"use strict";

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

/**
 * Module dependencies.
 */
// eslint-disable-next-line node/no-deprecated-api
var _require = require('url'),
    parse = _require.parse,
    format = _require.format,
    resolve = _require.resolve;

var Stream = require('stream');

var https = require('https');

var http = require('http');

var fs = require('fs');

var zlib = require('zlib');

var util = require('util');

var qs = require('qs');

var mime = require('mime');

var methods = require('methods');

var FormData = require('form-data');

var formidable = require('formidable');

var debug = require('debug')('superagent');

var CookieJar = require('cookiejar');

var semverGte = require('semver/functions/gte');

var safeStringify = require('fast-safe-stringify');

var utils = require('../utils');

var RequestBase = require('../request-base');

var _require2 = require('./unzip'),
    unzip = _require2.unzip;

var Response = require('./response');

var mixin = utils.mixin,
    hasOwn = utils.hasOwn;
var http2;
if (semverGte(process.version, 'v10.10.0')) http2 = require('./http2wrapper');

function request(method, url) {
  // callback
  if (typeof url === 'function') {
    return new exports.Request('GET', method).end(url);
  } // url first


  if (arguments.length === 1) {
    return new exports.Request('GET', method);
  }

  return new exports.Request(method, url);
}

module.exports = request;
exports = module.exports;
/**
 * Expose `Request`.
 */

exports.Request = Request;
/**
 * Expose the agent function
 */

exports.agent = require('./agent');
/**
 * Noop.
 */

function noop() {}
/**
 * Expose `Response`.
 */


exports.Response = Response;
/**
 * Define "form" mime type.
 */

mime.define({
  'application/x-www-form-urlencoded': ['form', 'urlencoded', 'form-data']
}, true);
/**
 * Protocol map.
 */

exports.protocols = {
  'http:': http,
  'https:': https,
  'http2:': http2
};
/**
 * Default serialization map.
 *
 *     superagent.serialize['application/xml'] = function(obj){
 *       return 'generated xml here';
 *     };
 *
 */

exports.serialize = {
  'application/x-www-form-urlencoded': qs.stringify,
  'application/json': safeStringify
};
/**
 * Default parsers.
 *
 *     superagent.parse['application/xml'] = function(res, fn){
 *       fn(null, res);
 *     };
 *
 */

exports.parse = require('./parsers');
/**
 * Default buffering map. Can be used to set certain
 * response types to buffer/not buffer.
 *
 *     superagent.buffer['application/xml'] = true;
 */

exports.buffer = {};
/**
 * Initialize internal header tracking properties on a request instance.
 *
 * @param {Object} req the instance
 * @api private
 */

function _initHeaders(request_) {
  request_._header = {// coerces header names to lowercase
  };
  request_.header = {// preserves header name case
  };
}
/**
 * Initialize a new `Request` with the given `method` and `url`.
 *
 * @param {String} method
 * @param {String|Object} url
 * @api public
 */


function Request(method, url) {
  Stream.call(this);
  if (typeof url !== 'string') url = format(url);
  this._enableHttp2 = Boolean(process.env.HTTP2_TEST); // internal only

  this._agent = false;
  this._formData = null;
  this.method = method;
  this.url = url;

  _initHeaders(this);

  this.writable = true;
  this._redirects = 0;
  this.redirects(method === 'HEAD' ? 0 : 5);
  this.cookies = '';
  this.qs = {};
  this._query = [];
  this.qsRaw = this._query; // Unused, for backwards compatibility only

  this._redirectList = [];
  this._streamRequest = false;
  this._lookup = undefined;
  this.once('end', this.clearTimeout.bind(this));
}
/**
 * Inherit from `Stream` (which inherits from `EventEmitter`).
 * Mixin `RequestBase`.
 */


util.inherits(Request, Stream);
mixin(Request.prototype, RequestBase.prototype);
/**
 * Enable or Disable http2.
 *
 * Enable http2.
 *
 * ``` js
 * request.get('http://localhost/')
 *   .http2()
 *   .end(callback);
 *
 * request.get('http://localhost/')
 *   .http2(true)
 *   .end(callback);
 * ```
 *
 * Disable http2.
 *
 * ``` js
 * request = request.http2();
 * request.get('http://localhost/')
 *   .http2(false)
 *   .end(callback);
 * ```
 *
 * @param {Boolean} enable
 * @return {Request} for chaining
 * @api public
 */

Request.prototype.http2 = function (bool) {
  if (exports.protocols['http2:'] === undefined) {
    throw new Error('superagent: this version of Node.js does not support http2');
  }

  this._enableHttp2 = bool === undefined ? true : bool;
  return this;
};
/**
 * Queue the given `file` as an attachment to the specified `field`,
 * with optional `options` (or filename).
 *
 * ``` js
 * request.post('http://localhost/upload')
 *   .attach('field', Buffer.from('<b>Hello world</b>'), 'hello.html')
 *   .end(callback);
 * ```
 *
 * A filename may also be used:
 *
 * ``` js
 * request.post('http://localhost/upload')
 *   .attach('files', 'image.jpg')
 *   .end(callback);
 * ```
 *
 * @param {String} field
 * @param {String|fs.ReadStream|Buffer} file
 * @param {String|Object} options
 * @return {Request} for chaining
 * @api public
 */


Request.prototype.attach = function (field, file, options) {
  var _this = this;

  if (file) {
    if (this._data) {
      throw new Error("superagent can't mix .send() and .attach()");
    }

    var o = options || {};

    if (typeof options === 'string') {
      o = {
        filename: options
      };
    }

    if (typeof file === 'string') {
      if (!o.filename) o.filename = file;
      debug('creating `fs.ReadStream` instance for file: %s', file);
      file = fs.createReadStream(file);
      file.on('error', function (error) {
        var formData = _this._getFormData();

        formData.emit('error', error);
      });
    } else if (!o.filename && file.path) {
      o.filename = file.path;
    }

    this._getFormData().append(field, file, o);
  }

  return this;
};

Request.prototype._getFormData = function () {
  var _this2 = this;

  if (!this._formData) {
    this._formData = new FormData();

    this._formData.on('error', function (error) {
      debug('FormData error', error);

      if (_this2.called) {
        // The request has already finished and the callback was called.
        // Silently ignore the error.
        return;
      }

      _this2.callback(error);

      _this2.abort();
    });
  }

  return this._formData;
};
/**
 * Gets/sets the `Agent` to use for this HTTP request. The default (if this
 * function is not called) is to opt out of connection pooling (`agent: false`).
 *
 * @param {http.Agent} agent
 * @return {http.Agent}
 * @api public
 */


Request.prototype.agent = function (agent) {
  if (arguments.length === 0) return this._agent;
  this._agent = agent;
  return this;
};
/**
 * Gets/sets the `lookup` function to use custom DNS resolver.
 *
 * @param {Function} lookup
 * @return {Function}
 * @api public
 */


Request.prototype.lookup = function (lookup) {
  if (arguments.length === 0) return this._lookup;
  this._lookup = lookup;
  return this;
};
/**
 * Set _Content-Type_ response header passed through `mime.getType()`.
 *
 * Examples:
 *
 *      request.post('/')
 *        .type('xml')
 *        .send(xmlstring)
 *        .end(callback);
 *
 *      request.post('/')
 *        .type('json')
 *        .send(jsonstring)
 *        .end(callback);
 *
 *      request.post('/')
 *        .type('application/json')
 *        .send(jsonstring)
 *        .end(callback);
 *
 * @param {String} type
 * @return {Request} for chaining
 * @api public
 */


Request.prototype.type = function (type) {
  return this.set('Content-Type', type.includes('/') ? type : mime.getType(type));
};
/**
 * Set _Accept_ response header passed through `mime.getType()`.
 *
 * Examples:
 *
 *      superagent.types.json = 'application/json';
 *
 *      request.get('/agent')
 *        .accept('json')
 *        .end(callback);
 *
 *      request.get('/agent')
 *        .accept('application/json')
 *        .end(callback);
 *
 * @param {String} accept
 * @return {Request} for chaining
 * @api public
 */


Request.prototype.accept = function (type) {
  return this.set('Accept', type.includes('/') ? type : mime.getType(type));
};
/**
 * Add query-string `val`.
 *
 * Examples:
 *
 *   request.get('/shoes')
 *     .query('size=10')
 *     .query({ color: 'blue' })
 *
 * @param {Object|String} val
 * @return {Request} for chaining
 * @api public
 */


Request.prototype.query = function (value) {
  if (typeof value === 'string') {
    this._query.push(value);
  } else {
    Object.assign(this.qs, value);
  }

  return this;
};
/**
 * Write raw `data` / `encoding` to the socket.
 *
 * @param {Buffer|String} data
 * @param {String} encoding
 * @return {Boolean}
 * @api public
 */


Request.prototype.write = function (data, encoding) {
  var request_ = this.request();

  if (!this._streamRequest) {
    this._streamRequest = true;
  }

  return request_.write(data, encoding);
};
/**
 * Pipe the request body to `stream`.
 *
 * @param {Stream} stream
 * @param {Object} options
 * @return {Stream}
 * @api public
 */


Request.prototype.pipe = function (stream, options) {
  this.piped = true; // HACK...

  this.buffer(false);
  this.end();
  return this._pipeContinue(stream, options);
};

Request.prototype._pipeContinue = function (stream, options) {
  var _this3 = this;

  this.req.once('response', function (res) {
    // redirect
    if (isRedirect(res.statusCode) && _this3._redirects++ !== _this3._maxRedirects) {
      return _this3._redirect(res) === _this3 ? _this3._pipeContinue(stream, options) : undefined;
    }

    _this3.res = res;

    _this3._emitResponse();

    if (_this3._aborted) return;

    if (_this3._shouldUnzip(res)) {
      var unzipObject = zlib.createUnzip();
      unzipObject.on('error', function (error) {
        if (error && error.code === 'Z_BUF_ERROR') {
          // unexpected end of file is ignored by browsers and curl
          stream.emit('end');
          return;
        }

        stream.emit('error', error);
      });
      res.pipe(unzipObject).pipe(stream, options);
    } else {
      res.pipe(stream, options);
    }

    res.once('end', function () {
      _this3.emit('end');
    });
  });
  return stream;
};
/**
 * Enable / disable buffering.
 *
 * @return {Boolean} [val]
 * @return {Request} for chaining
 * @api public
 */


Request.prototype.buffer = function (value) {
  this._buffer = value !== false;
  return this;
};
/**
 * Redirect to `url
 *
 * @param {IncomingMessage} res
 * @return {Request} for chaining
 * @api private
 */


Request.prototype._redirect = function (res) {
  var url = res.headers.location;

  if (!url) {
    return this.callback(new Error('No location header for redirect'), res);
  }

  debug('redirect %s -> %s', this.url, url); // location

  url = resolve(this.url, url); // ensure the response is being consumed
  // this is required for Node v0.10+

  res.resume();
  var headers = this.req.getHeaders ? this.req.getHeaders() : this.req._headers;
  var changesOrigin = parse(url).host !== parse(this.url).host; // implementation of 302 following defacto standard

  if (res.statusCode === 301 || res.statusCode === 302) {
    // strip Content-* related fields
    // in case of POST etc
    headers = utils.cleanHeader(headers, changesOrigin); // force GET

    this.method = this.method === 'HEAD' ? 'HEAD' : 'GET'; // clear data

    this._data = null;
  } // 303 is always GET


  if (res.statusCode === 303) {
    // strip Content-* related fields
    // in case of POST etc
    headers = utils.cleanHeader(headers, changesOrigin); // force method

    this.method = 'GET'; // clear data

    this._data = null;
  } // 307 preserves method
  // 308 preserves method


  delete headers.host;
  delete this.req;
  delete this._formData; // remove all add header except User-Agent

  _initHeaders(this); // redirect


  this._endCalled = false;
  this.url = url;
  this.qs = {};
  this._query.length = 0;
  this.set(headers);
  this.emit('redirect', res);

  this._redirectList.push(this.url);

  this.end(this._callback);
  return this;
};
/**
 * Set Authorization field value with `user` and `pass`.
 *
 * Examples:
 *
 *   .auth('tobi', 'learnboost')
 *   .auth('tobi:learnboost')
 *   .auth('tobi')
 *   .auth(accessToken, { type: 'bearer' })
 *
 * @param {String} user
 * @param {String} [pass]
 * @param {Object} [options] options with authorization type 'basic' or 'bearer' ('basic' is default)
 * @return {Request} for chaining
 * @api public
 */


Request.prototype.auth = function (user, pass, options) {
  if (arguments.length === 1) pass = '';

  if (_typeof(pass) === 'object' && pass !== null) {
    // pass is optional and can be replaced with options
    options = pass;
    pass = '';
  }

  if (!options) {
    options = {
      type: 'basic'
    };
  }

  var encoder = function encoder(string) {
    return Buffer.from(string).toString('base64');
  };

  return this._auth(user, pass, options, encoder);
};
/**
 * Set the certificate authority option for https request.
 *
 * @param {Buffer | Array} cert
 * @return {Request} for chaining
 * @api public
 */


Request.prototype.ca = function (cert) {
  this._ca = cert;
  return this;
};
/**
 * Set the client certificate key option for https request.
 *
 * @param {Buffer | String} cert
 * @return {Request} for chaining
 * @api public
 */


Request.prototype.key = function (cert) {
  this._key = cert;
  return this;
};
/**
 * Set the key, certificate, and CA certs of the client in PFX or PKCS12 format.
 *
 * @param {Buffer | String} cert
 * @return {Request} for chaining
 * @api public
 */


Request.prototype.pfx = function (cert) {
  if (_typeof(cert) === 'object' && !Buffer.isBuffer(cert)) {
    this._pfx = cert.pfx;
    this._passphrase = cert.passphrase;
  } else {
    this._pfx = cert;
  }

  return this;
};
/**
 * Set the client certificate option for https request.
 *
 * @param {Buffer | String} cert
 * @return {Request} for chaining
 * @api public
 */


Request.prototype.cert = function (cert) {
  this._cert = cert;
  return this;
};
/**
 * Do not reject expired or invalid TLS certs.
 * sets `rejectUnauthorized=true`. Be warned that this allows MITM attacks.
 *
 * @return {Request} for chaining
 * @api public
 */


Request.prototype.disableTLSCerts = function () {
  this._disableTLSCerts = true;
  return this;
};
/**
 * Return an http[s] request.
 *
 * @return {OutgoingMessage}
 * @api private
 */
// eslint-disable-next-line complexity


Request.prototype.request = function () {
  var _this4 = this;

  if (this.req) return this.req;
  var options = {};

  try {
    var query = qs.stringify(this.qs, {
      indices: false,
      strictNullHandling: true
    });

    if (query) {
      this.qs = {};

      this._query.push(query);
    }

    this._finalizeQueryString();
  } catch (err) {
    return this.emit('error', err);
  }

  var url = this.url;
  var retries = this._retries; // Capture backticks as-is from the final query string built above.
  // Note: this'll only find backticks entered in req.query(String)
  // calls, because qs.stringify unconditionally encodes backticks.

  var queryStringBackticks;

  if (url.includes('`')) {
    var queryStartIndex = url.indexOf('?');

    if (queryStartIndex !== -1) {
      var queryString = url.slice(queryStartIndex + 1);
      queryStringBackticks = queryString.match(/`|%60/g);
    }
  } // default to http://


  if (url.indexOf('http') !== 0) url = "http://".concat(url);
  url = parse(url); // See https://github.com/visionmedia/superagent/issues/1367

  if (queryStringBackticks) {
    var i = 0;
    url.query = url.query.replace(/%60/g, function () {
      return queryStringBackticks[i++];
    });
    url.search = "?".concat(url.query);
    url.path = url.pathname + url.search;
  } // support unix sockets


  if (/^https?\+unix:/.test(url.protocol) === true) {
    // get the protocol
    url.protocol = "".concat(url.protocol.split('+')[0], ":"); // get the socket, path

    var unixParts = url.path.match(/^([^/]+)(.+)$/);
    options.socketPath = unixParts[1].replace(/%2F/g, '/');
    url.path = unixParts[2];
  } // Override IP address of a hostname


  if (this._connectOverride) {
    var _url = url,
        hostname = _url.hostname;
    var match = hostname in this._connectOverride ? this._connectOverride[hostname] : this._connectOverride['*'];

    if (match) {
      // backup the real host
      if (!this._header.host) {
        this.set('host', url.host);
      }

      var newHost;
      var newPort;

      if (_typeof(match) === 'object') {
        newHost = match.host;
        newPort = match.port;
      } else {
        newHost = match;
        newPort = url.port;
      } // wrap [ipv6]


      url.host = /:/.test(newHost) ? "[".concat(newHost, "]") : newHost;

      if (newPort) {
        url.host += ":".concat(newPort);
        url.port = newPort;
      }

      url.hostname = newHost;
    }
  } // options


  options.method = this.method;
  options.port = url.port;
  options.path = url.path;
  options.host = url.hostname;
  options.ca = this._ca;
  options.key = this._key;
  options.pfx = this._pfx;
  options.cert = this._cert;
  options.passphrase = this._passphrase;
  options.agent = this._agent;
  options.lookup = this._lookup;
  options.rejectUnauthorized = typeof this._disableTLSCerts === 'boolean' ? !this._disableTLSCerts : process.env.NODE_TLS_REJECT_UNAUTHORIZED !== '0'; // Allows request.get('https://1.2.3.4/').set('Host', 'example.com')

  if (this._header.host) {
    options.servername = this._header.host.replace(/:\d+$/, '');
  }

  if (this._trustLocalhost && /^(?:localhost|127\.0\.0\.\d+|(0*:)+:0*1)$/.test(url.hostname)) {
    options.rejectUnauthorized = false;
  } // initiate request


  var module_ = this._enableHttp2 ? exports.protocols['http2:'].setProtocol(url.protocol) : exports.protocols[url.protocol]; // request

  this.req = module_.request(options);
  var req = this.req; // set tcp no delay

  req.setNoDelay(true);

  if (options.method !== 'HEAD') {
    req.setHeader('Accept-Encoding', 'gzip, deflate');
  }

  this.protocol = url.protocol;
  this.host = url.host; // expose events

  req.once('drain', function () {
    _this4.emit('drain');
  });
  req.on('error', function (error) {
    // flag abortion here for out timeouts
    // because node will emit a faux-error "socket hang up"
    // when request is aborted before a connection is made
    if (_this4._aborted) return; // if not the same, we are in the **old** (cancelled) request,
    // so need to continue (same as for above)

    if (_this4._retries !== retries) return; // if we've received a response then we don't want to let
    // an error in the request blow up the response

    if (_this4.response) return;

    _this4.callback(error);
  }); // auth

  if (url.auth) {
    var auth = url.auth.split(':');
    this.auth(auth[0], auth[1]);
  }

  if (this.username && this.password) {
    this.auth(this.username, this.password);
  }

  for (var key in this.header) {
    if (hasOwn(this.header, key)) req.setHeader(key, this.header[key]);
  } // add cookies


  if (this.cookies) {
    if (hasOwn(this._header, 'cookie')) {
      // merge
      var temporaryJar = new CookieJar.CookieJar();
      temporaryJar.setCookies(this._header.cookie.split(';'));
      temporaryJar.setCookies(this.cookies.split(';'));
      req.setHeader('Cookie', temporaryJar.getCookies(CookieJar.CookieAccessInfo.All).toValueString());
    } else {
      req.setHeader('Cookie', this.cookies);
    }
  }

  return req;
};
/**
 * Invoke the callback with `err` and `res`
 * and handle arity check.
 *
 * @param {Error} err
 * @param {Response} res
 * @api private
 */


Request.prototype.callback = function (error, res) {
  if (this._shouldRetry(error, res)) {
    return this._retry();
  } // Avoid the error which is emitted from 'socket hang up' to cause the fn undefined error on JS runtime.


  var fn = this._callback || noop;
  this.clearTimeout();
  if (this.called) return console.warn('superagent: double callback bug');
  this.called = true;

  if (!error) {
    try {
      if (!this._isResponseOK(res)) {
        var message = 'Unsuccessful HTTP response';

        if (res) {
          message = http.STATUS_CODES[res.status] || message;
        }

        error = new Error(message);
        error.status = res ? res.status : undefined;
      }
    } catch (err) {
      error = err;
    }
  } // It's important that the callback is called outside try/catch
  // to avoid double callback


  if (!error) {
    return fn(null, res);
  }

  error.response = res;
  if (this._maxRetries) error.retries = this._retries - 1; // only emit error event if there is a listener
  // otherwise we assume the callback to `.end()` will get the error

  if (error && this.listeners('error').length > 0) {
    this.emit('error', error);
  }

  fn(error, res);
};
/**
 * Check if `obj` is a host object,
 *
 * @param {Object} obj host object
 * @return {Boolean} is a host object
 * @api private
 */


Request.prototype._isHost = function (object) {
  return Buffer.isBuffer(object) || object instanceof Stream || object instanceof FormData;
};
/**
 * Initiate request, invoking callback `fn(err, res)`
 * with an instanceof `Response`.
 *
 * @param {Function} fn
 * @return {Request} for chaining
 * @api public
 */


Request.prototype._emitResponse = function (body, files) {
  var response = new Response(this);
  this.response = response;
  response.redirects = this._redirectList;

  if (undefined !== body) {
    response.body = body;
  }

  response.files = files;

  if (this._endCalled) {
    response.pipe = function () {
      throw new Error("end() has already been called, so it's too late to start piping");
    };
  }

  this.emit('response', response);
  return response;
};

Request.prototype.end = function (fn) {
  this.request();
  debug('%s %s', this.method, this.url);

  if (this._endCalled) {
    throw new Error('.end() was called twice. This is not supported in superagent');
  }

  this._endCalled = true; // store callback

  this._callback = fn || noop;

  this._end();
};

Request.prototype._end = function () {
  var _this5 = this;

  if (this._aborted) return this.callback(new Error('The request has been aborted even before .end() was called'));
  var data = this._data;
  var req = this.req;
  var method = this.method;

  this._setTimeouts(); // body


  if (method !== 'HEAD' && !req._headerSent) {
    // serialize stuff
    if (typeof data !== 'string') {
      var contentType = req.getHeader('Content-Type'); // Parse out just the content type from the header (ignore the charset)

      if (contentType) contentType = contentType.split(';')[0];
      var serialize = this._serializer || exports.serialize[contentType];

      if (!serialize && isJSON(contentType)) {
        serialize = exports.serialize['application/json'];
      }

      if (serialize) data = serialize(data);
    } // content-length


    if (data && !req.getHeader('Content-Length')) {
      req.setHeader('Content-Length', Buffer.isBuffer(data) ? data.length : Buffer.byteLength(data));
    }
  } // response
  // eslint-disable-next-line complexity


  req.once('response', function (res) {
    debug('%s %s -> %s', _this5.method, _this5.url, res.statusCode);

    if (_this5._responseTimeoutTimer) {
      clearTimeout(_this5._responseTimeoutTimer);
    }

    if (_this5.piped) {
      return;
    }

    var max = _this5._maxRedirects;
    var mime = utils.type(res.headers['content-type'] || '') || 'text/plain';
    var type = mime.split('/')[0];
    if (type) type = type.toLowerCase().trim();
    var multipart = type === 'multipart';
    var redirect = isRedirect(res.statusCode);
    var responseType = _this5._responseType;
    _this5.res = res; // redirect

    if (redirect && _this5._redirects++ !== max) {
      return _this5._redirect(res);
    }

    if (_this5.method === 'HEAD') {
      _this5.emit('end');

      _this5.callback(null, _this5._emitResponse());

      return;
    } // zlib support


    if (_this5._shouldUnzip(res)) {
      unzip(req, res);
    }

    var buffer = _this5._buffer;

    if (buffer === undefined && mime in exports.buffer) {
      buffer = Boolean(exports.buffer[mime]);
    }

    var parser = _this5._parser;

    if (undefined === buffer && parser) {
      console.warn("A custom superagent parser has been set, but buffering strategy for the parser hasn't been configured. Call `req.buffer(true or false)` or set `superagent.buffer[mime] = true or false`");
      buffer = true;
    }

    if (!parser) {
      if (responseType) {
        parser = exports.parse.image; // It's actually a generic Buffer

        buffer = true;
      } else if (multipart) {
        var form = formidable();
        parser = form.parse.bind(form);
        buffer = true;
      } else if (isImageOrVideo(mime)) {
        parser = exports.parse.image;
        buffer = true; // For backwards-compatibility buffering default is ad-hoc MIME-dependent
      } else if (exports.parse[mime]) {
        parser = exports.parse[mime];
      } else if (type === 'text') {
        parser = exports.parse.text;
        buffer = buffer !== false; // everyone wants their own white-labeled json
      } else if (isJSON(mime)) {
        parser = exports.parse['application/json'];
        buffer = buffer !== false;
      } else if (buffer) {
        parser = exports.parse.text;
      } else if (undefined === buffer) {
        parser = exports.parse.image; // It's actually a generic Buffer

        buffer = true;
      }
    } // by default only buffer text/*, json and messed up thing from hell


    if (undefined === buffer && isText(mime) || isJSON(mime)) {
      buffer = true;
    }

    _this5._resBuffered = buffer;
    var parserHandlesEnd = false;

    if (buffer) {
      // Protectiona against zip bombs and other nuisance
      var responseBytesLeft = _this5._maxResponseSize || 200000000;
      res.on('data', function (buf) {
        responseBytesLeft -= buf.byteLength || buf.length > 0 ? buf.length : 0;

        if (responseBytesLeft < 0) {
          // This will propagate through error event
          var error = new Error('Maximum response size reached');
          error.code = 'ETOOLARGE'; // Parsers aren't required to observe error event,
          // so would incorrectly report success

          parserHandlesEnd = false; // Will not emit error event

          res.destroy(error); // so we do callback now

          _this5.callback(error, null);
        }
      });
    }

    if (parser) {
      try {
        // Unbuffered parsers are supposed to emit response early,
        // which is weird BTW, because response.body won't be there.
        parserHandlesEnd = buffer;
        parser(res, function (error, object, files) {
          if (_this5.timedout) {
            // Timeout has already handled all callbacks
            return;
          } // Intentional (non-timeout) abort is supposed to preserve partial response,
          // even if it doesn't parse.


          if (error && !_this5._aborted) {
            return _this5.callback(error);
          }

          if (parserHandlesEnd) {
            _this5.emit('end');

            _this5.callback(null, _this5._emitResponse(object, files));
          }
        });
      } catch (err) {
        _this5.callback(err);

        return;
      }
    }

    _this5.res = res; // unbuffered

    if (!buffer) {
      debug('unbuffered %s %s', _this5.method, _this5.url);

      _this5.callback(null, _this5._emitResponse());

      if (multipart) return; // allow multipart to handle end event

      res.once('end', function () {
        debug('end %s %s', _this5.method, _this5.url);

        _this5.emit('end');
      });
      return;
    } // terminating events


    res.once('error', function (error) {
      parserHandlesEnd = false;

      _this5.callback(error, null);
    });
    if (!parserHandlesEnd) res.once('end', function () {
      debug('end %s %s', _this5.method, _this5.url); // TODO: unless buffering emit earlier to stream

      _this5.emit('end');

      _this5.callback(null, _this5._emitResponse());
    });
  });
  this.emit('request', this);

  var getProgressMonitor = function getProgressMonitor() {
    var lengthComputable = true;
    var total = req.getHeader('Content-Length');
    var loaded = 0;
    var progress = new Stream.Transform();

    progress._transform = function (chunk, encoding, callback) {
      loaded += chunk.length;

      _this5.emit('progress', {
        direction: 'upload',
        lengthComputable: lengthComputable,
        loaded: loaded,
        total: total
      });

      callback(null, chunk);
    };

    return progress;
  };

  var bufferToChunks = function bufferToChunks(buffer) {
    var chunkSize = 16 * 1024; // default highWaterMark value

    var chunking = new Stream.Readable();
    var totalLength = buffer.length;
    var remainder = totalLength % chunkSize;
    var cutoff = totalLength - remainder;

    for (var i = 0; i < cutoff; i += chunkSize) {
      var chunk = buffer.slice(i, i + chunkSize);
      chunking.push(chunk);
    }

    if (remainder > 0) {
      var remainderBuffer = buffer.slice(-remainder);
      chunking.push(remainderBuffer);
    }

    chunking.push(null); // no more data

    return chunking;
  }; // if a FormData instance got created, then we send that as the request body


  var formData = this._formData;

  if (formData) {
    // set headers
    var headers = formData.getHeaders();

    for (var i in headers) {
      if (hasOwn(headers, i)) {
        debug('setting FormData header: "%s: %s"', i, headers[i]);
        req.setHeader(i, headers[i]);
      }
    } // attempt to get "Content-Length" header


    formData.getLength(function (error, length) {
      // TODO: Add chunked encoding when no length (if err)
      if (error) debug('formData.getLength had error', error, length);
      debug('got FormData Content-Length: %s', length);

      if (typeof length === 'number') {
        req.setHeader('Content-Length', length);
      }

      formData.pipe(getProgressMonitor()).pipe(req);
    });
  } else if (Buffer.isBuffer(data)) {
    bufferToChunks(data).pipe(getProgressMonitor()).pipe(req);
  } else {
    req.end(data);
  }
}; // Check whether response has a non-0-sized gzip-encoded body


Request.prototype._shouldUnzip = function (res) {
  if (res.statusCode === 204 || res.statusCode === 304) {
    // These aren't supposed to have any body
    return false;
  } // header content is a string, and distinction between 0 and no information is crucial


  if (res.headers['content-length'] === '0') {
    // We know that the body is empty (unfortunately, this check does not cover chunked encoding)
    return false;
  } // console.log(res);


  return /^\s*(?:deflate|gzip)\s*$/.test(res.headers['content-encoding']);
};
/**
 * Overrides DNS for selected hostnames. Takes object mapping hostnames to IP addresses.
 *
 * When making a request to a URL with a hostname exactly matching a key in the object,
 * use the given IP address to connect, instead of using DNS to resolve the hostname.
 *
 * A special host `*` matches every hostname (keep redirects in mind!)
 *
 *      request.connect({
 *        'test.example.com': '127.0.0.1',
 *        'ipv6.example.com': '::1',
 *      })
 */


Request.prototype.connect = function (connectOverride) {
  if (typeof connectOverride === 'string') {
    this._connectOverride = {
      '*': connectOverride
    };
  } else if (_typeof(connectOverride) === 'object') {
    this._connectOverride = connectOverride;
  } else {
    this._connectOverride = undefined;
  }

  return this;
};

Request.prototype.trustLocalhost = function (toggle) {
  this._trustLocalhost = toggle === undefined ? true : toggle;
  return this;
}; // generate HTTP verb methods


if (!methods.includes('del')) {
  // create a copy so we don't cause conflicts with
  // other packages using the methods package and
  // npm 3.x
  methods = _toConsumableArray(methods);
  methods.push('del');
}

var _iterator = _createForOfIteratorHelper(methods),
    _step;

try {
  var _loop = function _loop() {
    var method = _step.value;
    var name = method;
    method = method === 'del' ? 'delete' : method;
    method = method.toUpperCase();

    request[name] = function (url, data, fn) {
      var request_ = request(method, url);

      if (typeof data === 'function') {
        fn = data;
        data = null;
      }

      if (data) {
        if (method === 'GET' || method === 'HEAD') {
          request_.query(data);
        } else {
          request_.send(data);
        }
      }

      if (fn) request_.end(fn);
      return request_;
    };
  };

  for (_iterator.s(); !(_step = _iterator.n()).done;) {
    _loop();
  }
  /**
   * Check if `mime` is text and should be buffered.
   *
   * @param {String} mime
   * @return {Boolean}
   * @api public
   */

} catch (err) {
  _iterator.e(err);
} finally {
  _iterator.f();
}

function isText(mime) {
  var parts = mime.split('/');
  var type = parts[0];
  if (type) type = type.toLowerCase().trim();
  var subtype = parts[1];
  if (subtype) subtype = subtype.toLowerCase().trim();
  return type === 'text' || subtype === 'x-www-form-urlencoded';
}

function isImageOrVideo(mime) {
  var type = mime.split('/')[0];
  if (type) type = type.toLowerCase().trim();
  return type === 'image' || type === 'video';
}
/**
 * Check if `mime` is json or has +json structured syntax suffix.
 *
 * @param {String} mime
 * @return {Boolean}
 * @api private
 */


function isJSON(mime) {
  // should match /json or +json
  // but not /json-seq
  return /[/+]json($|[^-\w])/i.test(mime);
}
/**
 * Check if we should follow the redirect `code`.
 *
 * @param {Number} code
 * @return {Boolean}
 * @api private
 */


function isRedirect(code) {
  return [301, 302, 303, 305, 307, 308].includes(code);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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