## mj-carousel

<p style="text-align: center;" >
  <img src="https://i.imgur.com/wHqIzgd.gif" alt="desktop" />
</p>

`mj-carousel` displays a gallery of images or "carousel". Readers can interact by hovering and clicking on thumbnails depending on the email client they use.

This component enables you to set the styles of the carousel elements.

```xml
<mjml>
  <mj-body>
    <mj-section>
      <mj-column>
        <mj-carousel>
          <mj-carousel-image src="https://www.mailjet.com/wp-content/uploads/2016/11/ecommerce-guide.jpg" />
          <mj-carousel-image src="https://www.mailjet.com/wp-content/uploads/2016/09/3@1x.png" />
          <mj-carousel-image src="https://www.mailjet.com/wp-content/uploads/2016/09/1@1x.png" />
        </mj-carousel>
      </mj-column>
    </mj-section>
  </mj-body>
</mjml>
```

<p style="text-align: center;" >
  <a href="https://mjml.io/try-it-live/components/carousel">
    <img width="100px" src="https://mjml.io/assets/img/svg/TRYITLIVE.svg" alt="sexy" />
  </a>
</p>

<aside class="notice">
  `mj-carousel-image` is an "ending tag", which means it can contain HTML code which will be left as it is, so it can contain HTML tags with attributes, but it cannot contain other MJML components. More information about ending tags <a href="#ending-tags">in this section</a>.
</aside>


attribute | unit | description | default value
----------|------|-------------|---------------
align | string | horizontal alignment | center
container-background-color | string | column background color | none
border-radius | px | border radius | n/a
css-class | string | class name, added to the root HTML element created | n/a
icon-width | px | width of the icons on left and right of the main image | 44px
left-icon | url | icon on the left of the main image | https://i.imgur.com/xTh3hln.png
right-icon | url | icon on the right of the main image | https://i.imgur.com/os7o9kz.png
tb-border | css border format | border of the thumbnails | none
tb-border-radius | px | border-radius of the thumbnails | none
tb-hover-border-color | string | css border color of the hovered thumbnail | none
tb-selected-border-color | string | css border color of the selected thumbnail | none
tb-width | px | thumbnail width | null
thumbnails | String | display or not the thumbnails (visible | hidden)

### mj-carousel-image

This component enables you to add and style the images in the carousel.

attribute | unit | description | default value
----------|------|-------------|---------------
alt | string | image description | n/a
css-class | string | class name, added to the root HTML element created | n/a
href | url | link to redirect to on click | n/a
rel | string | specify the rel attribute | n/a
src | url | image source | n/a
target | string | link target on click | \_blank
thumbnails-src | url | image source to have a thumbnail different than the image it's linked to | null
title | string | tooltip & accessibility | n/a
