"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __esm = (fn, res) => function __init() {
  return fn && (res = (0, fn[__getOwnPropNames(fn)[0]])(fn = 0)), res;
};
var __commonJS = (cb, mod2) => function __require() {
  return mod2 || (0, cb[__getOwnPropNames(cb)[0]])((mod2 = { exports: {} }).exports, mod2), mod2.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod2, isNodeMode, target) => (target = mod2 != null ? __create(__getProtoOf(mod2)) : {}, __copyProps(
  isNodeMode || !mod2 || !mod2.__esModule ? __defProp(target, "default", { value: mod2, enumerable: true }) : target,
  mod2
));
var __toCommonJS = (mod2) => __copyProps(__defProp({}, "__esModule", { value: true }), mod2);

// ../../node_modules/.pnpm/ms@2.1.2/node_modules/ms/index.js
var require_ms = __commonJS({
  "../../node_modules/.pnpm/ms@2.1.2/node_modules/ms/index.js"(exports, module2) {
    var s = 1e3;
    var m = s * 60;
    var h2 = m * 60;
    var d2 = h2 * 24;
    var w2 = d2 * 7;
    var y2 = d2 * 365.25;
    module2.exports = function(val, options2) {
      options2 = options2 || {};
      var type = typeof val;
      if (type === "string" && val.length > 0) {
        return parse(val);
      } else if (type === "number" && isFinite(val)) {
        return options2.long ? fmtLong(val) : fmtShort(val);
      }
      throw new Error(
        "val is not a non-empty string or a valid number. val=" + JSON.stringify(val)
      );
    };
    function parse(str) {
      str = String(str);
      if (str.length > 100) {
        return;
      }
      var match = /^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(
        str
      );
      if (!match) {
        return;
      }
      var n2 = parseFloat(match[1]);
      var type = (match[2] || "ms").toLowerCase();
      switch (type) {
        case "years":
        case "year":
        case "yrs":
        case "yr":
        case "y":
          return n2 * y2;
        case "weeks":
        case "week":
        case "w":
          return n2 * w2;
        case "days":
        case "day":
        case "d":
          return n2 * d2;
        case "hours":
        case "hour":
        case "hrs":
        case "hr":
        case "h":
          return n2 * h2;
        case "minutes":
        case "minute":
        case "mins":
        case "min":
        case "m":
          return n2 * m;
        case "seconds":
        case "second":
        case "secs":
        case "sec":
        case "s":
          return n2 * s;
        case "milliseconds":
        case "millisecond":
        case "msecs":
        case "msec":
        case "ms":
          return n2;
        default:
          return void 0;
      }
    }
    __name(parse, "parse");
    function fmtShort(ms) {
      var msAbs = Math.abs(ms);
      if (msAbs >= d2) {
        return Math.round(ms / d2) + "d";
      }
      if (msAbs >= h2) {
        return Math.round(ms / h2) + "h";
      }
      if (msAbs >= m) {
        return Math.round(ms / m) + "m";
      }
      if (msAbs >= s) {
        return Math.round(ms / s) + "s";
      }
      return ms + "ms";
    }
    __name(fmtShort, "fmtShort");
    function fmtLong(ms) {
      var msAbs = Math.abs(ms);
      if (msAbs >= d2) {
        return plural(ms, msAbs, d2, "day");
      }
      if (msAbs >= h2) {
        return plural(ms, msAbs, h2, "hour");
      }
      if (msAbs >= m) {
        return plural(ms, msAbs, m, "minute");
      }
      if (msAbs >= s) {
        return plural(ms, msAbs, s, "second");
      }
      return ms + " ms";
    }
    __name(fmtLong, "fmtLong");
    function plural(ms, msAbs, n2, name) {
      var isPlural = msAbs >= n2 * 1.5;
      return Math.round(ms / n2) + " " + name + (isPlural ? "s" : "");
    }
    __name(plural, "plural");
  }
});

// ../../node_modules/.pnpm/debug@4.3.4/node_modules/debug/src/common.js
var require_common = __commonJS({
  "../../node_modules/.pnpm/debug@4.3.4/node_modules/debug/src/common.js"(exports, module2) {
    function setup(env) {
      createDebug.debug = createDebug;
      createDebug.default = createDebug;
      createDebug.coerce = coerce;
      createDebug.disable = disable;
      createDebug.enable = enable;
      createDebug.enabled = enabled;
      createDebug.humanize = require_ms();
      createDebug.destroy = destroy;
      Object.keys(env).forEach((key) => {
        createDebug[key] = env[key];
      });
      createDebug.names = [];
      createDebug.skips = [];
      createDebug.formatters = {};
      function selectColor(namespace) {
        let hash = 0;
        for (let i = 0; i < namespace.length; i++) {
          hash = (hash << 5) - hash + namespace.charCodeAt(i);
          hash |= 0;
        }
        return createDebug.colors[Math.abs(hash) % createDebug.colors.length];
      }
      __name(selectColor, "selectColor");
      createDebug.selectColor = selectColor;
      function createDebug(namespace) {
        let prevTime;
        let enableOverride = null;
        let namespacesCache;
        let enabledCache;
        function debug9(...args) {
          if (!debug9.enabled) {
            return;
          }
          const self = debug9;
          const curr = Number(new Date());
          const ms = curr - (prevTime || curr);
          self.diff = ms;
          self.prev = prevTime;
          self.curr = curr;
          prevTime = curr;
          args[0] = createDebug.coerce(args[0]);
          if (typeof args[0] !== "string") {
            args.unshift("%O");
          }
          let index = 0;
          args[0] = args[0].replace(/%([a-zA-Z%])/g, (match, format) => {
            if (match === "%%") {
              return "%";
            }
            index++;
            const formatter = createDebug.formatters[format];
            if (typeof formatter === "function") {
              const val = args[index];
              match = formatter.call(self, val);
              args.splice(index, 1);
              index--;
            }
            return match;
          });
          createDebug.formatArgs.call(self, args);
          const logFn = self.log || createDebug.log;
          logFn.apply(self, args);
        }
        __name(debug9, "debug");
        debug9.namespace = namespace;
        debug9.useColors = createDebug.useColors();
        debug9.color = createDebug.selectColor(namespace);
        debug9.extend = extend;
        debug9.destroy = createDebug.destroy;
        Object.defineProperty(debug9, "enabled", {
          enumerable: true,
          configurable: false,
          get: () => {
            if (enableOverride !== null) {
              return enableOverride;
            }
            if (namespacesCache !== createDebug.namespaces) {
              namespacesCache = createDebug.namespaces;
              enabledCache = createDebug.enabled(namespace);
            }
            return enabledCache;
          },
          set: (v) => {
            enableOverride = v;
          }
        });
        if (typeof createDebug.init === "function") {
          createDebug.init(debug9);
        }
        return debug9;
      }
      __name(createDebug, "createDebug");
      function extend(namespace, delimiter) {
        const newDebug = createDebug(this.namespace + (typeof delimiter === "undefined" ? ":" : delimiter) + namespace);
        newDebug.log = this.log;
        return newDebug;
      }
      __name(extend, "extend");
      function enable(namespaces) {
        createDebug.save(namespaces);
        createDebug.namespaces = namespaces;
        createDebug.names = [];
        createDebug.skips = [];
        let i;
        const split = (typeof namespaces === "string" ? namespaces : "").split(/[\s,]+/);
        const len = split.length;
        for (i = 0; i < len; i++) {
          if (!split[i]) {
            continue;
          }
          namespaces = split[i].replace(/\*/g, ".*?");
          if (namespaces[0] === "-") {
            createDebug.skips.push(new RegExp("^" + namespaces.slice(1) + "$"));
          } else {
            createDebug.names.push(new RegExp("^" + namespaces + "$"));
          }
        }
      }
      __name(enable, "enable");
      function disable() {
        const namespaces = [
          ...createDebug.names.map(toNamespace),
          ...createDebug.skips.map(toNamespace).map((namespace) => "-" + namespace)
        ].join(",");
        createDebug.enable("");
        return namespaces;
      }
      __name(disable, "disable");
      function enabled(name) {
        if (name[name.length - 1] === "*") {
          return true;
        }
        let i;
        let len;
        for (i = 0, len = createDebug.skips.length; i < len; i++) {
          if (createDebug.skips[i].test(name)) {
            return false;
          }
        }
        for (i = 0, len = createDebug.names.length; i < len; i++) {
          if (createDebug.names[i].test(name)) {
            return true;
          }
        }
        return false;
      }
      __name(enabled, "enabled");
      function toNamespace(regexp) {
        return regexp.toString().substring(2, regexp.toString().length - 2).replace(/\.\*\?$/, "*");
      }
      __name(toNamespace, "toNamespace");
      function coerce(val) {
        if (val instanceof Error) {
          return val.stack || val.message;
        }
        return val;
      }
      __name(coerce, "coerce");
      function destroy() {
        console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.");
      }
      __name(destroy, "destroy");
      createDebug.enable(createDebug.load());
      return createDebug;
    }
    __name(setup, "setup");
    module2.exports = setup;
  }
});

// ../../node_modules/.pnpm/debug@4.3.4/node_modules/debug/src/browser.js
var require_browser = __commonJS({
  "../../node_modules/.pnpm/debug@4.3.4/node_modules/debug/src/browser.js"(exports, module2) {
    exports.formatArgs = formatArgs;
    exports.save = save;
    exports.load = load;
    exports.useColors = useColors;
    exports.storage = localstorage();
    exports.destroy = (() => {
      let warned = false;
      return () => {
        if (!warned) {
          warned = true;
          console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.");
        }
      };
    })();
    exports.colors = [
      "#0000CC",
      "#0000FF",
      "#0033CC",
      "#0033FF",
      "#0066CC",
      "#0066FF",
      "#0099CC",
      "#0099FF",
      "#00CC00",
      "#00CC33",
      "#00CC66",
      "#00CC99",
      "#00CCCC",
      "#00CCFF",
      "#3300CC",
      "#3300FF",
      "#3333CC",
      "#3333FF",
      "#3366CC",
      "#3366FF",
      "#3399CC",
      "#3399FF",
      "#33CC00",
      "#33CC33",
      "#33CC66",
      "#33CC99",
      "#33CCCC",
      "#33CCFF",
      "#6600CC",
      "#6600FF",
      "#6633CC",
      "#6633FF",
      "#66CC00",
      "#66CC33",
      "#9900CC",
      "#9900FF",
      "#9933CC",
      "#9933FF",
      "#99CC00",
      "#99CC33",
      "#CC0000",
      "#CC0033",
      "#CC0066",
      "#CC0099",
      "#CC00CC",
      "#CC00FF",
      "#CC3300",
      "#CC3333",
      "#CC3366",
      "#CC3399",
      "#CC33CC",
      "#CC33FF",
      "#CC6600",
      "#CC6633",
      "#CC9900",
      "#CC9933",
      "#CCCC00",
      "#CCCC33",
      "#FF0000",
      "#FF0033",
      "#FF0066",
      "#FF0099",
      "#FF00CC",
      "#FF00FF",
      "#FF3300",
      "#FF3333",
      "#FF3366",
      "#FF3399",
      "#FF33CC",
      "#FF33FF",
      "#FF6600",
      "#FF6633",
      "#FF9900",
      "#FF9933",
      "#FFCC00",
      "#FFCC33"
    ];
    function useColors() {
      if (typeof window !== "undefined" && window.process && (window.process.type === "renderer" || window.process.__nwjs)) {
        return true;
      }
      if (typeof navigator !== "undefined" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)) {
        return false;
      }
      return typeof document !== "undefined" && document.documentElement && document.documentElement.style && document.documentElement.style.WebkitAppearance || typeof window !== "undefined" && window.console && (window.console.firebug || window.console.exception && window.console.table) || typeof navigator !== "undefined" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/) && parseInt(RegExp.$1, 10) >= 31 || typeof navigator !== "undefined" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/);
    }
    __name(useColors, "useColors");
    function formatArgs(args) {
      args[0] = (this.useColors ? "%c" : "") + this.namespace + (this.useColors ? " %c" : " ") + args[0] + (this.useColors ? "%c " : " ") + "+" + module2.exports.humanize(this.diff);
      if (!this.useColors) {
        return;
      }
      const c = "color: " + this.color;
      args.splice(1, 0, c, "color: inherit");
      let index = 0;
      let lastC = 0;
      args[0].replace(/%[a-zA-Z%]/g, (match) => {
        if (match === "%%") {
          return;
        }
        index++;
        if (match === "%c") {
          lastC = index;
        }
      });
      args.splice(lastC, 0, c);
    }
    __name(formatArgs, "formatArgs");
    exports.log = console.debug || console.log || (() => {
    });
    function save(namespaces) {
      try {
        if (namespaces) {
          exports.storage.setItem("debug", namespaces);
        } else {
          exports.storage.removeItem("debug");
        }
      } catch (error) {
      }
    }
    __name(save, "save");
    function load() {
      let r2;
      try {
        r2 = exports.storage.getItem("debug");
      } catch (error) {
      }
      if (!r2 && typeof process !== "undefined" && "env" in process) {
        r2 = process.env.DEBUG;
      }
      return r2;
    }
    __name(load, "load");
    function localstorage() {
      try {
        return localStorage;
      } catch (error) {
      }
    }
    __name(localstorage, "localstorage");
    module2.exports = require_common()(exports);
    var { formatters } = module2.exports;
    formatters.j = function(v) {
      try {
        return JSON.stringify(v);
      } catch (error) {
        return "[UnexpectedJSONParseError]: " + error.message;
      }
    };
  }
});

// ../../node_modules/.pnpm/has-flag@4.0.0/node_modules/has-flag/index.js
var require_has_flag = __commonJS({
  "../../node_modules/.pnpm/has-flag@4.0.0/node_modules/has-flag/index.js"(exports, module2) {
    "use strict";
    module2.exports = (flag, argv = process.argv) => {
      const prefix = flag.startsWith("-") ? "" : flag.length === 1 ? "-" : "--";
      const position = argv.indexOf(prefix + flag);
      const terminatorPosition = argv.indexOf("--");
      return position !== -1 && (terminatorPosition === -1 || position < terminatorPosition);
    };
  }
});

// ../../node_modules/.pnpm/supports-color@7.2.0/node_modules/supports-color/index.js
var require_supports_color = __commonJS({
  "../../node_modules/.pnpm/supports-color@7.2.0/node_modules/supports-color/index.js"(exports, module2) {
    "use strict";
    var os2 = require("os");
    var tty = require("tty");
    var hasFlag = require_has_flag();
    var { env } = process;
    var forceColor;
    if (hasFlag("no-color") || hasFlag("no-colors") || hasFlag("color=false") || hasFlag("color=never")) {
      forceColor = 0;
    } else if (hasFlag("color") || hasFlag("colors") || hasFlag("color=true") || hasFlag("color=always")) {
      forceColor = 1;
    }
    if ("FORCE_COLOR" in env) {
      if (env.FORCE_COLOR === "true") {
        forceColor = 1;
      } else if (env.FORCE_COLOR === "false") {
        forceColor = 0;
      } else {
        forceColor = env.FORCE_COLOR.length === 0 ? 1 : Math.min(parseInt(env.FORCE_COLOR, 10), 3);
      }
    }
    function translateLevel(level) {
      if (level === 0) {
        return false;
      }
      return {
        level,
        hasBasic: true,
        has256: level >= 2,
        has16m: level >= 3
      };
    }
    __name(translateLevel, "translateLevel");
    function supportsColor(haveStream, streamIsTTY) {
      if (forceColor === 0) {
        return 0;
      }
      if (hasFlag("color=16m") || hasFlag("color=full") || hasFlag("color=truecolor")) {
        return 3;
      }
      if (hasFlag("color=256")) {
        return 2;
      }
      if (haveStream && !streamIsTTY && forceColor === void 0) {
        return 0;
      }
      const min2 = forceColor || 0;
      if (env.TERM === "dumb") {
        return min2;
      }
      if (process.platform === "win32") {
        const osRelease = os2.release().split(".");
        if (Number(osRelease[0]) >= 10 && Number(osRelease[2]) >= 10586) {
          return Number(osRelease[2]) >= 14931 ? 3 : 2;
        }
        return 1;
      }
      if ("CI" in env) {
        if (["TRAVIS", "CIRCLECI", "APPVEYOR", "GITLAB_CI", "GITHUB_ACTIONS", "BUILDKITE"].some((sign2) => sign2 in env) || env.CI_NAME === "codeship") {
          return 1;
        }
        return min2;
      }
      if ("TEAMCITY_VERSION" in env) {
        return /^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.test(env.TEAMCITY_VERSION) ? 1 : 0;
      }
      if (env.COLORTERM === "truecolor") {
        return 3;
      }
      if ("TERM_PROGRAM" in env) {
        const version = parseInt((env.TERM_PROGRAM_VERSION || "").split(".")[0], 10);
        switch (env.TERM_PROGRAM) {
          case "iTerm.app":
            return version >= 3 ? 3 : 2;
          case "Apple_Terminal":
            return 2;
        }
      }
      if (/-256(color)?$/i.test(env.TERM)) {
        return 2;
      }
      if (/^screen|^xterm|^vt100|^vt220|^rxvt|color|ansi|cygwin|linux/i.test(env.TERM)) {
        return 1;
      }
      if ("COLORTERM" in env) {
        return 1;
      }
      return min2;
    }
    __name(supportsColor, "supportsColor");
    function getSupportLevel(stream2) {
      const level = supportsColor(stream2, stream2 && stream2.isTTY);
      return translateLevel(level);
    }
    __name(getSupportLevel, "getSupportLevel");
    module2.exports = {
      supportsColor: getSupportLevel,
      stdout: translateLevel(supportsColor(true, tty.isatty(1))),
      stderr: translateLevel(supportsColor(true, tty.isatty(2)))
    };
  }
});

// ../../node_modules/.pnpm/debug@4.3.4/node_modules/debug/src/node.js
var require_node = __commonJS({
  "../../node_modules/.pnpm/debug@4.3.4/node_modules/debug/src/node.js"(exports, module2) {
    var tty = require("tty");
    var util2 = require("util");
    exports.init = init;
    exports.log = log3;
    exports.formatArgs = formatArgs;
    exports.save = save;
    exports.load = load;
    exports.useColors = useColors;
    exports.destroy = util2.deprecate(
      () => {
      },
      "Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`."
    );
    exports.colors = [6, 2, 3, 4, 5, 1];
    try {
      const supportsColor = require_supports_color();
      if (supportsColor && (supportsColor.stderr || supportsColor).level >= 2) {
        exports.colors = [
          20,
          21,
          26,
          27,
          32,
          33,
          38,
          39,
          40,
          41,
          42,
          43,
          44,
          45,
          56,
          57,
          62,
          63,
          68,
          69,
          74,
          75,
          76,
          77,
          78,
          79,
          80,
          81,
          92,
          93,
          98,
          99,
          112,
          113,
          128,
          129,
          134,
          135,
          148,
          149,
          160,
          161,
          162,
          163,
          164,
          165,
          166,
          167,
          168,
          169,
          170,
          171,
          172,
          173,
          178,
          179,
          184,
          185,
          196,
          197,
          198,
          199,
          200,
          201,
          202,
          203,
          204,
          205,
          206,
          207,
          208,
          209,
          214,
          215,
          220,
          221
        ];
      }
    } catch (error) {
    }
    exports.inspectOpts = Object.keys(process.env).filter((key) => {
      return /^debug_/i.test(key);
    }).reduce((obj, key) => {
      const prop = key.substring(6).toLowerCase().replace(/_([a-z])/g, (_, k) => {
        return k.toUpperCase();
      });
      let val = process.env[key];
      if (/^(yes|on|true|enabled)$/i.test(val)) {
        val = true;
      } else if (/^(no|off|false|disabled)$/i.test(val)) {
        val = false;
      } else if (val === "null") {
        val = null;
      } else {
        val = Number(val);
      }
      obj[prop] = val;
      return obj;
    }, {});
    function useColors() {
      return "colors" in exports.inspectOpts ? Boolean(exports.inspectOpts.colors) : tty.isatty(process.stderr.fd);
    }
    __name(useColors, "useColors");
    function formatArgs(args) {
      const { namespace: name, useColors: useColors2 } = this;
      if (useColors2) {
        const c = this.color;
        const colorCode = "\x1B[3" + (c < 8 ? c : "8;5;" + c);
        const prefix = `  ${colorCode};1m${name} \x1B[0m`;
        args[0] = prefix + args[0].split("\n").join("\n" + prefix);
        args.push(colorCode + "m+" + module2.exports.humanize(this.diff) + "\x1B[0m");
      } else {
        args[0] = getDate() + name + " " + args[0];
      }
    }
    __name(formatArgs, "formatArgs");
    function getDate() {
      if (exports.inspectOpts.hideDate) {
        return "";
      }
      return new Date().toISOString() + " ";
    }
    __name(getDate, "getDate");
    function log3(...args) {
      return process.stderr.write(util2.format(...args) + "\n");
    }
    __name(log3, "log");
    function save(namespaces) {
      if (namespaces) {
        process.env.DEBUG = namespaces;
      } else {
        delete process.env.DEBUG;
      }
    }
    __name(save, "save");
    function load() {
      return process.env.DEBUG;
    }
    __name(load, "load");
    function init(debug9) {
      debug9.inspectOpts = {};
      const keys = Object.keys(exports.inspectOpts);
      for (let i = 0; i < keys.length; i++) {
        debug9.inspectOpts[keys[i]] = exports.inspectOpts[keys[i]];
      }
    }
    __name(init, "init");
    module2.exports = require_common()(exports);
    var { formatters } = module2.exports;
    formatters.o = function(v) {
      this.inspectOpts.colors = this.useColors;
      return util2.inspect(v, this.inspectOpts).split("\n").map((str) => str.trim()).join(" ");
    };
    formatters.O = function(v) {
      this.inspectOpts.colors = this.useColors;
      return util2.inspect(v, this.inspectOpts);
    };
  }
});

// ../../node_modules/.pnpm/debug@4.3.4/node_modules/debug/src/index.js
var require_src = __commonJS({
  "../../node_modules/.pnpm/debug@4.3.4/node_modules/debug/src/index.js"(exports, module2) {
    if (typeof process === "undefined" || process.type === "renderer" || process.browser === true || process.__nwjs) {
      module2.exports = require_browser();
    } else {
      module2.exports = require_node();
    }
  }
});

// ../../node_modules/.pnpm/@prisma+engines-version@4.11.0-57.8fde8fef4033376662cad983758335009d522acb/node_modules/@prisma/engines-version/package.json
var require_package = __commonJS({
  "../../node_modules/.pnpm/@prisma+engines-version@4.11.0-57.8fde8fef4033376662cad983758335009d522acb/node_modules/@prisma/engines-version/package.json"(exports, module2) {
    module2.exports = {
      name: "@prisma/engines-version",
      version: "4.11.0-57.8fde8fef4033376662cad983758335009d522acb",
      main: "index.js",
      types: "index.d.ts",
      license: "Apache-2.0",
      author: "Tim Suchanek <suchanek@prisma.io>",
      prisma: {
        enginesVersion: "8fde8fef4033376662cad983758335009d522acb"
      },
      repository: {
        type: "git",
        url: "https://github.com/prisma/engines-wrapper.git",
        directory: "packages/engines-version"
      },
      devDependencies: {
        "@types/node": "16.11.64",
        typescript: "4.8.4"
      },
      files: [
        "index.js",
        "index.d.ts"
      ],
      scripts: {
        build: "tsc -d"
      }
    };
  }
});

// ../../node_modules/.pnpm/@prisma+engines-version@4.11.0-57.8fde8fef4033376662cad983758335009d522acb/node_modules/@prisma/engines-version/index.js
var require_engines_version = __commonJS({
  "../../node_modules/.pnpm/@prisma+engines-version@4.11.0-57.8fde8fef4033376662cad983758335009d522acb/node_modules/@prisma/engines-version/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.enginesVersion = void 0;
    exports.enginesVersion = require_package().prisma.enginesVersion;
  }
});

// ../../node_modules/.pnpm/color-name@1.1.4/node_modules/color-name/index.js
var require_color_name = __commonJS({
  "../../node_modules/.pnpm/color-name@1.1.4/node_modules/color-name/index.js"(exports, module2) {
    "use strict";
    module2.exports = {
      "aliceblue": [240, 248, 255],
      "antiquewhite": [250, 235, 215],
      "aqua": [0, 255, 255],
      "aquamarine": [127, 255, 212],
      "azure": [240, 255, 255],
      "beige": [245, 245, 220],
      "bisque": [255, 228, 196],
      "black": [0, 0, 0],
      "blanchedalmond": [255, 235, 205],
      "blue": [0, 0, 255],
      "blueviolet": [138, 43, 226],
      "brown": [165, 42, 42],
      "burlywood": [222, 184, 135],
      "cadetblue": [95, 158, 160],
      "chartreuse": [127, 255, 0],
      "chocolate": [210, 105, 30],
      "coral": [255, 127, 80],
      "cornflowerblue": [100, 149, 237],
      "cornsilk": [255, 248, 220],
      "crimson": [220, 20, 60],
      "cyan": [0, 255, 255],
      "darkblue": [0, 0, 139],
      "darkcyan": [0, 139, 139],
      "darkgoldenrod": [184, 134, 11],
      "darkgray": [169, 169, 169],
      "darkgreen": [0, 100, 0],
      "darkgrey": [169, 169, 169],
      "darkkhaki": [189, 183, 107],
      "darkmagenta": [139, 0, 139],
      "darkolivegreen": [85, 107, 47],
      "darkorange": [255, 140, 0],
      "darkorchid": [153, 50, 204],
      "darkred": [139, 0, 0],
      "darksalmon": [233, 150, 122],
      "darkseagreen": [143, 188, 143],
      "darkslateblue": [72, 61, 139],
      "darkslategray": [47, 79, 79],
      "darkslategrey": [47, 79, 79],
      "darkturquoise": [0, 206, 209],
      "darkviolet": [148, 0, 211],
      "deeppink": [255, 20, 147],
      "deepskyblue": [0, 191, 255],
      "dimgray": [105, 105, 105],
      "dimgrey": [105, 105, 105],
      "dodgerblue": [30, 144, 255],
      "firebrick": [178, 34, 34],
      "floralwhite": [255, 250, 240],
      "forestgreen": [34, 139, 34],
      "fuchsia": [255, 0, 255],
      "gainsboro": [220, 220, 220],
      "ghostwhite": [248, 248, 255],
      "gold": [255, 215, 0],
      "goldenrod": [218, 165, 32],
      "gray": [128, 128, 128],
      "green": [0, 128, 0],
      "greenyellow": [173, 255, 47],
      "grey": [128, 128, 128],
      "honeydew": [240, 255, 240],
      "hotpink": [255, 105, 180],
      "indianred": [205, 92, 92],
      "indigo": [75, 0, 130],
      "ivory": [255, 255, 240],
      "khaki": [240, 230, 140],
      "lavender": [230, 230, 250],
      "lavenderblush": [255, 240, 245],
      "lawngreen": [124, 252, 0],
      "lemonchiffon": [255, 250, 205],
      "lightblue": [173, 216, 230],
      "lightcoral": [240, 128, 128],
      "lightcyan": [224, 255, 255],
      "lightgoldenrodyellow": [250, 250, 210],
      "lightgray": [211, 211, 211],
      "lightgreen": [144, 238, 144],
      "lightgrey": [211, 211, 211],
      "lightpink": [255, 182, 193],
      "lightsalmon": [255, 160, 122],
      "lightseagreen": [32, 178, 170],
      "lightskyblue": [135, 206, 250],
      "lightslategray": [119, 136, 153],
      "lightslategrey": [119, 136, 153],
      "lightsteelblue": [176, 196, 222],
      "lightyellow": [255, 255, 224],
      "lime": [0, 255, 0],
      "limegreen": [50, 205, 50],
      "linen": [250, 240, 230],
      "magenta": [255, 0, 255],
      "maroon": [128, 0, 0],
      "mediumaquamarine": [102, 205, 170],
      "mediumblue": [0, 0, 205],
      "mediumorchid": [186, 85, 211],
      "mediumpurple": [147, 112, 219],
      "mediumseagreen": [60, 179, 113],
      "mediumslateblue": [123, 104, 238],
      "mediumspringgreen": [0, 250, 154],
      "mediumturquoise": [72, 209, 204],
      "mediumvioletred": [199, 21, 133],
      "midnightblue": [25, 25, 112],
      "mintcream": [245, 255, 250],
      "mistyrose": [255, 228, 225],
      "moccasin": [255, 228, 181],
      "navajowhite": [255, 222, 173],
      "navy": [0, 0, 128],
      "oldlace": [253, 245, 230],
      "olive": [128, 128, 0],
      "olivedrab": [107, 142, 35],
      "orange": [255, 165, 0],
      "orangered": [255, 69, 0],
      "orchid": [218, 112, 214],
      "palegoldenrod": [238, 232, 170],
      "palegreen": [152, 251, 152],
      "paleturquoise": [175, 238, 238],
      "palevioletred": [219, 112, 147],
      "papayawhip": [255, 239, 213],
      "peachpuff": [255, 218, 185],
      "peru": [205, 133, 63],
      "pink": [255, 192, 203],
      "plum": [221, 160, 221],
      "powderblue": [176, 224, 230],
      "purple": [128, 0, 128],
      "rebeccapurple": [102, 51, 153],
      "red": [255, 0, 0],
      "rosybrown": [188, 143, 143],
      "royalblue": [65, 105, 225],
      "saddlebrown": [139, 69, 19],
      "salmon": [250, 128, 114],
      "sandybrown": [244, 164, 96],
      "seagreen": [46, 139, 87],
      "seashell": [255, 245, 238],
      "sienna": [160, 82, 45],
      "silver": [192, 192, 192],
      "skyblue": [135, 206, 235],
      "slateblue": [106, 90, 205],
      "slategray": [112, 128, 144],
      "slategrey": [112, 128, 144],
      "snow": [255, 250, 250],
      "springgreen": [0, 255, 127],
      "steelblue": [70, 130, 180],
      "tan": [210, 180, 140],
      "teal": [0, 128, 128],
      "thistle": [216, 191, 216],
      "tomato": [255, 99, 71],
      "turquoise": [64, 224, 208],
      "violet": [238, 130, 238],
      "wheat": [245, 222, 179],
      "white": [255, 255, 255],
      "whitesmoke": [245, 245, 245],
      "yellow": [255, 255, 0],
      "yellowgreen": [154, 205, 50]
    };
  }
});

// ../../node_modules/.pnpm/color-convert@2.0.1/node_modules/color-convert/conversions.js
var require_conversions = __commonJS({
  "../../node_modules/.pnpm/color-convert@2.0.1/node_modules/color-convert/conversions.js"(exports, module2) {
    var cssKeywords = require_color_name();
    var reverseKeywords = {};
    for (const key of Object.keys(cssKeywords)) {
      reverseKeywords[cssKeywords[key]] = key;
    }
    var convert = {
      rgb: { channels: 3, labels: "rgb" },
      hsl: { channels: 3, labels: "hsl" },
      hsv: { channels: 3, labels: "hsv" },
      hwb: { channels: 3, labels: "hwb" },
      cmyk: { channels: 4, labels: "cmyk" },
      xyz: { channels: 3, labels: "xyz" },
      lab: { channels: 3, labels: "lab" },
      lch: { channels: 3, labels: "lch" },
      hex: { channels: 1, labels: ["hex"] },
      keyword: { channels: 1, labels: ["keyword"] },
      ansi16: { channels: 1, labels: ["ansi16"] },
      ansi256: { channels: 1, labels: ["ansi256"] },
      hcg: { channels: 3, labels: ["h", "c", "g"] },
      apple: { channels: 3, labels: ["r16", "g16", "b16"] },
      gray: { channels: 1, labels: ["gray"] }
    };
    module2.exports = convert;
    for (const model of Object.keys(convert)) {
      if (!("channels" in convert[model])) {
        throw new Error("missing channels property: " + model);
      }
      if (!("labels" in convert[model])) {
        throw new Error("missing channel labels property: " + model);
      }
      if (convert[model].labels.length !== convert[model].channels) {
        throw new Error("channel and label counts mismatch: " + model);
      }
      const { channels, labels } = convert[model];
      delete convert[model].channels;
      delete convert[model].labels;
      Object.defineProperty(convert[model], "channels", { value: channels });
      Object.defineProperty(convert[model], "labels", { value: labels });
    }
    convert.rgb.hsl = function(rgb) {
      const r2 = rgb[0] / 255;
      const g2 = rgb[1] / 255;
      const b2 = rgb[2] / 255;
      const min2 = Math.min(r2, g2, b2);
      const max2 = Math.max(r2, g2, b2);
      const delta = max2 - min2;
      let h2;
      let s;
      if (max2 === min2) {
        h2 = 0;
      } else if (r2 === max2) {
        h2 = (g2 - b2) / delta;
      } else if (g2 === max2) {
        h2 = 2 + (b2 - r2) / delta;
      } else if (b2 === max2) {
        h2 = 4 + (r2 - g2) / delta;
      }
      h2 = Math.min(h2 * 60, 360);
      if (h2 < 0) {
        h2 += 360;
      }
      const l = (min2 + max2) / 2;
      if (max2 === min2) {
        s = 0;
      } else if (l <= 0.5) {
        s = delta / (max2 + min2);
      } else {
        s = delta / (2 - max2 - min2);
      }
      return [h2, s * 100, l * 100];
    };
    convert.rgb.hsv = function(rgb) {
      let rdif;
      let gdif;
      let bdif;
      let h2;
      let s;
      const r2 = rgb[0] / 255;
      const g2 = rgb[1] / 255;
      const b2 = rgb[2] / 255;
      const v = Math.max(r2, g2, b2);
      const diff = v - Math.min(r2, g2, b2);
      const diffc = /* @__PURE__ */ __name(function(c) {
        return (v - c) / 6 / diff + 1 / 2;
      }, "diffc");
      if (diff === 0) {
        h2 = 0;
        s = 0;
      } else {
        s = diff / v;
        rdif = diffc(r2);
        gdif = diffc(g2);
        bdif = diffc(b2);
        if (r2 === v) {
          h2 = bdif - gdif;
        } else if (g2 === v) {
          h2 = 1 / 3 + rdif - bdif;
        } else if (b2 === v) {
          h2 = 2 / 3 + gdif - rdif;
        }
        if (h2 < 0) {
          h2 += 1;
        } else if (h2 > 1) {
          h2 -= 1;
        }
      }
      return [
        h2 * 360,
        s * 100,
        v * 100
      ];
    };
    convert.rgb.hwb = function(rgb) {
      const r2 = rgb[0];
      const g2 = rgb[1];
      let b2 = rgb[2];
      const h2 = convert.rgb.hsl(rgb)[0];
      const w2 = 1 / 255 * Math.min(r2, Math.min(g2, b2));
      b2 = 1 - 1 / 255 * Math.max(r2, Math.max(g2, b2));
      return [h2, w2 * 100, b2 * 100];
    };
    convert.rgb.cmyk = function(rgb) {
      const r2 = rgb[0] / 255;
      const g2 = rgb[1] / 255;
      const b2 = rgb[2] / 255;
      const k = Math.min(1 - r2, 1 - g2, 1 - b2);
      const c = (1 - r2 - k) / (1 - k) || 0;
      const m = (1 - g2 - k) / (1 - k) || 0;
      const y2 = (1 - b2 - k) / (1 - k) || 0;
      return [c * 100, m * 100, y2 * 100, k * 100];
    };
    function comparativeDistance(x, y2) {
      return (x[0] - y2[0]) ** 2 + (x[1] - y2[1]) ** 2 + (x[2] - y2[2]) ** 2;
    }
    __name(comparativeDistance, "comparativeDistance");
    convert.rgb.keyword = function(rgb) {
      const reversed = reverseKeywords[rgb];
      if (reversed) {
        return reversed;
      }
      let currentClosestDistance = Infinity;
      let currentClosestKeyword;
      for (const keyword of Object.keys(cssKeywords)) {
        const value = cssKeywords[keyword];
        const distance = comparativeDistance(rgb, value);
        if (distance < currentClosestDistance) {
          currentClosestDistance = distance;
          currentClosestKeyword = keyword;
        }
      }
      return currentClosestKeyword;
    };
    convert.keyword.rgb = function(keyword) {
      return cssKeywords[keyword];
    };
    convert.rgb.xyz = function(rgb) {
      let r2 = rgb[0] / 255;
      let g2 = rgb[1] / 255;
      let b2 = rgb[2] / 255;
      r2 = r2 > 0.04045 ? ((r2 + 0.055) / 1.055) ** 2.4 : r2 / 12.92;
      g2 = g2 > 0.04045 ? ((g2 + 0.055) / 1.055) ** 2.4 : g2 / 12.92;
      b2 = b2 > 0.04045 ? ((b2 + 0.055) / 1.055) ** 2.4 : b2 / 12.92;
      const x = r2 * 0.4124 + g2 * 0.3576 + b2 * 0.1805;
      const y2 = r2 * 0.2126 + g2 * 0.7152 + b2 * 0.0722;
      const z = r2 * 0.0193 + g2 * 0.1192 + b2 * 0.9505;
      return [x * 100, y2 * 100, z * 100];
    };
    convert.rgb.lab = function(rgb) {
      const xyz = convert.rgb.xyz(rgb);
      let x = xyz[0];
      let y2 = xyz[1];
      let z = xyz[2];
      x /= 95.047;
      y2 /= 100;
      z /= 108.883;
      x = x > 8856e-6 ? x ** (1 / 3) : 7.787 * x + 16 / 116;
      y2 = y2 > 8856e-6 ? y2 ** (1 / 3) : 7.787 * y2 + 16 / 116;
      z = z > 8856e-6 ? z ** (1 / 3) : 7.787 * z + 16 / 116;
      const l = 116 * y2 - 16;
      const a = 500 * (x - y2);
      const b2 = 200 * (y2 - z);
      return [l, a, b2];
    };
    convert.hsl.rgb = function(hsl) {
      const h2 = hsl[0] / 360;
      const s = hsl[1] / 100;
      const l = hsl[2] / 100;
      let t22;
      let t3;
      let val;
      if (s === 0) {
        val = l * 255;
        return [val, val, val];
      }
      if (l < 0.5) {
        t22 = l * (1 + s);
      } else {
        t22 = l + s - l * s;
      }
      const t1 = 2 * l - t22;
      const rgb = [0, 0, 0];
      for (let i = 0; i < 3; i++) {
        t3 = h2 + 1 / 3 * -(i - 1);
        if (t3 < 0) {
          t3++;
        }
        if (t3 > 1) {
          t3--;
        }
        if (6 * t3 < 1) {
          val = t1 + (t22 - t1) * 6 * t3;
        } else if (2 * t3 < 1) {
          val = t22;
        } else if (3 * t3 < 2) {
          val = t1 + (t22 - t1) * (2 / 3 - t3) * 6;
        } else {
          val = t1;
        }
        rgb[i] = val * 255;
      }
      return rgb;
    };
    convert.hsl.hsv = function(hsl) {
      const h2 = hsl[0];
      let s = hsl[1] / 100;
      let l = hsl[2] / 100;
      let smin = s;
      const lmin = Math.max(l, 0.01);
      l *= 2;
      s *= l <= 1 ? l : 2 - l;
      smin *= lmin <= 1 ? lmin : 2 - lmin;
      const v = (l + s) / 2;
      const sv = l === 0 ? 2 * smin / (lmin + smin) : 2 * s / (l + s);
      return [h2, sv * 100, v * 100];
    };
    convert.hsv.rgb = function(hsv) {
      const h2 = hsv[0] / 60;
      const s = hsv[1] / 100;
      let v = hsv[2] / 100;
      const hi = Math.floor(h2) % 6;
      const f = h2 - Math.floor(h2);
      const p2 = 255 * v * (1 - s);
      const q = 255 * v * (1 - s * f);
      const t3 = 255 * v * (1 - s * (1 - f));
      v *= 255;
      switch (hi) {
        case 0:
          return [v, t3, p2];
        case 1:
          return [q, v, p2];
        case 2:
          return [p2, v, t3];
        case 3:
          return [p2, q, v];
        case 4:
          return [t3, p2, v];
        case 5:
          return [v, p2, q];
      }
    };
    convert.hsv.hsl = function(hsv) {
      const h2 = hsv[0];
      const s = hsv[1] / 100;
      const v = hsv[2] / 100;
      const vmin = Math.max(v, 0.01);
      let sl;
      let l;
      l = (2 - s) * v;
      const lmin = (2 - s) * vmin;
      sl = s * vmin;
      sl /= lmin <= 1 ? lmin : 2 - lmin;
      sl = sl || 0;
      l /= 2;
      return [h2, sl * 100, l * 100];
    };
    convert.hwb.rgb = function(hwb) {
      const h2 = hwb[0] / 360;
      let wh = hwb[1] / 100;
      let bl = hwb[2] / 100;
      const ratio = wh + bl;
      let f;
      if (ratio > 1) {
        wh /= ratio;
        bl /= ratio;
      }
      const i = Math.floor(6 * h2);
      const v = 1 - bl;
      f = 6 * h2 - i;
      if ((i & 1) !== 0) {
        f = 1 - f;
      }
      const n2 = wh + f * (v - wh);
      let r2;
      let g2;
      let b2;
      switch (i) {
        default:
        case 6:
        case 0:
          r2 = v;
          g2 = n2;
          b2 = wh;
          break;
        case 1:
          r2 = n2;
          g2 = v;
          b2 = wh;
          break;
        case 2:
          r2 = wh;
          g2 = v;
          b2 = n2;
          break;
        case 3:
          r2 = wh;
          g2 = n2;
          b2 = v;
          break;
        case 4:
          r2 = n2;
          g2 = wh;
          b2 = v;
          break;
        case 5:
          r2 = v;
          g2 = wh;
          b2 = n2;
          break;
      }
      return [r2 * 255, g2 * 255, b2 * 255];
    };
    convert.cmyk.rgb = function(cmyk) {
      const c = cmyk[0] / 100;
      const m = cmyk[1] / 100;
      const y2 = cmyk[2] / 100;
      const k = cmyk[3] / 100;
      const r2 = 1 - Math.min(1, c * (1 - k) + k);
      const g2 = 1 - Math.min(1, m * (1 - k) + k);
      const b2 = 1 - Math.min(1, y2 * (1 - k) + k);
      return [r2 * 255, g2 * 255, b2 * 255];
    };
    convert.xyz.rgb = function(xyz) {
      const x = xyz[0] / 100;
      const y2 = xyz[1] / 100;
      const z = xyz[2] / 100;
      let r2;
      let g2;
      let b2;
      r2 = x * 3.2406 + y2 * -1.5372 + z * -0.4986;
      g2 = x * -0.9689 + y2 * 1.8758 + z * 0.0415;
      b2 = x * 0.0557 + y2 * -0.204 + z * 1.057;
      r2 = r2 > 31308e-7 ? 1.055 * r2 ** (1 / 2.4) - 0.055 : r2 * 12.92;
      g2 = g2 > 31308e-7 ? 1.055 * g2 ** (1 / 2.4) - 0.055 : g2 * 12.92;
      b2 = b2 > 31308e-7 ? 1.055 * b2 ** (1 / 2.4) - 0.055 : b2 * 12.92;
      r2 = Math.min(Math.max(0, r2), 1);
      g2 = Math.min(Math.max(0, g2), 1);
      b2 = Math.min(Math.max(0, b2), 1);
      return [r2 * 255, g2 * 255, b2 * 255];
    };
    convert.xyz.lab = function(xyz) {
      let x = xyz[0];
      let y2 = xyz[1];
      let z = xyz[2];
      x /= 95.047;
      y2 /= 100;
      z /= 108.883;
      x = x > 8856e-6 ? x ** (1 / 3) : 7.787 * x + 16 / 116;
      y2 = y2 > 8856e-6 ? y2 ** (1 / 3) : 7.787 * y2 + 16 / 116;
      z = z > 8856e-6 ? z ** (1 / 3) : 7.787 * z + 16 / 116;
      const l = 116 * y2 - 16;
      const a = 500 * (x - y2);
      const b2 = 200 * (y2 - z);
      return [l, a, b2];
    };
    convert.lab.xyz = function(lab) {
      const l = lab[0];
      const a = lab[1];
      const b2 = lab[2];
      let x;
      let y2;
      let z;
      y2 = (l + 16) / 116;
      x = a / 500 + y2;
      z = y2 - b2 / 200;
      const y22 = y2 ** 3;
      const x2 = x ** 3;
      const z2 = z ** 3;
      y2 = y22 > 8856e-6 ? y22 : (y2 - 16 / 116) / 7.787;
      x = x2 > 8856e-6 ? x2 : (x - 16 / 116) / 7.787;
      z = z2 > 8856e-6 ? z2 : (z - 16 / 116) / 7.787;
      x *= 95.047;
      y2 *= 100;
      z *= 108.883;
      return [x, y2, z];
    };
    convert.lab.lch = function(lab) {
      const l = lab[0];
      const a = lab[1];
      const b2 = lab[2];
      let h2;
      const hr = Math.atan2(b2, a);
      h2 = hr * 360 / 2 / Math.PI;
      if (h2 < 0) {
        h2 += 360;
      }
      const c = Math.sqrt(a * a + b2 * b2);
      return [l, c, h2];
    };
    convert.lch.lab = function(lch) {
      const l = lch[0];
      const c = lch[1];
      const h2 = lch[2];
      const hr = h2 / 360 * 2 * Math.PI;
      const a = c * Math.cos(hr);
      const b2 = c * Math.sin(hr);
      return [l, a, b2];
    };
    convert.rgb.ansi16 = function(args, saturation = null) {
      const [r2, g2, b2] = args;
      let value = saturation === null ? convert.rgb.hsv(args)[2] : saturation;
      value = Math.round(value / 50);
      if (value === 0) {
        return 30;
      }
      let ansi = 30 + (Math.round(b2 / 255) << 2 | Math.round(g2 / 255) << 1 | Math.round(r2 / 255));
      if (value === 2) {
        ansi += 60;
      }
      return ansi;
    };
    convert.hsv.ansi16 = function(args) {
      return convert.rgb.ansi16(convert.hsv.rgb(args), args[2]);
    };
    convert.rgb.ansi256 = function(args) {
      const r2 = args[0];
      const g2 = args[1];
      const b2 = args[2];
      if (r2 === g2 && g2 === b2) {
        if (r2 < 8) {
          return 16;
        }
        if (r2 > 248) {
          return 231;
        }
        return Math.round((r2 - 8) / 247 * 24) + 232;
      }
      const ansi = 16 + 36 * Math.round(r2 / 255 * 5) + 6 * Math.round(g2 / 255 * 5) + Math.round(b2 / 255 * 5);
      return ansi;
    };
    convert.ansi16.rgb = function(args) {
      let color = args % 10;
      if (color === 0 || color === 7) {
        if (args > 50) {
          color += 3.5;
        }
        color = color / 10.5 * 255;
        return [color, color, color];
      }
      const mult = (~~(args > 50) + 1) * 0.5;
      const r2 = (color & 1) * mult * 255;
      const g2 = (color >> 1 & 1) * mult * 255;
      const b2 = (color >> 2 & 1) * mult * 255;
      return [r2, g2, b2];
    };
    convert.ansi256.rgb = function(args) {
      if (args >= 232) {
        const c = (args - 232) * 10 + 8;
        return [c, c, c];
      }
      args -= 16;
      let rem;
      const r2 = Math.floor(args / 36) / 5 * 255;
      const g2 = Math.floor((rem = args % 36) / 6) / 5 * 255;
      const b2 = rem % 6 / 5 * 255;
      return [r2, g2, b2];
    };
    convert.rgb.hex = function(args) {
      const integer = ((Math.round(args[0]) & 255) << 16) + ((Math.round(args[1]) & 255) << 8) + (Math.round(args[2]) & 255);
      const string = integer.toString(16).toUpperCase();
      return "000000".substring(string.length) + string;
    };
    convert.hex.rgb = function(args) {
      const match = args.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);
      if (!match) {
        return [0, 0, 0];
      }
      let colorString = match[0];
      if (match[0].length === 3) {
        colorString = colorString.split("").map((char) => {
          return char + char;
        }).join("");
      }
      const integer = parseInt(colorString, 16);
      const r2 = integer >> 16 & 255;
      const g2 = integer >> 8 & 255;
      const b2 = integer & 255;
      return [r2, g2, b2];
    };
    convert.rgb.hcg = function(rgb) {
      const r2 = rgb[0] / 255;
      const g2 = rgb[1] / 255;
      const b2 = rgb[2] / 255;
      const max2 = Math.max(Math.max(r2, g2), b2);
      const min2 = Math.min(Math.min(r2, g2), b2);
      const chroma = max2 - min2;
      let grayscale;
      let hue;
      if (chroma < 1) {
        grayscale = min2 / (1 - chroma);
      } else {
        grayscale = 0;
      }
      if (chroma <= 0) {
        hue = 0;
      } else if (max2 === r2) {
        hue = (g2 - b2) / chroma % 6;
      } else if (max2 === g2) {
        hue = 2 + (b2 - r2) / chroma;
      } else {
        hue = 4 + (r2 - g2) / chroma;
      }
      hue /= 6;
      hue %= 1;
      return [hue * 360, chroma * 100, grayscale * 100];
    };
    convert.hsl.hcg = function(hsl) {
      const s = hsl[1] / 100;
      const l = hsl[2] / 100;
      const c = l < 0.5 ? 2 * s * l : 2 * s * (1 - l);
      let f = 0;
      if (c < 1) {
        f = (l - 0.5 * c) / (1 - c);
      }
      return [hsl[0], c * 100, f * 100];
    };
    convert.hsv.hcg = function(hsv) {
      const s = hsv[1] / 100;
      const v = hsv[2] / 100;
      const c = s * v;
      let f = 0;
      if (c < 1) {
        f = (v - c) / (1 - c);
      }
      return [hsv[0], c * 100, f * 100];
    };
    convert.hcg.rgb = function(hcg) {
      const h2 = hcg[0] / 360;
      const c = hcg[1] / 100;
      const g2 = hcg[2] / 100;
      if (c === 0) {
        return [g2 * 255, g2 * 255, g2 * 255];
      }
      const pure = [0, 0, 0];
      const hi = h2 % 1 * 6;
      const v = hi % 1;
      const w2 = 1 - v;
      let mg = 0;
      switch (Math.floor(hi)) {
        case 0:
          pure[0] = 1;
          pure[1] = v;
          pure[2] = 0;
          break;
        case 1:
          pure[0] = w2;
          pure[1] = 1;
          pure[2] = 0;
          break;
        case 2:
          pure[0] = 0;
          pure[1] = 1;
          pure[2] = v;
          break;
        case 3:
          pure[0] = 0;
          pure[1] = w2;
          pure[2] = 1;
          break;
        case 4:
          pure[0] = v;
          pure[1] = 0;
          pure[2] = 1;
          break;
        default:
          pure[0] = 1;
          pure[1] = 0;
          pure[2] = w2;
      }
      mg = (1 - c) * g2;
      return [
        (c * pure[0] + mg) * 255,
        (c * pure[1] + mg) * 255,
        (c * pure[2] + mg) * 255
      ];
    };
    convert.hcg.hsv = function(hcg) {
      const c = hcg[1] / 100;
      const g2 = hcg[2] / 100;
      const v = c + g2 * (1 - c);
      let f = 0;
      if (v > 0) {
        f = c / v;
      }
      return [hcg[0], f * 100, v * 100];
    };
    convert.hcg.hsl = function(hcg) {
      const c = hcg[1] / 100;
      const g2 = hcg[2] / 100;
      const l = g2 * (1 - c) + 0.5 * c;
      let s = 0;
      if (l > 0 && l < 0.5) {
        s = c / (2 * l);
      } else if (l >= 0.5 && l < 1) {
        s = c / (2 * (1 - l));
      }
      return [hcg[0], s * 100, l * 100];
    };
    convert.hcg.hwb = function(hcg) {
      const c = hcg[1] / 100;
      const g2 = hcg[2] / 100;
      const v = c + g2 * (1 - c);
      return [hcg[0], (v - c) * 100, (1 - v) * 100];
    };
    convert.hwb.hcg = function(hwb) {
      const w2 = hwb[1] / 100;
      const b2 = hwb[2] / 100;
      const v = 1 - b2;
      const c = v - w2;
      let g2 = 0;
      if (c < 1) {
        g2 = (v - c) / (1 - c);
      }
      return [hwb[0], c * 100, g2 * 100];
    };
    convert.apple.rgb = function(apple) {
      return [apple[0] / 65535 * 255, apple[1] / 65535 * 255, apple[2] / 65535 * 255];
    };
    convert.rgb.apple = function(rgb) {
      return [rgb[0] / 255 * 65535, rgb[1] / 255 * 65535, rgb[2] / 255 * 65535];
    };
    convert.gray.rgb = function(args) {
      return [args[0] / 100 * 255, args[0] / 100 * 255, args[0] / 100 * 255];
    };
    convert.gray.hsl = function(args) {
      return [0, 0, args[0]];
    };
    convert.gray.hsv = convert.gray.hsl;
    convert.gray.hwb = function(gray) {
      return [0, 100, gray[0]];
    };
    convert.gray.cmyk = function(gray) {
      return [0, 0, 0, gray[0]];
    };
    convert.gray.lab = function(gray) {
      return [gray[0], 0, 0];
    };
    convert.gray.hex = function(gray) {
      const val = Math.round(gray[0] / 100 * 255) & 255;
      const integer = (val << 16) + (val << 8) + val;
      const string = integer.toString(16).toUpperCase();
      return "000000".substring(string.length) + string;
    };
    convert.rgb.gray = function(rgb) {
      const val = (rgb[0] + rgb[1] + rgb[2]) / 3;
      return [val / 255 * 100];
    };
  }
});

// ../../node_modules/.pnpm/color-convert@2.0.1/node_modules/color-convert/route.js
var require_route = __commonJS({
  "../../node_modules/.pnpm/color-convert@2.0.1/node_modules/color-convert/route.js"(exports, module2) {
    var conversions = require_conversions();
    function buildGraph() {
      const graph = {};
      const models = Object.keys(conversions);
      for (let len = models.length, i = 0; i < len; i++) {
        graph[models[i]] = {
          distance: -1,
          parent: null
        };
      }
      return graph;
    }
    __name(buildGraph, "buildGraph");
    function deriveBFS(fromModel) {
      const graph = buildGraph();
      const queue = [fromModel];
      graph[fromModel].distance = 0;
      while (queue.length) {
        const current = queue.pop();
        const adjacents = Object.keys(conversions[current]);
        for (let len = adjacents.length, i = 0; i < len; i++) {
          const adjacent = adjacents[i];
          const node = graph[adjacent];
          if (node.distance === -1) {
            node.distance = graph[current].distance + 1;
            node.parent = current;
            queue.unshift(adjacent);
          }
        }
      }
      return graph;
    }
    __name(deriveBFS, "deriveBFS");
    function link2(from, to) {
      return function(args) {
        return to(from(args));
      };
    }
    __name(link2, "link");
    function wrapConversion(toModel, graph) {
      const path9 = [graph[toModel].parent, toModel];
      let fn = conversions[graph[toModel].parent][toModel];
      let cur = graph[toModel].parent;
      while (graph[cur].parent) {
        path9.unshift(graph[cur].parent);
        fn = link2(conversions[graph[cur].parent][cur], fn);
        cur = graph[cur].parent;
      }
      fn.conversion = path9;
      return fn;
    }
    __name(wrapConversion, "wrapConversion");
    module2.exports = function(fromModel) {
      const graph = deriveBFS(fromModel);
      const conversion = {};
      const models = Object.keys(graph);
      for (let len = models.length, i = 0; i < len; i++) {
        const toModel = models[i];
        const node = graph[toModel];
        if (node.parent === null) {
          continue;
        }
        conversion[toModel] = wrapConversion(toModel, graph);
      }
      return conversion;
    };
  }
});

// ../../node_modules/.pnpm/color-convert@2.0.1/node_modules/color-convert/index.js
var require_color_convert = __commonJS({
  "../../node_modules/.pnpm/color-convert@2.0.1/node_modules/color-convert/index.js"(exports, module2) {
    var conversions = require_conversions();
    var route = require_route();
    var convert = {};
    var models = Object.keys(conversions);
    function wrapRaw(fn) {
      const wrappedFn = /* @__PURE__ */ __name(function(...args) {
        const arg0 = args[0];
        if (arg0 === void 0 || arg0 === null) {
          return arg0;
        }
        if (arg0.length > 1) {
          args = arg0;
        }
        return fn(args);
      }, "wrappedFn");
      if ("conversion" in fn) {
        wrappedFn.conversion = fn.conversion;
      }
      return wrappedFn;
    }
    __name(wrapRaw, "wrapRaw");
    function wrapRounded(fn) {
      const wrappedFn = /* @__PURE__ */ __name(function(...args) {
        const arg0 = args[0];
        if (arg0 === void 0 || arg0 === null) {
          return arg0;
        }
        if (arg0.length > 1) {
          args = arg0;
        }
        const result = fn(args);
        if (typeof result === "object") {
          for (let len = result.length, i = 0; i < len; i++) {
            result[i] = Math.round(result[i]);
          }
        }
        return result;
      }, "wrappedFn");
      if ("conversion" in fn) {
        wrappedFn.conversion = fn.conversion;
      }
      return wrappedFn;
    }
    __name(wrapRounded, "wrapRounded");
    models.forEach((fromModel) => {
      convert[fromModel] = {};
      Object.defineProperty(convert[fromModel], "channels", { value: conversions[fromModel].channels });
      Object.defineProperty(convert[fromModel], "labels", { value: conversions[fromModel].labels });
      const routes = route(fromModel);
      const routeModels = Object.keys(routes);
      routeModels.forEach((toModel) => {
        const fn = routes[toModel];
        convert[fromModel][toModel] = wrapRounded(fn);
        convert[fromModel][toModel].raw = wrapRaw(fn);
      });
    });
    module2.exports = convert;
  }
});

// ../../node_modules/.pnpm/ansi-styles@4.3.0/node_modules/ansi-styles/index.js
var require_ansi_styles = __commonJS({
  "../../node_modules/.pnpm/ansi-styles@4.3.0/node_modules/ansi-styles/index.js"(exports, module2) {
    "use strict";
    var wrapAnsi16 = /* @__PURE__ */ __name((fn, offset) => (...args) => {
      const code = fn(...args);
      return `\x1B[${code + offset}m`;
    }, "wrapAnsi16");
    var wrapAnsi256 = /* @__PURE__ */ __name((fn, offset) => (...args) => {
      const code = fn(...args);
      return `\x1B[${38 + offset};5;${code}m`;
    }, "wrapAnsi256");
    var wrapAnsi16m = /* @__PURE__ */ __name((fn, offset) => (...args) => {
      const rgb = fn(...args);
      return `\x1B[${38 + offset};2;${rgb[0]};${rgb[1]};${rgb[2]}m`;
    }, "wrapAnsi16m");
    var ansi2ansi = /* @__PURE__ */ __name((n2) => n2, "ansi2ansi");
    var rgb2rgb = /* @__PURE__ */ __name((r2, g2, b2) => [r2, g2, b2], "rgb2rgb");
    var setLazyProperty = /* @__PURE__ */ __name((object, property2, get2) => {
      Object.defineProperty(object, property2, {
        get: () => {
          const value = get2();
          Object.defineProperty(object, property2, {
            value,
            enumerable: true,
            configurable: true
          });
          return value;
        },
        enumerable: true,
        configurable: true
      });
    }, "setLazyProperty");
    var colorConvert;
    var makeDynamicStyles = /* @__PURE__ */ __name((wrap, targetSpace, identity, isBackground) => {
      if (colorConvert === void 0) {
        colorConvert = require_color_convert();
      }
      const offset = isBackground ? 10 : 0;
      const styles = {};
      for (const [sourceSpace, suite] of Object.entries(colorConvert)) {
        const name = sourceSpace === "ansi16" ? "ansi" : sourceSpace;
        if (sourceSpace === targetSpace) {
          styles[name] = wrap(identity, offset);
        } else if (typeof suite === "object") {
          styles[name] = wrap(suite[targetSpace], offset);
        }
      }
      return styles;
    }, "makeDynamicStyles");
    function assembleStyles() {
      const codes = /* @__PURE__ */ new Map();
      const styles = {
        modifier: {
          reset: [0, 0],
          bold: [1, 22],
          dim: [2, 22],
          italic: [3, 23],
          underline: [4, 24],
          inverse: [7, 27],
          hidden: [8, 28],
          strikethrough: [9, 29]
        },
        color: {
          black: [30, 39],
          red: [31, 39],
          green: [32, 39],
          yellow: [33, 39],
          blue: [34, 39],
          magenta: [35, 39],
          cyan: [36, 39],
          white: [37, 39],
          blackBright: [90, 39],
          redBright: [91, 39],
          greenBright: [92, 39],
          yellowBright: [93, 39],
          blueBright: [94, 39],
          magentaBright: [95, 39],
          cyanBright: [96, 39],
          whiteBright: [97, 39]
        },
        bgColor: {
          bgBlack: [40, 49],
          bgRed: [41, 49],
          bgGreen: [42, 49],
          bgYellow: [43, 49],
          bgBlue: [44, 49],
          bgMagenta: [45, 49],
          bgCyan: [46, 49],
          bgWhite: [47, 49],
          bgBlackBright: [100, 49],
          bgRedBright: [101, 49],
          bgGreenBright: [102, 49],
          bgYellowBright: [103, 49],
          bgBlueBright: [104, 49],
          bgMagentaBright: [105, 49],
          bgCyanBright: [106, 49],
          bgWhiteBright: [107, 49]
        }
      };
      styles.color.gray = styles.color.blackBright;
      styles.bgColor.bgGray = styles.bgColor.bgBlackBright;
      styles.color.grey = styles.color.blackBright;
      styles.bgColor.bgGrey = styles.bgColor.bgBlackBright;
      for (const [groupName, group] of Object.entries(styles)) {
        for (const [styleName, style] of Object.entries(group)) {
          styles[styleName] = {
            open: `\x1B[${style[0]}m`,
            close: `\x1B[${style[1]}m`
          };
          group[styleName] = styles[styleName];
          codes.set(style[0], style[1]);
        }
        Object.defineProperty(styles, groupName, {
          value: group,
          enumerable: false
        });
      }
      Object.defineProperty(styles, "codes", {
        value: codes,
        enumerable: false
      });
      styles.color.close = "\x1B[39m";
      styles.bgColor.close = "\x1B[49m";
      setLazyProperty(styles.color, "ansi", () => makeDynamicStyles(wrapAnsi16, "ansi16", ansi2ansi, false));
      setLazyProperty(styles.color, "ansi256", () => makeDynamicStyles(wrapAnsi256, "ansi256", ansi2ansi, false));
      setLazyProperty(styles.color, "ansi16m", () => makeDynamicStyles(wrapAnsi16m, "rgb", rgb2rgb, false));
      setLazyProperty(styles.bgColor, "ansi", () => makeDynamicStyles(wrapAnsi16, "ansi16", ansi2ansi, true));
      setLazyProperty(styles.bgColor, "ansi256", () => makeDynamicStyles(wrapAnsi256, "ansi256", ansi2ansi, true));
      setLazyProperty(styles.bgColor, "ansi16m", () => makeDynamicStyles(wrapAnsi16m, "rgb", rgb2rgb, true));
      return styles;
    }
    __name(assembleStyles, "assembleStyles");
    Object.defineProperty(module2, "exports", {
      enumerable: true,
      get: assembleStyles
    });
  }
});

// ../../node_modules/.pnpm/chalk@4.1.2/node_modules/chalk/source/util.js
var require_util = __commonJS({
  "../../node_modules/.pnpm/chalk@4.1.2/node_modules/chalk/source/util.js"(exports, module2) {
    "use strict";
    var stringReplaceAll = /* @__PURE__ */ __name((string, substring, replacer) => {
      let index = string.indexOf(substring);
      if (index === -1) {
        return string;
      }
      const substringLength = substring.length;
      let endIndex = 0;
      let returnValue = "";
      do {
        returnValue += string.substr(endIndex, index - endIndex) + substring + replacer;
        endIndex = index + substringLength;
        index = string.indexOf(substring, endIndex);
      } while (index !== -1);
      returnValue += string.substr(endIndex);
      return returnValue;
    }, "stringReplaceAll");
    var stringEncaseCRLFWithFirstIndex = /* @__PURE__ */ __name((string, prefix, postfix, index) => {
      let endIndex = 0;
      let returnValue = "";
      do {
        const gotCR = string[index - 1] === "\r";
        returnValue += string.substr(endIndex, (gotCR ? index - 1 : index) - endIndex) + prefix + (gotCR ? "\r\n" : "\n") + postfix;
        endIndex = index + 1;
        index = string.indexOf("\n", endIndex);
      } while (index !== -1);
      returnValue += string.substr(endIndex);
      return returnValue;
    }, "stringEncaseCRLFWithFirstIndex");
    module2.exports = {
      stringReplaceAll,
      stringEncaseCRLFWithFirstIndex
    };
  }
});

// ../../node_modules/.pnpm/chalk@4.1.2/node_modules/chalk/source/templates.js
var require_templates = __commonJS({
  "../../node_modules/.pnpm/chalk@4.1.2/node_modules/chalk/source/templates.js"(exports, module2) {
    "use strict";
    var TEMPLATE_REGEX = /(?:\\(u(?:[a-f\d]{4}|\{[a-f\d]{1,6}\})|x[a-f\d]{2}|.))|(?:\{(~)?(\w+(?:\([^)]*\))?(?:\.\w+(?:\([^)]*\))?)*)(?:[ \t]|(?=\r?\n)))|(\})|((?:.|[\r\n\f])+?)/gi;
    var STYLE_REGEX = /(?:^|\.)(\w+)(?:\(([^)]*)\))?/g;
    var STRING_REGEX = /^(['"])((?:\\.|(?!\1)[^\\])*)\1$/;
    var ESCAPE_REGEX = /\\(u(?:[a-f\d]{4}|{[a-f\d]{1,6}})|x[a-f\d]{2}|.)|([^\\])/gi;
    var ESCAPES = /* @__PURE__ */ new Map([
      ["n", "\n"],
      ["r", "\r"],
      ["t", "	"],
      ["b", "\b"],
      ["f", "\f"],
      ["v", "\v"],
      ["0", "\0"],
      ["\\", "\\"],
      ["e", "\x1B"],
      ["a", "\x07"]
    ]);
    function unescape(c) {
      const u2 = c[0] === "u";
      const bracket = c[1] === "{";
      if (u2 && !bracket && c.length === 5 || c[0] === "x" && c.length === 3) {
        return String.fromCharCode(parseInt(c.slice(1), 16));
      }
      if (u2 && bracket) {
        return String.fromCodePoint(parseInt(c.slice(2, -1), 16));
      }
      return ESCAPES.get(c) || c;
    }
    __name(unescape, "unescape");
    function parseArguments(name, arguments_) {
      const results = [];
      const chunks = arguments_.trim().split(/\s*,\s*/g);
      let matches;
      for (const chunk of chunks) {
        const number = Number(chunk);
        if (!Number.isNaN(number)) {
          results.push(number);
        } else if (matches = chunk.match(STRING_REGEX)) {
          results.push(matches[2].replace(ESCAPE_REGEX, (m, escape, character) => escape ? unescape(escape) : character));
        } else {
          throw new Error(`Invalid Chalk template style argument: ${chunk} (in style '${name}')`);
        }
      }
      return results;
    }
    __name(parseArguments, "parseArguments");
    function parseStyle(style) {
      STYLE_REGEX.lastIndex = 0;
      const results = [];
      let matches;
      while ((matches = STYLE_REGEX.exec(style)) !== null) {
        const name = matches[1];
        if (matches[2]) {
          const args = parseArguments(name, matches[2]);
          results.push([name].concat(args));
        } else {
          results.push([name]);
        }
      }
      return results;
    }
    __name(parseStyle, "parseStyle");
    function buildStyle(chalk9, styles) {
      const enabled = {};
      for (const layer of styles) {
        for (const style of layer.styles) {
          enabled[style[0]] = layer.inverse ? null : style.slice(1);
        }
      }
      let current = chalk9;
      for (const [styleName, styles2] of Object.entries(enabled)) {
        if (!Array.isArray(styles2)) {
          continue;
        }
        if (!(styleName in current)) {
          throw new Error(`Unknown Chalk style: ${styleName}`);
        }
        current = styles2.length > 0 ? current[styleName](...styles2) : current[styleName];
      }
      return current;
    }
    __name(buildStyle, "buildStyle");
    module2.exports = (chalk9, temporary) => {
      const styles = [];
      const chunks = [];
      let chunk = [];
      temporary.replace(TEMPLATE_REGEX, (m, escapeCharacter, inverse, style, close, character) => {
        if (escapeCharacter) {
          chunk.push(unescape(escapeCharacter));
        } else if (style) {
          const string = chunk.join("");
          chunk = [];
          chunks.push(styles.length === 0 ? string : buildStyle(chalk9, styles)(string));
          styles.push({ inverse, styles: parseStyle(style) });
        } else if (close) {
          if (styles.length === 0) {
            throw new Error("Found extraneous } in Chalk template literal");
          }
          chunks.push(buildStyle(chalk9, styles)(chunk.join("")));
          chunk = [];
          styles.pop();
        } else {
          chunk.push(character);
        }
      });
      chunks.push(chunk.join(""));
      if (styles.length > 0) {
        const errMessage = `Chalk template literal is missing ${styles.length} closing bracket${styles.length === 1 ? "" : "s"} (\`}\`)`;
        throw new Error(errMessage);
      }
      return chunks.join("");
    };
  }
});

// ../../node_modules/.pnpm/chalk@4.1.2/node_modules/chalk/source/index.js
var require_source = __commonJS({
  "../../node_modules/.pnpm/chalk@4.1.2/node_modules/chalk/source/index.js"(exports, module2) {
    "use strict";
    var ansiStyles = require_ansi_styles();
    var { stdout: stdoutColor, stderr: stderrColor } = require_supports_color();
    var {
      stringReplaceAll,
      stringEncaseCRLFWithFirstIndex
    } = require_util();
    var { isArray } = Array;
    var levelMapping = [
      "ansi",
      "ansi",
      "ansi256",
      "ansi16m"
    ];
    var styles = /* @__PURE__ */ Object.create(null);
    var applyOptions = /* @__PURE__ */ __name((object, options2 = {}) => {
      if (options2.level && !(Number.isInteger(options2.level) && options2.level >= 0 && options2.level <= 3)) {
        throw new Error("The `level` option should be an integer from 0 to 3");
      }
      const colorLevel = stdoutColor ? stdoutColor.level : 0;
      object.level = options2.level === void 0 ? colorLevel : options2.level;
    }, "applyOptions");
    var ChalkClass = class {
      constructor(options2) {
        return chalkFactory(options2);
      }
    };
    __name(ChalkClass, "ChalkClass");
    var chalkFactory = /* @__PURE__ */ __name((options2) => {
      const chalk10 = {};
      applyOptions(chalk10, options2);
      chalk10.template = (...arguments_) => chalkTag(chalk10.template, ...arguments_);
      Object.setPrototypeOf(chalk10, Chalk.prototype);
      Object.setPrototypeOf(chalk10.template, chalk10);
      chalk10.template.constructor = () => {
        throw new Error("`chalk.constructor()` is deprecated. Use `new chalk.Instance()` instead.");
      };
      chalk10.template.Instance = ChalkClass;
      return chalk10.template;
    }, "chalkFactory");
    function Chalk(options2) {
      return chalkFactory(options2);
    }
    __name(Chalk, "Chalk");
    for (const [styleName, style] of Object.entries(ansiStyles)) {
      styles[styleName] = {
        get() {
          const builder = createBuilder(this, createStyler(style.open, style.close, this._styler), this._isEmpty);
          Object.defineProperty(this, styleName, { value: builder });
          return builder;
        }
      };
    }
    styles.visible = {
      get() {
        const builder = createBuilder(this, this._styler, true);
        Object.defineProperty(this, "visible", { value: builder });
        return builder;
      }
    };
    var usedModels = ["rgb", "hex", "keyword", "hsl", "hsv", "hwb", "ansi", "ansi256"];
    for (const model of usedModels) {
      styles[model] = {
        get() {
          const { level } = this;
          return function(...arguments_) {
            const styler = createStyler(ansiStyles.color[levelMapping[level]][model](...arguments_), ansiStyles.color.close, this._styler);
            return createBuilder(this, styler, this._isEmpty);
          };
        }
      };
    }
    for (const model of usedModels) {
      const bgModel = "bg" + model[0].toUpperCase() + model.slice(1);
      styles[bgModel] = {
        get() {
          const { level } = this;
          return function(...arguments_) {
            const styler = createStyler(ansiStyles.bgColor[levelMapping[level]][model](...arguments_), ansiStyles.bgColor.close, this._styler);
            return createBuilder(this, styler, this._isEmpty);
          };
        }
      };
    }
    var proto = Object.defineProperties(() => {
    }, {
      ...styles,
      level: {
        enumerable: true,
        get() {
          return this._generator.level;
        },
        set(level) {
          this._generator.level = level;
        }
      }
    });
    var createStyler = /* @__PURE__ */ __name((open, close, parent) => {
      let openAll;
      let closeAll;
      if (parent === void 0) {
        openAll = open;
        closeAll = close;
      } else {
        openAll = parent.openAll + open;
        closeAll = close + parent.closeAll;
      }
      return {
        open,
        close,
        openAll,
        closeAll,
        parent
      };
    }, "createStyler");
    var createBuilder = /* @__PURE__ */ __name((self, _styler, _isEmpty) => {
      const builder = /* @__PURE__ */ __name((...arguments_) => {
        if (isArray(arguments_[0]) && isArray(arguments_[0].raw)) {
          return applyStyle(builder, chalkTag(builder, ...arguments_));
        }
        return applyStyle(builder, arguments_.length === 1 ? "" + arguments_[0] : arguments_.join(" "));
      }, "builder");
      Object.setPrototypeOf(builder, proto);
      builder._generator = self;
      builder._styler = _styler;
      builder._isEmpty = _isEmpty;
      return builder;
    }, "createBuilder");
    var applyStyle = /* @__PURE__ */ __name((self, string) => {
      if (self.level <= 0 || !string) {
        return self._isEmpty ? "" : string;
      }
      let styler = self._styler;
      if (styler === void 0) {
        return string;
      }
      const { openAll, closeAll } = styler;
      if (string.indexOf("\x1B") !== -1) {
        while (styler !== void 0) {
          string = stringReplaceAll(string, styler.close, styler.open);
          styler = styler.parent;
        }
      }
      const lfIndex = string.indexOf("\n");
      if (lfIndex !== -1) {
        string = stringEncaseCRLFWithFirstIndex(string, closeAll, openAll, lfIndex);
      }
      return openAll + string + closeAll;
    }, "applyStyle");
    var template;
    var chalkTag = /* @__PURE__ */ __name((chalk10, ...strings) => {
      const [firstString] = strings;
      if (!isArray(firstString) || !isArray(firstString.raw)) {
        return strings.join(" ");
      }
      const arguments_ = strings.slice(1);
      const parts = [firstString.raw[0]];
      for (let i = 1; i < firstString.length; i++) {
        parts.push(
          String(arguments_[i - 1]).replace(/[{}\\]/g, "\\$&"),
          String(firstString.raw[i])
        );
      }
      if (template === void 0) {
        template = require_templates();
      }
      return template(chalk10, parts.join(""));
    }, "chalkTag");
    Object.defineProperties(Chalk.prototype, styles);
    var chalk9 = Chalk();
    chalk9.supportsColor = stdoutColor;
    chalk9.stderr = Chalk({ level: stderrColor ? stderrColor.level : 0 });
    chalk9.stderr.supportsColor = stderrColor;
    module2.exports = chalk9;
  }
});

// ../../node_modules/.pnpm/isexe@2.0.0/node_modules/isexe/windows.js
var require_windows = __commonJS({
  "../../node_modules/.pnpm/isexe@2.0.0/node_modules/isexe/windows.js"(exports, module2) {
    module2.exports = isexe;
    isexe.sync = sync;
    var fs11 = require("fs");
    function checkPathExt(path9, options2) {
      var pathext = options2.pathExt !== void 0 ? options2.pathExt : process.env.PATHEXT;
      if (!pathext) {
        return true;
      }
      pathext = pathext.split(";");
      if (pathext.indexOf("") !== -1) {
        return true;
      }
      for (var i = 0; i < pathext.length; i++) {
        var p2 = pathext[i].toLowerCase();
        if (p2 && path9.substr(-p2.length).toLowerCase() === p2) {
          return true;
        }
      }
      return false;
    }
    __name(checkPathExt, "checkPathExt");
    function checkStat(stat2, path9, options2) {
      if (!stat2.isSymbolicLink() && !stat2.isFile()) {
        return false;
      }
      return checkPathExt(path9, options2);
    }
    __name(checkStat, "checkStat");
    function isexe(path9, options2, cb) {
      fs11.stat(path9, function(er, stat2) {
        cb(er, er ? false : checkStat(stat2, path9, options2));
      });
    }
    __name(isexe, "isexe");
    function sync(path9, options2) {
      return checkStat(fs11.statSync(path9), path9, options2);
    }
    __name(sync, "sync");
  }
});

// ../../node_modules/.pnpm/isexe@2.0.0/node_modules/isexe/mode.js
var require_mode = __commonJS({
  "../../node_modules/.pnpm/isexe@2.0.0/node_modules/isexe/mode.js"(exports, module2) {
    module2.exports = isexe;
    isexe.sync = sync;
    var fs11 = require("fs");
    function isexe(path9, options2, cb) {
      fs11.stat(path9, function(er, stat2) {
        cb(er, er ? false : checkStat(stat2, options2));
      });
    }
    __name(isexe, "isexe");
    function sync(path9, options2) {
      return checkStat(fs11.statSync(path9), options2);
    }
    __name(sync, "sync");
    function checkStat(stat2, options2) {
      return stat2.isFile() && checkMode(stat2, options2);
    }
    __name(checkStat, "checkStat");
    function checkMode(stat2, options2) {
      var mod2 = stat2.mode;
      var uid = stat2.uid;
      var gid = stat2.gid;
      var myUid = options2.uid !== void 0 ? options2.uid : process.getuid && process.getuid();
      var myGid = options2.gid !== void 0 ? options2.gid : process.getgid && process.getgid();
      var u2 = parseInt("100", 8);
      var g2 = parseInt("010", 8);
      var o = parseInt("001", 8);
      var ug = u2 | g2;
      var ret = mod2 & o || mod2 & g2 && gid === myGid || mod2 & u2 && uid === myUid || mod2 & ug && myUid === 0;
      return ret;
    }
    __name(checkMode, "checkMode");
  }
});

// ../../node_modules/.pnpm/isexe@2.0.0/node_modules/isexe/index.js
var require_isexe = __commonJS({
  "../../node_modules/.pnpm/isexe@2.0.0/node_modules/isexe/index.js"(exports, module2) {
    var fs11 = require("fs");
    var core;
    if (process.platform === "win32" || global.TESTING_WINDOWS) {
      core = require_windows();
    } else {
      core = require_mode();
    }
    module2.exports = isexe;
    isexe.sync = sync;
    function isexe(path9, options2, cb) {
      if (typeof options2 === "function") {
        cb = options2;
        options2 = {};
      }
      if (!cb) {
        if (typeof Promise !== "function") {
          throw new TypeError("callback not provided");
        }
        return new Promise(function(resolve, reject) {
          isexe(path9, options2 || {}, function(er, is) {
            if (er) {
              reject(er);
            } else {
              resolve(is);
            }
          });
        });
      }
      core(path9, options2 || {}, function(er, is) {
        if (er) {
          if (er.code === "EACCES" || options2 && options2.ignoreErrors) {
            er = null;
            is = false;
          }
        }
        cb(er, is);
      });
    }
    __name(isexe, "isexe");
    function sync(path9, options2) {
      try {
        return core.sync(path9, options2 || {});
      } catch (er) {
        if (options2 && options2.ignoreErrors || er.code === "EACCES") {
          return false;
        } else {
          throw er;
        }
      }
    }
    __name(sync, "sync");
  }
});

// ../../node_modules/.pnpm/which@2.0.2/node_modules/which/which.js
var require_which = __commonJS({
  "../../node_modules/.pnpm/which@2.0.2/node_modules/which/which.js"(exports, module2) {
    var isWindows = process.platform === "win32" || process.env.OSTYPE === "cygwin" || process.env.OSTYPE === "msys";
    var path9 = require("path");
    var COLON = isWindows ? ";" : ":";
    var isexe = require_isexe();
    var getNotFoundError = /* @__PURE__ */ __name((cmd) => Object.assign(new Error(`not found: ${cmd}`), { code: "ENOENT" }), "getNotFoundError");
    var getPathInfo = /* @__PURE__ */ __name((cmd, opt) => {
      const colon = opt.colon || COLON;
      const pathEnv = cmd.match(/\//) || isWindows && cmd.match(/\\/) ? [""] : [
        ...isWindows ? [process.cwd()] : [],
        ...(opt.path || process.env.PATH || "").split(colon)
      ];
      const pathExtExe = isWindows ? opt.pathExt || process.env.PATHEXT || ".EXE;.CMD;.BAT;.COM" : "";
      const pathExt = isWindows ? pathExtExe.split(colon) : [""];
      if (isWindows) {
        if (cmd.indexOf(".") !== -1 && pathExt[0] !== "")
          pathExt.unshift("");
      }
      return {
        pathEnv,
        pathExt,
        pathExtExe
      };
    }, "getPathInfo");
    var which = /* @__PURE__ */ __name((cmd, opt, cb) => {
      if (typeof opt === "function") {
        cb = opt;
        opt = {};
      }
      if (!opt)
        opt = {};
      const { pathEnv, pathExt, pathExtExe } = getPathInfo(cmd, opt);
      const found = [];
      const step = /* @__PURE__ */ __name((i) => new Promise((resolve, reject) => {
        if (i === pathEnv.length)
          return opt.all && found.length ? resolve(found) : reject(getNotFoundError(cmd));
        const ppRaw = pathEnv[i];
        const pathPart = /^".*"$/.test(ppRaw) ? ppRaw.slice(1, -1) : ppRaw;
        const pCmd = path9.join(pathPart, cmd);
        const p2 = !pathPart && /^\.[\\\/]/.test(cmd) ? cmd.slice(0, 2) + pCmd : pCmd;
        resolve(subStep(p2, i, 0));
      }), "step");
      const subStep = /* @__PURE__ */ __name((p2, i, ii) => new Promise((resolve, reject) => {
        if (ii === pathExt.length)
          return resolve(step(i + 1));
        const ext = pathExt[ii];
        isexe(p2 + ext, { pathExt: pathExtExe }, (er, is) => {
          if (!er && is) {
            if (opt.all)
              found.push(p2 + ext);
            else
              return resolve(p2 + ext);
          }
          return resolve(subStep(p2, i, ii + 1));
        });
      }), "subStep");
      return cb ? step(0).then((res) => cb(null, res), cb) : step(0);
    }, "which");
    var whichSync = /* @__PURE__ */ __name((cmd, opt) => {
      opt = opt || {};
      const { pathEnv, pathExt, pathExtExe } = getPathInfo(cmd, opt);
      const found = [];
      for (let i = 0; i < pathEnv.length; i++) {
        const ppRaw = pathEnv[i];
        const pathPart = /^".*"$/.test(ppRaw) ? ppRaw.slice(1, -1) : ppRaw;
        const pCmd = path9.join(pathPart, cmd);
        const p2 = !pathPart && /^\.[\\\/]/.test(cmd) ? cmd.slice(0, 2) + pCmd : pCmd;
        for (let j = 0; j < pathExt.length; j++) {
          const cur = p2 + pathExt[j];
          try {
            const is = isexe.sync(cur, { pathExt: pathExtExe });
            if (is) {
              if (opt.all)
                found.push(cur);
              else
                return cur;
            }
          } catch (ex) {
          }
        }
      }
      if (opt.all && found.length)
        return found;
      if (opt.nothrow)
        return null;
      throw getNotFoundError(cmd);
    }, "whichSync");
    module2.exports = which;
    which.sync = whichSync;
  }
});

// ../../node_modules/.pnpm/path-key@3.1.1/node_modules/path-key/index.js
var require_path_key = __commonJS({
  "../../node_modules/.pnpm/path-key@3.1.1/node_modules/path-key/index.js"(exports, module2) {
    "use strict";
    var pathKey = /* @__PURE__ */ __name((options2 = {}) => {
      const environment = options2.env || process.env;
      const platform = options2.platform || process.platform;
      if (platform !== "win32") {
        return "PATH";
      }
      return Object.keys(environment).reverse().find((key) => key.toUpperCase() === "PATH") || "Path";
    }, "pathKey");
    module2.exports = pathKey;
    module2.exports.default = pathKey;
  }
});

// ../../node_modules/.pnpm/cross-spawn@7.0.3/node_modules/cross-spawn/lib/util/resolveCommand.js
var require_resolveCommand = __commonJS({
  "../../node_modules/.pnpm/cross-spawn@7.0.3/node_modules/cross-spawn/lib/util/resolveCommand.js"(exports, module2) {
    "use strict";
    var path9 = require("path");
    var which = require_which();
    var getPathKey = require_path_key();
    function resolveCommandAttempt(parsed, withoutPathExt) {
      const env = parsed.options.env || process.env;
      const cwd = process.cwd();
      const hasCustomCwd = parsed.options.cwd != null;
      const shouldSwitchCwd = hasCustomCwd && process.chdir !== void 0 && !process.chdir.disabled;
      if (shouldSwitchCwd) {
        try {
          process.chdir(parsed.options.cwd);
        } catch (err) {
        }
      }
      let resolved;
      try {
        resolved = which.sync(parsed.command, {
          path: env[getPathKey({ env })],
          pathExt: withoutPathExt ? path9.delimiter : void 0
        });
      } catch (e2) {
      } finally {
        if (shouldSwitchCwd) {
          process.chdir(cwd);
        }
      }
      if (resolved) {
        resolved = path9.resolve(hasCustomCwd ? parsed.options.cwd : "", resolved);
      }
      return resolved;
    }
    __name(resolveCommandAttempt, "resolveCommandAttempt");
    function resolveCommand(parsed) {
      return resolveCommandAttempt(parsed) || resolveCommandAttempt(parsed, true);
    }
    __name(resolveCommand, "resolveCommand");
    module2.exports = resolveCommand;
  }
});

// ../../node_modules/.pnpm/cross-spawn@7.0.3/node_modules/cross-spawn/lib/util/escape.js
var require_escape = __commonJS({
  "../../node_modules/.pnpm/cross-spawn@7.0.3/node_modules/cross-spawn/lib/util/escape.js"(exports, module2) {
    "use strict";
    var metaCharsRegExp = /([()\][%!^"`<>&|;, *?])/g;
    function escapeCommand(arg) {
      arg = arg.replace(metaCharsRegExp, "^$1");
      return arg;
    }
    __name(escapeCommand, "escapeCommand");
    function escapeArgument(arg, doubleEscapeMetaChars) {
      arg = `${arg}`;
      arg = arg.replace(/(\\*)"/g, '$1$1\\"');
      arg = arg.replace(/(\\*)$/, "$1$1");
      arg = `"${arg}"`;
      arg = arg.replace(metaCharsRegExp, "^$1");
      if (doubleEscapeMetaChars) {
        arg = arg.replace(metaCharsRegExp, "^$1");
      }
      return arg;
    }
    __name(escapeArgument, "escapeArgument");
    module2.exports.command = escapeCommand;
    module2.exports.argument = escapeArgument;
  }
});

// ../../node_modules/.pnpm/shebang-regex@3.0.0/node_modules/shebang-regex/index.js
var require_shebang_regex = __commonJS({
  "../../node_modules/.pnpm/shebang-regex@3.0.0/node_modules/shebang-regex/index.js"(exports, module2) {
    "use strict";
    module2.exports = /^#!(.*)/;
  }
});

// ../../node_modules/.pnpm/shebang-command@2.0.0/node_modules/shebang-command/index.js
var require_shebang_command = __commonJS({
  "../../node_modules/.pnpm/shebang-command@2.0.0/node_modules/shebang-command/index.js"(exports, module2) {
    "use strict";
    var shebangRegex = require_shebang_regex();
    module2.exports = (string = "") => {
      const match = string.match(shebangRegex);
      if (!match) {
        return null;
      }
      const [path9, argument] = match[0].replace(/#! ?/, "").split(" ");
      const binary = path9.split("/").pop();
      if (binary === "env") {
        return argument;
      }
      return argument ? `${binary} ${argument}` : binary;
    };
  }
});

// ../../node_modules/.pnpm/cross-spawn@7.0.3/node_modules/cross-spawn/lib/util/readShebang.js
var require_readShebang = __commonJS({
  "../../node_modules/.pnpm/cross-spawn@7.0.3/node_modules/cross-spawn/lib/util/readShebang.js"(exports, module2) {
    "use strict";
    var fs11 = require("fs");
    var shebangCommand = require_shebang_command();
    function readShebang(command) {
      const size = 150;
      const buffer = Buffer.alloc(size);
      let fd;
      try {
        fd = fs11.openSync(command, "r");
        fs11.readSync(fd, buffer, 0, size, 0);
        fs11.closeSync(fd);
      } catch (e2) {
      }
      return shebangCommand(buffer.toString());
    }
    __name(readShebang, "readShebang");
    module2.exports = readShebang;
  }
});

// ../../node_modules/.pnpm/cross-spawn@7.0.3/node_modules/cross-spawn/lib/parse.js
var require_parse = __commonJS({
  "../../node_modules/.pnpm/cross-spawn@7.0.3/node_modules/cross-spawn/lib/parse.js"(exports, module2) {
    "use strict";
    var path9 = require("path");
    var resolveCommand = require_resolveCommand();
    var escape = require_escape();
    var readShebang = require_readShebang();
    var isWin = process.platform === "win32";
    var isExecutableRegExp = /\.(?:com|exe)$/i;
    var isCmdShimRegExp = /node_modules[\\/].bin[\\/][^\\/]+\.cmd$/i;
    function detectShebang(parsed) {
      parsed.file = resolveCommand(parsed);
      const shebang = parsed.file && readShebang(parsed.file);
      if (shebang) {
        parsed.args.unshift(parsed.file);
        parsed.command = shebang;
        return resolveCommand(parsed);
      }
      return parsed.file;
    }
    __name(detectShebang, "detectShebang");
    function parseNonShell(parsed) {
      if (!isWin) {
        return parsed;
      }
      const commandFile = detectShebang(parsed);
      const needsShell = !isExecutableRegExp.test(commandFile);
      if (parsed.options.forceShell || needsShell) {
        const needsDoubleEscapeMetaChars = isCmdShimRegExp.test(commandFile);
        parsed.command = path9.normalize(parsed.command);
        parsed.command = escape.command(parsed.command);
        parsed.args = parsed.args.map((arg) => escape.argument(arg, needsDoubleEscapeMetaChars));
        const shellCommand = [parsed.command].concat(parsed.args).join(" ");
        parsed.args = ["/d", "/s", "/c", `"${shellCommand}"`];
        parsed.command = process.env.comspec || "cmd.exe";
        parsed.options.windowsVerbatimArguments = true;
      }
      return parsed;
    }
    __name(parseNonShell, "parseNonShell");
    function parse(command, args, options2) {
      if (args && !Array.isArray(args)) {
        options2 = args;
        args = null;
      }
      args = args ? args.slice(0) : [];
      options2 = Object.assign({}, options2);
      const parsed = {
        command,
        args,
        options: options2,
        file: void 0,
        original: {
          command,
          args
        }
      };
      return options2.shell ? parsed : parseNonShell(parsed);
    }
    __name(parse, "parse");
    module2.exports = parse;
  }
});

// ../../node_modules/.pnpm/cross-spawn@7.0.3/node_modules/cross-spawn/lib/enoent.js
var require_enoent = __commonJS({
  "../../node_modules/.pnpm/cross-spawn@7.0.3/node_modules/cross-spawn/lib/enoent.js"(exports, module2) {
    "use strict";
    var isWin = process.platform === "win32";
    function notFoundError(original, syscall) {
      return Object.assign(new Error(`${syscall} ${original.command} ENOENT`), {
        code: "ENOENT",
        errno: "ENOENT",
        syscall: `${syscall} ${original.command}`,
        path: original.command,
        spawnargs: original.args
      });
    }
    __name(notFoundError, "notFoundError");
    function hookChildProcess(cp2, parsed) {
      if (!isWin) {
        return;
      }
      const originalEmit = cp2.emit;
      cp2.emit = function(name, arg1) {
        if (name === "exit") {
          const err = verifyENOENT(arg1, parsed, "spawn");
          if (err) {
            return originalEmit.call(cp2, "error", err);
          }
        }
        return originalEmit.apply(cp2, arguments);
      };
    }
    __name(hookChildProcess, "hookChildProcess");
    function verifyENOENT(status, parsed) {
      if (isWin && status === 1 && !parsed.file) {
        return notFoundError(parsed.original, "spawn");
      }
      return null;
    }
    __name(verifyENOENT, "verifyENOENT");
    function verifyENOENTSync(status, parsed) {
      if (isWin && status === 1 && !parsed.file) {
        return notFoundError(parsed.original, "spawnSync");
      }
      return null;
    }
    __name(verifyENOENTSync, "verifyENOENTSync");
    module2.exports = {
      hookChildProcess,
      verifyENOENT,
      verifyENOENTSync,
      notFoundError
    };
  }
});

// ../../node_modules/.pnpm/cross-spawn@7.0.3/node_modules/cross-spawn/index.js
var require_cross_spawn = __commonJS({
  "../../node_modules/.pnpm/cross-spawn@7.0.3/node_modules/cross-spawn/index.js"(exports, module2) {
    "use strict";
    var cp2 = require("child_process");
    var parse = require_parse();
    var enoent = require_enoent();
    function spawn(command, args, options2) {
      const parsed = parse(command, args, options2);
      const spawned = cp2.spawn(parsed.command, parsed.args, parsed.options);
      enoent.hookChildProcess(spawned, parsed);
      return spawned;
    }
    __name(spawn, "spawn");
    function spawnSync(command, args, options2) {
      const parsed = parse(command, args, options2);
      const result = cp2.spawnSync(parsed.command, parsed.args, parsed.options);
      result.error = result.error || enoent.verifyENOENTSync(result.status, parsed);
      return result;
    }
    __name(spawnSync, "spawnSync");
    module2.exports = spawn;
    module2.exports.spawn = spawn;
    module2.exports.sync = spawnSync;
    module2.exports._parse = parse;
    module2.exports._enoent = enoent;
  }
});

// ../../node_modules/.pnpm/yocto-queue@0.1.0/node_modules/yocto-queue/index.js
var require_yocto_queue = __commonJS({
  "../../node_modules/.pnpm/yocto-queue@0.1.0/node_modules/yocto-queue/index.js"(exports, module2) {
    var Node = class {
      constructor(value) {
        this.value = value;
        this.next = void 0;
      }
    };
    __name(Node, "Node");
    var Queue = class {
      constructor() {
        this.clear();
      }
      enqueue(value) {
        const node = new Node(value);
        if (this._head) {
          this._tail.next = node;
          this._tail = node;
        } else {
          this._head = node;
          this._tail = node;
        }
        this._size++;
      }
      dequeue() {
        const current = this._head;
        if (!current) {
          return;
        }
        this._head = this._head.next;
        this._size--;
        return current.value;
      }
      clear() {
        this._head = void 0;
        this._tail = void 0;
        this._size = 0;
      }
      get size() {
        return this._size;
      }
      *[Symbol.iterator]() {
        let current = this._head;
        while (current) {
          yield current.value;
          current = current.next;
        }
      }
    };
    __name(Queue, "Queue");
    module2.exports = Queue;
  }
});

// ../../node_modules/.pnpm/p-limit@3.1.0/node_modules/p-limit/index.js
var require_p_limit = __commonJS({
  "../../node_modules/.pnpm/p-limit@3.1.0/node_modules/p-limit/index.js"(exports, module2) {
    "use strict";
    var Queue = require_yocto_queue();
    var pLimit = /* @__PURE__ */ __name((concurrency) => {
      if (!((Number.isInteger(concurrency) || concurrency === Infinity) && concurrency > 0)) {
        throw new TypeError("Expected `concurrency` to be a number from 1 and up");
      }
      const queue = new Queue();
      let activeCount = 0;
      const next = /* @__PURE__ */ __name(() => {
        activeCount--;
        if (queue.size > 0) {
          queue.dequeue()();
        }
      }, "next");
      const run = /* @__PURE__ */ __name(async (fn, resolve, ...args) => {
        activeCount++;
        const result = (async () => fn(...args))();
        resolve(result);
        try {
          await result;
        } catch {
        }
        next();
      }, "run");
      const enqueue = /* @__PURE__ */ __name((fn, resolve, ...args) => {
        queue.enqueue(run.bind(null, fn, resolve, ...args));
        (async () => {
          await Promise.resolve();
          if (activeCount < concurrency && queue.size > 0) {
            queue.dequeue()();
          }
        })();
      }, "enqueue");
      const generator2 = /* @__PURE__ */ __name((fn, ...args) => new Promise((resolve) => {
        enqueue(fn, resolve, ...args);
      }), "generator");
      Object.defineProperties(generator2, {
        activeCount: {
          get: () => activeCount
        },
        pendingCount: {
          get: () => queue.size
        },
        clearQueue: {
          value: () => {
            queue.clear();
          }
        }
      });
      return generator2;
    }, "pLimit");
    module2.exports = pLimit;
  }
});

// ../../node_modules/.pnpm/p-locate@5.0.0/node_modules/p-locate/index.js
var require_p_locate = __commonJS({
  "../../node_modules/.pnpm/p-locate@5.0.0/node_modules/p-locate/index.js"(exports, module2) {
    "use strict";
    var pLimit = require_p_limit();
    var EndError = class extends Error {
      constructor(value) {
        super();
        this.value = value;
      }
    };
    __name(EndError, "EndError");
    var testElement = /* @__PURE__ */ __name(async (element, tester) => tester(await element), "testElement");
    var finder = /* @__PURE__ */ __name(async (element) => {
      const values = await Promise.all(element);
      if (values[1] === true) {
        throw new EndError(values[0]);
      }
      return false;
    }, "finder");
    var pLocate = /* @__PURE__ */ __name(async (iterable, tester, options2) => {
      options2 = {
        concurrency: Infinity,
        preserveOrder: true,
        ...options2
      };
      const limit = pLimit(options2.concurrency);
      const items = [...iterable].map((element) => [element, limit(testElement, element, tester)]);
      const checkLimit = pLimit(options2.preserveOrder ? 1 : Infinity);
      try {
        await Promise.all(items.map((element) => checkLimit(finder, element)));
      } catch (error) {
        if (error instanceof EndError) {
          return error.value;
        }
        throw error;
      }
    }, "pLocate");
    module2.exports = pLocate;
  }
});

// ../../node_modules/.pnpm/locate-path@6.0.0/node_modules/locate-path/index.js
var require_locate_path = __commonJS({
  "../../node_modules/.pnpm/locate-path@6.0.0/node_modules/locate-path/index.js"(exports, module2) {
    "use strict";
    var path9 = require("path");
    var fs11 = require("fs");
    var { promisify: promisify5 } = require("util");
    var pLocate = require_p_locate();
    var fsStat = promisify5(fs11.stat);
    var fsLStat = promisify5(fs11.lstat);
    var typeMappings = {
      directory: "isDirectory",
      file: "isFile"
    };
    function checkType({ type }) {
      if (type in typeMappings) {
        return;
      }
      throw new Error(`Invalid type specified: ${type}`);
    }
    __name(checkType, "checkType");
    var matchType = /* @__PURE__ */ __name((type, stat2) => type === void 0 || stat2[typeMappings[type]](), "matchType");
    module2.exports = async (paths, options2) => {
      options2 = {
        cwd: process.cwd(),
        type: "file",
        allowSymlinks: true,
        ...options2
      };
      checkType(options2);
      const statFn = options2.allowSymlinks ? fsStat : fsLStat;
      return pLocate(paths, async (path_) => {
        try {
          const stat2 = await statFn(path9.resolve(options2.cwd, path_));
          return matchType(options2.type, stat2);
        } catch {
          return false;
        }
      }, options2);
    };
    module2.exports.sync = (paths, options2) => {
      options2 = {
        cwd: process.cwd(),
        allowSymlinks: true,
        type: "file",
        ...options2
      };
      checkType(options2);
      const statFn = options2.allowSymlinks ? fs11.statSync : fs11.lstatSync;
      for (const path_ of paths) {
        try {
          const stat2 = statFn(path9.resolve(options2.cwd, path_));
          if (matchType(options2.type, stat2)) {
            return path_;
          }
        } catch {
        }
      }
    };
  }
});

// ../../node_modules/.pnpm/path-exists@4.0.0/node_modules/path-exists/index.js
var require_path_exists = __commonJS({
  "../../node_modules/.pnpm/path-exists@4.0.0/node_modules/path-exists/index.js"(exports, module2) {
    "use strict";
    var fs11 = require("fs");
    var { promisify: promisify5 } = require("util");
    var pAccess = promisify5(fs11.access);
    module2.exports = async (path9) => {
      try {
        await pAccess(path9);
        return true;
      } catch (_) {
        return false;
      }
    };
    module2.exports.sync = (path9) => {
      try {
        fs11.accessSync(path9);
        return true;
      } catch (_) {
        return false;
      }
    };
  }
});

// ../../node_modules/.pnpm/find-up@5.0.0/node_modules/find-up/index.js
var require_find_up = __commonJS({
  "../../node_modules/.pnpm/find-up@5.0.0/node_modules/find-up/index.js"(exports, module2) {
    "use strict";
    var path9 = require("path");
    var locatePath = require_locate_path();
    var pathExists = require_path_exists();
    var stop = Symbol("findUp.stop");
    module2.exports = async (name, options2 = {}) => {
      let directory = path9.resolve(options2.cwd || "");
      const { root } = path9.parse(directory);
      const paths = [].concat(name);
      const runMatcher = /* @__PURE__ */ __name(async (locateOptions) => {
        if (typeof name !== "function") {
          return locatePath(paths, locateOptions);
        }
        const foundPath = await name(locateOptions.cwd);
        if (typeof foundPath === "string") {
          return locatePath([foundPath], locateOptions);
        }
        return foundPath;
      }, "runMatcher");
      while (true) {
        const foundPath = await runMatcher({ ...options2, cwd: directory });
        if (foundPath === stop) {
          return;
        }
        if (foundPath) {
          return path9.resolve(directory, foundPath);
        }
        if (directory === root) {
          return;
        }
        directory = path9.dirname(directory);
      }
    };
    module2.exports.sync = (name, options2 = {}) => {
      let directory = path9.resolve(options2.cwd || "");
      const { root } = path9.parse(directory);
      const paths = [].concat(name);
      const runMatcher = /* @__PURE__ */ __name((locateOptions) => {
        if (typeof name !== "function") {
          return locatePath.sync(paths, locateOptions);
        }
        const foundPath = name(locateOptions.cwd);
        if (typeof foundPath === "string") {
          return locatePath.sync([foundPath], locateOptions);
        }
        return foundPath;
      }, "runMatcher");
      while (true) {
        const foundPath = runMatcher({ ...options2, cwd: directory });
        if (foundPath === stop) {
          return;
        }
        if (foundPath) {
          return path9.resolve(directory, foundPath);
        }
        if (directory === root) {
          return;
        }
        directory = path9.dirname(directory);
      }
    };
    module2.exports.exists = pathExists;
    module2.exports.sync.exists = pathExists.sync;
    module2.exports.stop = stop;
  }
});

// ../../node_modules/.pnpm/strip-final-newline@2.0.0/node_modules/strip-final-newline/index.js
var require_strip_final_newline = __commonJS({
  "../../node_modules/.pnpm/strip-final-newline@2.0.0/node_modules/strip-final-newline/index.js"(exports, module2) {
    "use strict";
    module2.exports = (input) => {
      const LF = typeof input === "string" ? "\n" : "\n".charCodeAt();
      const CR = typeof input === "string" ? "\r" : "\r".charCodeAt();
      if (input[input.length - 1] === LF) {
        input = input.slice(0, input.length - 1);
      }
      if (input[input.length - 1] === CR) {
        input = input.slice(0, input.length - 1);
      }
      return input;
    };
  }
});

// ../../node_modules/.pnpm/npm-run-path@4.0.1/node_modules/npm-run-path/index.js
var require_npm_run_path = __commonJS({
  "../../node_modules/.pnpm/npm-run-path@4.0.1/node_modules/npm-run-path/index.js"(exports, module2) {
    "use strict";
    var path9 = require("path");
    var pathKey = require_path_key();
    var npmRunPath = /* @__PURE__ */ __name((options2) => {
      options2 = {
        cwd: process.cwd(),
        path: process.env[pathKey()],
        execPath: process.execPath,
        ...options2
      };
      let previous;
      let cwdPath = path9.resolve(options2.cwd);
      const result = [];
      while (previous !== cwdPath) {
        result.push(path9.join(cwdPath, "node_modules/.bin"));
        previous = cwdPath;
        cwdPath = path9.resolve(cwdPath, "..");
      }
      const execPathDir = path9.resolve(options2.cwd, options2.execPath, "..");
      result.push(execPathDir);
      return result.concat(options2.path).join(path9.delimiter);
    }, "npmRunPath");
    module2.exports = npmRunPath;
    module2.exports.default = npmRunPath;
    module2.exports.env = (options2) => {
      options2 = {
        env: process.env,
        ...options2
      };
      const env = { ...options2.env };
      const path10 = pathKey({ env });
      options2.path = env[path10];
      env[path10] = module2.exports(options2);
      return env;
    };
  }
});

// ../../node_modules/.pnpm/mimic-fn@2.1.0/node_modules/mimic-fn/index.js
var require_mimic_fn = __commonJS({
  "../../node_modules/.pnpm/mimic-fn@2.1.0/node_modules/mimic-fn/index.js"(exports, module2) {
    "use strict";
    var mimicFn = /* @__PURE__ */ __name((to, from) => {
      for (const prop of Reflect.ownKeys(from)) {
        Object.defineProperty(to, prop, Object.getOwnPropertyDescriptor(from, prop));
      }
      return to;
    }, "mimicFn");
    module2.exports = mimicFn;
    module2.exports.default = mimicFn;
  }
});

// ../../node_modules/.pnpm/onetime@5.1.2/node_modules/onetime/index.js
var require_onetime = __commonJS({
  "../../node_modules/.pnpm/onetime@5.1.2/node_modules/onetime/index.js"(exports, module2) {
    "use strict";
    var mimicFn = require_mimic_fn();
    var calledFunctions = /* @__PURE__ */ new WeakMap();
    var onetime = /* @__PURE__ */ __name((function_, options2 = {}) => {
      if (typeof function_ !== "function") {
        throw new TypeError("Expected a function");
      }
      let returnValue;
      let callCount = 0;
      const functionName = function_.displayName || function_.name || "<anonymous>";
      const onetime2 = /* @__PURE__ */ __name(function(...arguments_) {
        calledFunctions.set(onetime2, ++callCount);
        if (callCount === 1) {
          returnValue = function_.apply(this, arguments_);
          function_ = null;
        } else if (options2.throw === true) {
          throw new Error(`Function \`${functionName}\` can only be called once`);
        }
        return returnValue;
      }, "onetime");
      mimicFn(onetime2, function_);
      calledFunctions.set(onetime2, callCount);
      return onetime2;
    }, "onetime");
    module2.exports = onetime;
    module2.exports.default = onetime;
    module2.exports.callCount = (function_) => {
      if (!calledFunctions.has(function_)) {
        throw new Error(`The given function \`${function_.name}\` is not wrapped by the \`onetime\` package`);
      }
      return calledFunctions.get(function_);
    };
  }
});

// ../../node_modules/.pnpm/human-signals@2.1.0/node_modules/human-signals/build/src/core.js
var require_core = __commonJS({
  "../../node_modules/.pnpm/human-signals@2.1.0/node_modules/human-signals/build/src/core.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.SIGNALS = void 0;
    var SIGNALS = [
      {
        name: "SIGHUP",
        number: 1,
        action: "terminate",
        description: "Terminal closed",
        standard: "posix"
      },
      {
        name: "SIGINT",
        number: 2,
        action: "terminate",
        description: "User interruption with CTRL-C",
        standard: "ansi"
      },
      {
        name: "SIGQUIT",
        number: 3,
        action: "core",
        description: "User interruption with CTRL-\\",
        standard: "posix"
      },
      {
        name: "SIGILL",
        number: 4,
        action: "core",
        description: "Invalid machine instruction",
        standard: "ansi"
      },
      {
        name: "SIGTRAP",
        number: 5,
        action: "core",
        description: "Debugger breakpoint",
        standard: "posix"
      },
      {
        name: "SIGABRT",
        number: 6,
        action: "core",
        description: "Aborted",
        standard: "ansi"
      },
      {
        name: "SIGIOT",
        number: 6,
        action: "core",
        description: "Aborted",
        standard: "bsd"
      },
      {
        name: "SIGBUS",
        number: 7,
        action: "core",
        description: "Bus error due to misaligned, non-existing address or paging error",
        standard: "bsd"
      },
      {
        name: "SIGEMT",
        number: 7,
        action: "terminate",
        description: "Command should be emulated but is not implemented",
        standard: "other"
      },
      {
        name: "SIGFPE",
        number: 8,
        action: "core",
        description: "Floating point arithmetic error",
        standard: "ansi"
      },
      {
        name: "SIGKILL",
        number: 9,
        action: "terminate",
        description: "Forced termination",
        standard: "posix",
        forced: true
      },
      {
        name: "SIGUSR1",
        number: 10,
        action: "terminate",
        description: "Application-specific signal",
        standard: "posix"
      },
      {
        name: "SIGSEGV",
        number: 11,
        action: "core",
        description: "Segmentation fault",
        standard: "ansi"
      },
      {
        name: "SIGUSR2",
        number: 12,
        action: "terminate",
        description: "Application-specific signal",
        standard: "posix"
      },
      {
        name: "SIGPIPE",
        number: 13,
        action: "terminate",
        description: "Broken pipe or socket",
        standard: "posix"
      },
      {
        name: "SIGALRM",
        number: 14,
        action: "terminate",
        description: "Timeout or timer",
        standard: "posix"
      },
      {
        name: "SIGTERM",
        number: 15,
        action: "terminate",
        description: "Termination",
        standard: "ansi"
      },
      {
        name: "SIGSTKFLT",
        number: 16,
        action: "terminate",
        description: "Stack is empty or overflowed",
        standard: "other"
      },
      {
        name: "SIGCHLD",
        number: 17,
        action: "ignore",
        description: "Child process terminated, paused or unpaused",
        standard: "posix"
      },
      {
        name: "SIGCLD",
        number: 17,
        action: "ignore",
        description: "Child process terminated, paused or unpaused",
        standard: "other"
      },
      {
        name: "SIGCONT",
        number: 18,
        action: "unpause",
        description: "Unpaused",
        standard: "posix",
        forced: true
      },
      {
        name: "SIGSTOP",
        number: 19,
        action: "pause",
        description: "Paused",
        standard: "posix",
        forced: true
      },
      {
        name: "SIGTSTP",
        number: 20,
        action: "pause",
        description: 'Paused using CTRL-Z or "suspend"',
        standard: "posix"
      },
      {
        name: "SIGTTIN",
        number: 21,
        action: "pause",
        description: "Background process cannot read terminal input",
        standard: "posix"
      },
      {
        name: "SIGBREAK",
        number: 21,
        action: "terminate",
        description: "User interruption with CTRL-BREAK",
        standard: "other"
      },
      {
        name: "SIGTTOU",
        number: 22,
        action: "pause",
        description: "Background process cannot write to terminal output",
        standard: "posix"
      },
      {
        name: "SIGURG",
        number: 23,
        action: "ignore",
        description: "Socket received out-of-band data",
        standard: "bsd"
      },
      {
        name: "SIGXCPU",
        number: 24,
        action: "core",
        description: "Process timed out",
        standard: "bsd"
      },
      {
        name: "SIGXFSZ",
        number: 25,
        action: "core",
        description: "File too big",
        standard: "bsd"
      },
      {
        name: "SIGVTALRM",
        number: 26,
        action: "terminate",
        description: "Timeout or timer",
        standard: "bsd"
      },
      {
        name: "SIGPROF",
        number: 27,
        action: "terminate",
        description: "Timeout or timer",
        standard: "bsd"
      },
      {
        name: "SIGWINCH",
        number: 28,
        action: "ignore",
        description: "Terminal window size changed",
        standard: "bsd"
      },
      {
        name: "SIGIO",
        number: 29,
        action: "terminate",
        description: "I/O is available",
        standard: "other"
      },
      {
        name: "SIGPOLL",
        number: 29,
        action: "terminate",
        description: "Watched event",
        standard: "other"
      },
      {
        name: "SIGINFO",
        number: 29,
        action: "ignore",
        description: "Request for process information",
        standard: "other"
      },
      {
        name: "SIGPWR",
        number: 30,
        action: "terminate",
        description: "Device running out of power",
        standard: "systemv"
      },
      {
        name: "SIGSYS",
        number: 31,
        action: "core",
        description: "Invalid system call",
        standard: "other"
      },
      {
        name: "SIGUNUSED",
        number: 31,
        action: "terminate",
        description: "Invalid system call",
        standard: "other"
      }
    ];
    exports.SIGNALS = SIGNALS;
  }
});

// ../../node_modules/.pnpm/human-signals@2.1.0/node_modules/human-signals/build/src/realtime.js
var require_realtime = __commonJS({
  "../../node_modules/.pnpm/human-signals@2.1.0/node_modules/human-signals/build/src/realtime.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.SIGRTMAX = exports.getRealtimeSignals = void 0;
    var getRealtimeSignals = /* @__PURE__ */ __name(function() {
      const length = SIGRTMAX - SIGRTMIN + 1;
      return Array.from({ length }, getRealtimeSignal);
    }, "getRealtimeSignals");
    exports.getRealtimeSignals = getRealtimeSignals;
    var getRealtimeSignal = /* @__PURE__ */ __name(function(value, index) {
      return {
        name: `SIGRT${index + 1}`,
        number: SIGRTMIN + index,
        action: "terminate",
        description: "Application-specific signal (realtime)",
        standard: "posix"
      };
    }, "getRealtimeSignal");
    var SIGRTMIN = 34;
    var SIGRTMAX = 64;
    exports.SIGRTMAX = SIGRTMAX;
  }
});

// ../../node_modules/.pnpm/human-signals@2.1.0/node_modules/human-signals/build/src/signals.js
var require_signals = __commonJS({
  "../../node_modules/.pnpm/human-signals@2.1.0/node_modules/human-signals/build/src/signals.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.getSignals = void 0;
    var _os = require("os");
    var _core = require_core();
    var _realtime = require_realtime();
    var getSignals = /* @__PURE__ */ __name(function() {
      const realtimeSignals = (0, _realtime.getRealtimeSignals)();
      const signals = [..._core.SIGNALS, ...realtimeSignals].map(normalizeSignal);
      return signals;
    }, "getSignals");
    exports.getSignals = getSignals;
    var normalizeSignal = /* @__PURE__ */ __name(function({
      name,
      number: defaultNumber,
      description,
      action,
      forced = false,
      standard
    }) {
      const {
        signals: { [name]: constantSignal }
      } = _os.constants;
      const supported = constantSignal !== void 0;
      const number = supported ? constantSignal : defaultNumber;
      return { name, number, description, supported, action, forced, standard };
    }, "normalizeSignal");
  }
});

// ../../node_modules/.pnpm/human-signals@2.1.0/node_modules/human-signals/build/src/main.js
var require_main = __commonJS({
  "../../node_modules/.pnpm/human-signals@2.1.0/node_modules/human-signals/build/src/main.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.signalsByNumber = exports.signalsByName = void 0;
    var _os = require("os");
    var _signals = require_signals();
    var _realtime = require_realtime();
    var getSignalsByName = /* @__PURE__ */ __name(function() {
      const signals = (0, _signals.getSignals)();
      return signals.reduce(getSignalByName, {});
    }, "getSignalsByName");
    var getSignalByName = /* @__PURE__ */ __name(function(signalByNameMemo, { name, number, description, supported, action, forced, standard }) {
      return {
        ...signalByNameMemo,
        [name]: { name, number, description, supported, action, forced, standard }
      };
    }, "getSignalByName");
    var signalsByName = getSignalsByName();
    exports.signalsByName = signalsByName;
    var getSignalsByNumber = /* @__PURE__ */ __name(function() {
      const signals = (0, _signals.getSignals)();
      const length = _realtime.SIGRTMAX + 1;
      const signalsA = Array.from({ length }, (value, number) => getSignalByNumber(number, signals));
      return Object.assign({}, ...signalsA);
    }, "getSignalsByNumber");
    var getSignalByNumber = /* @__PURE__ */ __name(function(number, signals) {
      const signal = findSignalByNumber(number, signals);
      if (signal === void 0) {
        return {};
      }
      const { name, description, supported, action, forced, standard } = signal;
      return {
        [number]: {
          name,
          number,
          description,
          supported,
          action,
          forced,
          standard
        }
      };
    }, "getSignalByNumber");
    var findSignalByNumber = /* @__PURE__ */ __name(function(number, signals) {
      const signal = signals.find(({ name }) => _os.constants.signals[name] === number);
      if (signal !== void 0) {
        return signal;
      }
      return signals.find((signalA) => signalA.number === number);
    }, "findSignalByNumber");
    var signalsByNumber = getSignalsByNumber();
    exports.signalsByNumber = signalsByNumber;
  }
});

// ../../node_modules/.pnpm/execa@5.1.1/node_modules/execa/lib/error.js
var require_error = __commonJS({
  "../../node_modules/.pnpm/execa@5.1.1/node_modules/execa/lib/error.js"(exports, module2) {
    "use strict";
    var { signalsByName } = require_main();
    var getErrorPrefix = /* @__PURE__ */ __name(({ timedOut, timeout, errorCode, signal, signalDescription, exitCode, isCanceled }) => {
      if (timedOut) {
        return `timed out after ${timeout} milliseconds`;
      }
      if (isCanceled) {
        return "was canceled";
      }
      if (errorCode !== void 0) {
        return `failed with ${errorCode}`;
      }
      if (signal !== void 0) {
        return `was killed with ${signal} (${signalDescription})`;
      }
      if (exitCode !== void 0) {
        return `failed with exit code ${exitCode}`;
      }
      return "failed";
    }, "getErrorPrefix");
    var makeError = /* @__PURE__ */ __name(({
      stdout,
      stderr,
      all,
      error,
      signal,
      exitCode,
      command,
      escapedCommand,
      timedOut,
      isCanceled,
      killed,
      parsed: { options: { timeout } }
    }) => {
      exitCode = exitCode === null ? void 0 : exitCode;
      signal = signal === null ? void 0 : signal;
      const signalDescription = signal === void 0 ? void 0 : signalsByName[signal].description;
      const errorCode = error && error.code;
      const prefix = getErrorPrefix({ timedOut, timeout, errorCode, signal, signalDescription, exitCode, isCanceled });
      const execaMessage = `Command ${prefix}: ${command}`;
      const isError = Object.prototype.toString.call(error) === "[object Error]";
      const shortMessage = isError ? `${execaMessage}
${error.message}` : execaMessage;
      const message = [shortMessage, stderr, stdout].filter(Boolean).join("\n");
      if (isError) {
        error.originalMessage = error.message;
        error.message = message;
      } else {
        error = new Error(message);
      }
      error.shortMessage = shortMessage;
      error.command = command;
      error.escapedCommand = escapedCommand;
      error.exitCode = exitCode;
      error.signal = signal;
      error.signalDescription = signalDescription;
      error.stdout = stdout;
      error.stderr = stderr;
      if (all !== void 0) {
        error.all = all;
      }
      if ("bufferedData" in error) {
        delete error.bufferedData;
      }
      error.failed = true;
      error.timedOut = Boolean(timedOut);
      error.isCanceled = isCanceled;
      error.killed = killed && !timedOut;
      return error;
    }, "makeError");
    module2.exports = makeError;
  }
});

// ../../node_modules/.pnpm/execa@5.1.1/node_modules/execa/lib/stdio.js
var require_stdio = __commonJS({
  "../../node_modules/.pnpm/execa@5.1.1/node_modules/execa/lib/stdio.js"(exports, module2) {
    "use strict";
    var aliases = ["stdin", "stdout", "stderr"];
    var hasAlias = /* @__PURE__ */ __name((options2) => aliases.some((alias) => options2[alias] !== void 0), "hasAlias");
    var normalizeStdio = /* @__PURE__ */ __name((options2) => {
      if (!options2) {
        return;
      }
      const { stdio } = options2;
      if (stdio === void 0) {
        return aliases.map((alias) => options2[alias]);
      }
      if (hasAlias(options2)) {
        throw new Error(`It's not possible to provide \`stdio\` in combination with one of ${aliases.map((alias) => `\`${alias}\``).join(", ")}`);
      }
      if (typeof stdio === "string") {
        return stdio;
      }
      if (!Array.isArray(stdio)) {
        throw new TypeError(`Expected \`stdio\` to be of type \`string\` or \`Array\`, got \`${typeof stdio}\``);
      }
      const length = Math.max(stdio.length, aliases.length);
      return Array.from({ length }, (value, index) => stdio[index]);
    }, "normalizeStdio");
    module2.exports = normalizeStdio;
    module2.exports.node = (options2) => {
      const stdio = normalizeStdio(options2);
      if (stdio === "ipc") {
        return "ipc";
      }
      if (stdio === void 0 || typeof stdio === "string") {
        return [stdio, stdio, stdio, "ipc"];
      }
      if (stdio.includes("ipc")) {
        return stdio;
      }
      return [...stdio, "ipc"];
    };
  }
});

// ../../node_modules/.pnpm/signal-exit@3.0.7/node_modules/signal-exit/signals.js
var require_signals2 = __commonJS({
  "../../node_modules/.pnpm/signal-exit@3.0.7/node_modules/signal-exit/signals.js"(exports, module2) {
    module2.exports = [
      "SIGABRT",
      "SIGALRM",
      "SIGHUP",
      "SIGINT",
      "SIGTERM"
    ];
    if (process.platform !== "win32") {
      module2.exports.push(
        "SIGVTALRM",
        "SIGXCPU",
        "SIGXFSZ",
        "SIGUSR2",
        "SIGTRAP",
        "SIGSYS",
        "SIGQUIT",
        "SIGIOT"
      );
    }
    if (process.platform === "linux") {
      module2.exports.push(
        "SIGIO",
        "SIGPOLL",
        "SIGPWR",
        "SIGSTKFLT",
        "SIGUNUSED"
      );
    }
  }
});

// ../../node_modules/.pnpm/signal-exit@3.0.7/node_modules/signal-exit/index.js
var require_signal_exit = __commonJS({
  "../../node_modules/.pnpm/signal-exit@3.0.7/node_modules/signal-exit/index.js"(exports, module2) {
    var process2 = global.process;
    var processOk = /* @__PURE__ */ __name(function(process3) {
      return process3 && typeof process3 === "object" && typeof process3.removeListener === "function" && typeof process3.emit === "function" && typeof process3.reallyExit === "function" && typeof process3.listeners === "function" && typeof process3.kill === "function" && typeof process3.pid === "number" && typeof process3.on === "function";
    }, "processOk");
    if (!processOk(process2)) {
      module2.exports = function() {
        return function() {
        };
      };
    } else {
      assert = require("assert");
      signals = require_signals2();
      isWin = /^win/i.test(process2.platform);
      EE = require("events");
      if (typeof EE !== "function") {
        EE = EE.EventEmitter;
      }
      if (process2.__signal_exit_emitter__) {
        emitter = process2.__signal_exit_emitter__;
      } else {
        emitter = process2.__signal_exit_emitter__ = new EE();
        emitter.count = 0;
        emitter.emitted = {};
      }
      if (!emitter.infinite) {
        emitter.setMaxListeners(Infinity);
        emitter.infinite = true;
      }
      module2.exports = function(cb, opts) {
        if (!processOk(global.process)) {
          return function() {
          };
        }
        assert.equal(typeof cb, "function", "a callback must be provided for exit handler");
        if (loaded === false) {
          load();
        }
        var ev = "exit";
        if (opts && opts.alwaysLast) {
          ev = "afterexit";
        }
        var remove2 = /* @__PURE__ */ __name(function() {
          emitter.removeListener(ev, cb);
          if (emitter.listeners("exit").length === 0 && emitter.listeners("afterexit").length === 0) {
            unload();
          }
        }, "remove");
        emitter.on(ev, cb);
        return remove2;
      };
      unload = /* @__PURE__ */ __name(function unload2() {
        if (!loaded || !processOk(global.process)) {
          return;
        }
        loaded = false;
        signals.forEach(function(sig) {
          try {
            process2.removeListener(sig, sigListeners[sig]);
          } catch (er) {
          }
        });
        process2.emit = originalProcessEmit;
        process2.reallyExit = originalProcessReallyExit;
        emitter.count -= 1;
      }, "unload");
      module2.exports.unload = unload;
      emit = /* @__PURE__ */ __name(function emit2(event, code, signal) {
        if (emitter.emitted[event]) {
          return;
        }
        emitter.emitted[event] = true;
        emitter.emit(event, code, signal);
      }, "emit");
      sigListeners = {};
      signals.forEach(function(sig) {
        sigListeners[sig] = /* @__PURE__ */ __name(function listener() {
          if (!processOk(global.process)) {
            return;
          }
          var listeners = process2.listeners(sig);
          if (listeners.length === emitter.count) {
            unload();
            emit("exit", null, sig);
            emit("afterexit", null, sig);
            if (isWin && sig === "SIGHUP") {
              sig = "SIGINT";
            }
            process2.kill(process2.pid, sig);
          }
        }, "listener");
      });
      module2.exports.signals = function() {
        return signals;
      };
      loaded = false;
      load = /* @__PURE__ */ __name(function load2() {
        if (loaded || !processOk(global.process)) {
          return;
        }
        loaded = true;
        emitter.count += 1;
        signals = signals.filter(function(sig) {
          try {
            process2.on(sig, sigListeners[sig]);
            return true;
          } catch (er) {
            return false;
          }
        });
        process2.emit = processEmit;
        process2.reallyExit = processReallyExit;
      }, "load");
      module2.exports.load = load;
      originalProcessReallyExit = process2.reallyExit;
      processReallyExit = /* @__PURE__ */ __name(function processReallyExit2(code) {
        if (!processOk(global.process)) {
          return;
        }
        process2.exitCode = code || 0;
        emit("exit", process2.exitCode, null);
        emit("afterexit", process2.exitCode, null);
        originalProcessReallyExit.call(process2, process2.exitCode);
      }, "processReallyExit");
      originalProcessEmit = process2.emit;
      processEmit = /* @__PURE__ */ __name(function processEmit2(ev, arg) {
        if (ev === "exit" && processOk(global.process)) {
          if (arg !== void 0) {
            process2.exitCode = arg;
          }
          var ret = originalProcessEmit.apply(this, arguments);
          emit("exit", process2.exitCode, null);
          emit("afterexit", process2.exitCode, null);
          return ret;
        } else {
          return originalProcessEmit.apply(this, arguments);
        }
      }, "processEmit");
    }
    var assert;
    var signals;
    var isWin;
    var EE;
    var emitter;
    var unload;
    var emit;
    var sigListeners;
    var loaded;
    var load;
    var originalProcessReallyExit;
    var processReallyExit;
    var originalProcessEmit;
    var processEmit;
  }
});

// ../../node_modules/.pnpm/execa@5.1.1/node_modules/execa/lib/kill.js
var require_kill = __commonJS({
  "../../node_modules/.pnpm/execa@5.1.1/node_modules/execa/lib/kill.js"(exports, module2) {
    "use strict";
    var os2 = require("os");
    var onExit = require_signal_exit();
    var DEFAULT_FORCE_KILL_TIMEOUT = 1e3 * 5;
    var spawnedKill = /* @__PURE__ */ __name((kill, signal = "SIGTERM", options2 = {}) => {
      const killResult = kill(signal);
      setKillTimeout(kill, signal, options2, killResult);
      return killResult;
    }, "spawnedKill");
    var setKillTimeout = /* @__PURE__ */ __name((kill, signal, options2, killResult) => {
      if (!shouldForceKill(signal, options2, killResult)) {
        return;
      }
      const timeout = getForceKillAfterTimeout(options2);
      const t3 = setTimeout(() => {
        kill("SIGKILL");
      }, timeout);
      if (t3.unref) {
        t3.unref();
      }
    }, "setKillTimeout");
    var shouldForceKill = /* @__PURE__ */ __name((signal, { forceKillAfterTimeout }, killResult) => {
      return isSigterm(signal) && forceKillAfterTimeout !== false && killResult;
    }, "shouldForceKill");
    var isSigterm = /* @__PURE__ */ __name((signal) => {
      return signal === os2.constants.signals.SIGTERM || typeof signal === "string" && signal.toUpperCase() === "SIGTERM";
    }, "isSigterm");
    var getForceKillAfterTimeout = /* @__PURE__ */ __name(({ forceKillAfterTimeout = true }) => {
      if (forceKillAfterTimeout === true) {
        return DEFAULT_FORCE_KILL_TIMEOUT;
      }
      if (!Number.isFinite(forceKillAfterTimeout) || forceKillAfterTimeout < 0) {
        throw new TypeError(`Expected the \`forceKillAfterTimeout\` option to be a non-negative integer, got \`${forceKillAfterTimeout}\` (${typeof forceKillAfterTimeout})`);
      }
      return forceKillAfterTimeout;
    }, "getForceKillAfterTimeout");
    var spawnedCancel = /* @__PURE__ */ __name((spawned, context) => {
      const killResult = spawned.kill();
      if (killResult) {
        context.isCanceled = true;
      }
    }, "spawnedCancel");
    var timeoutKill = /* @__PURE__ */ __name((spawned, signal, reject) => {
      spawned.kill(signal);
      reject(Object.assign(new Error("Timed out"), { timedOut: true, signal }));
    }, "timeoutKill");
    var setupTimeout = /* @__PURE__ */ __name((spawned, { timeout, killSignal = "SIGTERM" }, spawnedPromise) => {
      if (timeout === 0 || timeout === void 0) {
        return spawnedPromise;
      }
      let timeoutId;
      const timeoutPromise = new Promise((resolve, reject) => {
        timeoutId = setTimeout(() => {
          timeoutKill(spawned, killSignal, reject);
        }, timeout);
      });
      const safeSpawnedPromise = spawnedPromise.finally(() => {
        clearTimeout(timeoutId);
      });
      return Promise.race([timeoutPromise, safeSpawnedPromise]);
    }, "setupTimeout");
    var validateTimeout = /* @__PURE__ */ __name(({ timeout }) => {
      if (timeout !== void 0 && (!Number.isFinite(timeout) || timeout < 0)) {
        throw new TypeError(`Expected the \`timeout\` option to be a non-negative integer, got \`${timeout}\` (${typeof timeout})`);
      }
    }, "validateTimeout");
    var setExitHandler = /* @__PURE__ */ __name(async (spawned, { cleanup, detached }, timedPromise) => {
      if (!cleanup || detached) {
        return timedPromise;
      }
      const removeExitHandler = onExit(() => {
        spawned.kill();
      });
      return timedPromise.finally(() => {
        removeExitHandler();
      });
    }, "setExitHandler");
    module2.exports = {
      spawnedKill,
      spawnedCancel,
      setupTimeout,
      validateTimeout,
      setExitHandler
    };
  }
});

// ../../node_modules/.pnpm/is-stream@2.0.1/node_modules/is-stream/index.js
var require_is_stream = __commonJS({
  "../../node_modules/.pnpm/is-stream@2.0.1/node_modules/is-stream/index.js"(exports, module2) {
    "use strict";
    var isStream = /* @__PURE__ */ __name((stream2) => stream2 !== null && typeof stream2 === "object" && typeof stream2.pipe === "function", "isStream");
    isStream.writable = (stream2) => isStream(stream2) && stream2.writable !== false && typeof stream2._write === "function" && typeof stream2._writableState === "object";
    isStream.readable = (stream2) => isStream(stream2) && stream2.readable !== false && typeof stream2._read === "function" && typeof stream2._readableState === "object";
    isStream.duplex = (stream2) => isStream.writable(stream2) && isStream.readable(stream2);
    isStream.transform = (stream2) => isStream.duplex(stream2) && typeof stream2._transform === "function";
    module2.exports = isStream;
  }
});

// ../../node_modules/.pnpm/get-stream@6.0.1/node_modules/get-stream/buffer-stream.js
var require_buffer_stream = __commonJS({
  "../../node_modules/.pnpm/get-stream@6.0.1/node_modules/get-stream/buffer-stream.js"(exports, module2) {
    "use strict";
    var { PassThrough: PassThroughStream } = require("stream");
    module2.exports = (options2) => {
      options2 = { ...options2 };
      const { array: array2 } = options2;
      let { encoding } = options2;
      const isBuffer = encoding === "buffer";
      let objectMode = false;
      if (array2) {
        objectMode = !(encoding || isBuffer);
      } else {
        encoding = encoding || "utf8";
      }
      if (isBuffer) {
        encoding = null;
      }
      const stream2 = new PassThroughStream({ objectMode });
      if (encoding) {
        stream2.setEncoding(encoding);
      }
      let length = 0;
      const chunks = [];
      stream2.on("data", (chunk) => {
        chunks.push(chunk);
        if (objectMode) {
          length = chunks.length;
        } else {
          length += chunk.length;
        }
      });
      stream2.getBufferedValue = () => {
        if (array2) {
          return chunks;
        }
        return isBuffer ? Buffer.concat(chunks, length) : chunks.join("");
      };
      stream2.getBufferedLength = () => length;
      return stream2;
    };
  }
});

// ../../node_modules/.pnpm/get-stream@6.0.1/node_modules/get-stream/index.js
var require_get_stream = __commonJS({
  "../../node_modules/.pnpm/get-stream@6.0.1/node_modules/get-stream/index.js"(exports, module2) {
    "use strict";
    var { constants: BufferConstants } = require("buffer");
    var stream2 = require("stream");
    var { promisify: promisify5 } = require("util");
    var bufferStream = require_buffer_stream();
    var streamPipelinePromisified = promisify5(stream2.pipeline);
    var MaxBufferError = class extends Error {
      constructor() {
        super("maxBuffer exceeded");
        this.name = "MaxBufferError";
      }
    };
    __name(MaxBufferError, "MaxBufferError");
    async function getStream(inputStream, options2) {
      if (!inputStream) {
        throw new Error("Expected a stream");
      }
      options2 = {
        maxBuffer: Infinity,
        ...options2
      };
      const { maxBuffer } = options2;
      const stream3 = bufferStream(options2);
      await new Promise((resolve, reject) => {
        const rejectPromise = /* @__PURE__ */ __name((error) => {
          if (error && stream3.getBufferedLength() <= BufferConstants.MAX_LENGTH) {
            error.bufferedData = stream3.getBufferedValue();
          }
          reject(error);
        }, "rejectPromise");
        (async () => {
          try {
            await streamPipelinePromisified(inputStream, stream3);
            resolve();
          } catch (error) {
            rejectPromise(error);
          }
        })();
        stream3.on("data", () => {
          if (stream3.getBufferedLength() > maxBuffer) {
            rejectPromise(new MaxBufferError());
          }
        });
      });
      return stream3.getBufferedValue();
    }
    __name(getStream, "getStream");
    module2.exports = getStream;
    module2.exports.buffer = (stream3, options2) => getStream(stream3, { ...options2, encoding: "buffer" });
    module2.exports.array = (stream3, options2) => getStream(stream3, { ...options2, array: true });
    module2.exports.MaxBufferError = MaxBufferError;
  }
});

// ../../node_modules/.pnpm/merge-stream@2.0.0/node_modules/merge-stream/index.js
var require_merge_stream = __commonJS({
  "../../node_modules/.pnpm/merge-stream@2.0.0/node_modules/merge-stream/index.js"(exports, module2) {
    "use strict";
    var { PassThrough } = require("stream");
    module2.exports = function() {
      var sources = [];
      var output = new PassThrough({ objectMode: true });
      output.setMaxListeners(0);
      output.add = add2;
      output.isEmpty = isEmpty;
      output.on("unpipe", remove2);
      Array.prototype.slice.call(arguments).forEach(add2);
      return output;
      function add2(source) {
        if (Array.isArray(source)) {
          source.forEach(add2);
          return this;
        }
        sources.push(source);
        source.once("end", remove2.bind(null, source));
        source.once("error", output.emit.bind(output, "error"));
        source.pipe(output, { end: false });
        return this;
      }
      __name(add2, "add");
      function isEmpty() {
        return sources.length == 0;
      }
      __name(isEmpty, "isEmpty");
      function remove2(source) {
        sources = sources.filter(function(it) {
          return it !== source;
        });
        if (!sources.length && output.readable) {
          output.end();
        }
      }
      __name(remove2, "remove");
    };
  }
});

// ../../node_modules/.pnpm/execa@5.1.1/node_modules/execa/lib/stream.js
var require_stream = __commonJS({
  "../../node_modules/.pnpm/execa@5.1.1/node_modules/execa/lib/stream.js"(exports, module2) {
    "use strict";
    var isStream = require_is_stream();
    var getStream = require_get_stream();
    var mergeStream = require_merge_stream();
    var handleInput = /* @__PURE__ */ __name((spawned, input) => {
      if (input === void 0 || spawned.stdin === void 0) {
        return;
      }
      if (isStream(input)) {
        input.pipe(spawned.stdin);
      } else {
        spawned.stdin.end(input);
      }
    }, "handleInput");
    var makeAllStream = /* @__PURE__ */ __name((spawned, { all }) => {
      if (!all || !spawned.stdout && !spawned.stderr) {
        return;
      }
      const mixed = mergeStream();
      if (spawned.stdout) {
        mixed.add(spawned.stdout);
      }
      if (spawned.stderr) {
        mixed.add(spawned.stderr);
      }
      return mixed;
    }, "makeAllStream");
    var getBufferedData = /* @__PURE__ */ __name(async (stream2, streamPromise) => {
      if (!stream2) {
        return;
      }
      stream2.destroy();
      try {
        return await streamPromise;
      } catch (error) {
        return error.bufferedData;
      }
    }, "getBufferedData");
    var getStreamPromise = /* @__PURE__ */ __name((stream2, { encoding, buffer, maxBuffer }) => {
      if (!stream2 || !buffer) {
        return;
      }
      if (encoding) {
        return getStream(stream2, { encoding, maxBuffer });
      }
      return getStream.buffer(stream2, { maxBuffer });
    }, "getStreamPromise");
    var getSpawnedResult = /* @__PURE__ */ __name(async ({ stdout, stderr, all }, { encoding, buffer, maxBuffer }, processDone) => {
      const stdoutPromise = getStreamPromise(stdout, { encoding, buffer, maxBuffer });
      const stderrPromise = getStreamPromise(stderr, { encoding, buffer, maxBuffer });
      const allPromise = getStreamPromise(all, { encoding, buffer, maxBuffer: maxBuffer * 2 });
      try {
        return await Promise.all([processDone, stdoutPromise, stderrPromise, allPromise]);
      } catch (error) {
        return Promise.all([
          { error, signal: error.signal, timedOut: error.timedOut },
          getBufferedData(stdout, stdoutPromise),
          getBufferedData(stderr, stderrPromise),
          getBufferedData(all, allPromise)
        ]);
      }
    }, "getSpawnedResult");
    var validateInputSync = /* @__PURE__ */ __name(({ input }) => {
      if (isStream(input)) {
        throw new TypeError("The `input` option cannot be a stream in sync mode");
      }
    }, "validateInputSync");
    module2.exports = {
      handleInput,
      makeAllStream,
      getSpawnedResult,
      validateInputSync
    };
  }
});

// ../../node_modules/.pnpm/execa@5.1.1/node_modules/execa/lib/promise.js
var require_promise = __commonJS({
  "../../node_modules/.pnpm/execa@5.1.1/node_modules/execa/lib/promise.js"(exports, module2) {
    "use strict";
    var nativePromisePrototype = (async () => {
    })().constructor.prototype;
    var descriptors = ["then", "catch", "finally"].map((property2) => [
      property2,
      Reflect.getOwnPropertyDescriptor(nativePromisePrototype, property2)
    ]);
    var mergePromise = /* @__PURE__ */ __name((spawned, promise2) => {
      for (const [property2, descriptor] of descriptors) {
        const value = typeof promise2 === "function" ? (...args) => Reflect.apply(descriptor.value, promise2(), args) : descriptor.value.bind(promise2);
        Reflect.defineProperty(spawned, property2, { ...descriptor, value });
      }
      return spawned;
    }, "mergePromise");
    var getSpawnedPromise = /* @__PURE__ */ __name((spawned) => {
      return new Promise((resolve, reject) => {
        spawned.on("exit", (exitCode, signal) => {
          resolve({ exitCode, signal });
        });
        spawned.on("error", (error) => {
          reject(error);
        });
        if (spawned.stdin) {
          spawned.stdin.on("error", (error) => {
            reject(error);
          });
        }
      });
    }, "getSpawnedPromise");
    module2.exports = {
      mergePromise,
      getSpawnedPromise
    };
  }
});

// ../../node_modules/.pnpm/execa@5.1.1/node_modules/execa/lib/command.js
var require_command = __commonJS({
  "../../node_modules/.pnpm/execa@5.1.1/node_modules/execa/lib/command.js"(exports, module2) {
    "use strict";
    var normalizeArgs = /* @__PURE__ */ __name((file2, args = []) => {
      if (!Array.isArray(args)) {
        return [file2];
      }
      return [file2, ...args];
    }, "normalizeArgs");
    var NO_ESCAPE_REGEXP = /^[\w.-]+$/;
    var DOUBLE_QUOTES_REGEXP = /"/g;
    var escapeArg = /* @__PURE__ */ __name((arg) => {
      if (typeof arg !== "string" || NO_ESCAPE_REGEXP.test(arg)) {
        return arg;
      }
      return `"${arg.replace(DOUBLE_QUOTES_REGEXP, '\\"')}"`;
    }, "escapeArg");
    var joinCommand = /* @__PURE__ */ __name((file2, args) => {
      return normalizeArgs(file2, args).join(" ");
    }, "joinCommand");
    var getEscapedCommand = /* @__PURE__ */ __name((file2, args) => {
      return normalizeArgs(file2, args).map((arg) => escapeArg(arg)).join(" ");
    }, "getEscapedCommand");
    var SPACES_REGEXP = / +/g;
    var parseCommand = /* @__PURE__ */ __name((command) => {
      const tokens = [];
      for (const token of command.trim().split(SPACES_REGEXP)) {
        const previousToken = tokens[tokens.length - 1];
        if (previousToken && previousToken.endsWith("\\")) {
          tokens[tokens.length - 1] = `${previousToken.slice(0, -1)} ${token}`;
        } else {
          tokens.push(token);
        }
      }
      return tokens;
    }, "parseCommand");
    module2.exports = {
      joinCommand,
      getEscapedCommand,
      parseCommand
    };
  }
});

// ../../node_modules/.pnpm/execa@5.1.1/node_modules/execa/index.js
var require_execa = __commonJS({
  "../../node_modules/.pnpm/execa@5.1.1/node_modules/execa/index.js"(exports, module2) {
    "use strict";
    var path9 = require("path");
    var childProcess = require("child_process");
    var crossSpawn = require_cross_spawn();
    var stripFinalNewline = require_strip_final_newline();
    var npmRunPath = require_npm_run_path();
    var onetime = require_onetime();
    var makeError = require_error();
    var normalizeStdio = require_stdio();
    var { spawnedKill, spawnedCancel, setupTimeout, validateTimeout, setExitHandler } = require_kill();
    var { handleInput, getSpawnedResult, makeAllStream, validateInputSync } = require_stream();
    var { mergePromise, getSpawnedPromise } = require_promise();
    var { joinCommand, parseCommand, getEscapedCommand } = require_command();
    var DEFAULT_MAX_BUFFER = 1e3 * 1e3 * 100;
    var getEnv = /* @__PURE__ */ __name(({ env: envOption, extendEnv, preferLocal, localDir, execPath }) => {
      const env = extendEnv ? { ...process.env, ...envOption } : envOption;
      if (preferLocal) {
        return npmRunPath.env({ env, cwd: localDir, execPath });
      }
      return env;
    }, "getEnv");
    var handleArguments = /* @__PURE__ */ __name((file2, args, options2 = {}) => {
      const parsed = crossSpawn._parse(file2, args, options2);
      file2 = parsed.command;
      args = parsed.args;
      options2 = parsed.options;
      options2 = {
        maxBuffer: DEFAULT_MAX_BUFFER,
        buffer: true,
        stripFinalNewline: true,
        extendEnv: true,
        preferLocal: false,
        localDir: options2.cwd || process.cwd(),
        execPath: process.execPath,
        encoding: "utf8",
        reject: true,
        cleanup: true,
        all: false,
        windowsHide: true,
        ...options2
      };
      options2.env = getEnv(options2);
      options2.stdio = normalizeStdio(options2);
      if (process.platform === "win32" && path9.basename(file2, ".exe") === "cmd") {
        args.unshift("/q");
      }
      return { file: file2, args, options: options2, parsed };
    }, "handleArguments");
    var handleOutput = /* @__PURE__ */ __name((options2, value, error) => {
      if (typeof value !== "string" && !Buffer.isBuffer(value)) {
        return error === void 0 ? void 0 : "";
      }
      if (options2.stripFinalNewline) {
        return stripFinalNewline(value);
      }
      return value;
    }, "handleOutput");
    var execa3 = /* @__PURE__ */ __name((file2, args, options2) => {
      const parsed = handleArguments(file2, args, options2);
      const command = joinCommand(file2, args);
      const escapedCommand = getEscapedCommand(file2, args);
      validateTimeout(parsed.options);
      let spawned;
      try {
        spawned = childProcess.spawn(parsed.file, parsed.args, parsed.options);
      } catch (error) {
        const dummySpawned = new childProcess.ChildProcess();
        const errorPromise = Promise.reject(makeError({
          error,
          stdout: "",
          stderr: "",
          all: "",
          command,
          escapedCommand,
          parsed,
          timedOut: false,
          isCanceled: false,
          killed: false
        }));
        return mergePromise(dummySpawned, errorPromise);
      }
      const spawnedPromise = getSpawnedPromise(spawned);
      const timedPromise = setupTimeout(spawned, parsed.options, spawnedPromise);
      const processDone = setExitHandler(spawned, parsed.options, timedPromise);
      const context = { isCanceled: false };
      spawned.kill = spawnedKill.bind(null, spawned.kill.bind(spawned));
      spawned.cancel = spawnedCancel.bind(null, spawned, context);
      const handlePromise = /* @__PURE__ */ __name(async () => {
        const [{ error, exitCode, signal, timedOut }, stdoutResult, stderrResult, allResult] = await getSpawnedResult(spawned, parsed.options, processDone);
        const stdout = handleOutput(parsed.options, stdoutResult);
        const stderr = handleOutput(parsed.options, stderrResult);
        const all = handleOutput(parsed.options, allResult);
        if (error || exitCode !== 0 || signal !== null) {
          const returnedError = makeError({
            error,
            exitCode,
            signal,
            stdout,
            stderr,
            all,
            command,
            escapedCommand,
            parsed,
            timedOut,
            isCanceled: context.isCanceled,
            killed: spawned.killed
          });
          if (!parsed.options.reject) {
            return returnedError;
          }
          throw returnedError;
        }
        return {
          command,
          escapedCommand,
          exitCode: 0,
          stdout,
          stderr,
          all,
          failed: false,
          timedOut: false,
          isCanceled: false,
          killed: false
        };
      }, "handlePromise");
      const handlePromiseOnce = onetime(handlePromise);
      handleInput(spawned, parsed.options.input);
      spawned.all = makeAllStream(spawned, parsed.options);
      return mergePromise(spawned, handlePromiseOnce);
    }, "execa");
    module2.exports = execa3;
    module2.exports.sync = (file2, args, options2) => {
      const parsed = handleArguments(file2, args, options2);
      const command = joinCommand(file2, args);
      const escapedCommand = getEscapedCommand(file2, args);
      validateInputSync(parsed.options);
      let result;
      try {
        result = childProcess.spawnSync(parsed.file, parsed.args, parsed.options);
      } catch (error) {
        throw makeError({
          error,
          stdout: "",
          stderr: "",
          all: "",
          command,
          escapedCommand,
          parsed,
          timedOut: false,
          isCanceled: false,
          killed: false
        });
      }
      const stdout = handleOutput(parsed.options, result.stdout, result.error);
      const stderr = handleOutput(parsed.options, result.stderr, result.error);
      if (result.error || result.status !== 0 || result.signal !== null) {
        const error = makeError({
          stdout,
          stderr,
          error: result.error,
          signal: result.signal,
          exitCode: result.status,
          command,
          escapedCommand,
          parsed,
          timedOut: result.error && result.error.code === "ETIMEDOUT",
          isCanceled: false,
          killed: result.signal !== null
        });
        if (!parsed.options.reject) {
          return error;
        }
        throw error;
      }
      return {
        command,
        escapedCommand,
        exitCode: 0,
        stdout,
        stderr,
        failed: false,
        timedOut: false,
        isCanceled: false,
        killed: false
      };
    };
    module2.exports.command = (command, options2) => {
      const [file2, ...args] = parseCommand(command);
      return execa3(file2, args, options2);
    };
    module2.exports.commandSync = (command, options2) => {
      const [file2, ...args] = parseCommand(command);
      return execa3.sync(file2, args, options2);
    };
    module2.exports.node = (scriptPath, args, options2 = {}) => {
      if (args && !Array.isArray(args) && typeof args === "object") {
        options2 = args;
        args = [];
      }
      const stdio = normalizeStdio.node(options2);
      const defaultExecArgv = process.execArgv.filter((arg) => !arg.startsWith("--inspect"));
      const {
        nodePath = process.execPath,
        nodeOptions = defaultExecArgv
      } = options2;
      return execa3(
        nodePath,
        [
          ...nodeOptions,
          scriptPath,
          ...Array.isArray(args) ? args : []
        ],
        {
          ...options2,
          stdin: void 0,
          stdout: void 0,
          stderr: void 0,
          stdio,
          shell: false
        }
      );
    };
  }
});

// ../../node_modules/.pnpm/p-try@2.2.0/node_modules/p-try/index.js
var require_p_try = __commonJS({
  "../../node_modules/.pnpm/p-try@2.2.0/node_modules/p-try/index.js"(exports, module2) {
    "use strict";
    var pTry = /* @__PURE__ */ __name((fn, ...arguments_) => new Promise((resolve) => {
      resolve(fn(...arguments_));
    }), "pTry");
    module2.exports = pTry;
    module2.exports.default = pTry;
  }
});

// ../../node_modules/.pnpm/p-limit@2.3.0/node_modules/p-limit/index.js
var require_p_limit2 = __commonJS({
  "../../node_modules/.pnpm/p-limit@2.3.0/node_modules/p-limit/index.js"(exports, module2) {
    "use strict";
    var pTry = require_p_try();
    var pLimit = /* @__PURE__ */ __name((concurrency) => {
      if (!((Number.isInteger(concurrency) || concurrency === Infinity) && concurrency > 0)) {
        return Promise.reject(new TypeError("Expected `concurrency` to be a number from 1 and up"));
      }
      const queue = [];
      let activeCount = 0;
      const next = /* @__PURE__ */ __name(() => {
        activeCount--;
        if (queue.length > 0) {
          queue.shift()();
        }
      }, "next");
      const run = /* @__PURE__ */ __name((fn, resolve, ...args) => {
        activeCount++;
        const result = pTry(fn, ...args);
        resolve(result);
        result.then(next, next);
      }, "run");
      const enqueue = /* @__PURE__ */ __name((fn, resolve, ...args) => {
        if (activeCount < concurrency) {
          run(fn, resolve, ...args);
        } else {
          queue.push(run.bind(null, fn, resolve, ...args));
        }
      }, "enqueue");
      const generator2 = /* @__PURE__ */ __name((fn, ...args) => new Promise((resolve) => enqueue(fn, resolve, ...args)), "generator");
      Object.defineProperties(generator2, {
        activeCount: {
          get: () => activeCount
        },
        pendingCount: {
          get: () => queue.length
        },
        clearQueue: {
          value: () => {
            queue.length = 0;
          }
        }
      });
      return generator2;
    }, "pLimit");
    module2.exports = pLimit;
    module2.exports.default = pLimit;
  }
});

// ../../node_modules/.pnpm/p-locate@4.1.0/node_modules/p-locate/index.js
var require_p_locate2 = __commonJS({
  "../../node_modules/.pnpm/p-locate@4.1.0/node_modules/p-locate/index.js"(exports, module2) {
    "use strict";
    var pLimit = require_p_limit2();
    var EndError = class extends Error {
      constructor(value) {
        super();
        this.value = value;
      }
    };
    __name(EndError, "EndError");
    var testElement = /* @__PURE__ */ __name(async (element, tester) => tester(await element), "testElement");
    var finder = /* @__PURE__ */ __name(async (element) => {
      const values = await Promise.all(element);
      if (values[1] === true) {
        throw new EndError(values[0]);
      }
      return false;
    }, "finder");
    var pLocate = /* @__PURE__ */ __name(async (iterable, tester, options2) => {
      options2 = {
        concurrency: Infinity,
        preserveOrder: true,
        ...options2
      };
      const limit = pLimit(options2.concurrency);
      const items = [...iterable].map((element) => [element, limit(testElement, element, tester)]);
      const checkLimit = pLimit(options2.preserveOrder ? 1 : Infinity);
      try {
        await Promise.all(items.map((element) => checkLimit(finder, element)));
      } catch (error) {
        if (error instanceof EndError) {
          return error.value;
        }
        throw error;
      }
    }, "pLocate");
    module2.exports = pLocate;
    module2.exports.default = pLocate;
  }
});

// ../../node_modules/.pnpm/locate-path@5.0.0/node_modules/locate-path/index.js
var require_locate_path2 = __commonJS({
  "../../node_modules/.pnpm/locate-path@5.0.0/node_modules/locate-path/index.js"(exports, module2) {
    "use strict";
    var path9 = require("path");
    var fs11 = require("fs");
    var { promisify: promisify5 } = require("util");
    var pLocate = require_p_locate2();
    var fsStat = promisify5(fs11.stat);
    var fsLStat = promisify5(fs11.lstat);
    var typeMappings = {
      directory: "isDirectory",
      file: "isFile"
    };
    function checkType({ type }) {
      if (type in typeMappings) {
        return;
      }
      throw new Error(`Invalid type specified: ${type}`);
    }
    __name(checkType, "checkType");
    var matchType = /* @__PURE__ */ __name((type, stat2) => type === void 0 || stat2[typeMappings[type]](), "matchType");
    module2.exports = async (paths, options2) => {
      options2 = {
        cwd: process.cwd(),
        type: "file",
        allowSymlinks: true,
        ...options2
      };
      checkType(options2);
      const statFn = options2.allowSymlinks ? fsStat : fsLStat;
      return pLocate(paths, async (path_) => {
        try {
          const stat2 = await statFn(path9.resolve(options2.cwd, path_));
          return matchType(options2.type, stat2);
        } catch (_) {
          return false;
        }
      }, options2);
    };
    module2.exports.sync = (paths, options2) => {
      options2 = {
        cwd: process.cwd(),
        allowSymlinks: true,
        type: "file",
        ...options2
      };
      checkType(options2);
      const statFn = options2.allowSymlinks ? fs11.statSync : fs11.lstatSync;
      for (const path_ of paths) {
        try {
          const stat2 = statFn(path9.resolve(options2.cwd, path_));
          if (matchType(options2.type, stat2)) {
            return path_;
          }
        } catch (_) {
        }
      }
    };
  }
});

// ../../node_modules/.pnpm/find-up@4.1.0/node_modules/find-up/index.js
var require_find_up2 = __commonJS({
  "../../node_modules/.pnpm/find-up@4.1.0/node_modules/find-up/index.js"(exports, module2) {
    "use strict";
    var path9 = require("path");
    var locatePath = require_locate_path2();
    var pathExists = require_path_exists();
    var stop = Symbol("findUp.stop");
    module2.exports = async (name, options2 = {}) => {
      let directory = path9.resolve(options2.cwd || "");
      const { root } = path9.parse(directory);
      const paths = [].concat(name);
      const runMatcher = /* @__PURE__ */ __name(async (locateOptions) => {
        if (typeof name !== "function") {
          return locatePath(paths, locateOptions);
        }
        const foundPath = await name(locateOptions.cwd);
        if (typeof foundPath === "string") {
          return locatePath([foundPath], locateOptions);
        }
        return foundPath;
      }, "runMatcher");
      while (true) {
        const foundPath = await runMatcher({ ...options2, cwd: directory });
        if (foundPath === stop) {
          return;
        }
        if (foundPath) {
          return path9.resolve(directory, foundPath);
        }
        if (directory === root) {
          return;
        }
        directory = path9.dirname(directory);
      }
    };
    module2.exports.sync = (name, options2 = {}) => {
      let directory = path9.resolve(options2.cwd || "");
      const { root } = path9.parse(directory);
      const paths = [].concat(name);
      const runMatcher = /* @__PURE__ */ __name((locateOptions) => {
        if (typeof name !== "function") {
          return locatePath.sync(paths, locateOptions);
        }
        const foundPath = name(locateOptions.cwd);
        if (typeof foundPath === "string") {
          return locatePath.sync([foundPath], locateOptions);
        }
        return foundPath;
      }, "runMatcher");
      while (true) {
        const foundPath = runMatcher({ ...options2, cwd: directory });
        if (foundPath === stop) {
          return;
        }
        if (foundPath) {
          return path9.resolve(directory, foundPath);
        }
        if (directory === root) {
          return;
        }
        directory = path9.dirname(directory);
      }
    };
    module2.exports.exists = pathExists;
    module2.exports.sync.exists = pathExists.sync;
    module2.exports.stop = stop;
  }
});

// ../../node_modules/.pnpm/is-arrayish@0.2.1/node_modules/is-arrayish/index.js
var require_is_arrayish = __commonJS({
  "../../node_modules/.pnpm/is-arrayish@0.2.1/node_modules/is-arrayish/index.js"(exports, module2) {
    "use strict";
    module2.exports = /* @__PURE__ */ __name(function isArrayish(obj) {
      if (!obj) {
        return false;
      }
      return obj instanceof Array || Array.isArray(obj) || obj.length >= 0 && obj.splice instanceof Function;
    }, "isArrayish");
  }
});

// ../../node_modules/.pnpm/error-ex@1.3.2/node_modules/error-ex/index.js
var require_error_ex = __commonJS({
  "../../node_modules/.pnpm/error-ex@1.3.2/node_modules/error-ex/index.js"(exports, module2) {
    "use strict";
    var util2 = require("util");
    var isArrayish = require_is_arrayish();
    var errorEx = /* @__PURE__ */ __name(function errorEx2(name, properties) {
      if (!name || name.constructor !== String) {
        properties = name || {};
        name = Error.name;
      }
      var errorExError = /* @__PURE__ */ __name(function ErrorEXError(message) {
        if (!this) {
          return new ErrorEXError(message);
        }
        message = message instanceof Error ? message.message : message || this.message;
        Error.call(this, message);
        Error.captureStackTrace(this, errorExError);
        this.name = name;
        Object.defineProperty(this, "message", {
          configurable: true,
          enumerable: false,
          get: function() {
            var newMessage = message.split(/\r?\n/g);
            for (var key in properties) {
              if (!properties.hasOwnProperty(key)) {
                continue;
              }
              var modifier = properties[key];
              if ("message" in modifier) {
                newMessage = modifier.message(this[key], newMessage) || newMessage;
                if (!isArrayish(newMessage)) {
                  newMessage = [newMessage];
                }
              }
            }
            return newMessage.join("\n");
          },
          set: function(v) {
            message = v;
          }
        });
        var overwrittenStack = null;
        var stackDescriptor = Object.getOwnPropertyDescriptor(this, "stack");
        var stackGetter = stackDescriptor.get;
        var stackValue = stackDescriptor.value;
        delete stackDescriptor.value;
        delete stackDescriptor.writable;
        stackDescriptor.set = function(newstack) {
          overwrittenStack = newstack;
        };
        stackDescriptor.get = function() {
          var stack = (overwrittenStack || (stackGetter ? stackGetter.call(this) : stackValue)).split(/\r?\n+/g);
          if (!overwrittenStack) {
            stack[0] = this.name + ": " + this.message;
          }
          var lineCount = 1;
          for (var key in properties) {
            if (!properties.hasOwnProperty(key)) {
              continue;
            }
            var modifier = properties[key];
            if ("line" in modifier) {
              var line = modifier.line(this[key]);
              if (line) {
                stack.splice(lineCount++, 0, "    " + line);
              }
            }
            if ("stack" in modifier) {
              modifier.stack(this[key], stack);
            }
          }
          return stack.join("\n");
        };
        Object.defineProperty(this, "stack", stackDescriptor);
      }, "ErrorEXError");
      if (Object.setPrototypeOf) {
        Object.setPrototypeOf(errorExError.prototype, Error.prototype);
        Object.setPrototypeOf(errorExError, Error);
      } else {
        util2.inherits(errorExError, Error);
      }
      return errorExError;
    }, "errorEx");
    errorEx.append = function(str, def) {
      return {
        message: function(v, message) {
          v = v || def;
          if (v) {
            message[0] += " " + str.replace("%s", v.toString());
          }
          return message;
        }
      };
    };
    errorEx.line = function(str, def) {
      return {
        line: function(v) {
          v = v || def;
          if (v) {
            return str.replace("%s", v.toString());
          }
          return null;
        }
      };
    };
    module2.exports = errorEx;
  }
});

// ../../node_modules/.pnpm/json-parse-even-better-errors@2.3.1/node_modules/json-parse-even-better-errors/index.js
var require_json_parse_even_better_errors = __commonJS({
  "../../node_modules/.pnpm/json-parse-even-better-errors@2.3.1/node_modules/json-parse-even-better-errors/index.js"(exports, module2) {
    "use strict";
    var hexify = /* @__PURE__ */ __name((char) => {
      const h2 = char.charCodeAt(0).toString(16).toUpperCase();
      return "0x" + (h2.length % 2 ? "0" : "") + h2;
    }, "hexify");
    var parseError = /* @__PURE__ */ __name((e2, txt, context) => {
      if (!txt) {
        return {
          message: e2.message + " while parsing empty string",
          position: 0
        };
      }
      const badToken = e2.message.match(/^Unexpected token (.) .*position\s+(\d+)/i);
      const errIdx = badToken ? +badToken[2] : e2.message.match(/^Unexpected end of JSON.*/i) ? txt.length - 1 : null;
      const msg = badToken ? e2.message.replace(/^Unexpected token ./, `Unexpected token ${JSON.stringify(badToken[1])} (${hexify(badToken[1])})`) : e2.message;
      if (errIdx !== null && errIdx !== void 0) {
        const start = errIdx <= context ? 0 : errIdx - context;
        const end = errIdx + context >= txt.length ? txt.length : errIdx + context;
        const slice = (start === 0 ? "" : "...") + txt.slice(start, end) + (end === txt.length ? "" : "...");
        const near = txt === slice ? "" : "near ";
        return {
          message: msg + ` while parsing ${near}${JSON.stringify(slice)}`,
          position: errIdx
        };
      } else {
        return {
          message: msg + ` while parsing '${txt.slice(0, context * 2)}'`,
          position: 0
        };
      }
    }, "parseError");
    var JSONParseError = class extends SyntaxError {
      constructor(er, txt, context, caller) {
        context = context || 20;
        const metadata = parseError(er, txt, context);
        super(metadata.message);
        Object.assign(this, metadata);
        this.code = "EJSONPARSE";
        this.systemError = er;
        Error.captureStackTrace(this, caller || this.constructor);
      }
      get name() {
        return this.constructor.name;
      }
      set name(n2) {
      }
      get [Symbol.toStringTag]() {
        return this.constructor.name;
      }
    };
    __name(JSONParseError, "JSONParseError");
    var kIndent = Symbol.for("indent");
    var kNewline = Symbol.for("newline");
    var formatRE = /^\s*[{\[]((?:\r?\n)+)([\s\t]*)/;
    var emptyRE = /^(?:\{\}|\[\])((?:\r?\n)+)?$/;
    var parseJson = /* @__PURE__ */ __name((txt, reviver, context) => {
      const parseText = stripBOM(txt);
      context = context || 20;
      try {
        const [, newline = "\n", indent15 = "  "] = parseText.match(emptyRE) || parseText.match(formatRE) || [, "", ""];
        const result = JSON.parse(parseText, reviver);
        if (result && typeof result === "object") {
          result[kNewline] = newline;
          result[kIndent] = indent15;
        }
        return result;
      } catch (e2) {
        if (typeof txt !== "string" && !Buffer.isBuffer(txt)) {
          const isEmptyArray = Array.isArray(txt) && txt.length === 0;
          throw Object.assign(new TypeError(
            `Cannot parse ${isEmptyArray ? "an empty array" : String(txt)}`
          ), {
            code: "EJSONPARSE",
            systemError: e2
          });
        }
        throw new JSONParseError(e2, parseText, context, parseJson);
      }
    }, "parseJson");
    var stripBOM = /* @__PURE__ */ __name((txt) => String(txt).replace(/^\uFEFF/, ""), "stripBOM");
    module2.exports = parseJson;
    parseJson.JSONParseError = JSONParseError;
    parseJson.noExceptions = (txt, reviver) => {
      try {
        return JSON.parse(stripBOM(txt), reviver);
      } catch (e2) {
      }
    };
  }
});

// ../../node_modules/.pnpm/lines-and-columns@1.2.4/node_modules/lines-and-columns/build/index.js
var require_build = __commonJS({
  "../../node_modules/.pnpm/lines-and-columns@1.2.4/node_modules/lines-and-columns/build/index.js"(exports) {
    "use strict";
    exports.__esModule = true;
    exports.LinesAndColumns = void 0;
    var LF = "\n";
    var CR = "\r";
    var LinesAndColumns = function() {
      function LinesAndColumns2(string) {
        this.string = string;
        var offsets = [0];
        for (var offset = 0; offset < string.length; ) {
          switch (string[offset]) {
            case LF:
              offset += LF.length;
              offsets.push(offset);
              break;
            case CR:
              offset += CR.length;
              if (string[offset] === LF) {
                offset += LF.length;
              }
              offsets.push(offset);
              break;
            default:
              offset++;
              break;
          }
        }
        this.offsets = offsets;
      }
      __name(LinesAndColumns2, "LinesAndColumns");
      LinesAndColumns2.prototype.locationForIndex = function(index) {
        if (index < 0 || index > this.string.length) {
          return null;
        }
        var line = 0;
        var offsets = this.offsets;
        while (offsets[line + 1] <= index) {
          line++;
        }
        var column = index - offsets[line];
        return { line, column };
      };
      LinesAndColumns2.prototype.indexForLocation = function(location) {
        var line = location.line, column = location.column;
        if (line < 0 || line >= this.offsets.length) {
          return null;
        }
        if (column < 0 || column > this.lengthOfLine(line)) {
          return null;
        }
        return this.offsets[line] + column;
      };
      LinesAndColumns2.prototype.lengthOfLine = function(line) {
        var offset = this.offsets[line];
        var nextOffset = line === this.offsets.length - 1 ? this.string.length : this.offsets[line + 1];
        return nextOffset - offset;
      };
      return LinesAndColumns2;
    }();
    exports.LinesAndColumns = LinesAndColumns;
    exports["default"] = LinesAndColumns;
  }
});

// ../../node_modules/.pnpm/js-tokens@4.0.0/node_modules/js-tokens/index.js
var require_js_tokens = __commonJS({
  "../../node_modules/.pnpm/js-tokens@4.0.0/node_modules/js-tokens/index.js"(exports) {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = /((['"])(?:(?!\2|\\).|\\(?:\r\n|[\s\S]))*(\2)?|`(?:[^`\\$]|\\[\s\S]|\$(?!\{)|\$\{(?:[^{}]|\{[^}]*\}?)*\}?)*(`)?)|(\/\/.*)|(\/\*(?:[^*]|\*(?!\/))*(\*\/)?)|(\/(?!\*)(?:\[(?:(?![\]\\]).|\\.)*\]|(?![\/\]\\]).|\\.)+\/(?:(?!\s*(?:\b|[\u0080-\uFFFF$\\'"~({]|[+\-!](?!=)|\.?\d))|[gmiyus]{1,6}\b(?![\u0080-\uFFFF$\\]|\s*(?:[+\-*%&|^<>!=?({]|\/(?![\/*])))))|(0[xX][\da-fA-F]+|0[oO][0-7]+|0[bB][01]+|(?:\d*\.\d+|\d+\.?)(?:[eE][+-]?\d+)?)|((?!\d)(?:(?!\s)[$\w\u0080-\uFFFF]|\\u[\da-fA-F]{4}|\\u\{[\da-fA-F]+\})+)|(--|\+\+|&&|\|\||=>|\.{3}|(?:[+\-\/%&|^]|\*{1,2}|<{1,2}|>{1,3}|!=?|={1,2})=?|[?~.,:;[\](){}])|(\s+)|(^$|[\s\S])/g;
    exports.matchToToken = function(match) {
      var token = { type: "invalid", value: match[0], closed: void 0 };
      if (match[1])
        token.type = "string", token.closed = !!(match[3] || match[4]);
      else if (match[5])
        token.type = "comment";
      else if (match[6])
        token.type = "comment", token.closed = !!match[7];
      else if (match[8])
        token.type = "regex";
      else if (match[9])
        token.type = "number";
      else if (match[10])
        token.type = "name";
      else if (match[11])
        token.type = "punctuator";
      else if (match[12])
        token.type = "whitespace";
      return token;
    };
  }
});

// ../../node_modules/.pnpm/@babel+helper-validator-identifier@7.19.1/node_modules/@babel/helper-validator-identifier/lib/identifier.js
var require_identifier = __commonJS({
  "../../node_modules/.pnpm/@babel+helper-validator-identifier@7.19.1/node_modules/@babel/helper-validator-identifier/lib/identifier.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.isIdentifierChar = isIdentifierChar;
    exports.isIdentifierName = isIdentifierName;
    exports.isIdentifierStart = isIdentifierStart;
    var nonASCIIidentifierStartChars = "\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0560-\u0588\u05D0-\u05EA\u05EF-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u0860-\u086A\u0870-\u0887\u0889-\u088E\u08A0-\u08C9\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u09FC\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C5D\u0C60\u0C61\u0C80\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D04-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D54-\u0D56\u0D5F-\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E86-\u0E8A\u0E8C-\u0EA3\u0EA5\u0EA7-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u1711\u171F-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1878\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4C\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1C80-\u1C88\u1C90-\u1CBA\u1CBD-\u1CBF\u1CE9-\u1CEC\u1CEE-\u1CF3\u1CF5\u1CF6\u1CFA\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2118-\u211D\u2124\u2126\u2128\u212A-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303C\u3041-\u3096\u309B-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312F\u3131-\u318E\u31A0-\u31BF\u31F0-\u31FF\u3400-\u4DBF\u4E00-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6EF\uA717-\uA71F\uA722-\uA788\uA78B-\uA7CA\uA7D0\uA7D1\uA7D3\uA7D5-\uA7D9\uA7F2-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA8FD\uA8FE\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB69\uAB70-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC";
    var nonASCIIidentifierChars = "\u200C\u200D\xB7\u0300-\u036F\u0387\u0483-\u0487\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0610-\u061A\u064B-\u0669\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u06F0-\u06F9\u0711\u0730-\u074A\u07A6-\u07B0\u07C0-\u07C9\u07EB-\u07F3\u07FD\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u0898-\u089F\u08CA-\u08E1\u08E3-\u0903\u093A-\u093C\u093E-\u094F\u0951-\u0957\u0962\u0963\u0966-\u096F\u0981-\u0983\u09BC\u09BE-\u09C4\u09C7\u09C8\u09CB-\u09CD\u09D7\u09E2\u09E3\u09E6-\u09EF\u09FE\u0A01-\u0A03\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A66-\u0A71\u0A75\u0A81-\u0A83\u0ABC\u0ABE-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AE2\u0AE3\u0AE6-\u0AEF\u0AFA-\u0AFF\u0B01-\u0B03\u0B3C\u0B3E-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B55-\u0B57\u0B62\u0B63\u0B66-\u0B6F\u0B82\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD7\u0BE6-\u0BEF\u0C00-\u0C04\u0C3C\u0C3E-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C62\u0C63\u0C66-\u0C6F\u0C81-\u0C83\u0CBC\u0CBE-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CE2\u0CE3\u0CE6-\u0CEF\u0CF3\u0D00-\u0D03\u0D3B\u0D3C\u0D3E-\u0D44\u0D46-\u0D48\u0D4A-\u0D4D\u0D57\u0D62\u0D63\u0D66-\u0D6F\u0D81-\u0D83\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DE6-\u0DEF\u0DF2\u0DF3\u0E31\u0E34-\u0E3A\u0E47-\u0E4E\u0E50-\u0E59\u0EB1\u0EB4-\u0EBC\u0EC8-\u0ECE\u0ED0-\u0ED9\u0F18\u0F19\u0F20-\u0F29\u0F35\u0F37\u0F39\u0F3E\u0F3F\u0F71-\u0F84\u0F86\u0F87\u0F8D-\u0F97\u0F99-\u0FBC\u0FC6\u102B-\u103E\u1040-\u1049\u1056-\u1059\u105E-\u1060\u1062-\u1064\u1067-\u106D\u1071-\u1074\u1082-\u108D\u108F-\u109D\u135D-\u135F\u1369-\u1371\u1712-\u1715\u1732-\u1734\u1752\u1753\u1772\u1773\u17B4-\u17D3\u17DD\u17E0-\u17E9\u180B-\u180D\u180F-\u1819\u18A9\u1920-\u192B\u1930-\u193B\u1946-\u194F\u19D0-\u19DA\u1A17-\u1A1B\u1A55-\u1A5E\u1A60-\u1A7C\u1A7F-\u1A89\u1A90-\u1A99\u1AB0-\u1ABD\u1ABF-\u1ACE\u1B00-\u1B04\u1B34-\u1B44\u1B50-\u1B59\u1B6B-\u1B73\u1B80-\u1B82\u1BA1-\u1BAD\u1BB0-\u1BB9\u1BE6-\u1BF3\u1C24-\u1C37\u1C40-\u1C49\u1C50-\u1C59\u1CD0-\u1CD2\u1CD4-\u1CE8\u1CED\u1CF4\u1CF7-\u1CF9\u1DC0-\u1DFF\u203F\u2040\u2054\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2CEF-\u2CF1\u2D7F\u2DE0-\u2DFF\u302A-\u302F\u3099\u309A\uA620-\uA629\uA66F\uA674-\uA67D\uA69E\uA69F\uA6F0\uA6F1\uA802\uA806\uA80B\uA823-\uA827\uA82C\uA880\uA881\uA8B4-\uA8C5\uA8D0-\uA8D9\uA8E0-\uA8F1\uA8FF-\uA909\uA926-\uA92D\uA947-\uA953\uA980-\uA983\uA9B3-\uA9C0\uA9D0-\uA9D9\uA9E5\uA9F0-\uA9F9\uAA29-\uAA36\uAA43\uAA4C\uAA4D\uAA50-\uAA59\uAA7B-\uAA7D\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAEB-\uAAEF\uAAF5\uAAF6\uABE3-\uABEA\uABEC\uABED\uABF0-\uABF9\uFB1E\uFE00-\uFE0F\uFE20-\uFE2F\uFE33\uFE34\uFE4D-\uFE4F\uFF10-\uFF19\uFF3F";
    var nonASCIIidentifierStart = new RegExp("[" + nonASCIIidentifierStartChars + "]");
    var nonASCIIidentifier = new RegExp("[" + nonASCIIidentifierStartChars + nonASCIIidentifierChars + "]");
    nonASCIIidentifierStartChars = nonASCIIidentifierChars = null;
    var astralIdentifierStartCodes = [0, 11, 2, 25, 2, 18, 2, 1, 2, 14, 3, 13, 35, 122, 70, 52, 268, 28, 4, 48, 48, 31, 14, 29, 6, 37, 11, 29, 3, 35, 5, 7, 2, 4, 43, 157, 19, 35, 5, 35, 5, 39, 9, 51, 13, 10, 2, 14, 2, 6, 2, 1, 2, 10, 2, 14, 2, 6, 2, 1, 68, 310, 10, 21, 11, 7, 25, 5, 2, 41, 2, 8, 70, 5, 3, 0, 2, 43, 2, 1, 4, 0, 3, 22, 11, 22, 10, 30, 66, 18, 2, 1, 11, 21, 11, 25, 71, 55, 7, 1, 65, 0, 16, 3, 2, 2, 2, 28, 43, 28, 4, 28, 36, 7, 2, 27, 28, 53, 11, 21, 11, 18, 14, 17, 111, 72, 56, 50, 14, 50, 14, 35, 349, 41, 7, 1, 79, 28, 11, 0, 9, 21, 43, 17, 47, 20, 28, 22, 13, 52, 58, 1, 3, 0, 14, 44, 33, 24, 27, 35, 30, 0, 3, 0, 9, 34, 4, 0, 13, 47, 15, 3, 22, 0, 2, 0, 36, 17, 2, 24, 20, 1, 64, 6, 2, 0, 2, 3, 2, 14, 2, 9, 8, 46, 39, 7, 3, 1, 3, 21, 2, 6, 2, 1, 2, 4, 4, 0, 19, 0, 13, 4, 159, 52, 19, 3, 21, 2, 31, 47, 21, 1, 2, 0, 185, 46, 42, 3, 37, 47, 21, 0, 60, 42, 14, 0, 72, 26, 38, 6, 186, 43, 117, 63, 32, 7, 3, 0, 3, 7, 2, 1, 2, 23, 16, 0, 2, 0, 95, 7, 3, 38, 17, 0, 2, 0, 29, 0, 11, 39, 8, 0, 22, 0, 12, 45, 20, 0, 19, 72, 264, 8, 2, 36, 18, 0, 50, 29, 113, 6, 2, 1, 2, 37, 22, 0, 26, 5, 2, 1, 2, 31, 15, 0, 328, 18, 16, 0, 2, 12, 2, 33, 125, 0, 80, 921, 103, 110, 18, 195, 2637, 96, 16, 1071, 18, 5, 4026, 582, 8634, 568, 8, 30, 18, 78, 18, 29, 19, 47, 17, 3, 32, 20, 6, 18, 689, 63, 129, 74, 6, 0, 67, 12, 65, 1, 2, 0, 29, 6135, 9, 1237, 43, 8, 8936, 3, 2, 6, 2, 1, 2, 290, 16, 0, 30, 2, 3, 0, 15, 3, 9, 395, 2309, 106, 6, 12, 4, 8, 8, 9, 5991, 84, 2, 70, 2, 1, 3, 0, 3, 1, 3, 3, 2, 11, 2, 0, 2, 6, 2, 64, 2, 3, 3, 7, 2, 6, 2, 27, 2, 3, 2, 4, 2, 0, 4, 6, 2, 339, 3, 24, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 7, 1845, 30, 7, 5, 262, 61, 147, 44, 11, 6, 17, 0, 322, 29, 19, 43, 485, 27, 757, 6, 2, 3, 2, 1, 2, 14, 2, 196, 60, 67, 8, 0, 1205, 3, 2, 26, 2, 1, 2, 0, 3, 0, 2, 9, 2, 3, 2, 0, 2, 0, 7, 0, 5, 0, 2, 0, 2, 0, 2, 2, 2, 1, 2, 0, 3, 0, 2, 0, 2, 0, 2, 0, 2, 0, 2, 1, 2, 0, 3, 3, 2, 6, 2, 3, 2, 3, 2, 0, 2, 9, 2, 16, 6, 2, 2, 4, 2, 16, 4421, 42719, 33, 4153, 7, 221, 3, 5761, 15, 7472, 3104, 541, 1507, 4938, 6, 4191];
    var astralIdentifierCodes = [509, 0, 227, 0, 150, 4, 294, 9, 1368, 2, 2, 1, 6, 3, 41, 2, 5, 0, 166, 1, 574, 3, 9, 9, 370, 1, 81, 2, 71, 10, 50, 3, 123, 2, 54, 14, 32, 10, 3, 1, 11, 3, 46, 10, 8, 0, 46, 9, 7, 2, 37, 13, 2, 9, 6, 1, 45, 0, 13, 2, 49, 13, 9, 3, 2, 11, 83, 11, 7, 0, 3, 0, 158, 11, 6, 9, 7, 3, 56, 1, 2, 6, 3, 1, 3, 2, 10, 0, 11, 1, 3, 6, 4, 4, 193, 17, 10, 9, 5, 0, 82, 19, 13, 9, 214, 6, 3, 8, 28, 1, 83, 16, 16, 9, 82, 12, 9, 9, 84, 14, 5, 9, 243, 14, 166, 9, 71, 5, 2, 1, 3, 3, 2, 0, 2, 1, 13, 9, 120, 6, 3, 6, 4, 0, 29, 9, 41, 6, 2, 3, 9, 0, 10, 10, 47, 15, 406, 7, 2, 7, 17, 9, 57, 21, 2, 13, 123, 5, 4, 0, 2, 1, 2, 6, 2, 0, 9, 9, 49, 4, 2, 1, 2, 4, 9, 9, 330, 3, 10, 1, 2, 0, 49, 6, 4, 4, 14, 9, 5351, 0, 7, 14, 13835, 9, 87, 9, 39, 4, 60, 6, 26, 9, 1014, 0, 2, 54, 8, 3, 82, 0, 12, 1, 19628, 1, 4706, 45, 3, 22, 543, 4, 4, 5, 9, 7, 3, 6, 31, 3, 149, 2, 1418, 49, 513, 54, 5, 49, 9, 0, 15, 0, 23, 4, 2, 14, 1361, 6, 2, 16, 3, 6, 2, 1, 2, 4, 101, 0, 161, 6, 10, 9, 357, 0, 62, 13, 499, 13, 983, 6, 110, 6, 6, 9, 4759, 9, 787719, 239];
    function isInAstralSet(code, set) {
      let pos = 65536;
      for (let i = 0, length = set.length; i < length; i += 2) {
        pos += set[i];
        if (pos > code)
          return false;
        pos += set[i + 1];
        if (pos >= code)
          return true;
      }
      return false;
    }
    __name(isInAstralSet, "isInAstralSet");
    function isIdentifierStart(code) {
      if (code < 65)
        return code === 36;
      if (code <= 90)
        return true;
      if (code < 97)
        return code === 95;
      if (code <= 122)
        return true;
      if (code <= 65535) {
        return code >= 170 && nonASCIIidentifierStart.test(String.fromCharCode(code));
      }
      return isInAstralSet(code, astralIdentifierStartCodes);
    }
    __name(isIdentifierStart, "isIdentifierStart");
    function isIdentifierChar(code) {
      if (code < 48)
        return code === 36;
      if (code < 58)
        return true;
      if (code < 65)
        return false;
      if (code <= 90)
        return true;
      if (code < 97)
        return code === 95;
      if (code <= 122)
        return true;
      if (code <= 65535) {
        return code >= 170 && nonASCIIidentifier.test(String.fromCharCode(code));
      }
      return isInAstralSet(code, astralIdentifierStartCodes) || isInAstralSet(code, astralIdentifierCodes);
    }
    __name(isIdentifierChar, "isIdentifierChar");
    function isIdentifierName(name) {
      let isFirst = true;
      for (let i = 0; i < name.length; i++) {
        let cp2 = name.charCodeAt(i);
        if ((cp2 & 64512) === 55296 && i + 1 < name.length) {
          const trail = name.charCodeAt(++i);
          if ((trail & 64512) === 56320) {
            cp2 = 65536 + ((cp2 & 1023) << 10) + (trail & 1023);
          }
        }
        if (isFirst) {
          isFirst = false;
          if (!isIdentifierStart(cp2)) {
            return false;
          }
        } else if (!isIdentifierChar(cp2)) {
          return false;
        }
      }
      return !isFirst;
    }
    __name(isIdentifierName, "isIdentifierName");
  }
});

// ../../node_modules/.pnpm/@babel+helper-validator-identifier@7.19.1/node_modules/@babel/helper-validator-identifier/lib/keyword.js
var require_keyword = __commonJS({
  "../../node_modules/.pnpm/@babel+helper-validator-identifier@7.19.1/node_modules/@babel/helper-validator-identifier/lib/keyword.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.isKeyword = isKeyword;
    exports.isReservedWord = isReservedWord;
    exports.isStrictBindOnlyReservedWord = isStrictBindOnlyReservedWord;
    exports.isStrictBindReservedWord = isStrictBindReservedWord;
    exports.isStrictReservedWord = isStrictReservedWord;
    var reservedWords = {
      keyword: ["break", "case", "catch", "continue", "debugger", "default", "do", "else", "finally", "for", "function", "if", "return", "switch", "throw", "try", "var", "const", "while", "with", "new", "this", "super", "class", "extends", "export", "import", "null", "true", "false", "in", "instanceof", "typeof", "void", "delete"],
      strict: ["implements", "interface", "let", "package", "private", "protected", "public", "static", "yield"],
      strictBind: ["eval", "arguments"]
    };
    var keywords = new Set(reservedWords.keyword);
    var reservedWordsStrictSet = new Set(reservedWords.strict);
    var reservedWordsStrictBindSet = new Set(reservedWords.strictBind);
    function isReservedWord(word, inModule) {
      return inModule && word === "await" || word === "enum";
    }
    __name(isReservedWord, "isReservedWord");
    function isStrictReservedWord(word, inModule) {
      return isReservedWord(word, inModule) || reservedWordsStrictSet.has(word);
    }
    __name(isStrictReservedWord, "isStrictReservedWord");
    function isStrictBindOnlyReservedWord(word) {
      return reservedWordsStrictBindSet.has(word);
    }
    __name(isStrictBindOnlyReservedWord, "isStrictBindOnlyReservedWord");
    function isStrictBindReservedWord(word, inModule) {
      return isStrictReservedWord(word, inModule) || isStrictBindOnlyReservedWord(word);
    }
    __name(isStrictBindReservedWord, "isStrictBindReservedWord");
    function isKeyword(word) {
      return keywords.has(word);
    }
    __name(isKeyword, "isKeyword");
  }
});

// ../../node_modules/.pnpm/@babel+helper-validator-identifier@7.19.1/node_modules/@babel/helper-validator-identifier/lib/index.js
var require_lib = __commonJS({
  "../../node_modules/.pnpm/@babel+helper-validator-identifier@7.19.1/node_modules/@babel/helper-validator-identifier/lib/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "isIdentifierChar", {
      enumerable: true,
      get: function() {
        return _identifier.isIdentifierChar;
      }
    });
    Object.defineProperty(exports, "isIdentifierName", {
      enumerable: true,
      get: function() {
        return _identifier.isIdentifierName;
      }
    });
    Object.defineProperty(exports, "isIdentifierStart", {
      enumerable: true,
      get: function() {
        return _identifier.isIdentifierStart;
      }
    });
    Object.defineProperty(exports, "isKeyword", {
      enumerable: true,
      get: function() {
        return _keyword.isKeyword;
      }
    });
    Object.defineProperty(exports, "isReservedWord", {
      enumerable: true,
      get: function() {
        return _keyword.isReservedWord;
      }
    });
    Object.defineProperty(exports, "isStrictBindOnlyReservedWord", {
      enumerable: true,
      get: function() {
        return _keyword.isStrictBindOnlyReservedWord;
      }
    });
    Object.defineProperty(exports, "isStrictBindReservedWord", {
      enumerable: true,
      get: function() {
        return _keyword.isStrictBindReservedWord;
      }
    });
    Object.defineProperty(exports, "isStrictReservedWord", {
      enumerable: true,
      get: function() {
        return _keyword.isStrictReservedWord;
      }
    });
    var _identifier = require_identifier();
    var _keyword = require_keyword();
  }
});

// ../../node_modules/.pnpm/escape-string-regexp@1.0.5/node_modules/escape-string-regexp/index.js
var require_escape_string_regexp = __commonJS({
  "../../node_modules/.pnpm/escape-string-regexp@1.0.5/node_modules/escape-string-regexp/index.js"(exports, module2) {
    "use strict";
    var matchOperatorsRe = /[|\\{}()[\]^$+*?.]/g;
    module2.exports = function(str) {
      if (typeof str !== "string") {
        throw new TypeError("Expected a string");
      }
      return str.replace(matchOperatorsRe, "\\$&");
    };
  }
});

// ../../node_modules/.pnpm/color-name@1.1.3/node_modules/color-name/index.js
var require_color_name2 = __commonJS({
  "../../node_modules/.pnpm/color-name@1.1.3/node_modules/color-name/index.js"(exports, module2) {
    "use strict";
    module2.exports = {
      "aliceblue": [240, 248, 255],
      "antiquewhite": [250, 235, 215],
      "aqua": [0, 255, 255],
      "aquamarine": [127, 255, 212],
      "azure": [240, 255, 255],
      "beige": [245, 245, 220],
      "bisque": [255, 228, 196],
      "black": [0, 0, 0],
      "blanchedalmond": [255, 235, 205],
      "blue": [0, 0, 255],
      "blueviolet": [138, 43, 226],
      "brown": [165, 42, 42],
      "burlywood": [222, 184, 135],
      "cadetblue": [95, 158, 160],
      "chartreuse": [127, 255, 0],
      "chocolate": [210, 105, 30],
      "coral": [255, 127, 80],
      "cornflowerblue": [100, 149, 237],
      "cornsilk": [255, 248, 220],
      "crimson": [220, 20, 60],
      "cyan": [0, 255, 255],
      "darkblue": [0, 0, 139],
      "darkcyan": [0, 139, 139],
      "darkgoldenrod": [184, 134, 11],
      "darkgray": [169, 169, 169],
      "darkgreen": [0, 100, 0],
      "darkgrey": [169, 169, 169],
      "darkkhaki": [189, 183, 107],
      "darkmagenta": [139, 0, 139],
      "darkolivegreen": [85, 107, 47],
      "darkorange": [255, 140, 0],
      "darkorchid": [153, 50, 204],
      "darkred": [139, 0, 0],
      "darksalmon": [233, 150, 122],
      "darkseagreen": [143, 188, 143],
      "darkslateblue": [72, 61, 139],
      "darkslategray": [47, 79, 79],
      "darkslategrey": [47, 79, 79],
      "darkturquoise": [0, 206, 209],
      "darkviolet": [148, 0, 211],
      "deeppink": [255, 20, 147],
      "deepskyblue": [0, 191, 255],
      "dimgray": [105, 105, 105],
      "dimgrey": [105, 105, 105],
      "dodgerblue": [30, 144, 255],
      "firebrick": [178, 34, 34],
      "floralwhite": [255, 250, 240],
      "forestgreen": [34, 139, 34],
      "fuchsia": [255, 0, 255],
      "gainsboro": [220, 220, 220],
      "ghostwhite": [248, 248, 255],
      "gold": [255, 215, 0],
      "goldenrod": [218, 165, 32],
      "gray": [128, 128, 128],
      "green": [0, 128, 0],
      "greenyellow": [173, 255, 47],
      "grey": [128, 128, 128],
      "honeydew": [240, 255, 240],
      "hotpink": [255, 105, 180],
      "indianred": [205, 92, 92],
      "indigo": [75, 0, 130],
      "ivory": [255, 255, 240],
      "khaki": [240, 230, 140],
      "lavender": [230, 230, 250],
      "lavenderblush": [255, 240, 245],
      "lawngreen": [124, 252, 0],
      "lemonchiffon": [255, 250, 205],
      "lightblue": [173, 216, 230],
      "lightcoral": [240, 128, 128],
      "lightcyan": [224, 255, 255],
      "lightgoldenrodyellow": [250, 250, 210],
      "lightgray": [211, 211, 211],
      "lightgreen": [144, 238, 144],
      "lightgrey": [211, 211, 211],
      "lightpink": [255, 182, 193],
      "lightsalmon": [255, 160, 122],
      "lightseagreen": [32, 178, 170],
      "lightskyblue": [135, 206, 250],
      "lightslategray": [119, 136, 153],
      "lightslategrey": [119, 136, 153],
      "lightsteelblue": [176, 196, 222],
      "lightyellow": [255, 255, 224],
      "lime": [0, 255, 0],
      "limegreen": [50, 205, 50],
      "linen": [250, 240, 230],
      "magenta": [255, 0, 255],
      "maroon": [128, 0, 0],
      "mediumaquamarine": [102, 205, 170],
      "mediumblue": [0, 0, 205],
      "mediumorchid": [186, 85, 211],
      "mediumpurple": [147, 112, 219],
      "mediumseagreen": [60, 179, 113],
      "mediumslateblue": [123, 104, 238],
      "mediumspringgreen": [0, 250, 154],
      "mediumturquoise": [72, 209, 204],
      "mediumvioletred": [199, 21, 133],
      "midnightblue": [25, 25, 112],
      "mintcream": [245, 255, 250],
      "mistyrose": [255, 228, 225],
      "moccasin": [255, 228, 181],
      "navajowhite": [255, 222, 173],
      "navy": [0, 0, 128],
      "oldlace": [253, 245, 230],
      "olive": [128, 128, 0],
      "olivedrab": [107, 142, 35],
      "orange": [255, 165, 0],
      "orangered": [255, 69, 0],
      "orchid": [218, 112, 214],
      "palegoldenrod": [238, 232, 170],
      "palegreen": [152, 251, 152],
      "paleturquoise": [175, 238, 238],
      "palevioletred": [219, 112, 147],
      "papayawhip": [255, 239, 213],
      "peachpuff": [255, 218, 185],
      "peru": [205, 133, 63],
      "pink": [255, 192, 203],
      "plum": [221, 160, 221],
      "powderblue": [176, 224, 230],
      "purple": [128, 0, 128],
      "rebeccapurple": [102, 51, 153],
      "red": [255, 0, 0],
      "rosybrown": [188, 143, 143],
      "royalblue": [65, 105, 225],
      "saddlebrown": [139, 69, 19],
      "salmon": [250, 128, 114],
      "sandybrown": [244, 164, 96],
      "seagreen": [46, 139, 87],
      "seashell": [255, 245, 238],
      "sienna": [160, 82, 45],
      "silver": [192, 192, 192],
      "skyblue": [135, 206, 235],
      "slateblue": [106, 90, 205],
      "slategray": [112, 128, 144],
      "slategrey": [112, 128, 144],
      "snow": [255, 250, 250],
      "springgreen": [0, 255, 127],
      "steelblue": [70, 130, 180],
      "tan": [210, 180, 140],
      "teal": [0, 128, 128],
      "thistle": [216, 191, 216],
      "tomato": [255, 99, 71],
      "turquoise": [64, 224, 208],
      "violet": [238, 130, 238],
      "wheat": [245, 222, 179],
      "white": [255, 255, 255],
      "whitesmoke": [245, 245, 245],
      "yellow": [255, 255, 0],
      "yellowgreen": [154, 205, 50]
    };
  }
});

// ../../node_modules/.pnpm/color-convert@1.9.3/node_modules/color-convert/conversions.js
var require_conversions2 = __commonJS({
  "../../node_modules/.pnpm/color-convert@1.9.3/node_modules/color-convert/conversions.js"(exports, module2) {
    var cssKeywords = require_color_name2();
    var reverseKeywords = {};
    for (key in cssKeywords) {
      if (cssKeywords.hasOwnProperty(key)) {
        reverseKeywords[cssKeywords[key]] = key;
      }
    }
    var key;
    var convert = module2.exports = {
      rgb: { channels: 3, labels: "rgb" },
      hsl: { channels: 3, labels: "hsl" },
      hsv: { channels: 3, labels: "hsv" },
      hwb: { channels: 3, labels: "hwb" },
      cmyk: { channels: 4, labels: "cmyk" },
      xyz: { channels: 3, labels: "xyz" },
      lab: { channels: 3, labels: "lab" },
      lch: { channels: 3, labels: "lch" },
      hex: { channels: 1, labels: ["hex"] },
      keyword: { channels: 1, labels: ["keyword"] },
      ansi16: { channels: 1, labels: ["ansi16"] },
      ansi256: { channels: 1, labels: ["ansi256"] },
      hcg: { channels: 3, labels: ["h", "c", "g"] },
      apple: { channels: 3, labels: ["r16", "g16", "b16"] },
      gray: { channels: 1, labels: ["gray"] }
    };
    for (model in convert) {
      if (convert.hasOwnProperty(model)) {
        if (!("channels" in convert[model])) {
          throw new Error("missing channels property: " + model);
        }
        if (!("labels" in convert[model])) {
          throw new Error("missing channel labels property: " + model);
        }
        if (convert[model].labels.length !== convert[model].channels) {
          throw new Error("channel and label counts mismatch: " + model);
        }
        channels = convert[model].channels;
        labels = convert[model].labels;
        delete convert[model].channels;
        delete convert[model].labels;
        Object.defineProperty(convert[model], "channels", { value: channels });
        Object.defineProperty(convert[model], "labels", { value: labels });
      }
    }
    var channels;
    var labels;
    var model;
    convert.rgb.hsl = function(rgb) {
      var r2 = rgb[0] / 255;
      var g2 = rgb[1] / 255;
      var b2 = rgb[2] / 255;
      var min2 = Math.min(r2, g2, b2);
      var max2 = Math.max(r2, g2, b2);
      var delta = max2 - min2;
      var h2;
      var s;
      var l;
      if (max2 === min2) {
        h2 = 0;
      } else if (r2 === max2) {
        h2 = (g2 - b2) / delta;
      } else if (g2 === max2) {
        h2 = 2 + (b2 - r2) / delta;
      } else if (b2 === max2) {
        h2 = 4 + (r2 - g2) / delta;
      }
      h2 = Math.min(h2 * 60, 360);
      if (h2 < 0) {
        h2 += 360;
      }
      l = (min2 + max2) / 2;
      if (max2 === min2) {
        s = 0;
      } else if (l <= 0.5) {
        s = delta / (max2 + min2);
      } else {
        s = delta / (2 - max2 - min2);
      }
      return [h2, s * 100, l * 100];
    };
    convert.rgb.hsv = function(rgb) {
      var rdif;
      var gdif;
      var bdif;
      var h2;
      var s;
      var r2 = rgb[0] / 255;
      var g2 = rgb[1] / 255;
      var b2 = rgb[2] / 255;
      var v = Math.max(r2, g2, b2);
      var diff = v - Math.min(r2, g2, b2);
      var diffc = /* @__PURE__ */ __name(function(c) {
        return (v - c) / 6 / diff + 1 / 2;
      }, "diffc");
      if (diff === 0) {
        h2 = s = 0;
      } else {
        s = diff / v;
        rdif = diffc(r2);
        gdif = diffc(g2);
        bdif = diffc(b2);
        if (r2 === v) {
          h2 = bdif - gdif;
        } else if (g2 === v) {
          h2 = 1 / 3 + rdif - bdif;
        } else if (b2 === v) {
          h2 = 2 / 3 + gdif - rdif;
        }
        if (h2 < 0) {
          h2 += 1;
        } else if (h2 > 1) {
          h2 -= 1;
        }
      }
      return [
        h2 * 360,
        s * 100,
        v * 100
      ];
    };
    convert.rgb.hwb = function(rgb) {
      var r2 = rgb[0];
      var g2 = rgb[1];
      var b2 = rgb[2];
      var h2 = convert.rgb.hsl(rgb)[0];
      var w2 = 1 / 255 * Math.min(r2, Math.min(g2, b2));
      b2 = 1 - 1 / 255 * Math.max(r2, Math.max(g2, b2));
      return [h2, w2 * 100, b2 * 100];
    };
    convert.rgb.cmyk = function(rgb) {
      var r2 = rgb[0] / 255;
      var g2 = rgb[1] / 255;
      var b2 = rgb[2] / 255;
      var c;
      var m;
      var y2;
      var k;
      k = Math.min(1 - r2, 1 - g2, 1 - b2);
      c = (1 - r2 - k) / (1 - k) || 0;
      m = (1 - g2 - k) / (1 - k) || 0;
      y2 = (1 - b2 - k) / (1 - k) || 0;
      return [c * 100, m * 100, y2 * 100, k * 100];
    };
    function comparativeDistance(x, y2) {
      return Math.pow(x[0] - y2[0], 2) + Math.pow(x[1] - y2[1], 2) + Math.pow(x[2] - y2[2], 2);
    }
    __name(comparativeDistance, "comparativeDistance");
    convert.rgb.keyword = function(rgb) {
      var reversed = reverseKeywords[rgb];
      if (reversed) {
        return reversed;
      }
      var currentClosestDistance = Infinity;
      var currentClosestKeyword;
      for (var keyword in cssKeywords) {
        if (cssKeywords.hasOwnProperty(keyword)) {
          var value = cssKeywords[keyword];
          var distance = comparativeDistance(rgb, value);
          if (distance < currentClosestDistance) {
            currentClosestDistance = distance;
            currentClosestKeyword = keyword;
          }
        }
      }
      return currentClosestKeyword;
    };
    convert.keyword.rgb = function(keyword) {
      return cssKeywords[keyword];
    };
    convert.rgb.xyz = function(rgb) {
      var r2 = rgb[0] / 255;
      var g2 = rgb[1] / 255;
      var b2 = rgb[2] / 255;
      r2 = r2 > 0.04045 ? Math.pow((r2 + 0.055) / 1.055, 2.4) : r2 / 12.92;
      g2 = g2 > 0.04045 ? Math.pow((g2 + 0.055) / 1.055, 2.4) : g2 / 12.92;
      b2 = b2 > 0.04045 ? Math.pow((b2 + 0.055) / 1.055, 2.4) : b2 / 12.92;
      var x = r2 * 0.4124 + g2 * 0.3576 + b2 * 0.1805;
      var y2 = r2 * 0.2126 + g2 * 0.7152 + b2 * 0.0722;
      var z = r2 * 0.0193 + g2 * 0.1192 + b2 * 0.9505;
      return [x * 100, y2 * 100, z * 100];
    };
    convert.rgb.lab = function(rgb) {
      var xyz = convert.rgb.xyz(rgb);
      var x = xyz[0];
      var y2 = xyz[1];
      var z = xyz[2];
      var l;
      var a;
      var b2;
      x /= 95.047;
      y2 /= 100;
      z /= 108.883;
      x = x > 8856e-6 ? Math.pow(x, 1 / 3) : 7.787 * x + 16 / 116;
      y2 = y2 > 8856e-6 ? Math.pow(y2, 1 / 3) : 7.787 * y2 + 16 / 116;
      z = z > 8856e-6 ? Math.pow(z, 1 / 3) : 7.787 * z + 16 / 116;
      l = 116 * y2 - 16;
      a = 500 * (x - y2);
      b2 = 200 * (y2 - z);
      return [l, a, b2];
    };
    convert.hsl.rgb = function(hsl) {
      var h2 = hsl[0] / 360;
      var s = hsl[1] / 100;
      var l = hsl[2] / 100;
      var t1;
      var t22;
      var t3;
      var rgb;
      var val;
      if (s === 0) {
        val = l * 255;
        return [val, val, val];
      }
      if (l < 0.5) {
        t22 = l * (1 + s);
      } else {
        t22 = l + s - l * s;
      }
      t1 = 2 * l - t22;
      rgb = [0, 0, 0];
      for (var i = 0; i < 3; i++) {
        t3 = h2 + 1 / 3 * -(i - 1);
        if (t3 < 0) {
          t3++;
        }
        if (t3 > 1) {
          t3--;
        }
        if (6 * t3 < 1) {
          val = t1 + (t22 - t1) * 6 * t3;
        } else if (2 * t3 < 1) {
          val = t22;
        } else if (3 * t3 < 2) {
          val = t1 + (t22 - t1) * (2 / 3 - t3) * 6;
        } else {
          val = t1;
        }
        rgb[i] = val * 255;
      }
      return rgb;
    };
    convert.hsl.hsv = function(hsl) {
      var h2 = hsl[0];
      var s = hsl[1] / 100;
      var l = hsl[2] / 100;
      var smin = s;
      var lmin = Math.max(l, 0.01);
      var sv;
      var v;
      l *= 2;
      s *= l <= 1 ? l : 2 - l;
      smin *= lmin <= 1 ? lmin : 2 - lmin;
      v = (l + s) / 2;
      sv = l === 0 ? 2 * smin / (lmin + smin) : 2 * s / (l + s);
      return [h2, sv * 100, v * 100];
    };
    convert.hsv.rgb = function(hsv) {
      var h2 = hsv[0] / 60;
      var s = hsv[1] / 100;
      var v = hsv[2] / 100;
      var hi = Math.floor(h2) % 6;
      var f = h2 - Math.floor(h2);
      var p2 = 255 * v * (1 - s);
      var q = 255 * v * (1 - s * f);
      var t3 = 255 * v * (1 - s * (1 - f));
      v *= 255;
      switch (hi) {
        case 0:
          return [v, t3, p2];
        case 1:
          return [q, v, p2];
        case 2:
          return [p2, v, t3];
        case 3:
          return [p2, q, v];
        case 4:
          return [t3, p2, v];
        case 5:
          return [v, p2, q];
      }
    };
    convert.hsv.hsl = function(hsv) {
      var h2 = hsv[0];
      var s = hsv[1] / 100;
      var v = hsv[2] / 100;
      var vmin = Math.max(v, 0.01);
      var lmin;
      var sl;
      var l;
      l = (2 - s) * v;
      lmin = (2 - s) * vmin;
      sl = s * vmin;
      sl /= lmin <= 1 ? lmin : 2 - lmin;
      sl = sl || 0;
      l /= 2;
      return [h2, sl * 100, l * 100];
    };
    convert.hwb.rgb = function(hwb) {
      var h2 = hwb[0] / 360;
      var wh = hwb[1] / 100;
      var bl = hwb[2] / 100;
      var ratio = wh + bl;
      var i;
      var v;
      var f;
      var n2;
      if (ratio > 1) {
        wh /= ratio;
        bl /= ratio;
      }
      i = Math.floor(6 * h2);
      v = 1 - bl;
      f = 6 * h2 - i;
      if ((i & 1) !== 0) {
        f = 1 - f;
      }
      n2 = wh + f * (v - wh);
      var r2;
      var g2;
      var b2;
      switch (i) {
        default:
        case 6:
        case 0:
          r2 = v;
          g2 = n2;
          b2 = wh;
          break;
        case 1:
          r2 = n2;
          g2 = v;
          b2 = wh;
          break;
        case 2:
          r2 = wh;
          g2 = v;
          b2 = n2;
          break;
        case 3:
          r2 = wh;
          g2 = n2;
          b2 = v;
          break;
        case 4:
          r2 = n2;
          g2 = wh;
          b2 = v;
          break;
        case 5:
          r2 = v;
          g2 = wh;
          b2 = n2;
          break;
      }
      return [r2 * 255, g2 * 255, b2 * 255];
    };
    convert.cmyk.rgb = function(cmyk) {
      var c = cmyk[0] / 100;
      var m = cmyk[1] / 100;
      var y2 = cmyk[2] / 100;
      var k = cmyk[3] / 100;
      var r2;
      var g2;
      var b2;
      r2 = 1 - Math.min(1, c * (1 - k) + k);
      g2 = 1 - Math.min(1, m * (1 - k) + k);
      b2 = 1 - Math.min(1, y2 * (1 - k) + k);
      return [r2 * 255, g2 * 255, b2 * 255];
    };
    convert.xyz.rgb = function(xyz) {
      var x = xyz[0] / 100;
      var y2 = xyz[1] / 100;
      var z = xyz[2] / 100;
      var r2;
      var g2;
      var b2;
      r2 = x * 3.2406 + y2 * -1.5372 + z * -0.4986;
      g2 = x * -0.9689 + y2 * 1.8758 + z * 0.0415;
      b2 = x * 0.0557 + y2 * -0.204 + z * 1.057;
      r2 = r2 > 31308e-7 ? 1.055 * Math.pow(r2, 1 / 2.4) - 0.055 : r2 * 12.92;
      g2 = g2 > 31308e-7 ? 1.055 * Math.pow(g2, 1 / 2.4) - 0.055 : g2 * 12.92;
      b2 = b2 > 31308e-7 ? 1.055 * Math.pow(b2, 1 / 2.4) - 0.055 : b2 * 12.92;
      r2 = Math.min(Math.max(0, r2), 1);
      g2 = Math.min(Math.max(0, g2), 1);
      b2 = Math.min(Math.max(0, b2), 1);
      return [r2 * 255, g2 * 255, b2 * 255];
    };
    convert.xyz.lab = function(xyz) {
      var x = xyz[0];
      var y2 = xyz[1];
      var z = xyz[2];
      var l;
      var a;
      var b2;
      x /= 95.047;
      y2 /= 100;
      z /= 108.883;
      x = x > 8856e-6 ? Math.pow(x, 1 / 3) : 7.787 * x + 16 / 116;
      y2 = y2 > 8856e-6 ? Math.pow(y2, 1 / 3) : 7.787 * y2 + 16 / 116;
      z = z > 8856e-6 ? Math.pow(z, 1 / 3) : 7.787 * z + 16 / 116;
      l = 116 * y2 - 16;
      a = 500 * (x - y2);
      b2 = 200 * (y2 - z);
      return [l, a, b2];
    };
    convert.lab.xyz = function(lab) {
      var l = lab[0];
      var a = lab[1];
      var b2 = lab[2];
      var x;
      var y2;
      var z;
      y2 = (l + 16) / 116;
      x = a / 500 + y2;
      z = y2 - b2 / 200;
      var y22 = Math.pow(y2, 3);
      var x2 = Math.pow(x, 3);
      var z2 = Math.pow(z, 3);
      y2 = y22 > 8856e-6 ? y22 : (y2 - 16 / 116) / 7.787;
      x = x2 > 8856e-6 ? x2 : (x - 16 / 116) / 7.787;
      z = z2 > 8856e-6 ? z2 : (z - 16 / 116) / 7.787;
      x *= 95.047;
      y2 *= 100;
      z *= 108.883;
      return [x, y2, z];
    };
    convert.lab.lch = function(lab) {
      var l = lab[0];
      var a = lab[1];
      var b2 = lab[2];
      var hr;
      var h2;
      var c;
      hr = Math.atan2(b2, a);
      h2 = hr * 360 / 2 / Math.PI;
      if (h2 < 0) {
        h2 += 360;
      }
      c = Math.sqrt(a * a + b2 * b2);
      return [l, c, h2];
    };
    convert.lch.lab = function(lch) {
      var l = lch[0];
      var c = lch[1];
      var h2 = lch[2];
      var a;
      var b2;
      var hr;
      hr = h2 / 360 * 2 * Math.PI;
      a = c * Math.cos(hr);
      b2 = c * Math.sin(hr);
      return [l, a, b2];
    };
    convert.rgb.ansi16 = function(args) {
      var r2 = args[0];
      var g2 = args[1];
      var b2 = args[2];
      var value = 1 in arguments ? arguments[1] : convert.rgb.hsv(args)[2];
      value = Math.round(value / 50);
      if (value === 0) {
        return 30;
      }
      var ansi = 30 + (Math.round(b2 / 255) << 2 | Math.round(g2 / 255) << 1 | Math.round(r2 / 255));
      if (value === 2) {
        ansi += 60;
      }
      return ansi;
    };
    convert.hsv.ansi16 = function(args) {
      return convert.rgb.ansi16(convert.hsv.rgb(args), args[2]);
    };
    convert.rgb.ansi256 = function(args) {
      var r2 = args[0];
      var g2 = args[1];
      var b2 = args[2];
      if (r2 === g2 && g2 === b2) {
        if (r2 < 8) {
          return 16;
        }
        if (r2 > 248) {
          return 231;
        }
        return Math.round((r2 - 8) / 247 * 24) + 232;
      }
      var ansi = 16 + 36 * Math.round(r2 / 255 * 5) + 6 * Math.round(g2 / 255 * 5) + Math.round(b2 / 255 * 5);
      return ansi;
    };
    convert.ansi16.rgb = function(args) {
      var color = args % 10;
      if (color === 0 || color === 7) {
        if (args > 50) {
          color += 3.5;
        }
        color = color / 10.5 * 255;
        return [color, color, color];
      }
      var mult = (~~(args > 50) + 1) * 0.5;
      var r2 = (color & 1) * mult * 255;
      var g2 = (color >> 1 & 1) * mult * 255;
      var b2 = (color >> 2 & 1) * mult * 255;
      return [r2, g2, b2];
    };
    convert.ansi256.rgb = function(args) {
      if (args >= 232) {
        var c = (args - 232) * 10 + 8;
        return [c, c, c];
      }
      args -= 16;
      var rem;
      var r2 = Math.floor(args / 36) / 5 * 255;
      var g2 = Math.floor((rem = args % 36) / 6) / 5 * 255;
      var b2 = rem % 6 / 5 * 255;
      return [r2, g2, b2];
    };
    convert.rgb.hex = function(args) {
      var integer = ((Math.round(args[0]) & 255) << 16) + ((Math.round(args[1]) & 255) << 8) + (Math.round(args[2]) & 255);
      var string = integer.toString(16).toUpperCase();
      return "000000".substring(string.length) + string;
    };
    convert.hex.rgb = function(args) {
      var match = args.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);
      if (!match) {
        return [0, 0, 0];
      }
      var colorString = match[0];
      if (match[0].length === 3) {
        colorString = colorString.split("").map(function(char) {
          return char + char;
        }).join("");
      }
      var integer = parseInt(colorString, 16);
      var r2 = integer >> 16 & 255;
      var g2 = integer >> 8 & 255;
      var b2 = integer & 255;
      return [r2, g2, b2];
    };
    convert.rgb.hcg = function(rgb) {
      var r2 = rgb[0] / 255;
      var g2 = rgb[1] / 255;
      var b2 = rgb[2] / 255;
      var max2 = Math.max(Math.max(r2, g2), b2);
      var min2 = Math.min(Math.min(r2, g2), b2);
      var chroma = max2 - min2;
      var grayscale;
      var hue;
      if (chroma < 1) {
        grayscale = min2 / (1 - chroma);
      } else {
        grayscale = 0;
      }
      if (chroma <= 0) {
        hue = 0;
      } else if (max2 === r2) {
        hue = (g2 - b2) / chroma % 6;
      } else if (max2 === g2) {
        hue = 2 + (b2 - r2) / chroma;
      } else {
        hue = 4 + (r2 - g2) / chroma + 4;
      }
      hue /= 6;
      hue %= 1;
      return [hue * 360, chroma * 100, grayscale * 100];
    };
    convert.hsl.hcg = function(hsl) {
      var s = hsl[1] / 100;
      var l = hsl[2] / 100;
      var c = 1;
      var f = 0;
      if (l < 0.5) {
        c = 2 * s * l;
      } else {
        c = 2 * s * (1 - l);
      }
      if (c < 1) {
        f = (l - 0.5 * c) / (1 - c);
      }
      return [hsl[0], c * 100, f * 100];
    };
    convert.hsv.hcg = function(hsv) {
      var s = hsv[1] / 100;
      var v = hsv[2] / 100;
      var c = s * v;
      var f = 0;
      if (c < 1) {
        f = (v - c) / (1 - c);
      }
      return [hsv[0], c * 100, f * 100];
    };
    convert.hcg.rgb = function(hcg) {
      var h2 = hcg[0] / 360;
      var c = hcg[1] / 100;
      var g2 = hcg[2] / 100;
      if (c === 0) {
        return [g2 * 255, g2 * 255, g2 * 255];
      }
      var pure = [0, 0, 0];
      var hi = h2 % 1 * 6;
      var v = hi % 1;
      var w2 = 1 - v;
      var mg = 0;
      switch (Math.floor(hi)) {
        case 0:
          pure[0] = 1;
          pure[1] = v;
          pure[2] = 0;
          break;
        case 1:
          pure[0] = w2;
          pure[1] = 1;
          pure[2] = 0;
          break;
        case 2:
          pure[0] = 0;
          pure[1] = 1;
          pure[2] = v;
          break;
        case 3:
          pure[0] = 0;
          pure[1] = w2;
          pure[2] = 1;
          break;
        case 4:
          pure[0] = v;
          pure[1] = 0;
          pure[2] = 1;
          break;
        default:
          pure[0] = 1;
          pure[1] = 0;
          pure[2] = w2;
      }
      mg = (1 - c) * g2;
      return [
        (c * pure[0] + mg) * 255,
        (c * pure[1] + mg) * 255,
        (c * pure[2] + mg) * 255
      ];
    };
    convert.hcg.hsv = function(hcg) {
      var c = hcg[1] / 100;
      var g2 = hcg[2] / 100;
      var v = c + g2 * (1 - c);
      var f = 0;
      if (v > 0) {
        f = c / v;
      }
      return [hcg[0], f * 100, v * 100];
    };
    convert.hcg.hsl = function(hcg) {
      var c = hcg[1] / 100;
      var g2 = hcg[2] / 100;
      var l = g2 * (1 - c) + 0.5 * c;
      var s = 0;
      if (l > 0 && l < 0.5) {
        s = c / (2 * l);
      } else if (l >= 0.5 && l < 1) {
        s = c / (2 * (1 - l));
      }
      return [hcg[0], s * 100, l * 100];
    };
    convert.hcg.hwb = function(hcg) {
      var c = hcg[1] / 100;
      var g2 = hcg[2] / 100;
      var v = c + g2 * (1 - c);
      return [hcg[0], (v - c) * 100, (1 - v) * 100];
    };
    convert.hwb.hcg = function(hwb) {
      var w2 = hwb[1] / 100;
      var b2 = hwb[2] / 100;
      var v = 1 - b2;
      var c = v - w2;
      var g2 = 0;
      if (c < 1) {
        g2 = (v - c) / (1 - c);
      }
      return [hwb[0], c * 100, g2 * 100];
    };
    convert.apple.rgb = function(apple) {
      return [apple[0] / 65535 * 255, apple[1] / 65535 * 255, apple[2] / 65535 * 255];
    };
    convert.rgb.apple = function(rgb) {
      return [rgb[0] / 255 * 65535, rgb[1] / 255 * 65535, rgb[2] / 255 * 65535];
    };
    convert.gray.rgb = function(args) {
      return [args[0] / 100 * 255, args[0] / 100 * 255, args[0] / 100 * 255];
    };
    convert.gray.hsl = convert.gray.hsv = function(args) {
      return [0, 0, args[0]];
    };
    convert.gray.hwb = function(gray) {
      return [0, 100, gray[0]];
    };
    convert.gray.cmyk = function(gray) {
      return [0, 0, 0, gray[0]];
    };
    convert.gray.lab = function(gray) {
      return [gray[0], 0, 0];
    };
    convert.gray.hex = function(gray) {
      var val = Math.round(gray[0] / 100 * 255) & 255;
      var integer = (val << 16) + (val << 8) + val;
      var string = integer.toString(16).toUpperCase();
      return "000000".substring(string.length) + string;
    };
    convert.rgb.gray = function(rgb) {
      var val = (rgb[0] + rgb[1] + rgb[2]) / 3;
      return [val / 255 * 100];
    };
  }
});

// ../../node_modules/.pnpm/color-convert@1.9.3/node_modules/color-convert/route.js
var require_route2 = __commonJS({
  "../../node_modules/.pnpm/color-convert@1.9.3/node_modules/color-convert/route.js"(exports, module2) {
    var conversions = require_conversions2();
    function buildGraph() {
      var graph = {};
      var models = Object.keys(conversions);
      for (var len = models.length, i = 0; i < len; i++) {
        graph[models[i]] = {
          distance: -1,
          parent: null
        };
      }
      return graph;
    }
    __name(buildGraph, "buildGraph");
    function deriveBFS(fromModel) {
      var graph = buildGraph();
      var queue = [fromModel];
      graph[fromModel].distance = 0;
      while (queue.length) {
        var current = queue.pop();
        var adjacents = Object.keys(conversions[current]);
        for (var len = adjacents.length, i = 0; i < len; i++) {
          var adjacent = adjacents[i];
          var node = graph[adjacent];
          if (node.distance === -1) {
            node.distance = graph[current].distance + 1;
            node.parent = current;
            queue.unshift(adjacent);
          }
        }
      }
      return graph;
    }
    __name(deriveBFS, "deriveBFS");
    function link2(from, to) {
      return function(args) {
        return to(from(args));
      };
    }
    __name(link2, "link");
    function wrapConversion(toModel, graph) {
      var path9 = [graph[toModel].parent, toModel];
      var fn = conversions[graph[toModel].parent][toModel];
      var cur = graph[toModel].parent;
      while (graph[cur].parent) {
        path9.unshift(graph[cur].parent);
        fn = link2(conversions[graph[cur].parent][cur], fn);
        cur = graph[cur].parent;
      }
      fn.conversion = path9;
      return fn;
    }
    __name(wrapConversion, "wrapConversion");
    module2.exports = function(fromModel) {
      var graph = deriveBFS(fromModel);
      var conversion = {};
      var models = Object.keys(graph);
      for (var len = models.length, i = 0; i < len; i++) {
        var toModel = models[i];
        var node = graph[toModel];
        if (node.parent === null) {
          continue;
        }
        conversion[toModel] = wrapConversion(toModel, graph);
      }
      return conversion;
    };
  }
});

// ../../node_modules/.pnpm/color-convert@1.9.3/node_modules/color-convert/index.js
var require_color_convert2 = __commonJS({
  "../../node_modules/.pnpm/color-convert@1.9.3/node_modules/color-convert/index.js"(exports, module2) {
    var conversions = require_conversions2();
    var route = require_route2();
    var convert = {};
    var models = Object.keys(conversions);
    function wrapRaw(fn) {
      var wrappedFn = /* @__PURE__ */ __name(function(args) {
        if (args === void 0 || args === null) {
          return args;
        }
        if (arguments.length > 1) {
          args = Array.prototype.slice.call(arguments);
        }
        return fn(args);
      }, "wrappedFn");
      if ("conversion" in fn) {
        wrappedFn.conversion = fn.conversion;
      }
      return wrappedFn;
    }
    __name(wrapRaw, "wrapRaw");
    function wrapRounded(fn) {
      var wrappedFn = /* @__PURE__ */ __name(function(args) {
        if (args === void 0 || args === null) {
          return args;
        }
        if (arguments.length > 1) {
          args = Array.prototype.slice.call(arguments);
        }
        var result = fn(args);
        if (typeof result === "object") {
          for (var len = result.length, i = 0; i < len; i++) {
            result[i] = Math.round(result[i]);
          }
        }
        return result;
      }, "wrappedFn");
      if ("conversion" in fn) {
        wrappedFn.conversion = fn.conversion;
      }
      return wrappedFn;
    }
    __name(wrapRounded, "wrapRounded");
    models.forEach(function(fromModel) {
      convert[fromModel] = {};
      Object.defineProperty(convert[fromModel], "channels", { value: conversions[fromModel].channels });
      Object.defineProperty(convert[fromModel], "labels", { value: conversions[fromModel].labels });
      var routes = route(fromModel);
      var routeModels = Object.keys(routes);
      routeModels.forEach(function(toModel) {
        var fn = routes[toModel];
        convert[fromModel][toModel] = wrapRounded(fn);
        convert[fromModel][toModel].raw = wrapRaw(fn);
      });
    });
    module2.exports = convert;
  }
});

// ../../node_modules/.pnpm/ansi-styles@3.2.1/node_modules/ansi-styles/index.js
var require_ansi_styles2 = __commonJS({
  "../../node_modules/.pnpm/ansi-styles@3.2.1/node_modules/ansi-styles/index.js"(exports, module2) {
    "use strict";
    var colorConvert = require_color_convert2();
    var wrapAnsi16 = /* @__PURE__ */ __name((fn, offset) => function() {
      const code = fn.apply(colorConvert, arguments);
      return `\x1B[${code + offset}m`;
    }, "wrapAnsi16");
    var wrapAnsi256 = /* @__PURE__ */ __name((fn, offset) => function() {
      const code = fn.apply(colorConvert, arguments);
      return `\x1B[${38 + offset};5;${code}m`;
    }, "wrapAnsi256");
    var wrapAnsi16m = /* @__PURE__ */ __name((fn, offset) => function() {
      const rgb = fn.apply(colorConvert, arguments);
      return `\x1B[${38 + offset};2;${rgb[0]};${rgb[1]};${rgb[2]}m`;
    }, "wrapAnsi16m");
    function assembleStyles() {
      const codes = /* @__PURE__ */ new Map();
      const styles = {
        modifier: {
          reset: [0, 0],
          bold: [1, 22],
          dim: [2, 22],
          italic: [3, 23],
          underline: [4, 24],
          inverse: [7, 27],
          hidden: [8, 28],
          strikethrough: [9, 29]
        },
        color: {
          black: [30, 39],
          red: [31, 39],
          green: [32, 39],
          yellow: [33, 39],
          blue: [34, 39],
          magenta: [35, 39],
          cyan: [36, 39],
          white: [37, 39],
          gray: [90, 39],
          redBright: [91, 39],
          greenBright: [92, 39],
          yellowBright: [93, 39],
          blueBright: [94, 39],
          magentaBright: [95, 39],
          cyanBright: [96, 39],
          whiteBright: [97, 39]
        },
        bgColor: {
          bgBlack: [40, 49],
          bgRed: [41, 49],
          bgGreen: [42, 49],
          bgYellow: [43, 49],
          bgBlue: [44, 49],
          bgMagenta: [45, 49],
          bgCyan: [46, 49],
          bgWhite: [47, 49],
          bgBlackBright: [100, 49],
          bgRedBright: [101, 49],
          bgGreenBright: [102, 49],
          bgYellowBright: [103, 49],
          bgBlueBright: [104, 49],
          bgMagentaBright: [105, 49],
          bgCyanBright: [106, 49],
          bgWhiteBright: [107, 49]
        }
      };
      styles.color.grey = styles.color.gray;
      for (const groupName of Object.keys(styles)) {
        const group = styles[groupName];
        for (const styleName of Object.keys(group)) {
          const style = group[styleName];
          styles[styleName] = {
            open: `\x1B[${style[0]}m`,
            close: `\x1B[${style[1]}m`
          };
          group[styleName] = styles[styleName];
          codes.set(style[0], style[1]);
        }
        Object.defineProperty(styles, groupName, {
          value: group,
          enumerable: false
        });
        Object.defineProperty(styles, "codes", {
          value: codes,
          enumerable: false
        });
      }
      const ansi2ansi = /* @__PURE__ */ __name((n2) => n2, "ansi2ansi");
      const rgb2rgb = /* @__PURE__ */ __name((r2, g2, b2) => [r2, g2, b2], "rgb2rgb");
      styles.color.close = "\x1B[39m";
      styles.bgColor.close = "\x1B[49m";
      styles.color.ansi = {
        ansi: wrapAnsi16(ansi2ansi, 0)
      };
      styles.color.ansi256 = {
        ansi256: wrapAnsi256(ansi2ansi, 0)
      };
      styles.color.ansi16m = {
        rgb: wrapAnsi16m(rgb2rgb, 0)
      };
      styles.bgColor.ansi = {
        ansi: wrapAnsi16(ansi2ansi, 10)
      };
      styles.bgColor.ansi256 = {
        ansi256: wrapAnsi256(ansi2ansi, 10)
      };
      styles.bgColor.ansi16m = {
        rgb: wrapAnsi16m(rgb2rgb, 10)
      };
      for (let key of Object.keys(colorConvert)) {
        if (typeof colorConvert[key] !== "object") {
          continue;
        }
        const suite = colorConvert[key];
        if (key === "ansi16") {
          key = "ansi";
        }
        if ("ansi16" in suite) {
          styles.color.ansi[key] = wrapAnsi16(suite.ansi16, 0);
          styles.bgColor.ansi[key] = wrapAnsi16(suite.ansi16, 10);
        }
        if ("ansi256" in suite) {
          styles.color.ansi256[key] = wrapAnsi256(suite.ansi256, 0);
          styles.bgColor.ansi256[key] = wrapAnsi256(suite.ansi256, 10);
        }
        if ("rgb" in suite) {
          styles.color.ansi16m[key] = wrapAnsi16m(suite.rgb, 0);
          styles.bgColor.ansi16m[key] = wrapAnsi16m(suite.rgb, 10);
        }
      }
      return styles;
    }
    __name(assembleStyles, "assembleStyles");
    Object.defineProperty(module2, "exports", {
      enumerable: true,
      get: assembleStyles
    });
  }
});

// ../../node_modules/.pnpm/has-flag@3.0.0/node_modules/has-flag/index.js
var require_has_flag2 = __commonJS({
  "../../node_modules/.pnpm/has-flag@3.0.0/node_modules/has-flag/index.js"(exports, module2) {
    "use strict";
    module2.exports = (flag, argv) => {
      argv = argv || process.argv;
      const prefix = flag.startsWith("-") ? "" : flag.length === 1 ? "-" : "--";
      const pos = argv.indexOf(prefix + flag);
      const terminatorPos = argv.indexOf("--");
      return pos !== -1 && (terminatorPos === -1 ? true : pos < terminatorPos);
    };
  }
});

// ../../node_modules/.pnpm/supports-color@5.5.0/node_modules/supports-color/index.js
var require_supports_color2 = __commonJS({
  "../../node_modules/.pnpm/supports-color@5.5.0/node_modules/supports-color/index.js"(exports, module2) {
    "use strict";
    var os2 = require("os");
    var hasFlag = require_has_flag2();
    var env = process.env;
    var forceColor;
    if (hasFlag("no-color") || hasFlag("no-colors") || hasFlag("color=false")) {
      forceColor = false;
    } else if (hasFlag("color") || hasFlag("colors") || hasFlag("color=true") || hasFlag("color=always")) {
      forceColor = true;
    }
    if ("FORCE_COLOR" in env) {
      forceColor = env.FORCE_COLOR.length === 0 || parseInt(env.FORCE_COLOR, 10) !== 0;
    }
    function translateLevel(level) {
      if (level === 0) {
        return false;
      }
      return {
        level,
        hasBasic: true,
        has256: level >= 2,
        has16m: level >= 3
      };
    }
    __name(translateLevel, "translateLevel");
    function supportsColor(stream2) {
      if (forceColor === false) {
        return 0;
      }
      if (hasFlag("color=16m") || hasFlag("color=full") || hasFlag("color=truecolor")) {
        return 3;
      }
      if (hasFlag("color=256")) {
        return 2;
      }
      if (stream2 && !stream2.isTTY && forceColor !== true) {
        return 0;
      }
      const min2 = forceColor ? 1 : 0;
      if (process.platform === "win32") {
        const osRelease = os2.release().split(".");
        if (Number(process.versions.node.split(".")[0]) >= 8 && Number(osRelease[0]) >= 10 && Number(osRelease[2]) >= 10586) {
          return Number(osRelease[2]) >= 14931 ? 3 : 2;
        }
        return 1;
      }
      if ("CI" in env) {
        if (["TRAVIS", "CIRCLECI", "APPVEYOR", "GITLAB_CI"].some((sign2) => sign2 in env) || env.CI_NAME === "codeship") {
          return 1;
        }
        return min2;
      }
      if ("TEAMCITY_VERSION" in env) {
        return /^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.test(env.TEAMCITY_VERSION) ? 1 : 0;
      }
      if (env.COLORTERM === "truecolor") {
        return 3;
      }
      if ("TERM_PROGRAM" in env) {
        const version = parseInt((env.TERM_PROGRAM_VERSION || "").split(".")[0], 10);
        switch (env.TERM_PROGRAM) {
          case "iTerm.app":
            return version >= 3 ? 3 : 2;
          case "Apple_Terminal":
            return 2;
        }
      }
      if (/-256(color)?$/i.test(env.TERM)) {
        return 2;
      }
      if (/^screen|^xterm|^vt100|^vt220|^rxvt|color|ansi|cygwin|linux/i.test(env.TERM)) {
        return 1;
      }
      if ("COLORTERM" in env) {
        return 1;
      }
      if (env.TERM === "dumb") {
        return min2;
      }
      return min2;
    }
    __name(supportsColor, "supportsColor");
    function getSupportLevel(stream2) {
      const level = supportsColor(stream2);
      return translateLevel(level);
    }
    __name(getSupportLevel, "getSupportLevel");
    module2.exports = {
      supportsColor: getSupportLevel,
      stdout: getSupportLevel(process.stdout),
      stderr: getSupportLevel(process.stderr)
    };
  }
});

// ../../node_modules/.pnpm/chalk@2.4.2/node_modules/chalk/templates.js
var require_templates2 = __commonJS({
  "../../node_modules/.pnpm/chalk@2.4.2/node_modules/chalk/templates.js"(exports, module2) {
    "use strict";
    var TEMPLATE_REGEX = /(?:\\(u[a-f\d]{4}|x[a-f\d]{2}|.))|(?:\{(~)?(\w+(?:\([^)]*\))?(?:\.\w+(?:\([^)]*\))?)*)(?:[ \t]|(?=\r?\n)))|(\})|((?:.|[\r\n\f])+?)/gi;
    var STYLE_REGEX = /(?:^|\.)(\w+)(?:\(([^)]*)\))?/g;
    var STRING_REGEX = /^(['"])((?:\\.|(?!\1)[^\\])*)\1$/;
    var ESCAPE_REGEX = /\\(u[a-f\d]{4}|x[a-f\d]{2}|.)|([^\\])/gi;
    var ESCAPES = /* @__PURE__ */ new Map([
      ["n", "\n"],
      ["r", "\r"],
      ["t", "	"],
      ["b", "\b"],
      ["f", "\f"],
      ["v", "\v"],
      ["0", "\0"],
      ["\\", "\\"],
      ["e", "\x1B"],
      ["a", "\x07"]
    ]);
    function unescape(c) {
      if (c[0] === "u" && c.length === 5 || c[0] === "x" && c.length === 3) {
        return String.fromCharCode(parseInt(c.slice(1), 16));
      }
      return ESCAPES.get(c) || c;
    }
    __name(unescape, "unescape");
    function parseArguments(name, args) {
      const results = [];
      const chunks = args.trim().split(/\s*,\s*/g);
      let matches;
      for (const chunk of chunks) {
        if (!isNaN(chunk)) {
          results.push(Number(chunk));
        } else if (matches = chunk.match(STRING_REGEX)) {
          results.push(matches[2].replace(ESCAPE_REGEX, (m, escape, chr) => escape ? unescape(escape) : chr));
        } else {
          throw new Error(`Invalid Chalk template style argument: ${chunk} (in style '${name}')`);
        }
      }
      return results;
    }
    __name(parseArguments, "parseArguments");
    function parseStyle(style) {
      STYLE_REGEX.lastIndex = 0;
      const results = [];
      let matches;
      while ((matches = STYLE_REGEX.exec(style)) !== null) {
        const name = matches[1];
        if (matches[2]) {
          const args = parseArguments(name, matches[2]);
          results.push([name].concat(args));
        } else {
          results.push([name]);
        }
      }
      return results;
    }
    __name(parseStyle, "parseStyle");
    function buildStyle(chalk9, styles) {
      const enabled = {};
      for (const layer of styles) {
        for (const style of layer.styles) {
          enabled[style[0]] = layer.inverse ? null : style.slice(1);
        }
      }
      let current = chalk9;
      for (const styleName of Object.keys(enabled)) {
        if (Array.isArray(enabled[styleName])) {
          if (!(styleName in current)) {
            throw new Error(`Unknown Chalk style: ${styleName}`);
          }
          if (enabled[styleName].length > 0) {
            current = current[styleName].apply(current, enabled[styleName]);
          } else {
            current = current[styleName];
          }
        }
      }
      return current;
    }
    __name(buildStyle, "buildStyle");
    module2.exports = (chalk9, tmp) => {
      const styles = [];
      const chunks = [];
      let chunk = [];
      tmp.replace(TEMPLATE_REGEX, (m, escapeChar, inverse, style, close, chr) => {
        if (escapeChar) {
          chunk.push(unescape(escapeChar));
        } else if (style) {
          const str = chunk.join("");
          chunk = [];
          chunks.push(styles.length === 0 ? str : buildStyle(chalk9, styles)(str));
          styles.push({ inverse, styles: parseStyle(style) });
        } else if (close) {
          if (styles.length === 0) {
            throw new Error("Found extraneous } in Chalk template literal");
          }
          chunks.push(buildStyle(chalk9, styles)(chunk.join("")));
          chunk = [];
          styles.pop();
        } else {
          chunk.push(chr);
        }
      });
      chunks.push(chunk.join(""));
      if (styles.length > 0) {
        const errMsg = `Chalk template literal is missing ${styles.length} closing bracket${styles.length === 1 ? "" : "s"} (\`}\`)`;
        throw new Error(errMsg);
      }
      return chunks.join("");
    };
  }
});

// ../../node_modules/.pnpm/chalk@2.4.2/node_modules/chalk/index.js
var require_chalk = __commonJS({
  "../../node_modules/.pnpm/chalk@2.4.2/node_modules/chalk/index.js"(exports, module2) {
    "use strict";
    var escapeStringRegexp = require_escape_string_regexp();
    var ansiStyles = require_ansi_styles2();
    var stdoutColor = require_supports_color2().stdout;
    var template = require_templates2();
    var isSimpleWindowsTerm = process.platform === "win32" && !(process.env.TERM || "").toLowerCase().startsWith("xterm");
    var levelMapping = ["ansi", "ansi", "ansi256", "ansi16m"];
    var skipModels = /* @__PURE__ */ new Set(["gray"]);
    var styles = /* @__PURE__ */ Object.create(null);
    function applyOptions(obj, options2) {
      options2 = options2 || {};
      const scLevel = stdoutColor ? stdoutColor.level : 0;
      obj.level = options2.level === void 0 ? scLevel : options2.level;
      obj.enabled = "enabled" in options2 ? options2.enabled : obj.level > 0;
    }
    __name(applyOptions, "applyOptions");
    function Chalk(options2) {
      if (!this || !(this instanceof Chalk) || this.template) {
        const chalk9 = {};
        applyOptions(chalk9, options2);
        chalk9.template = function() {
          const args = [].slice.call(arguments);
          return chalkTag.apply(null, [chalk9.template].concat(args));
        };
        Object.setPrototypeOf(chalk9, Chalk.prototype);
        Object.setPrototypeOf(chalk9.template, chalk9);
        chalk9.template.constructor = Chalk;
        return chalk9.template;
      }
      applyOptions(this, options2);
    }
    __name(Chalk, "Chalk");
    if (isSimpleWindowsTerm) {
      ansiStyles.blue.open = "\x1B[94m";
    }
    for (const key of Object.keys(ansiStyles)) {
      ansiStyles[key].closeRe = new RegExp(escapeStringRegexp(ansiStyles[key].close), "g");
      styles[key] = {
        get() {
          const codes = ansiStyles[key];
          return build.call(this, this._styles ? this._styles.concat(codes) : [codes], this._empty, key);
        }
      };
    }
    styles.visible = {
      get() {
        return build.call(this, this._styles || [], true, "visible");
      }
    };
    ansiStyles.color.closeRe = new RegExp(escapeStringRegexp(ansiStyles.color.close), "g");
    for (const model of Object.keys(ansiStyles.color.ansi)) {
      if (skipModels.has(model)) {
        continue;
      }
      styles[model] = {
        get() {
          const level = this.level;
          return function() {
            const open = ansiStyles.color[levelMapping[level]][model].apply(null, arguments);
            const codes = {
              open,
              close: ansiStyles.color.close,
              closeRe: ansiStyles.color.closeRe
            };
            return build.call(this, this._styles ? this._styles.concat(codes) : [codes], this._empty, model);
          };
        }
      };
    }
    ansiStyles.bgColor.closeRe = new RegExp(escapeStringRegexp(ansiStyles.bgColor.close), "g");
    for (const model of Object.keys(ansiStyles.bgColor.ansi)) {
      if (skipModels.has(model)) {
        continue;
      }
      const bgModel = "bg" + model[0].toUpperCase() + model.slice(1);
      styles[bgModel] = {
        get() {
          const level = this.level;
          return function() {
            const open = ansiStyles.bgColor[levelMapping[level]][model].apply(null, arguments);
            const codes = {
              open,
              close: ansiStyles.bgColor.close,
              closeRe: ansiStyles.bgColor.closeRe
            };
            return build.call(this, this._styles ? this._styles.concat(codes) : [codes], this._empty, model);
          };
        }
      };
    }
    var proto = Object.defineProperties(() => {
    }, styles);
    function build(_styles, _empty, key) {
      const builder = /* @__PURE__ */ __name(function() {
        return applyStyle.apply(builder, arguments);
      }, "builder");
      builder._styles = _styles;
      builder._empty = _empty;
      const self = this;
      Object.defineProperty(builder, "level", {
        enumerable: true,
        get() {
          return self.level;
        },
        set(level) {
          self.level = level;
        }
      });
      Object.defineProperty(builder, "enabled", {
        enumerable: true,
        get() {
          return self.enabled;
        },
        set(enabled) {
          self.enabled = enabled;
        }
      });
      builder.hasGrey = this.hasGrey || key === "gray" || key === "grey";
      builder.__proto__ = proto;
      return builder;
    }
    __name(build, "build");
    function applyStyle() {
      const args = arguments;
      const argsLen = args.length;
      let str = String(arguments[0]);
      if (argsLen === 0) {
        return "";
      }
      if (argsLen > 1) {
        for (let a = 1; a < argsLen; a++) {
          str += " " + args[a];
        }
      }
      if (!this.enabled || this.level <= 0 || !str) {
        return this._empty ? "" : str;
      }
      const originalDim = ansiStyles.dim.open;
      if (isSimpleWindowsTerm && this.hasGrey) {
        ansiStyles.dim.open = "";
      }
      for (const code of this._styles.slice().reverse()) {
        str = code.open + str.replace(code.closeRe, code.open) + code.close;
        str = str.replace(/\r?\n/g, `${code.close}$&${code.open}`);
      }
      ansiStyles.dim.open = originalDim;
      return str;
    }
    __name(applyStyle, "applyStyle");
    function chalkTag(chalk9, strings) {
      if (!Array.isArray(strings)) {
        return [].slice.call(arguments, 1).join(" ");
      }
      const args = [].slice.call(arguments, 2);
      const parts = [strings.raw[0]];
      for (let i = 1; i < strings.length; i++) {
        parts.push(String(args[i - 1]).replace(/[{}\\]/g, "\\$&"));
        parts.push(String(strings.raw[i]));
      }
      return template(chalk9, parts.join(""));
    }
    __name(chalkTag, "chalkTag");
    Object.defineProperties(Chalk.prototype, styles);
    module2.exports = Chalk();
    module2.exports.supportsColor = stdoutColor;
    module2.exports.default = module2.exports;
  }
});

// ../../node_modules/.pnpm/@babel+highlight@7.18.6/node_modules/@babel/highlight/lib/index.js
var require_lib2 = __commonJS({
  "../../node_modules/.pnpm/@babel+highlight@7.18.6/node_modules/@babel/highlight/lib/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = highlight;
    exports.getChalk = getChalk;
    exports.shouldHighlight = shouldHighlight;
    var _jsTokens = require_js_tokens();
    var _helperValidatorIdentifier = require_lib();
    var _chalk = require_chalk();
    var sometimesKeywords = /* @__PURE__ */ new Set(["as", "async", "from", "get", "of", "set"]);
    function getDefs(chalk9) {
      return {
        keyword: chalk9.cyan,
        capitalized: chalk9.yellow,
        jsxIdentifier: chalk9.yellow,
        punctuator: chalk9.yellow,
        number: chalk9.magenta,
        string: chalk9.green,
        regex: chalk9.magenta,
        comment: chalk9.grey,
        invalid: chalk9.white.bgRed.bold
      };
    }
    __name(getDefs, "getDefs");
    var NEWLINE = /\r\n|[\n\r\u2028\u2029]/;
    var BRACKET = /^[()[\]{}]$/;
    var tokenize;
    {
      const JSX_TAG = /^[a-z][\w-]*$/i;
      const getTokenType = /* @__PURE__ */ __name(function(token, offset, text) {
        if (token.type === "name") {
          if ((0, _helperValidatorIdentifier.isKeyword)(token.value) || (0, _helperValidatorIdentifier.isStrictReservedWord)(token.value, true) || sometimesKeywords.has(token.value)) {
            return "keyword";
          }
          if (JSX_TAG.test(token.value) && (text[offset - 1] === "<" || text.slice(offset - 2, offset) == "</")) {
            return "jsxIdentifier";
          }
          if (token.value[0] !== token.value[0].toLowerCase()) {
            return "capitalized";
          }
        }
        if (token.type === "punctuator" && BRACKET.test(token.value)) {
          return "bracket";
        }
        if (token.type === "invalid" && (token.value === "@" || token.value === "#")) {
          return "punctuator";
        }
        return token.type;
      }, "getTokenType");
      tokenize = /* @__PURE__ */ __name(function* (text) {
        let match;
        while (match = _jsTokens.default.exec(text)) {
          const token = _jsTokens.matchToToken(match);
          yield {
            type: getTokenType(token, match.index, text),
            value: token.value
          };
        }
      }, "tokenize");
    }
    function highlightTokens(defs, text) {
      let highlighted = "";
      for (const {
        type,
        value
      } of tokenize(text)) {
        const colorize = defs[type];
        if (colorize) {
          highlighted += value.split(NEWLINE).map((str) => colorize(str)).join("\n");
        } else {
          highlighted += value;
        }
      }
      return highlighted;
    }
    __name(highlightTokens, "highlightTokens");
    function shouldHighlight(options2) {
      return !!_chalk.supportsColor || options2.forceColor;
    }
    __name(shouldHighlight, "shouldHighlight");
    function getChalk(options2) {
      return options2.forceColor ? new _chalk.constructor({
        enabled: true,
        level: 1
      }) : _chalk;
    }
    __name(getChalk, "getChalk");
    function highlight(code, options2 = {}) {
      if (code !== "" && shouldHighlight(options2)) {
        const chalk9 = getChalk(options2);
        const defs = getDefs(chalk9);
        return highlightTokens(defs, code);
      } else {
        return code;
      }
    }
    __name(highlight, "highlight");
  }
});

// ../../node_modules/.pnpm/@babel+code-frame@7.18.6/node_modules/@babel/code-frame/lib/index.js
var require_lib3 = __commonJS({
  "../../node_modules/.pnpm/@babel+code-frame@7.18.6/node_modules/@babel/code-frame/lib/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.codeFrameColumns = codeFrameColumns;
    exports.default = _default;
    var _highlight = require_lib2();
    var deprecationWarningShown = false;
    function getDefs(chalk9) {
      return {
        gutter: chalk9.grey,
        marker: chalk9.red.bold,
        message: chalk9.red.bold
      };
    }
    __name(getDefs, "getDefs");
    var NEWLINE = /\r\n|[\n\r\u2028\u2029]/;
    function getMarkerLines(loc, source, opts) {
      const startLoc = Object.assign({
        column: 0,
        line: -1
      }, loc.start);
      const endLoc = Object.assign({}, startLoc, loc.end);
      const {
        linesAbove = 2,
        linesBelow = 3
      } = opts || {};
      const startLine = startLoc.line;
      const startColumn = startLoc.column;
      const endLine = endLoc.line;
      const endColumn = endLoc.column;
      let start = Math.max(startLine - (linesAbove + 1), 0);
      let end = Math.min(source.length, endLine + linesBelow);
      if (startLine === -1) {
        start = 0;
      }
      if (endLine === -1) {
        end = source.length;
      }
      const lineDiff = endLine - startLine;
      const markerLines = {};
      if (lineDiff) {
        for (let i = 0; i <= lineDiff; i++) {
          const lineNumber = i + startLine;
          if (!startColumn) {
            markerLines[lineNumber] = true;
          } else if (i === 0) {
            const sourceLength = source[lineNumber - 1].length;
            markerLines[lineNumber] = [startColumn, sourceLength - startColumn + 1];
          } else if (i === lineDiff) {
            markerLines[lineNumber] = [0, endColumn];
          } else {
            const sourceLength = source[lineNumber - i].length;
            markerLines[lineNumber] = [0, sourceLength];
          }
        }
      } else {
        if (startColumn === endColumn) {
          if (startColumn) {
            markerLines[startLine] = [startColumn, 0];
          } else {
            markerLines[startLine] = true;
          }
        } else {
          markerLines[startLine] = [startColumn, endColumn - startColumn];
        }
      }
      return {
        start,
        end,
        markerLines
      };
    }
    __name(getMarkerLines, "getMarkerLines");
    function codeFrameColumns(rawLines, loc, opts = {}) {
      const highlighted = (opts.highlightCode || opts.forceColor) && (0, _highlight.shouldHighlight)(opts);
      const chalk9 = (0, _highlight.getChalk)(opts);
      const defs = getDefs(chalk9);
      const maybeHighlight = /* @__PURE__ */ __name((chalkFn, string) => {
        return highlighted ? chalkFn(string) : string;
      }, "maybeHighlight");
      const lines = rawLines.split(NEWLINE);
      const {
        start,
        end,
        markerLines
      } = getMarkerLines(loc, lines, opts);
      const hasColumns = loc.start && typeof loc.start.column === "number";
      const numberMaxWidth = String(end).length;
      const highlightedLines = highlighted ? (0, _highlight.default)(rawLines, opts) : rawLines;
      let frame = highlightedLines.split(NEWLINE, end).slice(start, end).map((line, index) => {
        const number = start + 1 + index;
        const paddedNumber = ` ${number}`.slice(-numberMaxWidth);
        const gutter = ` ${paddedNumber} |`;
        const hasMarker = markerLines[number];
        const lastMarkerLine = !markerLines[number + 1];
        if (hasMarker) {
          let markerLine = "";
          if (Array.isArray(hasMarker)) {
            const markerSpacing = line.slice(0, Math.max(hasMarker[0] - 1, 0)).replace(/[^\t]/g, " ");
            const numberOfMarkers = hasMarker[1] || 1;
            markerLine = ["\n ", maybeHighlight(defs.gutter, gutter.replace(/\d/g, " ")), " ", markerSpacing, maybeHighlight(defs.marker, "^").repeat(numberOfMarkers)].join("");
            if (lastMarkerLine && opts.message) {
              markerLine += " " + maybeHighlight(defs.message, opts.message);
            }
          }
          return [maybeHighlight(defs.marker, ">"), maybeHighlight(defs.gutter, gutter), line.length > 0 ? ` ${line}` : "", markerLine].join("");
        } else {
          return ` ${maybeHighlight(defs.gutter, gutter)}${line.length > 0 ? ` ${line}` : ""}`;
        }
      }).join("\n");
      if (opts.message && !hasColumns) {
        frame = `${" ".repeat(numberMaxWidth + 1)}${opts.message}
${frame}`;
      }
      if (highlighted) {
        return chalk9.reset(frame);
      } else {
        return frame;
      }
    }
    __name(codeFrameColumns, "codeFrameColumns");
    function _default(rawLines, lineNumber, colNumber, opts = {}) {
      if (!deprecationWarningShown) {
        deprecationWarningShown = true;
        const message = "Passing lineNumber and colNumber is deprecated to @babel/code-frame. Please use `codeFrameColumns`.";
        if (process.emitWarning) {
          process.emitWarning(message, "DeprecationWarning");
        } else {
          const deprecationError = new Error(message);
          deprecationError.name = "DeprecationWarning";
          console.warn(new Error(message));
        }
      }
      colNumber = Math.max(colNumber, 0);
      const location = {
        start: {
          column: colNumber,
          line: lineNumber
        }
      };
      return codeFrameColumns(rawLines, location, opts);
    }
    __name(_default, "_default");
  }
});

// ../../node_modules/.pnpm/parse-json@5.2.0/node_modules/parse-json/index.js
var require_parse_json = __commonJS({
  "../../node_modules/.pnpm/parse-json@5.2.0/node_modules/parse-json/index.js"(exports, module2) {
    "use strict";
    var errorEx = require_error_ex();
    var fallback = require_json_parse_even_better_errors();
    var { default: LinesAndColumns } = require_build();
    var { codeFrameColumns } = require_lib3();
    var JSONError = errorEx("JSONError", {
      fileName: errorEx.append("in %s"),
      codeFrame: errorEx.append("\n\n%s\n")
    });
    var parseJson = /* @__PURE__ */ __name((string, reviver, filename) => {
      if (typeof reviver === "string") {
        filename = reviver;
        reviver = null;
      }
      try {
        try {
          return JSON.parse(string, reviver);
        } catch (error) {
          fallback(string, reviver);
          throw error;
        }
      } catch (error) {
        error.message = error.message.replace(/\n/g, "");
        const indexMatch = error.message.match(/in JSON at position (\d+) while parsing/);
        const jsonError = new JSONError(error);
        if (filename) {
          jsonError.fileName = filename;
        }
        if (indexMatch && indexMatch.length > 0) {
          const lines = new LinesAndColumns(string);
          const index = Number(indexMatch[1]);
          const location = lines.locationForIndex(index);
          const codeFrame = codeFrameColumns(
            string,
            { start: { line: location.line + 1, column: location.column + 1 } },
            { highlightCode: true }
          );
          jsonError.codeFrame = codeFrame;
        }
        throw jsonError;
      }
    }, "parseJson");
    parseJson.JSONError = JSONError;
    module2.exports = parseJson;
  }
});

// ../../node_modules/.pnpm/semver@5.7.1/node_modules/semver/semver.js
var require_semver = __commonJS({
  "../../node_modules/.pnpm/semver@5.7.1/node_modules/semver/semver.js"(exports, module2) {
    exports = module2.exports = SemVer;
    var debug9;
    if (typeof process === "object" && process.env && process.env.NODE_DEBUG && /\bsemver\b/i.test(process.env.NODE_DEBUG)) {
      debug9 = /* @__PURE__ */ __name(function() {
        var args = Array.prototype.slice.call(arguments, 0);
        args.unshift("SEMVER");
        console.log.apply(console, args);
      }, "debug");
    } else {
      debug9 = /* @__PURE__ */ __name(function() {
      }, "debug");
    }
    exports.SEMVER_SPEC_VERSION = "2.0.0";
    var MAX_LENGTH = 256;
    var MAX_SAFE_INTEGER2 = Number.MAX_SAFE_INTEGER || 9007199254740991;
    var MAX_SAFE_COMPONENT_LENGTH = 16;
    var re = exports.re = [];
    var src = exports.src = [];
    var R = 0;
    var NUMERICIDENTIFIER = R++;
    src[NUMERICIDENTIFIER] = "0|[1-9]\\d*";
    var NUMERICIDENTIFIERLOOSE = R++;
    src[NUMERICIDENTIFIERLOOSE] = "[0-9]+";
    var NONNUMERICIDENTIFIER = R++;
    src[NONNUMERICIDENTIFIER] = "\\d*[a-zA-Z-][a-zA-Z0-9-]*";
    var MAINVERSION = R++;
    src[MAINVERSION] = "(" + src[NUMERICIDENTIFIER] + ")\\.(" + src[NUMERICIDENTIFIER] + ")\\.(" + src[NUMERICIDENTIFIER] + ")";
    var MAINVERSIONLOOSE = R++;
    src[MAINVERSIONLOOSE] = "(" + src[NUMERICIDENTIFIERLOOSE] + ")\\.(" + src[NUMERICIDENTIFIERLOOSE] + ")\\.(" + src[NUMERICIDENTIFIERLOOSE] + ")";
    var PRERELEASEIDENTIFIER = R++;
    src[PRERELEASEIDENTIFIER] = "(?:" + src[NUMERICIDENTIFIER] + "|" + src[NONNUMERICIDENTIFIER] + ")";
    var PRERELEASEIDENTIFIERLOOSE = R++;
    src[PRERELEASEIDENTIFIERLOOSE] = "(?:" + src[NUMERICIDENTIFIERLOOSE] + "|" + src[NONNUMERICIDENTIFIER] + ")";
    var PRERELEASE = R++;
    src[PRERELEASE] = "(?:-(" + src[PRERELEASEIDENTIFIER] + "(?:\\." + src[PRERELEASEIDENTIFIER] + ")*))";
    var PRERELEASELOOSE = R++;
    src[PRERELEASELOOSE] = "(?:-?(" + src[PRERELEASEIDENTIFIERLOOSE] + "(?:\\." + src[PRERELEASEIDENTIFIERLOOSE] + ")*))";
    var BUILDIDENTIFIER = R++;
    src[BUILDIDENTIFIER] = "[0-9A-Za-z-]+";
    var BUILD = R++;
    src[BUILD] = "(?:\\+(" + src[BUILDIDENTIFIER] + "(?:\\." + src[BUILDIDENTIFIER] + ")*))";
    var FULL = R++;
    var FULLPLAIN = "v?" + src[MAINVERSION] + src[PRERELEASE] + "?" + src[BUILD] + "?";
    src[FULL] = "^" + FULLPLAIN + "$";
    var LOOSEPLAIN = "[v=\\s]*" + src[MAINVERSIONLOOSE] + src[PRERELEASELOOSE] + "?" + src[BUILD] + "?";
    var LOOSE = R++;
    src[LOOSE] = "^" + LOOSEPLAIN + "$";
    var GTLT = R++;
    src[GTLT] = "((?:<|>)?=?)";
    var XRANGEIDENTIFIERLOOSE = R++;
    src[XRANGEIDENTIFIERLOOSE] = src[NUMERICIDENTIFIERLOOSE] + "|x|X|\\*";
    var XRANGEIDENTIFIER = R++;
    src[XRANGEIDENTIFIER] = src[NUMERICIDENTIFIER] + "|x|X|\\*";
    var XRANGEPLAIN = R++;
    src[XRANGEPLAIN] = "[v=\\s]*(" + src[XRANGEIDENTIFIER] + ")(?:\\.(" + src[XRANGEIDENTIFIER] + ")(?:\\.(" + src[XRANGEIDENTIFIER] + ")(?:" + src[PRERELEASE] + ")?" + src[BUILD] + "?)?)?";
    var XRANGEPLAINLOOSE = R++;
    src[XRANGEPLAINLOOSE] = "[v=\\s]*(" + src[XRANGEIDENTIFIERLOOSE] + ")(?:\\.(" + src[XRANGEIDENTIFIERLOOSE] + ")(?:\\.(" + src[XRANGEIDENTIFIERLOOSE] + ")(?:" + src[PRERELEASELOOSE] + ")?" + src[BUILD] + "?)?)?";
    var XRANGE = R++;
    src[XRANGE] = "^" + src[GTLT] + "\\s*" + src[XRANGEPLAIN] + "$";
    var XRANGELOOSE = R++;
    src[XRANGELOOSE] = "^" + src[GTLT] + "\\s*" + src[XRANGEPLAINLOOSE] + "$";
    var COERCE = R++;
    src[COERCE] = "(?:^|[^\\d])(\\d{1," + MAX_SAFE_COMPONENT_LENGTH + "})(?:\\.(\\d{1," + MAX_SAFE_COMPONENT_LENGTH + "}))?(?:\\.(\\d{1," + MAX_SAFE_COMPONENT_LENGTH + "}))?(?:$|[^\\d])";
    var LONETILDE = R++;
    src[LONETILDE] = "(?:~>?)";
    var TILDETRIM = R++;
    src[TILDETRIM] = "(\\s*)" + src[LONETILDE] + "\\s+";
    re[TILDETRIM] = new RegExp(src[TILDETRIM], "g");
    var tildeTrimReplace = "$1~";
    var TILDE = R++;
    src[TILDE] = "^" + src[LONETILDE] + src[XRANGEPLAIN] + "$";
    var TILDELOOSE = R++;
    src[TILDELOOSE] = "^" + src[LONETILDE] + src[XRANGEPLAINLOOSE] + "$";
    var LONECARET = R++;
    src[LONECARET] = "(?:\\^)";
    var CARETTRIM = R++;
    src[CARETTRIM] = "(\\s*)" + src[LONECARET] + "\\s+";
    re[CARETTRIM] = new RegExp(src[CARETTRIM], "g");
    var caretTrimReplace = "$1^";
    var CARET = R++;
    src[CARET] = "^" + src[LONECARET] + src[XRANGEPLAIN] + "$";
    var CARETLOOSE = R++;
    src[CARETLOOSE] = "^" + src[LONECARET] + src[XRANGEPLAINLOOSE] + "$";
    var COMPARATORLOOSE = R++;
    src[COMPARATORLOOSE] = "^" + src[GTLT] + "\\s*(" + LOOSEPLAIN + ")$|^$";
    var COMPARATOR = R++;
    src[COMPARATOR] = "^" + src[GTLT] + "\\s*(" + FULLPLAIN + ")$|^$";
    var COMPARATORTRIM = R++;
    src[COMPARATORTRIM] = "(\\s*)" + src[GTLT] + "\\s*(" + LOOSEPLAIN + "|" + src[XRANGEPLAIN] + ")";
    re[COMPARATORTRIM] = new RegExp(src[COMPARATORTRIM], "g");
    var comparatorTrimReplace = "$1$2$3";
    var HYPHENRANGE = R++;
    src[HYPHENRANGE] = "^\\s*(" + src[XRANGEPLAIN] + ")\\s+-\\s+(" + src[XRANGEPLAIN] + ")\\s*$";
    var HYPHENRANGELOOSE = R++;
    src[HYPHENRANGELOOSE] = "^\\s*(" + src[XRANGEPLAINLOOSE] + ")\\s+-\\s+(" + src[XRANGEPLAINLOOSE] + ")\\s*$";
    var STAR = R++;
    src[STAR] = "(<|>)?=?\\s*\\*";
    for (i = 0; i < R; i++) {
      debug9(i, src[i]);
      if (!re[i]) {
        re[i] = new RegExp(src[i]);
      }
    }
    var i;
    exports.parse = parse;
    function parse(version, options2) {
      if (!options2 || typeof options2 !== "object") {
        options2 = {
          loose: !!options2,
          includePrerelease: false
        };
      }
      if (version instanceof SemVer) {
        return version;
      }
      if (typeof version !== "string") {
        return null;
      }
      if (version.length > MAX_LENGTH) {
        return null;
      }
      var r2 = options2.loose ? re[LOOSE] : re[FULL];
      if (!r2.test(version)) {
        return null;
      }
      try {
        return new SemVer(version, options2);
      } catch (er) {
        return null;
      }
    }
    __name(parse, "parse");
    exports.valid = valid;
    function valid(version, options2) {
      var v = parse(version, options2);
      return v ? v.version : null;
    }
    __name(valid, "valid");
    exports.clean = clean;
    function clean(version, options2) {
      var s = parse(version.trim().replace(/^[=v]+/, ""), options2);
      return s ? s.version : null;
    }
    __name(clean, "clean");
    exports.SemVer = SemVer;
    function SemVer(version, options2) {
      if (!options2 || typeof options2 !== "object") {
        options2 = {
          loose: !!options2,
          includePrerelease: false
        };
      }
      if (version instanceof SemVer) {
        if (version.loose === options2.loose) {
          return version;
        } else {
          version = version.version;
        }
      } else if (typeof version !== "string") {
        throw new TypeError("Invalid Version: " + version);
      }
      if (version.length > MAX_LENGTH) {
        throw new TypeError("version is longer than " + MAX_LENGTH + " characters");
      }
      if (!(this instanceof SemVer)) {
        return new SemVer(version, options2);
      }
      debug9("SemVer", version, options2);
      this.options = options2;
      this.loose = !!options2.loose;
      var m = version.trim().match(options2.loose ? re[LOOSE] : re[FULL]);
      if (!m) {
        throw new TypeError("Invalid Version: " + version);
      }
      this.raw = version;
      this.major = +m[1];
      this.minor = +m[2];
      this.patch = +m[3];
      if (this.major > MAX_SAFE_INTEGER2 || this.major < 0) {
        throw new TypeError("Invalid major version");
      }
      if (this.minor > MAX_SAFE_INTEGER2 || this.minor < 0) {
        throw new TypeError("Invalid minor version");
      }
      if (this.patch > MAX_SAFE_INTEGER2 || this.patch < 0) {
        throw new TypeError("Invalid patch version");
      }
      if (!m[4]) {
        this.prerelease = [];
      } else {
        this.prerelease = m[4].split(".").map(function(id) {
          if (/^[0-9]+$/.test(id)) {
            var num = +id;
            if (num >= 0 && num < MAX_SAFE_INTEGER2) {
              return num;
            }
          }
          return id;
        });
      }
      this.build = m[5] ? m[5].split(".") : [];
      this.format();
    }
    __name(SemVer, "SemVer");
    SemVer.prototype.format = function() {
      this.version = this.major + "." + this.minor + "." + this.patch;
      if (this.prerelease.length) {
        this.version += "-" + this.prerelease.join(".");
      }
      return this.version;
    };
    SemVer.prototype.toString = function() {
      return this.version;
    };
    SemVer.prototype.compare = function(other) {
      debug9("SemVer.compare", this.version, this.options, other);
      if (!(other instanceof SemVer)) {
        other = new SemVer(other, this.options);
      }
      return this.compareMain(other) || this.comparePre(other);
    };
    SemVer.prototype.compareMain = function(other) {
      if (!(other instanceof SemVer)) {
        other = new SemVer(other, this.options);
      }
      return compareIdentifiers(this.major, other.major) || compareIdentifiers(this.minor, other.minor) || compareIdentifiers(this.patch, other.patch);
    };
    SemVer.prototype.comparePre = function(other) {
      if (!(other instanceof SemVer)) {
        other = new SemVer(other, this.options);
      }
      if (this.prerelease.length && !other.prerelease.length) {
        return -1;
      } else if (!this.prerelease.length && other.prerelease.length) {
        return 1;
      } else if (!this.prerelease.length && !other.prerelease.length) {
        return 0;
      }
      var i2 = 0;
      do {
        var a = this.prerelease[i2];
        var b2 = other.prerelease[i2];
        debug9("prerelease compare", i2, a, b2);
        if (a === void 0 && b2 === void 0) {
          return 0;
        } else if (b2 === void 0) {
          return 1;
        } else if (a === void 0) {
          return -1;
        } else if (a === b2) {
          continue;
        } else {
          return compareIdentifiers(a, b2);
        }
      } while (++i2);
    };
    SemVer.prototype.inc = function(release, identifier) {
      switch (release) {
        case "premajor":
          this.prerelease.length = 0;
          this.patch = 0;
          this.minor = 0;
          this.major++;
          this.inc("pre", identifier);
          break;
        case "preminor":
          this.prerelease.length = 0;
          this.patch = 0;
          this.minor++;
          this.inc("pre", identifier);
          break;
        case "prepatch":
          this.prerelease.length = 0;
          this.inc("patch", identifier);
          this.inc("pre", identifier);
          break;
        case "prerelease":
          if (this.prerelease.length === 0) {
            this.inc("patch", identifier);
          }
          this.inc("pre", identifier);
          break;
        case "major":
          if (this.minor !== 0 || this.patch !== 0 || this.prerelease.length === 0) {
            this.major++;
          }
          this.minor = 0;
          this.patch = 0;
          this.prerelease = [];
          break;
        case "minor":
          if (this.patch !== 0 || this.prerelease.length === 0) {
            this.minor++;
          }
          this.patch = 0;
          this.prerelease = [];
          break;
        case "patch":
          if (this.prerelease.length === 0) {
            this.patch++;
          }
          this.prerelease = [];
          break;
        case "pre":
          if (this.prerelease.length === 0) {
            this.prerelease = [0];
          } else {
            var i2 = this.prerelease.length;
            while (--i2 >= 0) {
              if (typeof this.prerelease[i2] === "number") {
                this.prerelease[i2]++;
                i2 = -2;
              }
            }
            if (i2 === -1) {
              this.prerelease.push(0);
            }
          }
          if (identifier) {
            if (this.prerelease[0] === identifier) {
              if (isNaN(this.prerelease[1])) {
                this.prerelease = [identifier, 0];
              }
            } else {
              this.prerelease = [identifier, 0];
            }
          }
          break;
        default:
          throw new Error("invalid increment argument: " + release);
      }
      this.format();
      this.raw = this.version;
      return this;
    };
    exports.inc = inc;
    function inc(version, release, loose, identifier) {
      if (typeof loose === "string") {
        identifier = loose;
        loose = void 0;
      }
      try {
        return new SemVer(version, loose).inc(release, identifier).version;
      } catch (er) {
        return null;
      }
    }
    __name(inc, "inc");
    exports.diff = diff;
    function diff(version1, version2) {
      if (eq(version1, version2)) {
        return null;
      } else {
        var v1 = parse(version1);
        var v2 = parse(version2);
        var prefix = "";
        if (v1.prerelease.length || v2.prerelease.length) {
          prefix = "pre";
          var defaultResult = "prerelease";
        }
        for (var key in v1) {
          if (key === "major" || key === "minor" || key === "patch") {
            if (v1[key] !== v2[key]) {
              return prefix + key;
            }
          }
        }
        return defaultResult;
      }
    }
    __name(diff, "diff");
    exports.compareIdentifiers = compareIdentifiers;
    var numeric = /^[0-9]+$/;
    function compareIdentifiers(a, b2) {
      var anum = numeric.test(a);
      var bnum = numeric.test(b2);
      if (anum && bnum) {
        a = +a;
        b2 = +b2;
      }
      return a === b2 ? 0 : anum && !bnum ? -1 : bnum && !anum ? 1 : a < b2 ? -1 : 1;
    }
    __name(compareIdentifiers, "compareIdentifiers");
    exports.rcompareIdentifiers = rcompareIdentifiers;
    function rcompareIdentifiers(a, b2) {
      return compareIdentifiers(b2, a);
    }
    __name(rcompareIdentifiers, "rcompareIdentifiers");
    exports.major = major;
    function major(a, loose) {
      return new SemVer(a, loose).major;
    }
    __name(major, "major");
    exports.minor = minor;
    function minor(a, loose) {
      return new SemVer(a, loose).minor;
    }
    __name(minor, "minor");
    exports.patch = patch;
    function patch(a, loose) {
      return new SemVer(a, loose).patch;
    }
    __name(patch, "patch");
    exports.compare = compare;
    function compare(a, b2, loose) {
      return new SemVer(a, loose).compare(new SemVer(b2, loose));
    }
    __name(compare, "compare");
    exports.compareLoose = compareLoose;
    function compareLoose(a, b2) {
      return compare(a, b2, true);
    }
    __name(compareLoose, "compareLoose");
    exports.rcompare = rcompare;
    function rcompare(a, b2, loose) {
      return compare(b2, a, loose);
    }
    __name(rcompare, "rcompare");
    exports.sort = sort;
    function sort(list, loose) {
      return list.sort(function(a, b2) {
        return exports.compare(a, b2, loose);
      });
    }
    __name(sort, "sort");
    exports.rsort = rsort;
    function rsort(list, loose) {
      return list.sort(function(a, b2) {
        return exports.rcompare(a, b2, loose);
      });
    }
    __name(rsort, "rsort");
    exports.gt = gt;
    function gt(a, b2, loose) {
      return compare(a, b2, loose) > 0;
    }
    __name(gt, "gt");
    exports.lt = lt;
    function lt(a, b2, loose) {
      return compare(a, b2, loose) < 0;
    }
    __name(lt, "lt");
    exports.eq = eq;
    function eq(a, b2, loose) {
      return compare(a, b2, loose) === 0;
    }
    __name(eq, "eq");
    exports.neq = neq;
    function neq(a, b2, loose) {
      return compare(a, b2, loose) !== 0;
    }
    __name(neq, "neq");
    exports.gte = gte;
    function gte(a, b2, loose) {
      return compare(a, b2, loose) >= 0;
    }
    __name(gte, "gte");
    exports.lte = lte;
    function lte(a, b2, loose) {
      return compare(a, b2, loose) <= 0;
    }
    __name(lte, "lte");
    exports.cmp = cmp;
    function cmp(a, op, b2, loose) {
      switch (op) {
        case "===":
          if (typeof a === "object")
            a = a.version;
          if (typeof b2 === "object")
            b2 = b2.version;
          return a === b2;
        case "!==":
          if (typeof a === "object")
            a = a.version;
          if (typeof b2 === "object")
            b2 = b2.version;
          return a !== b2;
        case "":
        case "=":
        case "==":
          return eq(a, b2, loose);
        case "!=":
          return neq(a, b2, loose);
        case ">":
          return gt(a, b2, loose);
        case ">=":
          return gte(a, b2, loose);
        case "<":
          return lt(a, b2, loose);
        case "<=":
          return lte(a, b2, loose);
        default:
          throw new TypeError("Invalid operator: " + op);
      }
    }
    __name(cmp, "cmp");
    exports.Comparator = Comparator;
    function Comparator(comp, options2) {
      if (!options2 || typeof options2 !== "object") {
        options2 = {
          loose: !!options2,
          includePrerelease: false
        };
      }
      if (comp instanceof Comparator) {
        if (comp.loose === !!options2.loose) {
          return comp;
        } else {
          comp = comp.value;
        }
      }
      if (!(this instanceof Comparator)) {
        return new Comparator(comp, options2);
      }
      debug9("comparator", comp, options2);
      this.options = options2;
      this.loose = !!options2.loose;
      this.parse(comp);
      if (this.semver === ANY) {
        this.value = "";
      } else {
        this.value = this.operator + this.semver.version;
      }
      debug9("comp", this);
    }
    __name(Comparator, "Comparator");
    var ANY = {};
    Comparator.prototype.parse = function(comp) {
      var r2 = this.options.loose ? re[COMPARATORLOOSE] : re[COMPARATOR];
      var m = comp.match(r2);
      if (!m) {
        throw new TypeError("Invalid comparator: " + comp);
      }
      this.operator = m[1];
      if (this.operator === "=") {
        this.operator = "";
      }
      if (!m[2]) {
        this.semver = ANY;
      } else {
        this.semver = new SemVer(m[2], this.options.loose);
      }
    };
    Comparator.prototype.toString = function() {
      return this.value;
    };
    Comparator.prototype.test = function(version) {
      debug9("Comparator.test", version, this.options.loose);
      if (this.semver === ANY) {
        return true;
      }
      if (typeof version === "string") {
        version = new SemVer(version, this.options);
      }
      return cmp(version, this.operator, this.semver, this.options);
    };
    Comparator.prototype.intersects = function(comp, options2) {
      if (!(comp instanceof Comparator)) {
        throw new TypeError("a Comparator is required");
      }
      if (!options2 || typeof options2 !== "object") {
        options2 = {
          loose: !!options2,
          includePrerelease: false
        };
      }
      var rangeTmp;
      if (this.operator === "") {
        rangeTmp = new Range(comp.value, options2);
        return satisfies(this.value, rangeTmp, options2);
      } else if (comp.operator === "") {
        rangeTmp = new Range(this.value, options2);
        return satisfies(comp.semver, rangeTmp, options2);
      }
      var sameDirectionIncreasing = (this.operator === ">=" || this.operator === ">") && (comp.operator === ">=" || comp.operator === ">");
      var sameDirectionDecreasing = (this.operator === "<=" || this.operator === "<") && (comp.operator === "<=" || comp.operator === "<");
      var sameSemVer = this.semver.version === comp.semver.version;
      var differentDirectionsInclusive = (this.operator === ">=" || this.operator === "<=") && (comp.operator === ">=" || comp.operator === "<=");
      var oppositeDirectionsLessThan = cmp(this.semver, "<", comp.semver, options2) && ((this.operator === ">=" || this.operator === ">") && (comp.operator === "<=" || comp.operator === "<"));
      var oppositeDirectionsGreaterThan = cmp(this.semver, ">", comp.semver, options2) && ((this.operator === "<=" || this.operator === "<") && (comp.operator === ">=" || comp.operator === ">"));
      return sameDirectionIncreasing || sameDirectionDecreasing || sameSemVer && differentDirectionsInclusive || oppositeDirectionsLessThan || oppositeDirectionsGreaterThan;
    };
    exports.Range = Range;
    function Range(range, options2) {
      if (!options2 || typeof options2 !== "object") {
        options2 = {
          loose: !!options2,
          includePrerelease: false
        };
      }
      if (range instanceof Range) {
        if (range.loose === !!options2.loose && range.includePrerelease === !!options2.includePrerelease) {
          return range;
        } else {
          return new Range(range.raw, options2);
        }
      }
      if (range instanceof Comparator) {
        return new Range(range.value, options2);
      }
      if (!(this instanceof Range)) {
        return new Range(range, options2);
      }
      this.options = options2;
      this.loose = !!options2.loose;
      this.includePrerelease = !!options2.includePrerelease;
      this.raw = range;
      this.set = range.split(/\s*\|\|\s*/).map(function(range2) {
        return this.parseRange(range2.trim());
      }, this).filter(function(c) {
        return c.length;
      });
      if (!this.set.length) {
        throw new TypeError("Invalid SemVer Range: " + range);
      }
      this.format();
    }
    __name(Range, "Range");
    Range.prototype.format = function() {
      this.range = this.set.map(function(comps) {
        return comps.join(" ").trim();
      }).join("||").trim();
      return this.range;
    };
    Range.prototype.toString = function() {
      return this.range;
    };
    Range.prototype.parseRange = function(range) {
      var loose = this.options.loose;
      range = range.trim();
      var hr = loose ? re[HYPHENRANGELOOSE] : re[HYPHENRANGE];
      range = range.replace(hr, hyphenReplace);
      debug9("hyphen replace", range);
      range = range.replace(re[COMPARATORTRIM], comparatorTrimReplace);
      debug9("comparator trim", range, re[COMPARATORTRIM]);
      range = range.replace(re[TILDETRIM], tildeTrimReplace);
      range = range.replace(re[CARETTRIM], caretTrimReplace);
      range = range.split(/\s+/).join(" ");
      var compRe = loose ? re[COMPARATORLOOSE] : re[COMPARATOR];
      var set = range.split(" ").map(function(comp) {
        return parseComparator(comp, this.options);
      }, this).join(" ").split(/\s+/);
      if (this.options.loose) {
        set = set.filter(function(comp) {
          return !!comp.match(compRe);
        });
      }
      set = set.map(function(comp) {
        return new Comparator(comp, this.options);
      }, this);
      return set;
    };
    Range.prototype.intersects = function(range, options2) {
      if (!(range instanceof Range)) {
        throw new TypeError("a Range is required");
      }
      return this.set.some(function(thisComparators) {
        return thisComparators.every(function(thisComparator) {
          return range.set.some(function(rangeComparators) {
            return rangeComparators.every(function(rangeComparator) {
              return thisComparator.intersects(rangeComparator, options2);
            });
          });
        });
      });
    };
    exports.toComparators = toComparators;
    function toComparators(range, options2) {
      return new Range(range, options2).set.map(function(comp) {
        return comp.map(function(c) {
          return c.value;
        }).join(" ").trim().split(" ");
      });
    }
    __name(toComparators, "toComparators");
    function parseComparator(comp, options2) {
      debug9("comp", comp, options2);
      comp = replaceCarets(comp, options2);
      debug9("caret", comp);
      comp = replaceTildes(comp, options2);
      debug9("tildes", comp);
      comp = replaceXRanges(comp, options2);
      debug9("xrange", comp);
      comp = replaceStars(comp, options2);
      debug9("stars", comp);
      return comp;
    }
    __name(parseComparator, "parseComparator");
    function isX(id) {
      return !id || id.toLowerCase() === "x" || id === "*";
    }
    __name(isX, "isX");
    function replaceTildes(comp, options2) {
      return comp.trim().split(/\s+/).map(function(comp2) {
        return replaceTilde(comp2, options2);
      }).join(" ");
    }
    __name(replaceTildes, "replaceTildes");
    function replaceTilde(comp, options2) {
      var r2 = options2.loose ? re[TILDELOOSE] : re[TILDE];
      return comp.replace(r2, function(_, M, m, p2, pr) {
        debug9("tilde", comp, _, M, m, p2, pr);
        var ret;
        if (isX(M)) {
          ret = "";
        } else if (isX(m)) {
          ret = ">=" + M + ".0.0 <" + (+M + 1) + ".0.0";
        } else if (isX(p2)) {
          ret = ">=" + M + "." + m + ".0 <" + M + "." + (+m + 1) + ".0";
        } else if (pr) {
          debug9("replaceTilde pr", pr);
          ret = ">=" + M + "." + m + "." + p2 + "-" + pr + " <" + M + "." + (+m + 1) + ".0";
        } else {
          ret = ">=" + M + "." + m + "." + p2 + " <" + M + "." + (+m + 1) + ".0";
        }
        debug9("tilde return", ret);
        return ret;
      });
    }
    __name(replaceTilde, "replaceTilde");
    function replaceCarets(comp, options2) {
      return comp.trim().split(/\s+/).map(function(comp2) {
        return replaceCaret(comp2, options2);
      }).join(" ");
    }
    __name(replaceCarets, "replaceCarets");
    function replaceCaret(comp, options2) {
      debug9("caret", comp, options2);
      var r2 = options2.loose ? re[CARETLOOSE] : re[CARET];
      return comp.replace(r2, function(_, M, m, p2, pr) {
        debug9("caret", comp, _, M, m, p2, pr);
        var ret;
        if (isX(M)) {
          ret = "";
        } else if (isX(m)) {
          ret = ">=" + M + ".0.0 <" + (+M + 1) + ".0.0";
        } else if (isX(p2)) {
          if (M === "0") {
            ret = ">=" + M + "." + m + ".0 <" + M + "." + (+m + 1) + ".0";
          } else {
            ret = ">=" + M + "." + m + ".0 <" + (+M + 1) + ".0.0";
          }
        } else if (pr) {
          debug9("replaceCaret pr", pr);
          if (M === "0") {
            if (m === "0") {
              ret = ">=" + M + "." + m + "." + p2 + "-" + pr + " <" + M + "." + m + "." + (+p2 + 1);
            } else {
              ret = ">=" + M + "." + m + "." + p2 + "-" + pr + " <" + M + "." + (+m + 1) + ".0";
            }
          } else {
            ret = ">=" + M + "." + m + "." + p2 + "-" + pr + " <" + (+M + 1) + ".0.0";
          }
        } else {
          debug9("no pr");
          if (M === "0") {
            if (m === "0") {
              ret = ">=" + M + "." + m + "." + p2 + " <" + M + "." + m + "." + (+p2 + 1);
            } else {
              ret = ">=" + M + "." + m + "." + p2 + " <" + M + "." + (+m + 1) + ".0";
            }
          } else {
            ret = ">=" + M + "." + m + "." + p2 + " <" + (+M + 1) + ".0.0";
          }
        }
        debug9("caret return", ret);
        return ret;
      });
    }
    __name(replaceCaret, "replaceCaret");
    function replaceXRanges(comp, options2) {
      debug9("replaceXRanges", comp, options2);
      return comp.split(/\s+/).map(function(comp2) {
        return replaceXRange(comp2, options2);
      }).join(" ");
    }
    __name(replaceXRanges, "replaceXRanges");
    function replaceXRange(comp, options2) {
      comp = comp.trim();
      var r2 = options2.loose ? re[XRANGELOOSE] : re[XRANGE];
      return comp.replace(r2, function(ret, gtlt, M, m, p2, pr) {
        debug9("xRange", comp, ret, gtlt, M, m, p2, pr);
        var xM = isX(M);
        var xm = xM || isX(m);
        var xp = xm || isX(p2);
        var anyX = xp;
        if (gtlt === "=" && anyX) {
          gtlt = "";
        }
        if (xM) {
          if (gtlt === ">" || gtlt === "<") {
            ret = "<0.0.0";
          } else {
            ret = "*";
          }
        } else if (gtlt && anyX) {
          if (xm) {
            m = 0;
          }
          p2 = 0;
          if (gtlt === ">") {
            gtlt = ">=";
            if (xm) {
              M = +M + 1;
              m = 0;
              p2 = 0;
            } else {
              m = +m + 1;
              p2 = 0;
            }
          } else if (gtlt === "<=") {
            gtlt = "<";
            if (xm) {
              M = +M + 1;
            } else {
              m = +m + 1;
            }
          }
          ret = gtlt + M + "." + m + "." + p2;
        } else if (xm) {
          ret = ">=" + M + ".0.0 <" + (+M + 1) + ".0.0";
        } else if (xp) {
          ret = ">=" + M + "." + m + ".0 <" + M + "." + (+m + 1) + ".0";
        }
        debug9("xRange return", ret);
        return ret;
      });
    }
    __name(replaceXRange, "replaceXRange");
    function replaceStars(comp, options2) {
      debug9("replaceStars", comp, options2);
      return comp.trim().replace(re[STAR], "");
    }
    __name(replaceStars, "replaceStars");
    function hyphenReplace($0, from, fM, fm, fp, fpr, fb, to, tM, tm, tp, tpr, tb) {
      if (isX(fM)) {
        from = "";
      } else if (isX(fm)) {
        from = ">=" + fM + ".0.0";
      } else if (isX(fp)) {
        from = ">=" + fM + "." + fm + ".0";
      } else {
        from = ">=" + from;
      }
      if (isX(tM)) {
        to = "";
      } else if (isX(tm)) {
        to = "<" + (+tM + 1) + ".0.0";
      } else if (isX(tp)) {
        to = "<" + tM + "." + (+tm + 1) + ".0";
      } else if (tpr) {
        to = "<=" + tM + "." + tm + "." + tp + "-" + tpr;
      } else {
        to = "<=" + to;
      }
      return (from + " " + to).trim();
    }
    __name(hyphenReplace, "hyphenReplace");
    Range.prototype.test = function(version) {
      if (!version) {
        return false;
      }
      if (typeof version === "string") {
        version = new SemVer(version, this.options);
      }
      for (var i2 = 0; i2 < this.set.length; i2++) {
        if (testSet(this.set[i2], version, this.options)) {
          return true;
        }
      }
      return false;
    };
    function testSet(set, version, options2) {
      for (var i2 = 0; i2 < set.length; i2++) {
        if (!set[i2].test(version)) {
          return false;
        }
      }
      if (version.prerelease.length && !options2.includePrerelease) {
        for (i2 = 0; i2 < set.length; i2++) {
          debug9(set[i2].semver);
          if (set[i2].semver === ANY) {
            continue;
          }
          if (set[i2].semver.prerelease.length > 0) {
            var allowed = set[i2].semver;
            if (allowed.major === version.major && allowed.minor === version.minor && allowed.patch === version.patch) {
              return true;
            }
          }
        }
        return false;
      }
      return true;
    }
    __name(testSet, "testSet");
    exports.satisfies = satisfies;
    function satisfies(version, range, options2) {
      try {
        range = new Range(range, options2);
      } catch (er) {
        return false;
      }
      return range.test(version);
    }
    __name(satisfies, "satisfies");
    exports.maxSatisfying = maxSatisfying;
    function maxSatisfying(versions, range, options2) {
      var max2 = null;
      var maxSV = null;
      try {
        var rangeObj = new Range(range, options2);
      } catch (er) {
        return null;
      }
      versions.forEach(function(v) {
        if (rangeObj.test(v)) {
          if (!max2 || maxSV.compare(v) === -1) {
            max2 = v;
            maxSV = new SemVer(max2, options2);
          }
        }
      });
      return max2;
    }
    __name(maxSatisfying, "maxSatisfying");
    exports.minSatisfying = minSatisfying;
    function minSatisfying(versions, range, options2) {
      var min2 = null;
      var minSV = null;
      try {
        var rangeObj = new Range(range, options2);
      } catch (er) {
        return null;
      }
      versions.forEach(function(v) {
        if (rangeObj.test(v)) {
          if (!min2 || minSV.compare(v) === 1) {
            min2 = v;
            minSV = new SemVer(min2, options2);
          }
        }
      });
      return min2;
    }
    __name(minSatisfying, "minSatisfying");
    exports.minVersion = minVersion;
    function minVersion(range, loose) {
      range = new Range(range, loose);
      var minver = new SemVer("0.0.0");
      if (range.test(minver)) {
        return minver;
      }
      minver = new SemVer("0.0.0-0");
      if (range.test(minver)) {
        return minver;
      }
      minver = null;
      for (var i2 = 0; i2 < range.set.length; ++i2) {
        var comparators = range.set[i2];
        comparators.forEach(function(comparator) {
          var compver = new SemVer(comparator.semver.version);
          switch (comparator.operator) {
            case ">":
              if (compver.prerelease.length === 0) {
                compver.patch++;
              } else {
                compver.prerelease.push(0);
              }
              compver.raw = compver.format();
            case "":
            case ">=":
              if (!minver || gt(minver, compver)) {
                minver = compver;
              }
              break;
            case "<":
            case "<=":
              break;
            default:
              throw new Error("Unexpected operation: " + comparator.operator);
          }
        });
      }
      if (minver && range.test(minver)) {
        return minver;
      }
      return null;
    }
    __name(minVersion, "minVersion");
    exports.validRange = validRange;
    function validRange(range, options2) {
      try {
        return new Range(range, options2).range || "*";
      } catch (er) {
        return null;
      }
    }
    __name(validRange, "validRange");
    exports.ltr = ltr;
    function ltr(version, range, options2) {
      return outside(version, range, "<", options2);
    }
    __name(ltr, "ltr");
    exports.gtr = gtr;
    function gtr(version, range, options2) {
      return outside(version, range, ">", options2);
    }
    __name(gtr, "gtr");
    exports.outside = outside;
    function outside(version, range, hilo, options2) {
      version = new SemVer(version, options2);
      range = new Range(range, options2);
      var gtfn, ltefn, ltfn, comp, ecomp;
      switch (hilo) {
        case ">":
          gtfn = gt;
          ltefn = lte;
          ltfn = lt;
          comp = ">";
          ecomp = ">=";
          break;
        case "<":
          gtfn = lt;
          ltefn = gte;
          ltfn = gt;
          comp = "<";
          ecomp = "<=";
          break;
        default:
          throw new TypeError('Must provide a hilo val of "<" or ">"');
      }
      if (satisfies(version, range, options2)) {
        return false;
      }
      for (var i2 = 0; i2 < range.set.length; ++i2) {
        var comparators = range.set[i2];
        var high = null;
        var low = null;
        comparators.forEach(function(comparator) {
          if (comparator.semver === ANY) {
            comparator = new Comparator(">=0.0.0");
          }
          high = high || comparator;
          low = low || comparator;
          if (gtfn(comparator.semver, high.semver, options2)) {
            high = comparator;
          } else if (ltfn(comparator.semver, low.semver, options2)) {
            low = comparator;
          }
        });
        if (high.operator === comp || high.operator === ecomp) {
          return false;
        }
        if ((!low.operator || low.operator === comp) && ltefn(version, low.semver)) {
          return false;
        } else if (low.operator === ecomp && ltfn(version, low.semver)) {
          return false;
        }
      }
      return true;
    }
    __name(outside, "outside");
    exports.prerelease = prerelease;
    function prerelease(version, options2) {
      var parsed = parse(version, options2);
      return parsed && parsed.prerelease.length ? parsed.prerelease : null;
    }
    __name(prerelease, "prerelease");
    exports.intersects = intersects;
    function intersects(r1, r2, options2) {
      r1 = new Range(r1, options2);
      r2 = new Range(r2, options2);
      return r1.intersects(r2);
    }
    __name(intersects, "intersects");
    exports.coerce = coerce;
    function coerce(version) {
      if (version instanceof SemVer) {
        return version;
      }
      if (typeof version !== "string") {
        return null;
      }
      var match = version.match(re[COERCE]);
      if (match == null) {
        return null;
      }
      return parse(match[1] + "." + (match[2] || "0") + "." + (match[3] || "0"));
    }
    __name(coerce, "coerce");
  }
});

// ../../node_modules/.pnpm/spdx-license-ids@3.0.12/node_modules/spdx-license-ids/index.json
var require_spdx_license_ids = __commonJS({
  "../../node_modules/.pnpm/spdx-license-ids@3.0.12/node_modules/spdx-license-ids/index.json"(exports, module2) {
    module2.exports = [
      "0BSD",
      "AAL",
      "ADSL",
      "AFL-1.1",
      "AFL-1.2",
      "AFL-2.0",
      "AFL-2.1",
      "AFL-3.0",
      "AGPL-1.0-only",
      "AGPL-1.0-or-later",
      "AGPL-3.0-only",
      "AGPL-3.0-or-later",
      "AMDPLPA",
      "AML",
      "AMPAS",
      "ANTLR-PD",
      "ANTLR-PD-fallback",
      "APAFML",
      "APL-1.0",
      "APSL-1.0",
      "APSL-1.1",
      "APSL-1.2",
      "APSL-2.0",
      "Abstyles",
      "Adobe-2006",
      "Adobe-Glyph",
      "Afmparse",
      "Aladdin",
      "Apache-1.0",
      "Apache-1.1",
      "Apache-2.0",
      "App-s2p",
      "Arphic-1999",
      "Artistic-1.0",
      "Artistic-1.0-Perl",
      "Artistic-1.0-cl8",
      "Artistic-2.0",
      "BSD-1-Clause",
      "BSD-2-Clause",
      "BSD-2-Clause-Patent",
      "BSD-2-Clause-Views",
      "BSD-3-Clause",
      "BSD-3-Clause-Attribution",
      "BSD-3-Clause-Clear",
      "BSD-3-Clause-LBNL",
      "BSD-3-Clause-Modification",
      "BSD-3-Clause-No-Military-License",
      "BSD-3-Clause-No-Nuclear-License",
      "BSD-3-Clause-No-Nuclear-License-2014",
      "BSD-3-Clause-No-Nuclear-Warranty",
      "BSD-3-Clause-Open-MPI",
      "BSD-4-Clause",
      "BSD-4-Clause-Shortened",
      "BSD-4-Clause-UC",
      "BSD-Protection",
      "BSD-Source-Code",
      "BSL-1.0",
      "BUSL-1.1",
      "Baekmuk",
      "Bahyph",
      "Barr",
      "Beerware",
      "BitTorrent-1.0",
      "BitTorrent-1.1",
      "Bitstream-Vera",
      "BlueOak-1.0.0",
      "Borceux",
      "C-UDA-1.0",
      "CAL-1.0",
      "CAL-1.0-Combined-Work-Exception",
      "CATOSL-1.1",
      "CC-BY-1.0",
      "CC-BY-2.0",
      "CC-BY-2.5",
      "CC-BY-2.5-AU",
      "CC-BY-3.0",
      "CC-BY-3.0-AT",
      "CC-BY-3.0-DE",
      "CC-BY-3.0-IGO",
      "CC-BY-3.0-NL",
      "CC-BY-3.0-US",
      "CC-BY-4.0",
      "CC-BY-NC-1.0",
      "CC-BY-NC-2.0",
      "CC-BY-NC-2.5",
      "CC-BY-NC-3.0",
      "CC-BY-NC-3.0-DE",
      "CC-BY-NC-4.0",
      "CC-BY-NC-ND-1.0",
      "CC-BY-NC-ND-2.0",
      "CC-BY-NC-ND-2.5",
      "CC-BY-NC-ND-3.0",
      "CC-BY-NC-ND-3.0-DE",
      "CC-BY-NC-ND-3.0-IGO",
      "CC-BY-NC-ND-4.0",
      "CC-BY-NC-SA-1.0",
      "CC-BY-NC-SA-2.0",
      "CC-BY-NC-SA-2.0-FR",
      "CC-BY-NC-SA-2.0-UK",
      "CC-BY-NC-SA-2.5",
      "CC-BY-NC-SA-3.0",
      "CC-BY-NC-SA-3.0-DE",
      "CC-BY-NC-SA-3.0-IGO",
      "CC-BY-NC-SA-4.0",
      "CC-BY-ND-1.0",
      "CC-BY-ND-2.0",
      "CC-BY-ND-2.5",
      "CC-BY-ND-3.0",
      "CC-BY-ND-3.0-DE",
      "CC-BY-ND-4.0",
      "CC-BY-SA-1.0",
      "CC-BY-SA-2.0",
      "CC-BY-SA-2.0-UK",
      "CC-BY-SA-2.1-JP",
      "CC-BY-SA-2.5",
      "CC-BY-SA-3.0",
      "CC-BY-SA-3.0-AT",
      "CC-BY-SA-3.0-DE",
      "CC-BY-SA-4.0",
      "CC-PDDC",
      "CC0-1.0",
      "CDDL-1.0",
      "CDDL-1.1",
      "CDL-1.0",
      "CDLA-Permissive-1.0",
      "CDLA-Permissive-2.0",
      "CDLA-Sharing-1.0",
      "CECILL-1.0",
      "CECILL-1.1",
      "CECILL-2.0",
      "CECILL-2.1",
      "CECILL-B",
      "CECILL-C",
      "CERN-OHL-1.1",
      "CERN-OHL-1.2",
      "CERN-OHL-P-2.0",
      "CERN-OHL-S-2.0",
      "CERN-OHL-W-2.0",
      "CNRI-Jython",
      "CNRI-Python",
      "CNRI-Python-GPL-Compatible",
      "COIL-1.0",
      "CPAL-1.0",
      "CPL-1.0",
      "CPOL-1.02",
      "CUA-OPL-1.0",
      "Caldera",
      "ClArtistic",
      "Community-Spec-1.0",
      "Condor-1.1",
      "Crossword",
      "CrystalStacker",
      "Cube",
      "D-FSL-1.0",
      "DL-DE-BY-2.0",
      "DOC",
      "DRL-1.0",
      "DSDP",
      "Dotseqn",
      "ECL-1.0",
      "ECL-2.0",
      "EFL-1.0",
      "EFL-2.0",
      "EPICS",
      "EPL-1.0",
      "EPL-2.0",
      "EUDatagrid",
      "EUPL-1.0",
      "EUPL-1.1",
      "EUPL-1.2",
      "Elastic-2.0",
      "Entessa",
      "ErlPL-1.1",
      "Eurosym",
      "FDK-AAC",
      "FSFAP",
      "FSFUL",
      "FSFULLR",
      "FTL",
      "Fair",
      "Frameworx-1.0",
      "FreeBSD-DOC",
      "FreeImage",
      "GD",
      "GFDL-1.1-invariants-only",
      "GFDL-1.1-invariants-or-later",
      "GFDL-1.1-no-invariants-only",
      "GFDL-1.1-no-invariants-or-later",
      "GFDL-1.1-only",
      "GFDL-1.1-or-later",
      "GFDL-1.2-invariants-only",
      "GFDL-1.2-invariants-or-later",
      "GFDL-1.2-no-invariants-only",
      "GFDL-1.2-no-invariants-or-later",
      "GFDL-1.2-only",
      "GFDL-1.2-or-later",
      "GFDL-1.3-invariants-only",
      "GFDL-1.3-invariants-or-later",
      "GFDL-1.3-no-invariants-only",
      "GFDL-1.3-no-invariants-or-later",
      "GFDL-1.3-only",
      "GFDL-1.3-or-later",
      "GL2PS",
      "GLWTPL",
      "GPL-1.0-only",
      "GPL-1.0-or-later",
      "GPL-2.0-only",
      "GPL-2.0-or-later",
      "GPL-3.0-only",
      "GPL-3.0-or-later",
      "Giftware",
      "Glide",
      "Glulxe",
      "HPND",
      "HPND-sell-variant",
      "HTMLTIDY",
      "HaskellReport",
      "Hippocratic-2.1",
      "IBM-pibs",
      "ICU",
      "IJG",
      "IPA",
      "IPL-1.0",
      "ISC",
      "ImageMagick",
      "Imlib2",
      "Info-ZIP",
      "Intel",
      "Intel-ACPI",
      "Interbase-1.0",
      "JPNIC",
      "JSON",
      "Jam",
      "JasPer-2.0",
      "LAL-1.2",
      "LAL-1.3",
      "LGPL-2.0-only",
      "LGPL-2.0-or-later",
      "LGPL-2.1-only",
      "LGPL-2.1-or-later",
      "LGPL-3.0-only",
      "LGPL-3.0-or-later",
      "LGPLLR",
      "LPL-1.0",
      "LPL-1.02",
      "LPPL-1.0",
      "LPPL-1.1",
      "LPPL-1.2",
      "LPPL-1.3a",
      "LPPL-1.3c",
      "LZMA-SDK-9.11-to-9.20",
      "LZMA-SDK-9.22",
      "Latex2e",
      "Leptonica",
      "LiLiQ-P-1.1",
      "LiLiQ-R-1.1",
      "LiLiQ-Rplus-1.1",
      "Libpng",
      "Linux-OpenIB",
      "Linux-man-pages-copyleft",
      "MIT",
      "MIT-0",
      "MIT-CMU",
      "MIT-Modern-Variant",
      "MIT-advertising",
      "MIT-enna",
      "MIT-feh",
      "MIT-open-group",
      "MITNFA",
      "MPL-1.0",
      "MPL-1.1",
      "MPL-2.0",
      "MPL-2.0-no-copyleft-exception",
      "MS-LPL",
      "MS-PL",
      "MS-RL",
      "MTLL",
      "MakeIndex",
      "Minpack",
      "MirOS",
      "Motosoto",
      "MulanPSL-1.0",
      "MulanPSL-2.0",
      "Multics",
      "Mup",
      "NAIST-2003",
      "NASA-1.3",
      "NBPL-1.0",
      "NCGL-UK-2.0",
      "NCSA",
      "NGPL",
      "NICTA-1.0",
      "NIST-PD",
      "NIST-PD-fallback",
      "NLOD-1.0",
      "NLOD-2.0",
      "NLPL",
      "NOSL",
      "NPL-1.0",
      "NPL-1.1",
      "NPOSL-3.0",
      "NRL",
      "NTP",
      "NTP-0",
      "Naumen",
      "Net-SNMP",
      "NetCDF",
      "Newsletr",
      "Nokia",
      "Noweb",
      "O-UDA-1.0",
      "OCCT-PL",
      "OCLC-2.0",
      "ODC-By-1.0",
      "ODbL-1.0",
      "OFL-1.0",
      "OFL-1.0-RFN",
      "OFL-1.0-no-RFN",
      "OFL-1.1",
      "OFL-1.1-RFN",
      "OFL-1.1-no-RFN",
      "OGC-1.0",
      "OGDL-Taiwan-1.0",
      "OGL-Canada-2.0",
      "OGL-UK-1.0",
      "OGL-UK-2.0",
      "OGL-UK-3.0",
      "OGTSL",
      "OLDAP-1.1",
      "OLDAP-1.2",
      "OLDAP-1.3",
      "OLDAP-1.4",
      "OLDAP-2.0",
      "OLDAP-2.0.1",
      "OLDAP-2.1",
      "OLDAP-2.2",
      "OLDAP-2.2.1",
      "OLDAP-2.2.2",
      "OLDAP-2.3",
      "OLDAP-2.4",
      "OLDAP-2.5",
      "OLDAP-2.6",
      "OLDAP-2.7",
      "OLDAP-2.8",
      "OML",
      "OPL-1.0",
      "OPUBL-1.0",
      "OSET-PL-2.1",
      "OSL-1.0",
      "OSL-1.1",
      "OSL-2.0",
      "OSL-2.1",
      "OSL-3.0",
      "OpenSSL",
      "PDDL-1.0",
      "PHP-3.0",
      "PHP-3.01",
      "PSF-2.0",
      "Parity-6.0.0",
      "Parity-7.0.0",
      "Plexus",
      "PolyForm-Noncommercial-1.0.0",
      "PolyForm-Small-Business-1.0.0",
      "PostgreSQL",
      "Python-2.0",
      "Python-2.0.1",
      "QPL-1.0",
      "Qhull",
      "RHeCos-1.1",
      "RPL-1.1",
      "RPL-1.5",
      "RPSL-1.0",
      "RSA-MD",
      "RSCPL",
      "Rdisc",
      "Ruby",
      "SAX-PD",
      "SCEA",
      "SGI-B-1.0",
      "SGI-B-1.1",
      "SGI-B-2.0",
      "SHL-0.5",
      "SHL-0.51",
      "SISSL",
      "SISSL-1.2",
      "SMLNJ",
      "SMPPL",
      "SNIA",
      "SPL-1.0",
      "SSH-OpenSSH",
      "SSH-short",
      "SSPL-1.0",
      "SWL",
      "Saxpath",
      "SchemeReport",
      "Sendmail",
      "Sendmail-8.23",
      "SimPL-2.0",
      "Sleepycat",
      "Spencer-86",
      "Spencer-94",
      "Spencer-99",
      "SugarCRM-1.1.3",
      "TAPR-OHL-1.0",
      "TCL",
      "TCP-wrappers",
      "TMate",
      "TORQUE-1.1",
      "TOSL",
      "TU-Berlin-1.0",
      "TU-Berlin-2.0",
      "UCL-1.0",
      "UPL-1.0",
      "Unicode-DFS-2015",
      "Unicode-DFS-2016",
      "Unicode-TOU",
      "Unlicense",
      "VOSTROM",
      "VSL-1.0",
      "Vim",
      "W3C",
      "W3C-19980720",
      "W3C-20150513",
      "WTFPL",
      "Watcom-1.0",
      "Wsuipa",
      "X11",
      "X11-distribute-modifications-variant",
      "XFree86-1.1",
      "XSkat",
      "Xerox",
      "Xnet",
      "YPL-1.0",
      "YPL-1.1",
      "ZPL-1.1",
      "ZPL-2.0",
      "ZPL-2.1",
      "Zed",
      "Zend-2.0",
      "Zimbra-1.3",
      "Zimbra-1.4",
      "Zlib",
      "blessing",
      "bzip2-1.0.6",
      "copyleft-next-0.3.0",
      "copyleft-next-0.3.1",
      "curl",
      "diffmark",
      "dvipdfm",
      "eGenix",
      "etalab-2.0",
      "gSOAP-1.3b",
      "gnuplot",
      "iMatix",
      "libpng-2.0",
      "libselinux-1.0",
      "libtiff",
      "mpi-permissive",
      "mpich2",
      "mplus",
      "psfrag",
      "psutils",
      "xinetd",
      "xpp",
      "zlib-acknowledgement"
    ];
  }
});

// ../../node_modules/.pnpm/spdx-exceptions@2.3.0/node_modules/spdx-exceptions/index.json
var require_spdx_exceptions = __commonJS({
  "../../node_modules/.pnpm/spdx-exceptions@2.3.0/node_modules/spdx-exceptions/index.json"(exports, module2) {
    module2.exports = [
      "389-exception",
      "Autoconf-exception-2.0",
      "Autoconf-exception-3.0",
      "Bison-exception-2.2",
      "Bootloader-exception",
      "Classpath-exception-2.0",
      "CLISP-exception-2.0",
      "DigiRule-FOSS-exception",
      "eCos-exception-2.0",
      "Fawkes-Runtime-exception",
      "FLTK-exception",
      "Font-exception-2.0",
      "freertos-exception-2.0",
      "GCC-exception-2.0",
      "GCC-exception-3.1",
      "gnu-javamail-exception",
      "GPL-3.0-linking-exception",
      "GPL-3.0-linking-source-exception",
      "GPL-CC-1.0",
      "i2p-gpl-java-exception",
      "Libtool-exception",
      "Linux-syscall-note",
      "LLVM-exception",
      "LZMA-exception",
      "mif-exception",
      "Nokia-Qt-exception-1.1",
      "OCaml-LGPL-linking-exception",
      "OCCT-exception-1.0",
      "OpenJDK-assembly-exception-1.0",
      "openvpn-openssl-exception",
      "PS-or-PDF-font-exception-20170817",
      "Qt-GPL-exception-1.0",
      "Qt-LGPL-exception-1.1",
      "Qwt-exception-1.0",
      "Swift-exception",
      "u-boot-exception-2.0",
      "Universal-FOSS-exception-1.0",
      "WxWindows-exception-3.1"
    ];
  }
});

// ../../node_modules/.pnpm/spdx-expression-parse@3.0.1/node_modules/spdx-expression-parse/scan.js
var require_scan = __commonJS({
  "../../node_modules/.pnpm/spdx-expression-parse@3.0.1/node_modules/spdx-expression-parse/scan.js"(exports, module2) {
    "use strict";
    var licenses = [].concat(require_spdx_license_ids()).concat(require_spdx_license_ids());
    var exceptions = require_spdx_exceptions();
    module2.exports = function(source) {
      var index = 0;
      function hasMore() {
        return index < source.length;
      }
      __name(hasMore, "hasMore");
      function read(value) {
        if (value instanceof RegExp) {
          var chars = source.slice(index);
          var match = chars.match(value);
          if (match) {
            index += match[0].length;
            return match[0];
          }
        } else {
          if (source.indexOf(value, index) === index) {
            index += value.length;
            return value;
          }
        }
      }
      __name(read, "read");
      function skipWhitespace() {
        read(/[ ]*/);
      }
      __name(skipWhitespace, "skipWhitespace");
      function operator() {
        var string;
        var possibilities = ["WITH", "AND", "OR", "(", ")", ":", "+"];
        for (var i = 0; i < possibilities.length; i++) {
          string = read(possibilities[i]);
          if (string) {
            break;
          }
        }
        if (string === "+" && index > 1 && source[index - 2] === " ") {
          throw new Error("Space before `+`");
        }
        return string && {
          type: "OPERATOR",
          string
        };
      }
      __name(operator, "operator");
      function idstring() {
        return read(/[A-Za-z0-9-.]+/);
      }
      __name(idstring, "idstring");
      function expectIdstring() {
        var string = idstring();
        if (!string) {
          throw new Error("Expected idstring at offset " + index);
        }
        return string;
      }
      __name(expectIdstring, "expectIdstring");
      function documentRef() {
        if (read("DocumentRef-")) {
          var string = expectIdstring();
          return { type: "DOCUMENTREF", string };
        }
      }
      __name(documentRef, "documentRef");
      function licenseRef() {
        if (read("LicenseRef-")) {
          var string = expectIdstring();
          return { type: "LICENSEREF", string };
        }
      }
      __name(licenseRef, "licenseRef");
      function identifier() {
        var begin = index;
        var string = idstring();
        if (licenses.indexOf(string) !== -1) {
          return {
            type: "LICENSE",
            string
          };
        } else if (exceptions.indexOf(string) !== -1) {
          return {
            type: "EXCEPTION",
            string
          };
        }
        index = begin;
      }
      __name(identifier, "identifier");
      function parseToken() {
        return operator() || documentRef() || licenseRef() || identifier();
      }
      __name(parseToken, "parseToken");
      var tokens = [];
      while (hasMore()) {
        skipWhitespace();
        if (!hasMore()) {
          break;
        }
        var token = parseToken();
        if (!token) {
          throw new Error("Unexpected `" + source[index] + "` at offset " + index);
        }
        tokens.push(token);
      }
      return tokens;
    };
  }
});

// ../../node_modules/.pnpm/spdx-expression-parse@3.0.1/node_modules/spdx-expression-parse/parse.js
var require_parse2 = __commonJS({
  "../../node_modules/.pnpm/spdx-expression-parse@3.0.1/node_modules/spdx-expression-parse/parse.js"(exports, module2) {
    "use strict";
    module2.exports = function(tokens) {
      var index = 0;
      function hasMore() {
        return index < tokens.length;
      }
      __name(hasMore, "hasMore");
      function token() {
        return hasMore() ? tokens[index] : null;
      }
      __name(token, "token");
      function next() {
        if (!hasMore()) {
          throw new Error();
        }
        index++;
      }
      __name(next, "next");
      function parseOperator(operator) {
        var t3 = token();
        if (t3 && t3.type === "OPERATOR" && operator === t3.string) {
          next();
          return t3.string;
        }
      }
      __name(parseOperator, "parseOperator");
      function parseWith() {
        if (parseOperator("WITH")) {
          var t3 = token();
          if (t3 && t3.type === "EXCEPTION") {
            next();
            return t3.string;
          }
          throw new Error("Expected exception after `WITH`");
        }
      }
      __name(parseWith, "parseWith");
      function parseLicenseRef() {
        var begin = index;
        var string = "";
        var t3 = token();
        if (t3.type === "DOCUMENTREF") {
          next();
          string += "DocumentRef-" + t3.string + ":";
          if (!parseOperator(":")) {
            throw new Error("Expected `:` after `DocumentRef-...`");
          }
        }
        t3 = token();
        if (t3.type === "LICENSEREF") {
          next();
          string += "LicenseRef-" + t3.string;
          return { license: string };
        }
        index = begin;
      }
      __name(parseLicenseRef, "parseLicenseRef");
      function parseLicense() {
        var t3 = token();
        if (t3 && t3.type === "LICENSE") {
          next();
          var node2 = { license: t3.string };
          if (parseOperator("+")) {
            node2.plus = true;
          }
          var exception = parseWith();
          if (exception) {
            node2.exception = exception;
          }
          return node2;
        }
      }
      __name(parseLicense, "parseLicense");
      function parseParenthesizedExpression() {
        var left2 = parseOperator("(");
        if (!left2) {
          return;
        }
        var expr = parseExpression();
        if (!parseOperator(")")) {
          throw new Error("Expected `)`");
        }
        return expr;
      }
      __name(parseParenthesizedExpression, "parseParenthesizedExpression");
      function parseAtom() {
        return parseParenthesizedExpression() || parseLicenseRef() || parseLicense();
      }
      __name(parseAtom, "parseAtom");
      function makeBinaryOpParser(operator, nextParser) {
        return /* @__PURE__ */ __name(function parseBinaryOp() {
          var left2 = nextParser();
          if (!left2) {
            return;
          }
          if (!parseOperator(operator)) {
            return left2;
          }
          var right2 = parseBinaryOp();
          if (!right2) {
            throw new Error("Expected expression");
          }
          return {
            left: left2,
            conjunction: operator.toLowerCase(),
            right: right2
          };
        }, "parseBinaryOp");
      }
      __name(makeBinaryOpParser, "makeBinaryOpParser");
      var parseAnd = makeBinaryOpParser("AND", parseAtom);
      var parseExpression = makeBinaryOpParser("OR", parseAnd);
      var node = parseExpression();
      if (!node || hasMore()) {
        throw new Error("Syntax error");
      }
      return node;
    };
  }
});

// ../../node_modules/.pnpm/spdx-expression-parse@3.0.1/node_modules/spdx-expression-parse/index.js
var require_spdx_expression_parse = __commonJS({
  "../../node_modules/.pnpm/spdx-expression-parse@3.0.1/node_modules/spdx-expression-parse/index.js"(exports, module2) {
    "use strict";
    var scan = require_scan();
    var parse = require_parse2();
    module2.exports = function(source) {
      return parse(scan(source));
    };
  }
});

// ../../node_modules/.pnpm/spdx-correct@3.1.1/node_modules/spdx-correct/index.js
var require_spdx_correct = __commonJS({
  "../../node_modules/.pnpm/spdx-correct@3.1.1/node_modules/spdx-correct/index.js"(exports, module2) {
    var parse = require_spdx_expression_parse();
    var spdxLicenseIds = require_spdx_license_ids();
    function valid(string) {
      try {
        parse(string);
        return true;
      } catch (error) {
        return false;
      }
    }
    __name(valid, "valid");
    var transpositions = [
      ["APGL", "AGPL"],
      ["Gpl", "GPL"],
      ["GLP", "GPL"],
      ["APL", "Apache"],
      ["ISD", "ISC"],
      ["GLP", "GPL"],
      ["IST", "ISC"],
      ["Claude", "Clause"],
      [" or later", "+"],
      [" International", ""],
      ["GNU", "GPL"],
      ["GUN", "GPL"],
      ["+", ""],
      ["GNU GPL", "GPL"],
      ["GNU/GPL", "GPL"],
      ["GNU GLP", "GPL"],
      ["GNU General Public License", "GPL"],
      ["Gnu public license", "GPL"],
      ["GNU Public License", "GPL"],
      ["GNU GENERAL PUBLIC LICENSE", "GPL"],
      ["MTI", "MIT"],
      ["Mozilla Public License", "MPL"],
      ["Universal Permissive License", "UPL"],
      ["WTH", "WTF"],
      ["-License", ""]
    ];
    var TRANSPOSED = 0;
    var CORRECT = 1;
    var transforms = [
      function(argument) {
        return argument.toUpperCase();
      },
      function(argument) {
        return argument.trim();
      },
      function(argument) {
        return argument.replace(/\./g, "");
      },
      function(argument) {
        return argument.replace(/\s+/g, "");
      },
      function(argument) {
        return argument.replace(/\s+/g, "-");
      },
      function(argument) {
        return argument.replace("v", "-");
      },
      function(argument) {
        return argument.replace(/,?\s*(\d)/, "-$1");
      },
      function(argument) {
        return argument.replace(/,?\s*(\d)/, "-$1.0");
      },
      function(argument) {
        return argument.replace(/,?\s*(V\.|v\.|V|v|Version|version)\s*(\d)/, "-$2");
      },
      function(argument) {
        return argument.replace(/,?\s*(V\.|v\.|V|v|Version|version)\s*(\d)/, "-$2.0");
      },
      function(argument) {
        return argument[0].toUpperCase() + argument.slice(1);
      },
      function(argument) {
        return argument.replace("/", "-");
      },
      function(argument) {
        return argument.replace(/\s*V\s*(\d)/, "-$1").replace(/(\d)$/, "$1.0");
      },
      function(argument) {
        if (argument.indexOf("3.0") !== -1) {
          return argument + "-or-later";
        } else {
          return argument + "-only";
        }
      },
      function(argument) {
        return argument + "only";
      },
      function(argument) {
        return argument.replace(/(\d)$/, "-$1.0");
      },
      function(argument) {
        return argument.replace(/(-| )?(\d)$/, "-$2-Clause");
      },
      function(argument) {
        return argument.replace(/(-| )clause(-| )(\d)/, "-$3-Clause");
      },
      function(argument) {
        return argument.replace(/\b(Modified|New|Revised)(-| )?BSD((-| )License)?/i, "BSD-3-Clause");
      },
      function(argument) {
        return argument.replace(/\bSimplified(-| )?BSD((-| )License)?/i, "BSD-2-Clause");
      },
      function(argument) {
        return argument.replace(/\b(Free|Net)(-| )?BSD((-| )License)?/i, "BSD-2-Clause-$1BSD");
      },
      function(argument) {
        return argument.replace(/\bClear(-| )?BSD((-| )License)?/i, "BSD-3-Clause-Clear");
      },
      function(argument) {
        return argument.replace(/\b(Old|Original)(-| )?BSD((-| )License)?/i, "BSD-4-Clause");
      },
      function(argument) {
        return "CC-" + argument;
      },
      function(argument) {
        return "CC-" + argument + "-4.0";
      },
      function(argument) {
        return argument.replace("Attribution", "BY").replace("NonCommercial", "NC").replace("NoDerivatives", "ND").replace(/ (\d)/, "-$1").replace(/ ?International/, "");
      },
      function(argument) {
        return "CC-" + argument.replace("Attribution", "BY").replace("NonCommercial", "NC").replace("NoDerivatives", "ND").replace(/ (\d)/, "-$1").replace(/ ?International/, "") + "-4.0";
      }
    ];
    var licensesWithVersions = spdxLicenseIds.map(function(id) {
      var match = /^(.*)-\d+\.\d+$/.exec(id);
      return match ? [match[0], match[1]] : [id, null];
    }).reduce(function(objectMap, item) {
      var key = item[1];
      objectMap[key] = objectMap[key] || [];
      objectMap[key].push(item[0]);
      return objectMap;
    }, {});
    var licensesWithOneVersion = Object.keys(licensesWithVersions).map(/* @__PURE__ */ __name(function makeEntries(key) {
      return [key, licensesWithVersions[key]];
    }, "makeEntries")).filter(/* @__PURE__ */ __name(function identifySoleVersions(item) {
      return item[1].length === 1 && item[0] !== null && item[0] !== "APL";
    }, "identifySoleVersions")).map(/* @__PURE__ */ __name(function createLastResorts(item) {
      return [item[0], item[1][0]];
    }, "createLastResorts"));
    licensesWithVersions = void 0;
    var lastResorts = [
      ["UNLI", "Unlicense"],
      ["WTF", "WTFPL"],
      ["2 CLAUSE", "BSD-2-Clause"],
      ["2-CLAUSE", "BSD-2-Clause"],
      ["3 CLAUSE", "BSD-3-Clause"],
      ["3-CLAUSE", "BSD-3-Clause"],
      ["AFFERO", "AGPL-3.0-or-later"],
      ["AGPL", "AGPL-3.0-or-later"],
      ["APACHE", "Apache-2.0"],
      ["ARTISTIC", "Artistic-2.0"],
      ["Affero", "AGPL-3.0-or-later"],
      ["BEER", "Beerware"],
      ["BOOST", "BSL-1.0"],
      ["BSD", "BSD-2-Clause"],
      ["CDDL", "CDDL-1.1"],
      ["ECLIPSE", "EPL-1.0"],
      ["FUCK", "WTFPL"],
      ["GNU", "GPL-3.0-or-later"],
      ["LGPL", "LGPL-3.0-or-later"],
      ["GPLV1", "GPL-1.0-only"],
      ["GPL-1", "GPL-1.0-only"],
      ["GPLV2", "GPL-2.0-only"],
      ["GPL-2", "GPL-2.0-only"],
      ["GPL", "GPL-3.0-or-later"],
      ["MIT +NO-FALSE-ATTRIBS", "MITNFA"],
      ["MIT", "MIT"],
      ["MPL", "MPL-2.0"],
      ["X11", "X11"],
      ["ZLIB", "Zlib"]
    ].concat(licensesWithOneVersion);
    var SUBSTRING = 0;
    var IDENTIFIER = 1;
    var validTransformation = /* @__PURE__ */ __name(function(identifier) {
      for (var i = 0; i < transforms.length; i++) {
        var transformed = transforms[i](identifier).trim();
        if (transformed !== identifier && valid(transformed)) {
          return transformed;
        }
      }
      return null;
    }, "validTransformation");
    var validLastResort = /* @__PURE__ */ __name(function(identifier) {
      var upperCased = identifier.toUpperCase();
      for (var i = 0; i < lastResorts.length; i++) {
        var lastResort = lastResorts[i];
        if (upperCased.indexOf(lastResort[SUBSTRING]) > -1) {
          return lastResort[IDENTIFIER];
        }
      }
      return null;
    }, "validLastResort");
    var anyCorrection = /* @__PURE__ */ __name(function(identifier, check) {
      for (var i = 0; i < transpositions.length; i++) {
        var transposition = transpositions[i];
        var transposed = transposition[TRANSPOSED];
        if (identifier.indexOf(transposed) > -1) {
          var corrected = identifier.replace(
            transposed,
            transposition[CORRECT]
          );
          var checked = check(corrected);
          if (checked !== null) {
            return checked;
          }
        }
      }
      return null;
    }, "anyCorrection");
    module2.exports = function(identifier, options2) {
      options2 = options2 || {};
      var upgrade = options2.upgrade === void 0 ? true : !!options2.upgrade;
      function postprocess(value) {
        return upgrade ? upgradeGPLs(value) : value;
      }
      __name(postprocess, "postprocess");
      var validArugment = typeof identifier === "string" && identifier.trim().length !== 0;
      if (!validArugment) {
        throw Error("Invalid argument. Expected non-empty string.");
      }
      identifier = identifier.trim();
      if (valid(identifier)) {
        return postprocess(identifier);
      }
      var noPlus = identifier.replace(/\+$/, "").trim();
      if (valid(noPlus)) {
        return postprocess(noPlus);
      }
      var transformed = validTransformation(identifier);
      if (transformed !== null) {
        return postprocess(transformed);
      }
      transformed = anyCorrection(identifier, function(argument) {
        if (valid(argument)) {
          return argument;
        }
        return validTransformation(argument);
      });
      if (transformed !== null) {
        return postprocess(transformed);
      }
      transformed = validLastResort(identifier);
      if (transformed !== null) {
        return postprocess(transformed);
      }
      transformed = anyCorrection(identifier, validLastResort);
      if (transformed !== null) {
        return postprocess(transformed);
      }
      return null;
    };
    function upgradeGPLs(value) {
      if ([
        "GPL-1.0",
        "LGPL-1.0",
        "AGPL-1.0",
        "GPL-2.0",
        "LGPL-2.0",
        "AGPL-2.0",
        "LGPL-2.1"
      ].indexOf(value) !== -1) {
        return value + "-only";
      } else if ([
        "GPL-1.0+",
        "GPL-2.0+",
        "GPL-3.0+",
        "LGPL-2.0+",
        "LGPL-2.1+",
        "LGPL-3.0+",
        "AGPL-1.0+",
        "AGPL-3.0+"
      ].indexOf(value) !== -1) {
        return value.replace(/\+$/, "-or-later");
      } else if (["GPL-3.0", "LGPL-3.0", "AGPL-3.0"].indexOf(value) !== -1) {
        return value + "-or-later";
      } else {
        return value;
      }
    }
    __name(upgradeGPLs, "upgradeGPLs");
  }
});

// ../../node_modules/.pnpm/validate-npm-package-license@3.0.4/node_modules/validate-npm-package-license/index.js
var require_validate_npm_package_license = __commonJS({
  "../../node_modules/.pnpm/validate-npm-package-license@3.0.4/node_modules/validate-npm-package-license/index.js"(exports, module2) {
    var parse = require_spdx_expression_parse();
    var correct = require_spdx_correct();
    var genericWarning = 'license should be a valid SPDX license expression (without "LicenseRef"), "UNLICENSED", or "SEE LICENSE IN <filename>"';
    var fileReferenceRE = /^SEE LICEN[CS]E IN (.+)$/;
    function startsWith(prefix, string) {
      return string.slice(0, prefix.length) === prefix;
    }
    __name(startsWith, "startsWith");
    function usesLicenseRef(ast) {
      if (ast.hasOwnProperty("license")) {
        var license = ast.license;
        return startsWith("LicenseRef", license) || startsWith("DocumentRef", license);
      } else {
        return usesLicenseRef(ast.left) || usesLicenseRef(ast.right);
      }
    }
    __name(usesLicenseRef, "usesLicenseRef");
    module2.exports = function(argument) {
      var ast;
      try {
        ast = parse(argument);
      } catch (e2) {
        var match;
        if (argument === "UNLICENSED" || argument === "UNLICENCED") {
          return {
            validForOldPackages: true,
            validForNewPackages: true,
            unlicensed: true
          };
        } else if (match = fileReferenceRE.exec(argument)) {
          return {
            validForOldPackages: true,
            validForNewPackages: true,
            inFile: match[1]
          };
        } else {
          var result = {
            validForOldPackages: false,
            validForNewPackages: false,
            warnings: [genericWarning]
          };
          if (argument.trim().length !== 0) {
            var corrected = correct(argument);
            if (corrected) {
              result.warnings.push(
                'license is similar to the valid expression "' + corrected + '"'
              );
            }
          }
          return result;
        }
      }
      if (usesLicenseRef(ast)) {
        return {
          validForNewPackages: false,
          validForOldPackages: false,
          spdx: true,
          warnings: [genericWarning]
        };
      } else {
        return {
          validForNewPackages: true,
          validForOldPackages: true,
          spdx: true
        };
      }
    };
  }
});

// ../../node_modules/.pnpm/hosted-git-info@2.8.9/node_modules/hosted-git-info/git-host-info.js
var require_git_host_info = __commonJS({
  "../../node_modules/.pnpm/hosted-git-info@2.8.9/node_modules/hosted-git-info/git-host-info.js"(exports, module2) {
    "use strict";
    var gitHosts = module2.exports = {
      github: {
        "protocols": ["git", "http", "git+ssh", "git+https", "ssh", "https"],
        "domain": "github.com",
        "treepath": "tree",
        "filetemplate": "https://{auth@}raw.githubusercontent.com/{user}/{project}/{committish}/{path}",
        "bugstemplate": "https://{domain}/{user}/{project}/issues",
        "gittemplate": "git://{auth@}{domain}/{user}/{project}.git{#committish}",
        "tarballtemplate": "https://codeload.{domain}/{user}/{project}/tar.gz/{committish}"
      },
      bitbucket: {
        "protocols": ["git+ssh", "git+https", "ssh", "https"],
        "domain": "bitbucket.org",
        "treepath": "src",
        "tarballtemplate": "https://{domain}/{user}/{project}/get/{committish}.tar.gz"
      },
      gitlab: {
        "protocols": ["git+ssh", "git+https", "ssh", "https"],
        "domain": "gitlab.com",
        "treepath": "tree",
        "bugstemplate": "https://{domain}/{user}/{project}/issues",
        "httpstemplate": "git+https://{auth@}{domain}/{user}/{projectPath}.git{#committish}",
        "tarballtemplate": "https://{domain}/{user}/{project}/repository/archive.tar.gz?ref={committish}",
        "pathmatch": /^[/]([^/]+)[/]((?!.*(\/-\/|\/repository\/archive\.tar\.gz\?=.*|\/repository\/[^/]+\/archive.tar.gz$)).*?)(?:[.]git|[/])?$/
      },
      gist: {
        "protocols": ["git", "git+ssh", "git+https", "ssh", "https"],
        "domain": "gist.github.com",
        "pathmatch": /^[/](?:([^/]+)[/])?([a-z0-9]{32,})(?:[.]git)?$/,
        "filetemplate": "https://gist.githubusercontent.com/{user}/{project}/raw{/committish}/{path}",
        "bugstemplate": "https://{domain}/{project}",
        "gittemplate": "git://{domain}/{project}.git{#committish}",
        "sshtemplate": "git@{domain}:/{project}.git{#committish}",
        "sshurltemplate": "git+ssh://git@{domain}/{project}.git{#committish}",
        "browsetemplate": "https://{domain}/{project}{/committish}",
        "browsefiletemplate": "https://{domain}/{project}{/committish}{#path}",
        "docstemplate": "https://{domain}/{project}{/committish}",
        "httpstemplate": "git+https://{domain}/{project}.git{#committish}",
        "shortcuttemplate": "{type}:{project}{#committish}",
        "pathtemplate": "{project}{#committish}",
        "tarballtemplate": "https://codeload.github.com/gist/{project}/tar.gz/{committish}",
        "hashformat": function(fragment) {
          return "file-" + formatHashFragment(fragment);
        }
      }
    };
    var gitHostDefaults = {
      "sshtemplate": "git@{domain}:{user}/{project}.git{#committish}",
      "sshurltemplate": "git+ssh://git@{domain}/{user}/{project}.git{#committish}",
      "browsetemplate": "https://{domain}/{user}/{project}{/tree/committish}",
      "browsefiletemplate": "https://{domain}/{user}/{project}/{treepath}/{committish}/{path}{#fragment}",
      "docstemplate": "https://{domain}/{user}/{project}{/tree/committish}#readme",
      "httpstemplate": "git+https://{auth@}{domain}/{user}/{project}.git{#committish}",
      "filetemplate": "https://{domain}/{user}/{project}/raw/{committish}/{path}",
      "shortcuttemplate": "{type}:{user}/{project}{#committish}",
      "pathtemplate": "{user}/{project}{#committish}",
      "pathmatch": /^[/]([^/]+)[/]([^/]+?)(?:[.]git|[/])?$/,
      "hashformat": formatHashFragment
    };
    Object.keys(gitHosts).forEach(function(name) {
      Object.keys(gitHostDefaults).forEach(function(key) {
        if (gitHosts[name][key])
          return;
        gitHosts[name][key] = gitHostDefaults[key];
      });
      gitHosts[name].protocols_re = RegExp("^(" + gitHosts[name].protocols.map(function(protocol) {
        return protocol.replace(/([\\+*{}()[\]$^|])/g, "\\$1");
      }).join("|") + "):$");
    });
    function formatHashFragment(fragment) {
      return fragment.toLowerCase().replace(/^\W+|\/|\W+$/g, "").replace(/\W+/g, "-");
    }
    __name(formatHashFragment, "formatHashFragment");
  }
});

// ../../node_modules/.pnpm/hosted-git-info@2.8.9/node_modules/hosted-git-info/git-host.js
var require_git_host = __commonJS({
  "../../node_modules/.pnpm/hosted-git-info@2.8.9/node_modules/hosted-git-info/git-host.js"(exports, module2) {
    "use strict";
    var gitHosts = require_git_host_info();
    var extend = Object.assign || /* @__PURE__ */ __name(function _extend(target, source) {
      if (source === null || typeof source !== "object")
        return target;
      var keys = Object.keys(source);
      var i = keys.length;
      while (i--) {
        target[keys[i]] = source[keys[i]];
      }
      return target;
    }, "_extend");
    module2.exports = GitHost;
    function GitHost(type, user, auth, project, committish, defaultRepresentation, opts) {
      var gitHostInfo = this;
      gitHostInfo.type = type;
      Object.keys(gitHosts[type]).forEach(function(key) {
        gitHostInfo[key] = gitHosts[type][key];
      });
      gitHostInfo.user = user;
      gitHostInfo.auth = auth;
      gitHostInfo.project = project;
      gitHostInfo.committish = committish;
      gitHostInfo.default = defaultRepresentation;
      gitHostInfo.opts = opts || {};
    }
    __name(GitHost, "GitHost");
    GitHost.prototype.hash = function() {
      return this.committish ? "#" + this.committish : "";
    };
    GitHost.prototype._fill = function(template, opts) {
      if (!template)
        return;
      var vars = extend({}, opts);
      vars.path = vars.path ? vars.path.replace(/^[/]+/g, "") : "";
      opts = extend(extend({}, this.opts), opts);
      var self = this;
      Object.keys(this).forEach(function(key) {
        if (self[key] != null && vars[key] == null)
          vars[key] = self[key];
      });
      var rawAuth = vars.auth;
      var rawcommittish = vars.committish;
      var rawFragment = vars.fragment;
      var rawPath = vars.path;
      var rawProject = vars.project;
      Object.keys(vars).forEach(function(key) {
        var value = vars[key];
        if ((key === "path" || key === "project") && typeof value === "string") {
          vars[key] = value.split("/").map(function(pathComponent) {
            return encodeURIComponent(pathComponent);
          }).join("/");
        } else {
          vars[key] = encodeURIComponent(value);
        }
      });
      vars["auth@"] = rawAuth ? rawAuth + "@" : "";
      vars["#fragment"] = rawFragment ? "#" + this.hashformat(rawFragment) : "";
      vars.fragment = vars.fragment ? vars.fragment : "";
      vars["#path"] = rawPath ? "#" + this.hashformat(rawPath) : "";
      vars["/path"] = vars.path ? "/" + vars.path : "";
      vars.projectPath = rawProject.split("/").map(encodeURIComponent).join("/");
      if (opts.noCommittish) {
        vars["#committish"] = "";
        vars["/tree/committish"] = "";
        vars["/committish"] = "";
        vars.committish = "";
      } else {
        vars["#committish"] = rawcommittish ? "#" + rawcommittish : "";
        vars["/tree/committish"] = vars.committish ? "/" + vars.treepath + "/" + vars.committish : "";
        vars["/committish"] = vars.committish ? "/" + vars.committish : "";
        vars.committish = vars.committish || "master";
      }
      var res = template;
      Object.keys(vars).forEach(function(key) {
        res = res.replace(new RegExp("[{]" + key + "[}]", "g"), vars[key]);
      });
      if (opts.noGitPlus) {
        return res.replace(/^git[+]/, "");
      } else {
        return res;
      }
    };
    GitHost.prototype.ssh = function(opts) {
      return this._fill(this.sshtemplate, opts);
    };
    GitHost.prototype.sshurl = function(opts) {
      return this._fill(this.sshurltemplate, opts);
    };
    GitHost.prototype.browse = function(P2, F, opts) {
      if (typeof P2 === "string") {
        if (typeof F !== "string") {
          opts = F;
          F = null;
        }
        return this._fill(this.browsefiletemplate, extend({
          fragment: F,
          path: P2
        }, opts));
      } else {
        return this._fill(this.browsetemplate, P2);
      }
    };
    GitHost.prototype.docs = function(opts) {
      return this._fill(this.docstemplate, opts);
    };
    GitHost.prototype.bugs = function(opts) {
      return this._fill(this.bugstemplate, opts);
    };
    GitHost.prototype.https = function(opts) {
      return this._fill(this.httpstemplate, opts);
    };
    GitHost.prototype.git = function(opts) {
      return this._fill(this.gittemplate, opts);
    };
    GitHost.prototype.shortcut = function(opts) {
      return this._fill(this.shortcuttemplate, opts);
    };
    GitHost.prototype.path = function(opts) {
      return this._fill(this.pathtemplate, opts);
    };
    GitHost.prototype.tarball = function(opts_) {
      var opts = extend({}, opts_, { noCommittish: false });
      return this._fill(this.tarballtemplate, opts);
    };
    GitHost.prototype.file = function(P2, opts) {
      return this._fill(this.filetemplate, extend({ path: P2 }, opts));
    };
    GitHost.prototype.getDefaultRepresentation = function() {
      return this.default;
    };
    GitHost.prototype.toString = function(opts) {
      if (this.default && typeof this[this.default] === "function")
        return this[this.default](opts);
      return this.sshurl(opts);
    };
  }
});

// ../../node_modules/.pnpm/hosted-git-info@2.8.9/node_modules/hosted-git-info/index.js
var require_hosted_git_info = __commonJS({
  "../../node_modules/.pnpm/hosted-git-info@2.8.9/node_modules/hosted-git-info/index.js"(exports, module2) {
    "use strict";
    var url = require("url");
    var gitHosts = require_git_host_info();
    var GitHost = module2.exports = require_git_host();
    var protocolToRepresentationMap = {
      "git+ssh:": "sshurl",
      "git+https:": "https",
      "ssh:": "sshurl",
      "git:": "git"
    };
    function protocolToRepresentation(protocol) {
      return protocolToRepresentationMap[protocol] || protocol.slice(0, -1);
    }
    __name(protocolToRepresentation, "protocolToRepresentation");
    var authProtocols = {
      "git:": true,
      "https:": true,
      "git+https:": true,
      "http:": true,
      "git+http:": true
    };
    var cache = {};
    module2.exports.fromUrl = function(giturl, opts) {
      if (typeof giturl !== "string")
        return;
      var key = giturl + JSON.stringify(opts || {});
      if (!(key in cache)) {
        cache[key] = fromUrl(giturl, opts);
      }
      return cache[key];
    };
    function fromUrl(giturl, opts) {
      if (giturl == null || giturl === "")
        return;
      var url2 = fixupUnqualifiedGist(
        isGitHubShorthand(giturl) ? "github:" + giturl : giturl
      );
      var parsed = parseGitUrl(url2);
      var shortcutMatch = url2.match(/^([^:]+):(?:[^@]+@)?(?:([^/]*)\/)?([^#]+)/);
      var matches = Object.keys(gitHosts).map(function(gitHostName) {
        try {
          var gitHostInfo = gitHosts[gitHostName];
          var auth = null;
          if (parsed.auth && authProtocols[parsed.protocol]) {
            auth = parsed.auth;
          }
          var committish = parsed.hash ? decodeURIComponent(parsed.hash.substr(1)) : null;
          var user = null;
          var project = null;
          var defaultRepresentation = null;
          if (shortcutMatch && shortcutMatch[1] === gitHostName) {
            user = shortcutMatch[2] && decodeURIComponent(shortcutMatch[2]);
            project = decodeURIComponent(shortcutMatch[3].replace(/\.git$/, ""));
            defaultRepresentation = "shortcut";
          } else {
            if (parsed.host && parsed.host !== gitHostInfo.domain && parsed.host.replace(/^www[.]/, "") !== gitHostInfo.domain)
              return;
            if (!gitHostInfo.protocols_re.test(parsed.protocol))
              return;
            if (!parsed.path)
              return;
            var pathmatch = gitHostInfo.pathmatch;
            var matched = parsed.path.match(pathmatch);
            if (!matched)
              return;
            if (matched[1] !== null && matched[1] !== void 0) {
              user = decodeURIComponent(matched[1].replace(/^:/, ""));
            }
            project = decodeURIComponent(matched[2]);
            defaultRepresentation = protocolToRepresentation(parsed.protocol);
          }
          return new GitHost(gitHostName, user, auth, project, committish, defaultRepresentation, opts);
        } catch (ex) {
          if (ex instanceof URIError) {
          } else
            throw ex;
        }
      }).filter(function(gitHostInfo) {
        return gitHostInfo;
      });
      if (matches.length !== 1)
        return;
      return matches[0];
    }
    __name(fromUrl, "fromUrl");
    function isGitHubShorthand(arg) {
      return /^[^:@%/\s.-][^:@%/\s]*[/][^:@\s/%]+(?:#.*)?$/.test(arg);
    }
    __name(isGitHubShorthand, "isGitHubShorthand");
    function fixupUnqualifiedGist(giturl) {
      var parsed = url.parse(giturl);
      if (parsed.protocol === "gist:" && parsed.host && !parsed.path) {
        return parsed.protocol + "/" + parsed.host;
      } else {
        return giturl;
      }
    }
    __name(fixupUnqualifiedGist, "fixupUnqualifiedGist");
    function parseGitUrl(giturl) {
      var matched = giturl.match(/^([^@]+)@([^:/]+):[/]?((?:[^/]+[/])?[^/]+?)(?:[.]git)?(#.*)?$/);
      if (!matched) {
        var legacy = url.parse(giturl);
        if (legacy.auth && typeof url.URL === "function") {
          var authmatch = giturl.match(/[^@]+@[^:/]+/);
          if (authmatch) {
            var whatwg = new url.URL(authmatch[0]);
            legacy.auth = whatwg.username || "";
            if (whatwg.password)
              legacy.auth += ":" + whatwg.password;
          }
        }
        return legacy;
      }
      return {
        protocol: "git+ssh:",
        slashes: true,
        auth: matched[1],
        host: matched[2],
        port: null,
        hostname: matched[2],
        hash: matched[4],
        search: null,
        query: null,
        pathname: "/" + matched[3],
        path: "/" + matched[3],
        href: "git+ssh://" + matched[1] + "@" + matched[2] + "/" + matched[3] + (matched[4] || "")
      };
    }
    __name(parseGitUrl, "parseGitUrl");
  }
});

// ../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/homedir.js
var require_homedir = __commonJS({
  "../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/homedir.js"(exports, module2) {
    "use strict";
    var os2 = require("os");
    module2.exports = os2.homedir || /* @__PURE__ */ __name(function homedir() {
      var home = process.env.HOME;
      var user = process.env.LOGNAME || process.env.USER || process.env.LNAME || process.env.USERNAME;
      if (process.platform === "win32") {
        return process.env.USERPROFILE || process.env.HOMEDRIVE + process.env.HOMEPATH || home || null;
      }
      if (process.platform === "darwin") {
        return home || (user ? "/Users/" + user : null);
      }
      if (process.platform === "linux") {
        return home || (process.getuid() === 0 ? "/root" : user ? "/home/" + user : null);
      }
      return home || null;
    }, "homedir");
  }
});

// ../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/caller.js
var require_caller = __commonJS({
  "../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/caller.js"(exports, module2) {
    module2.exports = function() {
      var origPrepareStackTrace = Error.prepareStackTrace;
      Error.prepareStackTrace = function(_, stack2) {
        return stack2;
      };
      var stack = new Error().stack;
      Error.prepareStackTrace = origPrepareStackTrace;
      return stack[2].getFileName();
    };
  }
});

// ../../node_modules/.pnpm/path-parse@1.0.7/node_modules/path-parse/index.js
var require_path_parse = __commonJS({
  "../../node_modules/.pnpm/path-parse@1.0.7/node_modules/path-parse/index.js"(exports, module2) {
    "use strict";
    var isWindows = process.platform === "win32";
    var splitWindowsRe = /^(((?:[a-zA-Z]:|[\\\/]{2}[^\\\/]+[\\\/]+[^\\\/]+)?[\\\/]?)(?:[^\\\/]*[\\\/])*)((\.{1,2}|[^\\\/]+?|)(\.[^.\/\\]*|))[\\\/]*$/;
    var win32 = {};
    function win32SplitPath(filename) {
      return splitWindowsRe.exec(filename).slice(1);
    }
    __name(win32SplitPath, "win32SplitPath");
    win32.parse = function(pathString) {
      if (typeof pathString !== "string") {
        throw new TypeError(
          "Parameter 'pathString' must be a string, not " + typeof pathString
        );
      }
      var allParts = win32SplitPath(pathString);
      if (!allParts || allParts.length !== 5) {
        throw new TypeError("Invalid path '" + pathString + "'");
      }
      return {
        root: allParts[1],
        dir: allParts[0] === allParts[1] ? allParts[0] : allParts[0].slice(0, -1),
        base: allParts[2],
        ext: allParts[4],
        name: allParts[3]
      };
    };
    var splitPathRe = /^((\/?)(?:[^\/]*\/)*)((\.{1,2}|[^\/]+?|)(\.[^.\/]*|))[\/]*$/;
    var posix = {};
    function posixSplitPath(filename) {
      return splitPathRe.exec(filename).slice(1);
    }
    __name(posixSplitPath, "posixSplitPath");
    posix.parse = function(pathString) {
      if (typeof pathString !== "string") {
        throw new TypeError(
          "Parameter 'pathString' must be a string, not " + typeof pathString
        );
      }
      var allParts = posixSplitPath(pathString);
      if (!allParts || allParts.length !== 5) {
        throw new TypeError("Invalid path '" + pathString + "'");
      }
      return {
        root: allParts[1],
        dir: allParts[0].slice(0, -1),
        base: allParts[2],
        ext: allParts[4],
        name: allParts[3]
      };
    };
    if (isWindows)
      module2.exports = win32.parse;
    else
      module2.exports = posix.parse;
    module2.exports.posix = posix.parse;
    module2.exports.win32 = win32.parse;
  }
});

// ../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/node-modules-paths.js
var require_node_modules_paths = __commonJS({
  "../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/node-modules-paths.js"(exports, module2) {
    var path9 = require("path");
    var parse = path9.parse || require_path_parse();
    var getNodeModulesDirs = /* @__PURE__ */ __name(function getNodeModulesDirs2(absoluteStart, modules) {
      var prefix = "/";
      if (/^([A-Za-z]:)/.test(absoluteStart)) {
        prefix = "";
      } else if (/^\\\\/.test(absoluteStart)) {
        prefix = "\\\\";
      }
      var paths = [absoluteStart];
      var parsed = parse(absoluteStart);
      while (parsed.dir !== paths[paths.length - 1]) {
        paths.push(parsed.dir);
        parsed = parse(parsed.dir);
      }
      return paths.reduce(function(dirs, aPath) {
        return dirs.concat(modules.map(function(moduleDir) {
          return path9.resolve(prefix, aPath, moduleDir);
        }));
      }, []);
    }, "getNodeModulesDirs");
    module2.exports = /* @__PURE__ */ __name(function nodeModulesPaths(start, opts, request) {
      var modules = opts && opts.moduleDirectory ? [].concat(opts.moduleDirectory) : ["node_modules"];
      if (opts && typeof opts.paths === "function") {
        return opts.paths(
          request,
          start,
          function() {
            return getNodeModulesDirs(start, modules);
          },
          opts
        );
      }
      var dirs = getNodeModulesDirs(start, modules);
      return opts && opts.paths ? dirs.concat(opts.paths) : dirs;
    }, "nodeModulesPaths");
  }
});

// ../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/normalize-options.js
var require_normalize_options = __commonJS({
  "../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/normalize-options.js"(exports, module2) {
    module2.exports = function(x, opts) {
      return opts || {};
    };
  }
});

// ../../node_modules/.pnpm/function-bind@1.1.1/node_modules/function-bind/implementation.js
var require_implementation = __commonJS({
  "../../node_modules/.pnpm/function-bind@1.1.1/node_modules/function-bind/implementation.js"(exports, module2) {
    "use strict";
    var ERROR_MESSAGE = "Function.prototype.bind called on incompatible ";
    var slice = Array.prototype.slice;
    var toStr = Object.prototype.toString;
    var funcType = "[object Function]";
    module2.exports = /* @__PURE__ */ __name(function bind(that) {
      var target = this;
      if (typeof target !== "function" || toStr.call(target) !== funcType) {
        throw new TypeError(ERROR_MESSAGE + target);
      }
      var args = slice.call(arguments, 1);
      var bound;
      var binder = /* @__PURE__ */ __name(function() {
        if (this instanceof bound) {
          var result = target.apply(
            this,
            args.concat(slice.call(arguments))
          );
          if (Object(result) === result) {
            return result;
          }
          return this;
        } else {
          return target.apply(
            that,
            args.concat(slice.call(arguments))
          );
        }
      }, "binder");
      var boundLength = Math.max(0, target.length - args.length);
      var boundArgs = [];
      for (var i = 0; i < boundLength; i++) {
        boundArgs.push("$" + i);
      }
      bound = Function("binder", "return function (" + boundArgs.join(",") + "){ return binder.apply(this,arguments); }")(binder);
      if (target.prototype) {
        var Empty = /* @__PURE__ */ __name(function Empty2() {
        }, "Empty");
        Empty.prototype = target.prototype;
        bound.prototype = new Empty();
        Empty.prototype = null;
      }
      return bound;
    }, "bind");
  }
});

// ../../node_modules/.pnpm/function-bind@1.1.1/node_modules/function-bind/index.js
var require_function_bind = __commonJS({
  "../../node_modules/.pnpm/function-bind@1.1.1/node_modules/function-bind/index.js"(exports, module2) {
    "use strict";
    var implementation = require_implementation();
    module2.exports = Function.prototype.bind || implementation;
  }
});

// ../../node_modules/.pnpm/has@1.0.3/node_modules/has/src/index.js
var require_src2 = __commonJS({
  "../../node_modules/.pnpm/has@1.0.3/node_modules/has/src/index.js"(exports, module2) {
    "use strict";
    var bind = require_function_bind();
    module2.exports = bind.call(Function.call, Object.prototype.hasOwnProperty);
  }
});

// ../../node_modules/.pnpm/is-core-module@2.11.0/node_modules/is-core-module/core.json
var require_core2 = __commonJS({
  "../../node_modules/.pnpm/is-core-module@2.11.0/node_modules/is-core-module/core.json"(exports, module2) {
    module2.exports = {
      assert: true,
      "node:assert": [">= 14.18 && < 15", ">= 16"],
      "assert/strict": ">= 15",
      "node:assert/strict": ">= 16",
      async_hooks: ">= 8",
      "node:async_hooks": [">= 14.18 && < 15", ">= 16"],
      buffer_ieee754: ">= 0.5 && < 0.9.7",
      buffer: true,
      "node:buffer": [">= 14.18 && < 15", ">= 16"],
      child_process: true,
      "node:child_process": [">= 14.18 && < 15", ">= 16"],
      cluster: ">= 0.5",
      "node:cluster": [">= 14.18 && < 15", ">= 16"],
      console: true,
      "node:console": [">= 14.18 && < 15", ">= 16"],
      constants: true,
      "node:constants": [">= 14.18 && < 15", ">= 16"],
      crypto: true,
      "node:crypto": [">= 14.18 && < 15", ">= 16"],
      _debug_agent: ">= 1 && < 8",
      _debugger: "< 8",
      dgram: true,
      "node:dgram": [">= 14.18 && < 15", ">= 16"],
      diagnostics_channel: [">= 14.17 && < 15", ">= 15.1"],
      "node:diagnostics_channel": [">= 14.18 && < 15", ">= 16"],
      dns: true,
      "node:dns": [">= 14.18 && < 15", ">= 16"],
      "dns/promises": ">= 15",
      "node:dns/promises": ">= 16",
      domain: ">= 0.7.12",
      "node:domain": [">= 14.18 && < 15", ">= 16"],
      events: true,
      "node:events": [">= 14.18 && < 15", ">= 16"],
      freelist: "< 6",
      fs: true,
      "node:fs": [">= 14.18 && < 15", ">= 16"],
      "fs/promises": [">= 10 && < 10.1", ">= 14"],
      "node:fs/promises": [">= 14.18 && < 15", ">= 16"],
      _http_agent: ">= 0.11.1",
      "node:_http_agent": [">= 14.18 && < 15", ">= 16"],
      _http_client: ">= 0.11.1",
      "node:_http_client": [">= 14.18 && < 15", ">= 16"],
      _http_common: ">= 0.11.1",
      "node:_http_common": [">= 14.18 && < 15", ">= 16"],
      _http_incoming: ">= 0.11.1",
      "node:_http_incoming": [">= 14.18 && < 15", ">= 16"],
      _http_outgoing: ">= 0.11.1",
      "node:_http_outgoing": [">= 14.18 && < 15", ">= 16"],
      _http_server: ">= 0.11.1",
      "node:_http_server": [">= 14.18 && < 15", ">= 16"],
      http: true,
      "node:http": [">= 14.18 && < 15", ">= 16"],
      http2: ">= 8.8",
      "node:http2": [">= 14.18 && < 15", ">= 16"],
      https: true,
      "node:https": [">= 14.18 && < 15", ">= 16"],
      inspector: ">= 8",
      "node:inspector": [">= 14.18 && < 15", ">= 16"],
      "inspector/promises": [">= 19"],
      "node:inspector/promises": [">= 19"],
      _linklist: "< 8",
      module: true,
      "node:module": [">= 14.18 && < 15", ">= 16"],
      net: true,
      "node:net": [">= 14.18 && < 15", ">= 16"],
      "node-inspect/lib/_inspect": ">= 7.6 && < 12",
      "node-inspect/lib/internal/inspect_client": ">= 7.6 && < 12",
      "node-inspect/lib/internal/inspect_repl": ">= 7.6 && < 12",
      os: true,
      "node:os": [">= 14.18 && < 15", ">= 16"],
      path: true,
      "node:path": [">= 14.18 && < 15", ">= 16"],
      "path/posix": ">= 15.3",
      "node:path/posix": ">= 16",
      "path/win32": ">= 15.3",
      "node:path/win32": ">= 16",
      perf_hooks: ">= 8.5",
      "node:perf_hooks": [">= 14.18 && < 15", ">= 16"],
      process: ">= 1",
      "node:process": [">= 14.18 && < 15", ">= 16"],
      punycode: ">= 0.5",
      "node:punycode": [">= 14.18 && < 15", ">= 16"],
      querystring: true,
      "node:querystring": [">= 14.18 && < 15", ">= 16"],
      readline: true,
      "node:readline": [">= 14.18 && < 15", ">= 16"],
      "readline/promises": ">= 17",
      "node:readline/promises": ">= 17",
      repl: true,
      "node:repl": [">= 14.18 && < 15", ">= 16"],
      smalloc: ">= 0.11.5 && < 3",
      _stream_duplex: ">= 0.9.4",
      "node:_stream_duplex": [">= 14.18 && < 15", ">= 16"],
      _stream_transform: ">= 0.9.4",
      "node:_stream_transform": [">= 14.18 && < 15", ">= 16"],
      _stream_wrap: ">= 1.4.1",
      "node:_stream_wrap": [">= 14.18 && < 15", ">= 16"],
      _stream_passthrough: ">= 0.9.4",
      "node:_stream_passthrough": [">= 14.18 && < 15", ">= 16"],
      _stream_readable: ">= 0.9.4",
      "node:_stream_readable": [">= 14.18 && < 15", ">= 16"],
      _stream_writable: ">= 0.9.4",
      "node:_stream_writable": [">= 14.18 && < 15", ">= 16"],
      stream: true,
      "node:stream": [">= 14.18 && < 15", ">= 16"],
      "stream/consumers": ">= 16.7",
      "node:stream/consumers": ">= 16.7",
      "stream/promises": ">= 15",
      "node:stream/promises": ">= 16",
      "stream/web": ">= 16.5",
      "node:stream/web": ">= 16.5",
      string_decoder: true,
      "node:string_decoder": [">= 14.18 && < 15", ">= 16"],
      sys: [">= 0.4 && < 0.7", ">= 0.8"],
      "node:sys": [">= 14.18 && < 15", ">= 16"],
      "node:test": [">= 16.17 && < 17", ">= 18"],
      timers: true,
      "node:timers": [">= 14.18 && < 15", ">= 16"],
      "timers/promises": ">= 15",
      "node:timers/promises": ">= 16",
      _tls_common: ">= 0.11.13",
      "node:_tls_common": [">= 14.18 && < 15", ">= 16"],
      _tls_legacy: ">= 0.11.3 && < 10",
      _tls_wrap: ">= 0.11.3",
      "node:_tls_wrap": [">= 14.18 && < 15", ">= 16"],
      tls: true,
      "node:tls": [">= 14.18 && < 15", ">= 16"],
      trace_events: ">= 10",
      "node:trace_events": [">= 14.18 && < 15", ">= 16"],
      tty: true,
      "node:tty": [">= 14.18 && < 15", ">= 16"],
      url: true,
      "node:url": [">= 14.18 && < 15", ">= 16"],
      util: true,
      "node:util": [">= 14.18 && < 15", ">= 16"],
      "util/types": ">= 15.3",
      "node:util/types": ">= 16",
      "v8/tools/arguments": ">= 10 && < 12",
      "v8/tools/codemap": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/consarray": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/csvparser": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/logreader": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/profile_view": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/splaytree": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      v8: ">= 1",
      "node:v8": [">= 14.18 && < 15", ">= 16"],
      vm: true,
      "node:vm": [">= 14.18 && < 15", ">= 16"],
      wasi: ">= 13.4 && < 13.5",
      worker_threads: ">= 11.7",
      "node:worker_threads": [">= 14.18 && < 15", ">= 16"],
      zlib: ">= 0.5",
      "node:zlib": [">= 14.18 && < 15", ">= 16"]
    };
  }
});

// ../../node_modules/.pnpm/is-core-module@2.11.0/node_modules/is-core-module/index.js
var require_is_core_module = __commonJS({
  "../../node_modules/.pnpm/is-core-module@2.11.0/node_modules/is-core-module/index.js"(exports, module2) {
    "use strict";
    var has = require_src2();
    function specifierIncluded(current, specifier) {
      var nodeParts = current.split(".");
      var parts = specifier.split(" ");
      var op = parts.length > 1 ? parts[0] : "=";
      var versionParts = (parts.length > 1 ? parts[1] : parts[0]).split(".");
      for (var i = 0; i < 3; ++i) {
        var cur = parseInt(nodeParts[i] || 0, 10);
        var ver = parseInt(versionParts[i] || 0, 10);
        if (cur === ver) {
          continue;
        }
        if (op === "<") {
          return cur < ver;
        }
        if (op === ">=") {
          return cur >= ver;
        }
        return false;
      }
      return op === ">=";
    }
    __name(specifierIncluded, "specifierIncluded");
    function matchesRange(current, range) {
      var specifiers = range.split(/ ?&& ?/);
      if (specifiers.length === 0) {
        return false;
      }
      for (var i = 0; i < specifiers.length; ++i) {
        if (!specifierIncluded(current, specifiers[i])) {
          return false;
        }
      }
      return true;
    }
    __name(matchesRange, "matchesRange");
    function versionIncluded(nodeVersion, specifierValue) {
      if (typeof specifierValue === "boolean") {
        return specifierValue;
      }
      var current = typeof nodeVersion === "undefined" ? process.versions && process.versions.node : nodeVersion;
      if (typeof current !== "string") {
        throw new TypeError(typeof nodeVersion === "undefined" ? "Unable to determine current node version" : "If provided, a valid node version is required");
      }
      if (specifierValue && typeof specifierValue === "object") {
        for (var i = 0; i < specifierValue.length; ++i) {
          if (matchesRange(current, specifierValue[i])) {
            return true;
          }
        }
        return false;
      }
      return matchesRange(current, specifierValue);
    }
    __name(versionIncluded, "versionIncluded");
    var data = require_core2();
    module2.exports = /* @__PURE__ */ __name(function isCore(x, nodeVersion) {
      return has(data, x) && versionIncluded(nodeVersion, data[x]);
    }, "isCore");
  }
});

// ../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/async.js
var require_async = __commonJS({
  "../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/async.js"(exports, module2) {
    var fs11 = require("fs");
    var getHomedir = require_homedir();
    var path9 = require("path");
    var caller = require_caller();
    var nodeModulesPaths = require_node_modules_paths();
    var normalizeOptions = require_normalize_options();
    var isCore = require_is_core_module();
    var realpathFS = process.platform !== "win32" && fs11.realpath && typeof fs11.realpath.native === "function" ? fs11.realpath.native : fs11.realpath;
    var homedir = getHomedir();
    var defaultPaths = /* @__PURE__ */ __name(function() {
      return [
        path9.join(homedir, ".node_modules"),
        path9.join(homedir, ".node_libraries")
      ];
    }, "defaultPaths");
    var defaultIsFile = /* @__PURE__ */ __name(function isFile(file2, cb) {
      fs11.stat(file2, function(err, stat2) {
        if (!err) {
          return cb(null, stat2.isFile() || stat2.isFIFO());
        }
        if (err.code === "ENOENT" || err.code === "ENOTDIR")
          return cb(null, false);
        return cb(err);
      });
    }, "isFile");
    var defaultIsDir = /* @__PURE__ */ __name(function isDirectory(dir2, cb) {
      fs11.stat(dir2, function(err, stat2) {
        if (!err) {
          return cb(null, stat2.isDirectory());
        }
        if (err.code === "ENOENT" || err.code === "ENOTDIR")
          return cb(null, false);
        return cb(err);
      });
    }, "isDirectory");
    var defaultRealpath = /* @__PURE__ */ __name(function realpath(x, cb) {
      realpathFS(x, function(realpathErr, realPath) {
        if (realpathErr && realpathErr.code !== "ENOENT")
          cb(realpathErr);
        else
          cb(null, realpathErr ? x : realPath);
      });
    }, "realpath");
    var maybeRealpath = /* @__PURE__ */ __name(function maybeRealpath2(realpath, x, opts, cb) {
      if (opts && opts.preserveSymlinks === false) {
        realpath(x, cb);
      } else {
        cb(null, x);
      }
    }, "maybeRealpath");
    var defaultReadPackage = /* @__PURE__ */ __name(function defaultReadPackage2(readFile5, pkgfile, cb) {
      readFile5(pkgfile, function(readFileErr, body) {
        if (readFileErr)
          cb(readFileErr);
        else {
          try {
            var pkg2 = JSON.parse(body);
            cb(null, pkg2);
          } catch (jsonErr) {
            cb(null);
          }
        }
      });
    }, "defaultReadPackage");
    var getPackageCandidates = /* @__PURE__ */ __name(function getPackageCandidates2(x, start, opts) {
      var dirs = nodeModulesPaths(start, opts, x);
      for (var i = 0; i < dirs.length; i++) {
        dirs[i] = path9.join(dirs[i], x);
      }
      return dirs;
    }, "getPackageCandidates");
    module2.exports = /* @__PURE__ */ __name(function resolve(x, options2, callback) {
      var cb = callback;
      var opts = options2;
      if (typeof options2 === "function") {
        cb = opts;
        opts = {};
      }
      if (typeof x !== "string") {
        var err = new TypeError("Path must be a string.");
        return process.nextTick(function() {
          cb(err);
        });
      }
      opts = normalizeOptions(x, opts);
      var isFile = opts.isFile || defaultIsFile;
      var isDirectory = opts.isDirectory || defaultIsDir;
      var readFile5 = opts.readFile || fs11.readFile;
      var realpath = opts.realpath || defaultRealpath;
      var readPackage = opts.readPackage || defaultReadPackage;
      if (opts.readFile && opts.readPackage) {
        var conflictErr = new TypeError("`readFile` and `readPackage` are mutually exclusive.");
        return process.nextTick(function() {
          cb(conflictErr);
        });
      }
      var packageIterator = opts.packageIterator;
      var extensions = opts.extensions || [".js"];
      var includeCoreModules = opts.includeCoreModules !== false;
      var basedir = opts.basedir || path9.dirname(caller());
      var parent = opts.filename || basedir;
      opts.paths = opts.paths || defaultPaths();
      var absoluteStart = path9.resolve(basedir);
      maybeRealpath(
        realpath,
        absoluteStart,
        opts,
        function(err2, realStart) {
          if (err2)
            cb(err2);
          else
            init(realStart);
        }
      );
      var res;
      function init(basedir2) {
        if (/^(?:\.\.?(?:\/|$)|\/|([A-Za-z]:)?[/\\])/.test(x)) {
          res = path9.resolve(basedir2, x);
          if (x === "." || x === ".." || x.slice(-1) === "/")
            res += "/";
          if (/\/$/.test(x) && res === basedir2) {
            loadAsDirectory(res, opts.package, onfile);
          } else
            loadAsFile(res, opts.package, onfile);
        } else if (includeCoreModules && isCore(x)) {
          return cb(null, x);
        } else
          loadNodeModules(x, basedir2, function(err2, n2, pkg2) {
            if (err2)
              cb(err2);
            else if (n2) {
              return maybeRealpath(realpath, n2, opts, function(err3, realN) {
                if (err3) {
                  cb(err3);
                } else {
                  cb(null, realN, pkg2);
                }
              });
            } else {
              var moduleError = new Error("Cannot find module '" + x + "' from '" + parent + "'");
              moduleError.code = "MODULE_NOT_FOUND";
              cb(moduleError);
            }
          });
      }
      __name(init, "init");
      function onfile(err2, m, pkg2) {
        if (err2)
          cb(err2);
        else if (m)
          cb(null, m, pkg2);
        else
          loadAsDirectory(res, function(err3, d2, pkg3) {
            if (err3)
              cb(err3);
            else if (d2) {
              maybeRealpath(realpath, d2, opts, function(err4, realD) {
                if (err4) {
                  cb(err4);
                } else {
                  cb(null, realD, pkg3);
                }
              });
            } else {
              var moduleError = new Error("Cannot find module '" + x + "' from '" + parent + "'");
              moduleError.code = "MODULE_NOT_FOUND";
              cb(moduleError);
            }
          });
      }
      __name(onfile, "onfile");
      function loadAsFile(x2, thePackage, callback2) {
        var loadAsFilePackage = thePackage;
        var cb2 = callback2;
        if (typeof loadAsFilePackage === "function") {
          cb2 = loadAsFilePackage;
          loadAsFilePackage = void 0;
        }
        var exts = [""].concat(extensions);
        load(exts, x2, loadAsFilePackage);
        function load(exts2, x3, loadPackage) {
          if (exts2.length === 0)
            return cb2(null, void 0, loadPackage);
          var file2 = x3 + exts2[0];
          var pkg2 = loadPackage;
          if (pkg2)
            onpkg(null, pkg2);
          else
            loadpkg(path9.dirname(file2), onpkg);
          function onpkg(err2, pkg_, dir2) {
            pkg2 = pkg_;
            if (err2)
              return cb2(err2);
            if (dir2 && pkg2 && opts.pathFilter) {
              var rfile = path9.relative(dir2, file2);
              var rel = rfile.slice(0, rfile.length - exts2[0].length);
              var r2 = opts.pathFilter(pkg2, x3, rel);
              if (r2)
                return load(
                  [""].concat(extensions.slice()),
                  path9.resolve(dir2, r2),
                  pkg2
                );
            }
            isFile(file2, onex);
          }
          __name(onpkg, "onpkg");
          function onex(err2, ex) {
            if (err2)
              return cb2(err2);
            if (ex)
              return cb2(null, file2, pkg2);
            load(exts2.slice(1), x3, pkg2);
          }
          __name(onex, "onex");
        }
        __name(load, "load");
      }
      __name(loadAsFile, "loadAsFile");
      function loadpkg(dir2, cb2) {
        if (dir2 === "" || dir2 === "/")
          return cb2(null);
        if (process.platform === "win32" && /^\w:[/\\]*$/.test(dir2)) {
          return cb2(null);
        }
        if (/[/\\]node_modules[/\\]*$/.test(dir2))
          return cb2(null);
        maybeRealpath(realpath, dir2, opts, function(unwrapErr, pkgdir) {
          if (unwrapErr)
            return loadpkg(path9.dirname(dir2), cb2);
          var pkgfile = path9.join(pkgdir, "package.json");
          isFile(pkgfile, function(err2, ex) {
            if (!ex)
              return loadpkg(path9.dirname(dir2), cb2);
            readPackage(readFile5, pkgfile, function(err3, pkgParam) {
              if (err3)
                cb2(err3);
              var pkg2 = pkgParam;
              if (pkg2 && opts.packageFilter) {
                pkg2 = opts.packageFilter(pkg2, pkgfile);
              }
              cb2(null, pkg2, dir2);
            });
          });
        });
      }
      __name(loadpkg, "loadpkg");
      function loadAsDirectory(x2, loadAsDirectoryPackage, callback2) {
        var cb2 = callback2;
        var fpkg = loadAsDirectoryPackage;
        if (typeof fpkg === "function") {
          cb2 = fpkg;
          fpkg = opts.package;
        }
        maybeRealpath(realpath, x2, opts, function(unwrapErr, pkgdir) {
          if (unwrapErr)
            return cb2(unwrapErr);
          var pkgfile = path9.join(pkgdir, "package.json");
          isFile(pkgfile, function(err2, ex) {
            if (err2)
              return cb2(err2);
            if (!ex)
              return loadAsFile(path9.join(x2, "index"), fpkg, cb2);
            readPackage(readFile5, pkgfile, function(err3, pkgParam) {
              if (err3)
                return cb2(err3);
              var pkg2 = pkgParam;
              if (pkg2 && opts.packageFilter) {
                pkg2 = opts.packageFilter(pkg2, pkgfile);
              }
              if (pkg2 && pkg2.main) {
                if (typeof pkg2.main !== "string") {
                  var mainError = new TypeError("package \u201C" + pkg2.name + "\u201D `main` must be a string");
                  mainError.code = "INVALID_PACKAGE_MAIN";
                  return cb2(mainError);
                }
                if (pkg2.main === "." || pkg2.main === "./") {
                  pkg2.main = "index";
                }
                loadAsFile(path9.resolve(x2, pkg2.main), pkg2, function(err4, m, pkg3) {
                  if (err4)
                    return cb2(err4);
                  if (m)
                    return cb2(null, m, pkg3);
                  if (!pkg3)
                    return loadAsFile(path9.join(x2, "index"), pkg3, cb2);
                  var dir2 = path9.resolve(x2, pkg3.main);
                  loadAsDirectory(dir2, pkg3, function(err5, n2, pkg4) {
                    if (err5)
                      return cb2(err5);
                    if (n2)
                      return cb2(null, n2, pkg4);
                    loadAsFile(path9.join(x2, "index"), pkg4, cb2);
                  });
                });
                return;
              }
              loadAsFile(path9.join(x2, "/index"), pkg2, cb2);
            });
          });
        });
      }
      __name(loadAsDirectory, "loadAsDirectory");
      function processDirs(cb2, dirs) {
        if (dirs.length === 0)
          return cb2(null, void 0);
        var dir2 = dirs[0];
        isDirectory(path9.dirname(dir2), isdir);
        function isdir(err2, isdir2) {
          if (err2)
            return cb2(err2);
          if (!isdir2)
            return processDirs(cb2, dirs.slice(1));
          loadAsFile(dir2, opts.package, onfile2);
        }
        __name(isdir, "isdir");
        function onfile2(err2, m, pkg2) {
          if (err2)
            return cb2(err2);
          if (m)
            return cb2(null, m, pkg2);
          loadAsDirectory(dir2, opts.package, ondir);
        }
        __name(onfile2, "onfile");
        function ondir(err2, n2, pkg2) {
          if (err2)
            return cb2(err2);
          if (n2)
            return cb2(null, n2, pkg2);
          processDirs(cb2, dirs.slice(1));
        }
        __name(ondir, "ondir");
      }
      __name(processDirs, "processDirs");
      function loadNodeModules(x2, start, cb2) {
        var thunk = /* @__PURE__ */ __name(function() {
          return getPackageCandidates(x2, start, opts);
        }, "thunk");
        processDirs(
          cb2,
          packageIterator ? packageIterator(x2, start, thunk, opts) : thunk()
        );
      }
      __name(loadNodeModules, "loadNodeModules");
    }, "resolve");
  }
});

// ../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/core.json
var require_core3 = __commonJS({
  "../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/core.json"(exports, module2) {
    module2.exports = {
      assert: true,
      "node:assert": [">= 14.18 && < 15", ">= 16"],
      "assert/strict": ">= 15",
      "node:assert/strict": ">= 16",
      async_hooks: ">= 8",
      "node:async_hooks": [">= 14.18 && < 15", ">= 16"],
      buffer_ieee754: ">= 0.5 && < 0.9.7",
      buffer: true,
      "node:buffer": [">= 14.18 && < 15", ">= 16"],
      child_process: true,
      "node:child_process": [">= 14.18 && < 15", ">= 16"],
      cluster: ">= 0.5",
      "node:cluster": [">= 14.18 && < 15", ">= 16"],
      console: true,
      "node:console": [">= 14.18 && < 15", ">= 16"],
      constants: true,
      "node:constants": [">= 14.18 && < 15", ">= 16"],
      crypto: true,
      "node:crypto": [">= 14.18 && < 15", ">= 16"],
      _debug_agent: ">= 1 && < 8",
      _debugger: "< 8",
      dgram: true,
      "node:dgram": [">= 14.18 && < 15", ">= 16"],
      diagnostics_channel: [">= 14.17 && < 15", ">= 15.1"],
      "node:diagnostics_channel": [">= 14.18 && < 15", ">= 16"],
      dns: true,
      "node:dns": [">= 14.18 && < 15", ">= 16"],
      "dns/promises": ">= 15",
      "node:dns/promises": ">= 16",
      domain: ">= 0.7.12",
      "node:domain": [">= 14.18 && < 15", ">= 16"],
      events: true,
      "node:events": [">= 14.18 && < 15", ">= 16"],
      freelist: "< 6",
      fs: true,
      "node:fs": [">= 14.18 && < 15", ">= 16"],
      "fs/promises": [">= 10 && < 10.1", ">= 14"],
      "node:fs/promises": [">= 14.18 && < 15", ">= 16"],
      _http_agent: ">= 0.11.1",
      "node:_http_agent": [">= 14.18 && < 15", ">= 16"],
      _http_client: ">= 0.11.1",
      "node:_http_client": [">= 14.18 && < 15", ">= 16"],
      _http_common: ">= 0.11.1",
      "node:_http_common": [">= 14.18 && < 15", ">= 16"],
      _http_incoming: ">= 0.11.1",
      "node:_http_incoming": [">= 14.18 && < 15", ">= 16"],
      _http_outgoing: ">= 0.11.1",
      "node:_http_outgoing": [">= 14.18 && < 15", ">= 16"],
      _http_server: ">= 0.11.1",
      "node:_http_server": [">= 14.18 && < 15", ">= 16"],
      http: true,
      "node:http": [">= 14.18 && < 15", ">= 16"],
      http2: ">= 8.8",
      "node:http2": [">= 14.18 && < 15", ">= 16"],
      https: true,
      "node:https": [">= 14.18 && < 15", ">= 16"],
      inspector: ">= 8",
      "node:inspector": [">= 14.18 && < 15", ">= 16"],
      _linklist: "< 8",
      module: true,
      "node:module": [">= 14.18 && < 15", ">= 16"],
      net: true,
      "node:net": [">= 14.18 && < 15", ">= 16"],
      "node-inspect/lib/_inspect": ">= 7.6 && < 12",
      "node-inspect/lib/internal/inspect_client": ">= 7.6 && < 12",
      "node-inspect/lib/internal/inspect_repl": ">= 7.6 && < 12",
      os: true,
      "node:os": [">= 14.18 && < 15", ">= 16"],
      path: true,
      "node:path": [">= 14.18 && < 15", ">= 16"],
      "path/posix": ">= 15.3",
      "node:path/posix": ">= 16",
      "path/win32": ">= 15.3",
      "node:path/win32": ">= 16",
      perf_hooks: ">= 8.5",
      "node:perf_hooks": [">= 14.18 && < 15", ">= 16"],
      process: ">= 1",
      "node:process": [">= 14.18 && < 15", ">= 16"],
      punycode: ">= 0.5",
      "node:punycode": [">= 14.18 && < 15", ">= 16"],
      querystring: true,
      "node:querystring": [">= 14.18 && < 15", ">= 16"],
      readline: true,
      "node:readline": [">= 14.18 && < 15", ">= 16"],
      "readline/promises": ">= 17",
      "node:readline/promises": ">= 17",
      repl: true,
      "node:repl": [">= 14.18 && < 15", ">= 16"],
      smalloc: ">= 0.11.5 && < 3",
      _stream_duplex: ">= 0.9.4",
      "node:_stream_duplex": [">= 14.18 && < 15", ">= 16"],
      _stream_transform: ">= 0.9.4",
      "node:_stream_transform": [">= 14.18 && < 15", ">= 16"],
      _stream_wrap: ">= 1.4.1",
      "node:_stream_wrap": [">= 14.18 && < 15", ">= 16"],
      _stream_passthrough: ">= 0.9.4",
      "node:_stream_passthrough": [">= 14.18 && < 15", ">= 16"],
      _stream_readable: ">= 0.9.4",
      "node:_stream_readable": [">= 14.18 && < 15", ">= 16"],
      _stream_writable: ">= 0.9.4",
      "node:_stream_writable": [">= 14.18 && < 15", ">= 16"],
      stream: true,
      "node:stream": [">= 14.18 && < 15", ">= 16"],
      "stream/consumers": ">= 16.7",
      "node:stream/consumers": ">= 16.7",
      "stream/promises": ">= 15",
      "node:stream/promises": ">= 16",
      "stream/web": ">= 16.5",
      "node:stream/web": ">= 16.5",
      string_decoder: true,
      "node:string_decoder": [">= 14.18 && < 15", ">= 16"],
      sys: [">= 0.4 && < 0.7", ">= 0.8"],
      "node:sys": [">= 14.18 && < 15", ">= 16"],
      "node:test": ">= 18",
      timers: true,
      "node:timers": [">= 14.18 && < 15", ">= 16"],
      "timers/promises": ">= 15",
      "node:timers/promises": ">= 16",
      _tls_common: ">= 0.11.13",
      "node:_tls_common": [">= 14.18 && < 15", ">= 16"],
      _tls_legacy: ">= 0.11.3 && < 10",
      _tls_wrap: ">= 0.11.3",
      "node:_tls_wrap": [">= 14.18 && < 15", ">= 16"],
      tls: true,
      "node:tls": [">= 14.18 && < 15", ">= 16"],
      trace_events: ">= 10",
      "node:trace_events": [">= 14.18 && < 15", ">= 16"],
      tty: true,
      "node:tty": [">= 14.18 && < 15", ">= 16"],
      url: true,
      "node:url": [">= 14.18 && < 15", ">= 16"],
      util: true,
      "node:util": [">= 14.18 && < 15", ">= 16"],
      "util/types": ">= 15.3",
      "node:util/types": ">= 16",
      "v8/tools/arguments": ">= 10 && < 12",
      "v8/tools/codemap": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/consarray": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/csvparser": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/logreader": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/profile_view": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/splaytree": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      v8: ">= 1",
      "node:v8": [">= 14.18 && < 15", ">= 16"],
      vm: true,
      "node:vm": [">= 14.18 && < 15", ">= 16"],
      wasi: ">= 13.4 && < 13.5",
      worker_threads: ">= 11.7",
      "node:worker_threads": [">= 14.18 && < 15", ">= 16"],
      zlib: ">= 0.5",
      "node:zlib": [">= 14.18 && < 15", ">= 16"]
    };
  }
});

// ../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/core.js
var require_core4 = __commonJS({
  "../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/core.js"(exports, module2) {
    var current = process.versions && process.versions.node && process.versions.node.split(".") || [];
    function specifierIncluded(specifier) {
      var parts = specifier.split(" ");
      var op = parts.length > 1 ? parts[0] : "=";
      var versionParts = (parts.length > 1 ? parts[1] : parts[0]).split(".");
      for (var i = 0; i < 3; ++i) {
        var cur = parseInt(current[i] || 0, 10);
        var ver = parseInt(versionParts[i] || 0, 10);
        if (cur === ver) {
          continue;
        }
        if (op === "<") {
          return cur < ver;
        } else if (op === ">=") {
          return cur >= ver;
        }
        return false;
      }
      return op === ">=";
    }
    __name(specifierIncluded, "specifierIncluded");
    function matchesRange(range) {
      var specifiers = range.split(/ ?&& ?/);
      if (specifiers.length === 0) {
        return false;
      }
      for (var i = 0; i < specifiers.length; ++i) {
        if (!specifierIncluded(specifiers[i])) {
          return false;
        }
      }
      return true;
    }
    __name(matchesRange, "matchesRange");
    function versionIncluded(specifierValue) {
      if (typeof specifierValue === "boolean") {
        return specifierValue;
      }
      if (specifierValue && typeof specifierValue === "object") {
        for (var i = 0; i < specifierValue.length; ++i) {
          if (matchesRange(specifierValue[i])) {
            return true;
          }
        }
        return false;
      }
      return matchesRange(specifierValue);
    }
    __name(versionIncluded, "versionIncluded");
    var data = require_core3();
    var core = {};
    for (mod2 in data) {
      if (Object.prototype.hasOwnProperty.call(data, mod2)) {
        core[mod2] = versionIncluded(data[mod2]);
      }
    }
    var mod2;
    module2.exports = core;
  }
});

// ../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/is-core.js
var require_is_core = __commonJS({
  "../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/is-core.js"(exports, module2) {
    var isCoreModule = require_is_core_module();
    module2.exports = /* @__PURE__ */ __name(function isCore(x) {
      return isCoreModule(x);
    }, "isCore");
  }
});

// ../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/sync.js
var require_sync = __commonJS({
  "../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/sync.js"(exports, module2) {
    var isCore = require_is_core_module();
    var fs11 = require("fs");
    var path9 = require("path");
    var getHomedir = require_homedir();
    var caller = require_caller();
    var nodeModulesPaths = require_node_modules_paths();
    var normalizeOptions = require_normalize_options();
    var realpathFS = process.platform !== "win32" && fs11.realpathSync && typeof fs11.realpathSync.native === "function" ? fs11.realpathSync.native : fs11.realpathSync;
    var homedir = getHomedir();
    var defaultPaths = /* @__PURE__ */ __name(function() {
      return [
        path9.join(homedir, ".node_modules"),
        path9.join(homedir, ".node_libraries")
      ];
    }, "defaultPaths");
    var defaultIsFile = /* @__PURE__ */ __name(function isFile(file2) {
      try {
        var stat2 = fs11.statSync(file2, { throwIfNoEntry: false });
      } catch (e2) {
        if (e2 && (e2.code === "ENOENT" || e2.code === "ENOTDIR"))
          return false;
        throw e2;
      }
      return !!stat2 && (stat2.isFile() || stat2.isFIFO());
    }, "isFile");
    var defaultIsDir = /* @__PURE__ */ __name(function isDirectory(dir2) {
      try {
        var stat2 = fs11.statSync(dir2, { throwIfNoEntry: false });
      } catch (e2) {
        if (e2 && (e2.code === "ENOENT" || e2.code === "ENOTDIR"))
          return false;
        throw e2;
      }
      return !!stat2 && stat2.isDirectory();
    }, "isDirectory");
    var defaultRealpathSync = /* @__PURE__ */ __name(function realpathSync(x) {
      try {
        return realpathFS(x);
      } catch (realpathErr) {
        if (realpathErr.code !== "ENOENT") {
          throw realpathErr;
        }
      }
      return x;
    }, "realpathSync");
    var maybeRealpathSync = /* @__PURE__ */ __name(function maybeRealpathSync2(realpathSync, x, opts) {
      if (opts && opts.preserveSymlinks === false) {
        return realpathSync(x);
      }
      return x;
    }, "maybeRealpathSync");
    var defaultReadPackageSync = /* @__PURE__ */ __name(function defaultReadPackageSync2(readFileSync, pkgfile) {
      var body = readFileSync(pkgfile);
      try {
        var pkg2 = JSON.parse(body);
        return pkg2;
      } catch (jsonErr) {
      }
    }, "defaultReadPackageSync");
    var getPackageCandidates = /* @__PURE__ */ __name(function getPackageCandidates2(x, start, opts) {
      var dirs = nodeModulesPaths(start, opts, x);
      for (var i = 0; i < dirs.length; i++) {
        dirs[i] = path9.join(dirs[i], x);
      }
      return dirs;
    }, "getPackageCandidates");
    module2.exports = /* @__PURE__ */ __name(function resolveSync(x, options2) {
      if (typeof x !== "string") {
        throw new TypeError("Path must be a string.");
      }
      var opts = normalizeOptions(x, options2);
      var isFile = opts.isFile || defaultIsFile;
      var readFileSync = opts.readFileSync || fs11.readFileSync;
      var isDirectory = opts.isDirectory || defaultIsDir;
      var realpathSync = opts.realpathSync || defaultRealpathSync;
      var readPackageSync = opts.readPackageSync || defaultReadPackageSync;
      if (opts.readFileSync && opts.readPackageSync) {
        throw new TypeError("`readFileSync` and `readPackageSync` are mutually exclusive.");
      }
      var packageIterator = opts.packageIterator;
      var extensions = opts.extensions || [".js"];
      var includeCoreModules = opts.includeCoreModules !== false;
      var basedir = opts.basedir || path9.dirname(caller());
      var parent = opts.filename || basedir;
      opts.paths = opts.paths || defaultPaths();
      var absoluteStart = maybeRealpathSync(realpathSync, path9.resolve(basedir), opts);
      if (/^(?:\.\.?(?:\/|$)|\/|([A-Za-z]:)?[/\\])/.test(x)) {
        var res = path9.resolve(absoluteStart, x);
        if (x === "." || x === ".." || x.slice(-1) === "/")
          res += "/";
        var m = loadAsFileSync(res) || loadAsDirectorySync(res);
        if (m)
          return maybeRealpathSync(realpathSync, m, opts);
      } else if (includeCoreModules && isCore(x)) {
        return x;
      } else {
        var n2 = loadNodeModulesSync(x, absoluteStart);
        if (n2)
          return maybeRealpathSync(realpathSync, n2, opts);
      }
      var err = new Error("Cannot find module '" + x + "' from '" + parent + "'");
      err.code = "MODULE_NOT_FOUND";
      throw err;
      function loadAsFileSync(x2) {
        var pkg2 = loadpkg(path9.dirname(x2));
        if (pkg2 && pkg2.dir && pkg2.pkg && opts.pathFilter) {
          var rfile = path9.relative(pkg2.dir, x2);
          var r2 = opts.pathFilter(pkg2.pkg, x2, rfile);
          if (r2) {
            x2 = path9.resolve(pkg2.dir, r2);
          }
        }
        if (isFile(x2)) {
          return x2;
        }
        for (var i = 0; i < extensions.length; i++) {
          var file2 = x2 + extensions[i];
          if (isFile(file2)) {
            return file2;
          }
        }
      }
      __name(loadAsFileSync, "loadAsFileSync");
      function loadpkg(dir2) {
        if (dir2 === "" || dir2 === "/")
          return;
        if (process.platform === "win32" && /^\w:[/\\]*$/.test(dir2)) {
          return;
        }
        if (/[/\\]node_modules[/\\]*$/.test(dir2))
          return;
        var pkgfile = path9.join(maybeRealpathSync(realpathSync, dir2, opts), "package.json");
        if (!isFile(pkgfile)) {
          return loadpkg(path9.dirname(dir2));
        }
        var pkg2 = readPackageSync(readFileSync, pkgfile);
        if (pkg2 && opts.packageFilter) {
          pkg2 = opts.packageFilter(pkg2, dir2);
        }
        return { pkg: pkg2, dir: dir2 };
      }
      __name(loadpkg, "loadpkg");
      function loadAsDirectorySync(x2) {
        var pkgfile = path9.join(maybeRealpathSync(realpathSync, x2, opts), "/package.json");
        if (isFile(pkgfile)) {
          try {
            var pkg2 = readPackageSync(readFileSync, pkgfile);
          } catch (e2) {
          }
          if (pkg2 && opts.packageFilter) {
            pkg2 = opts.packageFilter(pkg2, x2);
          }
          if (pkg2 && pkg2.main) {
            if (typeof pkg2.main !== "string") {
              var mainError = new TypeError("package \u201C" + pkg2.name + "\u201D `main` must be a string");
              mainError.code = "INVALID_PACKAGE_MAIN";
              throw mainError;
            }
            if (pkg2.main === "." || pkg2.main === "./") {
              pkg2.main = "index";
            }
            try {
              var m2 = loadAsFileSync(path9.resolve(x2, pkg2.main));
              if (m2)
                return m2;
              var n3 = loadAsDirectorySync(path9.resolve(x2, pkg2.main));
              if (n3)
                return n3;
            } catch (e2) {
            }
          }
        }
        return loadAsFileSync(path9.join(x2, "/index"));
      }
      __name(loadAsDirectorySync, "loadAsDirectorySync");
      function loadNodeModulesSync(x2, start) {
        var thunk = /* @__PURE__ */ __name(function() {
          return getPackageCandidates(x2, start, opts);
        }, "thunk");
        var dirs = packageIterator ? packageIterator(x2, start, thunk, opts) : thunk();
        for (var i = 0; i < dirs.length; i++) {
          var dir2 = dirs[i];
          if (isDirectory(path9.dirname(dir2))) {
            var m2 = loadAsFileSync(dir2);
            if (m2)
              return m2;
            var n3 = loadAsDirectorySync(dir2);
            if (n3)
              return n3;
          }
        }
      }
      __name(loadNodeModulesSync, "loadNodeModulesSync");
    }, "resolveSync");
  }
});

// ../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/index.js
var require_resolve = __commonJS({
  "../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/index.js"(exports, module2) {
    var async = require_async();
    async.core = require_core4();
    async.isCore = require_is_core();
    async.sync = require_sync();
    module2.exports = async;
  }
});

// ../../node_modules/.pnpm/normalize-package-data@2.5.0/node_modules/normalize-package-data/lib/extract_description.js
var require_extract_description = __commonJS({
  "../../node_modules/.pnpm/normalize-package-data@2.5.0/node_modules/normalize-package-data/lib/extract_description.js"(exports, module2) {
    module2.exports = extractDescription;
    function extractDescription(d2) {
      if (!d2)
        return;
      if (d2 === "ERROR: No README data found!")
        return;
      d2 = d2.trim().split("\n");
      for (var s = 0; d2[s] && d2[s].trim().match(/^(#|$)/); s++)
        ;
      var l = d2.length;
      for (var e2 = s + 1; e2 < l && d2[e2].trim(); e2++)
        ;
      return d2.slice(s, e2).join(" ").trim();
    }
    __name(extractDescription, "extractDescription");
  }
});

// ../../node_modules/.pnpm/normalize-package-data@2.5.0/node_modules/normalize-package-data/lib/typos.json
var require_typos = __commonJS({
  "../../node_modules/.pnpm/normalize-package-data@2.5.0/node_modules/normalize-package-data/lib/typos.json"(exports, module2) {
    module2.exports = {
      topLevel: {
        dependancies: "dependencies",
        dependecies: "dependencies",
        depdenencies: "dependencies",
        devEependencies: "devDependencies",
        depends: "dependencies",
        "dev-dependencies": "devDependencies",
        devDependences: "devDependencies",
        devDepenencies: "devDependencies",
        devdependencies: "devDependencies",
        repostitory: "repository",
        repo: "repository",
        prefereGlobal: "preferGlobal",
        hompage: "homepage",
        hampage: "homepage",
        autohr: "author",
        autor: "author",
        contributers: "contributors",
        publicationConfig: "publishConfig",
        script: "scripts"
      },
      bugs: { web: "url", name: "url" },
      script: { server: "start", tests: "test" }
    };
  }
});

// ../../node_modules/.pnpm/normalize-package-data@2.5.0/node_modules/normalize-package-data/lib/fixer.js
var require_fixer = __commonJS({
  "../../node_modules/.pnpm/normalize-package-data@2.5.0/node_modules/normalize-package-data/lib/fixer.js"(exports, module2) {
    var semver = require_semver();
    var validateLicense = require_validate_npm_package_license();
    var hostedGitInfo = require_hosted_git_info();
    var isBuiltinModule = require_resolve().isCore;
    var depTypes = ["dependencies", "devDependencies", "optionalDependencies"];
    var extractDescription = require_extract_description();
    var url = require("url");
    var typos = require_typos();
    var fixer = module2.exports = {
      warn: function() {
      },
      fixRepositoryField: function(data) {
        if (data.repositories) {
          this.warn("repositories");
          data.repository = data.repositories[0];
        }
        if (!data.repository)
          return this.warn("missingRepository");
        if (typeof data.repository === "string") {
          data.repository = {
            type: "git",
            url: data.repository
          };
        }
        var r2 = data.repository.url || "";
        if (r2) {
          var hosted = hostedGitInfo.fromUrl(r2);
          if (hosted) {
            r2 = data.repository.url = hosted.getDefaultRepresentation() == "shortcut" ? hosted.https() : hosted.toString();
          }
        }
        if (r2.match(/github.com\/[^\/]+\/[^\/]+\.git\.git$/)) {
          this.warn("brokenGitUrl", r2);
        }
      },
      fixTypos: function(data) {
        Object.keys(typos.topLevel).forEach(function(d2) {
          if (data.hasOwnProperty(d2)) {
            this.warn("typo", d2, typos.topLevel[d2]);
          }
        }, this);
      },
      fixScriptsField: function(data) {
        if (!data.scripts)
          return;
        if (typeof data.scripts !== "object") {
          this.warn("nonObjectScripts");
          delete data.scripts;
          return;
        }
        Object.keys(data.scripts).forEach(function(k) {
          if (typeof data.scripts[k] !== "string") {
            this.warn("nonStringScript");
            delete data.scripts[k];
          } else if (typos.script[k] && !data.scripts[typos.script[k]]) {
            this.warn("typo", k, typos.script[k], "scripts");
          }
        }, this);
      },
      fixFilesField: function(data) {
        var files = data.files;
        if (files && !Array.isArray(files)) {
          this.warn("nonArrayFiles");
          delete data.files;
        } else if (data.files) {
          data.files = data.files.filter(function(file2) {
            if (!file2 || typeof file2 !== "string") {
              this.warn("invalidFilename", file2);
              return false;
            } else {
              return true;
            }
          }, this);
        }
      },
      fixBinField: function(data) {
        if (!data.bin)
          return;
        if (typeof data.bin === "string") {
          var b2 = {};
          var match;
          if (match = data.name.match(/^@[^/]+[/](.*)$/)) {
            b2[match[1]] = data.bin;
          } else {
            b2[data.name] = data.bin;
          }
          data.bin = b2;
        }
      },
      fixManField: function(data) {
        if (!data.man)
          return;
        if (typeof data.man === "string") {
          data.man = [data.man];
        }
      },
      fixBundleDependenciesField: function(data) {
        var bdd = "bundledDependencies";
        var bd = "bundleDependencies";
        if (data[bdd] && !data[bd]) {
          data[bd] = data[bdd];
          delete data[bdd];
        }
        if (data[bd] && !Array.isArray(data[bd])) {
          this.warn("nonArrayBundleDependencies");
          delete data[bd];
        } else if (data[bd]) {
          data[bd] = data[bd].filter(function(bd2) {
            if (!bd2 || typeof bd2 !== "string") {
              this.warn("nonStringBundleDependency", bd2);
              return false;
            } else {
              if (!data.dependencies) {
                data.dependencies = {};
              }
              if (!data.dependencies.hasOwnProperty(bd2)) {
                this.warn("nonDependencyBundleDependency", bd2);
                data.dependencies[bd2] = "*";
              }
              return true;
            }
          }, this);
        }
      },
      fixDependencies: function(data, strict) {
        var loose = !strict;
        objectifyDeps(data, this.warn);
        addOptionalDepsToDeps(data, this.warn);
        this.fixBundleDependenciesField(data);
        ["dependencies", "devDependencies"].forEach(function(deps) {
          if (!(deps in data))
            return;
          if (!data[deps] || typeof data[deps] !== "object") {
            this.warn("nonObjectDependencies", deps);
            delete data[deps];
            return;
          }
          Object.keys(data[deps]).forEach(function(d2) {
            var r2 = data[deps][d2];
            if (typeof r2 !== "string") {
              this.warn("nonStringDependency", d2, JSON.stringify(r2));
              delete data[deps][d2];
            }
            var hosted = hostedGitInfo.fromUrl(data[deps][d2]);
            if (hosted)
              data[deps][d2] = hosted.toString();
          }, this);
        }, this);
      },
      fixModulesField: function(data) {
        if (data.modules) {
          this.warn("deprecatedModules");
          delete data.modules;
        }
      },
      fixKeywordsField: function(data) {
        if (typeof data.keywords === "string") {
          data.keywords = data.keywords.split(/,\s+/);
        }
        if (data.keywords && !Array.isArray(data.keywords)) {
          delete data.keywords;
          this.warn("nonArrayKeywords");
        } else if (data.keywords) {
          data.keywords = data.keywords.filter(function(kw) {
            if (typeof kw !== "string" || !kw) {
              this.warn("nonStringKeyword");
              return false;
            } else {
              return true;
            }
          }, this);
        }
      },
      fixVersionField: function(data, strict) {
        var loose = !strict;
        if (!data.version) {
          data.version = "";
          return true;
        }
        if (!semver.valid(data.version, loose)) {
          throw new Error('Invalid version: "' + data.version + '"');
        }
        data.version = semver.clean(data.version, loose);
        return true;
      },
      fixPeople: function(data) {
        modifyPeople(data, unParsePerson);
        modifyPeople(data, parsePerson);
      },
      fixNameField: function(data, options2) {
        if (typeof options2 === "boolean")
          options2 = { strict: options2 };
        else if (typeof options2 === "undefined")
          options2 = {};
        var strict = options2.strict;
        if (!data.name && !strict) {
          data.name = "";
          return;
        }
        if (typeof data.name !== "string") {
          throw new Error("name field must be a string.");
        }
        if (!strict)
          data.name = data.name.trim();
        ensureValidName(data.name, strict, options2.allowLegacyCase);
        if (isBuiltinModule(data.name))
          this.warn("conflictingName", data.name);
      },
      fixDescriptionField: function(data) {
        if (data.description && typeof data.description !== "string") {
          this.warn("nonStringDescription");
          delete data.description;
        }
        if (data.readme && !data.description)
          data.description = extractDescription(data.readme);
        if (data.description === void 0)
          delete data.description;
        if (!data.description)
          this.warn("missingDescription");
      },
      fixReadmeField: function(data) {
        if (!data.readme) {
          this.warn("missingReadme");
          data.readme = "ERROR: No README data found!";
        }
      },
      fixBugsField: function(data) {
        if (!data.bugs && data.repository && data.repository.url) {
          var hosted = hostedGitInfo.fromUrl(data.repository.url);
          if (hosted && hosted.bugs()) {
            data.bugs = { url: hosted.bugs() };
          }
        } else if (data.bugs) {
          var emailRe = /^.+@.*\..+$/;
          if (typeof data.bugs == "string") {
            if (emailRe.test(data.bugs))
              data.bugs = { email: data.bugs };
            else if (url.parse(data.bugs).protocol)
              data.bugs = { url: data.bugs };
            else
              this.warn("nonEmailUrlBugsString");
          } else {
            bugsTypos(data.bugs, this.warn);
            var oldBugs = data.bugs;
            data.bugs = {};
            if (oldBugs.url) {
              if (typeof oldBugs.url == "string" && url.parse(oldBugs.url).protocol)
                data.bugs.url = oldBugs.url;
              else
                this.warn("nonUrlBugsUrlField");
            }
            if (oldBugs.email) {
              if (typeof oldBugs.email == "string" && emailRe.test(oldBugs.email))
                data.bugs.email = oldBugs.email;
              else
                this.warn("nonEmailBugsEmailField");
            }
          }
          if (!data.bugs.email && !data.bugs.url) {
            delete data.bugs;
            this.warn("emptyNormalizedBugs");
          }
        }
      },
      fixHomepageField: function(data) {
        if (!data.homepage && data.repository && data.repository.url) {
          var hosted = hostedGitInfo.fromUrl(data.repository.url);
          if (hosted && hosted.docs())
            data.homepage = hosted.docs();
        }
        if (!data.homepage)
          return;
        if (typeof data.homepage !== "string") {
          this.warn("nonUrlHomepage");
          return delete data.homepage;
        }
        if (!url.parse(data.homepage).protocol) {
          data.homepage = "http://" + data.homepage;
        }
      },
      fixLicenseField: function(data) {
        if (!data.license) {
          return this.warn("missingLicense");
        } else {
          if (typeof data.license !== "string" || data.license.length < 1 || data.license.trim() === "") {
            this.warn("invalidLicense");
          } else {
            if (!validateLicense(data.license).validForNewPackages)
              this.warn("invalidLicense");
          }
        }
      }
    };
    function isValidScopedPackageName(spec) {
      if (spec.charAt(0) !== "@")
        return false;
      var rest = spec.slice(1).split("/");
      if (rest.length !== 2)
        return false;
      return rest[0] && rest[1] && rest[0] === encodeURIComponent(rest[0]) && rest[1] === encodeURIComponent(rest[1]);
    }
    __name(isValidScopedPackageName, "isValidScopedPackageName");
    function isCorrectlyEncodedName(spec) {
      return !spec.match(/[\/@\s\+%:]/) && spec === encodeURIComponent(spec);
    }
    __name(isCorrectlyEncodedName, "isCorrectlyEncodedName");
    function ensureValidName(name, strict, allowLegacyCase) {
      if (name.charAt(0) === "." || !(isValidScopedPackageName(name) || isCorrectlyEncodedName(name)) || strict && !allowLegacyCase && name !== name.toLowerCase() || name.toLowerCase() === "node_modules" || name.toLowerCase() === "favicon.ico") {
        throw new Error("Invalid name: " + JSON.stringify(name));
      }
    }
    __name(ensureValidName, "ensureValidName");
    function modifyPeople(data, fn) {
      if (data.author)
        data.author = fn(data.author);
      ["maintainers", "contributors"].forEach(function(set) {
        if (!Array.isArray(data[set]))
          return;
        data[set] = data[set].map(fn);
      });
      return data;
    }
    __name(modifyPeople, "modifyPeople");
    function unParsePerson(person) {
      if (typeof person === "string")
        return person;
      var name = person.name || "";
      var u2 = person.url || person.web;
      var url2 = u2 ? " (" + u2 + ")" : "";
      var e2 = person.email || person.mail;
      var email = e2 ? " <" + e2 + ">" : "";
      return name + email + url2;
    }
    __name(unParsePerson, "unParsePerson");
    function parsePerson(person) {
      if (typeof person !== "string")
        return person;
      var name = person.match(/^([^\(<]+)/);
      var url2 = person.match(/\(([^\)]+)\)/);
      var email = person.match(/<([^>]+)>/);
      var obj = {};
      if (name && name[0].trim())
        obj.name = name[0].trim();
      if (email)
        obj.email = email[1];
      if (url2)
        obj.url = url2[1];
      return obj;
    }
    __name(parsePerson, "parsePerson");
    function addOptionalDepsToDeps(data, warn2) {
      var o = data.optionalDependencies;
      if (!o)
        return;
      var d2 = data.dependencies || {};
      Object.keys(o).forEach(function(k) {
        d2[k] = o[k];
      });
      data.dependencies = d2;
    }
    __name(addOptionalDepsToDeps, "addOptionalDepsToDeps");
    function depObjectify(deps, type, warn2) {
      if (!deps)
        return {};
      if (typeof deps === "string") {
        deps = deps.trim().split(/[\n\r\s\t ,]+/);
      }
      if (!Array.isArray(deps))
        return deps;
      warn2("deprecatedArrayDependencies", type);
      var o = {};
      deps.filter(function(d2) {
        return typeof d2 === "string";
      }).forEach(function(d2) {
        d2 = d2.trim().split(/(:?[@\s><=])/);
        var dn = d2.shift();
        var dv = d2.join("");
        dv = dv.trim();
        dv = dv.replace(/^@/, "");
        o[dn] = dv;
      });
      return o;
    }
    __name(depObjectify, "depObjectify");
    function objectifyDeps(data, warn2) {
      depTypes.forEach(function(type) {
        if (!data[type])
          return;
        data[type] = depObjectify(data[type], type, warn2);
      });
    }
    __name(objectifyDeps, "objectifyDeps");
    function bugsTypos(bugs, warn2) {
      if (!bugs)
        return;
      Object.keys(bugs).forEach(function(k) {
        if (typos.bugs[k]) {
          warn2("typo", k, typos.bugs[k], "bugs");
          bugs[typos.bugs[k]] = bugs[k];
          delete bugs[k];
        }
      });
    }
    __name(bugsTypos, "bugsTypos");
  }
});

// ../../node_modules/.pnpm/normalize-package-data@2.5.0/node_modules/normalize-package-data/lib/warning_messages.json
var require_warning_messages = __commonJS({
  "../../node_modules/.pnpm/normalize-package-data@2.5.0/node_modules/normalize-package-data/lib/warning_messages.json"(exports, module2) {
    module2.exports = {
      repositories: "'repositories' (plural) Not supported. Please pick one as the 'repository' field",
      missingRepository: "No repository field.",
      brokenGitUrl: "Probably broken git url: %s",
      nonObjectScripts: "scripts must be an object",
      nonStringScript: "script values must be string commands",
      nonArrayFiles: "Invalid 'files' member",
      invalidFilename: "Invalid filename in 'files' list: %s",
      nonArrayBundleDependencies: "Invalid 'bundleDependencies' list. Must be array of package names",
      nonStringBundleDependency: "Invalid bundleDependencies member: %s",
      nonDependencyBundleDependency: "Non-dependency in bundleDependencies: %s",
      nonObjectDependencies: "%s field must be an object",
      nonStringDependency: "Invalid dependency: %s %s",
      deprecatedArrayDependencies: "specifying %s as array is deprecated",
      deprecatedModules: "modules field is deprecated",
      nonArrayKeywords: "keywords should be an array of strings",
      nonStringKeyword: "keywords should be an array of strings",
      conflictingName: "%s is also the name of a node core module.",
      nonStringDescription: "'description' field should be a string",
      missingDescription: "No description",
      missingReadme: "No README data",
      missingLicense: "No license field.",
      nonEmailUrlBugsString: "Bug string field must be url, email, or {email,url}",
      nonUrlBugsUrlField: "bugs.url field must be a string url. Deleted.",
      nonEmailBugsEmailField: "bugs.email field must be a string email. Deleted.",
      emptyNormalizedBugs: "Normalized value of bugs field is an empty object. Deleted.",
      nonUrlHomepage: "homepage field must be a string url. Deleted.",
      invalidLicense: "license should be a valid SPDX license expression",
      typo: "%s should probably be %s."
    };
  }
});

// ../../node_modules/.pnpm/normalize-package-data@2.5.0/node_modules/normalize-package-data/lib/make_warning.js
var require_make_warning = __commonJS({
  "../../node_modules/.pnpm/normalize-package-data@2.5.0/node_modules/normalize-package-data/lib/make_warning.js"(exports, module2) {
    var util2 = require("util");
    var messages = require_warning_messages();
    module2.exports = function() {
      var args = Array.prototype.slice.call(arguments, 0);
      var warningName = args.shift();
      if (warningName == "typo") {
        return makeTypoWarning.apply(null, args);
      } else {
        var msgTemplate = messages[warningName] ? messages[warningName] : warningName + ": '%s'";
        args.unshift(msgTemplate);
        return util2.format.apply(null, args);
      }
    };
    function makeTypoWarning(providedName, probableName, field) {
      if (field) {
        providedName = field + "['" + providedName + "']";
        probableName = field + "['" + probableName + "']";
      }
      return util2.format(messages.typo, providedName, probableName);
    }
    __name(makeTypoWarning, "makeTypoWarning");
  }
});

// ../../node_modules/.pnpm/normalize-package-data@2.5.0/node_modules/normalize-package-data/lib/normalize.js
var require_normalize = __commonJS({
  "../../node_modules/.pnpm/normalize-package-data@2.5.0/node_modules/normalize-package-data/lib/normalize.js"(exports, module2) {
    module2.exports = normalize;
    var fixer = require_fixer();
    normalize.fixer = fixer;
    var makeWarning = require_make_warning();
    var fieldsToFix = [
      "name",
      "version",
      "description",
      "repository",
      "modules",
      "scripts",
      "files",
      "bin",
      "man",
      "bugs",
      "keywords",
      "readme",
      "homepage",
      "license"
    ];
    var otherThingsToFix = ["dependencies", "people", "typos"];
    var thingsToFix = fieldsToFix.map(function(fieldName) {
      return ucFirst(fieldName) + "Field";
    });
    thingsToFix = thingsToFix.concat(otherThingsToFix);
    function normalize(data, warn2, strict) {
      if (warn2 === true)
        warn2 = null, strict = true;
      if (!strict)
        strict = false;
      if (!warn2 || data.private)
        warn2 = /* @__PURE__ */ __name(function(msg) {
        }, "warn");
      if (data.scripts && data.scripts.install === "node-gyp rebuild" && !data.scripts.preinstall) {
        data.gypfile = true;
      }
      fixer.warn = function() {
        warn2(makeWarning.apply(null, arguments));
      };
      thingsToFix.forEach(function(thingName) {
        fixer["fix" + ucFirst(thingName)](data, strict);
      });
      data._id = data.name + "@" + data.version;
    }
    __name(normalize, "normalize");
    function ucFirst(string) {
      return string.charAt(0).toUpperCase() + string.slice(1);
    }
    __name(ucFirst, "ucFirst");
  }
});

// ../../node_modules/.pnpm/read-pkg@5.2.0/node_modules/read-pkg/index.js
var require_read_pkg = __commonJS({
  "../../node_modules/.pnpm/read-pkg@5.2.0/node_modules/read-pkg/index.js"(exports, module2) {
    "use strict";
    var { promisify: promisify5 } = require("util");
    var fs11 = require("fs");
    var path9 = require("path");
    var parseJson = require_parse_json();
    var readFileAsync = promisify5(fs11.readFile);
    module2.exports = async (options2) => {
      options2 = {
        cwd: process.cwd(),
        normalize: true,
        ...options2
      };
      const filePath = path9.resolve(options2.cwd, "package.json");
      const json = parseJson(await readFileAsync(filePath, "utf8"));
      if (options2.normalize) {
        require_normalize()(json);
      }
      return json;
    };
    module2.exports.sync = (options2) => {
      options2 = {
        cwd: process.cwd(),
        normalize: true,
        ...options2
      };
      const filePath = path9.resolve(options2.cwd, "package.json");
      const json = parseJson(fs11.readFileSync(filePath, "utf8"));
      if (options2.normalize) {
        require_normalize()(json);
      }
      return json;
    };
  }
});

// ../../node_modules/.pnpm/read-pkg-up@7.0.1/node_modules/read-pkg-up/index.js
var require_read_pkg_up = __commonJS({
  "../../node_modules/.pnpm/read-pkg-up@7.0.1/node_modules/read-pkg-up/index.js"(exports, module2) {
    "use strict";
    var path9 = require("path");
    var findUp2 = require_find_up2();
    var readPkg = require_read_pkg();
    module2.exports = async (options2) => {
      const filePath = await findUp2("package.json", options2);
      if (!filePath) {
        return;
      }
      return {
        packageJson: await readPkg({ ...options2, cwd: path9.dirname(filePath) }),
        path: filePath
      };
    };
    module2.exports.sync = (options2) => {
      const filePath = findUp2.sync("package.json", options2);
      if (!filePath) {
        return;
      }
      return {
        packageJson: readPkg.sync({ ...options2, cwd: path9.dirname(filePath) }),
        path: filePath
      };
    };
  }
});

// ../../node_modules/.pnpm/dotenv@16.0.3/node_modules/dotenv/package.json
var require_package2 = __commonJS({
  "../../node_modules/.pnpm/dotenv@16.0.3/node_modules/dotenv/package.json"(exports, module2) {
    module2.exports = {
      name: "dotenv",
      version: "16.0.3",
      description: "Loads environment variables from .env file",
      main: "lib/main.js",
      types: "lib/main.d.ts",
      exports: {
        ".": {
          require: "./lib/main.js",
          types: "./lib/main.d.ts",
          default: "./lib/main.js"
        },
        "./config": "./config.js",
        "./config.js": "./config.js",
        "./lib/env-options": "./lib/env-options.js",
        "./lib/env-options.js": "./lib/env-options.js",
        "./lib/cli-options": "./lib/cli-options.js",
        "./lib/cli-options.js": "./lib/cli-options.js",
        "./package.json": "./package.json"
      },
      scripts: {
        "dts-check": "tsc --project tests/types/tsconfig.json",
        lint: "standard",
        "lint-readme": "standard-markdown",
        pretest: "npm run lint && npm run dts-check",
        test: "tap tests/*.js --100 -Rspec",
        prerelease: "npm test",
        release: "standard-version"
      },
      repository: {
        type: "git",
        url: "git://github.com/motdotla/dotenv.git"
      },
      keywords: [
        "dotenv",
        "env",
        ".env",
        "environment",
        "variables",
        "config",
        "settings"
      ],
      readmeFilename: "README.md",
      license: "BSD-2-Clause",
      devDependencies: {
        "@types/node": "^17.0.9",
        decache: "^4.6.1",
        dtslint: "^3.7.0",
        sinon: "^12.0.1",
        standard: "^16.0.4",
        "standard-markdown": "^7.1.0",
        "standard-version": "^9.3.2",
        tap: "^15.1.6",
        tar: "^6.1.11",
        typescript: "^4.5.4"
      },
      engines: {
        node: ">=12"
      }
    };
  }
});

// ../../node_modules/.pnpm/dotenv@16.0.3/node_modules/dotenv/lib/main.js
var require_main2 = __commonJS({
  "../../node_modules/.pnpm/dotenv@16.0.3/node_modules/dotenv/lib/main.js"(exports, module2) {
    var fs11 = require("fs");
    var path9 = require("path");
    var os2 = require("os");
    var packageJson = require_package2();
    var version = packageJson.version;
    var LINE = /(?:^|^)\s*(?:export\s+)?([\w.-]+)(?:\s*=\s*?|:\s+?)(\s*'(?:\\'|[^'])*'|\s*"(?:\\"|[^"])*"|\s*`(?:\\`|[^`])*`|[^#\r\n]+)?\s*(?:#.*)?(?:$|$)/mg;
    function parse(src) {
      const obj = {};
      let lines = src.toString();
      lines = lines.replace(/\r\n?/mg, "\n");
      let match;
      while ((match = LINE.exec(lines)) != null) {
        const key = match[1];
        let value = match[2] || "";
        value = value.trim();
        const maybeQuote = value[0];
        value = value.replace(/^(['"`])([\s\S]*)\1$/mg, "$2");
        if (maybeQuote === '"') {
          value = value.replace(/\\n/g, "\n");
          value = value.replace(/\\r/g, "\r");
        }
        obj[key] = value;
      }
      return obj;
    }
    __name(parse, "parse");
    function _log(message) {
      console.log(`[dotenv@${version}][DEBUG] ${message}`);
    }
    __name(_log, "_log");
    function _resolveHome(envPath) {
      return envPath[0] === "~" ? path9.join(os2.homedir(), envPath.slice(1)) : envPath;
    }
    __name(_resolveHome, "_resolveHome");
    function config2(options2) {
      let dotenvPath = path9.resolve(process.cwd(), ".env");
      let encoding = "utf8";
      const debug9 = Boolean(options2 && options2.debug);
      const override = Boolean(options2 && options2.override);
      if (options2) {
        if (options2.path != null) {
          dotenvPath = _resolveHome(options2.path);
        }
        if (options2.encoding != null) {
          encoding = options2.encoding;
        }
      }
      try {
        const parsed = DotenvModule.parse(fs11.readFileSync(dotenvPath, { encoding }));
        Object.keys(parsed).forEach(function(key) {
          if (!Object.prototype.hasOwnProperty.call(process.env, key)) {
            process.env[key] = parsed[key];
          } else {
            if (override === true) {
              process.env[key] = parsed[key];
            }
            if (debug9) {
              if (override === true) {
                _log(`"${key}" is already defined in \`process.env\` and WAS overwritten`);
              } else {
                _log(`"${key}" is already defined in \`process.env\` and was NOT overwritten`);
              }
            }
          }
        });
        return { parsed };
      } catch (e2) {
        if (debug9) {
          _log(`Failed to load ${dotenvPath} ${e2.message}`);
        }
        return { error: e2 };
      }
    }
    __name(config2, "config");
    var DotenvModule = {
      config: config2,
      parse
    };
    module2.exports.config = DotenvModule.config;
    module2.exports.parse = DotenvModule.parse;
    module2.exports = DotenvModule;
  }
});

// ../../node_modules/.pnpm/ansi-escapes@4.3.2/node_modules/ansi-escapes/index.js
var require_ansi_escapes = __commonJS({
  "../../node_modules/.pnpm/ansi-escapes@4.3.2/node_modules/ansi-escapes/index.js"(exports, module2) {
    "use strict";
    var ansiEscapes = module2.exports;
    module2.exports.default = ansiEscapes;
    var ESC = "\x1B[";
    var OSC = "\x1B]";
    var BEL = "\x07";
    var SEP = ";";
    var isTerminalApp = process.env.TERM_PROGRAM === "Apple_Terminal";
    ansiEscapes.cursorTo = (x, y2) => {
      if (typeof x !== "number") {
        throw new TypeError("The `x` argument is required");
      }
      if (typeof y2 !== "number") {
        return ESC + (x + 1) + "G";
      }
      return ESC + (y2 + 1) + ";" + (x + 1) + "H";
    };
    ansiEscapes.cursorMove = (x, y2) => {
      if (typeof x !== "number") {
        throw new TypeError("The `x` argument is required");
      }
      let ret = "";
      if (x < 0) {
        ret += ESC + -x + "D";
      } else if (x > 0) {
        ret += ESC + x + "C";
      }
      if (y2 < 0) {
        ret += ESC + -y2 + "A";
      } else if (y2 > 0) {
        ret += ESC + y2 + "B";
      }
      return ret;
    };
    ansiEscapes.cursorUp = (count = 1) => ESC + count + "A";
    ansiEscapes.cursorDown = (count = 1) => ESC + count + "B";
    ansiEscapes.cursorForward = (count = 1) => ESC + count + "C";
    ansiEscapes.cursorBackward = (count = 1) => ESC + count + "D";
    ansiEscapes.cursorLeft = ESC + "G";
    ansiEscapes.cursorSavePosition = isTerminalApp ? "\x1B7" : ESC + "s";
    ansiEscapes.cursorRestorePosition = isTerminalApp ? "\x1B8" : ESC + "u";
    ansiEscapes.cursorGetPosition = ESC + "6n";
    ansiEscapes.cursorNextLine = ESC + "E";
    ansiEscapes.cursorPrevLine = ESC + "F";
    ansiEscapes.cursorHide = ESC + "?25l";
    ansiEscapes.cursorShow = ESC + "?25h";
    ansiEscapes.eraseLines = (count) => {
      let clear = "";
      for (let i = 0; i < count; i++) {
        clear += ansiEscapes.eraseLine + (i < count - 1 ? ansiEscapes.cursorUp() : "");
      }
      if (count) {
        clear += ansiEscapes.cursorLeft;
      }
      return clear;
    };
    ansiEscapes.eraseEndLine = ESC + "K";
    ansiEscapes.eraseStartLine = ESC + "1K";
    ansiEscapes.eraseLine = ESC + "2K";
    ansiEscapes.eraseDown = ESC + "J";
    ansiEscapes.eraseUp = ESC + "1J";
    ansiEscapes.eraseScreen = ESC + "2J";
    ansiEscapes.scrollUp = ESC + "S";
    ansiEscapes.scrollDown = ESC + "T";
    ansiEscapes.clearScreen = "\x1Bc";
    ansiEscapes.clearTerminal = process.platform === "win32" ? `${ansiEscapes.eraseScreen}${ESC}0f` : `${ansiEscapes.eraseScreen}${ESC}3J${ESC}H`;
    ansiEscapes.beep = BEL;
    ansiEscapes.link = (text, url) => {
      return [
        OSC,
        "8",
        SEP,
        SEP,
        url,
        BEL,
        text,
        OSC,
        "8",
        SEP,
        SEP,
        BEL
      ].join("");
    };
    ansiEscapes.image = (buffer, options2 = {}) => {
      let ret = `${OSC}1337;File=inline=1`;
      if (options2.width) {
        ret += `;width=${options2.width}`;
      }
      if (options2.height) {
        ret += `;height=${options2.height}`;
      }
      if (options2.preserveAspectRatio === false) {
        ret += ";preserveAspectRatio=0";
      }
      return ret + ":" + buffer.toString("base64") + BEL;
    };
    ansiEscapes.iTerm = {
      setCwd: (cwd = process.cwd()) => `${OSC}50;CurrentDir=${cwd}${BEL}`,
      annotation: (message, options2 = {}) => {
        let ret = `${OSC}1337;`;
        const hasX = typeof options2.x !== "undefined";
        const hasY = typeof options2.y !== "undefined";
        if ((hasX || hasY) && !(hasX && hasY && typeof options2.length !== "undefined")) {
          throw new Error("`x`, `y` and `length` must be defined when `x` or `y` is defined");
        }
        message = message.replace(/\|/g, "");
        ret += options2.isHidden ? "AddHiddenAnnotation=" : "AddAnnotation=";
        if (options2.length > 0) {
          ret += (hasX ? [message, options2.length, options2.x, options2.y] : [options2.length, message]).join("|");
        } else {
          ret += message;
        }
        return ret + BEL;
      }
    };
  }
});

// ../../node_modules/.pnpm/supports-hyperlinks@2.3.0/node_modules/supports-hyperlinks/index.js
var require_supports_hyperlinks = __commonJS({
  "../../node_modules/.pnpm/supports-hyperlinks@2.3.0/node_modules/supports-hyperlinks/index.js"(exports, module2) {
    "use strict";
    var supportsColor = require_supports_color();
    var hasFlag = require_has_flag();
    function parseVersion(versionString) {
      if (/^\d{3,4}$/.test(versionString)) {
        const m = /(\d{1,2})(\d{2})/.exec(versionString);
        return {
          major: 0,
          minor: parseInt(m[1], 10),
          patch: parseInt(m[2], 10)
        };
      }
      const versions = (versionString || "").split(".").map((n2) => parseInt(n2, 10));
      return {
        major: versions[0],
        minor: versions[1],
        patch: versions[2]
      };
    }
    __name(parseVersion, "parseVersion");
    function supportsHyperlink(stream2) {
      const { env } = process;
      if ("FORCE_HYPERLINK" in env) {
        return !(env.FORCE_HYPERLINK.length > 0 && parseInt(env.FORCE_HYPERLINK, 10) === 0);
      }
      if (hasFlag("no-hyperlink") || hasFlag("no-hyperlinks") || hasFlag("hyperlink=false") || hasFlag("hyperlink=never")) {
        return false;
      }
      if (hasFlag("hyperlink=true") || hasFlag("hyperlink=always")) {
        return true;
      }
      if ("NETLIFY" in env) {
        return true;
      }
      if (!supportsColor.supportsColor(stream2)) {
        return false;
      }
      if (stream2 && !stream2.isTTY) {
        return false;
      }
      if (process.platform === "win32") {
        return false;
      }
      if ("CI" in env) {
        return false;
      }
      if ("TEAMCITY_VERSION" in env) {
        return false;
      }
      if ("TERM_PROGRAM" in env) {
        const version = parseVersion(env.TERM_PROGRAM_VERSION);
        switch (env.TERM_PROGRAM) {
          case "iTerm.app":
            if (version.major === 3) {
              return version.minor >= 1;
            }
            return version.major > 3;
          case "WezTerm":
            return version.major >= 20200620;
          case "vscode":
            return version.major > 1 || version.major === 1 && version.minor >= 72;
        }
      }
      if ("VTE_VERSION" in env) {
        if (env.VTE_VERSION === "0.50.0") {
          return false;
        }
        const version = parseVersion(env.VTE_VERSION);
        return version.major > 0 || version.minor >= 50;
      }
      return false;
    }
    __name(supportsHyperlink, "supportsHyperlink");
    module2.exports = {
      supportsHyperlink,
      stdout: supportsHyperlink(process.stdout),
      stderr: supportsHyperlink(process.stderr)
    };
  }
});

// ../../node_modules/.pnpm/terminal-link@2.1.1/node_modules/terminal-link/index.js
var require_terminal_link = __commonJS({
  "../../node_modules/.pnpm/terminal-link@2.1.1/node_modules/terminal-link/index.js"(exports, module2) {
    "use strict";
    var ansiEscapes = require_ansi_escapes();
    var supportsHyperlinks = require_supports_hyperlinks();
    var terminalLink2 = /* @__PURE__ */ __name((text, url, { target = "stdout", ...options2 } = {}) => {
      if (!supportsHyperlinks[target]) {
        if (options2.fallback === false) {
          return text;
        }
        return typeof options2.fallback === "function" ? options2.fallback(text, url) : `${text} (\u200B${url}\u200B)`;
      }
      return ansiEscapes.link(text, url);
    }, "terminalLink");
    module2.exports = (text, url, options2 = {}) => terminalLink2(text, url, options2);
    module2.exports.stderr = (text, url, options2 = {}) => terminalLink2(text, url, { target: "stderr", ...options2 });
    module2.exports.isSupported = supportsHyperlinks.stdout;
    module2.exports.stderr.isSupported = supportsHyperlinks.stderr;
  }
});

// ../../node_modules/.pnpm/universalify@2.0.0/node_modules/universalify/index.js
var require_universalify = __commonJS({
  "../../node_modules/.pnpm/universalify@2.0.0/node_modules/universalify/index.js"(exports) {
    "use strict";
    exports.fromCallback = function(fn) {
      return Object.defineProperty(function(...args) {
        if (typeof args[args.length - 1] === "function")
          fn.apply(this, args);
        else {
          return new Promise((resolve, reject) => {
            fn.call(
              this,
              ...args,
              (err, res) => err != null ? reject(err) : resolve(res)
            );
          });
        }
      }, "name", { value: fn.name });
    };
    exports.fromPromise = function(fn) {
      return Object.defineProperty(function(...args) {
        const cb = args[args.length - 1];
        if (typeof cb !== "function")
          return fn.apply(this, args);
        else
          fn.apply(this, args.slice(0, -1)).then((r2) => cb(null, r2), cb);
      }, "name", { value: fn.name });
    };
  }
});

// ../../node_modules/.pnpm/graceful-fs@4.2.10/node_modules/graceful-fs/polyfills.js
var require_polyfills = __commonJS({
  "../../node_modules/.pnpm/graceful-fs@4.2.10/node_modules/graceful-fs/polyfills.js"(exports, module2) {
    var constants = require("constants");
    var origCwd = process.cwd;
    var cwd = null;
    var platform = process.env.GRACEFUL_FS_PLATFORM || process.platform;
    process.cwd = function() {
      if (!cwd)
        cwd = origCwd.call(process);
      return cwd;
    };
    try {
      process.cwd();
    } catch (er) {
    }
    if (typeof process.chdir === "function") {
      chdir = process.chdir;
      process.chdir = function(d2) {
        cwd = null;
        chdir.call(process, d2);
      };
      if (Object.setPrototypeOf)
        Object.setPrototypeOf(process.chdir, chdir);
    }
    var chdir;
    module2.exports = patch;
    function patch(fs11) {
      if (constants.hasOwnProperty("O_SYMLINK") && process.version.match(/^v0\.6\.[0-2]|^v0\.5\./)) {
        patchLchmod(fs11);
      }
      if (!fs11.lutimes) {
        patchLutimes(fs11);
      }
      fs11.chown = chownFix(fs11.chown);
      fs11.fchown = chownFix(fs11.fchown);
      fs11.lchown = chownFix(fs11.lchown);
      fs11.chmod = chmodFix(fs11.chmod);
      fs11.fchmod = chmodFix(fs11.fchmod);
      fs11.lchmod = chmodFix(fs11.lchmod);
      fs11.chownSync = chownFixSync(fs11.chownSync);
      fs11.fchownSync = chownFixSync(fs11.fchownSync);
      fs11.lchownSync = chownFixSync(fs11.lchownSync);
      fs11.chmodSync = chmodFixSync(fs11.chmodSync);
      fs11.fchmodSync = chmodFixSync(fs11.fchmodSync);
      fs11.lchmodSync = chmodFixSync(fs11.lchmodSync);
      fs11.stat = statFix(fs11.stat);
      fs11.fstat = statFix(fs11.fstat);
      fs11.lstat = statFix(fs11.lstat);
      fs11.statSync = statFixSync(fs11.statSync);
      fs11.fstatSync = statFixSync(fs11.fstatSync);
      fs11.lstatSync = statFixSync(fs11.lstatSync);
      if (fs11.chmod && !fs11.lchmod) {
        fs11.lchmod = function(path9, mode, cb) {
          if (cb)
            process.nextTick(cb);
        };
        fs11.lchmodSync = function() {
        };
      }
      if (fs11.chown && !fs11.lchown) {
        fs11.lchown = function(path9, uid, gid, cb) {
          if (cb)
            process.nextTick(cb);
        };
        fs11.lchownSync = function() {
        };
      }
      if (platform === "win32") {
        fs11.rename = typeof fs11.rename !== "function" ? fs11.rename : function(fs$rename) {
          function rename(from, to, cb) {
            var start = Date.now();
            var backoff = 0;
            fs$rename(from, to, /* @__PURE__ */ __name(function CB(er) {
              if (er && (er.code === "EACCES" || er.code === "EPERM") && Date.now() - start < 6e4) {
                setTimeout(function() {
                  fs11.stat(to, function(stater, st) {
                    if (stater && stater.code === "ENOENT")
                      fs$rename(from, to, CB);
                    else
                      cb(er);
                  });
                }, backoff);
                if (backoff < 100)
                  backoff += 10;
                return;
              }
              if (cb)
                cb(er);
            }, "CB"));
          }
          __name(rename, "rename");
          if (Object.setPrototypeOf)
            Object.setPrototypeOf(rename, fs$rename);
          return rename;
        }(fs11.rename);
      }
      fs11.read = typeof fs11.read !== "function" ? fs11.read : function(fs$read) {
        function read(fd, buffer, offset, length, position, callback_) {
          var callback;
          if (callback_ && typeof callback_ === "function") {
            var eagCounter = 0;
            callback = /* @__PURE__ */ __name(function(er, _, __) {
              if (er && er.code === "EAGAIN" && eagCounter < 10) {
                eagCounter++;
                return fs$read.call(fs11, fd, buffer, offset, length, position, callback);
              }
              callback_.apply(this, arguments);
            }, "callback");
          }
          return fs$read.call(fs11, fd, buffer, offset, length, position, callback);
        }
        __name(read, "read");
        if (Object.setPrototypeOf)
          Object.setPrototypeOf(read, fs$read);
        return read;
      }(fs11.read);
      fs11.readSync = typeof fs11.readSync !== "function" ? fs11.readSync : function(fs$readSync) {
        return function(fd, buffer, offset, length, position) {
          var eagCounter = 0;
          while (true) {
            try {
              return fs$readSync.call(fs11, fd, buffer, offset, length, position);
            } catch (er) {
              if (er.code === "EAGAIN" && eagCounter < 10) {
                eagCounter++;
                continue;
              }
              throw er;
            }
          }
        };
      }(fs11.readSync);
      function patchLchmod(fs12) {
        fs12.lchmod = function(path9, mode, callback) {
          fs12.open(
            path9,
            constants.O_WRONLY | constants.O_SYMLINK,
            mode,
            function(err, fd) {
              if (err) {
                if (callback)
                  callback(err);
                return;
              }
              fs12.fchmod(fd, mode, function(err2) {
                fs12.close(fd, function(err22) {
                  if (callback)
                    callback(err2 || err22);
                });
              });
            }
          );
        };
        fs12.lchmodSync = function(path9, mode) {
          var fd = fs12.openSync(path9, constants.O_WRONLY | constants.O_SYMLINK, mode);
          var threw = true;
          var ret;
          try {
            ret = fs12.fchmodSync(fd, mode);
            threw = false;
          } finally {
            if (threw) {
              try {
                fs12.closeSync(fd);
              } catch (er) {
              }
            } else {
              fs12.closeSync(fd);
            }
          }
          return ret;
        };
      }
      __name(patchLchmod, "patchLchmod");
      function patchLutimes(fs12) {
        if (constants.hasOwnProperty("O_SYMLINK") && fs12.futimes) {
          fs12.lutimes = function(path9, at, mt, cb) {
            fs12.open(path9, constants.O_SYMLINK, function(er, fd) {
              if (er) {
                if (cb)
                  cb(er);
                return;
              }
              fs12.futimes(fd, at, mt, function(er2) {
                fs12.close(fd, function(er22) {
                  if (cb)
                    cb(er2 || er22);
                });
              });
            });
          };
          fs12.lutimesSync = function(path9, at, mt) {
            var fd = fs12.openSync(path9, constants.O_SYMLINK);
            var ret;
            var threw = true;
            try {
              ret = fs12.futimesSync(fd, at, mt);
              threw = false;
            } finally {
              if (threw) {
                try {
                  fs12.closeSync(fd);
                } catch (er) {
                }
              } else {
                fs12.closeSync(fd);
              }
            }
            return ret;
          };
        } else if (fs12.futimes) {
          fs12.lutimes = function(_a, _b, _c, cb) {
            if (cb)
              process.nextTick(cb);
          };
          fs12.lutimesSync = function() {
          };
        }
      }
      __name(patchLutimes, "patchLutimes");
      function chmodFix(orig) {
        if (!orig)
          return orig;
        return function(target, mode, cb) {
          return orig.call(fs11, target, mode, function(er) {
            if (chownErOk(er))
              er = null;
            if (cb)
              cb.apply(this, arguments);
          });
        };
      }
      __name(chmodFix, "chmodFix");
      function chmodFixSync(orig) {
        if (!orig)
          return orig;
        return function(target, mode) {
          try {
            return orig.call(fs11, target, mode);
          } catch (er) {
            if (!chownErOk(er))
              throw er;
          }
        };
      }
      __name(chmodFixSync, "chmodFixSync");
      function chownFix(orig) {
        if (!orig)
          return orig;
        return function(target, uid, gid, cb) {
          return orig.call(fs11, target, uid, gid, function(er) {
            if (chownErOk(er))
              er = null;
            if (cb)
              cb.apply(this, arguments);
          });
        };
      }
      __name(chownFix, "chownFix");
      function chownFixSync(orig) {
        if (!orig)
          return orig;
        return function(target, uid, gid) {
          try {
            return orig.call(fs11, target, uid, gid);
          } catch (er) {
            if (!chownErOk(er))
              throw er;
          }
        };
      }
      __name(chownFixSync, "chownFixSync");
      function statFix(orig) {
        if (!orig)
          return orig;
        return function(target, options2, cb) {
          if (typeof options2 === "function") {
            cb = options2;
            options2 = null;
          }
          function callback(er, stats) {
            if (stats) {
              if (stats.uid < 0)
                stats.uid += 4294967296;
              if (stats.gid < 0)
                stats.gid += 4294967296;
            }
            if (cb)
              cb.apply(this, arguments);
          }
          __name(callback, "callback");
          return options2 ? orig.call(fs11, target, options2, callback) : orig.call(fs11, target, callback);
        };
      }
      __name(statFix, "statFix");
      function statFixSync(orig) {
        if (!orig)
          return orig;
        return function(target, options2) {
          var stats = options2 ? orig.call(fs11, target, options2) : orig.call(fs11, target);
          if (stats) {
            if (stats.uid < 0)
              stats.uid += 4294967296;
            if (stats.gid < 0)
              stats.gid += 4294967296;
          }
          return stats;
        };
      }
      __name(statFixSync, "statFixSync");
      function chownErOk(er) {
        if (!er)
          return true;
        if (er.code === "ENOSYS")
          return true;
        var nonroot = !process.getuid || process.getuid() !== 0;
        if (nonroot) {
          if (er.code === "EINVAL" || er.code === "EPERM")
            return true;
        }
        return false;
      }
      __name(chownErOk, "chownErOk");
    }
    __name(patch, "patch");
  }
});

// ../../node_modules/.pnpm/graceful-fs@4.2.10/node_modules/graceful-fs/legacy-streams.js
var require_legacy_streams = __commonJS({
  "../../node_modules/.pnpm/graceful-fs@4.2.10/node_modules/graceful-fs/legacy-streams.js"(exports, module2) {
    var Stream = require("stream").Stream;
    module2.exports = legacy;
    function legacy(fs11) {
      return {
        ReadStream,
        WriteStream
      };
      function ReadStream(path9, options2) {
        if (!(this instanceof ReadStream))
          return new ReadStream(path9, options2);
        Stream.call(this);
        var self = this;
        this.path = path9;
        this.fd = null;
        this.readable = true;
        this.paused = false;
        this.flags = "r";
        this.mode = 438;
        this.bufferSize = 64 * 1024;
        options2 = options2 || {};
        var keys = Object.keys(options2);
        for (var index = 0, length = keys.length; index < length; index++) {
          var key = keys[index];
          this[key] = options2[key];
        }
        if (this.encoding)
          this.setEncoding(this.encoding);
        if (this.start !== void 0) {
          if ("number" !== typeof this.start) {
            throw TypeError("start must be a Number");
          }
          if (this.end === void 0) {
            this.end = Infinity;
          } else if ("number" !== typeof this.end) {
            throw TypeError("end must be a Number");
          }
          if (this.start > this.end) {
            throw new Error("start must be <= end");
          }
          this.pos = this.start;
        }
        if (this.fd !== null) {
          process.nextTick(function() {
            self._read();
          });
          return;
        }
        fs11.open(this.path, this.flags, this.mode, function(err, fd) {
          if (err) {
            self.emit("error", err);
            self.readable = false;
            return;
          }
          self.fd = fd;
          self.emit("open", fd);
          self._read();
        });
      }
      __name(ReadStream, "ReadStream");
      function WriteStream(path9, options2) {
        if (!(this instanceof WriteStream))
          return new WriteStream(path9, options2);
        Stream.call(this);
        this.path = path9;
        this.fd = null;
        this.writable = true;
        this.flags = "w";
        this.encoding = "binary";
        this.mode = 438;
        this.bytesWritten = 0;
        options2 = options2 || {};
        var keys = Object.keys(options2);
        for (var index = 0, length = keys.length; index < length; index++) {
          var key = keys[index];
          this[key] = options2[key];
        }
        if (this.start !== void 0) {
          if ("number" !== typeof this.start) {
            throw TypeError("start must be a Number");
          }
          if (this.start < 0) {
            throw new Error("start must be >= zero");
          }
          this.pos = this.start;
        }
        this.busy = false;
        this._queue = [];
        if (this.fd === null) {
          this._open = fs11.open;
          this._queue.push([this._open, this.path, this.flags, this.mode, void 0]);
          this.flush();
        }
      }
      __name(WriteStream, "WriteStream");
    }
    __name(legacy, "legacy");
  }
});

// ../../node_modules/.pnpm/graceful-fs@4.2.10/node_modules/graceful-fs/clone.js
var require_clone = __commonJS({
  "../../node_modules/.pnpm/graceful-fs@4.2.10/node_modules/graceful-fs/clone.js"(exports, module2) {
    "use strict";
    module2.exports = clone2;
    var getPrototypeOf = Object.getPrototypeOf || function(obj) {
      return obj.__proto__;
    };
    function clone2(obj) {
      if (obj === null || typeof obj !== "object")
        return obj;
      if (obj instanceof Object)
        var copy = { __proto__: getPrototypeOf(obj) };
      else
        var copy = /* @__PURE__ */ Object.create(null);
      Object.getOwnPropertyNames(obj).forEach(function(key) {
        Object.defineProperty(copy, key, Object.getOwnPropertyDescriptor(obj, key));
      });
      return copy;
    }
    __name(clone2, "clone");
  }
});

// ../../node_modules/.pnpm/graceful-fs@4.2.10/node_modules/graceful-fs/graceful-fs.js
var require_graceful_fs = __commonJS({
  "../../node_modules/.pnpm/graceful-fs@4.2.10/node_modules/graceful-fs/graceful-fs.js"(exports, module2) {
    var fs11 = require("fs");
    var polyfills = require_polyfills();
    var legacy = require_legacy_streams();
    var clone2 = require_clone();
    var util2 = require("util");
    var gracefulQueue;
    var previousSymbol;
    if (typeof Symbol === "function" && typeof Symbol.for === "function") {
      gracefulQueue = Symbol.for("graceful-fs.queue");
      previousSymbol = Symbol.for("graceful-fs.previous");
    } else {
      gracefulQueue = "___graceful-fs.queue";
      previousSymbol = "___graceful-fs.previous";
    }
    function noop() {
    }
    __name(noop, "noop");
    function publishQueue(context, queue2) {
      Object.defineProperty(context, gracefulQueue, {
        get: function() {
          return queue2;
        }
      });
    }
    __name(publishQueue, "publishQueue");
    var debug9 = noop;
    if (util2.debuglog)
      debug9 = util2.debuglog("gfs4");
    else if (/\bgfs4\b/i.test(process.env.NODE_DEBUG || ""))
      debug9 = /* @__PURE__ */ __name(function() {
        var m = util2.format.apply(util2, arguments);
        m = "GFS4: " + m.split(/\n/).join("\nGFS4: ");
        console.error(m);
      }, "debug");
    if (!fs11[gracefulQueue]) {
      queue = global[gracefulQueue] || [];
      publishQueue(fs11, queue);
      fs11.close = function(fs$close) {
        function close(fd, cb) {
          return fs$close.call(fs11, fd, function(err) {
            if (!err) {
              resetQueue();
            }
            if (typeof cb === "function")
              cb.apply(this, arguments);
          });
        }
        __name(close, "close");
        Object.defineProperty(close, previousSymbol, {
          value: fs$close
        });
        return close;
      }(fs11.close);
      fs11.closeSync = function(fs$closeSync) {
        function closeSync(fd) {
          fs$closeSync.apply(fs11, arguments);
          resetQueue();
        }
        __name(closeSync, "closeSync");
        Object.defineProperty(closeSync, previousSymbol, {
          value: fs$closeSync
        });
        return closeSync;
      }(fs11.closeSync);
      if (/\bgfs4\b/i.test(process.env.NODE_DEBUG || "")) {
        process.on("exit", function() {
          debug9(fs11[gracefulQueue]);
          require("assert").equal(fs11[gracefulQueue].length, 0);
        });
      }
    }
    var queue;
    if (!global[gracefulQueue]) {
      publishQueue(global, fs11[gracefulQueue]);
    }
    module2.exports = patch(clone2(fs11));
    if (process.env.TEST_GRACEFUL_FS_GLOBAL_PATCH && !fs11.__patched) {
      module2.exports = patch(fs11);
      fs11.__patched = true;
    }
    function patch(fs12) {
      polyfills(fs12);
      fs12.gracefulify = patch;
      fs12.createReadStream = createReadStream;
      fs12.createWriteStream = createWriteStream;
      var fs$readFile = fs12.readFile;
      fs12.readFile = readFile5;
      function readFile5(path9, options2, cb) {
        if (typeof options2 === "function")
          cb = options2, options2 = null;
        return go$readFile(path9, options2, cb);
        function go$readFile(path10, options3, cb2, startTime) {
          return fs$readFile(path10, options3, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$readFile, [path10, options3, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
        __name(go$readFile, "go$readFile");
      }
      __name(readFile5, "readFile");
      var fs$writeFile = fs12.writeFile;
      fs12.writeFile = writeFile3;
      function writeFile3(path9, data, options2, cb) {
        if (typeof options2 === "function")
          cb = options2, options2 = null;
        return go$writeFile(path9, data, options2, cb);
        function go$writeFile(path10, data2, options3, cb2, startTime) {
          return fs$writeFile(path10, data2, options3, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$writeFile, [path10, data2, options3, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
        __name(go$writeFile, "go$writeFile");
      }
      __name(writeFile3, "writeFile");
      var fs$appendFile = fs12.appendFile;
      if (fs$appendFile)
        fs12.appendFile = appendFile;
      function appendFile(path9, data, options2, cb) {
        if (typeof options2 === "function")
          cb = options2, options2 = null;
        return go$appendFile(path9, data, options2, cb);
        function go$appendFile(path10, data2, options3, cb2, startTime) {
          return fs$appendFile(path10, data2, options3, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$appendFile, [path10, data2, options3, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
        __name(go$appendFile, "go$appendFile");
      }
      __name(appendFile, "appendFile");
      var fs$copyFile = fs12.copyFile;
      if (fs$copyFile)
        fs12.copyFile = copyFile2;
      function copyFile2(src, dest, flags, cb) {
        if (typeof flags === "function") {
          cb = flags;
          flags = 0;
        }
        return go$copyFile(src, dest, flags, cb);
        function go$copyFile(src2, dest2, flags2, cb2, startTime) {
          return fs$copyFile(src2, dest2, flags2, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$copyFile, [src2, dest2, flags2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
        __name(go$copyFile, "go$copyFile");
      }
      __name(copyFile2, "copyFile");
      var fs$readdir = fs12.readdir;
      fs12.readdir = readdir;
      var noReaddirOptionVersions = /^v[0-5]\./;
      function readdir(path9, options2, cb) {
        if (typeof options2 === "function")
          cb = options2, options2 = null;
        var go$readdir = noReaddirOptionVersions.test(process.version) ? /* @__PURE__ */ __name(function go$readdir2(path10, options3, cb2, startTime) {
          return fs$readdir(path10, fs$readdirCallback(
            path10,
            options3,
            cb2,
            startTime
          ));
        }, "go$readdir") : /* @__PURE__ */ __name(function go$readdir2(path10, options3, cb2, startTime) {
          return fs$readdir(path10, options3, fs$readdirCallback(
            path10,
            options3,
            cb2,
            startTime
          ));
        }, "go$readdir");
        return go$readdir(path9, options2, cb);
        function fs$readdirCallback(path10, options3, cb2, startTime) {
          return function(err, files) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([
                go$readdir,
                [path10, options3, cb2],
                err,
                startTime || Date.now(),
                Date.now()
              ]);
            else {
              if (files && files.sort)
                files.sort();
              if (typeof cb2 === "function")
                cb2.call(this, err, files);
            }
          };
        }
        __name(fs$readdirCallback, "fs$readdirCallback");
      }
      __name(readdir, "readdir");
      if (process.version.substr(0, 4) === "v0.8") {
        var legStreams = legacy(fs12);
        ReadStream = legStreams.ReadStream;
        WriteStream = legStreams.WriteStream;
      }
      var fs$ReadStream = fs12.ReadStream;
      if (fs$ReadStream) {
        ReadStream.prototype = Object.create(fs$ReadStream.prototype);
        ReadStream.prototype.open = ReadStream$open;
      }
      var fs$WriteStream = fs12.WriteStream;
      if (fs$WriteStream) {
        WriteStream.prototype = Object.create(fs$WriteStream.prototype);
        WriteStream.prototype.open = WriteStream$open;
      }
      Object.defineProperty(fs12, "ReadStream", {
        get: function() {
          return ReadStream;
        },
        set: function(val) {
          ReadStream = val;
        },
        enumerable: true,
        configurable: true
      });
      Object.defineProperty(fs12, "WriteStream", {
        get: function() {
          return WriteStream;
        },
        set: function(val) {
          WriteStream = val;
        },
        enumerable: true,
        configurable: true
      });
      var FileReadStream = ReadStream;
      Object.defineProperty(fs12, "FileReadStream", {
        get: function() {
          return FileReadStream;
        },
        set: function(val) {
          FileReadStream = val;
        },
        enumerable: true,
        configurable: true
      });
      var FileWriteStream = WriteStream;
      Object.defineProperty(fs12, "FileWriteStream", {
        get: function() {
          return FileWriteStream;
        },
        set: function(val) {
          FileWriteStream = val;
        },
        enumerable: true,
        configurable: true
      });
      function ReadStream(path9, options2) {
        if (this instanceof ReadStream)
          return fs$ReadStream.apply(this, arguments), this;
        else
          return ReadStream.apply(Object.create(ReadStream.prototype), arguments);
      }
      __name(ReadStream, "ReadStream");
      function ReadStream$open() {
        var that = this;
        open(that.path, that.flags, that.mode, function(err, fd) {
          if (err) {
            if (that.autoClose)
              that.destroy();
            that.emit("error", err);
          } else {
            that.fd = fd;
            that.emit("open", fd);
            that.read();
          }
        });
      }
      __name(ReadStream$open, "ReadStream$open");
      function WriteStream(path9, options2) {
        if (this instanceof WriteStream)
          return fs$WriteStream.apply(this, arguments), this;
        else
          return WriteStream.apply(Object.create(WriteStream.prototype), arguments);
      }
      __name(WriteStream, "WriteStream");
      function WriteStream$open() {
        var that = this;
        open(that.path, that.flags, that.mode, function(err, fd) {
          if (err) {
            that.destroy();
            that.emit("error", err);
          } else {
            that.fd = fd;
            that.emit("open", fd);
          }
        });
      }
      __name(WriteStream$open, "WriteStream$open");
      function createReadStream(path9, options2) {
        return new fs12.ReadStream(path9, options2);
      }
      __name(createReadStream, "createReadStream");
      function createWriteStream(path9, options2) {
        return new fs12.WriteStream(path9, options2);
      }
      __name(createWriteStream, "createWriteStream");
      var fs$open = fs12.open;
      fs12.open = open;
      function open(path9, flags, mode, cb) {
        if (typeof mode === "function")
          cb = mode, mode = null;
        return go$open(path9, flags, mode, cb);
        function go$open(path10, flags2, mode2, cb2, startTime) {
          return fs$open(path10, flags2, mode2, function(err, fd) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$open, [path10, flags2, mode2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
        __name(go$open, "go$open");
      }
      __name(open, "open");
      return fs12;
    }
    __name(patch, "patch");
    function enqueue(elem) {
      debug9("ENQUEUE", elem[0].name, elem[1]);
      fs11[gracefulQueue].push(elem);
      retry();
    }
    __name(enqueue, "enqueue");
    var retryTimer;
    function resetQueue() {
      var now = Date.now();
      for (var i = 0; i < fs11[gracefulQueue].length; ++i) {
        if (fs11[gracefulQueue][i].length > 2) {
          fs11[gracefulQueue][i][3] = now;
          fs11[gracefulQueue][i][4] = now;
        }
      }
      retry();
    }
    __name(resetQueue, "resetQueue");
    function retry() {
      clearTimeout(retryTimer);
      retryTimer = void 0;
      if (fs11[gracefulQueue].length === 0)
        return;
      var elem = fs11[gracefulQueue].shift();
      var fn = elem[0];
      var args = elem[1];
      var err = elem[2];
      var startTime = elem[3];
      var lastTime = elem[4];
      if (startTime === void 0) {
        debug9("RETRY", fn.name, args);
        fn.apply(null, args);
      } else if (Date.now() - startTime >= 6e4) {
        debug9("TIMEOUT", fn.name, args);
        var cb = args.pop();
        if (typeof cb === "function")
          cb.call(null, err);
      } else {
        var sinceAttempt = Date.now() - lastTime;
        var sinceStart = Math.max(lastTime - startTime, 1);
        var desiredDelay = Math.min(sinceStart * 1.2, 100);
        if (sinceAttempt >= desiredDelay) {
          debug9("RETRY", fn.name, args);
          fn.apply(null, args.concat([startTime]));
        } else {
          fs11[gracefulQueue].push(elem);
        }
      }
      if (retryTimer === void 0) {
        retryTimer = setTimeout(retry, 0);
      }
    }
    __name(retry, "retry");
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/fs/index.js
var require_fs = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/fs/index.js"(exports) {
    "use strict";
    var u2 = require_universalify().fromCallback;
    var fs11 = require_graceful_fs();
    var api = [
      "access",
      "appendFile",
      "chmod",
      "chown",
      "close",
      "copyFile",
      "fchmod",
      "fchown",
      "fdatasync",
      "fstat",
      "fsync",
      "ftruncate",
      "futimes",
      "lchmod",
      "lchown",
      "link",
      "lstat",
      "mkdir",
      "mkdtemp",
      "open",
      "opendir",
      "readdir",
      "readFile",
      "readlink",
      "realpath",
      "rename",
      "rm",
      "rmdir",
      "stat",
      "symlink",
      "truncate",
      "unlink",
      "utimes",
      "writeFile"
    ].filter((key) => {
      return typeof fs11[key] === "function";
    });
    Object.assign(exports, fs11);
    api.forEach((method2) => {
      exports[method2] = u2(fs11[method2]);
    });
    exports.exists = function(filename, callback) {
      if (typeof callback === "function") {
        return fs11.exists(filename, callback);
      }
      return new Promise((resolve) => {
        return fs11.exists(filename, resolve);
      });
    };
    exports.read = function(fd, buffer, offset, length, position, callback) {
      if (typeof callback === "function") {
        return fs11.read(fd, buffer, offset, length, position, callback);
      }
      return new Promise((resolve, reject) => {
        fs11.read(fd, buffer, offset, length, position, (err, bytesRead, buffer2) => {
          if (err)
            return reject(err);
          resolve({ bytesRead, buffer: buffer2 });
        });
      });
    };
    exports.write = function(fd, buffer, ...args) {
      if (typeof args[args.length - 1] === "function") {
        return fs11.write(fd, buffer, ...args);
      }
      return new Promise((resolve, reject) => {
        fs11.write(fd, buffer, ...args, (err, bytesWritten, buffer2) => {
          if (err)
            return reject(err);
          resolve({ bytesWritten, buffer: buffer2 });
        });
      });
    };
    exports.readv = function(fd, buffers, ...args) {
      if (typeof args[args.length - 1] === "function") {
        return fs11.readv(fd, buffers, ...args);
      }
      return new Promise((resolve, reject) => {
        fs11.readv(fd, buffers, ...args, (err, bytesRead, buffers2) => {
          if (err)
            return reject(err);
          resolve({ bytesRead, buffers: buffers2 });
        });
      });
    };
    exports.writev = function(fd, buffers, ...args) {
      if (typeof args[args.length - 1] === "function") {
        return fs11.writev(fd, buffers, ...args);
      }
      return new Promise((resolve, reject) => {
        fs11.writev(fd, buffers, ...args, (err, bytesWritten, buffers2) => {
          if (err)
            return reject(err);
          resolve({ bytesWritten, buffers: buffers2 });
        });
      });
    };
    if (typeof fs11.realpath.native === "function") {
      exports.realpath.native = u2(fs11.realpath.native);
    } else {
      process.emitWarning(
        "fs.realpath.native is not a function. Is fs being monkey-patched?",
        "Warning",
        "fs-extra-WARN0003"
      );
    }
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/mkdirs/utils.js
var require_utils = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/mkdirs/utils.js"(exports, module2) {
    "use strict";
    var path9 = require("path");
    module2.exports.checkPath = /* @__PURE__ */ __name(function checkPath(pth) {
      if (process.platform === "win32") {
        const pathHasInvalidWinCharacters = /[<>:"|?*]/.test(pth.replace(path9.parse(pth).root, ""));
        if (pathHasInvalidWinCharacters) {
          const error = new Error(`Path contains invalid characters: ${pth}`);
          error.code = "EINVAL";
          throw error;
        }
      }
    }, "checkPath");
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/mkdirs/make-dir.js
var require_make_dir = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/mkdirs/make-dir.js"(exports, module2) {
    "use strict";
    var fs11 = require_fs();
    var { checkPath } = require_utils();
    var getMode = /* @__PURE__ */ __name((options2) => {
      const defaults = { mode: 511 };
      if (typeof options2 === "number")
        return options2;
      return { ...defaults, ...options2 }.mode;
    }, "getMode");
    module2.exports.makeDir = async (dir2, options2) => {
      checkPath(dir2);
      return fs11.mkdir(dir2, {
        mode: getMode(options2),
        recursive: true
      });
    };
    module2.exports.makeDirSync = (dir2, options2) => {
      checkPath(dir2);
      return fs11.mkdirSync(dir2, {
        mode: getMode(options2),
        recursive: true
      });
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/mkdirs/index.js
var require_mkdirs = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/mkdirs/index.js"(exports, module2) {
    "use strict";
    var u2 = require_universalify().fromPromise;
    var { makeDir: _makeDir, makeDirSync } = require_make_dir();
    var makeDir = u2(_makeDir);
    module2.exports = {
      mkdirs: makeDir,
      mkdirsSync: makeDirSync,
      mkdirp: makeDir,
      mkdirpSync: makeDirSync,
      ensureDir: makeDir,
      ensureDirSync: makeDirSync
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/path-exists/index.js
var require_path_exists2 = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/path-exists/index.js"(exports, module2) {
    "use strict";
    var u2 = require_universalify().fromPromise;
    var fs11 = require_fs();
    function pathExists(path9) {
      return fs11.access(path9).then(() => true).catch(() => false);
    }
    __name(pathExists, "pathExists");
    module2.exports = {
      pathExists: u2(pathExists),
      pathExistsSync: fs11.existsSync
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/util/utimes.js
var require_utimes = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/util/utimes.js"(exports, module2) {
    "use strict";
    var fs11 = require_graceful_fs();
    function utimesMillis(path9, atime, mtime, callback) {
      fs11.open(path9, "r+", (err, fd) => {
        if (err)
          return callback(err);
        fs11.futimes(fd, atime, mtime, (futimesErr) => {
          fs11.close(fd, (closeErr) => {
            if (callback)
              callback(futimesErr || closeErr);
          });
        });
      });
    }
    __name(utimesMillis, "utimesMillis");
    function utimesMillisSync(path9, atime, mtime) {
      const fd = fs11.openSync(path9, "r+");
      fs11.futimesSync(fd, atime, mtime);
      return fs11.closeSync(fd);
    }
    __name(utimesMillisSync, "utimesMillisSync");
    module2.exports = {
      utimesMillis,
      utimesMillisSync
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/util/stat.js
var require_stat = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/util/stat.js"(exports, module2) {
    "use strict";
    var fs11 = require_fs();
    var path9 = require("path");
    var util2 = require("util");
    function getStats(src, dest, opts) {
      const statFunc = opts.dereference ? (file2) => fs11.stat(file2, { bigint: true }) : (file2) => fs11.lstat(file2, { bigint: true });
      return Promise.all([
        statFunc(src),
        statFunc(dest).catch((err) => {
          if (err.code === "ENOENT")
            return null;
          throw err;
        })
      ]).then(([srcStat, destStat]) => ({ srcStat, destStat }));
    }
    __name(getStats, "getStats");
    function getStatsSync(src, dest, opts) {
      let destStat;
      const statFunc = opts.dereference ? (file2) => fs11.statSync(file2, { bigint: true }) : (file2) => fs11.lstatSync(file2, { bigint: true });
      const srcStat = statFunc(src);
      try {
        destStat = statFunc(dest);
      } catch (err) {
        if (err.code === "ENOENT")
          return { srcStat, destStat: null };
        throw err;
      }
      return { srcStat, destStat };
    }
    __name(getStatsSync, "getStatsSync");
    function checkPaths(src, dest, funcName, opts, cb) {
      util2.callbackify(getStats)(src, dest, opts, (err, stats) => {
        if (err)
          return cb(err);
        const { srcStat, destStat } = stats;
        if (destStat) {
          if (areIdentical(srcStat, destStat)) {
            const srcBaseName = path9.basename(src);
            const destBaseName = path9.basename(dest);
            if (funcName === "move" && srcBaseName !== destBaseName && srcBaseName.toLowerCase() === destBaseName.toLowerCase()) {
              return cb(null, { srcStat, destStat, isChangingCase: true });
            }
            return cb(new Error("Source and destination must not be the same."));
          }
          if (srcStat.isDirectory() && !destStat.isDirectory()) {
            return cb(new Error(`Cannot overwrite non-directory '${dest}' with directory '${src}'.`));
          }
          if (!srcStat.isDirectory() && destStat.isDirectory()) {
            return cb(new Error(`Cannot overwrite directory '${dest}' with non-directory '${src}'.`));
          }
        }
        if (srcStat.isDirectory() && isSrcSubdir(src, dest)) {
          return cb(new Error(errMsg(src, dest, funcName)));
        }
        return cb(null, { srcStat, destStat });
      });
    }
    __name(checkPaths, "checkPaths");
    function checkPathsSync(src, dest, funcName, opts) {
      const { srcStat, destStat } = getStatsSync(src, dest, opts);
      if (destStat) {
        if (areIdentical(srcStat, destStat)) {
          const srcBaseName = path9.basename(src);
          const destBaseName = path9.basename(dest);
          if (funcName === "move" && srcBaseName !== destBaseName && srcBaseName.toLowerCase() === destBaseName.toLowerCase()) {
            return { srcStat, destStat, isChangingCase: true };
          }
          throw new Error("Source and destination must not be the same.");
        }
        if (srcStat.isDirectory() && !destStat.isDirectory()) {
          throw new Error(`Cannot overwrite non-directory '${dest}' with directory '${src}'.`);
        }
        if (!srcStat.isDirectory() && destStat.isDirectory()) {
          throw new Error(`Cannot overwrite directory '${dest}' with non-directory '${src}'.`);
        }
      }
      if (srcStat.isDirectory() && isSrcSubdir(src, dest)) {
        throw new Error(errMsg(src, dest, funcName));
      }
      return { srcStat, destStat };
    }
    __name(checkPathsSync, "checkPathsSync");
    function checkParentPaths(src, srcStat, dest, funcName, cb) {
      const srcParent = path9.resolve(path9.dirname(src));
      const destParent = path9.resolve(path9.dirname(dest));
      if (destParent === srcParent || destParent === path9.parse(destParent).root)
        return cb();
      fs11.stat(destParent, { bigint: true }, (err, destStat) => {
        if (err) {
          if (err.code === "ENOENT")
            return cb();
          return cb(err);
        }
        if (areIdentical(srcStat, destStat)) {
          return cb(new Error(errMsg(src, dest, funcName)));
        }
        return checkParentPaths(src, srcStat, destParent, funcName, cb);
      });
    }
    __name(checkParentPaths, "checkParentPaths");
    function checkParentPathsSync(src, srcStat, dest, funcName) {
      const srcParent = path9.resolve(path9.dirname(src));
      const destParent = path9.resolve(path9.dirname(dest));
      if (destParent === srcParent || destParent === path9.parse(destParent).root)
        return;
      let destStat;
      try {
        destStat = fs11.statSync(destParent, { bigint: true });
      } catch (err) {
        if (err.code === "ENOENT")
          return;
        throw err;
      }
      if (areIdentical(srcStat, destStat)) {
        throw new Error(errMsg(src, dest, funcName));
      }
      return checkParentPathsSync(src, srcStat, destParent, funcName);
    }
    __name(checkParentPathsSync, "checkParentPathsSync");
    function areIdentical(srcStat, destStat) {
      return destStat.ino && destStat.dev && destStat.ino === srcStat.ino && destStat.dev === srcStat.dev;
    }
    __name(areIdentical, "areIdentical");
    function isSrcSubdir(src, dest) {
      const srcArr = path9.resolve(src).split(path9.sep).filter((i) => i);
      const destArr = path9.resolve(dest).split(path9.sep).filter((i) => i);
      return srcArr.reduce((acc, cur, i) => acc && destArr[i] === cur, true);
    }
    __name(isSrcSubdir, "isSrcSubdir");
    function errMsg(src, dest, funcName) {
      return `Cannot ${funcName} '${src}' to a subdirectory of itself, '${dest}'.`;
    }
    __name(errMsg, "errMsg");
    module2.exports = {
      checkPaths,
      checkPathsSync,
      checkParentPaths,
      checkParentPathsSync,
      isSrcSubdir,
      areIdentical
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/copy/copy.js
var require_copy = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/copy/copy.js"(exports, module2) {
    "use strict";
    var fs11 = require_graceful_fs();
    var path9 = require("path");
    var mkdirs = require_mkdirs().mkdirs;
    var pathExists = require_path_exists2().pathExists;
    var utimesMillis = require_utimes().utimesMillis;
    var stat2 = require_stat();
    function copy(src, dest, opts, cb) {
      if (typeof opts === "function" && !cb) {
        cb = opts;
        opts = {};
      } else if (typeof opts === "function") {
        opts = { filter: opts };
      }
      cb = cb || function() {
      };
      opts = opts || {};
      opts.clobber = "clobber" in opts ? !!opts.clobber : true;
      opts.overwrite = "overwrite" in opts ? !!opts.overwrite : opts.clobber;
      if (opts.preserveTimestamps && process.arch === "ia32") {
        process.emitWarning(
          "Using the preserveTimestamps option in 32-bit node is not recommended;\n\n	see https://github.com/jprichardson/node-fs-extra/issues/269",
          "Warning",
          "fs-extra-WARN0001"
        );
      }
      stat2.checkPaths(src, dest, "copy", opts, (err, stats) => {
        if (err)
          return cb(err);
        const { srcStat, destStat } = stats;
        stat2.checkParentPaths(src, srcStat, dest, "copy", (err2) => {
          if (err2)
            return cb(err2);
          runFilter(src, dest, opts, (err3, include) => {
            if (err3)
              return cb(err3);
            if (!include)
              return cb();
            checkParentDir(destStat, src, dest, opts, cb);
          });
        });
      });
    }
    __name(copy, "copy");
    function checkParentDir(destStat, src, dest, opts, cb) {
      const destParent = path9.dirname(dest);
      pathExists(destParent, (err, dirExists) => {
        if (err)
          return cb(err);
        if (dirExists)
          return getStats(destStat, src, dest, opts, cb);
        mkdirs(destParent, (err2) => {
          if (err2)
            return cb(err2);
          return getStats(destStat, src, dest, opts, cb);
        });
      });
    }
    __name(checkParentDir, "checkParentDir");
    function runFilter(src, dest, opts, cb) {
      if (!opts.filter)
        return cb(null, true);
      Promise.resolve(opts.filter(src, dest)).then((include) => cb(null, include), (error) => cb(error));
    }
    __name(runFilter, "runFilter");
    function getStats(destStat, src, dest, opts, cb) {
      const stat3 = opts.dereference ? fs11.stat : fs11.lstat;
      stat3(src, (err, srcStat) => {
        if (err)
          return cb(err);
        if (srcStat.isDirectory())
          return onDir(srcStat, destStat, src, dest, opts, cb);
        else if (srcStat.isFile() || srcStat.isCharacterDevice() || srcStat.isBlockDevice())
          return onFile(srcStat, destStat, src, dest, opts, cb);
        else if (srcStat.isSymbolicLink())
          return onLink(destStat, src, dest, opts, cb);
        else if (srcStat.isSocket())
          return cb(new Error(`Cannot copy a socket file: ${src}`));
        else if (srcStat.isFIFO())
          return cb(new Error(`Cannot copy a FIFO pipe: ${src}`));
        return cb(new Error(`Unknown file: ${src}`));
      });
    }
    __name(getStats, "getStats");
    function onFile(srcStat, destStat, src, dest, opts, cb) {
      if (!destStat)
        return copyFile2(srcStat, src, dest, opts, cb);
      return mayCopyFile(srcStat, src, dest, opts, cb);
    }
    __name(onFile, "onFile");
    function mayCopyFile(srcStat, src, dest, opts, cb) {
      if (opts.overwrite) {
        fs11.unlink(dest, (err) => {
          if (err)
            return cb(err);
          return copyFile2(srcStat, src, dest, opts, cb);
        });
      } else if (opts.errorOnExist) {
        return cb(new Error(`'${dest}' already exists`));
      } else
        return cb();
    }
    __name(mayCopyFile, "mayCopyFile");
    function copyFile2(srcStat, src, dest, opts, cb) {
      fs11.copyFile(src, dest, (err) => {
        if (err)
          return cb(err);
        if (opts.preserveTimestamps)
          return handleTimestampsAndMode(srcStat.mode, src, dest, cb);
        return setDestMode(dest, srcStat.mode, cb);
      });
    }
    __name(copyFile2, "copyFile");
    function handleTimestampsAndMode(srcMode, src, dest, cb) {
      if (fileIsNotWritable(srcMode)) {
        return makeFileWritable(dest, srcMode, (err) => {
          if (err)
            return cb(err);
          return setDestTimestampsAndMode(srcMode, src, dest, cb);
        });
      }
      return setDestTimestampsAndMode(srcMode, src, dest, cb);
    }
    __name(handleTimestampsAndMode, "handleTimestampsAndMode");
    function fileIsNotWritable(srcMode) {
      return (srcMode & 128) === 0;
    }
    __name(fileIsNotWritable, "fileIsNotWritable");
    function makeFileWritable(dest, srcMode, cb) {
      return setDestMode(dest, srcMode | 128, cb);
    }
    __name(makeFileWritable, "makeFileWritable");
    function setDestTimestampsAndMode(srcMode, src, dest, cb) {
      setDestTimestamps(src, dest, (err) => {
        if (err)
          return cb(err);
        return setDestMode(dest, srcMode, cb);
      });
    }
    __name(setDestTimestampsAndMode, "setDestTimestampsAndMode");
    function setDestMode(dest, srcMode, cb) {
      return fs11.chmod(dest, srcMode, cb);
    }
    __name(setDestMode, "setDestMode");
    function setDestTimestamps(src, dest, cb) {
      fs11.stat(src, (err, updatedSrcStat) => {
        if (err)
          return cb(err);
        return utimesMillis(dest, updatedSrcStat.atime, updatedSrcStat.mtime, cb);
      });
    }
    __name(setDestTimestamps, "setDestTimestamps");
    function onDir(srcStat, destStat, src, dest, opts, cb) {
      if (!destStat)
        return mkDirAndCopy(srcStat.mode, src, dest, opts, cb);
      return copyDir(src, dest, opts, cb);
    }
    __name(onDir, "onDir");
    function mkDirAndCopy(srcMode, src, dest, opts, cb) {
      fs11.mkdir(dest, (err) => {
        if (err)
          return cb(err);
        copyDir(src, dest, opts, (err2) => {
          if (err2)
            return cb(err2);
          return setDestMode(dest, srcMode, cb);
        });
      });
    }
    __name(mkDirAndCopy, "mkDirAndCopy");
    function copyDir(src, dest, opts, cb) {
      fs11.readdir(src, (err, items) => {
        if (err)
          return cb(err);
        return copyDirItems(items, src, dest, opts, cb);
      });
    }
    __name(copyDir, "copyDir");
    function copyDirItems(items, src, dest, opts, cb) {
      const item = items.pop();
      if (!item)
        return cb();
      return copyDirItem(items, item, src, dest, opts, cb);
    }
    __name(copyDirItems, "copyDirItems");
    function copyDirItem(items, item, src, dest, opts, cb) {
      const srcItem = path9.join(src, item);
      const destItem = path9.join(dest, item);
      runFilter(srcItem, destItem, opts, (err, include) => {
        if (err)
          return cb(err);
        if (!include)
          return copyDirItems(items, src, dest, opts, cb);
        stat2.checkPaths(srcItem, destItem, "copy", opts, (err2, stats) => {
          if (err2)
            return cb(err2);
          const { destStat } = stats;
          getStats(destStat, srcItem, destItem, opts, (err3) => {
            if (err3)
              return cb(err3);
            return copyDirItems(items, src, dest, opts, cb);
          });
        });
      });
    }
    __name(copyDirItem, "copyDirItem");
    function onLink(destStat, src, dest, opts, cb) {
      fs11.readlink(src, (err, resolvedSrc) => {
        if (err)
          return cb(err);
        if (opts.dereference) {
          resolvedSrc = path9.resolve(process.cwd(), resolvedSrc);
        }
        if (!destStat) {
          return fs11.symlink(resolvedSrc, dest, cb);
        } else {
          fs11.readlink(dest, (err2, resolvedDest) => {
            if (err2) {
              if (err2.code === "EINVAL" || err2.code === "UNKNOWN")
                return fs11.symlink(resolvedSrc, dest, cb);
              return cb(err2);
            }
            if (opts.dereference) {
              resolvedDest = path9.resolve(process.cwd(), resolvedDest);
            }
            if (stat2.isSrcSubdir(resolvedSrc, resolvedDest)) {
              return cb(new Error(`Cannot copy '${resolvedSrc}' to a subdirectory of itself, '${resolvedDest}'.`));
            }
            if (stat2.isSrcSubdir(resolvedDest, resolvedSrc)) {
              return cb(new Error(`Cannot overwrite '${resolvedDest}' with '${resolvedSrc}'.`));
            }
            return copyLink(resolvedSrc, dest, cb);
          });
        }
      });
    }
    __name(onLink, "onLink");
    function copyLink(resolvedSrc, dest, cb) {
      fs11.unlink(dest, (err) => {
        if (err)
          return cb(err);
        return fs11.symlink(resolvedSrc, dest, cb);
      });
    }
    __name(copyLink, "copyLink");
    module2.exports = copy;
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/copy/copy-sync.js
var require_copy_sync = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/copy/copy-sync.js"(exports, module2) {
    "use strict";
    var fs11 = require_graceful_fs();
    var path9 = require("path");
    var mkdirsSync = require_mkdirs().mkdirsSync;
    var utimesMillisSync = require_utimes().utimesMillisSync;
    var stat2 = require_stat();
    function copySync(src, dest, opts) {
      if (typeof opts === "function") {
        opts = { filter: opts };
      }
      opts = opts || {};
      opts.clobber = "clobber" in opts ? !!opts.clobber : true;
      opts.overwrite = "overwrite" in opts ? !!opts.overwrite : opts.clobber;
      if (opts.preserveTimestamps && process.arch === "ia32") {
        process.emitWarning(
          "Using the preserveTimestamps option in 32-bit node is not recommended;\n\n	see https://github.com/jprichardson/node-fs-extra/issues/269",
          "Warning",
          "fs-extra-WARN0002"
        );
      }
      const { srcStat, destStat } = stat2.checkPathsSync(src, dest, "copy", opts);
      stat2.checkParentPathsSync(src, srcStat, dest, "copy");
      if (opts.filter && !opts.filter(src, dest))
        return;
      const destParent = path9.dirname(dest);
      if (!fs11.existsSync(destParent))
        mkdirsSync(destParent);
      return getStats(destStat, src, dest, opts);
    }
    __name(copySync, "copySync");
    function getStats(destStat, src, dest, opts) {
      const statSync = opts.dereference ? fs11.statSync : fs11.lstatSync;
      const srcStat = statSync(src);
      if (srcStat.isDirectory())
        return onDir(srcStat, destStat, src, dest, opts);
      else if (srcStat.isFile() || srcStat.isCharacterDevice() || srcStat.isBlockDevice())
        return onFile(srcStat, destStat, src, dest, opts);
      else if (srcStat.isSymbolicLink())
        return onLink(destStat, src, dest, opts);
      else if (srcStat.isSocket())
        throw new Error(`Cannot copy a socket file: ${src}`);
      else if (srcStat.isFIFO())
        throw new Error(`Cannot copy a FIFO pipe: ${src}`);
      throw new Error(`Unknown file: ${src}`);
    }
    __name(getStats, "getStats");
    function onFile(srcStat, destStat, src, dest, opts) {
      if (!destStat)
        return copyFile2(srcStat, src, dest, opts);
      return mayCopyFile(srcStat, src, dest, opts);
    }
    __name(onFile, "onFile");
    function mayCopyFile(srcStat, src, dest, opts) {
      if (opts.overwrite) {
        fs11.unlinkSync(dest);
        return copyFile2(srcStat, src, dest, opts);
      } else if (opts.errorOnExist) {
        throw new Error(`'${dest}' already exists`);
      }
    }
    __name(mayCopyFile, "mayCopyFile");
    function copyFile2(srcStat, src, dest, opts) {
      fs11.copyFileSync(src, dest);
      if (opts.preserveTimestamps)
        handleTimestamps(srcStat.mode, src, dest);
      return setDestMode(dest, srcStat.mode);
    }
    __name(copyFile2, "copyFile");
    function handleTimestamps(srcMode, src, dest) {
      if (fileIsNotWritable(srcMode))
        makeFileWritable(dest, srcMode);
      return setDestTimestamps(src, dest);
    }
    __name(handleTimestamps, "handleTimestamps");
    function fileIsNotWritable(srcMode) {
      return (srcMode & 128) === 0;
    }
    __name(fileIsNotWritable, "fileIsNotWritable");
    function makeFileWritable(dest, srcMode) {
      return setDestMode(dest, srcMode | 128);
    }
    __name(makeFileWritable, "makeFileWritable");
    function setDestMode(dest, srcMode) {
      return fs11.chmodSync(dest, srcMode);
    }
    __name(setDestMode, "setDestMode");
    function setDestTimestamps(src, dest) {
      const updatedSrcStat = fs11.statSync(src);
      return utimesMillisSync(dest, updatedSrcStat.atime, updatedSrcStat.mtime);
    }
    __name(setDestTimestamps, "setDestTimestamps");
    function onDir(srcStat, destStat, src, dest, opts) {
      if (!destStat)
        return mkDirAndCopy(srcStat.mode, src, dest, opts);
      return copyDir(src, dest, opts);
    }
    __name(onDir, "onDir");
    function mkDirAndCopy(srcMode, src, dest, opts) {
      fs11.mkdirSync(dest);
      copyDir(src, dest, opts);
      return setDestMode(dest, srcMode);
    }
    __name(mkDirAndCopy, "mkDirAndCopy");
    function copyDir(src, dest, opts) {
      fs11.readdirSync(src).forEach((item) => copyDirItem(item, src, dest, opts));
    }
    __name(copyDir, "copyDir");
    function copyDirItem(item, src, dest, opts) {
      const srcItem = path9.join(src, item);
      const destItem = path9.join(dest, item);
      if (opts.filter && !opts.filter(srcItem, destItem))
        return;
      const { destStat } = stat2.checkPathsSync(srcItem, destItem, "copy", opts);
      return getStats(destStat, srcItem, destItem, opts);
    }
    __name(copyDirItem, "copyDirItem");
    function onLink(destStat, src, dest, opts) {
      let resolvedSrc = fs11.readlinkSync(src);
      if (opts.dereference) {
        resolvedSrc = path9.resolve(process.cwd(), resolvedSrc);
      }
      if (!destStat) {
        return fs11.symlinkSync(resolvedSrc, dest);
      } else {
        let resolvedDest;
        try {
          resolvedDest = fs11.readlinkSync(dest);
        } catch (err) {
          if (err.code === "EINVAL" || err.code === "UNKNOWN")
            return fs11.symlinkSync(resolvedSrc, dest);
          throw err;
        }
        if (opts.dereference) {
          resolvedDest = path9.resolve(process.cwd(), resolvedDest);
        }
        if (stat2.isSrcSubdir(resolvedSrc, resolvedDest)) {
          throw new Error(`Cannot copy '${resolvedSrc}' to a subdirectory of itself, '${resolvedDest}'.`);
        }
        if (stat2.isSrcSubdir(resolvedDest, resolvedSrc)) {
          throw new Error(`Cannot overwrite '${resolvedDest}' with '${resolvedSrc}'.`);
        }
        return copyLink(resolvedSrc, dest);
      }
    }
    __name(onLink, "onLink");
    function copyLink(resolvedSrc, dest) {
      fs11.unlinkSync(dest);
      return fs11.symlinkSync(resolvedSrc, dest);
    }
    __name(copyLink, "copyLink");
    module2.exports = copySync;
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/copy/index.js
var require_copy2 = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/copy/index.js"(exports, module2) {
    "use strict";
    var u2 = require_universalify().fromCallback;
    module2.exports = {
      copy: u2(require_copy()),
      copySync: require_copy_sync()
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/remove/index.js
var require_remove = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/remove/index.js"(exports, module2) {
    "use strict";
    var fs11 = require_graceful_fs();
    var u2 = require_universalify().fromCallback;
    function remove2(path9, callback) {
      fs11.rm(path9, { recursive: true, force: true }, callback);
    }
    __name(remove2, "remove");
    function removeSync(path9) {
      fs11.rmSync(path9, { recursive: true, force: true });
    }
    __name(removeSync, "removeSync");
    module2.exports = {
      remove: u2(remove2),
      removeSync
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/empty/index.js
var require_empty = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/empty/index.js"(exports, module2) {
    "use strict";
    var u2 = require_universalify().fromPromise;
    var fs11 = require_fs();
    var path9 = require("path");
    var mkdir = require_mkdirs();
    var remove2 = require_remove();
    var emptyDir = u2(/* @__PURE__ */ __name(async function emptyDir2(dir2) {
      let items;
      try {
        items = await fs11.readdir(dir2);
      } catch {
        return mkdir.mkdirs(dir2);
      }
      return Promise.all(items.map((item) => remove2.remove(path9.join(dir2, item))));
    }, "emptyDir"));
    function emptyDirSync(dir2) {
      let items;
      try {
        items = fs11.readdirSync(dir2);
      } catch {
        return mkdir.mkdirsSync(dir2);
      }
      items.forEach((item) => {
        item = path9.join(dir2, item);
        remove2.removeSync(item);
      });
    }
    __name(emptyDirSync, "emptyDirSync");
    module2.exports = {
      emptyDirSync,
      emptydirSync: emptyDirSync,
      emptyDir,
      emptydir: emptyDir
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/ensure/file.js
var require_file = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/ensure/file.js"(exports, module2) {
    "use strict";
    var u2 = require_universalify().fromCallback;
    var path9 = require("path");
    var fs11 = require_graceful_fs();
    var mkdir = require_mkdirs();
    function createFile(file2, callback) {
      function makeFile() {
        fs11.writeFile(file2, "", (err) => {
          if (err)
            return callback(err);
          callback();
        });
      }
      __name(makeFile, "makeFile");
      fs11.stat(file2, (err, stats) => {
        if (!err && stats.isFile())
          return callback();
        const dir2 = path9.dirname(file2);
        fs11.stat(dir2, (err2, stats2) => {
          if (err2) {
            if (err2.code === "ENOENT") {
              return mkdir.mkdirs(dir2, (err3) => {
                if (err3)
                  return callback(err3);
                makeFile();
              });
            }
            return callback(err2);
          }
          if (stats2.isDirectory())
            makeFile();
          else {
            fs11.readdir(dir2, (err3) => {
              if (err3)
                return callback(err3);
            });
          }
        });
      });
    }
    __name(createFile, "createFile");
    function createFileSync(file2) {
      let stats;
      try {
        stats = fs11.statSync(file2);
      } catch {
      }
      if (stats && stats.isFile())
        return;
      const dir2 = path9.dirname(file2);
      try {
        if (!fs11.statSync(dir2).isDirectory()) {
          fs11.readdirSync(dir2);
        }
      } catch (err) {
        if (err && err.code === "ENOENT")
          mkdir.mkdirsSync(dir2);
        else
          throw err;
      }
      fs11.writeFileSync(file2, "");
    }
    __name(createFileSync, "createFileSync");
    module2.exports = {
      createFile: u2(createFile),
      createFileSync
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/ensure/link.js
var require_link = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/ensure/link.js"(exports, module2) {
    "use strict";
    var u2 = require_universalify().fromCallback;
    var path9 = require("path");
    var fs11 = require_graceful_fs();
    var mkdir = require_mkdirs();
    var pathExists = require_path_exists2().pathExists;
    var { areIdentical } = require_stat();
    function createLink(srcpath, dstpath, callback) {
      function makeLink(srcpath2, dstpath2) {
        fs11.link(srcpath2, dstpath2, (err) => {
          if (err)
            return callback(err);
          callback(null);
        });
      }
      __name(makeLink, "makeLink");
      fs11.lstat(dstpath, (_, dstStat) => {
        fs11.lstat(srcpath, (err, srcStat) => {
          if (err) {
            err.message = err.message.replace("lstat", "ensureLink");
            return callback(err);
          }
          if (dstStat && areIdentical(srcStat, dstStat))
            return callback(null);
          const dir2 = path9.dirname(dstpath);
          pathExists(dir2, (err2, dirExists) => {
            if (err2)
              return callback(err2);
            if (dirExists)
              return makeLink(srcpath, dstpath);
            mkdir.mkdirs(dir2, (err3) => {
              if (err3)
                return callback(err3);
              makeLink(srcpath, dstpath);
            });
          });
        });
      });
    }
    __name(createLink, "createLink");
    function createLinkSync(srcpath, dstpath) {
      let dstStat;
      try {
        dstStat = fs11.lstatSync(dstpath);
      } catch {
      }
      try {
        const srcStat = fs11.lstatSync(srcpath);
        if (dstStat && areIdentical(srcStat, dstStat))
          return;
      } catch (err) {
        err.message = err.message.replace("lstat", "ensureLink");
        throw err;
      }
      const dir2 = path9.dirname(dstpath);
      const dirExists = fs11.existsSync(dir2);
      if (dirExists)
        return fs11.linkSync(srcpath, dstpath);
      mkdir.mkdirsSync(dir2);
      return fs11.linkSync(srcpath, dstpath);
    }
    __name(createLinkSync, "createLinkSync");
    module2.exports = {
      createLink: u2(createLink),
      createLinkSync
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/ensure/symlink-paths.js
var require_symlink_paths = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/ensure/symlink-paths.js"(exports, module2) {
    "use strict";
    var path9 = require("path");
    var fs11 = require_graceful_fs();
    var pathExists = require_path_exists2().pathExists;
    function symlinkPaths(srcpath, dstpath, callback) {
      if (path9.isAbsolute(srcpath)) {
        return fs11.lstat(srcpath, (err) => {
          if (err) {
            err.message = err.message.replace("lstat", "ensureSymlink");
            return callback(err);
          }
          return callback(null, {
            toCwd: srcpath,
            toDst: srcpath
          });
        });
      } else {
        const dstdir = path9.dirname(dstpath);
        const relativeToDst = path9.join(dstdir, srcpath);
        return pathExists(relativeToDst, (err, exists4) => {
          if (err)
            return callback(err);
          if (exists4) {
            return callback(null, {
              toCwd: relativeToDst,
              toDst: srcpath
            });
          } else {
            return fs11.lstat(srcpath, (err2) => {
              if (err2) {
                err2.message = err2.message.replace("lstat", "ensureSymlink");
                return callback(err2);
              }
              return callback(null, {
                toCwd: srcpath,
                toDst: path9.relative(dstdir, srcpath)
              });
            });
          }
        });
      }
    }
    __name(symlinkPaths, "symlinkPaths");
    function symlinkPathsSync(srcpath, dstpath) {
      let exists4;
      if (path9.isAbsolute(srcpath)) {
        exists4 = fs11.existsSync(srcpath);
        if (!exists4)
          throw new Error("absolute srcpath does not exist");
        return {
          toCwd: srcpath,
          toDst: srcpath
        };
      } else {
        const dstdir = path9.dirname(dstpath);
        const relativeToDst = path9.join(dstdir, srcpath);
        exists4 = fs11.existsSync(relativeToDst);
        if (exists4) {
          return {
            toCwd: relativeToDst,
            toDst: srcpath
          };
        } else {
          exists4 = fs11.existsSync(srcpath);
          if (!exists4)
            throw new Error("relative srcpath does not exist");
          return {
            toCwd: srcpath,
            toDst: path9.relative(dstdir, srcpath)
          };
        }
      }
    }
    __name(symlinkPathsSync, "symlinkPathsSync");
    module2.exports = {
      symlinkPaths,
      symlinkPathsSync
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/ensure/symlink-type.js
var require_symlink_type = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/ensure/symlink-type.js"(exports, module2) {
    "use strict";
    var fs11 = require_graceful_fs();
    function symlinkType(srcpath, type, callback) {
      callback = typeof type === "function" ? type : callback;
      type = typeof type === "function" ? false : type;
      if (type)
        return callback(null, type);
      fs11.lstat(srcpath, (err, stats) => {
        if (err)
          return callback(null, "file");
        type = stats && stats.isDirectory() ? "dir" : "file";
        callback(null, type);
      });
    }
    __name(symlinkType, "symlinkType");
    function symlinkTypeSync(srcpath, type) {
      let stats;
      if (type)
        return type;
      try {
        stats = fs11.lstatSync(srcpath);
      } catch {
        return "file";
      }
      return stats && stats.isDirectory() ? "dir" : "file";
    }
    __name(symlinkTypeSync, "symlinkTypeSync");
    module2.exports = {
      symlinkType,
      symlinkTypeSync
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/ensure/symlink.js
var require_symlink = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/ensure/symlink.js"(exports, module2) {
    "use strict";
    var u2 = require_universalify().fromCallback;
    var path9 = require("path");
    var fs11 = require_fs();
    var _mkdirs = require_mkdirs();
    var mkdirs = _mkdirs.mkdirs;
    var mkdirsSync = _mkdirs.mkdirsSync;
    var _symlinkPaths = require_symlink_paths();
    var symlinkPaths = _symlinkPaths.symlinkPaths;
    var symlinkPathsSync = _symlinkPaths.symlinkPathsSync;
    var _symlinkType = require_symlink_type();
    var symlinkType = _symlinkType.symlinkType;
    var symlinkTypeSync = _symlinkType.symlinkTypeSync;
    var pathExists = require_path_exists2().pathExists;
    var { areIdentical } = require_stat();
    function createSymlink(srcpath, dstpath, type, callback) {
      callback = typeof type === "function" ? type : callback;
      type = typeof type === "function" ? false : type;
      fs11.lstat(dstpath, (err, stats) => {
        if (!err && stats.isSymbolicLink()) {
          Promise.all([
            fs11.stat(srcpath),
            fs11.stat(dstpath)
          ]).then(([srcStat, dstStat]) => {
            if (areIdentical(srcStat, dstStat))
              return callback(null);
            _createSymlink(srcpath, dstpath, type, callback);
          });
        } else
          _createSymlink(srcpath, dstpath, type, callback);
      });
    }
    __name(createSymlink, "createSymlink");
    function _createSymlink(srcpath, dstpath, type, callback) {
      symlinkPaths(srcpath, dstpath, (err, relative) => {
        if (err)
          return callback(err);
        srcpath = relative.toDst;
        symlinkType(relative.toCwd, type, (err2, type2) => {
          if (err2)
            return callback(err2);
          const dir2 = path9.dirname(dstpath);
          pathExists(dir2, (err3, dirExists) => {
            if (err3)
              return callback(err3);
            if (dirExists)
              return fs11.symlink(srcpath, dstpath, type2, callback);
            mkdirs(dir2, (err4) => {
              if (err4)
                return callback(err4);
              fs11.symlink(srcpath, dstpath, type2, callback);
            });
          });
        });
      });
    }
    __name(_createSymlink, "_createSymlink");
    function createSymlinkSync(srcpath, dstpath, type) {
      let stats;
      try {
        stats = fs11.lstatSync(dstpath);
      } catch {
      }
      if (stats && stats.isSymbolicLink()) {
        const srcStat = fs11.statSync(srcpath);
        const dstStat = fs11.statSync(dstpath);
        if (areIdentical(srcStat, dstStat))
          return;
      }
      const relative = symlinkPathsSync(srcpath, dstpath);
      srcpath = relative.toDst;
      type = symlinkTypeSync(relative.toCwd, type);
      const dir2 = path9.dirname(dstpath);
      const exists4 = fs11.existsSync(dir2);
      if (exists4)
        return fs11.symlinkSync(srcpath, dstpath, type);
      mkdirsSync(dir2);
      return fs11.symlinkSync(srcpath, dstpath, type);
    }
    __name(createSymlinkSync, "createSymlinkSync");
    module2.exports = {
      createSymlink: u2(createSymlink),
      createSymlinkSync
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/ensure/index.js
var require_ensure = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/ensure/index.js"(exports, module2) {
    "use strict";
    var { createFile, createFileSync } = require_file();
    var { createLink, createLinkSync } = require_link();
    var { createSymlink, createSymlinkSync } = require_symlink();
    module2.exports = {
      createFile,
      createFileSync,
      ensureFile: createFile,
      ensureFileSync: createFileSync,
      createLink,
      createLinkSync,
      ensureLink: createLink,
      ensureLinkSync: createLinkSync,
      createSymlink,
      createSymlinkSync,
      ensureSymlink: createSymlink,
      ensureSymlinkSync: createSymlinkSync
    };
  }
});

// ../../node_modules/.pnpm/jsonfile@6.1.0/node_modules/jsonfile/utils.js
var require_utils2 = __commonJS({
  "../../node_modules/.pnpm/jsonfile@6.1.0/node_modules/jsonfile/utils.js"(exports, module2) {
    function stringify2(obj, { EOL = "\n", finalEOL = true, replacer = null, spaces } = {}) {
      const EOF = finalEOL ? EOL : "";
      const str = JSON.stringify(obj, replacer, spaces);
      return str.replace(/\n/g, EOL) + EOF;
    }
    __name(stringify2, "stringify");
    function stripBom(content) {
      if (Buffer.isBuffer(content))
        content = content.toString("utf8");
      return content.replace(/^\uFEFF/, "");
    }
    __name(stripBom, "stripBom");
    module2.exports = { stringify: stringify2, stripBom };
  }
});

// ../../node_modules/.pnpm/jsonfile@6.1.0/node_modules/jsonfile/index.js
var require_jsonfile = __commonJS({
  "../../node_modules/.pnpm/jsonfile@6.1.0/node_modules/jsonfile/index.js"(exports, module2) {
    var _fs;
    try {
      _fs = require_graceful_fs();
    } catch (_) {
      _fs = require("fs");
    }
    var universalify = require_universalify();
    var { stringify: stringify2, stripBom } = require_utils2();
    async function _readFile(file2, options2 = {}) {
      if (typeof options2 === "string") {
        options2 = { encoding: options2 };
      }
      const fs11 = options2.fs || _fs;
      const shouldThrow = "throws" in options2 ? options2.throws : true;
      let data = await universalify.fromCallback(fs11.readFile)(file2, options2);
      data = stripBom(data);
      let obj;
      try {
        obj = JSON.parse(data, options2 ? options2.reviver : null);
      } catch (err) {
        if (shouldThrow) {
          err.message = `${file2}: ${err.message}`;
          throw err;
        } else {
          return null;
        }
      }
      return obj;
    }
    __name(_readFile, "_readFile");
    var readFile5 = universalify.fromPromise(_readFile);
    function readFileSync(file2, options2 = {}) {
      if (typeof options2 === "string") {
        options2 = { encoding: options2 };
      }
      const fs11 = options2.fs || _fs;
      const shouldThrow = "throws" in options2 ? options2.throws : true;
      try {
        let content = fs11.readFileSync(file2, options2);
        content = stripBom(content);
        return JSON.parse(content, options2.reviver);
      } catch (err) {
        if (shouldThrow) {
          err.message = `${file2}: ${err.message}`;
          throw err;
        } else {
          return null;
        }
      }
    }
    __name(readFileSync, "readFileSync");
    async function _writeFile(file2, obj, options2 = {}) {
      const fs11 = options2.fs || _fs;
      const str = stringify2(obj, options2);
      await universalify.fromCallback(fs11.writeFile)(file2, str, options2);
    }
    __name(_writeFile, "_writeFile");
    var writeFile3 = universalify.fromPromise(_writeFile);
    function writeFileSync(file2, obj, options2 = {}) {
      const fs11 = options2.fs || _fs;
      const str = stringify2(obj, options2);
      return fs11.writeFileSync(file2, str, options2);
    }
    __name(writeFileSync, "writeFileSync");
    var jsonfile = {
      readFile: readFile5,
      readFileSync,
      writeFile: writeFile3,
      writeFileSync
    };
    module2.exports = jsonfile;
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/json/jsonfile.js
var require_jsonfile2 = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/json/jsonfile.js"(exports, module2) {
    "use strict";
    var jsonFile = require_jsonfile();
    module2.exports = {
      readJson: jsonFile.readFile,
      readJsonSync: jsonFile.readFileSync,
      writeJson: jsonFile.writeFile,
      writeJsonSync: jsonFile.writeFileSync
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/output-file/index.js
var require_output_file = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/output-file/index.js"(exports, module2) {
    "use strict";
    var u2 = require_universalify().fromCallback;
    var fs11 = require_graceful_fs();
    var path9 = require("path");
    var mkdir = require_mkdirs();
    var pathExists = require_path_exists2().pathExists;
    function outputFile(file2, data, encoding, callback) {
      if (typeof encoding === "function") {
        callback = encoding;
        encoding = "utf8";
      }
      const dir2 = path9.dirname(file2);
      pathExists(dir2, (err, itDoes) => {
        if (err)
          return callback(err);
        if (itDoes)
          return fs11.writeFile(file2, data, encoding, callback);
        mkdir.mkdirs(dir2, (err2) => {
          if (err2)
            return callback(err2);
          fs11.writeFile(file2, data, encoding, callback);
        });
      });
    }
    __name(outputFile, "outputFile");
    function outputFileSync(file2, ...args) {
      const dir2 = path9.dirname(file2);
      if (fs11.existsSync(dir2)) {
        return fs11.writeFileSync(file2, ...args);
      }
      mkdir.mkdirsSync(dir2);
      fs11.writeFileSync(file2, ...args);
    }
    __name(outputFileSync, "outputFileSync");
    module2.exports = {
      outputFile: u2(outputFile),
      outputFileSync
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/json/output-json.js
var require_output_json = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/json/output-json.js"(exports, module2) {
    "use strict";
    var { stringify: stringify2 } = require_utils2();
    var { outputFile } = require_output_file();
    async function outputJson(file2, data, options2 = {}) {
      const str = stringify2(data, options2);
      await outputFile(file2, str, options2);
    }
    __name(outputJson, "outputJson");
    module2.exports = outputJson;
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/json/output-json-sync.js
var require_output_json_sync = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/json/output-json-sync.js"(exports, module2) {
    "use strict";
    var { stringify: stringify2 } = require_utils2();
    var { outputFileSync } = require_output_file();
    function outputJsonSync(file2, data, options2) {
      const str = stringify2(data, options2);
      outputFileSync(file2, str, options2);
    }
    __name(outputJsonSync, "outputJsonSync");
    module2.exports = outputJsonSync;
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/json/index.js
var require_json = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/json/index.js"(exports, module2) {
    "use strict";
    var u2 = require_universalify().fromPromise;
    var jsonFile = require_jsonfile2();
    jsonFile.outputJson = u2(require_output_json());
    jsonFile.outputJsonSync = require_output_json_sync();
    jsonFile.outputJSON = jsonFile.outputJson;
    jsonFile.outputJSONSync = jsonFile.outputJsonSync;
    jsonFile.writeJSON = jsonFile.writeJson;
    jsonFile.writeJSONSync = jsonFile.writeJsonSync;
    jsonFile.readJSON = jsonFile.readJson;
    jsonFile.readJSONSync = jsonFile.readJsonSync;
    module2.exports = jsonFile;
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/move/move.js
var require_move = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/move/move.js"(exports, module2) {
    "use strict";
    var fs11 = require_graceful_fs();
    var path9 = require("path");
    var copy = require_copy2().copy;
    var remove2 = require_remove().remove;
    var mkdirp = require_mkdirs().mkdirp;
    var pathExists = require_path_exists2().pathExists;
    var stat2 = require_stat();
    function move(src, dest, opts, cb) {
      if (typeof opts === "function") {
        cb = opts;
        opts = {};
      }
      opts = opts || {};
      const overwrite = opts.overwrite || opts.clobber || false;
      stat2.checkPaths(src, dest, "move", opts, (err, stats) => {
        if (err)
          return cb(err);
        const { srcStat, isChangingCase = false } = stats;
        stat2.checkParentPaths(src, srcStat, dest, "move", (err2) => {
          if (err2)
            return cb(err2);
          if (isParentRoot(dest))
            return doRename(src, dest, overwrite, isChangingCase, cb);
          mkdirp(path9.dirname(dest), (err3) => {
            if (err3)
              return cb(err3);
            return doRename(src, dest, overwrite, isChangingCase, cb);
          });
        });
      });
    }
    __name(move, "move");
    function isParentRoot(dest) {
      const parent = path9.dirname(dest);
      const parsedPath = path9.parse(parent);
      return parsedPath.root === parent;
    }
    __name(isParentRoot, "isParentRoot");
    function doRename(src, dest, overwrite, isChangingCase, cb) {
      if (isChangingCase)
        return rename(src, dest, overwrite, cb);
      if (overwrite) {
        return remove2(dest, (err) => {
          if (err)
            return cb(err);
          return rename(src, dest, overwrite, cb);
        });
      }
      pathExists(dest, (err, destExists) => {
        if (err)
          return cb(err);
        if (destExists)
          return cb(new Error("dest already exists."));
        return rename(src, dest, overwrite, cb);
      });
    }
    __name(doRename, "doRename");
    function rename(src, dest, overwrite, cb) {
      fs11.rename(src, dest, (err) => {
        if (!err)
          return cb();
        if (err.code !== "EXDEV")
          return cb(err);
        return moveAcrossDevice(src, dest, overwrite, cb);
      });
    }
    __name(rename, "rename");
    function moveAcrossDevice(src, dest, overwrite, cb) {
      const opts = {
        overwrite,
        errorOnExist: true
      };
      copy(src, dest, opts, (err) => {
        if (err)
          return cb(err);
        return remove2(src, cb);
      });
    }
    __name(moveAcrossDevice, "moveAcrossDevice");
    module2.exports = move;
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/move/move-sync.js
var require_move_sync = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/move/move-sync.js"(exports, module2) {
    "use strict";
    var fs11 = require_graceful_fs();
    var path9 = require("path");
    var copySync = require_copy2().copySync;
    var removeSync = require_remove().removeSync;
    var mkdirpSync = require_mkdirs().mkdirpSync;
    var stat2 = require_stat();
    function moveSync(src, dest, opts) {
      opts = opts || {};
      const overwrite = opts.overwrite || opts.clobber || false;
      const { srcStat, isChangingCase = false } = stat2.checkPathsSync(src, dest, "move", opts);
      stat2.checkParentPathsSync(src, srcStat, dest, "move");
      if (!isParentRoot(dest))
        mkdirpSync(path9.dirname(dest));
      return doRename(src, dest, overwrite, isChangingCase);
    }
    __name(moveSync, "moveSync");
    function isParentRoot(dest) {
      const parent = path9.dirname(dest);
      const parsedPath = path9.parse(parent);
      return parsedPath.root === parent;
    }
    __name(isParentRoot, "isParentRoot");
    function doRename(src, dest, overwrite, isChangingCase) {
      if (isChangingCase)
        return rename(src, dest, overwrite);
      if (overwrite) {
        removeSync(dest);
        return rename(src, dest, overwrite);
      }
      if (fs11.existsSync(dest))
        throw new Error("dest already exists.");
      return rename(src, dest, overwrite);
    }
    __name(doRename, "doRename");
    function rename(src, dest, overwrite) {
      try {
        fs11.renameSync(src, dest);
      } catch (err) {
        if (err.code !== "EXDEV")
          throw err;
        return moveAcrossDevice(src, dest, overwrite);
      }
    }
    __name(rename, "rename");
    function moveAcrossDevice(src, dest, overwrite) {
      const opts = {
        overwrite,
        errorOnExist: true
      };
      copySync(src, dest, opts);
      return removeSync(src);
    }
    __name(moveAcrossDevice, "moveAcrossDevice");
    module2.exports = moveSync;
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/move/index.js
var require_move2 = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/move/index.js"(exports, module2) {
    "use strict";
    var u2 = require_universalify().fromCallback;
    module2.exports = {
      move: u2(require_move()),
      moveSync: require_move_sync()
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/index.js
var require_lib4 = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/index.js"(exports, module2) {
    "use strict";
    module2.exports = {
      ...require_fs(),
      ...require_copy2(),
      ...require_empty(),
      ...require_ensure(),
      ...require_json(),
      ...require_mkdirs(),
      ...require_move2(),
      ...require_output_file(),
      ...require_path_exists2(),
      ...require_remove()
    };
  }
});

// ../../node_modules/.pnpm/temp-dir@2.0.0/node_modules/temp-dir/index.js
var require_temp_dir = __commonJS({
  "../../node_modules/.pnpm/temp-dir@2.0.0/node_modules/temp-dir/index.js"(exports, module2) {
    "use strict";
    var fs11 = require("fs");
    var os2 = require("os");
    var tempDirectorySymbol = Symbol.for("__RESOLVED_TEMP_DIRECTORY__");
    if (!global[tempDirectorySymbol]) {
      Object.defineProperty(global, tempDirectorySymbol, {
        value: fs11.realpathSync(os2.tmpdir())
      });
    }
    module2.exports = global[tempDirectorySymbol];
  }
});

// ../../node_modules/.pnpm/commondir@1.0.1/node_modules/commondir/index.js
var require_commondir = __commonJS({
  "../../node_modules/.pnpm/commondir@1.0.1/node_modules/commondir/index.js"(exports, module2) {
    var path9 = require("path");
    module2.exports = function(basedir, relfiles) {
      if (relfiles) {
        var files = relfiles.map(function(r2) {
          return path9.resolve(basedir, r2);
        });
      } else {
        var files = basedir;
      }
      var res = files.slice(1).reduce(function(ps, file2) {
        if (!file2.match(/^([A-Za-z]:)?\/|\\/)) {
          throw new Error("relative path without a basedir");
        }
        var xs = file2.split(/\/+|\\+/);
        for (var i = 0; ps[i] === xs[i] && i < Math.min(ps.length, xs.length); i++)
          ;
        return ps.slice(0, i);
      }, files[0].split(/\/+|\\+/));
      return res.length > 1 ? res.join("/") : "/";
    };
  }
});

// ../../node_modules/.pnpm/pkg-dir@4.2.0/node_modules/pkg-dir/index.js
var require_pkg_dir = __commonJS({
  "../../node_modules/.pnpm/pkg-dir@4.2.0/node_modules/pkg-dir/index.js"(exports, module2) {
    "use strict";
    var path9 = require("path");
    var findUp2 = require_find_up2();
    var pkgDir = /* @__PURE__ */ __name(async (cwd) => {
      const filePath = await findUp2("package.json", { cwd });
      return filePath && path9.dirname(filePath);
    }, "pkgDir");
    module2.exports = pkgDir;
    module2.exports.default = pkgDir;
    module2.exports.sync = (cwd) => {
      const filePath = findUp2.sync("package.json", { cwd });
      return filePath && path9.dirname(filePath);
    };
  }
});

// ../../node_modules/.pnpm/semver@6.3.0/node_modules/semver/semver.js
var require_semver2 = __commonJS({
  "../../node_modules/.pnpm/semver@6.3.0/node_modules/semver/semver.js"(exports, module2) {
    exports = module2.exports = SemVer;
    var debug9;
    if (typeof process === "object" && process.env && process.env.NODE_DEBUG && /\bsemver\b/i.test(process.env.NODE_DEBUG)) {
      debug9 = /* @__PURE__ */ __name(function() {
        var args = Array.prototype.slice.call(arguments, 0);
        args.unshift("SEMVER");
        console.log.apply(console, args);
      }, "debug");
    } else {
      debug9 = /* @__PURE__ */ __name(function() {
      }, "debug");
    }
    exports.SEMVER_SPEC_VERSION = "2.0.0";
    var MAX_LENGTH = 256;
    var MAX_SAFE_INTEGER2 = Number.MAX_SAFE_INTEGER || 9007199254740991;
    var MAX_SAFE_COMPONENT_LENGTH = 16;
    var re = exports.re = [];
    var src = exports.src = [];
    var t3 = exports.tokens = {};
    var R = 0;
    function tok(n2) {
      t3[n2] = R++;
    }
    __name(tok, "tok");
    tok("NUMERICIDENTIFIER");
    src[t3.NUMERICIDENTIFIER] = "0|[1-9]\\d*";
    tok("NUMERICIDENTIFIERLOOSE");
    src[t3.NUMERICIDENTIFIERLOOSE] = "[0-9]+";
    tok("NONNUMERICIDENTIFIER");
    src[t3.NONNUMERICIDENTIFIER] = "\\d*[a-zA-Z-][a-zA-Z0-9-]*";
    tok("MAINVERSION");
    src[t3.MAINVERSION] = "(" + src[t3.NUMERICIDENTIFIER] + ")\\.(" + src[t3.NUMERICIDENTIFIER] + ")\\.(" + src[t3.NUMERICIDENTIFIER] + ")";
    tok("MAINVERSIONLOOSE");
    src[t3.MAINVERSIONLOOSE] = "(" + src[t3.NUMERICIDENTIFIERLOOSE] + ")\\.(" + src[t3.NUMERICIDENTIFIERLOOSE] + ")\\.(" + src[t3.NUMERICIDENTIFIERLOOSE] + ")";
    tok("PRERELEASEIDENTIFIER");
    src[t3.PRERELEASEIDENTIFIER] = "(?:" + src[t3.NUMERICIDENTIFIER] + "|" + src[t3.NONNUMERICIDENTIFIER] + ")";
    tok("PRERELEASEIDENTIFIERLOOSE");
    src[t3.PRERELEASEIDENTIFIERLOOSE] = "(?:" + src[t3.NUMERICIDENTIFIERLOOSE] + "|" + src[t3.NONNUMERICIDENTIFIER] + ")";
    tok("PRERELEASE");
    src[t3.PRERELEASE] = "(?:-(" + src[t3.PRERELEASEIDENTIFIER] + "(?:\\." + src[t3.PRERELEASEIDENTIFIER] + ")*))";
    tok("PRERELEASELOOSE");
    src[t3.PRERELEASELOOSE] = "(?:-?(" + src[t3.PRERELEASEIDENTIFIERLOOSE] + "(?:\\." + src[t3.PRERELEASEIDENTIFIERLOOSE] + ")*))";
    tok("BUILDIDENTIFIER");
    src[t3.BUILDIDENTIFIER] = "[0-9A-Za-z-]+";
    tok("BUILD");
    src[t3.BUILD] = "(?:\\+(" + src[t3.BUILDIDENTIFIER] + "(?:\\." + src[t3.BUILDIDENTIFIER] + ")*))";
    tok("FULL");
    tok("FULLPLAIN");
    src[t3.FULLPLAIN] = "v?" + src[t3.MAINVERSION] + src[t3.PRERELEASE] + "?" + src[t3.BUILD] + "?";
    src[t3.FULL] = "^" + src[t3.FULLPLAIN] + "$";
    tok("LOOSEPLAIN");
    src[t3.LOOSEPLAIN] = "[v=\\s]*" + src[t3.MAINVERSIONLOOSE] + src[t3.PRERELEASELOOSE] + "?" + src[t3.BUILD] + "?";
    tok("LOOSE");
    src[t3.LOOSE] = "^" + src[t3.LOOSEPLAIN] + "$";
    tok("GTLT");
    src[t3.GTLT] = "((?:<|>)?=?)";
    tok("XRANGEIDENTIFIERLOOSE");
    src[t3.XRANGEIDENTIFIERLOOSE] = src[t3.NUMERICIDENTIFIERLOOSE] + "|x|X|\\*";
    tok("XRANGEIDENTIFIER");
    src[t3.XRANGEIDENTIFIER] = src[t3.NUMERICIDENTIFIER] + "|x|X|\\*";
    tok("XRANGEPLAIN");
    src[t3.XRANGEPLAIN] = "[v=\\s]*(" + src[t3.XRANGEIDENTIFIER] + ")(?:\\.(" + src[t3.XRANGEIDENTIFIER] + ")(?:\\.(" + src[t3.XRANGEIDENTIFIER] + ")(?:" + src[t3.PRERELEASE] + ")?" + src[t3.BUILD] + "?)?)?";
    tok("XRANGEPLAINLOOSE");
    src[t3.XRANGEPLAINLOOSE] = "[v=\\s]*(" + src[t3.XRANGEIDENTIFIERLOOSE] + ")(?:\\.(" + src[t3.XRANGEIDENTIFIERLOOSE] + ")(?:\\.(" + src[t3.XRANGEIDENTIFIERLOOSE] + ")(?:" + src[t3.PRERELEASELOOSE] + ")?" + src[t3.BUILD] + "?)?)?";
    tok("XRANGE");
    src[t3.XRANGE] = "^" + src[t3.GTLT] + "\\s*" + src[t3.XRANGEPLAIN] + "$";
    tok("XRANGELOOSE");
    src[t3.XRANGELOOSE] = "^" + src[t3.GTLT] + "\\s*" + src[t3.XRANGEPLAINLOOSE] + "$";
    tok("COERCE");
    src[t3.COERCE] = "(^|[^\\d])(\\d{1," + MAX_SAFE_COMPONENT_LENGTH + "})(?:\\.(\\d{1," + MAX_SAFE_COMPONENT_LENGTH + "}))?(?:\\.(\\d{1," + MAX_SAFE_COMPONENT_LENGTH + "}))?(?:$|[^\\d])";
    tok("COERCERTL");
    re[t3.COERCERTL] = new RegExp(src[t3.COERCE], "g");
    tok("LONETILDE");
    src[t3.LONETILDE] = "(?:~>?)";
    tok("TILDETRIM");
    src[t3.TILDETRIM] = "(\\s*)" + src[t3.LONETILDE] + "\\s+";
    re[t3.TILDETRIM] = new RegExp(src[t3.TILDETRIM], "g");
    var tildeTrimReplace = "$1~";
    tok("TILDE");
    src[t3.TILDE] = "^" + src[t3.LONETILDE] + src[t3.XRANGEPLAIN] + "$";
    tok("TILDELOOSE");
    src[t3.TILDELOOSE] = "^" + src[t3.LONETILDE] + src[t3.XRANGEPLAINLOOSE] + "$";
    tok("LONECARET");
    src[t3.LONECARET] = "(?:\\^)";
    tok("CARETTRIM");
    src[t3.CARETTRIM] = "(\\s*)" + src[t3.LONECARET] + "\\s+";
    re[t3.CARETTRIM] = new RegExp(src[t3.CARETTRIM], "g");
    var caretTrimReplace = "$1^";
    tok("CARET");
    src[t3.CARET] = "^" + src[t3.LONECARET] + src[t3.XRANGEPLAIN] + "$";
    tok("CARETLOOSE");
    src[t3.CARETLOOSE] = "^" + src[t3.LONECARET] + src[t3.XRANGEPLAINLOOSE] + "$";
    tok("COMPARATORLOOSE");
    src[t3.COMPARATORLOOSE] = "^" + src[t3.GTLT] + "\\s*(" + src[t3.LOOSEPLAIN] + ")$|^$";
    tok("COMPARATOR");
    src[t3.COMPARATOR] = "^" + src[t3.GTLT] + "\\s*(" + src[t3.FULLPLAIN] + ")$|^$";
    tok("COMPARATORTRIM");
    src[t3.COMPARATORTRIM] = "(\\s*)" + src[t3.GTLT] + "\\s*(" + src[t3.LOOSEPLAIN] + "|" + src[t3.XRANGEPLAIN] + ")";
    re[t3.COMPARATORTRIM] = new RegExp(src[t3.COMPARATORTRIM], "g");
    var comparatorTrimReplace = "$1$2$3";
    tok("HYPHENRANGE");
    src[t3.HYPHENRANGE] = "^\\s*(" + src[t3.XRANGEPLAIN] + ")\\s+-\\s+(" + src[t3.XRANGEPLAIN] + ")\\s*$";
    tok("HYPHENRANGELOOSE");
    src[t3.HYPHENRANGELOOSE] = "^\\s*(" + src[t3.XRANGEPLAINLOOSE] + ")\\s+-\\s+(" + src[t3.XRANGEPLAINLOOSE] + ")\\s*$";
    tok("STAR");
    src[t3.STAR] = "(<|>)?=?\\s*\\*";
    for (i = 0; i < R; i++) {
      debug9(i, src[i]);
      if (!re[i]) {
        re[i] = new RegExp(src[i]);
      }
    }
    var i;
    exports.parse = parse;
    function parse(version, options2) {
      if (!options2 || typeof options2 !== "object") {
        options2 = {
          loose: !!options2,
          includePrerelease: false
        };
      }
      if (version instanceof SemVer) {
        return version;
      }
      if (typeof version !== "string") {
        return null;
      }
      if (version.length > MAX_LENGTH) {
        return null;
      }
      var r2 = options2.loose ? re[t3.LOOSE] : re[t3.FULL];
      if (!r2.test(version)) {
        return null;
      }
      try {
        return new SemVer(version, options2);
      } catch (er) {
        return null;
      }
    }
    __name(parse, "parse");
    exports.valid = valid;
    function valid(version, options2) {
      var v = parse(version, options2);
      return v ? v.version : null;
    }
    __name(valid, "valid");
    exports.clean = clean;
    function clean(version, options2) {
      var s = parse(version.trim().replace(/^[=v]+/, ""), options2);
      return s ? s.version : null;
    }
    __name(clean, "clean");
    exports.SemVer = SemVer;
    function SemVer(version, options2) {
      if (!options2 || typeof options2 !== "object") {
        options2 = {
          loose: !!options2,
          includePrerelease: false
        };
      }
      if (version instanceof SemVer) {
        if (version.loose === options2.loose) {
          return version;
        } else {
          version = version.version;
        }
      } else if (typeof version !== "string") {
        throw new TypeError("Invalid Version: " + version);
      }
      if (version.length > MAX_LENGTH) {
        throw new TypeError("version is longer than " + MAX_LENGTH + " characters");
      }
      if (!(this instanceof SemVer)) {
        return new SemVer(version, options2);
      }
      debug9("SemVer", version, options2);
      this.options = options2;
      this.loose = !!options2.loose;
      var m = version.trim().match(options2.loose ? re[t3.LOOSE] : re[t3.FULL]);
      if (!m) {
        throw new TypeError("Invalid Version: " + version);
      }
      this.raw = version;
      this.major = +m[1];
      this.minor = +m[2];
      this.patch = +m[3];
      if (this.major > MAX_SAFE_INTEGER2 || this.major < 0) {
        throw new TypeError("Invalid major version");
      }
      if (this.minor > MAX_SAFE_INTEGER2 || this.minor < 0) {
        throw new TypeError("Invalid minor version");
      }
      if (this.patch > MAX_SAFE_INTEGER2 || this.patch < 0) {
        throw new TypeError("Invalid patch version");
      }
      if (!m[4]) {
        this.prerelease = [];
      } else {
        this.prerelease = m[4].split(".").map(function(id) {
          if (/^[0-9]+$/.test(id)) {
            var num = +id;
            if (num >= 0 && num < MAX_SAFE_INTEGER2) {
              return num;
            }
          }
          return id;
        });
      }
      this.build = m[5] ? m[5].split(".") : [];
      this.format();
    }
    __name(SemVer, "SemVer");
    SemVer.prototype.format = function() {
      this.version = this.major + "." + this.minor + "." + this.patch;
      if (this.prerelease.length) {
        this.version += "-" + this.prerelease.join(".");
      }
      return this.version;
    };
    SemVer.prototype.toString = function() {
      return this.version;
    };
    SemVer.prototype.compare = function(other) {
      debug9("SemVer.compare", this.version, this.options, other);
      if (!(other instanceof SemVer)) {
        other = new SemVer(other, this.options);
      }
      return this.compareMain(other) || this.comparePre(other);
    };
    SemVer.prototype.compareMain = function(other) {
      if (!(other instanceof SemVer)) {
        other = new SemVer(other, this.options);
      }
      return compareIdentifiers(this.major, other.major) || compareIdentifiers(this.minor, other.minor) || compareIdentifiers(this.patch, other.patch);
    };
    SemVer.prototype.comparePre = function(other) {
      if (!(other instanceof SemVer)) {
        other = new SemVer(other, this.options);
      }
      if (this.prerelease.length && !other.prerelease.length) {
        return -1;
      } else if (!this.prerelease.length && other.prerelease.length) {
        return 1;
      } else if (!this.prerelease.length && !other.prerelease.length) {
        return 0;
      }
      var i2 = 0;
      do {
        var a = this.prerelease[i2];
        var b2 = other.prerelease[i2];
        debug9("prerelease compare", i2, a, b2);
        if (a === void 0 && b2 === void 0) {
          return 0;
        } else if (b2 === void 0) {
          return 1;
        } else if (a === void 0) {
          return -1;
        } else if (a === b2) {
          continue;
        } else {
          return compareIdentifiers(a, b2);
        }
      } while (++i2);
    };
    SemVer.prototype.compareBuild = function(other) {
      if (!(other instanceof SemVer)) {
        other = new SemVer(other, this.options);
      }
      var i2 = 0;
      do {
        var a = this.build[i2];
        var b2 = other.build[i2];
        debug9("prerelease compare", i2, a, b2);
        if (a === void 0 && b2 === void 0) {
          return 0;
        } else if (b2 === void 0) {
          return 1;
        } else if (a === void 0) {
          return -1;
        } else if (a === b2) {
          continue;
        } else {
          return compareIdentifiers(a, b2);
        }
      } while (++i2);
    };
    SemVer.prototype.inc = function(release, identifier) {
      switch (release) {
        case "premajor":
          this.prerelease.length = 0;
          this.patch = 0;
          this.minor = 0;
          this.major++;
          this.inc("pre", identifier);
          break;
        case "preminor":
          this.prerelease.length = 0;
          this.patch = 0;
          this.minor++;
          this.inc("pre", identifier);
          break;
        case "prepatch":
          this.prerelease.length = 0;
          this.inc("patch", identifier);
          this.inc("pre", identifier);
          break;
        case "prerelease":
          if (this.prerelease.length === 0) {
            this.inc("patch", identifier);
          }
          this.inc("pre", identifier);
          break;
        case "major":
          if (this.minor !== 0 || this.patch !== 0 || this.prerelease.length === 0) {
            this.major++;
          }
          this.minor = 0;
          this.patch = 0;
          this.prerelease = [];
          break;
        case "minor":
          if (this.patch !== 0 || this.prerelease.length === 0) {
            this.minor++;
          }
          this.patch = 0;
          this.prerelease = [];
          break;
        case "patch":
          if (this.prerelease.length === 0) {
            this.patch++;
          }
          this.prerelease = [];
          break;
        case "pre":
          if (this.prerelease.length === 0) {
            this.prerelease = [0];
          } else {
            var i2 = this.prerelease.length;
            while (--i2 >= 0) {
              if (typeof this.prerelease[i2] === "number") {
                this.prerelease[i2]++;
                i2 = -2;
              }
            }
            if (i2 === -1) {
              this.prerelease.push(0);
            }
          }
          if (identifier) {
            if (this.prerelease[0] === identifier) {
              if (isNaN(this.prerelease[1])) {
                this.prerelease = [identifier, 0];
              }
            } else {
              this.prerelease = [identifier, 0];
            }
          }
          break;
        default:
          throw new Error("invalid increment argument: " + release);
      }
      this.format();
      this.raw = this.version;
      return this;
    };
    exports.inc = inc;
    function inc(version, release, loose, identifier) {
      if (typeof loose === "string") {
        identifier = loose;
        loose = void 0;
      }
      try {
        return new SemVer(version, loose).inc(release, identifier).version;
      } catch (er) {
        return null;
      }
    }
    __name(inc, "inc");
    exports.diff = diff;
    function diff(version1, version2) {
      if (eq(version1, version2)) {
        return null;
      } else {
        var v1 = parse(version1);
        var v2 = parse(version2);
        var prefix = "";
        if (v1.prerelease.length || v2.prerelease.length) {
          prefix = "pre";
          var defaultResult = "prerelease";
        }
        for (var key in v1) {
          if (key === "major" || key === "minor" || key === "patch") {
            if (v1[key] !== v2[key]) {
              return prefix + key;
            }
          }
        }
        return defaultResult;
      }
    }
    __name(diff, "diff");
    exports.compareIdentifiers = compareIdentifiers;
    var numeric = /^[0-9]+$/;
    function compareIdentifiers(a, b2) {
      var anum = numeric.test(a);
      var bnum = numeric.test(b2);
      if (anum && bnum) {
        a = +a;
        b2 = +b2;
      }
      return a === b2 ? 0 : anum && !bnum ? -1 : bnum && !anum ? 1 : a < b2 ? -1 : 1;
    }
    __name(compareIdentifiers, "compareIdentifiers");
    exports.rcompareIdentifiers = rcompareIdentifiers;
    function rcompareIdentifiers(a, b2) {
      return compareIdentifiers(b2, a);
    }
    __name(rcompareIdentifiers, "rcompareIdentifiers");
    exports.major = major;
    function major(a, loose) {
      return new SemVer(a, loose).major;
    }
    __name(major, "major");
    exports.minor = minor;
    function minor(a, loose) {
      return new SemVer(a, loose).minor;
    }
    __name(minor, "minor");
    exports.patch = patch;
    function patch(a, loose) {
      return new SemVer(a, loose).patch;
    }
    __name(patch, "patch");
    exports.compare = compare;
    function compare(a, b2, loose) {
      return new SemVer(a, loose).compare(new SemVer(b2, loose));
    }
    __name(compare, "compare");
    exports.compareLoose = compareLoose;
    function compareLoose(a, b2) {
      return compare(a, b2, true);
    }
    __name(compareLoose, "compareLoose");
    exports.compareBuild = compareBuild;
    function compareBuild(a, b2, loose) {
      var versionA = new SemVer(a, loose);
      var versionB = new SemVer(b2, loose);
      return versionA.compare(versionB) || versionA.compareBuild(versionB);
    }
    __name(compareBuild, "compareBuild");
    exports.rcompare = rcompare;
    function rcompare(a, b2, loose) {
      return compare(b2, a, loose);
    }
    __name(rcompare, "rcompare");
    exports.sort = sort;
    function sort(list, loose) {
      return list.sort(function(a, b2) {
        return exports.compareBuild(a, b2, loose);
      });
    }
    __name(sort, "sort");
    exports.rsort = rsort;
    function rsort(list, loose) {
      return list.sort(function(a, b2) {
        return exports.compareBuild(b2, a, loose);
      });
    }
    __name(rsort, "rsort");
    exports.gt = gt;
    function gt(a, b2, loose) {
      return compare(a, b2, loose) > 0;
    }
    __name(gt, "gt");
    exports.lt = lt;
    function lt(a, b2, loose) {
      return compare(a, b2, loose) < 0;
    }
    __name(lt, "lt");
    exports.eq = eq;
    function eq(a, b2, loose) {
      return compare(a, b2, loose) === 0;
    }
    __name(eq, "eq");
    exports.neq = neq;
    function neq(a, b2, loose) {
      return compare(a, b2, loose) !== 0;
    }
    __name(neq, "neq");
    exports.gte = gte;
    function gte(a, b2, loose) {
      return compare(a, b2, loose) >= 0;
    }
    __name(gte, "gte");
    exports.lte = lte;
    function lte(a, b2, loose) {
      return compare(a, b2, loose) <= 0;
    }
    __name(lte, "lte");
    exports.cmp = cmp;
    function cmp(a, op, b2, loose) {
      switch (op) {
        case "===":
          if (typeof a === "object")
            a = a.version;
          if (typeof b2 === "object")
            b2 = b2.version;
          return a === b2;
        case "!==":
          if (typeof a === "object")
            a = a.version;
          if (typeof b2 === "object")
            b2 = b2.version;
          return a !== b2;
        case "":
        case "=":
        case "==":
          return eq(a, b2, loose);
        case "!=":
          return neq(a, b2, loose);
        case ">":
          return gt(a, b2, loose);
        case ">=":
          return gte(a, b2, loose);
        case "<":
          return lt(a, b2, loose);
        case "<=":
          return lte(a, b2, loose);
        default:
          throw new TypeError("Invalid operator: " + op);
      }
    }
    __name(cmp, "cmp");
    exports.Comparator = Comparator;
    function Comparator(comp, options2) {
      if (!options2 || typeof options2 !== "object") {
        options2 = {
          loose: !!options2,
          includePrerelease: false
        };
      }
      if (comp instanceof Comparator) {
        if (comp.loose === !!options2.loose) {
          return comp;
        } else {
          comp = comp.value;
        }
      }
      if (!(this instanceof Comparator)) {
        return new Comparator(comp, options2);
      }
      debug9("comparator", comp, options2);
      this.options = options2;
      this.loose = !!options2.loose;
      this.parse(comp);
      if (this.semver === ANY) {
        this.value = "";
      } else {
        this.value = this.operator + this.semver.version;
      }
      debug9("comp", this);
    }
    __name(Comparator, "Comparator");
    var ANY = {};
    Comparator.prototype.parse = function(comp) {
      var r2 = this.options.loose ? re[t3.COMPARATORLOOSE] : re[t3.COMPARATOR];
      var m = comp.match(r2);
      if (!m) {
        throw new TypeError("Invalid comparator: " + comp);
      }
      this.operator = m[1] !== void 0 ? m[1] : "";
      if (this.operator === "=") {
        this.operator = "";
      }
      if (!m[2]) {
        this.semver = ANY;
      } else {
        this.semver = new SemVer(m[2], this.options.loose);
      }
    };
    Comparator.prototype.toString = function() {
      return this.value;
    };
    Comparator.prototype.test = function(version) {
      debug9("Comparator.test", version, this.options.loose);
      if (this.semver === ANY || version === ANY) {
        return true;
      }
      if (typeof version === "string") {
        try {
          version = new SemVer(version, this.options);
        } catch (er) {
          return false;
        }
      }
      return cmp(version, this.operator, this.semver, this.options);
    };
    Comparator.prototype.intersects = function(comp, options2) {
      if (!(comp instanceof Comparator)) {
        throw new TypeError("a Comparator is required");
      }
      if (!options2 || typeof options2 !== "object") {
        options2 = {
          loose: !!options2,
          includePrerelease: false
        };
      }
      var rangeTmp;
      if (this.operator === "") {
        if (this.value === "") {
          return true;
        }
        rangeTmp = new Range(comp.value, options2);
        return satisfies(this.value, rangeTmp, options2);
      } else if (comp.operator === "") {
        if (comp.value === "") {
          return true;
        }
        rangeTmp = new Range(this.value, options2);
        return satisfies(comp.semver, rangeTmp, options2);
      }
      var sameDirectionIncreasing = (this.operator === ">=" || this.operator === ">") && (comp.operator === ">=" || comp.operator === ">");
      var sameDirectionDecreasing = (this.operator === "<=" || this.operator === "<") && (comp.operator === "<=" || comp.operator === "<");
      var sameSemVer = this.semver.version === comp.semver.version;
      var differentDirectionsInclusive = (this.operator === ">=" || this.operator === "<=") && (comp.operator === ">=" || comp.operator === "<=");
      var oppositeDirectionsLessThan = cmp(this.semver, "<", comp.semver, options2) && ((this.operator === ">=" || this.operator === ">") && (comp.operator === "<=" || comp.operator === "<"));
      var oppositeDirectionsGreaterThan = cmp(this.semver, ">", comp.semver, options2) && ((this.operator === "<=" || this.operator === "<") && (comp.operator === ">=" || comp.operator === ">"));
      return sameDirectionIncreasing || sameDirectionDecreasing || sameSemVer && differentDirectionsInclusive || oppositeDirectionsLessThan || oppositeDirectionsGreaterThan;
    };
    exports.Range = Range;
    function Range(range, options2) {
      if (!options2 || typeof options2 !== "object") {
        options2 = {
          loose: !!options2,
          includePrerelease: false
        };
      }
      if (range instanceof Range) {
        if (range.loose === !!options2.loose && range.includePrerelease === !!options2.includePrerelease) {
          return range;
        } else {
          return new Range(range.raw, options2);
        }
      }
      if (range instanceof Comparator) {
        return new Range(range.value, options2);
      }
      if (!(this instanceof Range)) {
        return new Range(range, options2);
      }
      this.options = options2;
      this.loose = !!options2.loose;
      this.includePrerelease = !!options2.includePrerelease;
      this.raw = range;
      this.set = range.split(/\s*\|\|\s*/).map(function(range2) {
        return this.parseRange(range2.trim());
      }, this).filter(function(c) {
        return c.length;
      });
      if (!this.set.length) {
        throw new TypeError("Invalid SemVer Range: " + range);
      }
      this.format();
    }
    __name(Range, "Range");
    Range.prototype.format = function() {
      this.range = this.set.map(function(comps) {
        return comps.join(" ").trim();
      }).join("||").trim();
      return this.range;
    };
    Range.prototype.toString = function() {
      return this.range;
    };
    Range.prototype.parseRange = function(range) {
      var loose = this.options.loose;
      range = range.trim();
      var hr = loose ? re[t3.HYPHENRANGELOOSE] : re[t3.HYPHENRANGE];
      range = range.replace(hr, hyphenReplace);
      debug9("hyphen replace", range);
      range = range.replace(re[t3.COMPARATORTRIM], comparatorTrimReplace);
      debug9("comparator trim", range, re[t3.COMPARATORTRIM]);
      range = range.replace(re[t3.TILDETRIM], tildeTrimReplace);
      range = range.replace(re[t3.CARETTRIM], caretTrimReplace);
      range = range.split(/\s+/).join(" ");
      var compRe = loose ? re[t3.COMPARATORLOOSE] : re[t3.COMPARATOR];
      var set = range.split(" ").map(function(comp) {
        return parseComparator(comp, this.options);
      }, this).join(" ").split(/\s+/);
      if (this.options.loose) {
        set = set.filter(function(comp) {
          return !!comp.match(compRe);
        });
      }
      set = set.map(function(comp) {
        return new Comparator(comp, this.options);
      }, this);
      return set;
    };
    Range.prototype.intersects = function(range, options2) {
      if (!(range instanceof Range)) {
        throw new TypeError("a Range is required");
      }
      return this.set.some(function(thisComparators) {
        return isSatisfiable(thisComparators, options2) && range.set.some(function(rangeComparators) {
          return isSatisfiable(rangeComparators, options2) && thisComparators.every(function(thisComparator) {
            return rangeComparators.every(function(rangeComparator) {
              return thisComparator.intersects(rangeComparator, options2);
            });
          });
        });
      });
    };
    function isSatisfiable(comparators, options2) {
      var result = true;
      var remainingComparators = comparators.slice();
      var testComparator = remainingComparators.pop();
      while (result && remainingComparators.length) {
        result = remainingComparators.every(function(otherComparator) {
          return testComparator.intersects(otherComparator, options2);
        });
        testComparator = remainingComparators.pop();
      }
      return result;
    }
    __name(isSatisfiable, "isSatisfiable");
    exports.toComparators = toComparators;
    function toComparators(range, options2) {
      return new Range(range, options2).set.map(function(comp) {
        return comp.map(function(c) {
          return c.value;
        }).join(" ").trim().split(" ");
      });
    }
    __name(toComparators, "toComparators");
    function parseComparator(comp, options2) {
      debug9("comp", comp, options2);
      comp = replaceCarets(comp, options2);
      debug9("caret", comp);
      comp = replaceTildes(comp, options2);
      debug9("tildes", comp);
      comp = replaceXRanges(comp, options2);
      debug9("xrange", comp);
      comp = replaceStars(comp, options2);
      debug9("stars", comp);
      return comp;
    }
    __name(parseComparator, "parseComparator");
    function isX(id) {
      return !id || id.toLowerCase() === "x" || id === "*";
    }
    __name(isX, "isX");
    function replaceTildes(comp, options2) {
      return comp.trim().split(/\s+/).map(function(comp2) {
        return replaceTilde(comp2, options2);
      }).join(" ");
    }
    __name(replaceTildes, "replaceTildes");
    function replaceTilde(comp, options2) {
      var r2 = options2.loose ? re[t3.TILDELOOSE] : re[t3.TILDE];
      return comp.replace(r2, function(_, M, m, p2, pr) {
        debug9("tilde", comp, _, M, m, p2, pr);
        var ret;
        if (isX(M)) {
          ret = "";
        } else if (isX(m)) {
          ret = ">=" + M + ".0.0 <" + (+M + 1) + ".0.0";
        } else if (isX(p2)) {
          ret = ">=" + M + "." + m + ".0 <" + M + "." + (+m + 1) + ".0";
        } else if (pr) {
          debug9("replaceTilde pr", pr);
          ret = ">=" + M + "." + m + "." + p2 + "-" + pr + " <" + M + "." + (+m + 1) + ".0";
        } else {
          ret = ">=" + M + "." + m + "." + p2 + " <" + M + "." + (+m + 1) + ".0";
        }
        debug9("tilde return", ret);
        return ret;
      });
    }
    __name(replaceTilde, "replaceTilde");
    function replaceCarets(comp, options2) {
      return comp.trim().split(/\s+/).map(function(comp2) {
        return replaceCaret(comp2, options2);
      }).join(" ");
    }
    __name(replaceCarets, "replaceCarets");
    function replaceCaret(comp, options2) {
      debug9("caret", comp, options2);
      var r2 = options2.loose ? re[t3.CARETLOOSE] : re[t3.CARET];
      return comp.replace(r2, function(_, M, m, p2, pr) {
        debug9("caret", comp, _, M, m, p2, pr);
        var ret;
        if (isX(M)) {
          ret = "";
        } else if (isX(m)) {
          ret = ">=" + M + ".0.0 <" + (+M + 1) + ".0.0";
        } else if (isX(p2)) {
          if (M === "0") {
            ret = ">=" + M + "." + m + ".0 <" + M + "." + (+m + 1) + ".0";
          } else {
            ret = ">=" + M + "." + m + ".0 <" + (+M + 1) + ".0.0";
          }
        } else if (pr) {
          debug9("replaceCaret pr", pr);
          if (M === "0") {
            if (m === "0") {
              ret = ">=" + M + "." + m + "." + p2 + "-" + pr + " <" + M + "." + m + "." + (+p2 + 1);
            } else {
              ret = ">=" + M + "." + m + "." + p2 + "-" + pr + " <" + M + "." + (+m + 1) + ".0";
            }
          } else {
            ret = ">=" + M + "." + m + "." + p2 + "-" + pr + " <" + (+M + 1) + ".0.0";
          }
        } else {
          debug9("no pr");
          if (M === "0") {
            if (m === "0") {
              ret = ">=" + M + "." + m + "." + p2 + " <" + M + "." + m + "." + (+p2 + 1);
            } else {
              ret = ">=" + M + "." + m + "." + p2 + " <" + M + "." + (+m + 1) + ".0";
            }
          } else {
            ret = ">=" + M + "." + m + "." + p2 + " <" + (+M + 1) + ".0.0";
          }
        }
        debug9("caret return", ret);
        return ret;
      });
    }
    __name(replaceCaret, "replaceCaret");
    function replaceXRanges(comp, options2) {
      debug9("replaceXRanges", comp, options2);
      return comp.split(/\s+/).map(function(comp2) {
        return replaceXRange(comp2, options2);
      }).join(" ");
    }
    __name(replaceXRanges, "replaceXRanges");
    function replaceXRange(comp, options2) {
      comp = comp.trim();
      var r2 = options2.loose ? re[t3.XRANGELOOSE] : re[t3.XRANGE];
      return comp.replace(r2, function(ret, gtlt, M, m, p2, pr) {
        debug9("xRange", comp, ret, gtlt, M, m, p2, pr);
        var xM = isX(M);
        var xm = xM || isX(m);
        var xp = xm || isX(p2);
        var anyX = xp;
        if (gtlt === "=" && anyX) {
          gtlt = "";
        }
        pr = options2.includePrerelease ? "-0" : "";
        if (xM) {
          if (gtlt === ">" || gtlt === "<") {
            ret = "<0.0.0-0";
          } else {
            ret = "*";
          }
        } else if (gtlt && anyX) {
          if (xm) {
            m = 0;
          }
          p2 = 0;
          if (gtlt === ">") {
            gtlt = ">=";
            if (xm) {
              M = +M + 1;
              m = 0;
              p2 = 0;
            } else {
              m = +m + 1;
              p2 = 0;
            }
          } else if (gtlt === "<=") {
            gtlt = "<";
            if (xm) {
              M = +M + 1;
            } else {
              m = +m + 1;
            }
          }
          ret = gtlt + M + "." + m + "." + p2 + pr;
        } else if (xm) {
          ret = ">=" + M + ".0.0" + pr + " <" + (+M + 1) + ".0.0" + pr;
        } else if (xp) {
          ret = ">=" + M + "." + m + ".0" + pr + " <" + M + "." + (+m + 1) + ".0" + pr;
        }
        debug9("xRange return", ret);
        return ret;
      });
    }
    __name(replaceXRange, "replaceXRange");
    function replaceStars(comp, options2) {
      debug9("replaceStars", comp, options2);
      return comp.trim().replace(re[t3.STAR], "");
    }
    __name(replaceStars, "replaceStars");
    function hyphenReplace($0, from, fM, fm, fp, fpr, fb, to, tM, tm, tp, tpr, tb) {
      if (isX(fM)) {
        from = "";
      } else if (isX(fm)) {
        from = ">=" + fM + ".0.0";
      } else if (isX(fp)) {
        from = ">=" + fM + "." + fm + ".0";
      } else {
        from = ">=" + from;
      }
      if (isX(tM)) {
        to = "";
      } else if (isX(tm)) {
        to = "<" + (+tM + 1) + ".0.0";
      } else if (isX(tp)) {
        to = "<" + tM + "." + (+tm + 1) + ".0";
      } else if (tpr) {
        to = "<=" + tM + "." + tm + "." + tp + "-" + tpr;
      } else {
        to = "<=" + to;
      }
      return (from + " " + to).trim();
    }
    __name(hyphenReplace, "hyphenReplace");
    Range.prototype.test = function(version) {
      if (!version) {
        return false;
      }
      if (typeof version === "string") {
        try {
          version = new SemVer(version, this.options);
        } catch (er) {
          return false;
        }
      }
      for (var i2 = 0; i2 < this.set.length; i2++) {
        if (testSet(this.set[i2], version, this.options)) {
          return true;
        }
      }
      return false;
    };
    function testSet(set, version, options2) {
      for (var i2 = 0; i2 < set.length; i2++) {
        if (!set[i2].test(version)) {
          return false;
        }
      }
      if (version.prerelease.length && !options2.includePrerelease) {
        for (i2 = 0; i2 < set.length; i2++) {
          debug9(set[i2].semver);
          if (set[i2].semver === ANY) {
            continue;
          }
          if (set[i2].semver.prerelease.length > 0) {
            var allowed = set[i2].semver;
            if (allowed.major === version.major && allowed.minor === version.minor && allowed.patch === version.patch) {
              return true;
            }
          }
        }
        return false;
      }
      return true;
    }
    __name(testSet, "testSet");
    exports.satisfies = satisfies;
    function satisfies(version, range, options2) {
      try {
        range = new Range(range, options2);
      } catch (er) {
        return false;
      }
      return range.test(version);
    }
    __name(satisfies, "satisfies");
    exports.maxSatisfying = maxSatisfying;
    function maxSatisfying(versions, range, options2) {
      var max2 = null;
      var maxSV = null;
      try {
        var rangeObj = new Range(range, options2);
      } catch (er) {
        return null;
      }
      versions.forEach(function(v) {
        if (rangeObj.test(v)) {
          if (!max2 || maxSV.compare(v) === -1) {
            max2 = v;
            maxSV = new SemVer(max2, options2);
          }
        }
      });
      return max2;
    }
    __name(maxSatisfying, "maxSatisfying");
    exports.minSatisfying = minSatisfying;
    function minSatisfying(versions, range, options2) {
      var min2 = null;
      var minSV = null;
      try {
        var rangeObj = new Range(range, options2);
      } catch (er) {
        return null;
      }
      versions.forEach(function(v) {
        if (rangeObj.test(v)) {
          if (!min2 || minSV.compare(v) === 1) {
            min2 = v;
            minSV = new SemVer(min2, options2);
          }
        }
      });
      return min2;
    }
    __name(minSatisfying, "minSatisfying");
    exports.minVersion = minVersion;
    function minVersion(range, loose) {
      range = new Range(range, loose);
      var minver = new SemVer("0.0.0");
      if (range.test(minver)) {
        return minver;
      }
      minver = new SemVer("0.0.0-0");
      if (range.test(minver)) {
        return minver;
      }
      minver = null;
      for (var i2 = 0; i2 < range.set.length; ++i2) {
        var comparators = range.set[i2];
        comparators.forEach(function(comparator) {
          var compver = new SemVer(comparator.semver.version);
          switch (comparator.operator) {
            case ">":
              if (compver.prerelease.length === 0) {
                compver.patch++;
              } else {
                compver.prerelease.push(0);
              }
              compver.raw = compver.format();
            case "":
            case ">=":
              if (!minver || gt(minver, compver)) {
                minver = compver;
              }
              break;
            case "<":
            case "<=":
              break;
            default:
              throw new Error("Unexpected operation: " + comparator.operator);
          }
        });
      }
      if (minver && range.test(minver)) {
        return minver;
      }
      return null;
    }
    __name(minVersion, "minVersion");
    exports.validRange = validRange;
    function validRange(range, options2) {
      try {
        return new Range(range, options2).range || "*";
      } catch (er) {
        return null;
      }
    }
    __name(validRange, "validRange");
    exports.ltr = ltr;
    function ltr(version, range, options2) {
      return outside(version, range, "<", options2);
    }
    __name(ltr, "ltr");
    exports.gtr = gtr;
    function gtr(version, range, options2) {
      return outside(version, range, ">", options2);
    }
    __name(gtr, "gtr");
    exports.outside = outside;
    function outside(version, range, hilo, options2) {
      version = new SemVer(version, options2);
      range = new Range(range, options2);
      var gtfn, ltefn, ltfn, comp, ecomp;
      switch (hilo) {
        case ">":
          gtfn = gt;
          ltefn = lte;
          ltfn = lt;
          comp = ">";
          ecomp = ">=";
          break;
        case "<":
          gtfn = lt;
          ltefn = gte;
          ltfn = gt;
          comp = "<";
          ecomp = "<=";
          break;
        default:
          throw new TypeError('Must provide a hilo val of "<" or ">"');
      }
      if (satisfies(version, range, options2)) {
        return false;
      }
      for (var i2 = 0; i2 < range.set.length; ++i2) {
        var comparators = range.set[i2];
        var high = null;
        var low = null;
        comparators.forEach(function(comparator) {
          if (comparator.semver === ANY) {
            comparator = new Comparator(">=0.0.0");
          }
          high = high || comparator;
          low = low || comparator;
          if (gtfn(comparator.semver, high.semver, options2)) {
            high = comparator;
          } else if (ltfn(comparator.semver, low.semver, options2)) {
            low = comparator;
          }
        });
        if (high.operator === comp || high.operator === ecomp) {
          return false;
        }
        if ((!low.operator || low.operator === comp) && ltefn(version, low.semver)) {
          return false;
        } else if (low.operator === ecomp && ltfn(version, low.semver)) {
          return false;
        }
      }
      return true;
    }
    __name(outside, "outside");
    exports.prerelease = prerelease;
    function prerelease(version, options2) {
      var parsed = parse(version, options2);
      return parsed && parsed.prerelease.length ? parsed.prerelease : null;
    }
    __name(prerelease, "prerelease");
    exports.intersects = intersects;
    function intersects(r1, r2, options2) {
      r1 = new Range(r1, options2);
      r2 = new Range(r2, options2);
      return r1.intersects(r2);
    }
    __name(intersects, "intersects");
    exports.coerce = coerce;
    function coerce(version, options2) {
      if (version instanceof SemVer) {
        return version;
      }
      if (typeof version === "number") {
        version = String(version);
      }
      if (typeof version !== "string") {
        return null;
      }
      options2 = options2 || {};
      var match = null;
      if (!options2.rtl) {
        match = version.match(re[t3.COERCE]);
      } else {
        var next;
        while ((next = re[t3.COERCERTL].exec(version)) && (!match || match.index + match[0].length !== version.length)) {
          if (!match || next.index + next[0].length !== match.index + match[0].length) {
            match = next;
          }
          re[t3.COERCERTL].lastIndex = next.index + next[1].length + next[2].length;
        }
        re[t3.COERCERTL].lastIndex = -1;
      }
      if (match === null) {
        return null;
      }
      return parse(match[2] + "." + (match[3] || "0") + "." + (match[4] || "0"), options2);
    }
    __name(coerce, "coerce");
  }
});

// ../../node_modules/.pnpm/make-dir@3.1.0/node_modules/make-dir/index.js
var require_make_dir2 = __commonJS({
  "../../node_modules/.pnpm/make-dir@3.1.0/node_modules/make-dir/index.js"(exports, module2) {
    "use strict";
    var fs11 = require("fs");
    var path9 = require("path");
    var { promisify: promisify5 } = require("util");
    var semver = require_semver2();
    var useNativeRecursiveOption = semver.satisfies(process.version, ">=10.12.0");
    var checkPath = /* @__PURE__ */ __name((pth) => {
      if (process.platform === "win32") {
        const pathHasInvalidWinCharacters = /[<>:"|?*]/.test(pth.replace(path9.parse(pth).root, ""));
        if (pathHasInvalidWinCharacters) {
          const error = new Error(`Path contains invalid characters: ${pth}`);
          error.code = "EINVAL";
          throw error;
        }
      }
    }, "checkPath");
    var processOptions = /* @__PURE__ */ __name((options2) => {
      const defaults = {
        mode: 511,
        fs: fs11
      };
      return {
        ...defaults,
        ...options2
      };
    }, "processOptions");
    var permissionError = /* @__PURE__ */ __name((pth) => {
      const error = new Error(`operation not permitted, mkdir '${pth}'`);
      error.code = "EPERM";
      error.errno = -4048;
      error.path = pth;
      error.syscall = "mkdir";
      return error;
    }, "permissionError");
    var makeDir = /* @__PURE__ */ __name(async (input, options2) => {
      checkPath(input);
      options2 = processOptions(options2);
      const mkdir = promisify5(options2.fs.mkdir);
      const stat2 = promisify5(options2.fs.stat);
      if (useNativeRecursiveOption && options2.fs.mkdir === fs11.mkdir) {
        const pth = path9.resolve(input);
        await mkdir(pth, {
          mode: options2.mode,
          recursive: true
        });
        return pth;
      }
      const make = /* @__PURE__ */ __name(async (pth) => {
        try {
          await mkdir(pth, options2.mode);
          return pth;
        } catch (error) {
          if (error.code === "EPERM") {
            throw error;
          }
          if (error.code === "ENOENT") {
            if (path9.dirname(pth) === pth) {
              throw permissionError(pth);
            }
            if (error.message.includes("null bytes")) {
              throw error;
            }
            await make(path9.dirname(pth));
            return make(pth);
          }
          try {
            const stats = await stat2(pth);
            if (!stats.isDirectory()) {
              throw new Error("The path is not a directory");
            }
          } catch (_) {
            throw error;
          }
          return pth;
        }
      }, "make");
      return make(path9.resolve(input));
    }, "makeDir");
    module2.exports = makeDir;
    module2.exports.sync = (input, options2) => {
      checkPath(input);
      options2 = processOptions(options2);
      if (useNativeRecursiveOption && options2.fs.mkdirSync === fs11.mkdirSync) {
        const pth = path9.resolve(input);
        fs11.mkdirSync(pth, {
          mode: options2.mode,
          recursive: true
        });
        return pth;
      }
      const make = /* @__PURE__ */ __name((pth) => {
        try {
          options2.fs.mkdirSync(pth, options2.mode);
        } catch (error) {
          if (error.code === "EPERM") {
            throw error;
          }
          if (error.code === "ENOENT") {
            if (path9.dirname(pth) === pth) {
              throw permissionError(pth);
            }
            if (error.message.includes("null bytes")) {
              throw error;
            }
            make(path9.dirname(pth));
            return make(pth);
          }
          try {
            if (!options2.fs.statSync(pth).isDirectory()) {
              throw new Error("The path is not a directory");
            }
          } catch (_) {
            throw error;
          }
        }
        return pth;
      }, "make");
      return make(path9.resolve(input));
    };
  }
});

// ../../node_modules/.pnpm/find-cache-dir@3.3.2/node_modules/find-cache-dir/index.js
var require_find_cache_dir = __commonJS({
  "../../node_modules/.pnpm/find-cache-dir@3.3.2/node_modules/find-cache-dir/index.js"(exports, module2) {
    "use strict";
    var path9 = require("path");
    var fs11 = require("fs");
    var commonDir = require_commondir();
    var pkgDir = require_pkg_dir();
    var makeDir = require_make_dir2();
    var { env, cwd } = process;
    var isWritable = /* @__PURE__ */ __name((path10) => {
      try {
        fs11.accessSync(path10, fs11.constants.W_OK);
        return true;
      } catch (_) {
        return false;
      }
    }, "isWritable");
    function useDirectory(directory, options2) {
      if (options2.create) {
        makeDir.sync(directory);
      }
      if (options2.thunk) {
        return (...arguments_) => path9.join(directory, ...arguments_);
      }
      return directory;
    }
    __name(useDirectory, "useDirectory");
    function getNodeModuleDirectory(directory) {
      const nodeModules = path9.join(directory, "node_modules");
      if (!isWritable(nodeModules) && (fs11.existsSync(nodeModules) || !isWritable(path9.join(directory)))) {
        return;
      }
      return nodeModules;
    }
    __name(getNodeModuleDirectory, "getNodeModuleDirectory");
    module2.exports = (options2 = {}) => {
      if (env.CACHE_DIR && !["true", "false", "1", "0"].includes(env.CACHE_DIR)) {
        return useDirectory(path9.join(env.CACHE_DIR, options2.name), options2);
      }
      let { cwd: directory = cwd() } = options2;
      if (options2.files) {
        directory = commonDir(directory, options2.files);
      }
      directory = pkgDir.sync(directory);
      if (!directory) {
        return;
      }
      const nodeModules = getNodeModuleDirectory(directory);
      if (!nodeModules) {
        return void 0;
      }
      return useDirectory(path9.join(directory, "node_modules", ".cache", options2.name), options2);
    };
  }
});

// ../../node_modules/.pnpm/new-github-issue-url@0.2.1/node_modules/new-github-issue-url/index.js
var require_new_github_issue_url = __commonJS({
  "../../node_modules/.pnpm/new-github-issue-url@0.2.1/node_modules/new-github-issue-url/index.js"(exports, module2) {
    "use strict";
    module2.exports = (options2 = {}) => {
      let repoUrl;
      if (options2.repoUrl) {
        repoUrl = options2.repoUrl;
      } else if (options2.user && options2.repo) {
        repoUrl = `https://github.com/${options2.user}/${options2.repo}`;
      } else {
        throw new Error("You need to specify either the `repoUrl` option or both the `user` and `repo` options");
      }
      const url = new URL(`${repoUrl}/issues/new`);
      const types = [
        "body",
        "title",
        "labels",
        "template",
        "milestone",
        "assignee",
        "projects"
      ];
      for (const type of types) {
        let value = options2[type];
        if (value === void 0) {
          continue;
        }
        if (type === "labels" || type === "projects") {
          if (!Array.isArray(value)) {
            throw new TypeError(`The \`${type}\` option should be an array`);
          }
          value = value.join(",");
        }
        url.searchParams.set(type, value);
      }
      return url.toString();
    };
    module2.exports.default = module2.exports;
  }
});

// ../../node_modules/.pnpm/indent-string@4.0.0/node_modules/indent-string/index.js
var require_indent_string = __commonJS({
  "../../node_modules/.pnpm/indent-string@4.0.0/node_modules/indent-string/index.js"(exports, module2) {
    "use strict";
    module2.exports = (string, count = 1, options2) => {
      options2 = {
        indent: " ",
        includeEmptyLines: false,
        ...options2
      };
      if (typeof string !== "string") {
        throw new TypeError(
          `Expected \`input\` to be a \`string\`, got \`${typeof string}\``
        );
      }
      if (typeof count !== "number") {
        throw new TypeError(
          `Expected \`count\` to be a \`number\`, got \`${typeof count}\``
        );
      }
      if (typeof options2.indent !== "string") {
        throw new TypeError(
          `Expected \`options.indent\` to be a \`string\`, got \`${typeof options2.indent}\``
        );
      }
      if (count === 0) {
        return string;
      }
      const regex = options2.includeEmptyLines ? /^/gm : /^(?!\s*$)/gm;
      return string.replace(regex, options2.indent.repeat(count));
    };
  }
});

// ../../node_modules/.pnpm/pluralize@8.0.0/node_modules/pluralize/pluralize.js
var require_pluralize = __commonJS({
  "../../node_modules/.pnpm/pluralize@8.0.0/node_modules/pluralize/pluralize.js"(exports, module2) {
    (function(root, pluralize3) {
      if (typeof require === "function" && typeof exports === "object" && typeof module2 === "object") {
        module2.exports = pluralize3();
      } else if (typeof define === "function" && define.amd) {
        define(function() {
          return pluralize3();
        });
      } else {
        root.pluralize = pluralize3();
      }
    })(exports, function() {
      var pluralRules = [];
      var singularRules = [];
      var uncountables = {};
      var irregularPlurals = {};
      var irregularSingles = {};
      function sanitizeRule(rule) {
        if (typeof rule === "string") {
          return new RegExp("^" + rule + "$", "i");
        }
        return rule;
      }
      __name(sanitizeRule, "sanitizeRule");
      function restoreCase(word, token) {
        if (word === token)
          return token;
        if (word === word.toLowerCase())
          return token.toLowerCase();
        if (word === word.toUpperCase())
          return token.toUpperCase();
        if (word[0] === word[0].toUpperCase()) {
          return token.charAt(0).toUpperCase() + token.substr(1).toLowerCase();
        }
        return token.toLowerCase();
      }
      __name(restoreCase, "restoreCase");
      function interpolate(str, args) {
        return str.replace(/\$(\d{1,2})/g, function(match, index) {
          return args[index] || "";
        });
      }
      __name(interpolate, "interpolate");
      function replace(word, rule) {
        return word.replace(rule[0], function(match, index) {
          var result = interpolate(rule[1], arguments);
          if (match === "") {
            return restoreCase(word[index - 1], result);
          }
          return restoreCase(match, result);
        });
      }
      __name(replace, "replace");
      function sanitizeWord(token, word, rules) {
        if (!token.length || uncountables.hasOwnProperty(token)) {
          return word;
        }
        var len = rules.length;
        while (len--) {
          var rule = rules[len];
          if (rule[0].test(word))
            return replace(word, rule);
        }
        return word;
      }
      __name(sanitizeWord, "sanitizeWord");
      function replaceWord(replaceMap, keepMap, rules) {
        return function(word) {
          var token = word.toLowerCase();
          if (keepMap.hasOwnProperty(token)) {
            return restoreCase(word, token);
          }
          if (replaceMap.hasOwnProperty(token)) {
            return restoreCase(word, replaceMap[token]);
          }
          return sanitizeWord(token, word, rules);
        };
      }
      __name(replaceWord, "replaceWord");
      function checkWord(replaceMap, keepMap, rules, bool) {
        return function(word) {
          var token = word.toLowerCase();
          if (keepMap.hasOwnProperty(token))
            return true;
          if (replaceMap.hasOwnProperty(token))
            return false;
          return sanitizeWord(token, token, rules) === token;
        };
      }
      __name(checkWord, "checkWord");
      function pluralize3(word, count, inclusive) {
        var pluralized = count === 1 ? pluralize3.singular(word) : pluralize3.plural(word);
        return (inclusive ? count + " " : "") + pluralized;
      }
      __name(pluralize3, "pluralize");
      pluralize3.plural = replaceWord(
        irregularSingles,
        irregularPlurals,
        pluralRules
      );
      pluralize3.isPlural = checkWord(
        irregularSingles,
        irregularPlurals,
        pluralRules
      );
      pluralize3.singular = replaceWord(
        irregularPlurals,
        irregularSingles,
        singularRules
      );
      pluralize3.isSingular = checkWord(
        irregularPlurals,
        irregularSingles,
        singularRules
      );
      pluralize3.addPluralRule = function(rule, replacement) {
        pluralRules.push([sanitizeRule(rule), replacement]);
      };
      pluralize3.addSingularRule = function(rule, replacement) {
        singularRules.push([sanitizeRule(rule), replacement]);
      };
      pluralize3.addUncountableRule = function(word) {
        if (typeof word === "string") {
          uncountables[word.toLowerCase()] = true;
          return;
        }
        pluralize3.addPluralRule(word, "$0");
        pluralize3.addSingularRule(word, "$0");
      };
      pluralize3.addIrregularRule = function(single, plural) {
        plural = plural.toLowerCase();
        single = single.toLowerCase();
        irregularSingles[single] = plural;
        irregularPlurals[plural] = single;
      };
      [
        ["I", "we"],
        ["me", "us"],
        ["he", "they"],
        ["she", "they"],
        ["them", "them"],
        ["myself", "ourselves"],
        ["yourself", "yourselves"],
        ["itself", "themselves"],
        ["herself", "themselves"],
        ["himself", "themselves"],
        ["themself", "themselves"],
        ["is", "are"],
        ["was", "were"],
        ["has", "have"],
        ["this", "these"],
        ["that", "those"],
        ["echo", "echoes"],
        ["dingo", "dingoes"],
        ["volcano", "volcanoes"],
        ["tornado", "tornadoes"],
        ["torpedo", "torpedoes"],
        ["genus", "genera"],
        ["viscus", "viscera"],
        ["stigma", "stigmata"],
        ["stoma", "stomata"],
        ["dogma", "dogmata"],
        ["lemma", "lemmata"],
        ["schema", "schemata"],
        ["anathema", "anathemata"],
        ["ox", "oxen"],
        ["axe", "axes"],
        ["die", "dice"],
        ["yes", "yeses"],
        ["foot", "feet"],
        ["eave", "eaves"],
        ["goose", "geese"],
        ["tooth", "teeth"],
        ["quiz", "quizzes"],
        ["human", "humans"],
        ["proof", "proofs"],
        ["carve", "carves"],
        ["valve", "valves"],
        ["looey", "looies"],
        ["thief", "thieves"],
        ["groove", "grooves"],
        ["pickaxe", "pickaxes"],
        ["passerby", "passersby"]
      ].forEach(function(rule) {
        return pluralize3.addIrregularRule(rule[0], rule[1]);
      });
      [
        [/s?$/i, "s"],
        [/[^\u0000-\u007F]$/i, "$0"],
        [/([^aeiou]ese)$/i, "$1"],
        [/(ax|test)is$/i, "$1es"],
        [/(alias|[^aou]us|t[lm]as|gas|ris)$/i, "$1es"],
        [/(e[mn]u)s?$/i, "$1s"],
        [/([^l]ias|[aeiou]las|[ejzr]as|[iu]am)$/i, "$1"],
        [/(alumn|syllab|vir|radi|nucle|fung|cact|stimul|termin|bacill|foc|uter|loc|strat)(?:us|i)$/i, "$1i"],
        [/(alumn|alg|vertebr)(?:a|ae)$/i, "$1ae"],
        [/(seraph|cherub)(?:im)?$/i, "$1im"],
        [/(her|at|gr)o$/i, "$1oes"],
        [/(agend|addend|millenni|dat|extrem|bacteri|desiderat|strat|candelabr|errat|ov|symposi|curricul|automat|quor)(?:a|um)$/i, "$1a"],
        [/(apheli|hyperbat|periheli|asyndet|noumen|phenomen|criteri|organ|prolegomen|hedr|automat)(?:a|on)$/i, "$1a"],
        [/sis$/i, "ses"],
        [/(?:(kni|wi|li)fe|(ar|l|ea|eo|oa|hoo)f)$/i, "$1$2ves"],
        [/([^aeiouy]|qu)y$/i, "$1ies"],
        [/([^ch][ieo][ln])ey$/i, "$1ies"],
        [/(x|ch|ss|sh|zz)$/i, "$1es"],
        [/(matr|cod|mur|sil|vert|ind|append)(?:ix|ex)$/i, "$1ices"],
        [/\b((?:tit)?m|l)(?:ice|ouse)$/i, "$1ice"],
        [/(pe)(?:rson|ople)$/i, "$1ople"],
        [/(child)(?:ren)?$/i, "$1ren"],
        [/eaux$/i, "$0"],
        [/m[ae]n$/i, "men"],
        ["thou", "you"]
      ].forEach(function(rule) {
        return pluralize3.addPluralRule(rule[0], rule[1]);
      });
      [
        [/s$/i, ""],
        [/(ss)$/i, "$1"],
        [/(wi|kni|(?:after|half|high|low|mid|non|night|[^\w]|^)li)ves$/i, "$1fe"],
        [/(ar|(?:wo|[ae])l|[eo][ao])ves$/i, "$1f"],
        [/ies$/i, "y"],
        [/\b([pl]|zomb|(?:neck|cross)?t|coll|faer|food|gen|goon|group|lass|talk|goal|cut)ies$/i, "$1ie"],
        [/\b(mon|smil)ies$/i, "$1ey"],
        [/\b((?:tit)?m|l)ice$/i, "$1ouse"],
        [/(seraph|cherub)im$/i, "$1"],
        [/(x|ch|ss|sh|zz|tto|go|cho|alias|[^aou]us|t[lm]as|gas|(?:her|at|gr)o|[aeiou]ris)(?:es)?$/i, "$1"],
        [/(analy|diagno|parenthe|progno|synop|the|empha|cri|ne)(?:sis|ses)$/i, "$1sis"],
        [/(movie|twelve|abuse|e[mn]u)s$/i, "$1"],
        [/(test)(?:is|es)$/i, "$1is"],
        [/(alumn|syllab|vir|radi|nucle|fung|cact|stimul|termin|bacill|foc|uter|loc|strat)(?:us|i)$/i, "$1us"],
        [/(agend|addend|millenni|dat|extrem|bacteri|desiderat|strat|candelabr|errat|ov|symposi|curricul|quor)a$/i, "$1um"],
        [/(apheli|hyperbat|periheli|asyndet|noumen|phenomen|criteri|organ|prolegomen|hedr|automat)a$/i, "$1on"],
        [/(alumn|alg|vertebr)ae$/i, "$1a"],
        [/(cod|mur|sil|vert|ind)ices$/i, "$1ex"],
        [/(matr|append)ices$/i, "$1ix"],
        [/(pe)(rson|ople)$/i, "$1rson"],
        [/(child)ren$/i, "$1"],
        [/(eau)x?$/i, "$1"],
        [/men$/i, "man"]
      ].forEach(function(rule) {
        return pluralize3.addSingularRule(rule[0], rule[1]);
      });
      [
        "adulthood",
        "advice",
        "agenda",
        "aid",
        "aircraft",
        "alcohol",
        "ammo",
        "analytics",
        "anime",
        "athletics",
        "audio",
        "bison",
        "blood",
        "bream",
        "buffalo",
        "butter",
        "carp",
        "cash",
        "chassis",
        "chess",
        "clothing",
        "cod",
        "commerce",
        "cooperation",
        "corps",
        "debris",
        "diabetes",
        "digestion",
        "elk",
        "energy",
        "equipment",
        "excretion",
        "expertise",
        "firmware",
        "flounder",
        "fun",
        "gallows",
        "garbage",
        "graffiti",
        "hardware",
        "headquarters",
        "health",
        "herpes",
        "highjinks",
        "homework",
        "housework",
        "information",
        "jeans",
        "justice",
        "kudos",
        "labour",
        "literature",
        "machinery",
        "mackerel",
        "mail",
        "media",
        "mews",
        "moose",
        "music",
        "mud",
        "manga",
        "news",
        "only",
        "personnel",
        "pike",
        "plankton",
        "pliers",
        "police",
        "pollution",
        "premises",
        "rain",
        "research",
        "rice",
        "salmon",
        "scissors",
        "series",
        "sewage",
        "shambles",
        "shrimp",
        "software",
        "species",
        "staff",
        "swine",
        "tennis",
        "traffic",
        "transportation",
        "trout",
        "tuna",
        "wealth",
        "welfare",
        "whiting",
        "wildebeest",
        "wildlife",
        "you",
        /pok[eé]mon$/i,
        /[^aeiou]ese$/i,
        /deer$/i,
        /fish$/i,
        /measles$/i,
        /o[iu]s$/i,
        /pox$/i,
        /sheep$/i
      ].forEach(pluralize3.addUncountableRule);
      return pluralize3;
    });
  }
});

// ../../node_modules/.pnpm/js-levenshtein@1.1.6/node_modules/js-levenshtein/index.js
var require_js_levenshtein = __commonJS({
  "../../node_modules/.pnpm/js-levenshtein@1.1.6/node_modules/js-levenshtein/index.js"(exports, module2) {
    "use strict";
    module2.exports = function() {
      function _min(d0, d1, d2, bx, ay) {
        return d0 < d1 || d2 < d1 ? d0 > d2 ? d2 + 1 : d0 + 1 : bx === ay ? d1 : d1 + 1;
      }
      __name(_min, "_min");
      return function(a, b2) {
        if (a === b2) {
          return 0;
        }
        if (a.length > b2.length) {
          var tmp = a;
          a = b2;
          b2 = tmp;
        }
        var la = a.length;
        var lb = b2.length;
        while (la > 0 && a.charCodeAt(la - 1) === b2.charCodeAt(lb - 1)) {
          la--;
          lb--;
        }
        var offset = 0;
        while (offset < la && a.charCodeAt(offset) === b2.charCodeAt(offset)) {
          offset++;
        }
        la -= offset;
        lb -= offset;
        if (la === 0 || lb < 3) {
          return lb;
        }
        var x = 0;
        var y2;
        var d0;
        var d1;
        var d2;
        var d3;
        var dd;
        var dy;
        var ay;
        var bx0;
        var bx1;
        var bx2;
        var bx3;
        var vector = [];
        for (y2 = 0; y2 < la; y2++) {
          vector.push(y2 + 1);
          vector.push(a.charCodeAt(offset + y2));
        }
        var len = vector.length - 1;
        for (; x < lb - 3; ) {
          bx0 = b2.charCodeAt(offset + (d0 = x));
          bx1 = b2.charCodeAt(offset + (d1 = x + 1));
          bx2 = b2.charCodeAt(offset + (d2 = x + 2));
          bx3 = b2.charCodeAt(offset + (d3 = x + 3));
          dd = x += 4;
          for (y2 = 0; y2 < len; y2 += 2) {
            dy = vector[y2];
            ay = vector[y2 + 1];
            d0 = _min(dy, d0, d1, bx0, ay);
            d1 = _min(d0, d1, d2, bx1, ay);
            d2 = _min(d1, d2, d3, bx2, ay);
            dd = _min(d2, d3, dd, bx3, ay);
            vector[y2] = dd;
            d3 = d2;
            d2 = d1;
            d1 = d0;
            d0 = dy;
          }
        }
        for (; x < lb; ) {
          bx0 = b2.charCodeAt(offset + (d0 = x));
          dd = ++x;
          for (y2 = 0; y2 < len; y2 += 2) {
            dy = vector[y2];
            vector[y2] = dd = _min(dy, d0, dd, bx0, vector[y2 + 1]);
            d0 = dy;
          }
        }
        return dd;
      };
    }();
  }
});

// ../../node_modules/.pnpm/path-exists@3.0.0/node_modules/path-exists/index.js
var require_path_exists3 = __commonJS({
  "../../node_modules/.pnpm/path-exists@3.0.0/node_modules/path-exists/index.js"(exports, module2) {
    "use strict";
    var fs11 = require("fs");
    module2.exports = (fp) => new Promise((resolve) => {
      fs11.access(fp, (err) => {
        resolve(!err);
      });
    });
    module2.exports.sync = (fp) => {
      try {
        fs11.accessSync(fp);
        return true;
      } catch (err) {
        return false;
      }
    };
  }
});

// ../../node_modules/.pnpm/p-locate@3.0.0/node_modules/p-locate/index.js
var require_p_locate3 = __commonJS({
  "../../node_modules/.pnpm/p-locate@3.0.0/node_modules/p-locate/index.js"(exports, module2) {
    "use strict";
    var pLimit = require_p_limit2();
    var EndError = class extends Error {
      constructor(value) {
        super();
        this.value = value;
      }
    };
    __name(EndError, "EndError");
    var testElement = /* @__PURE__ */ __name((el, tester) => Promise.resolve(el).then(tester), "testElement");
    var finder = /* @__PURE__ */ __name((el) => Promise.all(el).then((val) => val[1] === true && Promise.reject(new EndError(val[0]))), "finder");
    module2.exports = (iterable, tester, opts) => {
      opts = Object.assign({
        concurrency: Infinity,
        preserveOrder: true
      }, opts);
      const limit = pLimit(opts.concurrency);
      const items = [...iterable].map((el) => [el, limit(testElement, el, tester)]);
      const checkLimit = pLimit(opts.preserveOrder ? 1 : Infinity);
      return Promise.all(items.map((el) => checkLimit(finder, el))).then(() => {
      }).catch((err) => err instanceof EndError ? err.value : Promise.reject(err));
    };
  }
});

// ../../node_modules/.pnpm/locate-path@3.0.0/node_modules/locate-path/index.js
var require_locate_path3 = __commonJS({
  "../../node_modules/.pnpm/locate-path@3.0.0/node_modules/locate-path/index.js"(exports, module2) {
    "use strict";
    var path9 = require("path");
    var pathExists = require_path_exists3();
    var pLocate = require_p_locate3();
    module2.exports = (iterable, options2) => {
      options2 = Object.assign({
        cwd: process.cwd()
      }, options2);
      return pLocate(iterable, (el) => pathExists(path9.resolve(options2.cwd, el)), options2);
    };
    module2.exports.sync = (iterable, options2) => {
      options2 = Object.assign({
        cwd: process.cwd()
      }, options2);
      for (const el of iterable) {
        if (pathExists.sync(path9.resolve(options2.cwd, el))) {
          return el;
        }
      }
    };
  }
});

// ../../node_modules/.pnpm/find-up@3.0.0/node_modules/find-up/index.js
var require_find_up3 = __commonJS({
  "../../node_modules/.pnpm/find-up@3.0.0/node_modules/find-up/index.js"(exports, module2) {
    "use strict";
    var path9 = require("path");
    var locatePath = require_locate_path3();
    module2.exports = (filename, opts = {}) => {
      const startDir = path9.resolve(opts.cwd || "");
      const { root } = path9.parse(startDir);
      const filenames = [].concat(filename);
      return new Promise((resolve) => {
        (/* @__PURE__ */ __name(function find(dir2) {
          locatePath(filenames, { cwd: dir2 }).then((file2) => {
            if (file2) {
              resolve(path9.join(dir2, file2));
            } else if (dir2 === root) {
              resolve(null);
            } else {
              find(path9.dirname(dir2));
            }
          });
        }, "find"))(startDir);
      });
    };
    module2.exports.sync = (filename, opts = {}) => {
      let dir2 = path9.resolve(opts.cwd || "");
      const { root } = path9.parse(dir2);
      const filenames = [].concat(filename);
      while (true) {
        const file2 = locatePath.sync(filenames, { cwd: dir2 });
        if (file2) {
          return path9.join(dir2, file2);
        }
        if (dir2 === root) {
          return null;
        }
        dir2 = path9.dirname(dir2);
      }
    };
  }
});

// ../../node_modules/.pnpm/pkg-up@3.1.0/node_modules/pkg-up/index.js
var require_pkg_up = __commonJS({
  "../../node_modules/.pnpm/pkg-up@3.1.0/node_modules/pkg-up/index.js"(exports, module2) {
    "use strict";
    var findUp2 = require_find_up3();
    module2.exports = async ({ cwd } = {}) => findUp2("package.json", { cwd });
    module2.exports.sync = ({ cwd } = {}) => findUp2.sync("package.json", { cwd });
  }
});

// package.json
var require_package3 = __commonJS({
  "package.json"(exports, module2) {
    module2.exports = {
      name: "@prisma/client",
      version: "4.11.0",
      description: "Prisma Client is an auto-generated, type-safe and modern JavaScript/TypeScript ORM for Node.js that's tailored to your data. Supports MySQL, PostgreSQL, MariaDB, SQLite databases.",
      keywords: [
        "orm",
        "prisma2",
        "prisma",
        "client",
        "query",
        "database",
        "sql",
        "postgres",
        "postgresql",
        "mysql",
        "sqlite",
        "mariadb",
        "mssql",
        "typescript",
        "query-builder"
      ],
      main: "index.js",
      browser: "index-browser.js",
      types: "index.d.ts",
      license: "Apache-2.0",
      engines: {
        node: ">=14.17"
      },
      homepage: "https://www.prisma.io",
      repository: {
        type: "git",
        url: "https://github.com/prisma/prisma.git",
        directory: "packages/client"
      },
      author: "Tim Suchanek <suchanek@prisma.io>",
      bugs: "https://github.com/prisma/prisma/issues",
      scripts: {
        dev: "DEV=true node -r esbuild-register helpers/build.ts",
        build: "node -r esbuild-register helpers/build.ts",
        test: "jest --verbose",
        "test:e2e": "node -r esbuild-register tests/e2e/_utils/run.ts",
        "test:functional": "node -r esbuild-register helpers/functional-test/run-tests.ts",
        "test:memory": "node -r esbuild-register helpers/memory-tests.ts",
        "test:functional:code": "node -r esbuild-register helpers/functional-test/run-tests.ts --no-types",
        "test:functional:types": "node -r esbuild-register helpers/functional-test/run-tests.ts --types-only",
        "test-notypes": "jest --verbose --testPathIgnorePatterns src/__tests__/types/types.test.ts",
        generate: "node scripts/postinstall.js",
        postinstall: "node scripts/postinstall.js",
        prepublishOnly: "pnpm run build",
        "new-test": "NODE_OPTIONS='-r ts-node/register' yo ./helpers/generator-test/index.ts"
      },
      files: [
        "README.md",
        "runtime",
        "!runtime/*.map",
        "scripts",
        "generator-build",
        "edge.js",
        "edge.d.ts",
        "index.js",
        "index.d.ts",
        "index-browser.js"
      ],
      devDependencies: {
        "@faker-js/faker": "7.6.0",
        "@fast-check/jest": "1.6.0",
        "@jest/globals": "29.4.1",
        "@jest/test-sequencer": "29.4.1",
        "@opentelemetry/api": "1.4.0",
        "@opentelemetry/context-async-hooks": "1.9.1",
        "@opentelemetry/instrumentation": "0.35.1",
        "@opentelemetry/resources": "1.9.1",
        "@opentelemetry/sdk-trace-base": "1.9.1",
        "@opentelemetry/semantic-conventions": "1.9.1",
        "@prisma/debug": "workspace:*",
        "@prisma/engine-core": "workspace:*",
        "@prisma/engines": "workspace:*",
        "@prisma/fetch-engine": "workspace:*",
        "@prisma/generator-helper": "workspace:*",
        "@prisma/get-platform": "workspace:*",
        "@prisma/instrumentation": "workspace:*",
        "@prisma/internals": "workspace:*",
        "@prisma/migrate": "workspace:*",
        "@prisma/mini-proxy": "0.6.4",
        "@swc-node/register": "1.5.5",
        "@swc/core": "1.3.32",
        "@swc/jest": "0.2.24",
        "@timsuchanek/copy": "1.4.5",
        "@types/debug": "4.1.7",
        "@types/fs-extra": "9.0.13",
        "@types/jest": "29.4.0",
        "@types/js-levenshtein": "1.1.1",
        "@types/mssql": "8.1.2",
        "@types/node": "14.18.36",
        "@types/pg": "8.6.6",
        "@types/yeoman-generator": "5.2.11",
        arg: "5.0.2",
        benchmark: "2.1.4",
        chalk: "4.1.2",
        "decimal.js": "10.4.3",
        esbuild: "0.15.13",
        execa: "5.1.1",
        "expect-type": "0.15.0",
        "flat-map-polyfill": "0.3.8",
        "fs-extra": "11.1.0",
        "fs-monkey": "1.0.3",
        "get-own-enumerable-property-symbols": "3.0.2",
        globby: "11.1.0",
        "indent-string": "4.0.0",
        "is-obj": "2.0.0",
        "is-regexp": "2.1.0",
        jest: "29.4.1",
        "jest-junit": "15.0.0",
        "jest-snapshot": "29.4.1",
        "js-levenshtein": "1.1.6",
        klona: "2.0.6",
        "lz-string": "1.4.4",
        mariadb: "3.0.2",
        memfs: "3.4.13",
        mssql: "9.1.1",
        "node-fetch": "2.6.9",
        pg: "8.9.0",
        "pkg-up": "3.1.0",
        pluralize: "8.0.0",
        resolve: "1.22.1",
        rimraf: "3.0.2",
        "simple-statistics": "7.8.2",
        "sort-keys": "4.2.0",
        "source-map-support": "0.5.21",
        "sql-template-tag": "5.0.3",
        "stacktrace-parser": "0.1.10",
        "strip-ansi": "6.0.1",
        "strip-indent": "3.0.0",
        "ts-jest": "29.0.5",
        "ts-node": "10.9.1",
        "ts-pattern": "4.1.3",
        tsd: "0.21.0",
        typescript: "4.9.5",
        "yeoman-generator": "5.7.0",
        yo: "4.3.1",
        zx: "7.1.1"
      },
      peerDependencies: {
        prisma: "*"
      },
      peerDependenciesMeta: {
        prisma: {
          optional: true
        }
      },
      dependencies: {
        "@prisma/engines-version": "4.11.0-57.8fde8fef4033376662cad983758335009d522acb"
      },
      sideEffects: false
    };
  }
});

// ../../node_modules/.pnpm/flat-map-polyfill@0.3.8/node_modules/flat-map-polyfill/dist/cjs/array-species-create.js
var require_array_species_create = __commonJS({
  "../../node_modules/.pnpm/flat-map-polyfill@0.3.8/node_modules/flat-map-polyfill/dist/cjs/array-species-create.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function(obj) {
      return typeof obj;
    } : function(obj) {
      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
    };
    exports.default = arraySpeciesCreate;
    function arraySpeciesCreate(originalArray, length) {
      var isArray = Array.isArray(originalArray);
      if (!isArray) {
        return Array(length);
      }
      var C = Object.getPrototypeOf(originalArray).constructor;
      if (C) {
        if ((typeof C === "undefined" ? "undefined" : _typeof(C)) === "object" || typeof C === "function") {
          C = C[Symbol.species.toString()];
          C = C !== null ? C : void 0;
        }
        if (C === void 0) {
          return Array(length);
        }
        if (typeof C !== "function") {
          throw TypeError("invalid constructor");
        }
        var result = new C(length);
        return result;
      }
    }
    __name(arraySpeciesCreate, "arraySpeciesCreate");
  }
});

// ../../node_modules/.pnpm/flat-map-polyfill@0.3.8/node_modules/flat-map-polyfill/dist/cjs/flatten-into-array.js
var require_flatten_into_array = __commonJS({
  "../../node_modules/.pnpm/flat-map-polyfill@0.3.8/node_modules/flat-map-polyfill/dist/cjs/flatten-into-array.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = flattenIntoArray;
    function flattenIntoArray(target, source, start, depth, mapperFunction, thisArg) {
      var mapperFunctionProvied = mapperFunction !== void 0;
      var targetIndex = start;
      var sourceIndex = 0;
      var sourceLen = source.length;
      while (sourceIndex < sourceLen) {
        var p2 = sourceIndex;
        var exists4 = !!source[p2];
        if (exists4 === true) {
          var element = source[p2];
          if (element) {
            if (mapperFunctionProvied) {
              element = mapperFunction.call(thisArg, element, sourceIndex, target);
            }
            var spreadable = Object.getOwnPropertySymbols(element).includes(Symbol.isConcatSpreadable) || Array.isArray(element);
            if (spreadable === true && depth > 0) {
              var nextIndex = flattenIntoArray(target, element, targetIndex, depth - 1);
              targetIndex = nextIndex;
            } else {
              if (!Number.isSafeInteger(targetIndex)) {
                throw TypeError();
              }
              target[targetIndex] = element;
            }
          }
        }
        targetIndex += 1;
        sourceIndex += 1;
      }
      return targetIndex;
    }
    __name(flattenIntoArray, "flattenIntoArray");
  }
});

// ../../node_modules/.pnpm/flat-map-polyfill@0.3.8/node_modules/flat-map-polyfill/dist/cjs/flatten.js
var require_flatten = __commonJS({
  "../../node_modules/.pnpm/flat-map-polyfill@0.3.8/node_modules/flat-map-polyfill/dist/cjs/flatten.js"() {
    "use strict";
    var _arraySpeciesCreate = require_array_species_create();
    var _arraySpeciesCreate2 = _interopRequireDefault(_arraySpeciesCreate);
    var _flattenIntoArray = require_flatten_into_array();
    var _flattenIntoArray2 = _interopRequireDefault(_flattenIntoArray);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    __name(_interopRequireDefault, "_interopRequireDefault");
    if (!Object.prototype.hasOwnProperty.call(Array.prototype, "flatten")) {
      Array.prototype.flatten = /* @__PURE__ */ __name(function flatten(depth) {
        var o = Object(this);
        var a = (0, _arraySpeciesCreate2.default)(o, this.length);
        var depthNum = depth !== void 0 ? Number(depth) : Infinity;
        (0, _flattenIntoArray2.default)(a, o, 0, depthNum);
        return a.filter(function(e2) {
          return e2 !== void 0;
        });
      }, "flatten");
    }
  }
});

// ../../node_modules/.pnpm/flat-map-polyfill@0.3.8/node_modules/flat-map-polyfill/dist/cjs/flat-map.js
var require_flat_map = __commonJS({
  "../../node_modules/.pnpm/flat-map-polyfill@0.3.8/node_modules/flat-map-polyfill/dist/cjs/flat-map.js"() {
    "use strict";
    var _flattenIntoArray = require_flatten_into_array();
    var _flattenIntoArray2 = _interopRequireDefault(_flattenIntoArray);
    var _arraySpeciesCreate = require_array_species_create();
    var _arraySpeciesCreate2 = _interopRequireDefault(_arraySpeciesCreate);
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    __name(_interopRequireDefault, "_interopRequireDefault");
    if (!Object.prototype.hasOwnProperty.call(Array.prototype, "flatMap")) {
      Array.prototype.flatMap = /* @__PURE__ */ __name(function flatMap(callbackFn, thisArg) {
        var o = Object(this);
        if (!callbackFn || typeof callbackFn.call !== "function") {
          throw TypeError("callbackFn must be callable.");
        }
        var t3 = thisArg !== void 0 ? thisArg : void 0;
        var a = (0, _arraySpeciesCreate2.default)(o, o.length);
        (0, _flattenIntoArray2.default)(
          a,
          o,
          0,
          1,
          callbackFn,
          t3
        );
        return a.filter(function(x) {
          return x !== void 0;
        }, a);
      }, "flatMap");
    }
  }
});

// ../../node_modules/.pnpm/lz-string@1.4.4/node_modules/lz-string/libs/lz-string.js
var require_lz_string = __commonJS({
  "../../node_modules/.pnpm/lz-string@1.4.4/node_modules/lz-string/libs/lz-string.js"(exports, module2) {
    var LZString = function() {
      var f = String.fromCharCode;
      var keyStrBase64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
      var keyStrUriSafe = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-$";
      var baseReverseDic = {};
      function getBaseValue(alphabet, character) {
        if (!baseReverseDic[alphabet]) {
          baseReverseDic[alphabet] = {};
          for (var i = 0; i < alphabet.length; i++) {
            baseReverseDic[alphabet][alphabet.charAt(i)] = i;
          }
        }
        return baseReverseDic[alphabet][character];
      }
      __name(getBaseValue, "getBaseValue");
      var LZString2 = {
        compressToBase64: function(input) {
          if (input == null)
            return "";
          var res = LZString2._compress(input, 6, function(a) {
            return keyStrBase64.charAt(a);
          });
          switch (res.length % 4) {
            default:
            case 0:
              return res;
            case 1:
              return res + "===";
            case 2:
              return res + "==";
            case 3:
              return res + "=";
          }
        },
        decompressFromBase64: function(input) {
          if (input == null)
            return "";
          if (input == "")
            return null;
          return LZString2._decompress(input.length, 32, function(index) {
            return getBaseValue(keyStrBase64, input.charAt(index));
          });
        },
        compressToUTF16: function(input) {
          if (input == null)
            return "";
          return LZString2._compress(input, 15, function(a) {
            return f(a + 32);
          }) + " ";
        },
        decompressFromUTF16: function(compressed) {
          if (compressed == null)
            return "";
          if (compressed == "")
            return null;
          return LZString2._decompress(compressed.length, 16384, function(index) {
            return compressed.charCodeAt(index) - 32;
          });
        },
        compressToUint8Array: function(uncompressed) {
          var compressed = LZString2.compress(uncompressed);
          var buf = new Uint8Array(compressed.length * 2);
          for (var i = 0, TotalLen = compressed.length; i < TotalLen; i++) {
            var current_value = compressed.charCodeAt(i);
            buf[i * 2] = current_value >>> 8;
            buf[i * 2 + 1] = current_value % 256;
          }
          return buf;
        },
        decompressFromUint8Array: function(compressed) {
          if (compressed === null || compressed === void 0) {
            return LZString2.decompress(compressed);
          } else {
            var buf = new Array(compressed.length / 2);
            for (var i = 0, TotalLen = buf.length; i < TotalLen; i++) {
              buf[i] = compressed[i * 2] * 256 + compressed[i * 2 + 1];
            }
            var result = [];
            buf.forEach(function(c) {
              result.push(f(c));
            });
            return LZString2.decompress(result.join(""));
          }
        },
        compressToEncodedURIComponent: function(input) {
          if (input == null)
            return "";
          return LZString2._compress(input, 6, function(a) {
            return keyStrUriSafe.charAt(a);
          });
        },
        decompressFromEncodedURIComponent: function(input) {
          if (input == null)
            return "";
          if (input == "")
            return null;
          input = input.replace(/ /g, "+");
          return LZString2._decompress(input.length, 32, function(index) {
            return getBaseValue(keyStrUriSafe, input.charAt(index));
          });
        },
        compress: function(uncompressed) {
          return LZString2._compress(uncompressed, 16, function(a) {
            return f(a);
          });
        },
        _compress: function(uncompressed, bitsPerChar, getCharFromInt) {
          if (uncompressed == null)
            return "";
          var i, value, context_dictionary = {}, context_dictionaryToCreate = {}, context_c = "", context_wc = "", context_w = "", context_enlargeIn = 2, context_dictSize = 3, context_numBits = 2, context_data = [], context_data_val = 0, context_data_position = 0, ii;
          for (ii = 0; ii < uncompressed.length; ii += 1) {
            context_c = uncompressed.charAt(ii);
            if (!Object.prototype.hasOwnProperty.call(context_dictionary, context_c)) {
              context_dictionary[context_c] = context_dictSize++;
              context_dictionaryToCreate[context_c] = true;
            }
            context_wc = context_w + context_c;
            if (Object.prototype.hasOwnProperty.call(context_dictionary, context_wc)) {
              context_w = context_wc;
            } else {
              if (Object.prototype.hasOwnProperty.call(context_dictionaryToCreate, context_w)) {
                if (context_w.charCodeAt(0) < 256) {
                  for (i = 0; i < context_numBits; i++) {
                    context_data_val = context_data_val << 1;
                    if (context_data_position == bitsPerChar - 1) {
                      context_data_position = 0;
                      context_data.push(getCharFromInt(context_data_val));
                      context_data_val = 0;
                    } else {
                      context_data_position++;
                    }
                  }
                  value = context_w.charCodeAt(0);
                  for (i = 0; i < 8; i++) {
                    context_data_val = context_data_val << 1 | value & 1;
                    if (context_data_position == bitsPerChar - 1) {
                      context_data_position = 0;
                      context_data.push(getCharFromInt(context_data_val));
                      context_data_val = 0;
                    } else {
                      context_data_position++;
                    }
                    value = value >> 1;
                  }
                } else {
                  value = 1;
                  for (i = 0; i < context_numBits; i++) {
                    context_data_val = context_data_val << 1 | value;
                    if (context_data_position == bitsPerChar - 1) {
                      context_data_position = 0;
                      context_data.push(getCharFromInt(context_data_val));
                      context_data_val = 0;
                    } else {
                      context_data_position++;
                    }
                    value = 0;
                  }
                  value = context_w.charCodeAt(0);
                  for (i = 0; i < 16; i++) {
                    context_data_val = context_data_val << 1 | value & 1;
                    if (context_data_position == bitsPerChar - 1) {
                      context_data_position = 0;
                      context_data.push(getCharFromInt(context_data_val));
                      context_data_val = 0;
                    } else {
                      context_data_position++;
                    }
                    value = value >> 1;
                  }
                }
                context_enlargeIn--;
                if (context_enlargeIn == 0) {
                  context_enlargeIn = Math.pow(2, context_numBits);
                  context_numBits++;
                }
                delete context_dictionaryToCreate[context_w];
              } else {
                value = context_dictionary[context_w];
                for (i = 0; i < context_numBits; i++) {
                  context_data_val = context_data_val << 1 | value & 1;
                  if (context_data_position == bitsPerChar - 1) {
                    context_data_position = 0;
                    context_data.push(getCharFromInt(context_data_val));
                    context_data_val = 0;
                  } else {
                    context_data_position++;
                  }
                  value = value >> 1;
                }
              }
              context_enlargeIn--;
              if (context_enlargeIn == 0) {
                context_enlargeIn = Math.pow(2, context_numBits);
                context_numBits++;
              }
              context_dictionary[context_wc] = context_dictSize++;
              context_w = String(context_c);
            }
          }
          if (context_w !== "") {
            if (Object.prototype.hasOwnProperty.call(context_dictionaryToCreate, context_w)) {
              if (context_w.charCodeAt(0) < 256) {
                for (i = 0; i < context_numBits; i++) {
                  context_data_val = context_data_val << 1;
                  if (context_data_position == bitsPerChar - 1) {
                    context_data_position = 0;
                    context_data.push(getCharFromInt(context_data_val));
                    context_data_val = 0;
                  } else {
                    context_data_position++;
                  }
                }
                value = context_w.charCodeAt(0);
                for (i = 0; i < 8; i++) {
                  context_data_val = context_data_val << 1 | value & 1;
                  if (context_data_position == bitsPerChar - 1) {
                    context_data_position = 0;
                    context_data.push(getCharFromInt(context_data_val));
                    context_data_val = 0;
                  } else {
                    context_data_position++;
                  }
                  value = value >> 1;
                }
              } else {
                value = 1;
                for (i = 0; i < context_numBits; i++) {
                  context_data_val = context_data_val << 1 | value;
                  if (context_data_position == bitsPerChar - 1) {
                    context_data_position = 0;
                    context_data.push(getCharFromInt(context_data_val));
                    context_data_val = 0;
                  } else {
                    context_data_position++;
                  }
                  value = 0;
                }
                value = context_w.charCodeAt(0);
                for (i = 0; i < 16; i++) {
                  context_data_val = context_data_val << 1 | value & 1;
                  if (context_data_position == bitsPerChar - 1) {
                    context_data_position = 0;
                    context_data.push(getCharFromInt(context_data_val));
                    context_data_val = 0;
                  } else {
                    context_data_position++;
                  }
                  value = value >> 1;
                }
              }
              context_enlargeIn--;
              if (context_enlargeIn == 0) {
                context_enlargeIn = Math.pow(2, context_numBits);
                context_numBits++;
              }
              delete context_dictionaryToCreate[context_w];
            } else {
              value = context_dictionary[context_w];
              for (i = 0; i < context_numBits; i++) {
                context_data_val = context_data_val << 1 | value & 1;
                if (context_data_position == bitsPerChar - 1) {
                  context_data_position = 0;
                  context_data.push(getCharFromInt(context_data_val));
                  context_data_val = 0;
                } else {
                  context_data_position++;
                }
                value = value >> 1;
              }
            }
            context_enlargeIn--;
            if (context_enlargeIn == 0) {
              context_enlargeIn = Math.pow(2, context_numBits);
              context_numBits++;
            }
          }
          value = 2;
          for (i = 0; i < context_numBits; i++) {
            context_data_val = context_data_val << 1 | value & 1;
            if (context_data_position == bitsPerChar - 1) {
              context_data_position = 0;
              context_data.push(getCharFromInt(context_data_val));
              context_data_val = 0;
            } else {
              context_data_position++;
            }
            value = value >> 1;
          }
          while (true) {
            context_data_val = context_data_val << 1;
            if (context_data_position == bitsPerChar - 1) {
              context_data.push(getCharFromInt(context_data_val));
              break;
            } else
              context_data_position++;
          }
          return context_data.join("");
        },
        decompress: function(compressed) {
          if (compressed == null)
            return "";
          if (compressed == "")
            return null;
          return LZString2._decompress(compressed.length, 32768, function(index) {
            return compressed.charCodeAt(index);
          });
        },
        _decompress: function(length, resetValue, getNextValue) {
          var dictionary = [], next, enlargeIn = 4, dictSize = 4, numBits = 3, entry = "", result = [], i, w2, bits, resb, maxpower, power, c, data = { val: getNextValue(0), position: resetValue, index: 1 };
          for (i = 0; i < 3; i += 1) {
            dictionary[i] = i;
          }
          bits = 0;
          maxpower = Math.pow(2, 2);
          power = 1;
          while (power != maxpower) {
            resb = data.val & data.position;
            data.position >>= 1;
            if (data.position == 0) {
              data.position = resetValue;
              data.val = getNextValue(data.index++);
            }
            bits |= (resb > 0 ? 1 : 0) * power;
            power <<= 1;
          }
          switch (next = bits) {
            case 0:
              bits = 0;
              maxpower = Math.pow(2, 8);
              power = 1;
              while (power != maxpower) {
                resb = data.val & data.position;
                data.position >>= 1;
                if (data.position == 0) {
                  data.position = resetValue;
                  data.val = getNextValue(data.index++);
                }
                bits |= (resb > 0 ? 1 : 0) * power;
                power <<= 1;
              }
              c = f(bits);
              break;
            case 1:
              bits = 0;
              maxpower = Math.pow(2, 16);
              power = 1;
              while (power != maxpower) {
                resb = data.val & data.position;
                data.position >>= 1;
                if (data.position == 0) {
                  data.position = resetValue;
                  data.val = getNextValue(data.index++);
                }
                bits |= (resb > 0 ? 1 : 0) * power;
                power <<= 1;
              }
              c = f(bits);
              break;
            case 2:
              return "";
          }
          dictionary[3] = c;
          w2 = c;
          result.push(c);
          while (true) {
            if (data.index > length) {
              return "";
            }
            bits = 0;
            maxpower = Math.pow(2, numBits);
            power = 1;
            while (power != maxpower) {
              resb = data.val & data.position;
              data.position >>= 1;
              if (data.position == 0) {
                data.position = resetValue;
                data.val = getNextValue(data.index++);
              }
              bits |= (resb > 0 ? 1 : 0) * power;
              power <<= 1;
            }
            switch (c = bits) {
              case 0:
                bits = 0;
                maxpower = Math.pow(2, 8);
                power = 1;
                while (power != maxpower) {
                  resb = data.val & data.position;
                  data.position >>= 1;
                  if (data.position == 0) {
                    data.position = resetValue;
                    data.val = getNextValue(data.index++);
                  }
                  bits |= (resb > 0 ? 1 : 0) * power;
                  power <<= 1;
                }
                dictionary[dictSize++] = f(bits);
                c = dictSize - 1;
                enlargeIn--;
                break;
              case 1:
                bits = 0;
                maxpower = Math.pow(2, 16);
                power = 1;
                while (power != maxpower) {
                  resb = data.val & data.position;
                  data.position >>= 1;
                  if (data.position == 0) {
                    data.position = resetValue;
                    data.val = getNextValue(data.index++);
                  }
                  bits |= (resb > 0 ? 1 : 0) * power;
                  power <<= 1;
                }
                dictionary[dictSize++] = f(bits);
                c = dictSize - 1;
                enlargeIn--;
                break;
              case 2:
                return result.join("");
            }
            if (enlargeIn == 0) {
              enlargeIn = Math.pow(2, numBits);
              numBits++;
            }
            if (dictionary[c]) {
              entry = dictionary[c];
            } else {
              if (c === dictSize) {
                entry = w2 + w2.charAt(0);
              } else {
                return null;
              }
            }
            result.push(entry);
            dictionary[dictSize++] = w2 + entry.charAt(0);
            enlargeIn--;
            w2 = entry;
            if (enlargeIn == 0) {
              enlargeIn = Math.pow(2, numBits);
              numBits++;
            }
          }
        }
      };
      return LZString2;
    }();
    if (typeof define === "function" && define.amd) {
      define(function() {
        return LZString;
      });
    } else if (typeof module2 !== "undefined" && module2 != null) {
      module2.exports = LZString;
    }
  }
});

// src/generation/ts-builders/KeyType.ts
var KeyType_exports = {};
__export(KeyType_exports, {
  KeyType: () => KeyType,
  keyType: () => keyType
});
function keyType(baseType, key) {
  return new KeyType(baseType, key);
}
var KeyType;
var init_KeyType = __esm({
  "src/generation/ts-builders/KeyType.ts"() {
    "use strict";
    init_TypeBuilder();
    KeyType = class extends TypeBuilder {
      constructor(baseType, key) {
        super();
        this.baseType = baseType;
        this.key = key;
      }
      write(writer) {
        this.baseType.writeIndexed(writer);
        writer.write("[").write(`"${this.key}"`).write("]");
      }
    };
    __name(KeyType, "KeyType");
    __name(keyType, "keyType");
  }
});

// src/generation/ts-builders/TypeBuilder.ts
var TypeBuilder;
var init_TypeBuilder = __esm({
  "src/generation/ts-builders/TypeBuilder.ts"() {
    "use strict";
    TypeBuilder = class {
      constructor() {
        this.needsParenthesisWhenIndexed = false;
      }
      subKey(key) {
        const { KeyType: KeyType2 } = (init_KeyType(), __toCommonJS(KeyType_exports));
        return new KeyType2(this, key);
      }
      writeIndexed(writer) {
        if (this.needsParenthesisWhenIndexed) {
          writer.write("(");
        }
        writer.write(this);
        if (this.needsParenthesisWhenIndexed) {
          writer.write(")");
        }
      }
    };
    __name(TypeBuilder, "TypeBuilder");
  }
});

// src/generation/generator.ts
var generator_exports = {};
__export(generator_exports, {
  dmmfToTypes: () => dmmfToTypes,
  externalToInternalDmmf: () => externalToInternalDmmf
});
module.exports = __toCommonJS(generator_exports);

// ../debug/src/index.ts
var import_debug = __toESM(require_src());
var MAX_LOGS = 100;
var debugArgsHistory = [];
if (typeof process !== "undefined" && typeof process.stderr?.write !== "function") {
  import_debug.default.log = console.debug ?? console.log;
}
function debugCall(namespace) {
  const debugNamespace = (0, import_debug.default)(namespace);
  const call = Object.assign((...args) => {
    debugNamespace.log = call.log;
    if (args.length !== 0) {
      debugArgsHistory.push([namespace, ...args]);
    }
    if (debugArgsHistory.length > MAX_LOGS) {
      debugArgsHistory.shift();
    }
    return debugNamespace("", ...args);
  }, debugNamespace);
  return call;
}
__name(debugCall, "debugCall");
var Debug = Object.assign(debugCall, import_debug.default);
var src_default = Debug;

// src/generation/generator.ts
var import_engines_version3 = __toESM(require_engines_version());

// ../generator-helper/src/dmmf.ts
var DMMF;
((DMMF2) => {
  let ModelAction;
  ((ModelAction2) => {
    ModelAction2["findUnique"] = "findUnique";
    ModelAction2["findUniqueOrThrow"] = "findUniqueOrThrow";
    ModelAction2["findFirst"] = "findFirst";
    ModelAction2["findFirstOrThrow"] = "findFirstOrThrow";
    ModelAction2["findMany"] = "findMany";
    ModelAction2["create"] = "create";
    ModelAction2["createMany"] = "createMany";
    ModelAction2["update"] = "update";
    ModelAction2["updateMany"] = "updateMany";
    ModelAction2["upsert"] = "upsert";
    ModelAction2["delete"] = "delete";
    ModelAction2["deleteMany"] = "deleteMany";
    ModelAction2["groupBy"] = "groupBy";
    ModelAction2["count"] = "count";
    ModelAction2["aggregate"] = "aggregate";
    ModelAction2["findRaw"] = "findRaw";
    ModelAction2["aggregateRaw"] = "aggregateRaw";
  })(ModelAction = DMMF2.ModelAction || (DMMF2.ModelAction = {}));
})(DMMF || (DMMF = {}));

// ../generator-helper/src/byline.ts
var import_stream = __toESM(require("stream"));
var import_util = __toESM(require("util"));
function byline(readStream, options2) {
  return createStream(readStream, options2);
}
__name(byline, "byline");
function createStream(readStream, options2) {
  if (readStream) {
    return createLineStream(readStream, options2);
  } else {
    return new LineStream(options2);
  }
}
__name(createStream, "createStream");
function createLineStream(readStream, options2) {
  if (!readStream) {
    throw new Error("expected readStream");
  }
  if (!readStream.readable) {
    throw new Error("readStream must be readable");
  }
  const ls = new LineStream(options2);
  readStream.pipe(ls);
  return ls;
}
__name(createLineStream, "createLineStream");
function LineStream(options2) {
  import_stream.default.Transform.call(this, options2);
  options2 = options2 || {};
  this._readableState.objectMode = true;
  this._lineBuffer = [];
  this._keepEmptyLines = options2.keepEmptyLines || false;
  this._lastChunkEndedWithCR = false;
  this.on("pipe", function(src) {
    if (!this.encoding) {
      if (src instanceof import_stream.default.Readable) {
        this.encoding = src._readableState.encoding;
      }
    }
  });
}
__name(LineStream, "LineStream");
import_util.default.inherits(LineStream, import_stream.default.Transform);
LineStream.prototype._transform = function(chunk, encoding, done) {
  encoding = encoding || "utf8";
  if (Buffer.isBuffer(chunk)) {
    if (encoding == "buffer") {
      chunk = chunk.toString();
      encoding = "utf8";
    } else {
      chunk = chunk.toString(encoding);
    }
  }
  this._chunkEncoding = encoding;
  const lines = chunk.split(/\r\n|\r|\n/g);
  if (this._lastChunkEndedWithCR && chunk[0] == "\n") {
    lines.shift();
  }
  if (this._lineBuffer.length > 0) {
    this._lineBuffer[this._lineBuffer.length - 1] += lines[0];
    lines.shift();
  }
  this._lastChunkEndedWithCR = chunk[chunk.length - 1] == "\r";
  this._lineBuffer = this._lineBuffer.concat(lines);
  this._pushBuffer(encoding, 1, done);
};
LineStream.prototype._pushBuffer = function(encoding, keep, done) {
  while (this._lineBuffer.length > keep) {
    const line = this._lineBuffer.shift();
    if (this._keepEmptyLines || line.length > 0) {
      if (!this.push(this._reencode(line, encoding))) {
        const self = this;
        setImmediate(function() {
          self._pushBuffer(encoding, keep, done);
        });
        return;
      }
    }
  }
  done();
};
LineStream.prototype._flush = function(done) {
  this._pushBuffer(this._chunkEncoding, 0, done);
};
LineStream.prototype._reencode = function(line, chunkEncoding) {
  if (this.encoding && this.encoding != chunkEncoding) {
    return Buffer.from(line, chunkEncoding).toString(this.encoding);
  } else if (this.encoding) {
    return line;
  } else {
    return Buffer.from(line, chunkEncoding);
  }
};

// ../generator-helper/src/generatorHandler.ts
function generatorHandler(handler) {
  byline(process.stdin).on("data", async (line) => {
    const json = JSON.parse(String(line));
    if (json.method === "generate" && json.params) {
      try {
        const result = await handler.onGenerate(json.params);
        respond({
          jsonrpc: "2.0",
          result,
          id: json.id
        });
      } catch (_e) {
        const e2 = _e;
        respond({
          jsonrpc: "2.0",
          error: {
            code: -32e3,
            message: e2.message,
            data: {
              stack: e2.stack
            }
          },
          id: json.id
        });
      }
    }
    if (json.method === "getManifest") {
      if (handler.onManifest) {
        try {
          const manifest = handler.onManifest(json.params);
          respond({
            jsonrpc: "2.0",
            result: {
              manifest
            },
            id: json.id
          });
        } catch (_e) {
          const e2 = _e;
          respond({
            jsonrpc: "2.0",
            error: {
              code: -32e3,
              message: e2.message,
              data: {
                stack: e2.stack
              }
            },
            id: json.id
          });
        }
      } else {
        respond({
          jsonrpc: "2.0",
          result: {
            manifest: null
          },
          id: json.id
        });
      }
    }
  });
  process.stdin.resume();
}
__name(generatorHandler, "generatorHandler");
function respond(response) {
  console.error(JSON.stringify(response));
}
__name(respond, "respond");

// ../internals/src/utils/getEnvPaths.ts
var import_find_up = __toESM(require_find_up());
var import_fs3 = __toESM(require("fs"));
var import_path2 = __toESM(require("path"));

// ../internals/src/cli/getSchema.ts
var import_chalk = __toESM(require_source());
var import_execa = __toESM(require_execa());
var import_fs = __toESM(require("fs"));
var import_path = __toESM(require("path"));
var import_read_pkg_up = __toESM(require_read_pkg_up());
var import_util2 = require("util");
var exists = (0, import_util2.promisify)(import_fs.default.exists);
var readFile = (0, import_util2.promisify)(import_fs.default.readFile);
function getSchemaPathFromPackageJsonSync(cwd) {
  const pkgJson = import_read_pkg_up.default.sync({ cwd });
  const schemaPathFromPkgJson = pkgJson?.packageJson?.prisma?.schema;
  if (!schemaPathFromPkgJson || !pkgJson) {
    return null;
  }
  if (typeof schemaPathFromPkgJson !== "string") {
    throw new Error(
      `Provided schema path \`${schemaPathFromPkgJson}\` from \`${import_path.default.relative(
        cwd,
        pkgJson.path
      )}\` must be of type string`
    );
  }
  const absoluteSchemaPath = import_path.default.isAbsolute(schemaPathFromPkgJson) ? schemaPathFromPkgJson : import_path.default.resolve(import_path.default.dirname(pkgJson.path), schemaPathFromPkgJson);
  if (import_fs.default.existsSync(absoluteSchemaPath) === false) {
    throw new Error(
      `Provided schema path \`${import_path.default.relative(cwd, absoluteSchemaPath)}\` from \`${import_path.default.relative(
        cwd,
        pkgJson.path
      )}\` doesn't exist.`
    );
  }
  return absoluteSchemaPath;
}
__name(getSchemaPathFromPackageJsonSync, "getSchemaPathFromPackageJsonSync");

// ../internals/src/utils/tryLoadEnvs.ts
var import_chalk2 = __toESM(require_source());
var import_dotenv = __toESM(require_main2());
var import_fs2 = __toESM(require("fs"));
var debug2 = src_default("prisma:tryLoadEnv");
function exists2(p2) {
  return Boolean(p2 && import_fs2.default.existsSync(p2));
}
__name(exists2, "exists");

// ../internals/src/utils/getEnvPaths.ts
var debug3 = src_default("prisma:loadEnv");
function getEnvPaths(schemaPath2, opts = { cwd: process.cwd() }) {
  const rootEnvPath = getProjectRootEnvPath({ cwd: opts.cwd }) ?? null;
  const schemaEnvPathFromArgs = schemaPathToEnvPath(schemaPath2);
  const schemaEnvPathFromPkgJson = schemaPathToEnvPath(readSchemaPathFromPkgJson());
  const schemaEnvPaths = [
    schemaEnvPathFromArgs,
    schemaEnvPathFromPkgJson,
    "./prisma/.env",
    "./.env"
  ];
  const schemaEnvPath = schemaEnvPaths.find(exists2);
  return { rootEnvPath, schemaEnvPath };
}
__name(getEnvPaths, "getEnvPaths");
function readSchemaPathFromPkgJson() {
  try {
    return getSchemaPathFromPackageJsonSync(process.cwd());
  } catch {
    return null;
  }
}
__name(readSchemaPathFromPkgJson, "readSchemaPathFromPkgJson");
function getProjectRootEnvPath(opts) {
  const pkgJsonPath = import_find_up.default.sync((dir2) => {
    const pkgPath = import_path2.default.join(dir2, "package.json");
    if (import_find_up.default.sync.exists(pkgPath)) {
      try {
        const pkg2 = JSON.parse(import_fs3.default.readFileSync(pkgPath, "utf8"));
        if (pkg2["name"] !== ".prisma/client") {
          debug3(`project root found at ${pkgPath}`);
          return pkgPath;
        }
      } catch (e2) {
        debug3(`skipping package.json at ${pkgPath}`);
      }
    }
    return void 0;
  }, opts);
  if (!pkgJsonPath) {
    return null;
  }
  const candidate = import_path2.default.join(import_path2.default.dirname(pkgJsonPath), ".env");
  if (!import_fs3.default.existsSync(candidate)) {
    return null;
  }
  return candidate;
}
__name(getProjectRootEnvPath, "getProjectRootEnvPath");
function schemaPathToEnvPath(schemaPath2) {
  if (!schemaPath2)
    return null;
  return import_path2.default.join(import_path2.default.dirname(schemaPath2), ".env");
}
__name(schemaPathToEnvPath, "schemaPathToEnvPath");

// ../internals/src/client/getClientEngineType.ts
var DEFAULT_CLIENT_ENGINE_TYPE = "library" /* Library */;
function getClientEngineType(generatorConfig) {
  const engineTypeFromEnvVar = getEngineTypeFromEnvVar();
  if (engineTypeFromEnvVar)
    return engineTypeFromEnvVar;
  if (generatorConfig?.config.engineType === "library" /* Library */) {
    return "library" /* Library */;
  } else if (generatorConfig?.config.engineType === "binary" /* Binary */) {
    return "binary" /* Binary */;
  } else {
    return DEFAULT_CLIENT_ENGINE_TYPE;
  }
}
__name(getClientEngineType, "getClientEngineType");
function getEngineTypeFromEnvVar() {
  const engineType = process.env.PRISMA_CLIENT_ENGINE_TYPE;
  if (engineType === "library" /* Library */) {
    return "library" /* Library */;
  } else if (engineType === "binary" /* Binary */) {
    return "binary" /* Binary */;
  } else {
    return void 0;
  }
}
__name(getEngineTypeFromEnvVar, "getEngineTypeFromEnvVar");

// ../internals/src/utils/parseEnvValue.ts
var import_chalk3 = __toESM(require_source());
function parseEnvValue(object) {
  if (object.fromEnvVar && object.fromEnvVar != "null") {
    const value = process.env[object.fromEnvVar];
    if (!value) {
      throw new Error(
        `Attempted to load provider value using \`env(${object.fromEnvVar})\` but it was not present. Please ensure that ${import_chalk3.default.dim(
          object.fromEnvVar
        )} is present in your Environment Variables`
      );
    }
    return value;
  }
  return object.value;
}
__name(parseEnvValue, "parseEnvValue");

// ../internals/src/client/getQueryEngineProtocol.ts
function getQueryEngineProtocol(generatorConfig) {
  const fromEnv = process.env.PRISMA_ENGINE_PROTOCOL;
  if (fromEnv === "json" || fromEnv == "graphql") {
    return fromEnv;
  }
  if (fromEnv !== void 0) {
    throw new Error(`Invalid PRISMA_ENGINE_PROTOCOL env variable value. Expected 'graphql' or 'json', got '${fromEnv}'`);
  }
  if (generatorConfig?.previewFeatures?.includes("jsonProtocol")) {
    return "json";
  }
  return "graphql";
}
__name(getQueryEngineProtocol, "getQueryEngineProtocol");

// ../../node_modules/.pnpm/fp-ts@2.13.1/node_modules/fp-ts/es6/internal.js
var left = /* @__PURE__ */ __name(function(e2) {
  return { _tag: "Left", left: e2 };
}, "left");
var right = /* @__PURE__ */ __name(function(a) {
  return { _tag: "Right", right: a };
}, "right");

// ../get-platform/src/getNodeAPIName.ts
var NODE_API_QUERY_ENGINE_URL_BASE = "libquery_engine";
function getNodeAPIName(platform, type) {
  const isUrl = type === "url";
  if (platform.includes("windows")) {
    return isUrl ? `query_engine.dll.node` : `query_engine-${platform}.dll.node`;
  } else if (platform.includes("darwin")) {
    return isUrl ? `${NODE_API_QUERY_ENGINE_URL_BASE}.dylib.node` : `${NODE_API_QUERY_ENGINE_URL_BASE}-${platform}.dylib.node`;
  } else {
    return isUrl ? `${NODE_API_QUERY_ENGINE_URL_BASE}.so.node` : `${NODE_API_QUERY_ENGINE_URL_BASE}-${platform}.so.node`;
  }
}
__name(getNodeAPIName, "getNodeAPIName");

// ../get-platform/src/getPlatform.ts
var import_child_process = __toESM(require("child_process"));
var import_fs4 = __toESM(require("fs"));
var import_os = __toESM(require("os"));

// ../../node_modules/.pnpm/ts-pattern@4.1.3/node_modules/ts-pattern/dist/index.module.js
var n = Symbol("@ts-pattern/matcher");
var t = "@ts-pattern/anonymous-select-key";
var e = /* @__PURE__ */ __name(function(n2) {
  return Boolean(n2 && "object" == typeof n2);
}, "e");
var r = /* @__PURE__ */ __name(function(t3) {
  return t3 && !!t3[n];
}, "r");
var u = /* @__PURE__ */ __name(function t2(u2, i, c) {
  if (e(u2)) {
    if (r(u2)) {
      var o = u2[n]().match(i), a = o.matched, f = o.selections;
      return a && f && Object.keys(f).forEach(function(n2) {
        return c(n2, f[n2]);
      }), a;
    }
    if (!e(i))
      return false;
    if (Array.isArray(u2))
      return !!Array.isArray(i) && u2.length === i.length && u2.every(function(n2, e2) {
        return t2(n2, i[e2], c);
      });
    if (u2 instanceof Map)
      return i instanceof Map && Array.from(u2.keys()).every(function(n2) {
        return t2(u2.get(n2), i.get(n2), c);
      });
    if (u2 instanceof Set) {
      if (!(i instanceof Set))
        return false;
      if (0 === u2.size)
        return 0 === i.size;
      if (1 === u2.size) {
        var s = Array.from(u2.values())[0];
        return r(s) ? Array.from(i.values()).every(function(n2) {
          return t2(s, n2, c);
        }) : i.has(s);
      }
      return Array.from(u2.values()).every(function(n2) {
        return i.has(n2);
      });
    }
    return Object.keys(u2).every(function(e2) {
      var o2, a2 = u2[e2];
      return (e2 in i || r(o2 = a2) && "optional" === o2[n]().matcherType) && t2(a2, i[e2], c);
    });
  }
  return Object.is(i, u2);
}, "t");
function h(t3) {
  var e2;
  return (e2 = {})[n] = function() {
    return { match: function(n2) {
      return { matched: Boolean(t3(n2)) };
    } };
  }, e2;
}
__name(h, "h");
var y = h(function(n2) {
  return true;
});
var d = h(function(n2) {
  return "string" == typeof n2;
});
var g = h(function(n2) {
  return "number" == typeof n2;
});
var p = h(function(n2) {
  return "boolean" == typeof n2;
});
var b = h(function(n2) {
  return "bigint" == typeof n2;
});
var w = h(function(n2) {
  return "symbol" == typeof n2;
});
var A = h(function(n2) {
  return null == n2;
});
var K = /* @__PURE__ */ __name(function(n2) {
  return new O(n2, []);
}, "K");
var O = /* @__PURE__ */ function() {
  function n2(n3, t3) {
    this.value = void 0, this.cases = void 0, this.value = n3, this.cases = t3;
  }
  __name(n2, "n");
  var e2 = n2.prototype;
  return e2.with = function() {
    var e3 = [].slice.call(arguments), r2 = e3[e3.length - 1], i = [e3[0]], c = [];
    return 3 === e3.length && "function" == typeof e3[1] ? (i.push(e3[0]), c.push(e3[1])) : e3.length > 2 && i.push.apply(i, e3.slice(1, e3.length - 1)), new n2(this.value, this.cases.concat([{ match: function(n3) {
      var e4 = {}, r3 = Boolean(i.some(function(t3) {
        return u(t3, n3, function(n4, t4) {
          e4[n4] = t4;
        });
      }) && c.every(function(t3) {
        return t3(n3);
      }));
      return { matched: r3, value: r3 && Object.keys(e4).length ? t in e4 ? e4[t] : e4 : n3 };
    }, handler: r2 }]));
  }, e2.when = function(t3, e3) {
    return new n2(this.value, this.cases.concat([{ match: function(n3) {
      return { matched: Boolean(t3(n3)), value: n3 };
    }, handler: e3 }]));
  }, e2.otherwise = function(t3) {
    return new n2(this.value, this.cases.concat([{ match: function(n3) {
      return { matched: true, value: n3 };
    }, handler: t3 }])).run();
  }, e2.exhaustive = function() {
    return this.run();
  }, e2.run = function() {
    for (var n3 = this.value, t3 = void 0, e3 = 0; e3 < this.cases.length; e3++) {
      var r2 = this.cases[e3], u2 = r2.match(this.value);
      if (u2.matched) {
        n3 = u2.value, t3 = r2.handler;
        break;
      }
    }
    if (!t3) {
      var i;
      try {
        i = JSON.stringify(this.value);
      } catch (n4) {
        i = this.value;
      }
      throw new Error("Pattern matching error: no pattern matches value " + i);
    }
    return t3(n3, this.value);
  }, n2;
}();

// ../get-platform/src/getPlatform.ts
var import_util3 = require("util");

// ../get-platform/src/link.ts
var import_chalk4 = __toESM(require_source());
var import_terminal_link = __toESM(require_terminal_link());
function link(url) {
  return (0, import_terminal_link.default)(url, url, {
    fallback: (url2) => import_chalk4.default.underline(url2)
  });
}
__name(link, "link");

// ../get-platform/src/logger.ts
var import_chalk5 = __toESM(require_source());
var tags = {
  warn: import_chalk5.default.yellow("prisma:warn")
};
var should = {
  warn: () => !process.env.PRISMA_DISABLE_WARNINGS
};
function warn(message, ...optionalParams) {
  if (should.warn()) {
    console.warn(`${tags.warn} ${message}`, ...optionalParams);
  }
}
__name(warn, "warn");

// ../get-platform/src/getPlatform.ts
var readFile2 = (0, import_util3.promisify)(import_fs4.default.readFile);
var exec = (0, import_util3.promisify)(import_child_process.default.exec);
var debug4 = src_default("prisma:get-platform");
var supportedLibSSLVersions = ["1.0.x", "1.1.x", "3.0.x"];
async function getos() {
  const platform = import_os.default.platform();
  const arch = process.arch;
  if (platform === "freebsd") {
    const version = await getFirstSuccessfulExec([`freebsd-version`]);
    if (version && version.trim().length > 0) {
      const regex = /^(\d+)\.?/;
      const match = regex.exec(version);
      if (match) {
        return {
          platform: "freebsd",
          targetDistro: `freebsd${match[1]}`,
          arch
        };
      }
    }
  }
  if (platform !== "linux") {
    return {
      platform,
      arch
    };
  }
  const distroInfo = await resolveDistro();
  const archFromUname = await getArchFromUname();
  const libsslSpecificPaths = computeLibSSLSpecificPaths({ arch, archFromUname, familyDistro: distroInfo.familyDistro });
  const { libssl } = await getSSLVersion(libsslSpecificPaths);
  return {
    platform: "linux",
    libssl,
    arch,
    archFromUname,
    ...distroInfo
  };
}
__name(getos, "getos");
function parseDistro(osReleaseInput) {
  const idRegex = /^ID="?([^"\n]*)"?$/im;
  const idLikeRegex = /^ID_LIKE="?([^"\n]*)"?$/im;
  const idMatch = idRegex.exec(osReleaseInput);
  const id = idMatch && idMatch[1] && idMatch[1].toLowerCase() || "";
  const idLikeMatch = idLikeRegex.exec(osReleaseInput);
  const idLike = idLikeMatch && idLikeMatch[1] && idLikeMatch[1].toLowerCase() || "";
  const distroInfo = K({ id, idLike }).with(
    { id: "alpine" },
    ({ id: originalDistro }) => ({
      targetDistro: "musl",
      familyDistro: originalDistro,
      originalDistro
    })
  ).with(
    { id: "raspbian" },
    ({ id: originalDistro }) => ({
      targetDistro: "arm",
      familyDistro: "debian",
      originalDistro
    })
  ).with(
    { id: "nixos" },
    ({ id: originalDistro }) => ({
      targetDistro: "nixos",
      originalDistro,
      familyDistro: "nixos"
    })
  ).with(
    { id: "debian" },
    { id: "ubuntu" },
    ({ id: originalDistro }) => ({
      targetDistro: "debian",
      familyDistro: "debian",
      originalDistro
    })
  ).with(
    { id: "rhel" },
    { id: "centos" },
    { id: "fedora" },
    ({ id: originalDistro }) => ({
      targetDistro: "rhel",
      familyDistro: "rhel",
      originalDistro
    })
  ).when(
    ({ idLike: idLike2 }) => idLike2.includes("debian") || idLike2.includes("ubuntu"),
    ({ id: originalDistro }) => ({
      targetDistro: "debian",
      familyDistro: "debian",
      originalDistro
    })
  ).when(
    ({ idLike: idLike2 }) => id === "arch" || idLike2.includes("arch"),
    ({ id: originalDistro }) => ({
      targetDistro: "debian",
      familyDistro: "arch",
      originalDistro
    })
  ).when(
    ({ idLike: idLike2 }) => idLike2.includes("centos") || idLike2.includes("fedora") || idLike2.includes("rhel") || idLike2.includes("suse"),
    ({ id: originalDistro }) => ({
      targetDistro: "rhel",
      familyDistro: "rhel",
      originalDistro
    })
  ).otherwise(({ id: originalDistro }) => {
    return {
      targetDistro: void 0,
      familyDistro: void 0,
      originalDistro
    };
  });
  debug4(`Found distro info:
${JSON.stringify(distroInfo, null, 2)}`);
  return distroInfo;
}
__name(parseDistro, "parseDistro");
async function resolveDistro() {
  const osReleaseFile = "/etc/os-release";
  try {
    const osReleaseInput = await readFile2(osReleaseFile, { encoding: "utf-8" });
    return parseDistro(osReleaseInput);
  } catch (_) {
    return {
      targetDistro: void 0,
      familyDistro: void 0,
      originalDistro: void 0
    };
  }
}
__name(resolveDistro, "resolveDistro");
function parseOpenSSLVersion(input) {
  const match = /^OpenSSL\s(\d+\.\d+)\.\d+/.exec(input);
  if (match) {
    const partialVersion = `${match[1]}.x`;
    return sanitiseSSLVersion(partialVersion);
  }
  return void 0;
}
__name(parseOpenSSLVersion, "parseOpenSSLVersion");
function parseLibSSLVersion(input) {
  const match = /libssl\.so\.(\d)(\.\d)?/.exec(input);
  if (match) {
    const partialVersion = `${match[1]}${match[2] ?? ".0"}.x`;
    return sanitiseSSLVersion(partialVersion);
  }
  return void 0;
}
__name(parseLibSSLVersion, "parseLibSSLVersion");
function sanitiseSSLVersion(version) {
  const sanitisedVersion = (() => {
    if (isLibssl1x(version)) {
      return version;
    }
    const versionSplit = version.split(".");
    versionSplit[1] = "0";
    return versionSplit.join(".");
  })();
  if (supportedLibSSLVersions.includes(sanitisedVersion)) {
    return sanitisedVersion;
  }
  return void 0;
}
__name(sanitiseSSLVersion, "sanitiseSSLVersion");
function computeLibSSLSpecificPaths(args) {
  return K(args).with({ familyDistro: "musl" }, () => {
    debug4('Trying platform-specific paths for "alpine"');
    return ["/lib"];
  }).with({ familyDistro: "debian" }, ({ archFromUname }) => {
    debug4('Trying platform-specific paths for "debian" (and "ubuntu")');
    return [`/usr/lib/${archFromUname}-linux-gnu`, `/lib/${archFromUname}-linux-gnu`];
  }).with({ familyDistro: "rhel" }, () => {
    debug4('Trying platform-specific paths for "rhel"');
    return ["/lib64", "/usr/lib64"];
  }).otherwise(({ familyDistro, arch, archFromUname }) => {
    debug4(`Don't know any platform-specific paths for "${familyDistro}" on ${arch} (${archFromUname})`);
    return [];
  });
}
__name(computeLibSSLSpecificPaths, "computeLibSSLSpecificPaths");
async function getSSLVersion(libsslSpecificPaths) {
  const excludeLibssl0x = 'grep -v "libssl.so.0"';
  const libsslSpecificCommands = libsslSpecificPaths.map(
    (path9) => `ls -v "libssl.so.0*" ${path9} | grep libssl.so | ${excludeLibssl0x}`
  );
  const libsslFilenameFromSpecificPath = await getFirstSuccessfulExec(libsslSpecificCommands);
  if (libsslFilenameFromSpecificPath) {
    debug4(`Found libssl.so file using platform-specific paths: ${libsslFilenameFromSpecificPath}`);
    const libsslVersion = parseLibSSLVersion(libsslFilenameFromSpecificPath);
    debug4(`The parsed libssl version is: ${libsslVersion}`);
    if (libsslVersion) {
      return { libssl: libsslVersion, strategy: "libssl-specific-path" };
    }
  }
  debug4('Falling back to "ldconfig" and other generic paths');
  const libsslFilename = await getFirstSuccessfulExec([
    `ldconfig -p | sed "s/.*=>s*//" | sed "s|.*/||" | grep libssl | sort | ${excludeLibssl0x}`,
    `ls /lib64 | grep libssl | ${excludeLibssl0x}`,
    `ls /usr/lib64 | grep libssl | ${excludeLibssl0x}`,
    `ls /lib | grep libssl | ${excludeLibssl0x}`
  ]);
  if (libsslFilename) {
    debug4(`Found libssl.so file using "ldconfig" or other generic paths: ${libsslFilename}`);
    const libsslVersion = parseLibSSLVersion(libsslFilename);
    if (libsslVersion) {
      return { libssl: libsslVersion, strategy: "ldconfig" };
    }
  }
  const openSSLVersionLine = await getFirstSuccessfulExec(["openssl version -v"]);
  if (openSSLVersionLine) {
    debug4(`Found openssl binary with version: ${openSSLVersionLine}`);
    const openSSLVersion = parseOpenSSLVersion(openSSLVersionLine);
    debug4(`The parsed openssl version is: ${openSSLVersion}`);
    if (openSSLVersion) {
      return { libssl: openSSLVersion, strategy: "openssl-binary" };
    }
  }
  debug4(`Couldn't find any version of libssl or OpenSSL in the system`);
  return {};
}
__name(getSSLVersion, "getSSLVersion");
async function getPlatform() {
  const { binaryTarget } = await getPlatformMemoized();
  return binaryTarget;
}
__name(getPlatform, "getPlatform");
function isPlatformWithOSResultDefined(args) {
  return args.binaryTarget !== void 0;
}
__name(isPlatformWithOSResultDefined, "isPlatformWithOSResultDefined");
async function getPlatformWithOSResult() {
  const { memoized: _, ...rest } = await getPlatformMemoized();
  return rest;
}
__name(getPlatformWithOSResult, "getPlatformWithOSResult");
var memoizedPlatformWithInfo = {};
async function getPlatformMemoized() {
  if (isPlatformWithOSResultDefined(memoizedPlatformWithInfo)) {
    return Promise.resolve({ ...memoizedPlatformWithInfo, memoized: true });
  }
  const args = await getos();
  const binaryTarget = getPlatformInternal(args);
  memoizedPlatformWithInfo = { ...args, binaryTarget };
  return { ...memoizedPlatformWithInfo, memoized: false };
}
__name(getPlatformMemoized, "getPlatformMemoized");
function getPlatformInternal(args) {
  const { platform, arch, archFromUname, libssl, targetDistro, familyDistro, originalDistro } = args;
  if (platform === "linux" && !["x64", "arm64"].includes(arch)) {
    warn(
      `Prisma only officially supports Linux on amd64 (x86_64) and arm64 (aarch64) system architectures. If you are using your own custom Prisma engines, you can ignore this warning, as long as you've compiled the engines for your system architecture "${archFromUname}".`
    );
  }
  const defaultLibssl = "1.1.x";
  if (platform === "linux" && libssl === void 0) {
    const additionalMessage = K({ familyDistro }).with({ familyDistro: "debian" }, () => {
      return "Please manually install OpenSSL via `apt-get update -y && apt-get install -y openssl` and try installing Prisma again. If you're running Prisma on Docker, you may also try to replace your base image with `node:lts-slim`, which already ships with OpenSSL installed.";
    }).otherwise(() => {
      return "Please manually install OpenSSL and try installing Prisma again.";
    });
    warn(
      `Prisma failed to detect the libssl/openssl version to use, and may not work as expected. Defaulting to "openssl-${defaultLibssl}".
${additionalMessage}`
    );
  }
  const defaultDistro = "debian";
  if (platform === "linux" && targetDistro === void 0) {
    warn(
      `Prisma doesn't know which engines to download for the Linux distro "${originalDistro}". Falling back to Prisma engines built "${defaultDistro}".
Please report your experience by creating an issue at ${link(
        "https://github.com/prisma/prisma/issues"
      )} so we can add your distro to the list of known supported distros.`
    );
  }
  if (platform === "darwin" && arch === "arm64") {
    return "darwin-arm64";
  }
  if (platform === "darwin") {
    return "darwin";
  }
  if (platform === "win32") {
    return "windows";
  }
  if (platform === "freebsd") {
    return targetDistro;
  }
  if (platform === "openbsd") {
    return "openbsd";
  }
  if (platform === "netbsd") {
    return "netbsd";
  }
  if (platform === "linux" && targetDistro === "nixos") {
    return "linux-nixos";
  }
  if (platform === "linux" && arch === "arm64") {
    const baseName = targetDistro === "musl" ? "linux-musl-arm64" : "linux-arm64";
    return `${baseName}-openssl-${libssl || defaultLibssl}`;
  }
  if (platform === "linux" && arch === "arm") {
    return `linux-arm-openssl-${libssl || defaultLibssl}`;
  }
  if (platform === "linux" && targetDistro === "musl") {
    const base = "linux-musl";
    if (!libssl) {
      return base;
    }
    if (isLibssl1x(libssl)) {
      return base;
    } else {
      return `${base}-openssl-${libssl}`;
    }
  }
  if (platform === "linux" && targetDistro && libssl) {
    return `${targetDistro}-openssl-${libssl}`;
  }
  if (platform !== "linux") {
    warn(`Prisma detected unknown OS "${platform}" and may not work as expected. Defaulting to "linux".`);
  }
  if (libssl) {
    return `${defaultDistro}-openssl-${libssl}`;
  }
  if (targetDistro) {
    return `${targetDistro}-openssl-${defaultLibssl}`;
  }
  return `${defaultDistro}-openssl-${defaultLibssl}`;
}
__name(getPlatformInternal, "getPlatformInternal");
async function discardError(runPromise) {
  try {
    return await runPromise();
  } catch (e2) {
    return void 0;
  }
}
__name(discardError, "discardError");
function getFirstSuccessfulExec(commands) {
  return discardError(async () => {
    const results = await Promise.allSettled(commands.map((cmd) => exec(cmd)));
    const idx = results.findIndex(({ status }) => status === "fulfilled");
    if (idx === -1) {
      return void 0;
    }
    const { value } = results[idx];
    const output = String(value.stdout);
    debug4(`Command "${commands[idx]}" successfully returned "${output}"`);
    return output;
  });
}
__name(getFirstSuccessfulExec, "getFirstSuccessfulExec");
async function getArchFromUname() {
  const arch = await getFirstSuccessfulExec(["uname -m"]);
  return arch?.trim();
}
__name(getArchFromUname, "getArchFromUname");
function isLibssl1x(libssl) {
  return libssl.startsWith("1.");
}
__name(isLibssl1x, "isLibssl1x");

// ../get-platform/src/isNodeAPISupported.ts
var import_fs5 = __toESM(require("fs"));
async function isNodeAPISupported() {
  const customLibraryPath = process.env.PRISMA_QUERY_ENGINE_LIBRARY;
  const customLibraryExists = customLibraryPath && import_fs5.default.existsSync(customLibraryPath);
  const os2 = await getos();
  if (!customLibraryExists && (os2.arch === "x32" || os2.arch === "ia32")) {
    throw new Error(
      `The default query engine type (Node-API, "library") is currently not supported for 32bit Node. Please set \`engineType = "binary"\` in the "generator" block of your "schema.prisma" file (or use the environment variables "PRISMA_CLIENT_ENGINE_TYPE=binary" and/or "PRISMA_CLI_QUERY_ENGINE_TYPE=binary".)`
    );
  }
}
__name(isNodeAPISupported, "isNodeAPISupported");

// ../fetch-engine/src/utils.ts
var import_find_cache_dir = __toESM(require_find_cache_dir());
var import_fs6 = __toESM(require("fs"));
var debug5 = src_default("prisma:cache-dir");
async function overwriteFile(sourcePath, targetPath) {
  await removeFileIfExists(targetPath);
  await import_fs6.default.promises.copyFile(sourcePath, targetPath);
}
__name(overwriteFile, "overwriteFile");
async function removeFileIfExists(filePath) {
  try {
    await import_fs6.default.promises.unlink(filePath);
  } catch (e2) {
    if (e2.code !== "ENOENT") {
      throw e2;
    }
  }
}
__name(removeFileIfExists, "removeFileIfExists");

// ../../node_modules/.pnpm/fp-ts@2.13.1/node_modules/fp-ts/es6/TaskEither.js
var __awaiter = function(thisArg, _arguments, P2, generator2) {
  function adopt(value) {
    return value instanceof P2 ? value : new P2(function(resolve) {
      resolve(value);
    });
  }
  __name(adopt, "adopt");
  return new (P2 || (P2 = Promise))(function(resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator2.next(value));
      } catch (e2) {
        reject(e2);
      }
    }
    __name(fulfilled, "fulfilled");
    function rejected(value) {
      try {
        step(generator2["throw"](value));
      } catch (e2) {
        reject(e2);
      }
    }
    __name(rejected, "rejected");
    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }
    __name(step, "step");
    step((generator2 = generator2.apply(thisArg, _arguments || [])).next());
  });
};
var __generator = function(thisArg, body) {
  var _ = { label: 0, sent: function() {
    if (t3[0] & 1)
      throw t3[1];
    return t3[1];
  }, trys: [], ops: [] }, f, y2, t3, g2;
  return g2 = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g2[Symbol.iterator] = function() {
    return this;
  }), g2;
  function verb(n2) {
    return function(v) {
      return step([n2, v]);
    };
  }
  __name(verb, "verb");
  function step(op) {
    if (f)
      throw new TypeError("Generator is already executing.");
    while (_)
      try {
        if (f = 1, y2 && (t3 = op[0] & 2 ? y2["return"] : op[0] ? y2["throw"] || ((t3 = y2["return"]) && t3.call(y2), 0) : y2.next) && !(t3 = t3.call(y2, op[1])).done)
          return t3;
        if (y2 = 0, t3)
          op = [op[0] & 2, t3.value];
        switch (op[0]) {
          case 0:
          case 1:
            t3 = op;
            break;
          case 4:
            _.label++;
            return { value: op[1], done: false };
          case 5:
            _.label++;
            y2 = op[1];
            op = [0];
            continue;
          case 7:
            op = _.ops.pop();
            _.trys.pop();
            continue;
          default:
            if (!(t3 = _.trys, t3 = t3.length > 0 && t3[t3.length - 1]) && (op[0] === 6 || op[0] === 2)) {
              _ = 0;
              continue;
            }
            if (op[0] === 3 && (!t3 || op[1] > t3[0] && op[1] < t3[3])) {
              _.label = op[1];
              break;
            }
            if (op[0] === 6 && _.label < t3[1]) {
              _.label = t3[1];
              t3 = op;
              break;
            }
            if (t3 && _.label < t3[2]) {
              _.label = t3[2];
              _.ops.push(op);
              break;
            }
            if (t3[2])
              _.ops.pop();
            _.trys.pop();
            continue;
        }
        op = body.call(thisArg, _);
      } catch (e2) {
        op = [6, e2];
        y2 = 0;
      } finally {
        f = t3 = 0;
      }
    if (op[0] & 5)
      throw op[1];
    return { value: op[0] ? op[1] : void 0, done: true };
  }
  __name(step, "step");
};
var tryCatch = /* @__PURE__ */ __name(function(f, onRejected) {
  return function() {
    return __awaiter(void 0, void 0, void 0, function() {
      var reason_1;
      return __generator(this, function(_a) {
        switch (_a.label) {
          case 0:
            _a.trys.push([0, 2, , 3]);
            return [4, f().then(right)];
          case 1:
            return [2, _a.sent()];
          case 2:
            reason_1 = _a.sent();
            return [2, left(onRejected(reason_1))];
          case 3:
            return [2];
        }
      });
    });
  };
}, "tryCatch");

// ../engines/src/index.ts
var import_engines_version = __toESM(require_engines_version());
var import_path3 = __toESM(require("path"));
var import_engines_version2 = __toESM(require_engines_version());
var debug6 = src_default("prisma:engines");
function getEnginesPath() {
  return import_path3.default.join(__dirname, "../");
}
__name(getEnginesPath, "getEnginesPath");
var DEFAULT_CLI_QUERY_ENGINE_BINARY_TYPE = "libquery-engine" /* libqueryEngine */;
function getCliQueryEngineBinaryType() {
  const envCliQueryEngineType = process.env.PRISMA_CLI_QUERY_ENGINE_TYPE;
  if (envCliQueryEngineType) {
    if (envCliQueryEngineType === "binary") {
      return "query-engine" /* queryEngine */;
    }
    if (envCliQueryEngineType === "library") {
      return "libquery-engine" /* libqueryEngine */;
    }
  }
  return DEFAULT_CLI_QUERY_ENGINE_BINARY_TYPE;
}
__name(getCliQueryEngineBinaryType, "getCliQueryEngineBinaryType");
import_path3.default.join(__dirname, "../query-engine-darwin");
import_path3.default.join(__dirname, "../query-engine-darwin-arm64");
import_path3.default.join(__dirname, "../query-engine-debian-openssl-1.0.x");
import_path3.default.join(__dirname, "../query-engine-debian-openssl-1.1.x");
import_path3.default.join(__dirname, "../query-engine-debian-openssl-3.0.x");
import_path3.default.join(__dirname, "../query-engine-rhel-openssl-1.0.x");
import_path3.default.join(__dirname, "../query-engine-rhel-openssl-1.1.x");
import_path3.default.join(__dirname, "../query-engine-rhel-openssl-3.0.x");
import_path3.default.join(__dirname, "../libquery_engine-darwin.dylib.node");
import_path3.default.join(__dirname, "../libquery_engine-darwin-arm64.dylib.node");
import_path3.default.join(__dirname, "../libquery_engine-debian-openssl-1.0.x.so.node");
import_path3.default.join(__dirname, "../libquery_engine-debian-openssl-1.1.x.so.node");
import_path3.default.join(__dirname, "../libquery_engine-debian-openssl-3.0.x.so.node");
import_path3.default.join(__dirname, "../libquery_engine-linux-arm64-openssl-1.0.x.so.node");
import_path3.default.join(__dirname, "../libquery_engine-linux-arm64-openssl-1.1.x.so.node");
import_path3.default.join(__dirname, "../libquery_engine-linux-arm64-openssl-3.0.x.so.node");
import_path3.default.join(__dirname, "../libquery_engine-linux-musl.so.node");
import_path3.default.join(__dirname, "../libquery_engine-linux-musl-openssl-3.0.x.so.node");
import_path3.default.join(__dirname, "../libquery_engine-rhel-openssl-1.0.x.so.node");
import_path3.default.join(__dirname, "../libquery_engine-rhel-openssl-1.1.x.so.node");
import_path3.default.join(__dirname, "../libquery_engine-rhel-openssl-3.0.x.so.node");
import_path3.default.join(__dirname, "../query_engine-windows.dll.node");

// ../engine-core/src/common/utils/util.ts
var import_fs7 = __toESM(require("fs"));
var import_new_github_issue_url = __toESM(require_new_github_issue_url());
var debug7 = src_default("plusX");
function plusX(file2) {
  const s = import_fs7.default.statSync(file2);
  const newMode = s.mode | 64 | 8 | 1;
  if (s.mode === newMode) {
    debug7(`Execution permissions of ${file2} are fine`);
    return;
  }
  const base8 = newMode.toString(8).slice(-3);
  debug7(`Have to call plusX on ${file2}`);
  import_fs7.default.chmodSync(file2, base8);
}
__name(plusX, "plusX");

// ../engine-core/src/common/errors/utils/handleEngineLoadingErrors.ts
var import_chalk6 = __toESM(require_source());
function handleLibraryLoadingErrors(args) {
  const error = args.e;
  const systemLibraryNotFound = /* @__PURE__ */ __name((library) => `Prisma cannot find the required \`${library}\` system library in your system`, "systemLibraryNotFound");
  const hasLinkingProblem = error.message.includes("cannot open shared object file");
  const referToSystemRequirementsDocs = `Please refer to the documentation about Prisma's system requirements: ${link(
    "https://pris.ly/d/system-requirements"
  )}`;
  const errorTitle = `Unable to require(\`${import_chalk6.default.dim(args.id)}\`).`;
  const potentialReasonMessage = K({ message: error.message, code: error.code }).with({ code: "ENOENT" }, () => `File does not exist.`).when(
    ({ message }) => hasLinkingProblem && message.includes("libz"),
    () => {
      return `${systemLibraryNotFound("libz")}. Please install it and try again.`;
    }
  ).when(
    ({ message }) => hasLinkingProblem && message.includes("libgcc_s"),
    () => {
      return `${systemLibraryNotFound("libgcc_s")}. Please install it and try again.`;
    }
  ).when(
    ({ message }) => hasLinkingProblem && message.includes("libssl"),
    () => {
      const libsslVersion = args.platformInfo.libssl ? `openssl-${args.platformInfo.libssl}` : "openssl";
      return `${systemLibraryNotFound("libssl")}. Please install ${libsslVersion} and try again.`;
    }
  ).when(
    ({ message }) => message.includes("GLIBC"),
    () => {
      return `Prisma has detected an incompatible version of the \`glibc\` C standard library installed in your system. This probably means your system may be too old to run Prisma. ${referToSystemRequirementsDocs}`;
    }
  ).when(
    ({ message }) => args.platformInfo.platform === "linux" && message.includes("symbol not found"),
    () => {
      return `The Prisma engines are not compatible with your system ${args.platformInfo.originalDistro} on (${args.platformInfo.archFromUname}) which uses the \`${args.platformInfo.binaryTarget}\` binaryTarget by default. ${referToSystemRequirementsDocs}`;
    }
  ).otherwise(() => {
    return `The Prisma engines do not seem to be compatible with your system. ${referToSystemRequirementsDocs}`;
  });
  return `${errorTitle}
${potentialReasonMessage}

Details: ${error.message}`;
}
__name(handleLibraryLoadingErrors, "handleLibraryLoadingErrors");

// ../internals/src/resolveBinary.ts
var import_fs8 = __toESM(require("fs"));
var import_fs_extra = __toESM(require_lib4());
var import_path4 = __toESM(require("path"));
var import_temp_dir = __toESM(require_temp_dir());
var import_util5 = require("util");
var readFile3 = (0, import_util5.promisify)(import_fs8.default.readFile);
var writeFile = (0, import_util5.promisify)(import_fs8.default.writeFile);
async function getBinaryName(name) {
  const platform = await getPlatform();
  const extension = platform === "windows" ? ".exe" : "";
  if (name === "libquery-engine" /* libqueryEngine */) {
    return getNodeAPIName(platform, "fs");
  }
  return `${name}-${platform}${extension}`;
}
__name(getBinaryName, "getBinaryName");
var engineEnvVarMap = {
  ["query-engine" /* queryEngine */]: "PRISMA_QUERY_ENGINE_BINARY",
  ["libquery-engine" /* libqueryEngine */]: "PRISMA_QUERY_ENGINE_LIBRARY",
  ["migration-engine" /* migrationEngine */]: "PRISMA_MIGRATION_ENGINE_BINARY"
};
async function resolveBinary(name, proposedPath) {
  if (proposedPath && !proposedPath.startsWith("/snapshot/") && import_fs8.default.existsSync(proposedPath)) {
    return proposedPath;
  }
  const envVar = engineEnvVarMap[name];
  if (process.env[envVar]) {
    if (!import_fs8.default.existsSync(process.env[envVar])) {
      throw new Error(`Env var ${envVar} is provided, but provided path ${process.env[envVar]} can't be resolved.`);
    }
    return process.env[envVar];
  }
  const binaryName = await getBinaryName(name);
  const prismaPath = import_path4.default.join(getEnginesPath(), binaryName);
  if (import_fs8.default.existsSync(prismaPath)) {
    return maybeCopyToTmp(prismaPath);
  }
  const prismaPath2 = import_path4.default.join(__dirname, "..", binaryName);
  if (import_fs8.default.existsSync(prismaPath2)) {
    return maybeCopyToTmp(prismaPath2);
  }
  const prismaPath3 = import_path4.default.join(__dirname, "../..", binaryName);
  if (import_fs8.default.existsSync(prismaPath3)) {
    return maybeCopyToTmp(prismaPath3);
  }
  const prismaPath4 = import_path4.default.join(__dirname, "../runtime", binaryName);
  if (import_fs8.default.existsSync(prismaPath4)) {
    return maybeCopyToTmp(prismaPath4);
  }
  throw new Error(
    `Could not find ${name} binary. Searched in:
- ${prismaPath}
- ${prismaPath2}
- ${prismaPath3}
- ${prismaPath4}`
  );
}
__name(resolveBinary, "resolveBinary");
function safeResolveBinary(name, proposedPath) {
  return tryCatch(
    () => resolveBinary(name, proposedPath),
    (error) => error
  );
}
__name(safeResolveBinary, "safeResolveBinary");
async function maybeCopyToTmp(file) {
  const dir = eval("__dirname");
  if (dir.startsWith("/snapshot/")) {
    const targetDir = import_path4.default.join(import_temp_dir.default, "prisma-binaries");
    await (0, import_fs_extra.ensureDir)(targetDir);
    const target = import_path4.default.join(targetDir, import_path4.default.basename(file));
    const data = await readFile3(file);
    await writeFile(target, data);
    plusX(target);
    return target;
  }
  return file;
}
__name(maybeCopyToTmp, "maybeCopyToTmp");

// ../internals/src/engine-commands/getEngineVersion.ts
var import_execa2 = __toESM(require_execa());

// ../internals/src/utils/load.ts
function loadLibrary(id, platformInfo) {
  try {
    return require(id);
  } catch (e2) {
    const errorMessage = handleLibraryLoadingErrors({
      e: e2,
      platformInfo,
      id
    });
    throw new Error(errorMessage);
  }
}
__name(loadLibrary, "loadLibrary");

// ../internals/src/engine-commands/getEngineVersion.ts
async function getEngineVersion(enginePath2, binaryName) {
  if (!binaryName) {
    binaryName = getCliQueryEngineBinaryType();
  }
  enginePath2 = await resolveBinary(binaryName, enginePath2);
  const platformInfo = await getPlatformWithOSResult();
  if (binaryName === "libquery-engine" /* libqueryEngine */) {
    await isNodeAPISupported();
    const QE = loadLibrary(enginePath2, platformInfo);
    return `${"libquery-engine" /* libqueryEngine */} ${QE.version().commit}`;
  } else {
    const result = await (0, import_execa2.default)(enginePath2, ["--version"]);
    return result.stdout;
  }
}
__name(getEngineVersion, "getEngineVersion");

// ../internals/src/utils/assertNever.ts
function assertNever(arg, errorMessage) {
  throw new Error(errorMessage);
}
__name(assertNever, "assertNever");

// src/runtime/externalToInternalDmmf.ts
var import_pluralize = __toESM(require_pluralize());

// src/runtime/utils/common.ts
var import_chalk7 = __toESM(require_source());

// ../../node_modules/.pnpm/decimal.js@10.4.3/node_modules/decimal.js/decimal.mjs
var EXP_LIMIT = 9e15;
var MAX_DIGITS = 1e9;
var NUMERALS = "0123456789abcdef";
var LN10 = "2.3025850929940456840179914546843642076011014886287729760333279009675726096773524802359972050895982983419677840422862486334095254650828067566662873690987816894829072083255546808437998948262331985283935053089653777326288461633662222876982198867465436674744042432743651550489343149393914796194044002221051017141748003688084012647080685567743216228355220114804663715659121373450747856947683463616792101806445070648000277502684916746550586856935673420670581136429224554405758925724208241314695689016758940256776311356919292033376587141660230105703089634572075440370847469940168269282808481184289314848524948644871927809676271275775397027668605952496716674183485704422507197965004714951050492214776567636938662976979522110718264549734772662425709429322582798502585509785265383207606726317164309505995087807523710333101197857547331541421808427543863591778117054309827482385045648019095610299291824318237525357709750539565187697510374970888692180205189339507238539205144634197265287286965110862571492198849978748873771345686209167058";
var PI = "3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679821480865132823066470938446095505822317253594081284811174502841027019385211055596446229489549303819644288109756659334461284756482337867831652712019091456485669234603486104543266482133936072602491412737245870066063155881748815209209628292540917153643678925903600113305305488204665213841469519415116094330572703657595919530921861173819326117931051185480744623799627495673518857527248912279381830119491298336733624406566430860213949463952247371907021798609437027705392171762931767523846748184676694051320005681271452635608277857713427577896091736371787214684409012249534301465495853710507922796892589235420199561121290219608640344181598136297747713099605187072113499999983729780499510597317328160963185950244594553469083026425223082533446850352619311881710100031378387528865875332083814206171776691473035982534904287554687311595628638823537875937519577818577805321712268066130019278766111959092164201989380952572010654858632789";
var DEFAULTS = {
  precision: 20,
  rounding: 4,
  modulo: 1,
  toExpNeg: -7,
  toExpPos: 21,
  minE: -EXP_LIMIT,
  maxE: EXP_LIMIT,
  crypto: false
};
var inexact;
var quadrant;
var external = true;
var decimalError = "[DecimalError] ";
var invalidArgument = decimalError + "Invalid argument: ";
var precisionLimitExceeded = decimalError + "Precision limit exceeded";
var cryptoUnavailable = decimalError + "crypto unavailable";
var tag = "[object Decimal]";
var mathfloor = Math.floor;
var mathpow = Math.pow;
var isBinary = /^0b([01]+(\.[01]*)?|\.[01]+)(p[+-]?\d+)?$/i;
var isHex = /^0x([0-9a-f]+(\.[0-9a-f]*)?|\.[0-9a-f]+)(p[+-]?\d+)?$/i;
var isOctal = /^0o([0-7]+(\.[0-7]*)?|\.[0-7]+)(p[+-]?\d+)?$/i;
var isDecimal = /^(\d+(\.\d*)?|\.\d+)(e[+-]?\d+)?$/i;
var BASE = 1e7;
var LOG_BASE = 7;
var MAX_SAFE_INTEGER = 9007199254740991;
var LN10_PRECISION = LN10.length - 1;
var PI_PRECISION = PI.length - 1;
var P = { toStringTag: tag };
P.absoluteValue = P.abs = function() {
  var x = new this.constructor(this);
  if (x.s < 0)
    x.s = 1;
  return finalise(x);
};
P.ceil = function() {
  return finalise(new this.constructor(this), this.e + 1, 2);
};
P.clampedTo = P.clamp = function(min2, max2) {
  var k, x = this, Ctor = x.constructor;
  min2 = new Ctor(min2);
  max2 = new Ctor(max2);
  if (!min2.s || !max2.s)
    return new Ctor(NaN);
  if (min2.gt(max2))
    throw Error(invalidArgument + max2);
  k = x.cmp(min2);
  return k < 0 ? min2 : x.cmp(max2) > 0 ? max2 : new Ctor(x);
};
P.comparedTo = P.cmp = function(y2) {
  var i, j, xdL, ydL, x = this, xd = x.d, yd = (y2 = new x.constructor(y2)).d, xs = x.s, ys = y2.s;
  if (!xd || !yd) {
    return !xs || !ys ? NaN : xs !== ys ? xs : xd === yd ? 0 : !xd ^ xs < 0 ? 1 : -1;
  }
  if (!xd[0] || !yd[0])
    return xd[0] ? xs : yd[0] ? -ys : 0;
  if (xs !== ys)
    return xs;
  if (x.e !== y2.e)
    return x.e > y2.e ^ xs < 0 ? 1 : -1;
  xdL = xd.length;
  ydL = yd.length;
  for (i = 0, j = xdL < ydL ? xdL : ydL; i < j; ++i) {
    if (xd[i] !== yd[i])
      return xd[i] > yd[i] ^ xs < 0 ? 1 : -1;
  }
  return xdL === ydL ? 0 : xdL > ydL ^ xs < 0 ? 1 : -1;
};
P.cosine = P.cos = function() {
  var pr, rm, x = this, Ctor = x.constructor;
  if (!x.d)
    return new Ctor(NaN);
  if (!x.d[0])
    return new Ctor(1);
  pr = Ctor.precision;
  rm = Ctor.rounding;
  Ctor.precision = pr + Math.max(x.e, x.sd()) + LOG_BASE;
  Ctor.rounding = 1;
  x = cosine(Ctor, toLessThanHalfPi(Ctor, x));
  Ctor.precision = pr;
  Ctor.rounding = rm;
  return finalise(quadrant == 2 || quadrant == 3 ? x.neg() : x, pr, rm, true);
};
P.cubeRoot = P.cbrt = function() {
  var e2, m, n2, r2, rep, s, sd, t3, t32, t3plusx, x = this, Ctor = x.constructor;
  if (!x.isFinite() || x.isZero())
    return new Ctor(x);
  external = false;
  s = x.s * mathpow(x.s * x, 1 / 3);
  if (!s || Math.abs(s) == 1 / 0) {
    n2 = digitsToString(x.d);
    e2 = x.e;
    if (s = (e2 - n2.length + 1) % 3)
      n2 += s == 1 || s == -2 ? "0" : "00";
    s = mathpow(n2, 1 / 3);
    e2 = mathfloor((e2 + 1) / 3) - (e2 % 3 == (e2 < 0 ? -1 : 2));
    if (s == 1 / 0) {
      n2 = "5e" + e2;
    } else {
      n2 = s.toExponential();
      n2 = n2.slice(0, n2.indexOf("e") + 1) + e2;
    }
    r2 = new Ctor(n2);
    r2.s = x.s;
  } else {
    r2 = new Ctor(s.toString());
  }
  sd = (e2 = Ctor.precision) + 3;
  for (; ; ) {
    t3 = r2;
    t32 = t3.times(t3).times(t3);
    t3plusx = t32.plus(x);
    r2 = divide(t3plusx.plus(x).times(t3), t3plusx.plus(t32), sd + 2, 1);
    if (digitsToString(t3.d).slice(0, sd) === (n2 = digitsToString(r2.d)).slice(0, sd)) {
      n2 = n2.slice(sd - 3, sd + 1);
      if (n2 == "9999" || !rep && n2 == "4999") {
        if (!rep) {
          finalise(t3, e2 + 1, 0);
          if (t3.times(t3).times(t3).eq(x)) {
            r2 = t3;
            break;
          }
        }
        sd += 4;
        rep = 1;
      } else {
        if (!+n2 || !+n2.slice(1) && n2.charAt(0) == "5") {
          finalise(r2, e2 + 1, 1);
          m = !r2.times(r2).times(r2).eq(x);
        }
        break;
      }
    }
  }
  external = true;
  return finalise(r2, e2, Ctor.rounding, m);
};
P.decimalPlaces = P.dp = function() {
  var w2, d2 = this.d, n2 = NaN;
  if (d2) {
    w2 = d2.length - 1;
    n2 = (w2 - mathfloor(this.e / LOG_BASE)) * LOG_BASE;
    w2 = d2[w2];
    if (w2)
      for (; w2 % 10 == 0; w2 /= 10)
        n2--;
    if (n2 < 0)
      n2 = 0;
  }
  return n2;
};
P.dividedBy = P.div = function(y2) {
  return divide(this, new this.constructor(y2));
};
P.dividedToIntegerBy = P.divToInt = function(y2) {
  var x = this, Ctor = x.constructor;
  return finalise(divide(x, new Ctor(y2), 0, 1, 1), Ctor.precision, Ctor.rounding);
};
P.equals = P.eq = function(y2) {
  return this.cmp(y2) === 0;
};
P.floor = function() {
  return finalise(new this.constructor(this), this.e + 1, 3);
};
P.greaterThan = P.gt = function(y2) {
  return this.cmp(y2) > 0;
};
P.greaterThanOrEqualTo = P.gte = function(y2) {
  var k = this.cmp(y2);
  return k == 1 || k === 0;
};
P.hyperbolicCosine = P.cosh = function() {
  var k, n2, pr, rm, len, x = this, Ctor = x.constructor, one = new Ctor(1);
  if (!x.isFinite())
    return new Ctor(x.s ? 1 / 0 : NaN);
  if (x.isZero())
    return one;
  pr = Ctor.precision;
  rm = Ctor.rounding;
  Ctor.precision = pr + Math.max(x.e, x.sd()) + 4;
  Ctor.rounding = 1;
  len = x.d.length;
  if (len < 32) {
    k = Math.ceil(len / 3);
    n2 = (1 / tinyPow(4, k)).toString();
  } else {
    k = 16;
    n2 = "2.3283064365386962890625e-10";
  }
  x = taylorSeries(Ctor, 1, x.times(n2), new Ctor(1), true);
  var cosh2_x, i = k, d8 = new Ctor(8);
  for (; i--; ) {
    cosh2_x = x.times(x);
    x = one.minus(cosh2_x.times(d8.minus(cosh2_x.times(d8))));
  }
  return finalise(x, Ctor.precision = pr, Ctor.rounding = rm, true);
};
P.hyperbolicSine = P.sinh = function() {
  var k, pr, rm, len, x = this, Ctor = x.constructor;
  if (!x.isFinite() || x.isZero())
    return new Ctor(x);
  pr = Ctor.precision;
  rm = Ctor.rounding;
  Ctor.precision = pr + Math.max(x.e, x.sd()) + 4;
  Ctor.rounding = 1;
  len = x.d.length;
  if (len < 3) {
    x = taylorSeries(Ctor, 2, x, x, true);
  } else {
    k = 1.4 * Math.sqrt(len);
    k = k > 16 ? 16 : k | 0;
    x = x.times(1 / tinyPow(5, k));
    x = taylorSeries(Ctor, 2, x, x, true);
    var sinh2_x, d5 = new Ctor(5), d16 = new Ctor(16), d20 = new Ctor(20);
    for (; k--; ) {
      sinh2_x = x.times(x);
      x = x.times(d5.plus(sinh2_x.times(d16.times(sinh2_x).plus(d20))));
    }
  }
  Ctor.precision = pr;
  Ctor.rounding = rm;
  return finalise(x, pr, rm, true);
};
P.hyperbolicTangent = P.tanh = function() {
  var pr, rm, x = this, Ctor = x.constructor;
  if (!x.isFinite())
    return new Ctor(x.s);
  if (x.isZero())
    return new Ctor(x);
  pr = Ctor.precision;
  rm = Ctor.rounding;
  Ctor.precision = pr + 7;
  Ctor.rounding = 1;
  return divide(x.sinh(), x.cosh(), Ctor.precision = pr, Ctor.rounding = rm);
};
P.inverseCosine = P.acos = function() {
  var halfPi, x = this, Ctor = x.constructor, k = x.abs().cmp(1), pr = Ctor.precision, rm = Ctor.rounding;
  if (k !== -1) {
    return k === 0 ? x.isNeg() ? getPi(Ctor, pr, rm) : new Ctor(0) : new Ctor(NaN);
  }
  if (x.isZero())
    return getPi(Ctor, pr + 4, rm).times(0.5);
  Ctor.precision = pr + 6;
  Ctor.rounding = 1;
  x = x.asin();
  halfPi = getPi(Ctor, pr + 4, rm).times(0.5);
  Ctor.precision = pr;
  Ctor.rounding = rm;
  return halfPi.minus(x);
};
P.inverseHyperbolicCosine = P.acosh = function() {
  var pr, rm, x = this, Ctor = x.constructor;
  if (x.lte(1))
    return new Ctor(x.eq(1) ? 0 : NaN);
  if (!x.isFinite())
    return new Ctor(x);
  pr = Ctor.precision;
  rm = Ctor.rounding;
  Ctor.precision = pr + Math.max(Math.abs(x.e), x.sd()) + 4;
  Ctor.rounding = 1;
  external = false;
  x = x.times(x).minus(1).sqrt().plus(x);
  external = true;
  Ctor.precision = pr;
  Ctor.rounding = rm;
  return x.ln();
};
P.inverseHyperbolicSine = P.asinh = function() {
  var pr, rm, x = this, Ctor = x.constructor;
  if (!x.isFinite() || x.isZero())
    return new Ctor(x);
  pr = Ctor.precision;
  rm = Ctor.rounding;
  Ctor.precision = pr + 2 * Math.max(Math.abs(x.e), x.sd()) + 6;
  Ctor.rounding = 1;
  external = false;
  x = x.times(x).plus(1).sqrt().plus(x);
  external = true;
  Ctor.precision = pr;
  Ctor.rounding = rm;
  return x.ln();
};
P.inverseHyperbolicTangent = P.atanh = function() {
  var pr, rm, wpr, xsd, x = this, Ctor = x.constructor;
  if (!x.isFinite())
    return new Ctor(NaN);
  if (x.e >= 0)
    return new Ctor(x.abs().eq(1) ? x.s / 0 : x.isZero() ? x : NaN);
  pr = Ctor.precision;
  rm = Ctor.rounding;
  xsd = x.sd();
  if (Math.max(xsd, pr) < 2 * -x.e - 1)
    return finalise(new Ctor(x), pr, rm, true);
  Ctor.precision = wpr = xsd - x.e;
  x = divide(x.plus(1), new Ctor(1).minus(x), wpr + pr, 1);
  Ctor.precision = pr + 4;
  Ctor.rounding = 1;
  x = x.ln();
  Ctor.precision = pr;
  Ctor.rounding = rm;
  return x.times(0.5);
};
P.inverseSine = P.asin = function() {
  var halfPi, k, pr, rm, x = this, Ctor = x.constructor;
  if (x.isZero())
    return new Ctor(x);
  k = x.abs().cmp(1);
  pr = Ctor.precision;
  rm = Ctor.rounding;
  if (k !== -1) {
    if (k === 0) {
      halfPi = getPi(Ctor, pr + 4, rm).times(0.5);
      halfPi.s = x.s;
      return halfPi;
    }
    return new Ctor(NaN);
  }
  Ctor.precision = pr + 6;
  Ctor.rounding = 1;
  x = x.div(new Ctor(1).minus(x.times(x)).sqrt().plus(1)).atan();
  Ctor.precision = pr;
  Ctor.rounding = rm;
  return x.times(2);
};
P.inverseTangent = P.atan = function() {
  var i, j, k, n2, px, t3, r2, wpr, x2, x = this, Ctor = x.constructor, pr = Ctor.precision, rm = Ctor.rounding;
  if (!x.isFinite()) {
    if (!x.s)
      return new Ctor(NaN);
    if (pr + 4 <= PI_PRECISION) {
      r2 = getPi(Ctor, pr + 4, rm).times(0.5);
      r2.s = x.s;
      return r2;
    }
  } else if (x.isZero()) {
    return new Ctor(x);
  } else if (x.abs().eq(1) && pr + 4 <= PI_PRECISION) {
    r2 = getPi(Ctor, pr + 4, rm).times(0.25);
    r2.s = x.s;
    return r2;
  }
  Ctor.precision = wpr = pr + 10;
  Ctor.rounding = 1;
  k = Math.min(28, wpr / LOG_BASE + 2 | 0);
  for (i = k; i; --i)
    x = x.div(x.times(x).plus(1).sqrt().plus(1));
  external = false;
  j = Math.ceil(wpr / LOG_BASE);
  n2 = 1;
  x2 = x.times(x);
  r2 = new Ctor(x);
  px = x;
  for (; i !== -1; ) {
    px = px.times(x2);
    t3 = r2.minus(px.div(n2 += 2));
    px = px.times(x2);
    r2 = t3.plus(px.div(n2 += 2));
    if (r2.d[j] !== void 0)
      for (i = j; r2.d[i] === t3.d[i] && i--; )
        ;
  }
  if (k)
    r2 = r2.times(2 << k - 1);
  external = true;
  return finalise(r2, Ctor.precision = pr, Ctor.rounding = rm, true);
};
P.isFinite = function() {
  return !!this.d;
};
P.isInteger = P.isInt = function() {
  return !!this.d && mathfloor(this.e / LOG_BASE) > this.d.length - 2;
};
P.isNaN = function() {
  return !this.s;
};
P.isNegative = P.isNeg = function() {
  return this.s < 0;
};
P.isPositive = P.isPos = function() {
  return this.s > 0;
};
P.isZero = function() {
  return !!this.d && this.d[0] === 0;
};
P.lessThan = P.lt = function(y2) {
  return this.cmp(y2) < 0;
};
P.lessThanOrEqualTo = P.lte = function(y2) {
  return this.cmp(y2) < 1;
};
P.logarithm = P.log = function(base) {
  var isBase10, d2, denominator, k, inf, num, sd, r2, arg = this, Ctor = arg.constructor, pr = Ctor.precision, rm = Ctor.rounding, guard = 5;
  if (base == null) {
    base = new Ctor(10);
    isBase10 = true;
  } else {
    base = new Ctor(base);
    d2 = base.d;
    if (base.s < 0 || !d2 || !d2[0] || base.eq(1))
      return new Ctor(NaN);
    isBase10 = base.eq(10);
  }
  d2 = arg.d;
  if (arg.s < 0 || !d2 || !d2[0] || arg.eq(1)) {
    return new Ctor(d2 && !d2[0] ? -1 / 0 : arg.s != 1 ? NaN : d2 ? 0 : 1 / 0);
  }
  if (isBase10) {
    if (d2.length > 1) {
      inf = true;
    } else {
      for (k = d2[0]; k % 10 === 0; )
        k /= 10;
      inf = k !== 1;
    }
  }
  external = false;
  sd = pr + guard;
  num = naturalLogarithm(arg, sd);
  denominator = isBase10 ? getLn10(Ctor, sd + 10) : naturalLogarithm(base, sd);
  r2 = divide(num, denominator, sd, 1);
  if (checkRoundingDigits(r2.d, k = pr, rm)) {
    do {
      sd += 10;
      num = naturalLogarithm(arg, sd);
      denominator = isBase10 ? getLn10(Ctor, sd + 10) : naturalLogarithm(base, sd);
      r2 = divide(num, denominator, sd, 1);
      if (!inf) {
        if (+digitsToString(r2.d).slice(k + 1, k + 15) + 1 == 1e14) {
          r2 = finalise(r2, pr + 1, 0);
        }
        break;
      }
    } while (checkRoundingDigits(r2.d, k += 10, rm));
  }
  external = true;
  return finalise(r2, pr, rm);
};
P.minus = P.sub = function(y2) {
  var d2, e2, i, j, k, len, pr, rm, xd, xe, xLTy, yd, x = this, Ctor = x.constructor;
  y2 = new Ctor(y2);
  if (!x.d || !y2.d) {
    if (!x.s || !y2.s)
      y2 = new Ctor(NaN);
    else if (x.d)
      y2.s = -y2.s;
    else
      y2 = new Ctor(y2.d || x.s !== y2.s ? x : NaN);
    return y2;
  }
  if (x.s != y2.s) {
    y2.s = -y2.s;
    return x.plus(y2);
  }
  xd = x.d;
  yd = y2.d;
  pr = Ctor.precision;
  rm = Ctor.rounding;
  if (!xd[0] || !yd[0]) {
    if (yd[0])
      y2.s = -y2.s;
    else if (xd[0])
      y2 = new Ctor(x);
    else
      return new Ctor(rm === 3 ? -0 : 0);
    return external ? finalise(y2, pr, rm) : y2;
  }
  e2 = mathfloor(y2.e / LOG_BASE);
  xe = mathfloor(x.e / LOG_BASE);
  xd = xd.slice();
  k = xe - e2;
  if (k) {
    xLTy = k < 0;
    if (xLTy) {
      d2 = xd;
      k = -k;
      len = yd.length;
    } else {
      d2 = yd;
      e2 = xe;
      len = xd.length;
    }
    i = Math.max(Math.ceil(pr / LOG_BASE), len) + 2;
    if (k > i) {
      k = i;
      d2.length = 1;
    }
    d2.reverse();
    for (i = k; i--; )
      d2.push(0);
    d2.reverse();
  } else {
    i = xd.length;
    len = yd.length;
    xLTy = i < len;
    if (xLTy)
      len = i;
    for (i = 0; i < len; i++) {
      if (xd[i] != yd[i]) {
        xLTy = xd[i] < yd[i];
        break;
      }
    }
    k = 0;
  }
  if (xLTy) {
    d2 = xd;
    xd = yd;
    yd = d2;
    y2.s = -y2.s;
  }
  len = xd.length;
  for (i = yd.length - len; i > 0; --i)
    xd[len++] = 0;
  for (i = yd.length; i > k; ) {
    if (xd[--i] < yd[i]) {
      for (j = i; j && xd[--j] === 0; )
        xd[j] = BASE - 1;
      --xd[j];
      xd[i] += BASE;
    }
    xd[i] -= yd[i];
  }
  for (; xd[--len] === 0; )
    xd.pop();
  for (; xd[0] === 0; xd.shift())
    --e2;
  if (!xd[0])
    return new Ctor(rm === 3 ? -0 : 0);
  y2.d = xd;
  y2.e = getBase10Exponent(xd, e2);
  return external ? finalise(y2, pr, rm) : y2;
};
P.modulo = P.mod = function(y2) {
  var q, x = this, Ctor = x.constructor;
  y2 = new Ctor(y2);
  if (!x.d || !y2.s || y2.d && !y2.d[0])
    return new Ctor(NaN);
  if (!y2.d || x.d && !x.d[0]) {
    return finalise(new Ctor(x), Ctor.precision, Ctor.rounding);
  }
  external = false;
  if (Ctor.modulo == 9) {
    q = divide(x, y2.abs(), 0, 3, 1);
    q.s *= y2.s;
  } else {
    q = divide(x, y2, 0, Ctor.modulo, 1);
  }
  q = q.times(y2);
  external = true;
  return x.minus(q);
};
P.naturalExponential = P.exp = function() {
  return naturalExponential(this);
};
P.naturalLogarithm = P.ln = function() {
  return naturalLogarithm(this);
};
P.negated = P.neg = function() {
  var x = new this.constructor(this);
  x.s = -x.s;
  return finalise(x);
};
P.plus = P.add = function(y2) {
  var carry, d2, e2, i, k, len, pr, rm, xd, yd, x = this, Ctor = x.constructor;
  y2 = new Ctor(y2);
  if (!x.d || !y2.d) {
    if (!x.s || !y2.s)
      y2 = new Ctor(NaN);
    else if (!x.d)
      y2 = new Ctor(y2.d || x.s === y2.s ? x : NaN);
    return y2;
  }
  if (x.s != y2.s) {
    y2.s = -y2.s;
    return x.minus(y2);
  }
  xd = x.d;
  yd = y2.d;
  pr = Ctor.precision;
  rm = Ctor.rounding;
  if (!xd[0] || !yd[0]) {
    if (!yd[0])
      y2 = new Ctor(x);
    return external ? finalise(y2, pr, rm) : y2;
  }
  k = mathfloor(x.e / LOG_BASE);
  e2 = mathfloor(y2.e / LOG_BASE);
  xd = xd.slice();
  i = k - e2;
  if (i) {
    if (i < 0) {
      d2 = xd;
      i = -i;
      len = yd.length;
    } else {
      d2 = yd;
      e2 = k;
      len = xd.length;
    }
    k = Math.ceil(pr / LOG_BASE);
    len = k > len ? k + 1 : len + 1;
    if (i > len) {
      i = len;
      d2.length = 1;
    }
    d2.reverse();
    for (; i--; )
      d2.push(0);
    d2.reverse();
  }
  len = xd.length;
  i = yd.length;
  if (len - i < 0) {
    i = len;
    d2 = yd;
    yd = xd;
    xd = d2;
  }
  for (carry = 0; i; ) {
    carry = (xd[--i] = xd[i] + yd[i] + carry) / BASE | 0;
    xd[i] %= BASE;
  }
  if (carry) {
    xd.unshift(carry);
    ++e2;
  }
  for (len = xd.length; xd[--len] == 0; )
    xd.pop();
  y2.d = xd;
  y2.e = getBase10Exponent(xd, e2);
  return external ? finalise(y2, pr, rm) : y2;
};
P.precision = P.sd = function(z) {
  var k, x = this;
  if (z !== void 0 && z !== !!z && z !== 1 && z !== 0)
    throw Error(invalidArgument + z);
  if (x.d) {
    k = getPrecision(x.d);
    if (z && x.e + 1 > k)
      k = x.e + 1;
  } else {
    k = NaN;
  }
  return k;
};
P.round = function() {
  var x = this, Ctor = x.constructor;
  return finalise(new Ctor(x), x.e + 1, Ctor.rounding);
};
P.sine = P.sin = function() {
  var pr, rm, x = this, Ctor = x.constructor;
  if (!x.isFinite())
    return new Ctor(NaN);
  if (x.isZero())
    return new Ctor(x);
  pr = Ctor.precision;
  rm = Ctor.rounding;
  Ctor.precision = pr + Math.max(x.e, x.sd()) + LOG_BASE;
  Ctor.rounding = 1;
  x = sine(Ctor, toLessThanHalfPi(Ctor, x));
  Ctor.precision = pr;
  Ctor.rounding = rm;
  return finalise(quadrant > 2 ? x.neg() : x, pr, rm, true);
};
P.squareRoot = P.sqrt = function() {
  var m, n2, sd, r2, rep, t3, x = this, d2 = x.d, e2 = x.e, s = x.s, Ctor = x.constructor;
  if (s !== 1 || !d2 || !d2[0]) {
    return new Ctor(!s || s < 0 && (!d2 || d2[0]) ? NaN : d2 ? x : 1 / 0);
  }
  external = false;
  s = Math.sqrt(+x);
  if (s == 0 || s == 1 / 0) {
    n2 = digitsToString(d2);
    if ((n2.length + e2) % 2 == 0)
      n2 += "0";
    s = Math.sqrt(n2);
    e2 = mathfloor((e2 + 1) / 2) - (e2 < 0 || e2 % 2);
    if (s == 1 / 0) {
      n2 = "5e" + e2;
    } else {
      n2 = s.toExponential();
      n2 = n2.slice(0, n2.indexOf("e") + 1) + e2;
    }
    r2 = new Ctor(n2);
  } else {
    r2 = new Ctor(s.toString());
  }
  sd = (e2 = Ctor.precision) + 3;
  for (; ; ) {
    t3 = r2;
    r2 = t3.plus(divide(x, t3, sd + 2, 1)).times(0.5);
    if (digitsToString(t3.d).slice(0, sd) === (n2 = digitsToString(r2.d)).slice(0, sd)) {
      n2 = n2.slice(sd - 3, sd + 1);
      if (n2 == "9999" || !rep && n2 == "4999") {
        if (!rep) {
          finalise(t3, e2 + 1, 0);
          if (t3.times(t3).eq(x)) {
            r2 = t3;
            break;
          }
        }
        sd += 4;
        rep = 1;
      } else {
        if (!+n2 || !+n2.slice(1) && n2.charAt(0) == "5") {
          finalise(r2, e2 + 1, 1);
          m = !r2.times(r2).eq(x);
        }
        break;
      }
    }
  }
  external = true;
  return finalise(r2, e2, Ctor.rounding, m);
};
P.tangent = P.tan = function() {
  var pr, rm, x = this, Ctor = x.constructor;
  if (!x.isFinite())
    return new Ctor(NaN);
  if (x.isZero())
    return new Ctor(x);
  pr = Ctor.precision;
  rm = Ctor.rounding;
  Ctor.precision = pr + 10;
  Ctor.rounding = 1;
  x = x.sin();
  x.s = 1;
  x = divide(x, new Ctor(1).minus(x.times(x)).sqrt(), pr + 10, 0);
  Ctor.precision = pr;
  Ctor.rounding = rm;
  return finalise(quadrant == 2 || quadrant == 4 ? x.neg() : x, pr, rm, true);
};
P.times = P.mul = function(y2) {
  var carry, e2, i, k, r2, rL, t3, xdL, ydL, x = this, Ctor = x.constructor, xd = x.d, yd = (y2 = new Ctor(y2)).d;
  y2.s *= x.s;
  if (!xd || !xd[0] || !yd || !yd[0]) {
    return new Ctor(!y2.s || xd && !xd[0] && !yd || yd && !yd[0] && !xd ? NaN : !xd || !yd ? y2.s / 0 : y2.s * 0);
  }
  e2 = mathfloor(x.e / LOG_BASE) + mathfloor(y2.e / LOG_BASE);
  xdL = xd.length;
  ydL = yd.length;
  if (xdL < ydL) {
    r2 = xd;
    xd = yd;
    yd = r2;
    rL = xdL;
    xdL = ydL;
    ydL = rL;
  }
  r2 = [];
  rL = xdL + ydL;
  for (i = rL; i--; )
    r2.push(0);
  for (i = ydL; --i >= 0; ) {
    carry = 0;
    for (k = xdL + i; k > i; ) {
      t3 = r2[k] + yd[i] * xd[k - i - 1] + carry;
      r2[k--] = t3 % BASE | 0;
      carry = t3 / BASE | 0;
    }
    r2[k] = (r2[k] + carry) % BASE | 0;
  }
  for (; !r2[--rL]; )
    r2.pop();
  if (carry)
    ++e2;
  else
    r2.shift();
  y2.d = r2;
  y2.e = getBase10Exponent(r2, e2);
  return external ? finalise(y2, Ctor.precision, Ctor.rounding) : y2;
};
P.toBinary = function(sd, rm) {
  return toStringBinary(this, 2, sd, rm);
};
P.toDecimalPlaces = P.toDP = function(dp, rm) {
  var x = this, Ctor = x.constructor;
  x = new Ctor(x);
  if (dp === void 0)
    return x;
  checkInt32(dp, 0, MAX_DIGITS);
  if (rm === void 0)
    rm = Ctor.rounding;
  else
    checkInt32(rm, 0, 8);
  return finalise(x, dp + x.e + 1, rm);
};
P.toExponential = function(dp, rm) {
  var str, x = this, Ctor = x.constructor;
  if (dp === void 0) {
    str = finiteToString(x, true);
  } else {
    checkInt32(dp, 0, MAX_DIGITS);
    if (rm === void 0)
      rm = Ctor.rounding;
    else
      checkInt32(rm, 0, 8);
    x = finalise(new Ctor(x), dp + 1, rm);
    str = finiteToString(x, true, dp + 1);
  }
  return x.isNeg() && !x.isZero() ? "-" + str : str;
};
P.toFixed = function(dp, rm) {
  var str, y2, x = this, Ctor = x.constructor;
  if (dp === void 0) {
    str = finiteToString(x);
  } else {
    checkInt32(dp, 0, MAX_DIGITS);
    if (rm === void 0)
      rm = Ctor.rounding;
    else
      checkInt32(rm, 0, 8);
    y2 = finalise(new Ctor(x), dp + x.e + 1, rm);
    str = finiteToString(y2, false, dp + y2.e + 1);
  }
  return x.isNeg() && !x.isZero() ? "-" + str : str;
};
P.toFraction = function(maxD) {
  var d2, d0, d1, d22, e2, k, n2, n0, n1, pr, q, r2, x = this, xd = x.d, Ctor = x.constructor;
  if (!xd)
    return new Ctor(x);
  n1 = d0 = new Ctor(1);
  d1 = n0 = new Ctor(0);
  d2 = new Ctor(d1);
  e2 = d2.e = getPrecision(xd) - x.e - 1;
  k = e2 % LOG_BASE;
  d2.d[0] = mathpow(10, k < 0 ? LOG_BASE + k : k);
  if (maxD == null) {
    maxD = e2 > 0 ? d2 : n1;
  } else {
    n2 = new Ctor(maxD);
    if (!n2.isInt() || n2.lt(n1))
      throw Error(invalidArgument + n2);
    maxD = n2.gt(d2) ? e2 > 0 ? d2 : n1 : n2;
  }
  external = false;
  n2 = new Ctor(digitsToString(xd));
  pr = Ctor.precision;
  Ctor.precision = e2 = xd.length * LOG_BASE * 2;
  for (; ; ) {
    q = divide(n2, d2, 0, 1, 1);
    d22 = d0.plus(q.times(d1));
    if (d22.cmp(maxD) == 1)
      break;
    d0 = d1;
    d1 = d22;
    d22 = n1;
    n1 = n0.plus(q.times(d22));
    n0 = d22;
    d22 = d2;
    d2 = n2.minus(q.times(d22));
    n2 = d22;
  }
  d22 = divide(maxD.minus(d0), d1, 0, 1, 1);
  n0 = n0.plus(d22.times(n1));
  d0 = d0.plus(d22.times(d1));
  n0.s = n1.s = x.s;
  r2 = divide(n1, d1, e2, 1).minus(x).abs().cmp(divide(n0, d0, e2, 1).minus(x).abs()) < 1 ? [n1, d1] : [n0, d0];
  Ctor.precision = pr;
  external = true;
  return r2;
};
P.toHexadecimal = P.toHex = function(sd, rm) {
  return toStringBinary(this, 16, sd, rm);
};
P.toNearest = function(y2, rm) {
  var x = this, Ctor = x.constructor;
  x = new Ctor(x);
  if (y2 == null) {
    if (!x.d)
      return x;
    y2 = new Ctor(1);
    rm = Ctor.rounding;
  } else {
    y2 = new Ctor(y2);
    if (rm === void 0) {
      rm = Ctor.rounding;
    } else {
      checkInt32(rm, 0, 8);
    }
    if (!x.d)
      return y2.s ? x : y2;
    if (!y2.d) {
      if (y2.s)
        y2.s = x.s;
      return y2;
    }
  }
  if (y2.d[0]) {
    external = false;
    x = divide(x, y2, 0, rm, 1).times(y2);
    external = true;
    finalise(x);
  } else {
    y2.s = x.s;
    x = y2;
  }
  return x;
};
P.toNumber = function() {
  return +this;
};
P.toOctal = function(sd, rm) {
  return toStringBinary(this, 8, sd, rm);
};
P.toPower = P.pow = function(y2) {
  var e2, k, pr, r2, rm, s, x = this, Ctor = x.constructor, yn = +(y2 = new Ctor(y2));
  if (!x.d || !y2.d || !x.d[0] || !y2.d[0])
    return new Ctor(mathpow(+x, yn));
  x = new Ctor(x);
  if (x.eq(1))
    return x;
  pr = Ctor.precision;
  rm = Ctor.rounding;
  if (y2.eq(1))
    return finalise(x, pr, rm);
  e2 = mathfloor(y2.e / LOG_BASE);
  if (e2 >= y2.d.length - 1 && (k = yn < 0 ? -yn : yn) <= MAX_SAFE_INTEGER) {
    r2 = intPow(Ctor, x, k, pr);
    return y2.s < 0 ? new Ctor(1).div(r2) : finalise(r2, pr, rm);
  }
  s = x.s;
  if (s < 0) {
    if (e2 < y2.d.length - 1)
      return new Ctor(NaN);
    if ((y2.d[e2] & 1) == 0)
      s = 1;
    if (x.e == 0 && x.d[0] == 1 && x.d.length == 1) {
      x.s = s;
      return x;
    }
  }
  k = mathpow(+x, yn);
  e2 = k == 0 || !isFinite(k) ? mathfloor(yn * (Math.log("0." + digitsToString(x.d)) / Math.LN10 + x.e + 1)) : new Ctor(k + "").e;
  if (e2 > Ctor.maxE + 1 || e2 < Ctor.minE - 1)
    return new Ctor(e2 > 0 ? s / 0 : 0);
  external = false;
  Ctor.rounding = x.s = 1;
  k = Math.min(12, (e2 + "").length);
  r2 = naturalExponential(y2.times(naturalLogarithm(x, pr + k)), pr);
  if (r2.d) {
    r2 = finalise(r2, pr + 5, 1);
    if (checkRoundingDigits(r2.d, pr, rm)) {
      e2 = pr + 10;
      r2 = finalise(naturalExponential(y2.times(naturalLogarithm(x, e2 + k)), e2), e2 + 5, 1);
      if (+digitsToString(r2.d).slice(pr + 1, pr + 15) + 1 == 1e14) {
        r2 = finalise(r2, pr + 1, 0);
      }
    }
  }
  r2.s = s;
  external = true;
  Ctor.rounding = rm;
  return finalise(r2, pr, rm);
};
P.toPrecision = function(sd, rm) {
  var str, x = this, Ctor = x.constructor;
  if (sd === void 0) {
    str = finiteToString(x, x.e <= Ctor.toExpNeg || x.e >= Ctor.toExpPos);
  } else {
    checkInt32(sd, 1, MAX_DIGITS);
    if (rm === void 0)
      rm = Ctor.rounding;
    else
      checkInt32(rm, 0, 8);
    x = finalise(new Ctor(x), sd, rm);
    str = finiteToString(x, sd <= x.e || x.e <= Ctor.toExpNeg, sd);
  }
  return x.isNeg() && !x.isZero() ? "-" + str : str;
};
P.toSignificantDigits = P.toSD = function(sd, rm) {
  var x = this, Ctor = x.constructor;
  if (sd === void 0) {
    sd = Ctor.precision;
    rm = Ctor.rounding;
  } else {
    checkInt32(sd, 1, MAX_DIGITS);
    if (rm === void 0)
      rm = Ctor.rounding;
    else
      checkInt32(rm, 0, 8);
  }
  return finalise(new Ctor(x), sd, rm);
};
P.toString = function() {
  var x = this, Ctor = x.constructor, str = finiteToString(x, x.e <= Ctor.toExpNeg || x.e >= Ctor.toExpPos);
  return x.isNeg() && !x.isZero() ? "-" + str : str;
};
P.truncated = P.trunc = function() {
  return finalise(new this.constructor(this), this.e + 1, 1);
};
P.valueOf = P.toJSON = function() {
  var x = this, Ctor = x.constructor, str = finiteToString(x, x.e <= Ctor.toExpNeg || x.e >= Ctor.toExpPos);
  return x.isNeg() ? "-" + str : str;
};
function digitsToString(d2) {
  var i, k, ws, indexOfLastWord = d2.length - 1, str = "", w2 = d2[0];
  if (indexOfLastWord > 0) {
    str += w2;
    for (i = 1; i < indexOfLastWord; i++) {
      ws = d2[i] + "";
      k = LOG_BASE - ws.length;
      if (k)
        str += getZeroString(k);
      str += ws;
    }
    w2 = d2[i];
    ws = w2 + "";
    k = LOG_BASE - ws.length;
    if (k)
      str += getZeroString(k);
  } else if (w2 === 0) {
    return "0";
  }
  for (; w2 % 10 === 0; )
    w2 /= 10;
  return str + w2;
}
__name(digitsToString, "digitsToString");
function checkInt32(i, min2, max2) {
  if (i !== ~~i || i < min2 || i > max2) {
    throw Error(invalidArgument + i);
  }
}
__name(checkInt32, "checkInt32");
function checkRoundingDigits(d2, i, rm, repeating) {
  var di, k, r2, rd;
  for (k = d2[0]; k >= 10; k /= 10)
    --i;
  if (--i < 0) {
    i += LOG_BASE;
    di = 0;
  } else {
    di = Math.ceil((i + 1) / LOG_BASE);
    i %= LOG_BASE;
  }
  k = mathpow(10, LOG_BASE - i);
  rd = d2[di] % k | 0;
  if (repeating == null) {
    if (i < 3) {
      if (i == 0)
        rd = rd / 100 | 0;
      else if (i == 1)
        rd = rd / 10 | 0;
      r2 = rm < 4 && rd == 99999 || rm > 3 && rd == 49999 || rd == 5e4 || rd == 0;
    } else {
      r2 = (rm < 4 && rd + 1 == k || rm > 3 && rd + 1 == k / 2) && (d2[di + 1] / k / 100 | 0) == mathpow(10, i - 2) - 1 || (rd == k / 2 || rd == 0) && (d2[di + 1] / k / 100 | 0) == 0;
    }
  } else {
    if (i < 4) {
      if (i == 0)
        rd = rd / 1e3 | 0;
      else if (i == 1)
        rd = rd / 100 | 0;
      else if (i == 2)
        rd = rd / 10 | 0;
      r2 = (repeating || rm < 4) && rd == 9999 || !repeating && rm > 3 && rd == 4999;
    } else {
      r2 = ((repeating || rm < 4) && rd + 1 == k || !repeating && rm > 3 && rd + 1 == k / 2) && (d2[di + 1] / k / 1e3 | 0) == mathpow(10, i - 3) - 1;
    }
  }
  return r2;
}
__name(checkRoundingDigits, "checkRoundingDigits");
function convertBase(str, baseIn, baseOut) {
  var j, arr = [0], arrL, i = 0, strL = str.length;
  for (; i < strL; ) {
    for (arrL = arr.length; arrL--; )
      arr[arrL] *= baseIn;
    arr[0] += NUMERALS.indexOf(str.charAt(i++));
    for (j = 0; j < arr.length; j++) {
      if (arr[j] > baseOut - 1) {
        if (arr[j + 1] === void 0)
          arr[j + 1] = 0;
        arr[j + 1] += arr[j] / baseOut | 0;
        arr[j] %= baseOut;
      }
    }
  }
  return arr.reverse();
}
__name(convertBase, "convertBase");
function cosine(Ctor, x) {
  var k, len, y2;
  if (x.isZero())
    return x;
  len = x.d.length;
  if (len < 32) {
    k = Math.ceil(len / 3);
    y2 = (1 / tinyPow(4, k)).toString();
  } else {
    k = 16;
    y2 = "2.3283064365386962890625e-10";
  }
  Ctor.precision += k;
  x = taylorSeries(Ctor, 1, x.times(y2), new Ctor(1));
  for (var i = k; i--; ) {
    var cos2x = x.times(x);
    x = cos2x.times(cos2x).minus(cos2x).times(8).plus(1);
  }
  Ctor.precision -= k;
  return x;
}
__name(cosine, "cosine");
var divide = function() {
  function multiplyInteger(x, k, base) {
    var temp, carry = 0, i = x.length;
    for (x = x.slice(); i--; ) {
      temp = x[i] * k + carry;
      x[i] = temp % base | 0;
      carry = temp / base | 0;
    }
    if (carry)
      x.unshift(carry);
    return x;
  }
  __name(multiplyInteger, "multiplyInteger");
  function compare(a, b2, aL, bL) {
    var i, r2;
    if (aL != bL) {
      r2 = aL > bL ? 1 : -1;
    } else {
      for (i = r2 = 0; i < aL; i++) {
        if (a[i] != b2[i]) {
          r2 = a[i] > b2[i] ? 1 : -1;
          break;
        }
      }
    }
    return r2;
  }
  __name(compare, "compare");
  function subtract(a, b2, aL, base) {
    var i = 0;
    for (; aL--; ) {
      a[aL] -= i;
      i = a[aL] < b2[aL] ? 1 : 0;
      a[aL] = i * base + a[aL] - b2[aL];
    }
    for (; !a[0] && a.length > 1; )
      a.shift();
  }
  __name(subtract, "subtract");
  return function(x, y2, pr, rm, dp, base) {
    var cmp, e2, i, k, logBase, more, prod, prodL, q, qd, rem, remL, rem0, sd, t3, xi, xL, yd0, yL, yz, Ctor = x.constructor, sign2 = x.s == y2.s ? 1 : -1, xd = x.d, yd = y2.d;
    if (!xd || !xd[0] || !yd || !yd[0]) {
      return new Ctor(
        !x.s || !y2.s || (xd ? yd && xd[0] == yd[0] : !yd) ? NaN : xd && xd[0] == 0 || !yd ? sign2 * 0 : sign2 / 0
      );
    }
    if (base) {
      logBase = 1;
      e2 = x.e - y2.e;
    } else {
      base = BASE;
      logBase = LOG_BASE;
      e2 = mathfloor(x.e / logBase) - mathfloor(y2.e / logBase);
    }
    yL = yd.length;
    xL = xd.length;
    q = new Ctor(sign2);
    qd = q.d = [];
    for (i = 0; yd[i] == (xd[i] || 0); i++)
      ;
    if (yd[i] > (xd[i] || 0))
      e2--;
    if (pr == null) {
      sd = pr = Ctor.precision;
      rm = Ctor.rounding;
    } else if (dp) {
      sd = pr + (x.e - y2.e) + 1;
    } else {
      sd = pr;
    }
    if (sd < 0) {
      qd.push(1);
      more = true;
    } else {
      sd = sd / logBase + 2 | 0;
      i = 0;
      if (yL == 1) {
        k = 0;
        yd = yd[0];
        sd++;
        for (; (i < xL || k) && sd--; i++) {
          t3 = k * base + (xd[i] || 0);
          qd[i] = t3 / yd | 0;
          k = t3 % yd | 0;
        }
        more = k || i < xL;
      } else {
        k = base / (yd[0] + 1) | 0;
        if (k > 1) {
          yd = multiplyInteger(yd, k, base);
          xd = multiplyInteger(xd, k, base);
          yL = yd.length;
          xL = xd.length;
        }
        xi = yL;
        rem = xd.slice(0, yL);
        remL = rem.length;
        for (; remL < yL; )
          rem[remL++] = 0;
        yz = yd.slice();
        yz.unshift(0);
        yd0 = yd[0];
        if (yd[1] >= base / 2)
          ++yd0;
        do {
          k = 0;
          cmp = compare(yd, rem, yL, remL);
          if (cmp < 0) {
            rem0 = rem[0];
            if (yL != remL)
              rem0 = rem0 * base + (rem[1] || 0);
            k = rem0 / yd0 | 0;
            if (k > 1) {
              if (k >= base)
                k = base - 1;
              prod = multiplyInteger(yd, k, base);
              prodL = prod.length;
              remL = rem.length;
              cmp = compare(prod, rem, prodL, remL);
              if (cmp == 1) {
                k--;
                subtract(prod, yL < prodL ? yz : yd, prodL, base);
              }
            } else {
              if (k == 0)
                cmp = k = 1;
              prod = yd.slice();
            }
            prodL = prod.length;
            if (prodL < remL)
              prod.unshift(0);
            subtract(rem, prod, remL, base);
            if (cmp == -1) {
              remL = rem.length;
              cmp = compare(yd, rem, yL, remL);
              if (cmp < 1) {
                k++;
                subtract(rem, yL < remL ? yz : yd, remL, base);
              }
            }
            remL = rem.length;
          } else if (cmp === 0) {
            k++;
            rem = [0];
          }
          qd[i++] = k;
          if (cmp && rem[0]) {
            rem[remL++] = xd[xi] || 0;
          } else {
            rem = [xd[xi]];
            remL = 1;
          }
        } while ((xi++ < xL || rem[0] !== void 0) && sd--);
        more = rem[0] !== void 0;
      }
      if (!qd[0])
        qd.shift();
    }
    if (logBase == 1) {
      q.e = e2;
      inexact = more;
    } else {
      for (i = 1, k = qd[0]; k >= 10; k /= 10)
        i++;
      q.e = i + e2 * logBase - 1;
      finalise(q, dp ? pr + q.e + 1 : pr, rm, more);
    }
    return q;
  };
}();
function finalise(x, sd, rm, isTruncated) {
  var digits, i, j, k, rd, roundUp, w2, xd, xdi, Ctor = x.constructor;
  out:
    if (sd != null) {
      xd = x.d;
      if (!xd)
        return x;
      for (digits = 1, k = xd[0]; k >= 10; k /= 10)
        digits++;
      i = sd - digits;
      if (i < 0) {
        i += LOG_BASE;
        j = sd;
        w2 = xd[xdi = 0];
        rd = w2 / mathpow(10, digits - j - 1) % 10 | 0;
      } else {
        xdi = Math.ceil((i + 1) / LOG_BASE);
        k = xd.length;
        if (xdi >= k) {
          if (isTruncated) {
            for (; k++ <= xdi; )
              xd.push(0);
            w2 = rd = 0;
            digits = 1;
            i %= LOG_BASE;
            j = i - LOG_BASE + 1;
          } else {
            break out;
          }
        } else {
          w2 = k = xd[xdi];
          for (digits = 1; k >= 10; k /= 10)
            digits++;
          i %= LOG_BASE;
          j = i - LOG_BASE + digits;
          rd = j < 0 ? 0 : w2 / mathpow(10, digits - j - 1) % 10 | 0;
        }
      }
      isTruncated = isTruncated || sd < 0 || xd[xdi + 1] !== void 0 || (j < 0 ? w2 : w2 % mathpow(10, digits - j - 1));
      roundUp = rm < 4 ? (rd || isTruncated) && (rm == 0 || rm == (x.s < 0 ? 3 : 2)) : rd > 5 || rd == 5 && (rm == 4 || isTruncated || rm == 6 && (i > 0 ? j > 0 ? w2 / mathpow(10, digits - j) : 0 : xd[xdi - 1]) % 10 & 1 || rm == (x.s < 0 ? 8 : 7));
      if (sd < 1 || !xd[0]) {
        xd.length = 0;
        if (roundUp) {
          sd -= x.e + 1;
          xd[0] = mathpow(10, (LOG_BASE - sd % LOG_BASE) % LOG_BASE);
          x.e = -sd || 0;
        } else {
          xd[0] = x.e = 0;
        }
        return x;
      }
      if (i == 0) {
        xd.length = xdi;
        k = 1;
        xdi--;
      } else {
        xd.length = xdi + 1;
        k = mathpow(10, LOG_BASE - i);
        xd[xdi] = j > 0 ? (w2 / mathpow(10, digits - j) % mathpow(10, j) | 0) * k : 0;
      }
      if (roundUp) {
        for (; ; ) {
          if (xdi == 0) {
            for (i = 1, j = xd[0]; j >= 10; j /= 10)
              i++;
            j = xd[0] += k;
            for (k = 1; j >= 10; j /= 10)
              k++;
            if (i != k) {
              x.e++;
              if (xd[0] == BASE)
                xd[0] = 1;
            }
            break;
          } else {
            xd[xdi] += k;
            if (xd[xdi] != BASE)
              break;
            xd[xdi--] = 0;
            k = 1;
          }
        }
      }
      for (i = xd.length; xd[--i] === 0; )
        xd.pop();
    }
  if (external) {
    if (x.e > Ctor.maxE) {
      x.d = null;
      x.e = NaN;
    } else if (x.e < Ctor.minE) {
      x.e = 0;
      x.d = [0];
    }
  }
  return x;
}
__name(finalise, "finalise");
function finiteToString(x, isExp, sd) {
  if (!x.isFinite())
    return nonFiniteToString(x);
  var k, e2 = x.e, str = digitsToString(x.d), len = str.length;
  if (isExp) {
    if (sd && (k = sd - len) > 0) {
      str = str.charAt(0) + "." + str.slice(1) + getZeroString(k);
    } else if (len > 1) {
      str = str.charAt(0) + "." + str.slice(1);
    }
    str = str + (x.e < 0 ? "e" : "e+") + x.e;
  } else if (e2 < 0) {
    str = "0." + getZeroString(-e2 - 1) + str;
    if (sd && (k = sd - len) > 0)
      str += getZeroString(k);
  } else if (e2 >= len) {
    str += getZeroString(e2 + 1 - len);
    if (sd && (k = sd - e2 - 1) > 0)
      str = str + "." + getZeroString(k);
  } else {
    if ((k = e2 + 1) < len)
      str = str.slice(0, k) + "." + str.slice(k);
    if (sd && (k = sd - len) > 0) {
      if (e2 + 1 === len)
        str += ".";
      str += getZeroString(k);
    }
  }
  return str;
}
__name(finiteToString, "finiteToString");
function getBase10Exponent(digits, e2) {
  var w2 = digits[0];
  for (e2 *= LOG_BASE; w2 >= 10; w2 /= 10)
    e2++;
  return e2;
}
__name(getBase10Exponent, "getBase10Exponent");
function getLn10(Ctor, sd, pr) {
  if (sd > LN10_PRECISION) {
    external = true;
    if (pr)
      Ctor.precision = pr;
    throw Error(precisionLimitExceeded);
  }
  return finalise(new Ctor(LN10), sd, 1, true);
}
__name(getLn10, "getLn10");
function getPi(Ctor, sd, rm) {
  if (sd > PI_PRECISION)
    throw Error(precisionLimitExceeded);
  return finalise(new Ctor(PI), sd, rm, true);
}
__name(getPi, "getPi");
function getPrecision(digits) {
  var w2 = digits.length - 1, len = w2 * LOG_BASE + 1;
  w2 = digits[w2];
  if (w2) {
    for (; w2 % 10 == 0; w2 /= 10)
      len--;
    for (w2 = digits[0]; w2 >= 10; w2 /= 10)
      len++;
  }
  return len;
}
__name(getPrecision, "getPrecision");
function getZeroString(k) {
  var zs = "";
  for (; k--; )
    zs += "0";
  return zs;
}
__name(getZeroString, "getZeroString");
function intPow(Ctor, x, n2, pr) {
  var isTruncated, r2 = new Ctor(1), k = Math.ceil(pr / LOG_BASE + 4);
  external = false;
  for (; ; ) {
    if (n2 % 2) {
      r2 = r2.times(x);
      if (truncate(r2.d, k))
        isTruncated = true;
    }
    n2 = mathfloor(n2 / 2);
    if (n2 === 0) {
      n2 = r2.d.length - 1;
      if (isTruncated && r2.d[n2] === 0)
        ++r2.d[n2];
      break;
    }
    x = x.times(x);
    truncate(x.d, k);
  }
  external = true;
  return r2;
}
__name(intPow, "intPow");
function isOdd(n2) {
  return n2.d[n2.d.length - 1] & 1;
}
__name(isOdd, "isOdd");
function maxOrMin(Ctor, args, ltgt) {
  var y2, x = new Ctor(args[0]), i = 0;
  for (; ++i < args.length; ) {
    y2 = new Ctor(args[i]);
    if (!y2.s) {
      x = y2;
      break;
    } else if (x[ltgt](y2)) {
      x = y2;
    }
  }
  return x;
}
__name(maxOrMin, "maxOrMin");
function naturalExponential(x, sd) {
  var denominator, guard, j, pow2, sum2, t3, wpr, rep = 0, i = 0, k = 0, Ctor = x.constructor, rm = Ctor.rounding, pr = Ctor.precision;
  if (!x.d || !x.d[0] || x.e > 17) {
    return new Ctor(x.d ? !x.d[0] ? 1 : x.s < 0 ? 0 : 1 / 0 : x.s ? x.s < 0 ? 0 : x : 0 / 0);
  }
  if (sd == null) {
    external = false;
    wpr = pr;
  } else {
    wpr = sd;
  }
  t3 = new Ctor(0.03125);
  while (x.e > -2) {
    x = x.times(t3);
    k += 5;
  }
  guard = Math.log(mathpow(2, k)) / Math.LN10 * 2 + 5 | 0;
  wpr += guard;
  denominator = pow2 = sum2 = new Ctor(1);
  Ctor.precision = wpr;
  for (; ; ) {
    pow2 = finalise(pow2.times(x), wpr, 1);
    denominator = denominator.times(++i);
    t3 = sum2.plus(divide(pow2, denominator, wpr, 1));
    if (digitsToString(t3.d).slice(0, wpr) === digitsToString(sum2.d).slice(0, wpr)) {
      j = k;
      while (j--)
        sum2 = finalise(sum2.times(sum2), wpr, 1);
      if (sd == null) {
        if (rep < 3 && checkRoundingDigits(sum2.d, wpr - guard, rm, rep)) {
          Ctor.precision = wpr += 10;
          denominator = pow2 = t3 = new Ctor(1);
          i = 0;
          rep++;
        } else {
          return finalise(sum2, Ctor.precision = pr, rm, external = true);
        }
      } else {
        Ctor.precision = pr;
        return sum2;
      }
    }
    sum2 = t3;
  }
}
__name(naturalExponential, "naturalExponential");
function naturalLogarithm(y2, sd) {
  var c, c0, denominator, e2, numerator, rep, sum2, t3, wpr, x1, x2, n2 = 1, guard = 10, x = y2, xd = x.d, Ctor = x.constructor, rm = Ctor.rounding, pr = Ctor.precision;
  if (x.s < 0 || !xd || !xd[0] || !x.e && xd[0] == 1 && xd.length == 1) {
    return new Ctor(xd && !xd[0] ? -1 / 0 : x.s != 1 ? NaN : xd ? 0 : x);
  }
  if (sd == null) {
    external = false;
    wpr = pr;
  } else {
    wpr = sd;
  }
  Ctor.precision = wpr += guard;
  c = digitsToString(xd);
  c0 = c.charAt(0);
  if (Math.abs(e2 = x.e) < 15e14) {
    while (c0 < 7 && c0 != 1 || c0 == 1 && c.charAt(1) > 3) {
      x = x.times(y2);
      c = digitsToString(x.d);
      c0 = c.charAt(0);
      n2++;
    }
    e2 = x.e;
    if (c0 > 1) {
      x = new Ctor("0." + c);
      e2++;
    } else {
      x = new Ctor(c0 + "." + c.slice(1));
    }
  } else {
    t3 = getLn10(Ctor, wpr + 2, pr).times(e2 + "");
    x = naturalLogarithm(new Ctor(c0 + "." + c.slice(1)), wpr - guard).plus(t3);
    Ctor.precision = pr;
    return sd == null ? finalise(x, pr, rm, external = true) : x;
  }
  x1 = x;
  sum2 = numerator = x = divide(x.minus(1), x.plus(1), wpr, 1);
  x2 = finalise(x.times(x), wpr, 1);
  denominator = 3;
  for (; ; ) {
    numerator = finalise(numerator.times(x2), wpr, 1);
    t3 = sum2.plus(divide(numerator, new Ctor(denominator), wpr, 1));
    if (digitsToString(t3.d).slice(0, wpr) === digitsToString(sum2.d).slice(0, wpr)) {
      sum2 = sum2.times(2);
      if (e2 !== 0)
        sum2 = sum2.plus(getLn10(Ctor, wpr + 2, pr).times(e2 + ""));
      sum2 = divide(sum2, new Ctor(n2), wpr, 1);
      if (sd == null) {
        if (checkRoundingDigits(sum2.d, wpr - guard, rm, rep)) {
          Ctor.precision = wpr += guard;
          t3 = numerator = x = divide(x1.minus(1), x1.plus(1), wpr, 1);
          x2 = finalise(x.times(x), wpr, 1);
          denominator = rep = 1;
        } else {
          return finalise(sum2, Ctor.precision = pr, rm, external = true);
        }
      } else {
        Ctor.precision = pr;
        return sum2;
      }
    }
    sum2 = t3;
    denominator += 2;
  }
}
__name(naturalLogarithm, "naturalLogarithm");
function nonFiniteToString(x) {
  return String(x.s * x.s / 0);
}
__name(nonFiniteToString, "nonFiniteToString");
function parseDecimal(x, str) {
  var e2, i, len;
  if ((e2 = str.indexOf(".")) > -1)
    str = str.replace(".", "");
  if ((i = str.search(/e/i)) > 0) {
    if (e2 < 0)
      e2 = i;
    e2 += +str.slice(i + 1);
    str = str.substring(0, i);
  } else if (e2 < 0) {
    e2 = str.length;
  }
  for (i = 0; str.charCodeAt(i) === 48; i++)
    ;
  for (len = str.length; str.charCodeAt(len - 1) === 48; --len)
    ;
  str = str.slice(i, len);
  if (str) {
    len -= i;
    x.e = e2 = e2 - i - 1;
    x.d = [];
    i = (e2 + 1) % LOG_BASE;
    if (e2 < 0)
      i += LOG_BASE;
    if (i < len) {
      if (i)
        x.d.push(+str.slice(0, i));
      for (len -= LOG_BASE; i < len; )
        x.d.push(+str.slice(i, i += LOG_BASE));
      str = str.slice(i);
      i = LOG_BASE - str.length;
    } else {
      i -= len;
    }
    for (; i--; )
      str += "0";
    x.d.push(+str);
    if (external) {
      if (x.e > x.constructor.maxE) {
        x.d = null;
        x.e = NaN;
      } else if (x.e < x.constructor.minE) {
        x.e = 0;
        x.d = [0];
      }
    }
  } else {
    x.e = 0;
    x.d = [0];
  }
  return x;
}
__name(parseDecimal, "parseDecimal");
function parseOther(x, str) {
  var base, Ctor, divisor, i, isFloat, len, p2, xd, xe;
  if (str.indexOf("_") > -1) {
    str = str.replace(/(\d)_(?=\d)/g, "$1");
    if (isDecimal.test(str))
      return parseDecimal(x, str);
  } else if (str === "Infinity" || str === "NaN") {
    if (!+str)
      x.s = NaN;
    x.e = NaN;
    x.d = null;
    return x;
  }
  if (isHex.test(str)) {
    base = 16;
    str = str.toLowerCase();
  } else if (isBinary.test(str)) {
    base = 2;
  } else if (isOctal.test(str)) {
    base = 8;
  } else {
    throw Error(invalidArgument + str);
  }
  i = str.search(/p/i);
  if (i > 0) {
    p2 = +str.slice(i + 1);
    str = str.substring(2, i);
  } else {
    str = str.slice(2);
  }
  i = str.indexOf(".");
  isFloat = i >= 0;
  Ctor = x.constructor;
  if (isFloat) {
    str = str.replace(".", "");
    len = str.length;
    i = len - i;
    divisor = intPow(Ctor, new Ctor(base), i, i * 2);
  }
  xd = convertBase(str, base, BASE);
  xe = xd.length - 1;
  for (i = xe; xd[i] === 0; --i)
    xd.pop();
  if (i < 0)
    return new Ctor(x.s * 0);
  x.e = getBase10Exponent(xd, xe);
  x.d = xd;
  external = false;
  if (isFloat)
    x = divide(x, divisor, len * 4);
  if (p2)
    x = x.times(Math.abs(p2) < 54 ? mathpow(2, p2) : Decimal.pow(2, p2));
  external = true;
  return x;
}
__name(parseOther, "parseOther");
function sine(Ctor, x) {
  var k, len = x.d.length;
  if (len < 3) {
    return x.isZero() ? x : taylorSeries(Ctor, 2, x, x);
  }
  k = 1.4 * Math.sqrt(len);
  k = k > 16 ? 16 : k | 0;
  x = x.times(1 / tinyPow(5, k));
  x = taylorSeries(Ctor, 2, x, x);
  var sin2_x, d5 = new Ctor(5), d16 = new Ctor(16), d20 = new Ctor(20);
  for (; k--; ) {
    sin2_x = x.times(x);
    x = x.times(d5.plus(sin2_x.times(d16.times(sin2_x).minus(d20))));
  }
  return x;
}
__name(sine, "sine");
function taylorSeries(Ctor, n2, x, y2, isHyperbolic) {
  var j, t3, u2, x2, i = 1, pr = Ctor.precision, k = Math.ceil(pr / LOG_BASE);
  external = false;
  x2 = x.times(x);
  u2 = new Ctor(y2);
  for (; ; ) {
    t3 = divide(u2.times(x2), new Ctor(n2++ * n2++), pr, 1);
    u2 = isHyperbolic ? y2.plus(t3) : y2.minus(t3);
    y2 = divide(t3.times(x2), new Ctor(n2++ * n2++), pr, 1);
    t3 = u2.plus(y2);
    if (t3.d[k] !== void 0) {
      for (j = k; t3.d[j] === u2.d[j] && j--; )
        ;
      if (j == -1)
        break;
    }
    j = u2;
    u2 = y2;
    y2 = t3;
    t3 = j;
    i++;
  }
  external = true;
  t3.d.length = k + 1;
  return t3;
}
__name(taylorSeries, "taylorSeries");
function tinyPow(b2, e2) {
  var n2 = b2;
  while (--e2)
    n2 *= b2;
  return n2;
}
__name(tinyPow, "tinyPow");
function toLessThanHalfPi(Ctor, x) {
  var t3, isNeg = x.s < 0, pi = getPi(Ctor, Ctor.precision, 1), halfPi = pi.times(0.5);
  x = x.abs();
  if (x.lte(halfPi)) {
    quadrant = isNeg ? 4 : 1;
    return x;
  }
  t3 = x.divToInt(pi);
  if (t3.isZero()) {
    quadrant = isNeg ? 3 : 2;
  } else {
    x = x.minus(t3.times(pi));
    if (x.lte(halfPi)) {
      quadrant = isOdd(t3) ? isNeg ? 2 : 3 : isNeg ? 4 : 1;
      return x;
    }
    quadrant = isOdd(t3) ? isNeg ? 1 : 4 : isNeg ? 3 : 2;
  }
  return x.minus(pi).abs();
}
__name(toLessThanHalfPi, "toLessThanHalfPi");
function toStringBinary(x, baseOut, sd, rm) {
  var base, e2, i, k, len, roundUp, str, xd, y2, Ctor = x.constructor, isExp = sd !== void 0;
  if (isExp) {
    checkInt32(sd, 1, MAX_DIGITS);
    if (rm === void 0)
      rm = Ctor.rounding;
    else
      checkInt32(rm, 0, 8);
  } else {
    sd = Ctor.precision;
    rm = Ctor.rounding;
  }
  if (!x.isFinite()) {
    str = nonFiniteToString(x);
  } else {
    str = finiteToString(x);
    i = str.indexOf(".");
    if (isExp) {
      base = 2;
      if (baseOut == 16) {
        sd = sd * 4 - 3;
      } else if (baseOut == 8) {
        sd = sd * 3 - 2;
      }
    } else {
      base = baseOut;
    }
    if (i >= 0) {
      str = str.replace(".", "");
      y2 = new Ctor(1);
      y2.e = str.length - i;
      y2.d = convertBase(finiteToString(y2), 10, base);
      y2.e = y2.d.length;
    }
    xd = convertBase(str, 10, base);
    e2 = len = xd.length;
    for (; xd[--len] == 0; )
      xd.pop();
    if (!xd[0]) {
      str = isExp ? "0p+0" : "0";
    } else {
      if (i < 0) {
        e2--;
      } else {
        x = new Ctor(x);
        x.d = xd;
        x.e = e2;
        x = divide(x, y2, sd, rm, 0, base);
        xd = x.d;
        e2 = x.e;
        roundUp = inexact;
      }
      i = xd[sd];
      k = base / 2;
      roundUp = roundUp || xd[sd + 1] !== void 0;
      roundUp = rm < 4 ? (i !== void 0 || roundUp) && (rm === 0 || rm === (x.s < 0 ? 3 : 2)) : i > k || i === k && (rm === 4 || roundUp || rm === 6 && xd[sd - 1] & 1 || rm === (x.s < 0 ? 8 : 7));
      xd.length = sd;
      if (roundUp) {
        for (; ++xd[--sd] > base - 1; ) {
          xd[sd] = 0;
          if (!sd) {
            ++e2;
            xd.unshift(1);
          }
        }
      }
      for (len = xd.length; !xd[len - 1]; --len)
        ;
      for (i = 0, str = ""; i < len; i++)
        str += NUMERALS.charAt(xd[i]);
      if (isExp) {
        if (len > 1) {
          if (baseOut == 16 || baseOut == 8) {
            i = baseOut == 16 ? 4 : 3;
            for (--len; len % i; len++)
              str += "0";
            xd = convertBase(str, base, baseOut);
            for (len = xd.length; !xd[len - 1]; --len)
              ;
            for (i = 1, str = "1."; i < len; i++)
              str += NUMERALS.charAt(xd[i]);
          } else {
            str = str.charAt(0) + "." + str.slice(1);
          }
        }
        str = str + (e2 < 0 ? "p" : "p+") + e2;
      } else if (e2 < 0) {
        for (; ++e2; )
          str = "0" + str;
        str = "0." + str;
      } else {
        if (++e2 > len)
          for (e2 -= len; e2--; )
            str += "0";
        else if (e2 < len)
          str = str.slice(0, e2) + "." + str.slice(e2);
      }
    }
    str = (baseOut == 16 ? "0x" : baseOut == 2 ? "0b" : baseOut == 8 ? "0o" : "") + str;
  }
  return x.s < 0 ? "-" + str : str;
}
__name(toStringBinary, "toStringBinary");
function truncate(arr, len) {
  if (arr.length > len) {
    arr.length = len;
    return true;
  }
}
__name(truncate, "truncate");
function abs(x) {
  return new this(x).abs();
}
__name(abs, "abs");
function acos(x) {
  return new this(x).acos();
}
__name(acos, "acos");
function acosh(x) {
  return new this(x).acosh();
}
__name(acosh, "acosh");
function add(x, y2) {
  return new this(x).plus(y2);
}
__name(add, "add");
function asin(x) {
  return new this(x).asin();
}
__name(asin, "asin");
function asinh(x) {
  return new this(x).asinh();
}
__name(asinh, "asinh");
function atan(x) {
  return new this(x).atan();
}
__name(atan, "atan");
function atanh(x) {
  return new this(x).atanh();
}
__name(atanh, "atanh");
function atan2(y2, x) {
  y2 = new this(y2);
  x = new this(x);
  var r2, pr = this.precision, rm = this.rounding, wpr = pr + 4;
  if (!y2.s || !x.s) {
    r2 = new this(NaN);
  } else if (!y2.d && !x.d) {
    r2 = getPi(this, wpr, 1).times(x.s > 0 ? 0.25 : 0.75);
    r2.s = y2.s;
  } else if (!x.d || y2.isZero()) {
    r2 = x.s < 0 ? getPi(this, pr, rm) : new this(0);
    r2.s = y2.s;
  } else if (!y2.d || x.isZero()) {
    r2 = getPi(this, wpr, 1).times(0.5);
    r2.s = y2.s;
  } else if (x.s < 0) {
    this.precision = wpr;
    this.rounding = 1;
    r2 = this.atan(divide(y2, x, wpr, 1));
    x = getPi(this, wpr, 1);
    this.precision = pr;
    this.rounding = rm;
    r2 = y2.s < 0 ? r2.minus(x) : r2.plus(x);
  } else {
    r2 = this.atan(divide(y2, x, wpr, 1));
  }
  return r2;
}
__name(atan2, "atan2");
function cbrt(x) {
  return new this(x).cbrt();
}
__name(cbrt, "cbrt");
function ceil(x) {
  return finalise(x = new this(x), x.e + 1, 2);
}
__name(ceil, "ceil");
function clamp(x, min2, max2) {
  return new this(x).clamp(min2, max2);
}
__name(clamp, "clamp");
function config(obj) {
  if (!obj || typeof obj !== "object")
    throw Error(decimalError + "Object expected");
  var i, p2, v, useDefaults = obj.defaults === true, ps = [
    "precision",
    1,
    MAX_DIGITS,
    "rounding",
    0,
    8,
    "toExpNeg",
    -EXP_LIMIT,
    0,
    "toExpPos",
    0,
    EXP_LIMIT,
    "maxE",
    0,
    EXP_LIMIT,
    "minE",
    -EXP_LIMIT,
    0,
    "modulo",
    0,
    9
  ];
  for (i = 0; i < ps.length; i += 3) {
    if (p2 = ps[i], useDefaults)
      this[p2] = DEFAULTS[p2];
    if ((v = obj[p2]) !== void 0) {
      if (mathfloor(v) === v && v >= ps[i + 1] && v <= ps[i + 2])
        this[p2] = v;
      else
        throw Error(invalidArgument + p2 + ": " + v);
    }
  }
  if (p2 = "crypto", useDefaults)
    this[p2] = DEFAULTS[p2];
  if ((v = obj[p2]) !== void 0) {
    if (v === true || v === false || v === 0 || v === 1) {
      if (v) {
        if (typeof crypto != "undefined" && crypto && (crypto.getRandomValues || crypto.randomBytes)) {
          this[p2] = true;
        } else {
          throw Error(cryptoUnavailable);
        }
      } else {
        this[p2] = false;
      }
    } else {
      throw Error(invalidArgument + p2 + ": " + v);
    }
  }
  return this;
}
__name(config, "config");
function cos(x) {
  return new this(x).cos();
}
__name(cos, "cos");
function cosh(x) {
  return new this(x).cosh();
}
__name(cosh, "cosh");
function clone(obj) {
  var i, p2, ps;
  function Decimal2(v) {
    var e2, i2, t3, x = this;
    if (!(x instanceof Decimal2))
      return new Decimal2(v);
    x.constructor = Decimal2;
    if (isDecimalInstance(v)) {
      x.s = v.s;
      if (external) {
        if (!v.d || v.e > Decimal2.maxE) {
          x.e = NaN;
          x.d = null;
        } else if (v.e < Decimal2.minE) {
          x.e = 0;
          x.d = [0];
        } else {
          x.e = v.e;
          x.d = v.d.slice();
        }
      } else {
        x.e = v.e;
        x.d = v.d ? v.d.slice() : v.d;
      }
      return;
    }
    t3 = typeof v;
    if (t3 === "number") {
      if (v === 0) {
        x.s = 1 / v < 0 ? -1 : 1;
        x.e = 0;
        x.d = [0];
        return;
      }
      if (v < 0) {
        v = -v;
        x.s = -1;
      } else {
        x.s = 1;
      }
      if (v === ~~v && v < 1e7) {
        for (e2 = 0, i2 = v; i2 >= 10; i2 /= 10)
          e2++;
        if (external) {
          if (e2 > Decimal2.maxE) {
            x.e = NaN;
            x.d = null;
          } else if (e2 < Decimal2.minE) {
            x.e = 0;
            x.d = [0];
          } else {
            x.e = e2;
            x.d = [v];
          }
        } else {
          x.e = e2;
          x.d = [v];
        }
        return;
      } else if (v * 0 !== 0) {
        if (!v)
          x.s = NaN;
        x.e = NaN;
        x.d = null;
        return;
      }
      return parseDecimal(x, v.toString());
    } else if (t3 !== "string") {
      throw Error(invalidArgument + v);
    }
    if ((i2 = v.charCodeAt(0)) === 45) {
      v = v.slice(1);
      x.s = -1;
    } else {
      if (i2 === 43)
        v = v.slice(1);
      x.s = 1;
    }
    return isDecimal.test(v) ? parseDecimal(x, v) : parseOther(x, v);
  }
  __name(Decimal2, "Decimal");
  Decimal2.prototype = P;
  Decimal2.ROUND_UP = 0;
  Decimal2.ROUND_DOWN = 1;
  Decimal2.ROUND_CEIL = 2;
  Decimal2.ROUND_FLOOR = 3;
  Decimal2.ROUND_HALF_UP = 4;
  Decimal2.ROUND_HALF_DOWN = 5;
  Decimal2.ROUND_HALF_EVEN = 6;
  Decimal2.ROUND_HALF_CEIL = 7;
  Decimal2.ROUND_HALF_FLOOR = 8;
  Decimal2.EUCLID = 9;
  Decimal2.config = Decimal2.set = config;
  Decimal2.clone = clone;
  Decimal2.isDecimal = isDecimalInstance;
  Decimal2.abs = abs;
  Decimal2.acos = acos;
  Decimal2.acosh = acosh;
  Decimal2.add = add;
  Decimal2.asin = asin;
  Decimal2.asinh = asinh;
  Decimal2.atan = atan;
  Decimal2.atanh = atanh;
  Decimal2.atan2 = atan2;
  Decimal2.cbrt = cbrt;
  Decimal2.ceil = ceil;
  Decimal2.clamp = clamp;
  Decimal2.cos = cos;
  Decimal2.cosh = cosh;
  Decimal2.div = div;
  Decimal2.exp = exp;
  Decimal2.floor = floor;
  Decimal2.hypot = hypot;
  Decimal2.ln = ln;
  Decimal2.log = log;
  Decimal2.log10 = log10;
  Decimal2.log2 = log2;
  Decimal2.max = max;
  Decimal2.min = min;
  Decimal2.mod = mod;
  Decimal2.mul = mul;
  Decimal2.pow = pow;
  Decimal2.random = random;
  Decimal2.round = round;
  Decimal2.sign = sign;
  Decimal2.sin = sin;
  Decimal2.sinh = sinh;
  Decimal2.sqrt = sqrt;
  Decimal2.sub = sub;
  Decimal2.sum = sum;
  Decimal2.tan = tan;
  Decimal2.tanh = tanh;
  Decimal2.trunc = trunc;
  if (obj === void 0)
    obj = {};
  if (obj) {
    if (obj.defaults !== true) {
      ps = ["precision", "rounding", "toExpNeg", "toExpPos", "maxE", "minE", "modulo", "crypto"];
      for (i = 0; i < ps.length; )
        if (!obj.hasOwnProperty(p2 = ps[i++]))
          obj[p2] = this[p2];
    }
  }
  Decimal2.config(obj);
  return Decimal2;
}
__name(clone, "clone");
function div(x, y2) {
  return new this(x).div(y2);
}
__name(div, "div");
function exp(x) {
  return new this(x).exp();
}
__name(exp, "exp");
function floor(x) {
  return finalise(x = new this(x), x.e + 1, 3);
}
__name(floor, "floor");
function hypot() {
  var i, n2, t3 = new this(0);
  external = false;
  for (i = 0; i < arguments.length; ) {
    n2 = new this(arguments[i++]);
    if (!n2.d) {
      if (n2.s) {
        external = true;
        return new this(1 / 0);
      }
      t3 = n2;
    } else if (t3.d) {
      t3 = t3.plus(n2.times(n2));
    }
  }
  external = true;
  return t3.sqrt();
}
__name(hypot, "hypot");
function isDecimalInstance(obj) {
  return obj instanceof Decimal || obj && obj.toStringTag === tag || false;
}
__name(isDecimalInstance, "isDecimalInstance");
function ln(x) {
  return new this(x).ln();
}
__name(ln, "ln");
function log(x, y2) {
  return new this(x).log(y2);
}
__name(log, "log");
function log2(x) {
  return new this(x).log(2);
}
__name(log2, "log2");
function log10(x) {
  return new this(x).log(10);
}
__name(log10, "log10");
function max() {
  return maxOrMin(this, arguments, "lt");
}
__name(max, "max");
function min() {
  return maxOrMin(this, arguments, "gt");
}
__name(min, "min");
function mod(x, y2) {
  return new this(x).mod(y2);
}
__name(mod, "mod");
function mul(x, y2) {
  return new this(x).mul(y2);
}
__name(mul, "mul");
function pow(x, y2) {
  return new this(x).pow(y2);
}
__name(pow, "pow");
function random(sd) {
  var d2, e2, k, n2, i = 0, r2 = new this(1), rd = [];
  if (sd === void 0)
    sd = this.precision;
  else
    checkInt32(sd, 1, MAX_DIGITS);
  k = Math.ceil(sd / LOG_BASE);
  if (!this.crypto) {
    for (; i < k; )
      rd[i++] = Math.random() * 1e7 | 0;
  } else if (crypto.getRandomValues) {
    d2 = crypto.getRandomValues(new Uint32Array(k));
    for (; i < k; ) {
      n2 = d2[i];
      if (n2 >= 429e7) {
        d2[i] = crypto.getRandomValues(new Uint32Array(1))[0];
      } else {
        rd[i++] = n2 % 1e7;
      }
    }
  } else if (crypto.randomBytes) {
    d2 = crypto.randomBytes(k *= 4);
    for (; i < k; ) {
      n2 = d2[i] + (d2[i + 1] << 8) + (d2[i + 2] << 16) + ((d2[i + 3] & 127) << 24);
      if (n2 >= 214e7) {
        crypto.randomBytes(4).copy(d2, i);
      } else {
        rd.push(n2 % 1e7);
        i += 4;
      }
    }
    i = k / 4;
  } else {
    throw Error(cryptoUnavailable);
  }
  k = rd[--i];
  sd %= LOG_BASE;
  if (k && sd) {
    n2 = mathpow(10, LOG_BASE - sd);
    rd[i] = (k / n2 | 0) * n2;
  }
  for (; rd[i] === 0; i--)
    rd.pop();
  if (i < 0) {
    e2 = 0;
    rd = [0];
  } else {
    e2 = -1;
    for (; rd[0] === 0; e2 -= LOG_BASE)
      rd.shift();
    for (k = 1, n2 = rd[0]; n2 >= 10; n2 /= 10)
      k++;
    if (k < LOG_BASE)
      e2 -= LOG_BASE - k;
  }
  r2.e = e2;
  r2.d = rd;
  return r2;
}
__name(random, "random");
function round(x) {
  return finalise(x = new this(x), x.e + 1, this.rounding);
}
__name(round, "round");
function sign(x) {
  x = new this(x);
  return x.d ? x.d[0] ? x.s : 0 * x.s : x.s || NaN;
}
__name(sign, "sign");
function sin(x) {
  return new this(x).sin();
}
__name(sin, "sin");
function sinh(x) {
  return new this(x).sinh();
}
__name(sinh, "sinh");
function sqrt(x) {
  return new this(x).sqrt();
}
__name(sqrt, "sqrt");
function sub(x, y2) {
  return new this(x).sub(y2);
}
__name(sub, "sub");
function sum() {
  var i = 0, args = arguments, x = new this(args[i]);
  external = false;
  for (; x.s && ++i < args.length; )
    x = x.plus(args[i]);
  external = true;
  return finalise(x, this.precision, this.rounding);
}
__name(sum, "sum");
function tan(x) {
  return new this(x).tan();
}
__name(tan, "tan");
function tanh(x) {
  return new this(x).tanh();
}
__name(tanh, "tanh");
function trunc(x) {
  return finalise(x = new this(x), x.e + 1, 1);
}
__name(trunc, "trunc");
P[Symbol.for("nodejs.util.inspect.custom")] = P.toString;
P[Symbol.toStringTag] = "Decimal";
var Decimal = P.constructor = clone(DEFAULTS);
LN10 = new Decimal(LN10);
PI = new Decimal(PI);

// src/runtime/utils/common.ts
var import_indent_string = __toESM(require_indent_string());
var import_js_levenshtein = __toESM(require_js_levenshtein());

// src/runtime/object-enums.ts
var objectEnumNames = ["JsonNullValueInput", "NullableJsonNullValueInput", "JsonNullValueFilter"];
var secret = Symbol();
var representations = /* @__PURE__ */ new WeakMap();
var ObjectEnumValue = class {
  constructor(arg) {
    if (arg === secret) {
      representations.set(this, `Prisma.${this._getName()}`);
    } else {
      representations.set(this, `new Prisma.${this._getNamespace()}.${this._getName()}()`);
    }
  }
  _getName() {
    return this.constructor.name;
  }
  toString() {
    return representations.get(this);
  }
};
__name(ObjectEnumValue, "ObjectEnumValue");
var NullTypesEnumValue = class extends ObjectEnumValue {
  _getNamespace() {
    return "NullTypes";
  }
};
__name(NullTypesEnumValue, "NullTypesEnumValue");
var DbNull = class extends NullTypesEnumValue {
};
__name(DbNull, "DbNull");
var JsonNull = class extends NullTypesEnumValue {
};
__name(JsonNull, "JsonNull");
var AnyNull = class extends NullTypesEnumValue {
};
__name(AnyNull, "AnyNull");
var objectEnumValues = {
  classes: {
    DbNull,
    JsonNull,
    AnyNull
  },
  instances: {
    DbNull: new DbNull(secret),
    JsonNull: new JsonNull(secret),
    AnyNull: new AnyNull(secret)
  }
};

// src/runtime/utils/common.ts
var keyBy = /* @__PURE__ */ __name((collection, prop) => {
  const acc = {};
  for (const obj of collection) {
    const key = obj[prop];
    acc[key] = obj;
  }
  return acc;
}, "keyBy");
var ScalarTypeTable = {
  String: true,
  Int: true,
  Float: true,
  Boolean: true,
  Long: true,
  DateTime: true,
  ID: true,
  UUID: true,
  Json: true,
  Bytes: true,
  Decimal: true,
  BigInt: true
};
var needNamespace = {
  Json: "JsonValue",
  Decimal: "Decimal"
};
function needsNamespace(fieldType, dmmf2) {
  if (typeof fieldType === "string") {
    if (dmmf2.datamodelEnumMap[fieldType]) {
      return false;
    }
    if (GraphQLScalarToJSTypeTable[fieldType]) {
      return Boolean(needNamespace[fieldType]);
    }
  }
  return true;
}
__name(needsNamespace, "needsNamespace");
var GraphQLScalarToJSTypeTable = {
  String: "string",
  Int: "number",
  Float: "number",
  Boolean: "boolean",
  Long: "number",
  DateTime: ["Date", "string"],
  ID: "string",
  UUID: "string",
  Json: "JsonValue",
  Bytes: "Buffer",
  Decimal: ["Decimal", "DecimalJsLike", "number", "string"],
  BigInt: ["bigint", "number"]
};
var JSOutputTypeToInputType = {
  JsonValue: "InputJsonValue"
};
function argIsInputType(arg) {
  if (typeof arg === "string") {
    return false;
  }
  return true;
}
__name(argIsInputType, "argIsInputType");
function capitalize(str) {
  return str[0].toUpperCase() + str.slice(1);
}
__name(capitalize, "capitalize");
function lowerCase(name) {
  return name.substring(0, 1).toLowerCase() + name.substring(1);
}
__name(lowerCase, "lowerCase");
function isSchemaEnum(type) {
  return typeof type === "object" && type !== null && typeof type.name === "string" && Array.isArray(type.values);
}
__name(isSchemaEnum, "isSchemaEnum");

// src/runtime/externalToInternalDmmf.ts
function externalToInternalDmmf(document2) {
  return {
    ...document2,
    mappings: getMappings(document2.mappings, document2.datamodel)
  };
}
__name(externalToInternalDmmf, "externalToInternalDmmf");
function getMappings(mappings, datamodel2) {
  const modelOperations = mappings.modelOperations.filter((mapping) => {
    const model = datamodel2.models.find((m) => m.name === mapping.model);
    if (!model) {
      throw new Error(`Mapping without model ${mapping.model}`);
    }
    return model.fields.some((f) => f.kind !== "object");
  }).map((mapping) => ({
    model: mapping.model,
    plural: (0, import_pluralize.default)(lowerCase(mapping.model)),
    findUnique: mapping.findUnique || mapping.findSingle,
    findUniqueOrThrow: mapping.findUniqueOrThrow,
    findFirst: mapping.findFirst,
    findFirstOrThrow: mapping.findFirstOrThrow,
    findMany: mapping.findMany,
    create: mapping.createOne || mapping.createSingle || mapping.create,
    createMany: mapping.createMany,
    delete: mapping.deleteOne || mapping.deleteSingle || mapping.delete,
    update: mapping.updateOne || mapping.updateSingle || mapping.update,
    deleteMany: mapping.deleteMany,
    updateMany: mapping.updateMany,
    upsert: mapping.upsertOne || mapping.upsertSingle || mapping.upsert,
    aggregate: mapping.aggregate,
    groupBy: mapping.groupBy,
    findRaw: mapping.findRaw,
    aggregateRaw: mapping.aggregateRaw
  }));
  return {
    modelOperations,
    otherOperations: mappings.otherOperations
  };
}
__name(getMappings, "getMappings");

// src/generation/generateClient.ts
var import_chalk8 = __toESM(require_source());
var import_fs10 = __toESM(require("fs"));
var import_fs_extra2 = __toESM(require_lib4());
var import_path8 = __toESM(require("path"));
var import_pkg_up = __toESM(require_pkg_up());
var import_util6 = require("util");
var import_package = __toESM(require_package3());

// src/generation/getDMMF.ts
function getPrismaClientDMMF(dmmf2) {
  return externalToInternalDmmf(dmmf2);
}
__name(getPrismaClientDMMF, "getPrismaClientDMMF");

// ../../node_modules/.pnpm/flat-map-polyfill@0.3.8/node_modules/flat-map-polyfill/dist/cjs/index.js
require_flatten();
require_flat_map();

// src/generation/TSClient/Args.ts
var import_indent_string14 = __toESM(require_indent_string());

// src/generation/utils.ts
var import_indent_string13 = __toESM(require_indent_string());

// src/generation/TSClient/TSClient.ts
var import_indent_string12 = __toESM(require_indent_string());

// ../../node_modules/.pnpm/klona@2.0.6/node_modules/klona/dist/index.mjs
function klona(x) {
  if (typeof x !== "object")
    return x;
  var k, tmp, str = Object.prototype.toString.call(x);
  if (str === "[object Object]") {
    if (x.constructor !== Object && typeof x.constructor === "function") {
      tmp = new x.constructor();
      for (k in x) {
        if (x.hasOwnProperty(k) && tmp[k] !== x[k]) {
          tmp[k] = klona(x[k]);
        }
      }
    } else {
      tmp = {};
      for (k in x) {
        if (k === "__proto__") {
          Object.defineProperty(tmp, k, {
            value: klona(x[k]),
            configurable: true,
            enumerable: true,
            writable: true
          });
        } else {
          tmp[k] = klona(x[k]);
        }
      }
    }
    return tmp;
  }
  if (str === "[object Array]") {
    k = x.length;
    for (tmp = Array(k); k--; ) {
      tmp[k] = klona(x[k]);
    }
    return tmp;
  }
  if (str === "[object Set]") {
    tmp = /* @__PURE__ */ new Set();
    x.forEach(function(val) {
      tmp.add(klona(val));
    });
    return tmp;
  }
  if (str === "[object Map]") {
    tmp = /* @__PURE__ */ new Map();
    x.forEach(function(val, key) {
      tmp.set(klona(key), klona(val));
    });
    return tmp;
  }
  if (str === "[object Date]") {
    return new Date(+x);
  }
  if (str === "[object RegExp]") {
    tmp = new RegExp(x.source, x.flags);
    tmp.lastIndex = x.lastIndex;
    return tmp;
  }
  if (str === "[object DataView]") {
    return new x.constructor(klona(x.buffer));
  }
  if (str === "[object ArrayBuffer]") {
    return x.slice(0);
  }
  if (str.slice(-6) === "Array]") {
    return new x.constructor(x);
  }
  return x;
}
__name(klona, "klona");

// src/generation/TSClient/TSClient.ts
var import_path7 = __toESM(require("path"));

// src/runtime/utils/applyMixins.ts
function applyMixins(derivedCtor, constructors) {
  for (const baseCtor of constructors) {
    for (const name of Object.getOwnPropertyNames(baseCtor.prototype)) {
      Object.defineProperty(
        derivedCtor.prototype,
        name,
        Object.getOwnPropertyDescriptor(baseCtor.prototype, name) ?? /* @__PURE__ */ Object.create(null)
      );
    }
  }
}
__name(applyMixins, "applyMixins");

// src/runtime/dmmf.ts
var DMMFDatamodelHelper = class {
  constructor({ datamodel: datamodel2 }) {
    this.datamodel = datamodel2;
    this.datamodelEnumMap = this.getDatamodelEnumMap();
    this.modelMap = this.getModelMap();
    this.typeMap = this.getTypeMap();
    this.typeAndModelMap = this.getTypeModelMap();
  }
  getDatamodelEnumMap() {
    return keyBy(this.datamodel.enums, "name");
  }
  getModelMap() {
    return { ...keyBy(this.datamodel.models, "name") };
  }
  getTypeMap() {
    return { ...keyBy(this.datamodel.types, "name") };
  }
  getTypeModelMap() {
    return { ...this.getTypeMap(), ...this.getModelMap() };
  }
};
__name(DMMFDatamodelHelper, "DMMFDatamodelHelper");
var DMMFMappingsHelper = class {
  constructor({ mappings }) {
    this.mappings = mappings;
    this.mappingsMap = this.getMappingsMap();
  }
  getMappingsMap() {
    return keyBy(this.mappings.modelOperations, "model");
  }
  getOtherOperationNames() {
    return [
      Object.values(this.mappings.otherOperations.write),
      Object.values(this.mappings.otherOperations.read)
    ].flat();
  }
};
__name(DMMFMappingsHelper, "DMMFMappingsHelper");
var DMMFSchemaHelper = class {
  constructor({ schema }) {
    this.outputTypeToMergedOutputType = /* @__PURE__ */ __name((outputType) => {
      return {
        ...outputType,
        fields: outputType.fields
      };
    }, "outputTypeToMergedOutputType");
    this.schema = schema;
    this.enumMap = this.getEnumMap();
    this.queryType = this.getQueryType();
    this.mutationType = this.getMutationType();
    this.outputTypes = this.getOutputTypes();
    this.outputTypeMap = this.getMergedOutputTypeMap();
    this.resolveOutputTypes();
    this.inputObjectTypes = this.schema.inputObjectTypes;
    this.inputTypeMap = this.getInputTypeMap();
    this.resolveInputTypes();
    this.resolveFieldArgumentTypes();
    this.queryType = this.outputTypeMap.Query;
    this.mutationType = this.outputTypeMap.Mutation;
    this.rootFieldMap = this.getRootFieldMap();
  }
  get [Symbol.toStringTag]() {
    return "DMMFClass";
  }
  resolveOutputTypes() {
    for (const type of this.outputTypes.model) {
      for (const field of type.fields) {
        if (typeof field.outputType.type === "string" && !ScalarTypeTable[field.outputType.type]) {
          field.outputType.type = this.outputTypeMap[field.outputType.type] || this.outputTypeMap[field.outputType.type] || this.enumMap[field.outputType.type] || field.outputType.type;
        }
      }
      type.fieldMap = keyBy(type.fields, "name");
    }
    for (const type of this.outputTypes.prisma) {
      for (const field of type.fields) {
        if (typeof field.outputType.type === "string" && !ScalarTypeTable[field.outputType.type]) {
          field.outputType.type = this.outputTypeMap[field.outputType.type] || this.outputTypeMap[field.outputType.type] || this.enumMap[field.outputType.type] || field.outputType.type;
        }
      }
      type.fieldMap = keyBy(type.fields, "name");
    }
  }
  resolveInputTypes() {
    const inputTypes = this.inputObjectTypes.prisma;
    if (this.inputObjectTypes.model) {
      inputTypes.push(...this.inputObjectTypes.model);
    }
    for (const type of inputTypes) {
      for (const field of type.fields) {
        for (const fieldInputType of field.inputTypes) {
          const fieldType = fieldInputType.type;
          if (typeof fieldType === "string" && !ScalarTypeTable[fieldType] && (this.inputTypeMap[fieldType] || this.enumMap[fieldType])) {
            fieldInputType.type = this.inputTypeMap[fieldType] || this.enumMap[fieldType] || fieldType;
          }
        }
      }
      type.fieldMap = keyBy(type.fields, "name");
    }
  }
  resolveFieldArgumentTypes() {
    for (const type of this.outputTypes.prisma) {
      for (const field of type.fields) {
        for (const arg of field.args) {
          for (const argInputType of arg.inputTypes) {
            const argType = argInputType.type;
            if (typeof argType === "string" && !ScalarTypeTable[argType]) {
              argInputType.type = this.inputTypeMap[argType] || this.enumMap[argType] || argType;
            }
          }
        }
      }
    }
    for (const type of this.outputTypes.model) {
      for (const field of type.fields) {
        for (const arg of field.args) {
          for (const argInputType of arg.inputTypes) {
            const argType = argInputType.type;
            if (typeof argType === "string" && !ScalarTypeTable[argType]) {
              argInputType.type = this.inputTypeMap[argType] || this.enumMap[argType] || argInputType.type;
            }
          }
        }
      }
    }
  }
  getQueryType() {
    return this.schema.outputObjectTypes.prisma.find((t3) => t3.name === "Query");
  }
  getMutationType() {
    return this.schema.outputObjectTypes.prisma.find((t3) => t3.name === "Mutation");
  }
  getOutputTypes() {
    return {
      model: this.schema.outputObjectTypes.model.map(this.outputTypeToMergedOutputType),
      prisma: this.schema.outputObjectTypes.prisma.map(this.outputTypeToMergedOutputType)
    };
  }
  getEnumMap() {
    return {
      ...keyBy(this.schema.enumTypes.prisma, "name"),
      ...this.schema.enumTypes.model ? keyBy(this.schema.enumTypes.model, "name") : void 0
    };
  }
  hasEnumInNamespace(enumName, namespace) {
    return this.schema.enumTypes[namespace]?.find((schemaEnum) => schemaEnum.name === enumName) !== void 0;
  }
  getMergedOutputTypeMap() {
    return {
      ...keyBy(this.outputTypes.model, "name"),
      ...keyBy(this.outputTypes.prisma, "name")
    };
  }
  getInputTypeMap() {
    return {
      ...this.schema.inputObjectTypes.model ? keyBy(this.schema.inputObjectTypes.model, "name") : void 0,
      ...keyBy(this.schema.inputObjectTypes.prisma, "name")
    };
  }
  getRootFieldMap() {
    return { ...keyBy(this.queryType.fields, "name"), ...keyBy(this.mutationType.fields, "name") };
  }
};
__name(DMMFSchemaHelper, "DMMFSchemaHelper");
var BaseDMMFHelper = class {
  constructor(dmmf2) {
    return Object.assign(this, new DMMFDatamodelHelper(dmmf2), new DMMFMappingsHelper(dmmf2));
  }
};
__name(BaseDMMFHelper, "BaseDMMFHelper");
applyMixins(BaseDMMFHelper, [DMMFDatamodelHelper, DMMFMappingsHelper]);
var DMMFHelper = class {
  constructor(dmmf2) {
    return Object.assign(this, new BaseDMMFHelper(dmmf2), new DMMFSchemaHelper(dmmf2));
  }
};
__name(DMMFHelper, "DMMFHelper");
applyMixins(DMMFHelper, [BaseDMMFHelper, DMMFSchemaHelper]);

// src/generation/Cache.ts
var Cache = class {
  constructor() {
    this._map = /* @__PURE__ */ new Map();
  }
  get(key) {
    return this._map.get(key)?.value;
  }
  set(key, value) {
    this._map.set(key, { value });
  }
  getOrCreate(key, create) {
    const cached = this._map.get(key);
    if (cached) {
      return cached.value;
    }
    const value = create();
    this.set(key, value);
    return value;
  }
};
__name(Cache, "Cache");

// src/generation/GenericsArgsInfo.ts
var GenericArgsInfo = class {
  constructor() {
    this._cache = new Cache();
  }
  needsGenericModelArg(topLevelType) {
    const topLevelKey = getTypeKey(topLevelType);
    return this._cache.getOrCreate(topLevelKey, () => {
      const toVisit = [{ key: topLevelKey, type: topLevelType }];
      const visited = /* @__PURE__ */ new Set();
      let item;
      while (item = toVisit.shift()) {
        const { type: currentType, key } = item;
        const cached = this._cache.get(key);
        if (cached === true) {
          this._cacheResultsForTree(item);
          return true;
        }
        if (cached === false) {
          continue;
        }
        if (visited.has(key)) {
          continue;
        }
        visited.add(key);
        if (currentType.location === "fieldRefTypes") {
          this._cacheResultsForTree(item);
          return true;
        }
        if (currentType.location === "inputObjectTypes" && typeof currentType.type === "object") {
          const inputType = currentType.type;
          if (!inputType.fields) {
            continue;
          }
          if (inputType.meta?.source) {
            this._cache.set(key, false);
            continue;
          }
          for (const field of inputType.fields) {
            toVisit.push(...field.inputTypes.map((type) => ({ key: getTypeKey(type), type, parent: item })));
          }
        }
      }
      for (const visitedKey of visited) {
        this._cache.set(visitedKey, false);
      }
      return false;
    });
  }
  _cacheResultsForTree(item) {
    let currentItem = item;
    while (currentItem) {
      this._cache.set(currentItem.key, true);
      currentItem = currentItem.parent;
    }
  }
  inputTypeNeedsGenericModelArg(inputType) {
    return this.needsGenericModelArg({ type: inputType, location: "inputObjectTypes", isList: false });
  }
};
__name(GenericArgsInfo, "GenericArgsInfo");
function getTypeKey(type) {
  const parts = [];
  if (type.namespace) {
    parts.push(type.namespace);
  }
  if (typeof type.type === "string") {
    parts.push(type.type);
  } else {
    parts.push(type.type.name);
  }
  return parts.join(".");
}
__name(getTypeKey, "getTypeKey");

// src/generation/utils/buildInjectableEdgeEnv.ts
function buildInjectableEdgeEnv(edge, datasources2) {
  if (edge === true) {
    return declareInjectableEdgeEnv(datasources2);
  }
  return ``;
}
__name(buildInjectableEdgeEnv, "buildInjectableEdgeEnv");
function declareInjectableEdgeEnv(datasources2) {
  const injectableEdgeEnv = { parsed: {} };
  const envVarNames = getSelectedEnvVarNames(datasources2);
  for (const envVarName of envVarNames) {
    injectableEdgeEnv.parsed[envVarName] = getRuntimeEdgeEnvVar(envVarName);
  }
  const injectableEdgeEnvJson = JSON.stringify(injectableEdgeEnv, null, 2);
  const injectableEdgeEnvCode = injectableEdgeEnvJson.replace(/"/g, "");
  return `
config.injectableEdgeEnv = ${injectableEdgeEnvCode}`;
}
__name(declareInjectableEdgeEnv, "declareInjectableEdgeEnv");
function getSelectedEnvVarNames(datasources2) {
  return datasources2.reduce((acc, datasource) => {
    if (datasource.url.fromEnvVar) {
      return [...acc, datasource.url.fromEnvVar];
    }
    return acc;
  }, []);
}
__name(getSelectedEnvVarNames, "getSelectedEnvVarNames");
function getRuntimeEdgeEnvVar(envVarName) {
  const cfwEnv = `typeof globalThis !== 'undefined' && globalThis['${envVarName}']`;
  const nodeOrVercelEnv = `typeof process !== 'undefined' && process.env && process.env.${envVarName}`;
  return `${cfwEnv} || ${nodeOrVercelEnv} || undefined`;
}
__name(getRuntimeEdgeEnvVar, "getRuntimeEdgeEnvVar");

// src/generation/utils/buildDebugInitialization.ts
function buildDebugInitialization(edge) {
  if (!edge) {
    return "";
  }
  const debugVar = getRuntimeEdgeEnvVar("DEBUG");
  return `if (${debugVar}) {
  Debug.enable(${debugVar})
}
`;
}
__name(buildDebugInitialization, "buildDebugInitialization");

// src/generation/utils/buildDirname.ts
var import_path5 = __toESM(require("path"));
function buildDirname(edge, relativeOutdir, runtimeDir) {
  if (edge === true) {
    return buildDirnameDefault();
  }
  return buildDirnameFind(relativeOutdir, runtimeDir);
}
__name(buildDirname, "buildDirname");
function buildDirnameFind(defaultRelativeOutdir, runtimePath) {
  const serverlessRelativeOutdir = defaultRelativeOutdir.split(import_path5.default.sep).slice(1).join(import_path5.default.sep);
  return `
const fs = require('fs')

// some frameworks or bundlers replace or totally remove __dirname
const hasDirname = typeof __dirname !== 'undefined' && __dirname !== '/'

// will work in most cases, ie. if the client has not been bundled
const regularDirname = hasDirname && fs.existsSync(path.join(__dirname, 'schema.prisma')) && __dirname

// if the client has been bundled, we need to look for the folders
const foundDirname = !regularDirname && findSync(process.cwd(), [
    ${defaultRelativeOutdir ? `${JSON.stringify(defaultRelativeOutdir)},` : ""}
    ${serverlessRelativeOutdir ? `${JSON.stringify(serverlessRelativeOutdir)},` : ""}
], ['d'], ['d'], 1)[0]

const dirname = regularDirname || foundDirname || __dirname`;
}
__name(buildDirnameFind, "buildDirnameFind");
function buildDirnameDefault() {
  return `const dirname = '/'`;
}
__name(buildDirnameDefault, "buildDirnameDefault");

// src/generation/utils/buildDMMF.ts
var import_lz_string = __toESM(require_lz_string());

// src/generation/TSClient/helpers.ts
var import_pluralize2 = __toESM(require_pluralize());

// src/generation/TSClient/jsdoc.ts
var Docs = {
  cursor: `{@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}`,
  pagination: `{@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}`,
  aggregations: `{@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}`,
  distinct: `{@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}`,
  sorting: `{@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}`
};
function addLinkToDocs(comment, docs) {
  return `${Docs[docs]}

${comment}`;
}
__name(addLinkToDocs, "addLinkToDocs");
function getDeprecationString(since, replacement) {
  return `@deprecated since ${since} please use \`${replacement}\``;
}
__name(getDeprecationString, "getDeprecationString");
var undefinedNote = `Note, that providing \`undefined\` is treated as the value not being there.
Read more here: https://pris.ly/d/null-undefined`;
var JSDocFields = {
  take: (singular, plural) => addLinkToDocs(`Take \`\xB1n\` ${plural} from the position of the cursor.`, "pagination"),
  skip: (singular, plural) => addLinkToDocs(`Skip the first \`n\` ${plural}.`, "pagination"),
  _count: (singular, plural) => addLinkToDocs(`Count returned ${plural}`, "aggregations"),
  _avg: () => addLinkToDocs(`Select which fields to average`, "aggregations"),
  _sum: () => addLinkToDocs(`Select which fields to sum`, "aggregations"),
  _min: () => addLinkToDocs(`Select which fields to find the minimum value`, "aggregations"),
  _max: () => addLinkToDocs(`Select which fields to find the maximum value`, "aggregations"),
  count: () => getDeprecationString("2.23.0", "_count"),
  avg: () => getDeprecationString("2.23.0", "_avg"),
  sum: () => getDeprecationString("2.23.0", "_sum"),
  min: () => getDeprecationString("2.23.0", "_min"),
  max: () => getDeprecationString("2.23.0", "_max"),
  distinct: (singular, plural) => addLinkToDocs(`Filter by unique combinations of ${plural}.`, "distinct"),
  orderBy: (singular, plural) => addLinkToDocs(`Determine the order of ${plural} to fetch.`, "sorting")
};
var JSDocs = {
  groupBy: {
    body: (ctx) => `Group by ${ctx.singular}.
${undefinedNote}
@param {${getGroupByArgsName(ctx.model.name)}} args - Group by arguments.
@example
// Group by city, order by createdAt, get count
const result = await prisma.user.groupBy({
  by: ['city', 'createdAt'],
  orderBy: {
    createdAt: true
  },
  _count: {
    _all: true
  },
})
`,
    fields: {}
  },
  create: {
    body: (ctx) => `Create a ${ctx.singular}.
@param {${getModelArgName(ctx.model.name, ctx.action)}} args - Arguments to create a ${ctx.singular}.
@example
// Create one ${ctx.singular}
const ${ctx.singular} = await ${ctx.method}({
  data: {
    // ... data to create a ${ctx.singular}
  }
})
`,
    fields: {
      data: (singular) => `The data needed to create a ${singular}.`
    }
  },
  createMany: {
    body: (ctx) => `Create many ${ctx.plural}.
    @param {${getModelArgName(ctx.model.name, ctx.action)}} args - Arguments to create many ${ctx.plural}.
    @example
    // Create many ${ctx.plural}
    const ${lowerCase(ctx.mapping.model)} = await ${ctx.method}({
      data: {
        // ... provide data here
      }
    })
    `,
    fields: {
      data: (singular, plural) => `The data used to create many ${plural}.`
    }
  },
  findUnique: {
    body: (ctx) => `Find zero or one ${ctx.singular} that matches the filter.
@param {${getModelArgName(ctx.model.name, ctx.action)}} args - Arguments to find a ${ctx.singular}
@example
// Get one ${ctx.singular}
const ${lowerCase(ctx.mapping.model)} = await ${ctx.method}({
  where: {
    // ... provide filter here
  }
})`,
    fields: {
      where: (singular) => `Filter, which ${singular} to fetch.`
    }
  },
  findUniqueOrThrow: {
    body: (ctx) => `Find one ${ctx.singular} that matches the filter or throw an error  with \`error.code='P2025'\` 
    if no matches were found.
@param {${getModelArgName(ctx.model.name, ctx.action)}} args - Arguments to find a ${ctx.singular}
@example
// Get one ${ctx.singular}
const ${lowerCase(ctx.mapping.model)} = await ${ctx.method}({
  where: {
    // ... provide filter here
  }
})`,
    fields: {
      where: (singular) => `Filter, which ${singular} to fetch.`
    }
  },
  findFirst: {
    body: (ctx) => `Find the first ${ctx.singular} that matches the filter.
${undefinedNote}
@param {${getModelArgName(ctx.model.name, ctx.action)}} args - Arguments to find a ${ctx.singular}
@example
// Get one ${ctx.singular}
const ${lowerCase(ctx.mapping.model)} = await ${ctx.method}({
  where: {
    // ... provide filter here
  }
})`,
    fields: {
      where: (singular) => `Filter, which ${singular} to fetch.`,
      orderBy: JSDocFields.orderBy,
      cursor: (singular, plural) => addLinkToDocs(`Sets the position for searching for ${plural}.`, "cursor"),
      take: JSDocFields.take,
      skip: JSDocFields.skip,
      distinct: JSDocFields.distinct
    }
  },
  findFirstOrThrow: {
    body: (ctx) => `Find the first ${ctx.singular} that matches the filter or
throw \`NotFoundError\` if no matches were found.
${undefinedNote}
@param {${getModelArgName(ctx.model.name, ctx.action)}} args - Arguments to find a ${ctx.singular}
@example
// Get one ${ctx.singular}
const ${lowerCase(ctx.mapping.model)} = await ${ctx.method}({
  where: {
    // ... provide filter here
  }
})`,
    fields: {
      where: (singular) => `Filter, which ${singular} to fetch.`,
      orderBy: JSDocFields.orderBy,
      cursor: (singular, plural) => addLinkToDocs(`Sets the position for searching for ${plural}.`, "cursor"),
      take: JSDocFields.take,
      skip: JSDocFields.skip,
      distinct: JSDocFields.distinct
    }
  },
  findMany: {
    body: (ctx) => {
      const onlySelect = ctx.firstScalar ? `
// Only select the \`${ctx.firstScalar.name}\`
const ${lowerCase(ctx.mapping.model)}With${capitalize(ctx.firstScalar.name)}Only = await ${ctx.method}({ select: { ${ctx.firstScalar.name}: true } })` : "";
      return `Find zero or more ${ctx.plural} that matches the filter.
${undefinedNote}
@param {${getModelArgName(ctx.model.name, ctx.action)}=} args - Arguments to filter and select certain fields only.
@example
// Get all ${ctx.plural}
const ${ctx.mapping.plural} = await ${ctx.method}()

// Get first 10 ${ctx.plural}
const ${ctx.mapping.plural} = await ${ctx.method}({ take: 10 })
${onlySelect}
`;
    },
    fields: {
      where: (singular, plural) => `Filter, which ${plural} to fetch.`,
      orderBy: JSDocFields.orderBy,
      skip: JSDocFields.skip,
      cursor: (singular, plural) => addLinkToDocs(`Sets the position for listing ${plural}.`, "cursor"),
      take: JSDocFields.take
    }
  },
  update: {
    body: (ctx) => `Update one ${ctx.singular}.
@param {${getModelArgName(ctx.model.name, ctx.action)}} args - Arguments to update one ${ctx.singular}.
@example
// Update one ${ctx.singular}
const ${lowerCase(ctx.mapping.model)} = await ${ctx.method}({
  where: {
    // ... provide filter here
  },
  data: {
    // ... provide data here
  }
})
`,
    fields: {
      data: (singular) => `The data needed to update a ${singular}.`,
      where: (singular) => `Choose, which ${singular} to update.`
    }
  },
  upsert: {
    body: (ctx) => `Create or update one ${ctx.singular}.
@param {${getModelArgName(ctx.model.name, ctx.action)}} args - Arguments to update or create a ${ctx.singular}.
@example
// Update or create a ${ctx.singular}
const ${lowerCase(ctx.mapping.model)} = await ${ctx.method}({
  create: {
    // ... data to create a ${ctx.singular}
  },
  update: {
    // ... in case it already exists, update
  },
  where: {
    // ... the filter for the ${ctx.singular} we want to update
  }
})`,
    fields: {
      where: (singular) => `The filter to search for the ${singular} to update in case it exists.`,
      create: (singular) => `In case the ${singular} found by the \`where\` argument doesn't exist, create a new ${singular} with this data.`,
      update: (singular) => `In case the ${singular} was found with the provided \`where\` argument, update it with this data.`
    }
  },
  delete: {
    body: (ctx) => `Delete a ${ctx.singular}.
@param {${getModelArgName(ctx.model.name, ctx.action)}} args - Arguments to delete one ${ctx.singular}.
@example
// Delete one ${ctx.singular}
const ${ctx.singular} = await ${ctx.method}({
  where: {
    // ... filter to delete one ${ctx.singular}
  }
})
`,
    fields: {
      where: (singular) => `Filter which ${singular} to delete.`
    }
  },
  aggregate: {
    body: (ctx) => `Allows you to perform aggregations operations on a ${ctx.singular}.
${undefinedNote}
@param {${getModelArgName(
      ctx.model.name,
      ctx.action
    )}} args - Select which aggregations you would like to apply and on what fields.
@example
// Ordered by age ascending
// Where email contains prisma.io
// Limited to the 10 users
const aggregations = await prisma.user.aggregate({
  _avg: {
    age: true,
  },
  where: {
    email: {
      contains: "prisma.io",
    },
  },
  orderBy: {
    age: "asc",
  },
  take: 10,
})`,
    fields: {
      where: (singular) => `Filter which ${singular} to aggregate.`,
      orderBy: JSDocFields.orderBy,
      cursor: () => addLinkToDocs(`Sets the start position`, "cursor"),
      take: JSDocFields.take,
      skip: JSDocFields.skip,
      _count: JSDocFields._count,
      _avg: JSDocFields._avg,
      _sum: JSDocFields._sum,
      _min: JSDocFields._min,
      _max: JSDocFields._max,
      count: JSDocFields.count,
      avg: JSDocFields.avg,
      sum: JSDocFields.sum,
      min: JSDocFields.min,
      max: JSDocFields.max
    }
  },
  count: {
    body: (ctx) => `Count the number of ${ctx.plural}.
${undefinedNote}
@param {${getModelArgName(ctx.model.name, ctx.action)}} args - Arguments to filter ${ctx.plural} to count.
@example
// Count the number of ${ctx.plural}
const count = await ${ctx.method}({
  where: {
    // ... the filter for the ${ctx.plural} we want to count
  }
})`,
    fields: {}
  },
  updateMany: {
    body: (ctx) => `Update zero or more ${ctx.plural}.
${undefinedNote}
@param {${getModelArgName(ctx.model.name, ctx.action)}} args - Arguments to update one or more rows.
@example
// Update many ${ctx.plural}
const ${lowerCase(ctx.mapping.model)} = await ${ctx.method}({
  where: {
    // ... provide filter here
  },
  data: {
    // ... provide data here
  }
})
`,
    fields: {
      data: (singular, plural) => `The data used to update ${plural}.`,
      where: (singular, plural) => `Filter which ${plural} to update`
    }
  },
  deleteMany: {
    body: (ctx) => `Delete zero or more ${ctx.plural}.
@param {${getModelArgName(ctx.model.name, ctx.action)}} args - Arguments to filter ${ctx.plural} to delete.
@example
// Delete a few ${ctx.plural}
const { count } = await ${ctx.method}({
  where: {
    // ... provide filter here
  }
})
`,
    fields: {
      where: (singular, plural) => `Filter which ${plural} to delete`
    }
  },
  aggregateRaw: {
    body: (ctx) => `Perform aggregation operations on a ${ctx.singular}.
@param {${getModelArgName(ctx.model.name, ctx.action)}} args - Select which aggregations you would like to apply.
@example
const ${lowerCase(ctx.mapping.model)} = await ${ctx.method}({
  pipeline: [
    { $match: { status: "registered" } },
    { $group: { _id: "$country", total: { $sum: 1 } } }
  ]
})`,
    fields: {
      pipeline: () => "An array of aggregation stages to process and transform the document stream via the aggregation pipeline. ${@link https://docs.mongodb.com/manual/reference/operator/aggregation-pipeline MongoDB Docs}.",
      options: () => "Additional options to pass to the `aggregate` command ${@link https://docs.mongodb.com/manual/reference/command/aggregate/#command-fields MongoDB Docs}."
    }
  },
  findRaw: {
    body: (ctx) => `Find zero or more ${ctx.plural} that matches the filter.
@param {${getModelArgName(ctx.model.name, ctx.action)}} args - Select which filters you would like to apply.
@example
const ${lowerCase(ctx.mapping.model)} = await ${ctx.method}({
  filter: { age: { $gt: 25 } } 
})`,
    fields: {
      filter: () => "The query predicate filter. If unspecified, then all documents in the collection will match the predicate. ${@link https://docs.mongodb.com/manual/reference/operator/query MongoDB Docs}.",
      options: () => "Additional options to pass to the `find` command ${@link https://docs.mongodb.com/manual/reference/command/find/#command-fields MongoDB Docs}."
    }
  }
};

// src/generation/TSClient/helpers.ts
function getMethodJSDocBody(action, mapping, model) {
  const ctx = {
    singular: capitalize(mapping.model),
    plural: capitalize(mapping.plural),
    firstScalar: model.fields.find((f) => f.kind === "scalar"),
    method: `prisma.${lowerCase(mapping.model)}.${action}`,
    action,
    mapping,
    model
  };
  const jsdoc = JSDocs[action]?.body(ctx);
  return jsdoc ? jsdoc : "";
}
__name(getMethodJSDocBody, "getMethodJSDocBody");
function getMethodJSDoc(action, mapping, model) {
  return wrapComment(getMethodJSDocBody(action, mapping, model));
}
__name(getMethodJSDoc, "getMethodJSDoc");
function getGenericMethod(name, actionName) {
  if (actionName === "count") {
    return "";
  }
  if (actionName === "aggregate") {
    return `<T extends ${getAggregateArgsName(name)}>`;
  }
  if (actionName === "findRaw" || actionName === "aggregateRaw") {
    return "";
  }
  if (actionName === "findFirst" || actionName === "findUnique") {
    return `<T extends ${getModelArgName(name, actionName)}${ifExtensions(
      "<ExtArgs>",
      ""
    )},  LocalRejectSettings = T["rejectOnNotFound"] extends RejectOnNotFound ? T['rejectOnNotFound'] : undefined>`;
  }
  const modelArgName = getModelArgName(name, actionName);
  if (!modelArgName) {
    console.log({ name, actionName });
  }
  return `<T extends ${modelArgName}${ifExtensions("<ExtArgs>", "")}>`;
}
__name(getGenericMethod, "getGenericMethod");
function getArgs(modelName, actionName) {
  if (actionName === "count") {
    return `args?: Omit<${getModelArgName(modelName, DMMF.ModelAction.findMany)}, 'select' | 'include'>`;
  }
  if (actionName === "aggregate") {
    return `args: Subset<T, ${getAggregateArgsName(modelName)}>`;
  }
  if (actionName === "findRaw" || actionName === "aggregateRaw") {
    return `args?: ${getModelArgName(modelName, actionName)}`;
  }
  return `args${actionName === DMMF.ModelAction.findMany || actionName === DMMF.ModelAction.findFirst || actionName === DMMF.ModelAction.deleteMany || actionName === DMMF.ModelAction.createMany || actionName === DMMF.ModelAction.findUniqueOrThrow || actionName === DMMF.ModelAction.findFirstOrThrow ? "?" : ""}: SelectSubset<T, ${getModelArgName(modelName, actionName)}${ifExtensions("<ExtArgs>", "")}>`;
}
__name(getArgs, "getArgs");
function wrapComment(str) {
  return `/**
${str.split("\n").map((l) => " * " + l).join("\n")}
**/`;
}
__name(wrapComment, "wrapComment");
function getArgFieldJSDoc(type, action, field) {
  if (!field || !action || !type)
    return;
  const fieldName = typeof field === "string" ? field : field.name;
  if (JSDocs[action] && JSDocs[action]?.fields[fieldName]) {
    const singular = type.name;
    const plural = (0, import_pluralize2.default)(type.name);
    const comment = JSDocs[action]?.fields[fieldName](singular, plural);
    return comment;
  }
  return void 0;
}
__name(getArgFieldJSDoc, "getArgFieldJSDoc");
function escapeJson(str) {
  return str.replace(/\\n/g, "\\\\n").replace(/\\r/g, "\\\\r").replace(/\\t/g, "\\\\t");
}
__name(escapeJson, "escapeJson");

// src/generation/utils/buildDMMF.ts
function buildDMMF(compressed, dmmf2) {
  if (compressed === true) {
    const dmmfString2 = escapeJson(JSON.stringify(dmmf2));
    return buildCompressedDMMF(dmmfString2);
  }
  const { datamodel: datamodel2, mappings } = dmmf2;
  const dmmfString = escapeJson(JSON.stringify({ datamodel: datamodel2, mappings }));
  return buildUncompressedDMMF(dmmfString);
}
__name(buildDMMF, "buildDMMF");
function buildCompressedDMMF(dmmf2) {
  const compressedDMMF = import_lz_string.default.compressToBase64(dmmf2);
  return `
const compressedDMMF = '${compressedDMMF}'
const decompressedDMMF = decompressFromBase64(compressedDMMF)
// We are parsing 2 times, as we want independent objects, because
// DMMFClass introduces circular references in the dmmf object
const dmmf = JSON.parse(decompressedDMMF)
exports.Prisma.dmmf = JSON.parse(decompressedDMMF)`;
}
__name(buildCompressedDMMF, "buildCompressedDMMF");
function buildUncompressedDMMF(dmmf2) {
  return `
const dmmfString = ${JSON.stringify(dmmf2)}
const dmmf = JSON.parse(dmmfString)
exports.Prisma.dmmf = JSON.parse(dmmfString)`;
}
__name(buildUncompressedDMMF, "buildUncompressedDMMF");

// src/generation/utils/buildEdgeClientProtocol.ts
function buildEdgeClientProtocol(edge, config2) {
  if (!edge) {
    return "";
  }
  const protocol = getQueryEngineProtocol(config2);
  return `config.edgeClientProtocol = "${protocol}";`;
}
__name(buildEdgeClientProtocol, "buildEdgeClientProtocol");

// src/generation/utils/buildInlineDatasources.ts
function buildInlineDatasource(dataProxy2, internalDatasources) {
  if (dataProxy2 === true) {
    const datasources2 = internalToInlineDatasources(internalDatasources);
    return `
config.inlineDatasources = ${JSON.stringify(datasources2, null, 2)}`;
  }
  return ``;
}
__name(buildInlineDatasource, "buildInlineDatasource");
function internalToInlineDatasources(internalDatasources) {
  return internalDatasources.reduce((acc, ds) => {
    acc[ds.name] = { url: ds.url };
    return acc;
  }, {});
}
__name(internalToInlineDatasources, "internalToInlineDatasources");

// src/generation/utils/buildInlineSchema.ts
var import_crypto = __toESM(require("crypto"));
var import_fs9 = __toESM(require("fs"));
var readFile4 = import_fs9.default.promises.readFile;
async function buildInlineSchema(dataProxy2, schemaPath2) {
  if (dataProxy2 === true) {
    const b64Schema = (await readFile4(schemaPath2)).toString("base64");
    const schemaHash = import_crypto.default.createHash("sha256").update(b64Schema).digest("hex");
    return `
config.inlineSchema = '${b64Schema}'
config.inlineSchemaHash = '${schemaHash}'`;
  }
  return ``;
}
__name(buildInlineSchema, "buildInlineSchema");

// src/generation/utils/buildNFTAnnotations.ts
var import_path6 = __toESM(require("path"));

// ../../helpers/blaze/map.ts
function mapList(object, mapper) {
  const mapped = new Array(object.length);
  for (let i = 0; i < object.length; ++i) {
    mapped[i] = mapper(object[i], i);
  }
  return mapped;
}
__name(mapList, "mapList");
function mapObject(object, mapper) {
  const mapped = {};
  const keys = Object.keys(object);
  for (let i = 0; i < keys.length; ++i) {
    mapped[i] = mapper(object[keys[i]], keys[i]);
  }
  return mapped;
}
__name(mapObject, "mapObject");
var map = /* @__PURE__ */ __name((object, mapper) => {
  return Array.isArray(object) ? mapList(object, mapper) : mapObject(object, mapper);
}, "map");

// src/generation/utils/buildNFTAnnotations.ts
function buildNFTAnnotations(dataProxy2, engineType, platforms, relativeOutdir) {
  if (dataProxy2 === true)
    return "";
  if (platforms === void 0) {
    return "";
  }
  if (process.env.NETLIFY) {
    platforms = ["rhel-openssl-1.0.x"];
  }
  const engineAnnotations = map(platforms, (platform) => {
    const engineFilename = getQueryEngineFilename(engineType, platform);
    return engineFilename ? buildNFTAnnotation(engineFilename, relativeOutdir) : "";
  }).join("\n");
  const schemaAnnotations = buildNFTAnnotation("schema.prisma", relativeOutdir);
  return `${engineAnnotations}${schemaAnnotations}`;
}
__name(buildNFTAnnotations, "buildNFTAnnotations");
function getQueryEngineFilename(engineType, platform) {
  if (engineType === "library" /* Library */) {
    return getNodeAPIName(platform, "fs");
  }
  if (engineType === "binary" /* Binary */) {
    return `query-engine-${platform}`;
  }
  return void 0;
}
__name(getQueryEngineFilename, "getQueryEngineFilename");
function buildNFTAnnotation(fileName, relativeOutdir) {
  const relativeFilePath = import_path6.default.join(relativeOutdir, fileName);
  return `
path.join(__dirname, ${JSON.stringify(fileName)});
path.join(process.cwd(), ${JSON.stringify(relativeFilePath)})`;
}
__name(buildNFTAnnotation, "buildNFTAnnotation");

// src/generation/utils/buildRequirePath.ts
function buildRequirePath(edge) {
  if (edge === true)
    return "";
  return `
  const path = require('path')`;
}
__name(buildRequirePath, "buildRequirePath");

// src/generation/utils/buildWarnEnvConflicts.ts
function buildWarnEnvConflicts(edge, runtimeDir, runtimeName) {
  if (edge === true)
    return "";
  return `
const { warnEnvConflicts } = require('${runtimeDir}/${runtimeName}')

warnEnvConflicts({
    rootEnvPath: config.relativeEnvPaths.rootEnvPath && path.resolve(dirname, config.relativeEnvPaths.rootEnvPath),
    schemaEnvPath: config.relativeEnvPaths.schemaEnvPath && path.resolve(dirname, config.relativeEnvPaths.schemaEnvPath)
})`;
}
__name(buildWarnEnvConflicts, "buildWarnEnvConflicts");

// src/generation/TSClient/common.ts
var import_indent_string2 = __toESM(require_indent_string());

// src/generation/TSClient/constants.ts
var TAB_SIZE = 2;

// src/generation/TSClient/common.ts
var commonCodeJS = /* @__PURE__ */ __name(({
  runtimeDir,
  runtimeName,
  browser,
  clientVersion: clientVersion3,
  engineVersion: engineVersion2,
  deno
}) => `${deno ? "const exports = {}" : ""}
Object.defineProperty(exports, "__esModule", { value: true });
${deno ? `
import {
  PrismaClientKnownRequestError,
  PrismaClientUnknownRequestError,
  PrismaClientRustPanicError,
  PrismaClientInitializationError,
  PrismaClientValidationError,
  NotFoundError,
  decompressFromBase64,
  getPrismaClient,
  sqltag,
  empty,
  join,
  raw,
  Decimal,
  Debug,
  objectEnumValues,
  makeStrictEnum,
  Extensions,
  findSync
} from '${runtimeDir}/edge-esm.js'` : browser ? `
const {
  Decimal,
  objectEnumValues,
  makeStrictEnum
} = require('${runtimeDir}/${runtimeName}')
` : `
const {
  PrismaClientKnownRequestError,
  PrismaClientUnknownRequestError,
  PrismaClientRustPanicError,
  PrismaClientInitializationError,
  PrismaClientValidationError,
  NotFoundError,
  decompressFromBase64,
  getPrismaClient,
  sqltag,
  empty,
  join,
  raw,
  Decimal,
  Debug,
  objectEnumValues,
  makeStrictEnum,
  Extensions,
  findSync
} = require('${runtimeDir}/${runtimeName}')
`}

const Prisma = {}

exports.Prisma = Prisma

/**
 * Prisma Client JS version: ${clientVersion3}
 * Query Engine version: ${engineVersion2}
 */
Prisma.prismaVersion = {
  client: "${clientVersion3}",
  engine: "${engineVersion2}"
}

Prisma.PrismaClientKnownRequestError = ${notSupportOnBrowser("PrismaClientKnownRequestError", browser)};
Prisma.PrismaClientUnknownRequestError = ${notSupportOnBrowser("PrismaClientUnknownRequestError", browser)}
Prisma.PrismaClientRustPanicError = ${notSupportOnBrowser("PrismaClientRustPanicError", browser)}
Prisma.PrismaClientInitializationError = ${notSupportOnBrowser("PrismaClientInitializationError", browser)}
Prisma.PrismaClientValidationError = ${notSupportOnBrowser("PrismaClientValidationError", browser)}
Prisma.NotFoundError = ${notSupportOnBrowser("NotFoundError", browser)}
Prisma.Decimal = Decimal

/**
 * Re-export of sql-template-tag
 */
Prisma.sql = ${notSupportOnBrowser("sqltag", browser)}
Prisma.empty = ${notSupportOnBrowser("empty", browser)}
Prisma.join = ${notSupportOnBrowser("join", browser)}
Prisma.raw = ${notSupportOnBrowser("raw", browser)}
Prisma.validator = () => (val) => val

${ifExtensions(
  `/**
* Extensions
*/
Prisma.getExtensionContext = ${notSupportOnBrowser("Extensions.getExtensionContext", browser)}
Prisma.defineExtension = ${notSupportOnBrowser("Extensions.defineExtension", browser)}

`,
  ""
)}
/**
 * Shorthand utilities for JSON filtering
 */
Prisma.DbNull = objectEnumValues.instances.DbNull
Prisma.JsonNull = objectEnumValues.instances.JsonNull
Prisma.AnyNull = objectEnumValues.instances.AnyNull

Prisma.NullTypes = {
  DbNull: objectEnumValues.classes.DbNull,
  JsonNull: objectEnumValues.classes.JsonNull,
  AnyNull: objectEnumValues.classes.AnyNull
}
`, "commonCodeJS");
var notSupportOnBrowser = /* @__PURE__ */ __name((fnc, browser) => {
  if (browser)
    return `() => {
  throw new Error(\`${fnc} is unable to be run in the browser.
In case this error is unexpected for you, please report it in https://github.com/prisma/prisma/issues\`,
)}`;
  return fnc;
}, "notSupportOnBrowser");
var commonCodeTS = /* @__PURE__ */ __name(({ runtimeDir, runtimeName, clientVersion: clientVersion3, engineVersion: engineVersion2 }) => ({
  tsWithoutNamespace: () => `import * as runtime from '${runtimeDir}/${runtimeName}';
type UnwrapPromise<P extends any> = P extends Promise<infer R> ? R : P
type UnwrapTuple<Tuple extends readonly unknown[]> = {
  [K in keyof Tuple]: K extends \`\${number}\` ? Tuple[K] extends Prisma.PrismaPromise<infer X> ? X : UnwrapPromise<Tuple[K]> : UnwrapPromise<Tuple[K]>
};
`,
  ts: () => `export import DMMF = runtime.DMMF

export type PrismaPromise<T> = runtime.Types.Public.PrismaPromise<T>

/**
 * Prisma Errors
 */
export import PrismaClientKnownRequestError = runtime.PrismaClientKnownRequestError
export import PrismaClientUnknownRequestError = runtime.PrismaClientUnknownRequestError
export import PrismaClientRustPanicError = runtime.PrismaClientRustPanicError
export import PrismaClientInitializationError = runtime.PrismaClientInitializationError
export import PrismaClientValidationError = runtime.PrismaClientValidationError
export import NotFoundError = runtime.NotFoundError

/**
 * Re-export of sql-template-tag
 */
export import sql = runtime.sqltag
export import empty = runtime.empty
export import join = runtime.join
export import raw = runtime.raw
export import Sql = runtime.Sql

/**
 * Decimal.js
 */
export import Decimal = runtime.Decimal

export type DecimalJsLike = runtime.DecimalJsLike

/**
 * Metrics 
 */
export type Metrics = runtime.Metrics
export type Metric<T> = runtime.Metric<T>
export type MetricHistogram = runtime.MetricHistogram
export type MetricHistogramBucket = runtime.MetricHistogramBucket

${ifExtensions(
    `/**
* Extensions
*/
export type Extension = runtime.Types.Extensions.UserArgs
export import getExtensionContext = runtime.Extensions.getExtensionContext
export type Args<T, F extends runtime.Types.Public.Operation> = runtime.Types.Public.Args<T, F>
export type Payload<T, F extends runtime.Types.Public.Operation> = runtime.Types.Public.Payload<T, F>
export type Result<T, A, F extends runtime.Types.Public.Operation> = runtime.Types.Public.Result<T, A, F>
export type Exact<T, W> = runtime.Types.Public.Exact<T, W>

`,
    ""
  )}
/**
 * Prisma Client JS version: ${clientVersion3}
 * Query Engine version: ${engineVersion2}
 */
export type PrismaVersion = {
  client: string
}

export const prismaVersion: PrismaVersion 

/**
 * Utility Types
 */

/**
 * From https://github.com/sindresorhus/type-fest/
 * Matches a JSON object.
 * This type can be useful to enforce some input to be JSON-compatible or as a super-type to be extended from. 
 */
export type JsonObject = {[Key in string]?: JsonValue}

/**
 * From https://github.com/sindresorhus/type-fest/
 * Matches a JSON array.
 */
export interface JsonArray extends Array<JsonValue> {}

/**
 * From https://github.com/sindresorhus/type-fest/
 * Matches any valid JSON value.
 */
export type JsonValue = string | number | boolean | JsonObject | JsonArray | null

/**
 * Matches a JSON object.
 * Unlike \`JsonObject\`, this type allows undefined and read-only properties.
 */
export type InputJsonObject = {readonly [Key in string]?: InputJsonValue | null}

/**
 * Matches a JSON array.
 * Unlike \`JsonArray\`, readonly arrays are assignable to this type.
 */
export interface InputJsonArray extends ReadonlyArray<InputJsonValue | null> {}

/**
 * Matches any valid value that can be used as an input for operations like
 * create and update as the value of a JSON field. Unlike \`JsonValue\`, this
 * type allows read-only arrays and read-only object properties and disallows
 * \`null\` at the top level.
 *
 * \`null\` cannot be used as the value of a JSON field because its meaning
 * would be ambiguous. Use \`Prisma.JsonNull\` to store the JSON null value or
 * \`Prisma.DbNull\` to clear the JSON value and set the field to the database
 * NULL value instead.
 *
 * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-by-null-values
 */
export type InputJsonValue = string | number | boolean | InputJsonObject | InputJsonArray

/**
 * Types of the values used to represent different kinds of \`null\` values when working with JSON fields.
 * 
 * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
 */
namespace NullTypes {
${buildNullClass("DbNull")}

${buildNullClass("JsonNull")}

${buildNullClass("AnyNull")}
}

/**
 * Helper for filtering JSON entries that have \`null\` on the database (empty on the db)
 * 
 * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
 */
export const DbNull: NullTypes.DbNull

/**
 * Helper for filtering JSON entries that have JSON \`null\` values (not empty on the db)
 * 
 * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
 */
export const JsonNull: NullTypes.JsonNull

/**
 * Helper for filtering JSON entries that are \`Prisma.DbNull\` or \`Prisma.JsonNull\`
 * 
 * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
 */
export const AnyNull: NullTypes.AnyNull

type SelectAndInclude = {
  select: any
  include: any
}
type HasSelect = {
  select: any
}
type HasInclude = {
  include: any
}
type CheckSelect<T, S, U> = T extends SelectAndInclude
  ? 'Please either choose \`select\` or \`include\`'
  : T extends HasSelect
  ? U
  : T extends HasInclude
  ? U
  : S

/**
 * Get the type of the value, that the Promise holds.
 */
export type PromiseType<T extends PromiseLike<any>> = T extends PromiseLike<infer U> ? U : T;

/**
 * Get the return type of a function which returns a Promise.
 */
export type PromiseReturnType<T extends (...args: any) => Promise<any>> = PromiseType<ReturnType<T>>

/**
 * From T, pick a set of properties whose keys are in the union K
 */
type Prisma__Pick<T, K extends keyof T> = {
    [P in K]: T[P];
};


export type Enumerable<T> = T | Array<T>;

export type RequiredKeys<T> = {
  [K in keyof T]-?: {} extends Prisma__Pick<T, K> ? never : K
}[keyof T]

export type TruthyKeys<T> = keyof {
  [K in keyof T as T[K] extends false | undefined | null ? never : K]: K
}

export type TrueKeys<T> = TruthyKeys<Prisma__Pick<T, RequiredKeys<T>>>

/**
 * Subset
 * @desc From \`T\` pick properties that exist in \`U\`. Simple version of Intersection
 */
export type Subset<T, U> = {
  [key in keyof T]: key extends keyof U ? T[key] : never;
};

/**
 * SelectSubset
 * @desc From \`T\` pick properties that exist in \`U\`. Simple version of Intersection.
 * Additionally, it validates, if both select and include are present. If the case, it errors.
 */
export type SelectSubset<T, U> = {
  [key in keyof T]: key extends keyof U ? T[key] : never
} &
  (T extends SelectAndInclude
    ? 'Please either choose \`select\` or \`include\`.'
    : {})

/**
 * Subset + Intersection
 * @desc From \`T\` pick properties that exist in \`U\` and intersect \`K\`
 */
export type SubsetIntersection<T, U, K> = {
  [key in keyof T]: key extends keyof U ? T[key] : never
} &
  K

type Without<T, U> = { [P in Exclude<keyof T, keyof U>]?: never };

/**
 * XOR is needed to have a real mutually exclusive union type
 * https://stackoverflow.com/questions/42123407/does-typescript-support-mutually-exclusive-types
 */
type XOR<T, U> =
  T extends object ?
  U extends object ?
    (Without<T, U> & U) | (Without<U, T> & T)
  : U : T


/**
 * Is T a Record?
 */
type IsObject<T extends any> = T extends Array<any>
? False
: T extends Date
? False
: T extends Uint8Array
? False
: T extends BigInt
? False
: T extends object
? True
: False


/**
 * If it's T[], return T
 */
export type UnEnumerate<T extends unknown> = T extends Array<infer U> ? U : T

/**
 * From ts-toolbelt
 */

type __Either<O extends object, K extends Key> = Omit<O, K> &
  {
    // Merge all but K
    [P in K]: Prisma__Pick<O, P & keyof O> // With K possibilities
  }[K]

type EitherStrict<O extends object, K extends Key> = Strict<__Either<O, K>>

type EitherLoose<O extends object, K extends Key> = ComputeRaw<__Either<O, K>>

type _Either<
  O extends object,
  K extends Key,
  strict extends Boolean
> = {
  1: EitherStrict<O, K>
  0: EitherLoose<O, K>
}[strict]

type Either<
  O extends object,
  K extends Key,
  strict extends Boolean = 1
> = O extends unknown ? _Either<O, K, strict> : never

export type Union = any

type PatchUndefined<O extends object, O1 extends object> = {
  [K in keyof O]: O[K] extends undefined ? At<O1, K> : O[K]
} & {}

/** Helper Types for "Merge" **/
export type IntersectOf<U extends Union> = (
  U extends unknown ? (k: U) => void : never
) extends (k: infer I) => void
  ? I
  : never

export type Overwrite<O extends object, O1 extends object> = {
    [K in keyof O]: K extends keyof O1 ? O1[K] : O[K];
} & {};

type _Merge<U extends object> = IntersectOf<Overwrite<U, {
    [K in keyof U]-?: At<U, K>;
}>>;

type Key = string | number | symbol;
type AtBasic<O extends object, K extends Key> = K extends keyof O ? O[K] : never;
type AtStrict<O extends object, K extends Key> = O[K & keyof O];
type AtLoose<O extends object, K extends Key> = O extends unknown ? AtStrict<O, K> : never;
export type At<O extends object, K extends Key, strict extends Boolean = 1> = {
    1: AtStrict<O, K>;
    0: AtLoose<O, K>;
}[strict];

export type ComputeRaw<A extends any> = A extends Function ? A : {
  [K in keyof A]: A[K];
} & {};

export type OptionalFlat<O> = {
  [K in keyof O]?: O[K];
} & {};

type _Record<K extends keyof any, T> = {
  [P in K]: T;
};

// cause typescript not to expand types and preserve names
type NoExpand<T> = T extends unknown ? T : never;

// this type assumes the passed object is entirely optional
type AtLeast<O extends object, K extends string> = NoExpand<
  O extends unknown
  ? | (K extends keyof O ? { [P in K]: O[P] } & O : O)
    | {[P in keyof O as P extends K ? K : never]-?: O[P]} & O
  : never>;

type _Strict<U, _U = U> = U extends unknown ? U & OptionalFlat<_Record<Exclude<Keys<_U>, keyof U>, never>> : never;

export type Strict<U extends object> = ComputeRaw<_Strict<U>>;
/** End Helper Types for "Merge" **/

export type Merge<U extends object> = ComputeRaw<_Merge<Strict<U>>>;

/**
A [[Boolean]]
*/
export type Boolean = True | False

// /**
// 1
// */
export type True = 1

/**
0
*/
export type False = 0

export type Not<B extends Boolean> = {
  0: 1
  1: 0
}[B]

export type Extends<A1 extends any, A2 extends any> = [A1] extends [never]
  ? 0 // anything \`never\` is false
  : A1 extends A2
  ? 1
  : 0

export type Has<U extends Union, U1 extends Union> = Not<
  Extends<Exclude<U1, U>, U1>
>

export type Or<B1 extends Boolean, B2 extends Boolean> = {
  0: {
    0: 0
    1: 1
  }
  1: {
    0: 1
    1: 1
  }
}[B1][B2]

export type Keys<U extends Union> = U extends unknown ? keyof U : never

type Cast<A, B> = A extends B ? A : B;

export const type: unique symbol;

export function validator<V>(): <S>(select: runtime.Types.Utils.LegacyExact<S, V>) => S;

/**
 * Used by group by
 */

export type GetScalarType<T, O> = O extends object ? {
  [P in keyof T]: P extends keyof O
    ? O[P]
    : never
} : never

type FieldPaths<
  T,
  U = Omit<T, '_avg' | '_sum' | '_count' | '_min' | '_max'>
> = IsObject<T> extends True ? U : T

type GetHavingFields<T> = {
  [K in keyof T]: Or<
    Or<Extends<'OR', K>, Extends<'AND', K>>,
    Extends<'NOT', K>
  > extends True
    ? // infer is only needed to not hit TS limit
      // based on the brilliant idea of Pierre-Antoine Mills
      // https://github.com/microsoft/TypeScript/issues/30188#issuecomment-478938437
      T[K] extends infer TK
      ? GetHavingFields<UnEnumerate<TK> extends object ? Merge<UnEnumerate<TK>> : never>
      : never
    : {} extends FieldPaths<T[K]>
    ? never
    : K
}[keyof T]

/**
 * Convert tuple to union
 */
type _TupleToUnion<T> = T extends (infer E)[] ? E : never
type TupleToUnion<K extends readonly any[]> = _TupleToUnion<K>
type MaybeTupleToUnion<T> = T extends any[] ? TupleToUnion<T> : T

/**
 * Like \`Pick\`, but with an array
 */
type PickArray<T, K extends Array<keyof T>> = Prisma__Pick<T, TupleToUnion<K>>

/**
 * Exclude all keys with underscores
 */
type ExcludeUnderscoreKeys<T extends string> = T extends \`_\${string}\` ? never : T


export type FieldRef<Model, FieldType> = runtime.FieldRef<Model, FieldType>

type FieldRefInputType<Model, FieldType> = Model extends never ? never : FieldRef<Model, FieldType>

`
}), "commonCodeTS");
function buildNullClass(name) {
  const source = `/**
* Type of \`Prisma.${name}\`.
* 
* You cannot use other instances of this class. Please use the \`Prisma.${name}\` value.
* 
* @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
*/
class ${name} {
  private ${name}: never
  private constructor()
}`;
  return (0, import_indent_string2.default)(source, TAB_SIZE);
}
__name(buildNullClass, "buildNullClass");

// src/generation/TSClient/Count.ts
var import_indent_string5 = __toESM(require_indent_string());

// src/generation/TSClient/Generatable.ts
function JS(gen, edge = false) {
  return gen.toJS?.(edge) ?? "";
}
__name(JS, "JS");
function BrowserJS(gen) {
  return gen.toBrowserJS?.() ?? "";
}
__name(BrowserJS, "BrowserJS");
function TS(gen, edge = false) {
  return gen.toTS(edge);
}
__name(TS, "TS");

// src/generation/TSClient/Output.ts
var import_indent_string3 = __toESM(require_indent_string());

// src/generation/utils/types/buildComment.ts
function buildComment(documentation) {
  if (documentation === void 0)
    return "";
  const docLines = documentation.split("\n");
  const docBody = docLines.reduce((acc, item) => {
    return `${acc}
 * ${item}`;
  }, "");
  return `/**${docBody}
 */
`;
}
__name(buildComment, "buildComment");

// src/generation/TSClient/Output.ts
var ModelOutputField = class {
  constructor(dmmf2, field, useNamespace = false) {
    this.dmmf = dmmf2;
    this.field = field;
    this.useNamespace = useNamespace;
  }
  toTS() {
    const { field, useNamespace } = this;
    let fieldType = GraphQLScalarToJSTypeTable[field.type] || field.type;
    if (Array.isArray(fieldType)) {
      fieldType = fieldType[0];
    }
    const arrayStr = field.isList ? `[]` : "";
    const nullableStr = !field.isRequired && !field.isList ? " | null" : "";
    const namespaceStr = useNamespace && needsNamespace(field.type, this.dmmf) ? `Prisma.` : "";
    return ifExtensions(
      () => {
        if (field.kind === "object") {
          fieldType = `${fieldType}Payload`;
          return `${buildComment(field.documentation)}${field.name}: ${namespaceStr}${fieldType}<ExtArgs>${arrayStr}${nullableStr}`;
        }
        return `${buildComment(field.documentation)}${field.name}: ${namespaceStr}${fieldType}${arrayStr}${nullableStr}`;
      },
      () => {
        return `${buildComment(field.documentation)}${field.name}: ${namespaceStr}${fieldType}${arrayStr}${nullableStr}`;
      }
    );
  }
};
__name(ModelOutputField, "ModelOutputField");
var OutputField = class {
  constructor(dmmf2, field, useNamespace = false) {
    this.dmmf = dmmf2;
    this.field = field;
    this.useNamespace = useNamespace;
  }
  toTS() {
    const { field, useNamespace } = this;
    let fieldType;
    if (field.outputType.location === "scalar") {
      fieldType = GraphQLScalarToJSTypeTable[field.outputType.type];
    } else if (field.outputType.location === "enumTypes") {
      if (isSchemaEnum(field.outputType.type)) {
        fieldType = field.outputType.type.name;
      }
    } else {
      fieldType = field.outputType.type.name;
    }
    if (Array.isArray(fieldType)) {
      fieldType = fieldType[0];
    }
    const arrayStr = field.outputType.isList ? `[]` : "";
    const nullableStr = field.isNullable && !field.outputType.isList ? " | null" : "";
    const namespaceStr = useNamespace && needsNamespace(field.outputType.type, this.dmmf) ? `Prisma.` : "";
    const deprecated = field.deprecation ? `@deprecated since ${field.deprecation.sinceVersion} because ${field.deprecation.reason}` : "";
    const jsdoc = deprecated ? wrapComment(deprecated) + "\n" : "";
    return `${jsdoc}${field.name}: ${namespaceStr}${fieldType}${arrayStr}${nullableStr}`;
  }
};
__name(OutputField, "OutputField");
var OutputType = class {
  constructor(dmmf2, type) {
    this.dmmf = dmmf2;
    this.type = type;
    this.name = type.name;
    this.fields = type.fields;
  }
  toTS() {
    const { type } = this;
    return `
export type ${type.name} = {
${(0, import_indent_string3.default)(
      type.fields.map((field) => new OutputField(this.dmmf, { ...field, ...field.outputType }).toTS()).join("\n"),
      TAB_SIZE
    )}
}`;
  }
};
__name(OutputType, "OutputType");

// src/generation/TSClient/Payload.ts
var import_indent_string4 = __toESM(require_indent_string());

// ../../helpers/blaze/get.ts
function get(object, key) {
  return object[key];
}
__name(get, "get");

// src/generation/TSClient/Payload.ts
var PayloadType = class {
  constructor(type, dmmf2, findMany = true) {
    this.type = type;
    this.dmmf = dmmf2;
    this.findMany = findMany;
  }
  toTS() {
    const { type } = this;
    const { name } = type;
    const argsName = getArgName(name);
    const include = this.renderRelations("include" /* include */);
    const select = this.renderRelations("select" /* select */);
    const isModel = !this.dmmf.typeMap[name];
    const findManyArg = isModel && this.findMany ? ` | ${getModelArgName(name, DMMF.ModelAction.findMany)}${ifExtensions("", "")}` : "";
    return `export type ${getPayloadName(name)}<S extends boolean | null | undefined | ${argsName}${ifExtensions(
      `, ExtArgs extends runtime.Types.Extensions.Args = runtime.Types.Extensions.DefaultArgs, _${name} = runtime.Types.Extensions.GetResult<${name}, ExtArgs['result']['${lowerCase(
        name
      )}']>`,
      ""
    )}> =
  S extends { select: any, include: any } ? 'Please either choose \`select\` or \`include\`' :
  S extends true ? ${ifExtensions(`_${name}`, name)} :
  S extends undefined ? never :
  S extends { include: any } & (${argsName}${findManyArg})
  ? ${ifExtensions(`_${name}`, name)} ${include.length > 0 ? ifExtensions(`& ${include}`, ` & ${include}`) : ""}
  : S extends { select: any } & (${argsName}${findManyArg})
    ? ${select}
    : ${ifExtensions(`_${name}`, name)}
`;
  }
  renderRelations(projection) {
    const { type } = this;
    const relationsProjectionChoice = {
      ["select" /* select */]: () => {
        return type.fields.filter((f) => {
          return f.outputType.location === "outputObjectTypes";
        });
      },
      ["include" /* include */]: () => {
        const nonCompositeRelations = type.fields.filter((f) => {
          return f.outputType.location === "outputObjectTypes" && typeof f.outputType.type === "object" && !this.dmmf.typeMap[f.outputType.type.name];
        });
        return nonCompositeRelations;
      }
    };
    const relations = get(relationsProjectionChoice, projection)();
    if (projection === "include" /* include */ && relations.length === 0)
      return "";
    const typeName = ifExtensions(`_${type.name}`, type.name);
    const selectPrefix = projection === "select" /* select */ ? ` P extends keyof ${typeName} ? ${typeName}[P] :` : "";
    return `{
  [P in TruthyKeys<S['${projection}']>]:
${(0, import_indent_string4.default)(
      relations.map(
        (f) => `P extends '${f.name}' ? ${this.wrapType(
          f,
          `${getPayloadName(f.outputType.type.name)}<S['${projection}'][P]${ifExtensions(
            ", ExtArgs",
            ""
          )}>`
        )} :`
      ).join("\n"),
      6
    )} ${selectPrefix} never
} `;
  }
  wrapType(field, str) {
    const { outputType } = field;
    if (!field.isNullable && !outputType.isList) {
      return str;
    }
    if (outputType.isList) {
      return `Array < ${str}> `;
    }
    if (str === "Null") {
      return "null";
    }
    if (field.isNullable) {
      str += " | null";
    }
    return str;
  }
};
__name(PayloadType, "PayloadType");

// src/generation/TSClient/Count.ts
var Count = class {
  constructor(type, dmmf2, genericsInfo, generator2) {
    this.type = type;
    this.dmmf = dmmf2;
    this.genericsInfo = genericsInfo;
    this.generator = generator2;
  }
  get argsTypes() {
    const argsTypes = [];
    argsTypes.push(new ArgsType([], this.type, this.genericsInfo));
    for (const field of this.type.fields) {
      if (field.args.length > 0) {
        argsTypes.push(
          new MinimalArgsType(
            field.args,
            this.type,
            this.genericsInfo,
            void 0,
            getCountArgsType(this.type.name, field.name)
          )
        );
      }
    }
    return argsTypes;
  }
  toTS() {
    const { type } = this;
    const { name } = type;
    const outputType = new OutputType(this.dmmf, this.type);
    return `
/**
 * Count Type ${name}
 */

${outputType.toTS()}

export type ${getSelectName(name)}${ifExtensions(
      "<ExtArgs extends runtime.Types.Extensions.Args = runtime.Types.Extensions.DefaultArgs>",
      ""
    )} = {
${(0, import_indent_string5.default)(
      type.fields.map((field) => {
        const types = ["boolean"];
        if (field.outputType.location === "outputObjectTypes") {
          types.push(getFieldArgName(field, this.type.name));
        }
        if (field.args.length > 0) {
          types.push(getCountArgsType(name, field.name));
        }
        return `${field.name}?: ${types.join(" | ")}`;
      }).join("\n"),
      TAB_SIZE
    )}
}

${ifExtensions("", new PayloadType(outputType, this.dmmf, false).toTS())}



// Custom InputTypes
${this.argsTypes.map((gen) => TS(gen)).join("\n")}
`;
  }
};
__name(Count, "Count");
function getCountArgsType(typeName, fieldName) {
  return `${typeName}Count${capitalize2(fieldName)}Args`;
}
__name(getCountArgsType, "getCountArgsType");

// src/generation/TSClient/Enum.ts
var import_indent_string6 = __toESM(require_indent_string());

// src/runtime/strictEnum.ts
var strictEnumNames = ["TransactionIsolationLevel"];

// src/generation/TSClient/Enum.ts
var Enum = class {
  constructor(type, useNamespace) {
    this.type = type;
    this.useNamespace = useNamespace;
  }
  isObjectEnum() {
    return this.useNamespace && objectEnumNames.includes(this.type.name);
  }
  isStrictEnum() {
    return this.useNamespace && strictEnumNames.includes(this.type.name);
  }
  toJS() {
    const { type } = this;
    const factoryFunction = this.isStrictEnum() ? "makeStrictEnum" : "makeEnum";
    return `exports.${this.useNamespace ? "Prisma." : ""}${type.name} = ${factoryFunction}({
${(0, import_indent_string6.default)(type.values.map((v) => `${v}: ${this.getValueJS(v)}`).join(",\n"), TAB_SIZE)}
});`;
  }
  getValueJS(value) {
    return this.isObjectEnum() ? `Prisma.${value}` : `'${value}'`;
  }
  toTS() {
    const { type } = this;
    return `export const ${type.name}: {
${(0, import_indent_string6.default)(type.values.map((v) => `${v}: ${this.getValueTS(v)}`).join(",\n"), TAB_SIZE)}
};

export type ${type.name} = (typeof ${type.name})[keyof typeof ${type.name}]
`;
  }
  getValueTS(value) {
    return this.isObjectEnum() ? `typeof ${value}` : `'${value}'`;
  }
};
__name(Enum, "Enum");

// src/generation/TSClient/FieldRefInput.ts
var FieldRefInput = class {
  constructor(type) {
    this.type = type;
  }
  toTS() {
    const allowedTypes = this.getAllowedTypes();
    return `
/**
 * Reference to a field of type ${allowedTypes}
 */
export type ${this.type.name}<$PrismaModel> = FieldRefInputType<$PrismaModel, ${allowedTypes}>
    `;
  }
  getAllowedTypes() {
    return this.type.allowTypes.map(getRefAllowedTypeName).join(" | ");
  }
};
__name(FieldRefInput, "FieldRefInput");

// src/generation/TSClient/Input.ts
var import_indent_string7 = __toESM(require_indent_string());

// src/runtime/utils/uniqueBy.ts
function uniqueBy(arr, callee) {
  const result = {};
  for (const value of arr) {
    const hash = callee(value);
    if (!result[hash]) {
      result[hash] = value;
    }
  }
  return Object.values(result);
}
__name(uniqueBy, "uniqueBy");

// src/generation/ts-builders/ArraySpread.ts
init_TypeBuilder();
var ArraySpread = class extends TypeBuilder {
  constructor(innerType) {
    super();
    this.innerType = innerType;
  }
  write(writer) {
    writer.write("[...").write(this.innerType).write("]");
  }
};
__name(ArraySpread, "ArraySpread");
function arraySpread(innerType) {
  return new ArraySpread(innerType);
}
__name(arraySpread, "arraySpread");

// src/generation/ts-builders/ArrayType.ts
init_TypeBuilder();
var ArrayType = class extends TypeBuilder {
  constructor(elementType) {
    super();
    this.elementType = elementType;
  }
  write(writer) {
    this.elementType.writeIndexed(writer);
    writer.write("[]");
  }
};
__name(ArrayType, "ArrayType");
function array(elementType) {
  return new ArrayType(elementType);
}
__name(array, "array");

// src/generation/ts-builders/DocComment.ts
var DocComment = class {
  constructor(startingText) {
    this.lines = [];
    if (startingText) {
      this.addText(startingText);
    }
  }
  addText(text) {
    this.lines.push(...text.split("\n"));
    return this;
  }
  write(writer) {
    writer.writeLine("/**");
    for (const line of this.lines) {
      writer.writeLine(` * ${line}`);
    }
    writer.writeLine(" */");
    return writer;
  }
};
__name(DocComment, "DocComment");
function docComment(firstParameter) {
  if (typeof firstParameter === "string" || typeof firstParameter === "undefined") {
    return new DocComment(firstParameter);
  }
  return docCommentTag(firstParameter);
}
__name(docComment, "docComment");
function docCommentTag(strings) {
  const docComment2 = new DocComment();
  const lines = trimEmptyLines(strings.join("").split("\n"));
  if (lines.length === 0) {
    return docComment2;
  }
  const indent15 = getIndent(lines[0]);
  for (const line of lines) {
    docComment2.addText(line.slice(indent15));
  }
  return docComment2;
}
__name(docCommentTag, "docCommentTag");
function trimEmptyLines(lines) {
  const firstLine = findFirstNonEmptyLine(lines);
  const lastLine = findLastNonEmptyLine(lines);
  if (firstLine === -1 || lastLine === -1) {
    return [];
  }
  return lines.slice(firstLine, lastLine + 1);
}
__name(trimEmptyLines, "trimEmptyLines");
function findFirstNonEmptyLine(lines) {
  return lines.findIndex((line) => !isEmptyLine(line));
}
__name(findFirstNonEmptyLine, "findFirstNonEmptyLine");
function findLastNonEmptyLine(lines) {
  let i = lines.length - 1;
  while (i > 0 && isEmptyLine(lines[i])) {
    i--;
  }
  return i;
}
__name(findLastNonEmptyLine, "findLastNonEmptyLine");
function isEmptyLine(line) {
  return line.trim().length === 0;
}
__name(isEmptyLine, "isEmptyLine");
function getIndent(line) {
  let indent15 = 0;
  while (line[indent15] === " ") {
    indent15++;
  }
  return indent15;
}
__name(getIndent, "getIndent");

// src/generation/ts-builders/Export.ts
var Export = class {
  constructor(declaration) {
    this.declaration = declaration;
  }
  write(writer) {
    writer.write("export ").write(this.declaration);
  }
};
__name(Export, "Export");
function moduleExport(declaration) {
  return new Export(declaration);
}
__name(moduleExport, "moduleExport");

// src/generation/ts-builders/PrimitiveType.ts
init_TypeBuilder();
var PrimitiveType = class extends TypeBuilder {
  constructor(name) {
    super();
    this.name = name;
  }
  write(writer) {
    writer.write(this.name);
  }
};
__name(PrimitiveType, "PrimitiveType");
var stringType = new PrimitiveType("string");
var numberType = new PrimitiveType("number");
var booleanType = new PrimitiveType("boolean");
var nullType = new PrimitiveType("null");
var undefinedType = new PrimitiveType("undefined");
var bigintType = new PrimitiveType("bigint");
var unknownType = new PrimitiveType("unknown");
var anyType = new PrimitiveType("any");
var voidType = new PrimitiveType("void");

// src/generation/ts-builders/FunctionType.ts
init_TypeBuilder();
var FunctionType = class extends TypeBuilder {
  constructor() {
    super(...arguments);
    this.needsParenthesisWhenIndexed = true;
    this.returnType = voidType;
    this.parameters = [];
    this.genericParameters = [];
  }
  setReturnType(returnType) {
    this.returnType = returnType;
    return this;
  }
  addParameter(param) {
    this.parameters.push(param);
    return this;
  }
  addGenericParameter(param) {
    this.genericParameters.push(param);
    return this;
  }
  write(writer) {
    if (this.genericParameters.length > 0) {
      writer.write("<").writeJoined(", ", this.genericParameters).write(">");
    }
    writer.write("(").writeJoined(", ", this.parameters).write(") => ").write(this.returnType);
  }
};
__name(FunctionType, "FunctionType");
function functionType() {
  return new FunctionType();
}
__name(functionType, "functionType");

// src/generation/ts-builders/NamedType.ts
init_TypeBuilder();
var NamedType = class extends TypeBuilder {
  constructor(name) {
    super();
    this.name = name;
    this.genericArguments = [];
  }
  addGenericArgument(type) {
    this.genericArguments.push(type);
    return this;
  }
  write(writer) {
    writer.write(this.name);
    if (this.genericArguments.length > 0) {
      writer.write("<").writeJoined(", ", this.genericArguments).write(">");
    }
  }
};
__name(NamedType, "NamedType");
function namedType(name) {
  return new NamedType(name);
}
__name(namedType, "namedType");
function promise(resultType) {
  return new NamedType("Promise").addGenericArgument(resultType);
}
__name(promise, "promise");
function prismaPromise(resultType) {
  return new NamedType("Prisma.PrismaPromise").addGenericArgument(resultType);
}
__name(prismaPromise, "prismaPromise");

// src/generation/ts-builders/GenericParameter.ts
var GenericParameter = class {
  constructor(name) {
    this.name = name;
  }
  extends(type) {
    this.extendedType = type;
    return this;
  }
  default(type) {
    this.defaultType = type;
    return this;
  }
  toArgument() {
    return new NamedType(this.name);
  }
  write(writer) {
    writer.write(this.name);
    if (this.extendedType) {
      writer.write(" extends ").write(this.extendedType);
    }
    if (this.defaultType) {
      writer.write(" = ").write(this.defaultType);
    }
  }
};
__name(GenericParameter, "GenericParameter");
function genericParameter(name) {
  return new GenericParameter(name);
}
__name(genericParameter, "genericParameter");

// src/generation/ts-builders/Method.ts
var Method = class {
  constructor(name) {
    this.name = name;
    this.returnType = voidType;
    this.parameters = [];
    this.genericParameters = [];
  }
  setDocComment(docComment2) {
    this.docComment = docComment2;
    return this;
  }
  setReturnType(returnType) {
    this.returnType = returnType;
    return this;
  }
  addParameter(param) {
    this.parameters.push(param);
    return this;
  }
  addGenericParameter(param) {
    this.genericParameters.push(param);
    return this;
  }
  write(writer) {
    if (this.docComment) {
      writer.write(this.docComment);
    }
    writer.write(this.name);
    if (this.genericParameters.length > 0) {
      writer.write("<").writeJoined(", ", this.genericParameters).write(">");
    }
    writer.write("(");
    if (this.parameters.length > 0) {
      writer.writeJoined(", ", this.parameters);
    }
    writer.write(")").write(": ").write(this.returnType);
  }
};
__name(Method, "Method");
function method(name) {
  return new Method(name);
}
__name(method, "method");

// src/generation/ts-builders/ObjectType.ts
init_TypeBuilder();
var ObjectType = class extends TypeBuilder {
  constructor() {
    super(...arguments);
    this.needsParenthesisWhenIndexed = true;
    this.items = [];
    this.inline = false;
  }
  add(item) {
    this.items.push(item);
    return this;
  }
  formatInline() {
    this.inline = true;
    return this;
  }
  write(writer) {
    if (this.items.length === 0) {
      writer.write("{}");
    } else if (this.inline) {
      this.writeInline(writer);
    } else {
      this.writeMultiline(writer);
    }
  }
  writeMultiline(writer) {
    writer.writeLine("{").withIndent(() => {
      for (const item of this.items) {
        writer.writeLine(item);
      }
    }).write("}");
  }
  writeInline(writer) {
    writer.write("{ ").writeJoined(", ", this.items).write(" }");
  }
};
__name(ObjectType, "ObjectType");
function objectType() {
  return new ObjectType();
}
__name(objectType, "objectType");

// src/generation/ts-builders/Parameter.ts
var Parameter = class {
  constructor(name, type) {
    this.name = name;
    this.type = type;
    this.isOptional = false;
  }
  optional() {
    this.isOptional = true;
    return this;
  }
  write(writer) {
    writer.write(this.name);
    if (this.isOptional) {
      writer.write("?");
    }
    writer.write(": ").write(this.type);
  }
};
__name(Parameter, "Parameter");
function parameter(name, type) {
  return new Parameter(name, type);
}
__name(parameter, "parameter");

// src/generation/ts-builders/Property.ts
var Property = class {
  constructor(name, type) {
    this.name = name;
    this.type = type;
    this.isOptional = false;
    this.isReadonly = false;
  }
  optional() {
    this.isOptional = true;
    return this;
  }
  readonly() {
    this.isReadonly = true;
    return this;
  }
  setDocComment(docComment2) {
    this.docComment = docComment2;
    return this;
  }
  write(writer) {
    if (this.docComment) {
      writer.write(this.docComment);
    }
    if (this.isReadonly) {
      writer.write("readonly ");
    }
    writer.write(this.name);
    if (this.isOptional) {
      writer.write("?");
    }
    writer.write(": ").write(this.type);
  }
};
__name(Property, "Property");
function property(name, type) {
  return new Property(name, type);
}
__name(property, "property");

// src/generation/ts-builders/Writer.ts
var INDENT_SIZE = 2;
var Writer = class {
  constructor(startingIndent = 0) {
    this.lines = [];
    this.currentLine = "";
    this.currentIndent = 0;
    this.currentIndent = startingIndent;
  }
  write(value) {
    if (typeof value === "string") {
      this.currentLine += value;
    } else {
      value.write(this);
    }
    return this;
  }
  writeJoined(separator, values) {
    const last = values.length - 1;
    for (let i = 0; i < values.length; i++) {
      this.write(values[i]);
      if (i !== last) {
        this.write(separator);
      }
    }
    return this;
  }
  writeLine(line) {
    return this.write(line).newLine();
  }
  newLine() {
    this.lines.push(this.indentedCurrentLine());
    this.currentLine = "";
    return this;
  }
  withIndent(callback) {
    this.indent();
    callback(this);
    this.unindent();
    return this;
  }
  indent() {
    this.currentIndent++;
    return this;
  }
  unindent() {
    if (this.currentIndent > 0) {
      this.currentIndent--;
    }
    return this;
  }
  toString() {
    return this.lines.concat(this.indentedCurrentLine()).join("\n");
  }
  indentedCurrentLine() {
    return this.currentLine.padStart(this.currentLine.length + INDENT_SIZE * this.currentIndent);
  }
};
__name(Writer, "Writer");

// src/generation/ts-builders/stringify.ts
function stringify(builder, { indentLevel = 0, newLine = "none" } = {}) {
  const str = new Writer(indentLevel).write(builder).toString();
  switch (newLine) {
    case "none":
      return str;
    case "leading":
      return "\n" + str;
    case "trailing":
      return str + "\n";
    case "both":
      return "\n" + str + "\n";
    default:
      assertNever(newLine, "Unexpected value");
  }
}
__name(stringify, "stringify");

// src/generation/ts-builders/StringLiteralType.ts
init_TypeBuilder();
var StringLiteralType = class extends TypeBuilder {
  constructor(content) {
    super();
    this.content = content;
  }
  write(writer) {
    writer.write(JSON.stringify(this.content));
  }
};
__name(StringLiteralType, "StringLiteralType");
function stringLiteral(content) {
  return new StringLiteralType(content);
}
__name(stringLiteral, "stringLiteral");

// src/generation/ts-builders/TypeDeclaration.ts
var TypeDeclaration = class {
  constructor(name, type) {
    this.name = name;
    this.type = type;
    this.genericParameters = [];
  }
  addGenericParameter(param) {
    this.genericParameters.push(param);
    return this;
  }
  setDocComment(docComment2) {
    this.docComment = docComment2;
    return this;
  }
  write(writer) {
    if (this.docComment) {
      writer.write(this.docComment);
    }
    writer.write("type ").write(this.name);
    if (this.genericParameters.length > 0) {
      writer.write("<").writeJoined(", ", this.genericParameters).write(">");
    }
    writer.write(" = ").write(this.type);
  }
};
__name(TypeDeclaration, "TypeDeclaration");
function typeDeclaration(name, type) {
  return new TypeDeclaration(name, type);
}
__name(typeDeclaration, "typeDeclaration");

// src/generation/ts-builders/UnionType.ts
init_TypeBuilder();
var UnionType = class extends TypeBuilder {
  constructor(firstType) {
    super();
    this.needsParenthesisWhenIndexed = true;
    this.variants = [firstType];
  }
  addVariant(variant) {
    this.variants.push(variant);
    return this;
  }
  addVariants(variants) {
    for (const variant of variants) {
      this.addVariant(variant);
    }
    return this;
  }
  write(writer) {
    writer.writeJoined(" | ", this.variants);
  }
  mapVariants(callback) {
    return unionType(this.variants.map((v) => callback(v)));
  }
};
__name(UnionType, "UnionType");
function unionType(types) {
  if (Array.isArray(types)) {
    if (types.length === 0) {
      throw new TypeError("Union types array can not be empty");
    }
    const union = new UnionType(types[0]);
    for (let i = 1; i < types.length; i++) {
      union.addVariant(types[i]);
    }
    return union;
  }
  return new UnionType(types);
}
__name(unionType, "unionType");

// src/generation/TSClient/Input.ts
var InputField = class {
  constructor(field, noEnumerable = false, genericsInfo, source) {
    this.field = field;
    this.noEnumerable = noEnumerable;
    this.genericsInfo = genericsInfo;
    this.source = source;
  }
  toTS() {
    const property2 = buildInputField(this.field, this.noEnumerable, this.genericsInfo, this.source);
    return stringify(property2);
  }
};
__name(InputField, "InputField");
function buildInputField(field, noEnumerable = false, genericsInfo, source) {
  const tsType = buildAllFieldTypes(field.inputTypes, noEnumerable, genericsInfo, source);
  const tsProperty = property(field.name, tsType);
  if (!field.isRequired) {
    tsProperty.optional();
  }
  const docComment2 = docComment();
  if (field.comment) {
    docComment2.addText(field.comment);
  }
  if (field.deprecation) {
    docComment2.addText(`@deprecated since ${field.deprecation.sinceVersion}: ${field.deprecation.reason}`);
  }
  if (docComment2.lines.length > 0) {
    tsProperty.setDocComment(docComment2);
  }
  return tsProperty;
}
__name(buildInputField, "buildInputField");
function buildSingleFieldType(t3, noEnumerable = false, genericsInfo, source) {
  let type;
  if (typeof t3.type === "string") {
    if (t3.type === "Null") {
      return nullType;
    }
    const scalarType = GraphQLScalarToJSTypeTable[t3.type];
    if (Array.isArray(scalarType)) {
      const union = unionType(scalarType.map(namedInputType));
      if (t3.isList) {
        return union.mapVariants((variant) => wrapList(variant, noEnumerable));
      }
      return union;
    }
    type = namedInputType(scalarType ?? t3.type);
  } else {
    type = namedInputType(t3.type.name);
  }
  ifExtensions(() => {
    if (type.name.endsWith("Select") || type.name.endsWith("Include")) {
      type.addGenericArgument(namedType("ExtArgs"));
    }
  }, void 0);
  if (genericsInfo.needsGenericModelArg(t3)) {
    if (source) {
      type.addGenericArgument(stringLiteral(source));
    } else {
      type.addGenericArgument(namedType("$PrismaModel"));
    }
  }
  if (t3.isList) {
    return wrapList(type, noEnumerable);
  }
  return type;
}
__name(buildSingleFieldType, "buildSingleFieldType");
function namedInputType(typeName) {
  return namedType(JSOutputTypeToInputType[typeName] ?? typeName);
}
__name(namedInputType, "namedInputType");
function wrapList(type, noEnumerable) {
  return noEnumerable ? array(type) : namedType("Enumerable").addGenericArgument(type);
}
__name(wrapList, "wrapList");
function buildAllFieldTypes(inputTypes, noEnumerable = false, genericsInfo, source) {
  const pairMap = /* @__PURE__ */ Object.create(null);
  const singularPairIndexes = /* @__PURE__ */ new Set();
  for (let i = 0; i < inputTypes.length; i++) {
    const inputType = inputTypes[i];
    if (argIsInputType(inputType.type)) {
      const { name } = inputType.type;
      if (typeof pairMap[name] === "number") {
        if (inputType.isList) {
          singularPairIndexes.add(pairMap[name]);
        } else {
          singularPairIndexes.add(i);
        }
      } else {
        pairMap[name] = i;
      }
    }
  }
  const filteredInputTypes = inputTypes.filter((t3, i) => !singularPairIndexes.has(i));
  const inputObjectTypes = filteredInputTypes.filter((t3) => t3.location === "inputObjectTypes");
  const otherTypes = filteredInputTypes.filter((t3) => t3.location !== "inputObjectTypes");
  const tsInputObjectTypes = inputObjectTypes.map(
    (type) => buildSingleFieldType(type, noEnumerable, genericsInfo, source)
  );
  const tsOtherTypes = otherTypes.map((type) => buildSingleFieldType(type, noEnumerable, genericsInfo, source));
  if (tsOtherTypes.length === 0) {
    return xorTypes(tsInputObjectTypes);
  }
  if (tsInputObjectTypes.length === 0) {
    return unionType(tsOtherTypes);
  }
  return unionType(xorTypes(tsInputObjectTypes)).addVariants(tsOtherTypes);
}
__name(buildAllFieldTypes, "buildAllFieldTypes");
function xorTypes(types) {
  return types.reduce((prev, curr) => namedType("XOR").addGenericArgument(prev).addGenericArgument(curr));
}
__name(xorTypes, "xorTypes");
var InputType = class {
  constructor(type, genericsInfo) {
    this.type = type;
    this.genericsInfo = genericsInfo;
  }
  toTS() {
    const { type } = this;
    const source = type.meta?.source;
    const fields = uniqueBy(type.fields, (f) => f.name);
    const body = `{
${(0, import_indent_string7.default)(
      fields.map((arg) => {
        const noEnumerable = type.name.includes("Json") && type.name.includes("Filter") && arg.name === "path";
        return new InputField(arg, noEnumerable, this.genericsInfo, source).toTS();
      }).join("\n"),
      TAB_SIZE
    )}
}`;
    return `
export type ${this.getTypeName()} = ${wrapWithAtLeast(body, type)}`;
  }
  getTypeName() {
    if (this.genericsInfo.inputTypeNeedsGenericModelArg(this.type)) {
      return `${this.type.name}<$PrismaModel = never>`;
    }
    return this.type.name;
  }
};
__name(InputType, "InputType");
function wrapWithAtLeast(body, input) {
  if (input.constraints?.fields && input.constraints.fields.length > 0) {
    const fields = input.constraints.fields.map((f) => `"${f}"`).join(" | ");
    return `Prisma.AtLeast<${body}, ${fields}>`;
  }
  return body;
}
__name(wrapWithAtLeast, "wrapWithAtLeast");

// src/generation/TSClient/Model.ts
var import_indent_string9 = __toESM(require_indent_string());

// src/generation/TSClient/ModelFieldRefs.ts
var ModelFieldRefs = class {
  constructor(generator2, outputType) {
    this.generator = generator2;
    this.outputType = outputType;
  }
  toTS() {
    if (!this.generator?.previewFeatures.includes("fieldReference")) {
      return "";
    }
    const { name } = this.outputType;
    return `

/**
 * Fields of the ${name} model
 */ 
interface ${getFieldRefsTypeName(name)} {
${this.stringifyFields()}
}
    `;
  }
  stringifyFields() {
    const { name } = this.outputType;
    return this.outputType.fields.filter((field) => field.outputType.location !== "outputObjectTypes").map((field) => {
      const fieldOutput = field.outputType;
      const refTypeName = getRefAllowedTypeName(fieldOutput);
      return `  readonly ${field.name}: FieldRef<"${name}", ${refTypeName}>`;
    }).join("\n");
  }
};
__name(ModelFieldRefs, "ModelFieldRefs");

// src/generation/TSClient/SchemaOutput.ts
var import_indent_string8 = __toESM(require_indent_string());
var SchemaOutputField = class {
  constructor(field) {
    this.field = field;
  }
  toTS() {
    const { field } = this;
    let fieldType = typeof field.outputType.type === "string" ? GraphQLScalarToJSTypeTable[field.outputType.type] || field.outputType.type : field.outputType.type.name;
    if (Array.isArray(fieldType)) {
      fieldType = fieldType[0];
    }
    const arrayStr = field.outputType.isList ? `[]` : "";
    const nullableStr = field.isNullable ? " | null" : "";
    return `${field.name}: ${fieldType}${arrayStr}${nullableStr}`;
  }
};
__name(SchemaOutputField, "SchemaOutputField");
var SchemaOutputType = class {
  constructor(type) {
    this.type = type;
    this.name = type.name;
    this.fields = type.fields;
  }
  toTS() {
    const { type } = this;
    return `
export type ${type.name} = {
${(0, import_indent_string8.default)(
      type.fields.map((field) => new SchemaOutputField({ ...field, ...field.outputType }).toTS()).join("\n"),
      TAB_SIZE
    )}
}`;
  }
};
__name(SchemaOutputType, "SchemaOutputType");

// src/generation/TSClient/SelectInclude.ts
var extArgsParameter = genericParameter("ExtArgs").extends(namedType("runtime.Types.Extensions.Args")).default(namedType("runtime.Types.Extensions.DefaultArgs"));
function buildIncludeType({ modelName, dmmf: dmmf2, fields }) {
  const type = buildSelectOrIncludeObject(modelName, getIncludeFields(fields, dmmf2));
  return buildExport(getIncludeName(modelName), type);
}
__name(buildIncludeType, "buildIncludeType");
function buildSelectType({ modelName, fields }) {
  const objectType2 = buildSelectOrIncludeObject(modelName, fields);
  const selectType = ifExtensions(
    () => namedType("runtime.Types.Extensions.GetSelect").addGenericArgument(objectType2).addGenericArgument(extArgsParameter.toArgument().subKey("result").subKey(lowerCase(modelName))),
    () => objectType2
  );
  return buildExport(getSelectName(modelName), selectType);
}
__name(buildSelectType, "buildSelectType");
function buildScalarSelectType({ modelName, fields }) {
  const object = buildSelectOrIncludeObject(
    modelName,
    fields.filter((field) => field.outputType.location === "scalar" || field.outputType.location === "enumTypes")
  );
  return moduleExport(typeDeclaration(`${getSelectName(modelName)}Scalar`, object));
}
__name(buildScalarSelectType, "buildScalarSelectType");
function buildSelectOrIncludeObject(modelName, fields) {
  const objectType2 = objectType();
  for (const field of fields) {
    const fieldType = unionType(booleanType);
    if (field.outputType.location === "outputObjectTypes") {
      const subSelectType = namedType(getFieldArgName(field, modelName));
      ifExtensions(
        () => {
          subSelectType.addGenericArgument(extArgsParameter.toArgument());
        },
        () => {
        }
      );
      fieldType.addVariant(subSelectType);
    }
    objectType2.add(property(field.name, fieldType).optional());
  }
  return objectType2;
}
__name(buildSelectOrIncludeObject, "buildSelectOrIncludeObject");
function buildExport(typeName, type) {
  const declaration = typeDeclaration(typeName, type);
  return moduleExport(
    ifExtensions(
      () => declaration.addGenericParameter(extArgsParameter),
      () => declaration
    )
  );
}
__name(buildExport, "buildExport");
function getIncludeFields(fields, dmmf2) {
  return fields.filter((field) => {
    if (field.outputType.location !== "outputObjectTypes") {
      return false;
    }
    const name = typeof field.outputType.type === "string" ? field.outputType.type : field.outputType.type.name;
    return !dmmf2.typeMap[name];
  });
}
__name(getIncludeFields, "getIncludeFields");

// src/generation/TSClient/utils/getModelActions.ts
function getModelActions(dmmf2, name) {
  const mapping = dmmf2.mappingsMap[name] ?? { model: name, plural: `${name}s` };
  const mappingKeys = Object.keys(mapping).filter(
    (key) => key !== "model" && key !== "plural" && mapping[key]
  );
  if ("aggregate" in mapping) {
    mappingKeys.push("count");
  }
  return mappingKeys;
}
__name(getModelActions, "getModelActions");

// src/generation/TSClient/Model.ts
var Model = class {
  constructor(model, dmmf2, genericsInfo, generator2) {
    this.model = model;
    this.dmmf = dmmf2;
    this.genericsInfo = genericsInfo;
    this.generator = generator2;
    this.type = dmmf2.outputTypeMap[model.name];
    this.outputType = new OutputType(dmmf2, this.type);
    this.mapping = dmmf2.mappings.modelOperations.find((m) => m.model === model.name);
  }
  get argsTypes() {
    const argsTypes = [];
    for (const action of Object.keys(DMMF.ModelAction)) {
      const fieldName = this.rootFieldNameForAction(action);
      if (!fieldName) {
        continue;
      }
      const field = this.dmmf.rootFieldMap[fieldName];
      if (!field) {
        throw new Error(`Oops this must not happen. Could not find field ${fieldName} on either Query or Mutation`);
      }
      if (action === "updateMany" || action === "deleteMany" || action === "createMany") {
        argsTypes.push(new MinimalArgsType(field.args, this.type, this.genericsInfo, action));
      } else if (action === "findRaw" || action === "aggregateRaw") {
        argsTypes.push(new MinimalArgsType(field.args, this.type, this.genericsInfo, action));
      } else if (action !== "groupBy" && action !== "aggregate") {
        argsTypes.push(new ArgsType(field.args, this.type, this.genericsInfo, action));
      }
    }
    for (const field of this.type.fields) {
      if (field.args.length) {
        if (field.outputType.location === "outputObjectTypes" && typeof field.outputType.type === "object") {
          argsTypes.push(
            new ArgsType(field.args, field.outputType.type, this.genericsInfo).setGeneratedName(getModelFieldArgsName(field, this.model.name)).setComment(`${this.model.name}.${field.name}`)
          );
        }
      }
    }
    argsTypes.push(new ArgsType([], this.type, this.genericsInfo));
    return argsTypes;
  }
  rootFieldNameForAction(action) {
    return this.mapping?.[action];
  }
  getGroupByTypes() {
    const { model, mapping } = this;
    const groupByType = this.dmmf.outputTypeMap[getGroupByName(model.name)];
    if (!groupByType) {
      throw new Error(`Could not get group by type for model ${model.name}`);
    }
    const groupByRootField = this.dmmf.rootFieldMap[mapping.groupBy];
    if (!groupByRootField) {
      throw new Error(`Could not find groupBy root field for model ${model.name}. Mapping: ${mapping?.groupBy}`);
    }
    const groupByArgsName = getGroupByArgsName(model.name);
    return `


export type ${groupByArgsName}${ifExtensions(
      "<ExtArgs extends runtime.Types.Extensions.Args = runtime.Types.Extensions.DefaultArgs>",
      ""
    )} = {
${(0, import_indent_string9.default)(
      groupByRootField.args.map((arg) => {
        arg.comment = getArgFieldJSDoc(this.type, DMMF.ModelAction.groupBy, arg);
        return new InputField(arg, arg.name === "by", this.genericsInfo).toTS();
      }).concat(
        groupByType.fields.filter((f) => f.outputType.location === "outputObjectTypes").map((f) => {
          if (f.outputType.location === "outputObjectTypes") {
            return `${f.name}?: ${getAggregateInputType(f.outputType.type.name)}${f.name === "_count" ? " | true" : ""}`;
          }
          return "";
        })
      ).join("\n"),
      TAB_SIZE
    )}
}

${new OutputType(this.dmmf, groupByType).toTS()}

type ${getGroupByPayloadName(model.name)}<T extends ${groupByArgsName}> = Prisma.PrismaPromise<
  Array<
    PickArray<${groupByType.name}, T['by']> &
      {
        [P in ((keyof T) & (keyof ${groupByType.name}))]: P extends '_count'
          ? T[P] extends boolean
            ? number
            : GetScalarType<T[P], ${groupByType.name}[P]>
          : GetScalarType<T[P], ${groupByType.name}[P]>
      }
    >
  >
`;
  }
  getAggregationTypes() {
    const { model, mapping } = this;
    let aggregateType = this.dmmf.outputTypeMap[getAggregateName(model.name)];
    if (!aggregateType) {
      throw new Error(`Could not get aggregate type "${getAggregateName(model.name)}" for "${model.name}"`);
    }
    aggregateType = klona(aggregateType);
    const aggregateRootField = this.dmmf.rootFieldMap[mapping.aggregate];
    if (!aggregateRootField) {
      throw new Error(`Could not find aggregate root field for model ${model.name}. Mapping: ${mapping?.aggregate}`);
    }
    const aggregateTypes = [aggregateType];
    const avgType = this.dmmf.outputTypeMap[getAvgAggregateName(model.name)];
    const sumType = this.dmmf.outputTypeMap[getSumAggregateName(model.name)];
    const minType = this.dmmf.outputTypeMap[getMinAggregateName(model.name)];
    const maxType = this.dmmf.outputTypeMap[getMaxAggregateName(model.name)];
    const countType = this.dmmf.outputTypeMap[getCountAggregateOutputName(model.name)];
    if (avgType) {
      aggregateTypes.push(avgType);
    }
    if (sumType) {
      aggregateTypes.push(sumType);
    }
    if (minType) {
      aggregateTypes.push(minType);
    }
    if (maxType) {
      aggregateTypes.push(maxType);
    }
    if (countType) {
      aggregateTypes.push(countType);
    }
    const aggregateArgsName = getAggregateArgsName(model.name);
    const aggregateName = getAggregateName(model.name);
    return `${aggregateTypes.map((type) => new SchemaOutputType(type).toTS()).join("\n")}

${aggregateTypes.length > 1 ? aggregateTypes.slice(1).map((type) => {
      const newType = {
        name: getAggregateInputType(type.name),
        constraints: {
          maxNumFields: null,
          minNumFields: null
        },
        fields: type.fields.map((field) => ({
          ...field,
          name: field.name,
          isNullable: false,
          isRequired: false,
          inputTypes: [
            {
              isList: false,
              location: "scalar",
              type: "true"
            }
          ]
        }))
      };
      return new InputType(newType, this.genericsInfo).toTS();
    }).join("\n") : ""}

export type ${aggregateArgsName}${ifExtensions(
      "<ExtArgs extends runtime.Types.Extensions.Args = runtime.Types.Extensions.DefaultArgs>",
      ""
    )} = {
${(0, import_indent_string9.default)(
      aggregateRootField.args.map((arg) => {
        arg.comment = getArgFieldJSDoc(this.type, DMMF.ModelAction.aggregate, arg);
        return new InputField(arg, false, this.genericsInfo).toTS();
      }).concat(
        aggregateType.fields.map((f) => {
          let data = "";
          const comment = getArgFieldJSDoc(this.type, DMMF.ModelAction.aggregate, f.name);
          data += comment ? wrapComment(comment) + "\n" : "";
          if (f.name === "_count" || f.name === "count") {
            data += `${f.name}?: true | ${getCountAggregateInputName(model.name)}`;
          } else {
            data += `${f.name}?: ${getAggregateInputType(f.outputType.type.name)}`;
          }
          return data;
        })
      ).join("\n"),
      TAB_SIZE
    )}
}

export type ${getAggregateGetName(model.name)}<T extends ${getAggregateArgsName(model.name)}> = {
      [P in keyof T & keyof ${aggregateName}]: P extends '_count' | 'count'
    ? T[P] extends true
      ? number
      : GetScalarType<T[P], ${aggregateName}[P]>
    : GetScalarType<T[P], ${aggregateName}[P]>
}`;
  }
  toTSWithoutNamespace() {
    const { model } = this;
    const docLines = model.documentation ?? "";
    const modelLine = `Model ${model.name}
`;
    const docs = `${modelLine}${docLines}`;
    return ifExtensions(
      () => {
        return `export type ${model.name}Payload<ExtArgs extends runtime.Types.Extensions.Args = runtime.Types.Extensions.DefaultArgs> = {
${(0, import_indent_string9.default)(
          `objects: {
${(0, import_indent_string9.default)(
            model.fields.filter((f) => f.kind === "object").map((field) => new ModelOutputField(this.dmmf, field, false).toTS()).join("\n"),
            TAB_SIZE
          )}
}`,
          TAB_SIZE
        )}
${(0, import_indent_string9.default)(
          `scalars: runtime.Types.Extensions.GetResult<{
${(0, import_indent_string9.default)(
            model.fields.filter((f) => f.kind === "scalar" || f.kind === "enum").map((field) => new ModelOutputField(this.dmmf, field, !this.dmmf.typeMap[field.type]).toTS()).join("\n"),
            TAB_SIZE
          )}
}, ExtArgs['result']['${lowerCase(model.name)}']>`,
          TAB_SIZE
        )}
}

${buildComment(docs)}export type ${model.name} = ${model.name}Payload['scalars']
`;
      },
      () => {
        return `${buildComment(docs)}export type ${model.name} = {
${(0, import_indent_string9.default)(
          model.fields.filter((f) => f.kind !== "object" && f.kind !== "unsupported" || this.dmmf.typeMap[f.type]).map((field) => new ModelOutputField(this.dmmf, field, !this.dmmf.typeMap[field.type]).toTS()).join("\n"),
          TAB_SIZE
        )}
}
`;
      }
    );
  }
  toTS() {
    const { model, outputType } = this;
    const hasRelationField = model.fields.some((f) => f.kind === "object");
    const includeType = hasRelationField ? stringify(
      buildIncludeType({ modelName: this.model.name, dmmf: this.dmmf, fields: this.outputType.fields }),
      {
        newLine: "both"
      }
    ) : "";
    return `
/**
 * Model ${model.name}
 */

${!this.dmmf.typeMap[model.name] ? this.getAggregationTypes() : ""}

${!this.dmmf.typeMap[model.name] ? this.getGroupByTypes() : ""}

${stringify(buildSelectType({ modelName: this.model.name, fields: this.outputType.fields }))}
${ifExtensions(() => {
      return stringify(buildScalarSelectType({ modelName: this.model.name, fields: this.outputType.fields }), {
        newLine: "leading"
      });
    }, "")}
${includeType}
${ifExtensions(
      `type ${model.name}GetPayload<S extends boolean | null | undefined | ${getArgName(
        model.name
      )}> = runtime.Types.GetFindResult<${model.name}Payload, S>`,
      new PayloadType(this.outputType, this.dmmf).toTS()
    )}

${new ModelDelegate(this.outputType, this.dmmf, this.generator).toTS()}

${new ModelFieldRefs(this.generator, this.outputType).toTS()}

// Custom InputTypes
${this.argsTypes.map((gen) => TS(gen)).join("\n")}
`;
  }
};
__name(Model, "Model");
var ModelDelegate = class {
  constructor(outputType, dmmf2, generator2) {
    this.outputType = outputType;
    this.dmmf = dmmf2;
    this.generator = generator2;
  }
  getNonAggregateActions(availableActions) {
    const actions = availableActions.filter((key) => key !== "aggregate" && key !== "groupBy" && key !== "count");
    return actions;
  }
  toTS() {
    const { fields, name } = this.outputType;
    const mapping = this.dmmf.mappingsMap[name] ?? { model: name, plural: `${name}s` };
    const modelOrType = this.dmmf.typeAndModelMap[name];
    const availableActions = getModelActions(this.dmmf, name);
    const nonAggregateActions = this.getNonAggregateActions(availableActions);
    const groupByArgsName = getGroupByArgsName(name);
    const countArgsName = getModelArgName(name, DMMF.ModelAction.count);
    let fieldsProxy = "";
    if (this.generator?.previewFeatures.includes("fieldReference")) {
      fieldsProxy = `
  /**
   * Fields of the ${name} model
   */
  readonly fields: ${getFieldRefsTypeName(name)};
`;
    }
    return `${availableActions.includes(DMMF.ModelAction.aggregate) ? `type ${countArgsName}${ifExtensions(
      "<ExtArgs extends runtime.Types.Extensions.Args = runtime.Types.Extensions.DefaultArgs>",
      ""
    )} = 
  Omit<${getModelArgName(name, DMMF.ModelAction.findMany)}, 'select' | 'include'> & {
    select?: ${getCountAggregateInputName(name)} | true
  }
` : ""}
export interface ${name}Delegate<GlobalRejectSettings extends Prisma.RejectOnNotFound | Prisma.RejectPerOperation | false | undefined${ifExtensions(
      ", ExtArgs extends runtime.Types.Extensions.Args = runtime.Types.Extensions.DefaultArgs",
      ""
    )}> {
${ifExtensions(
      `${(0, import_indent_string9.default)(
        `[K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['${name}'], meta: { name: '${name}' } }`,
        TAB_SIZE
      )}`,
      ""
    )}
${(0, import_indent_string9.default)(
      nonAggregateActions.map(
        (actionName) => `${getMethodJSDoc(actionName, mapping, modelOrType)}
${actionName}${getGenericMethod(name, actionName)}(
  ${getArgs(name, actionName)}
): ${getReturnType({ name, actionName, projection: "select" /* select */ })}`
      ).join("\n\n"),
      TAB_SIZE
    )}

${availableActions.includes(DMMF.ModelAction.aggregate) ? `${(0, import_indent_string9.default)(getMethodJSDoc(DMMF.ModelAction.count, mapping, modelOrType), TAB_SIZE)}
  count<T extends ${countArgsName}>(
    args?: Subset<T, ${countArgsName}>,
  ): Prisma.PrismaPromise<
    T extends _Record<'select', any>
      ? T['select'] extends true
        ? number
        : GetScalarType<T['select'], ${getCountAggregateOutputName(name)}>
      : number
  >
` : ""}
${availableActions.includes(DMMF.ModelAction.aggregate) ? `${(0, import_indent_string9.default)(getMethodJSDoc(DMMF.ModelAction.aggregate, mapping, modelOrType), TAB_SIZE)}
  aggregate<T extends ${getAggregateArgsName(name)}>(args: Subset<T, ${getAggregateArgsName(
      name
    )}>): Prisma.PrismaPromise<${getAggregateGetName(name)}<T>>
` : ""}
${availableActions.includes(DMMF.ModelAction.groupBy) ? `${(0, import_indent_string9.default)(getMethodJSDoc(DMMF.ModelAction.groupBy, mapping, modelOrType), TAB_SIZE)}
  groupBy<
    T extends ${groupByArgsName},
    HasSelectOrTake extends Or<
      Extends<'skip', Keys<T>>,
      Extends<'take', Keys<T>>
    >,
    OrderByArg extends True extends HasSelectOrTake
      ? { orderBy: ${groupByArgsName}['orderBy'] }
      : { orderBy?: ${groupByArgsName}['orderBy'] },
    OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
    ByFields extends TupleToUnion<T['by']>,
    ByValid extends Has<ByFields, OrderFields>,
    HavingFields extends GetHavingFields<T['having']>,
    HavingValid extends Has<ByFields, HavingFields>,
    ByEmpty extends T['by'] extends never[] ? True : False,
    InputErrors extends ByEmpty extends True
    ? \`Error: "by" must not be empty.\`
    : HavingValid extends False
    ? {
        [P in HavingFields]: P extends ByFields
          ? never
          : P extends string
          ? \`Error: Field "\${P}" used in "having" needs to be provided in "by".\`
          : [
              Error,
              'Field ',
              P,
              \` in "having" needs to be provided in "by"\`,
            ]
      }[HavingFields]
    : 'take' extends Keys<T>
    ? 'orderBy' extends Keys<T>
      ? ByValid extends True
        ? {}
        : {
            [P in OrderFields]: P extends ByFields
              ? never
              : \`Error: Field "\${P}" in "orderBy" needs to be provided in "by"\`
          }[OrderFields]
      : 'Error: If you provide "take", you also need to provide "orderBy"'
    : 'skip' extends Keys<T>
    ? 'orderBy' extends Keys<T>
      ? ByValid extends True
        ? {}
        : {
            [P in OrderFields]: P extends ByFields
              ? never
              : \`Error: Field "\${P}" in "orderBy" needs to be provided in "by"\`
          }[OrderFields]
      : 'Error: If you provide "skip", you also need to provide "orderBy"'
    : ByValid extends True
    ? {}
    : {
        [P in OrderFields]: P extends ByFields
          ? never
          : \`Error: Field "\${P}" in "orderBy" needs to be provided in "by"\`
      }[OrderFields]
  >(args: SubsetIntersection<T, ${groupByArgsName}, OrderByArg> & InputErrors): {} extends InputErrors ? ${getGroupByPayloadName(
      name
    )}<T> : Prisma.PrismaPromise<InputErrors>` : ""}
${fieldsProxy}
}

/**
 * The delegate class that acts as a "Promise-like" for ${name}.
 * Why is this prefixed with \`Prisma__\`?
 * Because we want to prevent naming conflicts as mentioned in
 * https://github.com/prisma/prisma-client-js/issues/707
 */
export class Prisma__${name}Client<T, Null = never${ifExtensions(
      ", ExtArgs extends runtime.Types.Extensions.Args = runtime.Types.Extensions.DefaultArgs",
      ""
    )}> implements Prisma.PrismaPromise<T> {
  private readonly _dmmf;
  private readonly _queryType;
  private readonly _rootField;
  private readonly _clientMethod;
  private readonly _args;
  private readonly _dataPath;
  private readonly _errorFormat;
  private readonly _measurePerformance?;
  private _isList;
  private _callsite;
  private _requestPromise?;
  readonly [Symbol.toStringTag]: 'PrismaPromise';
  constructor(_dmmf: runtime.DMMFClass, _queryType: 'query' | 'mutation', _rootField: string, _clientMethod: string, _args: any, _dataPath: string[], _errorFormat: ErrorFormat, _measurePerformance?: boolean | undefined, _isList?: boolean);
${(0, import_indent_string9.default)(
      fields.filter((f) => f.outputType.location === "outputObjectTypes" && f.name !== "_count").map((f) => {
        const fieldTypeName = f.outputType.type.name;
        return `
${f.name}<T extends ${getFieldArgName(f, name)}${ifExtensions(
          "<ExtArgs> = {}",
          "= {}"
        )}>(args?: Subset<T, ${getFieldArgName(f, name)}${ifExtensions("<ExtArgs>", "")}>): ${getReturnType({
          name: fieldTypeName,
          actionName: f.outputType.isList ? DMMF.ModelAction.findMany : DMMF.ModelAction.findUnique,
          hideCondition: false,
          isField: true,
          renderPromise: true,
          fieldName: f.name,
          isChaining: true,
          projection: "select" /* select */
        })};`;
      }).join("\n"),
      2
    )}

  private get _document();
  /**
   * Attaches callbacks for the resolution and/or rejection of the Promise.
   * @param onfulfilled The callback to execute when the Promise is resolved.
   * @param onrejected The callback to execute when the Promise is rejected.
   * @returns A Promise for the completion of which ever callback is executed.
   */
  then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): Promise<TResult1 | TResult2>;
  /**
   * Attaches a callback for only the rejection of the Promise.
   * @param onrejected The callback to execute when the Promise is rejected.
   * @returns A Promise for the completion of the callback.
   */
  catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): Promise<T | TResult>;
  /**
   * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
   * resolved value cannot be modified from the callback.
   * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
   * @returns A Promise for the completion of the callback.
   */
  finally(onfinally?: (() => void) | undefined | null): Promise<T>;
}`;
  }
};
__name(ModelDelegate, "ModelDelegate");

// src/generation/TSClient/PrismaClient.ts
var import_indent_string11 = __toESM(require_indent_string());

// src/generation/utils/runtimeImport.ts
function runtimeImport(name) {
  return name;
}
__name(runtimeImport, "runtimeImport");

// src/generation/TSClient/Datasources.ts
var import_indent_string10 = __toESM(require_indent_string());
var Datasources = class {
  constructor(internalDatasources) {
    this.internalDatasources = internalDatasources;
  }
  toTS() {
    const sources = this.internalDatasources;
    return `export type Datasources = {
${(0, import_indent_string10.default)(sources.map((s) => `${s.name}?: Datasource`).join("\n"), 2)}
}`;
  }
};
__name(Datasources, "Datasources");

// src/generation/TSClient/PrismaClient.ts
function clientExtensionsResultDefinition() {
  const modelNames = Object.keys(this.dmmf.getModelMap());
  const resultGenericParams = /* @__PURE__ */ __name((modelName) => {
    return `R_${modelName}_Needs extends Record<string, runtime.Types.Extensions.GetSelect<Prisma.${modelName}SelectScalar, ExtArgs['result']['${lowerCase(
      modelName
    )}']>>`;
  }, "resultGenericParams");
  const genericParams = [
    ...modelNames.flatMap(resultGenericParams),
    `R extends runtime.Types.Extensions.UserArgs['result'] = {}`
  ].join(",\n    ");
  const resultParam = /* @__PURE__ */ __name((modelName) => {
    return `${lowerCase(modelName)}?: {
        [K in keyof R_${modelName}_Needs]: {
          needs: R_${modelName}_Needs[K]
          compute: (data: runtime.Types.GetResult<${modelName}Payload<ExtArgs>, { select: R_${modelName}_Needs[K] }, 'findUniqueOrThrow'>) => unknown
        }
      }`;
  }, "resultParam");
  const params = `{
      $allModels?: Record<string, {
        compute: (data: unknown) => unknown
      }>
      ${modelNames.map(resultParam).join("\n      ")}
    }`;
  return {
    genericParams,
    params
  };
}
__name(clientExtensionsResultDefinition, "clientExtensionsResultDefinition");
function clientExtensionsModelDefinition() {
  const modelNames = Object.keys(this.dmmf.getModelMap());
  const modelParam = /* @__PURE__ */ __name((modelName) => {
    return `${lowerCase(
      modelName
    )}?: { [K: symbol]: { ctx: runtime.Types.Extensions.GetModel<Prisma.${modelName}Delegate<false, ExtArgs>, ExtArgs['model']['${lowerCase(
      modelName
    )}']> } }`;
  }, "modelParam");
  const params = `{
      $allModels?: {}
      ${modelNames.map(modelParam).join("\n      ")}
    }`;
  return {
    genericParams: `M extends runtime.Types.Extensions.UserArgs['model'] = {}`,
    params
  };
}
__name(clientExtensionsModelDefinition, "clientExtensionsModelDefinition");
function clientTypeMapModelsDefinition() {
  const modelNames = Object.keys(this.dmmf.getModelMap());
  return `{
    meta: {
      modelProps: ${modelNames.map((mn) => `'${lowerCase(mn)}'`).join(" | ")}
    },
    model: {${modelNames.reduce((acc, modelName) => {
    const actions = getModelActions(this.dmmf, modelName);
    return `${acc}
    ${modelName}: {${actions.reduce((acc2, action) => {
      return `${acc2}
      ${action}: {
        args: Prisma.${getModelArgName(modelName, action)}<ExtArgs>,
        result: runtime.Types.Utils.OptionalFlat<${modelName}>
        payload: ${modelName}Payload<ExtArgs>
      }`;
    }, "")}
    }`;
  }, "")}
  }
}`;
}
__name(clientTypeMapModelsDefinition, "clientTypeMapModelsDefinition");
function clientTypeMapOthersDefinition() {
  const otherOperationsNames = this.dmmf.getOtherOperationNames().flatMap((n2) => {
    if (n2 === "executeRaw" || n2 === "queryRaw") {
      return [`$${n2}Unsafe`, `$${n2}`];
    }
    return `$${n2}`;
  });
  const argsResultMap = {
    $executeRaw: { args: "[query: TemplateStringsArray | Prisma.Sql, ...values: any[]]", result: "any" },
    $queryRaw: { args: "[query: TemplateStringsArray | Prisma.Sql, ...values: any[]]", result: "any" },
    $executeRawUnsafe: { args: "[query: string, ...values: any[]]", result: "any" },
    $queryRawUnsafe: { args: "[query: string, ...values: any[]]", result: "any" },
    $runCommandRaw: { args: "Prisma.InputJsonObject", result: "Prisma.JsonObject" }
  };
  return `{
  other: {${otherOperationsNames.reduce((acc, action) => {
    return `${acc}
    ${action}: {
      args: ${argsResultMap[action].args},
      result: ${argsResultMap[action].result}
      payload: any
    }`;
  }, "")}
  }
}`;
}
__name(clientTypeMapOthersDefinition, "clientTypeMapOthersDefinition");
function clientTypeMapDefinition() {
  const typeMap = `${clientTypeMapModelsDefinition.bind(this)()} & ${clientTypeMapOthersDefinition.bind(this)()}`;
  return `export type TypeMap<ExtArgs extends runtime.Types.Extensions.Args = runtime.Types.Extensions.DefaultArgs> = ${typeMap}`;
}
__name(clientTypeMapDefinition, "clientTypeMapDefinition");
function clientExtensionsQueryDefinition() {
  const modelNames = Object.keys(this.dmmf.getModelMap());
  const prismaNamespaceDefinitions = clientTypeMapDefinition.bind(this)();
  const queryCbDefinitionModel = /* @__PURE__ */ __name((modelName, operationName) => {
    const queryArgs = `runtime.Types.Extensions.ReadonlySelector<Prisma.TypeMap<ExtArgs>['model'][${modelName}][${operationName}]['args']>`;
    const queryResult = `Prisma.TypeMap<ExtArgs>['model'][${modelName}][${operationName}]['result']`;
    const inputQueryBase = `model: ${modelName}, operation: ${operationName}, args: ${queryArgs}`;
    const inputQueryCbBase = `query: (args: ${queryArgs}) => Prisma.PrismaPromise<${queryResult}>`;
    const inputQuery = `{ ${inputQueryBase}, ${inputQueryCbBase} }`;
    return `(args: ${inputQuery}) => Promise<${queryResult}>`;
  }, "queryCbDefinitionModel");
  const queryCbDefinitionOther = /* @__PURE__ */ __name((operationName) => {
    const queryArgs = `Prisma.TypeMap<ExtArgs>['other'][${operationName}]['args']`;
    const queryResult = `Prisma.TypeMap<ExtArgs>['other'][${operationName}]['result']`;
    const inputQueryBase = `operation: ${operationName}, args: ${queryArgs}`;
    const inputQueryCbBase = `query: (args: ${queryArgs}) => Prisma.PrismaPromise<${queryResult}>`;
    const inputQuery = `{ ${inputQueryBase}, ${inputQueryCbBase} }`;
    return `(args: ${inputQuery}) => Promise<${queryResult}>`;
  }, "queryCbDefinitionOther");
  const allOperationsParam = /* @__PURE__ */ __name((modelNames2, indent15) => {
    const modelName = modelNames2.map((mn) => `'${mn}'`).join(" | ");
    return `{
    ${indent15}$allOperations?: ${queryCbDefinitionModel(modelName, `keyof Prisma.TypeMap['model'][${modelName}]`)}
  ${indent15}}`;
  }, "allOperationsParam");
  const modelParam = /* @__PURE__ */ __name((propName, modelNames2) => {
    const key = modelNames2.map((mn) => `'${mn}'`).join(" | ");
    return `${propName}?: {
        [K in keyof Prisma.TypeMap['model'][${key}]]?: ${queryCbDefinitionModel(key, `K`)}
      } & ${allOperationsParam(modelNames2, "    ")}`;
  }, "modelParam");
  const allModelsParam = `{
      ${modelParam("$allModels", modelNames)}
    }`;
  const concreteModelParams = `{${modelNames.reduce((acc, modelName) => {
    return `${acc}
      ${modelParam(lowerCase(modelName), [modelName])}`;
  }, "")}
    }`;
  const concreteOtherParams = `{
      [K in keyof Prisma.TypeMap['other']]?: ${queryCbDefinitionOther(`K`)}
    }`;
  return {
    genericParams: `Q extends runtime.Types.Extensions.UserArgs['query'] = {}`,
    params: `${allModelsParam} & ${concreteModelParams} & ${concreteOtherParams}`,
    prismaNamespaceDefinitions
  };
}
__name(clientExtensionsQueryDefinition, "clientExtensionsQueryDefinition");
function clientExtensionsClientDefinition() {
  return {
    genericParams: `C extends runtime.Types.Extensions.UserArgs['client'] = {}`,
    params: `{ [K: symbol]: { ctx: runtime.Types.Extensions.GetClient<PrismaClient<never, never, false, ExtArgs>, ExtArgs['client']> } }`
  };
}
__name(clientExtensionsClientDefinition, "clientExtensionsClientDefinition");
function clientExtensionsHookDefinition(name) {
  const result = clientExtensionsResultDefinition.call(this);
  const model = clientExtensionsModelDefinition.call(this);
  const client = clientExtensionsClientDefinition.call(this);
  const query = clientExtensionsQueryDefinition.call(this);
  const genericParams = [result.genericParams, model.genericParams, query.genericParams, client.genericParams];
  const genericVars = genericParams.map((gp) => gp.replace(/ extends .*/g, ","));
  return {
    signature: `${name === "defineExtension" ? name : `${name}: { extArgs: ExtArgs } & (`}<
    ${genericParams.join(",\n    ")},
    Args extends runtime.Types.Extensions.Args = runtime.Types.Extensions.InternalArgs<R, M, Q, C>, ${name === "defineExtension" ? `
    ExtArgs extends runtime.Types.Extensions.Args = runtime.Types.Extensions.DefaultArgs,` : ""}
  >(extension: ((client: ${name === "defineExtension" ? "Prisma.DefaultPrismaClient" : "this"}) => { $extends: { extArgs: Args } }) | Prisma.ExtensionArgs<
    ExtArgs,
    ${genericVars.join("\n    ").slice(0, -1)}
  >) ${name === "defineExtension" ? ":" : "=>"} ${name === "defineExtension" ? "(client: any) => PrismaClient<any, any, any, Args>" : `runtime.Types.Extensions.GetClient<PrismaClient<T, U, GlobalReject, {
    result: ExtArgs['result'] & Record<string, Args['result']['$allModels'] & {}> & Args['result']
    model: ExtArgs['model'] & Record<string, Args['model']['$allModels'] & {}> & Args['model']
    client: ExtArgs['client'] & Args['client'],
    query: {}
  }>, ExtArgs['client'] & Args['client']>`}${name === "defineExtension" ? "" : ")"};`,
    prismaNamespaceDefinitions: `${query.prismaNamespaceDefinitions}
export type ExtensionArgs<
    ExtArgs extends runtime.Types.Extensions.Args,
    ${genericParams.join(",\n    ")}
> = {
  name?: string,
  result?: R & ${result.params}
  model?: M & ${model.params}
  query?: ${query.params}
  client?: C & ${client.params}
}`
  };
}
__name(clientExtensionsHookDefinition, "clientExtensionsHookDefinition");
function clientExtensionsDefinitions() {
  const define2 = clientExtensionsHookDefinition.bind(this)("defineExtension");
  const extend = clientExtensionsHookDefinition.bind(this)("$extends");
  return {
    prismaNamespaceDefinitions: ifExtensions(
      `
export function ${define2.signature}
${extend.prismaNamespaceDefinitions}`,
      ""
    ),
    prismaClientDefinitions: ifExtensions(
      `  ${extend.signature}
`,
      ""
    )
  };
}
__name(clientExtensionsDefinitions, "clientExtensionsDefinitions");
function batchingTransactionDefinition() {
  const method2 = method("$transaction").setDocComment(
    docComment`
        Allows the running of a sequence of read/write operations that are guaranteed to either succeed or fail as a whole.
        @example
        \`\`\`
        const [george, bob, alice] = await prisma.$transaction([
          prisma.user.create({ data: { name: 'George' } }),
          prisma.user.create({ data: { name: 'Bob' } }),
          prisma.user.create({ data: { name: 'Alice' } }),
        ])
        \`\`\`

        Read more in our [docs](https://www.prisma.io/docs/concepts/components/prisma-client/transactions).
      `
  ).addGenericParameter(genericParameter("P").extends(array(prismaPromise(anyType)))).addParameter(parameter("arg", arraySpread(namedType("P")))).setReturnType(promise(namedType("UnwrapTuple").addGenericArgument(namedType("P"))));
  if (this.dmmf.hasEnumInNamespace("TransactionIsolationLevel", "prisma")) {
    const options2 = objectType().formatInline().add(property("isolationLevel", namedType("Prisma.TransactionIsolationLevel")).optional());
    method2.addParameter(parameter("options", options2).optional());
  }
  return stringify(method2, { indentLevel: 1, newLine: "leading" });
}
__name(batchingTransactionDefinition, "batchingTransactionDefinition");
function interactiveTransactionDefinition() {
  const options2 = objectType().formatInline().add(property("maxWait", numberType).optional()).add(property("timeout", numberType).optional());
  if (this.dmmf.hasEnumInNamespace("TransactionIsolationLevel", "prisma")) {
    const isolationLevel = property("isolationLevel", namedType("Prisma.TransactionIsolationLevel")).optional();
    options2.add(isolationLevel);
  }
  const returnType = promise(namedType("R"));
  const callbackType = functionType().addParameter(
    parameter(
      "prisma",
      namedType("Omit").addGenericArgument(namedType("this")).addGenericArgument(
        unionType(stringLiteral("$connect")).addVariant(stringLiteral("$disconnect")).addVariant(stringLiteral("$on")).addVariant(stringLiteral("$transaction")).addVariant(stringLiteral("$use"))
      )
    )
  ).setReturnType(returnType);
  const method2 = method("$transaction").addGenericParameter(genericParameter("R")).addParameter(parameter("fn", callbackType)).addParameter(parameter("options", options2).optional()).setReturnType(returnType);
  return stringify(method2, { indentLevel: 1, newLine: "leading" });
}
__name(interactiveTransactionDefinition, "interactiveTransactionDefinition");
function queryRawDefinition() {
  if (!this.dmmf.mappings.otherOperations.write.includes("queryRaw")) {
    return "";
  }
  return `
  /**
   * Performs a prepared raw query and returns the \`SELECT\` data.
   * @example
   * \`\`\`
   * const result = await prisma.$queryRaw\`SELECT * FROM User WHERE id = \${1} OR email = \${'user@email.com'};\`
   * \`\`\`
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<T>;

  /**
   * Performs a raw query and returns the \`SELECT\` data.
   * Susceptible to SQL injections, see documentation.
   * @example
   * \`\`\`
   * const result = await prisma.$queryRawUnsafe('SELECT * FROM User WHERE id = $1 OR email = $2;', 1, 'user@email.com')
   * \`\`\`
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<T>;`;
}
__name(queryRawDefinition, "queryRawDefinition");
function executeRawDefinition() {
  if (!this.dmmf.mappings.otherOperations.write.includes("executeRaw")) {
    return "";
  }
  return `
  /**
   * Executes a prepared raw query and returns the number of affected rows.
   * @example
   * \`\`\`
   * const result = await prisma.$executeRaw\`UPDATE User SET cool = \${true} WHERE email = \${'user@email.com'};\`
   * \`\`\`
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<number>;

  /**
   * Executes a raw query and returns the number of affected rows.
   * Susceptible to SQL injections, see documentation.
   * @example
   * \`\`\`
   * const result = await prisma.$executeRawUnsafe('UPDATE User SET cool = $1 WHERE email = $2 ;', true, 'user@email.com')
   * \`\`\`
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<number>;`;
}
__name(executeRawDefinition, "executeRawDefinition");
function metricDefinition() {
  if (!this.generator?.previewFeatures.includes("metrics")) {
    return "";
  }
  const property2 = property("$metrics", namedType(`runtime.${runtimeImport("MetricsClient")}`)).setDocComment(
    docComment`
        Gives access to the client metrics in json or prometheus format.
        
        @example
        \`\`\`
        const metrics = await prisma.$metrics.json()
        // or
        const metrics = await prisma.$metrics.prometheus()
        \`\`\`
    `
  ).readonly();
  return stringify(property2, { indentLevel: 1, newLine: "leading" });
}
__name(metricDefinition, "metricDefinition");
function runCommandRawDefinition() {
  if (!this.dmmf.mappings.otherOperations.write.includes("runCommandRaw")) {
    return "";
  }
  const method2 = method("$runCommandRaw").addParameter(parameter("command", namedType("Prisma.InputJsonObject"))).setReturnType(prismaPromise(namedType("Prisma.JsonObject"))).setDocComment(docComment`
      Executes a raw MongoDB command and returns the result of it.
      @example
      \`\`\`
      const user = await prisma.$runCommandRaw({
        aggregate: 'User',
        pipeline: [{ $match: { name: 'Bob' } }, { $project: { email: true, _id: false } }],
        explain: false,
      })
      \`\`\`
   
      Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
    `);
  return stringify(method2, { indentLevel: 1, newLine: "leading" });
}
__name(runCommandRawDefinition, "runCommandRawDefinition");
var PrismaClientClass = class {
  constructor(dmmf2, internalDatasources, outputDir2, browser, generator2, sqliteDatasourceOverrides, cwd) {
    this.dmmf = dmmf2;
    this.internalDatasources = internalDatasources;
    this.outputDir = outputDir2;
    this.browser = browser;
    this.generator = generator2;
    this.sqliteDatasourceOverrides = sqliteDatasourceOverrides;
    this.cwd = cwd;
    this.clientExtensionsDefinitions = clientExtensionsDefinitions.bind(this)();
  }
  get jsDoc() {
    const { dmmf: dmmf2 } = this;
    const example = dmmf2.mappings.modelOperations[0];
    return `/**
 * ##  Prisma Client \u02B2\u02E2
 * 
 * Type-safe database client for TypeScript & Node.js
 * @example
 * \`\`\`
 * const prisma = new PrismaClient()
 * // Fetch zero or more ${capitalize(example.plural)}
 * const ${lowerCase(example.plural)} = await prisma.${lowerCase(example.model)}.findMany()
 * \`\`\`
 *
 * 
 * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
 */`;
  }
  toTSWithoutNamespace() {
    const { dmmf: dmmf2 } = this;
    return `${this.jsDoc}
export class PrismaClient<
  T extends Prisma.PrismaClientOptions = Prisma.PrismaClientOptions,
  U = 'log' extends keyof T ? T['log'] extends Array<Prisma.LogLevel | Prisma.LogDefinition> ? Prisma.GetEvents<T['log']> : never : never,
  GlobalReject extends Prisma.RejectOnNotFound | Prisma.RejectPerOperation | false | undefined = 'rejectOnNotFound' extends keyof T
    ? T['rejectOnNotFound']
    : false${ifExtensions(
      `,
  ExtArgs extends runtime.Types.Extensions.Args = runtime.Types.Extensions.DefaultArgs`,
      ""
    )}
      > {${ifExtensions(
      `

  [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['other'] }
`,
      ""
    )}
  ${(0, import_indent_string11.default)(this.jsDoc, TAB_SIZE)}

  constructor(optionsArg ?: Prisma.Subset<T, Prisma.PrismaClientOptions>);
  $on<V extends (U | 'beforeExit')>(eventType: V, callback: (event: V extends 'query' ? Prisma.QueryEvent : V extends 'beforeExit' ? () => Promise<void> : Prisma.LogEvent) => void): void;

  /**
   * Connect with the database
   */
  $connect(): Promise<void>;

  /**
   * Disconnect from the database
   */
  $disconnect(): Promise<void>;

  /**
   * Add a middleware
   */
  $use(cb: Prisma.Middleware): void

${[
      executeRawDefinition.bind(this)(),
      queryRawDefinition.bind(this)(),
      batchingTransactionDefinition.bind(this)(),
      interactiveTransactionDefinition.bind(this)(),
      runCommandRawDefinition.bind(this)(),
      metricDefinition.bind(this)(),
      this.clientExtensionsDefinitions.prismaClientDefinitions
    ].join("\n").trim()}

    ${(0, import_indent_string11.default)(
      dmmf2.mappings.modelOperations.filter((m) => m.findMany).map((m) => {
        const methodName = lowerCase(m.model);
        return `/**
 * \`prisma.${methodName}\`: Exposes CRUD operations for the **${m.model}** model.
  * Example usage:
  * \`\`\`ts
  * // Fetch zero or more ${capitalize(m.plural)}
  * const ${lowerCase(m.plural)} = await prisma.${methodName}.findMany()
  * \`\`\`
  */
get ${methodName}(): ${ifExtensions(
          `runtime.Types.Extensions.GetModel<Prisma.${m.model}Delegate<GlobalReject, ExtArgs>, ExtArgs['model']['${lowerCase(m.model)}']>`,
          `Prisma.${m.model}Delegate<GlobalReject>`
        )};`;
      }).join("\n\n"),
      2
    )}
}`;
  }
  toTS() {
    return `${new Datasources(this.internalDatasources).toTS()}
${this.clientExtensionsDefinitions.prismaNamespaceDefinitions}
export type DefaultPrismaClient = PrismaClient
export type RejectOnNotFound = boolean | ((error: Error) => Error)
export type RejectPerModel = { [P in ModelName]?: RejectOnNotFound }
export type RejectPerOperation =  { [P in "findUnique" | "findFirst"]?: RejectPerModel | RejectOnNotFound } 
type IsReject<T> = T extends true ? True : T extends (err: Error) => Error ? True : False
export type HasReject<
  GlobalRejectSettings extends Prisma.PrismaClientOptions['rejectOnNotFound'],
  LocalRejectSettings,
  Action extends PrismaAction,
  Model extends ModelName
> = LocalRejectSettings extends RejectOnNotFound
  ? IsReject<LocalRejectSettings>
  : GlobalRejectSettings extends RejectPerOperation
  ? Action extends keyof GlobalRejectSettings
    ? GlobalRejectSettings[Action] extends RejectOnNotFound
      ? IsReject<GlobalRejectSettings[Action]>
      : GlobalRejectSettings[Action] extends RejectPerModel
      ? Model extends keyof GlobalRejectSettings[Action]
        ? IsReject<GlobalRejectSettings[Action][Model]>
        : False
      : False
    : False
  : IsReject<GlobalRejectSettings>
export type ErrorFormat = 'pretty' | 'colorless' | 'minimal'

export interface PrismaClientOptions {
  /**
   * Configure findUnique/findFirst to throw an error if the query returns null. 
   * @deprecated since 4.0.0. Use \`findUniqueOrThrow\`/\`findFirstOrThrow\` methods instead.
   * @example
   * \`\`\`
   * // Reject on both findUnique/findFirst
   * rejectOnNotFound: true
   * // Reject only on findFirst with a custom error
   * rejectOnNotFound: { findFirst: (err) => new Error("Custom Error")}
   * // Reject on user.findUnique with a custom error
   * rejectOnNotFound: { findUnique: {User: (err) => new Error("User not found")}}
   * \`\`\`
   */
  rejectOnNotFound?: RejectOnNotFound | RejectPerOperation
  /**
   * Overwrites the datasource url from your schema.prisma file
   */
  datasources?: Datasources

  /**
   * @default "colorless"
   */
  errorFormat?: ErrorFormat

  /**
   * @example
   * \`\`\`
   * // Defaults to stdout
   * log: ['query', 'info', 'warn', 'error']
   * 
   * // Emit as events
   * log: [
   *  { emit: 'stdout', level: 'query' },
   *  { emit: 'stdout', level: 'info' },
   *  { emit: 'stdout', level: 'warn' }
   *  { emit: 'stdout', level: 'error' }
   * ]
   * \`\`\`
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/logging#the-log-option).
   */
  log?: Array<LogLevel | LogDefinition>
}

/* Types for Logging */
export type LogLevel = 'info' | 'query' | 'warn' | 'error'
export type LogDefinition = {
  level: LogLevel
  emit: 'stdout' | 'event'
}

export type GetLogType<T extends LogLevel | LogDefinition> = T extends LogDefinition ? T['emit'] extends 'event' ? T['level'] : never : never
export type GetEvents<T extends any> = T extends Array<LogLevel | LogDefinition> ?
  GetLogType<T[0]> | GetLogType<T[1]> | GetLogType<T[2]> | GetLogType<T[3]>
  : never

export type QueryEvent = {
  timestamp: Date
  query: string
  params: string
  duration: number
  target: string
}

export type LogEvent = {
  timestamp: Date
  message: string
  target: string
}
/* End Types for Logging */


export type PrismaAction =
  | 'findUnique'
  | 'findMany'
  | 'findFirst'
  | 'create'
  | 'createMany'
  | 'update'
  | 'updateMany'
  | 'upsert'
  | 'delete'
  | 'deleteMany'
  | 'executeRaw'
  | 'queryRaw'
  | 'aggregate'
  | 'count'
  | 'runCommandRaw'
  | 'findRaw'

/**
 * These options are being passed into the middleware as "params"
 */
export type MiddlewareParams = {
  model?: ModelName
  action: PrismaAction
  args: any
  dataPath: string[]
  runInTransaction: boolean
}

/**
 * The \`T\` type makes sure, that the \`return proceed\` is not forgotten in the middleware implementation
 */
export type Middleware<T = any> = (
  params: MiddlewareParams,
  next: (params: MiddlewareParams) => Promise<T>,
) => Promise<T>

// tested in getLogLevel.test.ts
export function getLogLevel(log: Array<LogLevel | LogDefinition>): LogLevel | undefined;

/**
 * \`PrismaClient\` proxy available in interactive transactions.
 */
export type TransactionClient = Omit<Prisma.DefaultPrismaClient, '$connect' | '$disconnect' | '$on' | '$transaction' | '$use'>
`;
  }
};
__name(PrismaClientClass, "PrismaClientClass");

// src/generation/TSClient/TSClient.ts
var TSClient = class {
  constructor(options2) {
    this.options = options2;
    this.genericsInfo = new GenericArgsInfo();
    this.dmmf = new DMMFHelper(klona(options2.document));
    TSClient.enabledPreviewFeatures = this.options.generator?.previewFeatures ?? [];
  }
  async toJS(edge = false) {
    const {
      platforms,
      generator: generator2,
      sqliteDatasourceOverrides,
      outputDir: outputDir2,
      schemaPath: schemaPath2,
      runtimeDir,
      runtimeName,
      datasources: datasources2,
      dataProxy: dataProxy2,
      deno
    } = this.options;
    const engineProtocol = getQueryEngineProtocol(generator2);
    const envPaths = getEnvPaths(schemaPath2, { cwd: outputDir2 });
    const relativeEnvPaths = {
      rootEnvPath: envPaths.rootEnvPath && import_path7.default.relative(outputDir2, envPaths.rootEnvPath),
      schemaEnvPath: envPaths.schemaEnvPath && import_path7.default.relative(outputDir2, envPaths.schemaEnvPath)
    };
    const engineType = getClientEngineType(generator2);
    if (generator2) {
      generator2.config.engineType = engineType;
    }
    const config2 = {
      generator: generator2,
      relativeEnvPaths,
      sqliteDatasourceOverrides,
      relativePath: import_path7.default.relative(outputDir2, import_path7.default.dirname(schemaPath2)),
      clientVersion: this.options.clientVersion,
      engineVersion: this.options.engineVersion,
      datasourceNames: datasources2.map((d2) => d2.name),
      activeProvider: this.options.activeProvider,
      dataProxy: this.options.dataProxy
    };
    const relativeOutdir = import_path7.default.relative(process.cwd(), outputDir2);
    const code = `${commonCodeJS({ ...this.options, browser: false })}
${buildRequirePath(edge)}
${buildDirname(edge, relativeOutdir, runtimeDir)}

/**
 * Enums
 */
// Based on
// https://github.com/microsoft/TypeScript/issues/3192#issuecomment-261720275
function makeEnum(x) { return x; }

${this.dmmf.schema.enumTypes.prisma.map((type) => new Enum(type, true).toJS()).join("\n\n")}
${this.dmmf.schema.enumTypes.model?.map((type) => new Enum(type, false).toJS()).join("\n\n") ?? ""}

${new Enum(
      {
        name: "ModelName",
        values: this.dmmf.mappings.modelOperations.map((m) => m.model)
      },
      true
    ).toJS()}
${buildDMMF(dataProxy2 && engineProtocol === "graphql", this.options.document)}

/**
 * Create the Client
 */
const config = ${JSON.stringify(config2, null, 2)}
config.dirname = dirname
config.document = dmmf
${await buildInlineSchema(dataProxy2, schemaPath2)}
${buildInlineDatasource(dataProxy2, datasources2)}
${buildInjectableEdgeEnv(edge, datasources2)}
${buildWarnEnvConflicts(edge, runtimeDir, runtimeName)}
${buildEdgeClientProtocol(edge, generator2)}
${buildDebugInitialization(edge)}
const PrismaClient = getPrismaClient(config)
exports.PrismaClient = PrismaClient
Object.assign(exports, Prisma)${deno ? "\nexport { exports as default, Prisma, PrismaClient }" : ""}
${buildNFTAnnotations(dataProxy2, engineType, platforms, relativeOutdir)}
`;
    return code;
  }
  toTS(edge = false) {
    if (edge === true)
      return `export * from './index'`;
    const prismaClientClass = new PrismaClientClass(
      this.dmmf,
      this.options.datasources,
      this.options.outputDir,
      this.options.browser,
      this.options.generator,
      this.options.sqliteDatasourceOverrides,
      import_path7.default.dirname(this.options.schemaPath)
    );
    const commonCode = commonCodeTS(this.options);
    const modelAndTypes = Object.values(this.dmmf.typeAndModelMap).reduce((acc, modelOrType) => {
      if (this.dmmf.outputTypeMap[modelOrType.name]) {
        acc.push(new Model(modelOrType, this.dmmf, this.genericsInfo, this.options.generator));
      }
      return acc;
    }, []);
    const prismaEnums = this.dmmf.schema.enumTypes.prisma.map((type) => new Enum(type, true).toTS());
    const modelEnums = this.dmmf.schema.enumTypes.model?.map((type) => new Enum(type, false).toTS());
    const fieldRefs = this.dmmf.schema.fieldRefTypes.prisma?.map((type) => new FieldRefInput(type).toTS()) ?? [];
    const countTypes = this.dmmf.schema.outputObjectTypes.prisma.filter((t3) => t3.name.endsWith("CountOutputType")).map((t3) => new Count(t3, this.dmmf, this.genericsInfo, this.options.generator));
    const code = `
/**
 * Client
**/

${commonCode.tsWithoutNamespace()}

${modelAndTypes.map((m) => m.toTSWithoutNamespace()).join("\n")}
${modelEnums && modelEnums.length > 0 ? `
/**
 * Enums
 */

// Based on
// https://github.com/microsoft/TypeScript/issues/3192#issuecomment-261720275

${modelEnums.join("\n\n")}
` : ""}
${prismaClientClass.toTSWithoutNamespace()}

export namespace Prisma {
${(0, import_indent_string12.default)(
      `${commonCode.ts()}
${new Enum(
        {
          name: "ModelName",
          values: this.dmmf.mappings.modelOperations.map((m) => m.model)
        },
        true
      ).toTS()}

${prismaClientClass.toTS()}
export type Datasource = {
  url?: string
}

/**
 * Count Types
 */

${countTypes.map((t3) => t3.toTS()).join("\n")}

/**
 * Models
 */
${modelAndTypes.map((model) => model.toTS()).join("\n")}

/**
 * Enums
 */

// Based on
// https://github.com/microsoft/TypeScript/issues/3192#issuecomment-261720275

${prismaEnums.join("\n\n")}
${fieldRefs.length > 0 ? `
/**
 * Field references 
 */

${fieldRefs.join("\n\n")}` : ""}
/**
 * Deep Input Types
 */

${this.dmmf.inputObjectTypes.prisma.reduce((acc, inputType) => {
        if (inputType.name.includes("Json") && inputType.name.includes("Filter")) {
          const needsGeneric = this.genericsInfo.inputTypeNeedsGenericModelArg(inputType);
          const innerName = needsGeneric ? `${inputType.name}Base<$PrismaModel>` : `${inputType.name}Base`;
          const typeName = needsGeneric ? `${inputType.name}<$PrismaModel = never>` : inputType.name;
          const baseName = `Required<${innerName}>`;
          acc.push(`export type ${typeName} = 
  | PatchUndefined<
      Either<${baseName}, Exclude<keyof ${baseName}, 'path'>>,
      ${baseName}
    >
  | OptionalFlat<Omit<${baseName}, 'path'>>`);
          acc.push(new InputType({ ...inputType, name: `${inputType.name}Base` }, this.genericsInfo).toTS());
        } else {
          acc.push(new InputType(inputType, this.genericsInfo).toTS());
        }
        return acc;
      }, []).join("\n")}

${this.dmmf.inputObjectTypes.model?.map((inputType) => new InputType(inputType, this.genericsInfo).toTS()).join("\n") ?? ""}

/**
 * Batch Payload for updateMany & deleteMany & createMany
 */

export type BatchPayload = {
  count: number
}

/**
 * DMMF
 */
export const dmmf: runtime.BaseDMMF
`,
      2
    )}}`;
    return code;
  }
  toBrowserJS() {
    const code = `${commonCodeJS({
      ...this.options,
      runtimeName: "index-browser",
      browser: true
    })}
/**
 * Enums
 */
// Based on
// https://github.com/microsoft/TypeScript/issues/3192#issuecomment-261720275
function makeEnum(x) { return x; }

${this.dmmf.schema.enumTypes.prisma.map((type) => new Enum(type, true).toJS()).join("\n\n")}
${this.dmmf.schema.enumTypes.model?.map((type) => new Enum(type, false).toJS()).join("\n\n") ?? ""}

${new Enum(
      {
        name: "ModelName",
        values: this.dmmf.mappings.modelOperations.map((m) => m.model)
      },
      true
    ).toJS()}

/**
 * Create the Client
 */
class PrismaClient {
  constructor() {
    throw new Error(
      \`PrismaClient is unable to be run in the browser.
In case this error is unexpected for you, please report it in https://github.com/prisma/prisma/issues\`,
    )
  }
}
exports.PrismaClient = PrismaClient

Object.assign(exports, Prisma)
`;
    return code;
  }
};
__name(TSClient, "TSClient");

// src/generation/TSClient/utils/ifExtensions.ts
function ifExtensions(_case, _default) {
  if (TSClient.enabledPreviewFeatures.includes("clientExtensions")) {
    return typeof _case === "function" ? _case() : _case;
  }
  return typeof _default === "function" ? _default() : _default;
}
__name(ifExtensions, "ifExtensions");

// src/generation/utils.ts
function getPayloadName(modelName) {
  return ifExtensions(`runtime.Types.GetResult`, `${modelName}GetPayload`);
}
__name(getPayloadName, "getPayloadName");
function getSelectName(modelName) {
  return `${modelName}Select`;
}
__name(getSelectName, "getSelectName");
function getAggregateName(modelName) {
  return `Aggregate${capitalize2(modelName)}`;
}
__name(getAggregateName, "getAggregateName");
function getGroupByName(modelName) {
  return `${capitalize2(modelName)}GroupByOutputType`;
}
__name(getGroupByName, "getGroupByName");
function getAvgAggregateName(modelName) {
  return `${capitalize2(modelName)}AvgAggregateOutputType`;
}
__name(getAvgAggregateName, "getAvgAggregateName");
function getSumAggregateName(modelName) {
  return `${capitalize2(modelName)}SumAggregateOutputType`;
}
__name(getSumAggregateName, "getSumAggregateName");
function getMinAggregateName(modelName) {
  return `${capitalize2(modelName)}MinAggregateOutputType`;
}
__name(getMinAggregateName, "getMinAggregateName");
function getMaxAggregateName(modelName) {
  return `${capitalize2(modelName)}MaxAggregateOutputType`;
}
__name(getMaxAggregateName, "getMaxAggregateName");
function getCountAggregateInputName(modelName) {
  return `${capitalize2(modelName)}CountAggregateInputType`;
}
__name(getCountAggregateInputName, "getCountAggregateInputName");
function getCountAggregateOutputName(modelName) {
  return `${capitalize2(modelName)}CountAggregateOutputType`;
}
__name(getCountAggregateOutputName, "getCountAggregateOutputName");
function getAggregateInputType(aggregateOutputType) {
  return aggregateOutputType.replace(/OutputType$/, "InputType");
}
__name(getAggregateInputType, "getAggregateInputType");
function getGroupByArgsName(modelName) {
  return `${capitalize2(modelName)}GroupByArgs`;
}
__name(getGroupByArgsName, "getGroupByArgsName");
function getGroupByPayloadName(modelName) {
  return `Get${capitalize2(modelName)}GroupByPayload`;
}
__name(getGroupByPayloadName, "getGroupByPayloadName");
function getAggregateArgsName(modelName) {
  return `${capitalize2(modelName)}AggregateArgs`;
}
__name(getAggregateArgsName, "getAggregateArgsName");
function getAggregateGetName(modelName) {
  return `Get${capitalize2(modelName)}AggregateType`;
}
__name(getAggregateGetName, "getAggregateGetName");
function getIncludeName(modelName) {
  return `${modelName}Include`;
}
__name(getIncludeName, "getIncludeName");
function getFieldArgName(field, modelName) {
  if (field.args.length) {
    return getModelFieldArgsName(field, modelName);
  }
  return getArgName(field.outputType.type.name);
}
__name(getFieldArgName, "getFieldArgName");
function getModelFieldArgsName(field, modelName) {
  return `${modelName}$${field.name}Args`;
}
__name(getModelFieldArgsName, "getModelFieldArgsName");
function getArgName(name) {
  return `${name}Args`;
}
__name(getArgName, "getArgName");
function getModelArgName(modelName, action) {
  if (!action) {
    return `${modelName}Args`;
  }
  switch (action) {
    case DMMF.ModelAction.findMany:
      return `${modelName}FindManyArgs`;
    case DMMF.ModelAction.findUnique:
      return `${modelName}FindUniqueArgs`;
    case DMMF.ModelAction.findUniqueOrThrow:
      return `${modelName}FindUniqueOrThrowArgs`;
    case DMMF.ModelAction.findFirst:
      return `${modelName}FindFirstArgs`;
    case DMMF.ModelAction.findFirstOrThrow:
      return `${modelName}FindFirstOrThrowArgs`;
    case DMMF.ModelAction.upsert:
      return `${modelName}UpsertArgs`;
    case DMMF.ModelAction.update:
      return `${modelName}UpdateArgs`;
    case DMMF.ModelAction.updateMany:
      return `${modelName}UpdateManyArgs`;
    case DMMF.ModelAction.delete:
      return `${modelName}DeleteArgs`;
    case DMMF.ModelAction.create:
      return `${modelName}CreateArgs`;
    case DMMF.ModelAction.createMany:
      return `${modelName}CreateManyArgs`;
    case DMMF.ModelAction.deleteMany:
      return `${modelName}DeleteManyArgs`;
    case DMMF.ModelAction.groupBy:
      return `${modelName}GroupByArgs`;
    case DMMF.ModelAction.aggregate:
      return getAggregateArgsName(modelName);
    case DMMF.ModelAction.count:
      return `${modelName}CountArgs`;
    case DMMF.ModelAction.findRaw:
      return `${modelName}FindRawArgs`;
    case DMMF.ModelAction.aggregateRaw:
      return `${modelName}AggregateRawArgs`;
    default:
      assertNever(action, "Unknown action");
  }
}
__name(getModelArgName, "getModelArgName");
function getFieldRefsTypeName(name) {
  return `${name}FieldRefs`;
}
__name(getFieldRefsTypeName, "getFieldRefsTypeName");
function getType(name, isList, isOptional) {
  return name + (isList ? "[]" : "") + (isOptional ? " | null" : "");
}
__name(getType, "getType");
function getReturnType({
  name,
  actionName,
  renderPromise = true,
  hideCondition = false,
  isField = false,
  isChaining = false
}) {
  if (actionName === "count") {
    return `Promise<number>`;
  }
  if (actionName === "aggregate")
    return `Promise<${getAggregateGetName(name)}<T>>`;
  if (actionName === "findRaw" || actionName === "aggregateRaw") {
    return `Prisma.PrismaPromise<JsonObject>`;
  }
  const isList = actionName === DMMF.ModelAction.findMany;
  if (actionName === "deleteMany" || actionName === "updateMany" || actionName === "createMany") {
    return `Prisma.PrismaPromise<BatchPayload>`;
  }
  if (isList || hideCondition) {
    const listOpen = isList ? "Array<" : "";
    const listClose = isList ? ">" : "";
    const promiseOpen = renderPromise ? "Prisma.PrismaPromise<" : "";
    const promiseClose = renderPromise ? ">" : "";
    return `${promiseOpen}${ifExtensions("", listOpen)}${getPayloadName(name)}<${ifExtensions(
      `${name}Payload<ExtArgs>, T, '${actionName}'`,
      "T"
    )}>${ifExtensions("", listClose)}${isChaining ? "| Null" : ""}${promiseClose}`;
  }
  if (actionName === "findFirstOrThrow" || actionName === "findUniqueOrThrow") {
    return `Prisma__${name}Client<${getType(
      getPayloadName(name) + `<${ifExtensions(`${name}Payload<ExtArgs>, T, '${actionName}'`, "T")}>`,
      isList
    )}${ifExtensions(", never, ExtArgs", "")}>`;
  }
  if (actionName === "findFirst" || actionName === "findUnique") {
    if (isField) {
      return `Prisma__${name}Client<${getType(
        getPayloadName(name) + `<${ifExtensions(`${name}Payload<ExtArgs>, T, '${actionName}'`, "T")}>`,
        isList
      )} | Null${ifExtensions(", never, ExtArgs", "")}>`;
    }
    return `HasReject<GlobalRejectSettings, LocalRejectSettings, '${actionName}', '${name}'> extends True ? Prisma__${name}Client<${getType(
      getPayloadName(name) + `<${ifExtensions(`${name}Payload<ExtArgs>, T, '${actionName}'`, "T")}>`,
      isList
    )}${ifExtensions(", never, ExtArgs", "")}> : Prisma__${name}Client<${getType(
      getPayloadName(name) + `<${ifExtensions(`${name}Payload<ExtArgs>, T, '${actionName}'`, "T")}>`,
      isList
    )} | null, null${ifExtensions(", ExtArgs", "")}>`;
  }
  return `Prisma__${name}Client<${getType(
    getPayloadName(name) + `<${ifExtensions(`${name}Payload<ExtArgs>, T, '${actionName}'`, "T")}>`,
    isList
  )}${ifExtensions(", never, ExtArgs", "")}>`;
}
__name(getReturnType, "getReturnType");
function capitalize2(str) {
  return str[0].toUpperCase() + str.slice(1);
}
__name(capitalize2, "capitalize");
function getRefAllowedTypeName(type) {
  let typeName;
  if (typeof type.type === "string") {
    typeName = type.type;
  } else {
    typeName = type.type.name;
  }
  if (type.isList) {
    typeName += "[]";
  }
  return `'${typeName}'`;
}
__name(getRefAllowedTypeName, "getRefAllowedTypeName");

// src/generation/TSClient/Args.ts
var ArgsType = class {
  constructor(args, type, genericsInfo, action) {
    this.args = args;
    this.type = type;
    this.genericsInfo = genericsInfo;
    this.action = action;
    this.generatedName = null;
    this.comment = null;
  }
  setGeneratedName(name) {
    this.generatedName = name;
    return this;
  }
  setComment(comment) {
    this.comment = comment;
    return this;
  }
  toTS() {
    const { action, args } = this;
    const { name } = this.type;
    for (const arg of args) {
      arg.comment = getArgFieldJSDoc(this.type, action, arg);
    }
    const selectName = getSelectName(name);
    const argsToGenerate = [
      {
        name: "select",
        isRequired: false,
        isNullable: true,
        inputTypes: [
          {
            type: selectName,
            location: "inputObjectTypes",
            isList: false
          },
          {
            type: "null",
            location: "scalar",
            isList: false
          }
        ],
        comment: `Select specific fields to fetch from the ${name}`
      }
    ];
    const hasRelationField = this.type.fields.some((f) => f.outputType.location === "outputObjectTypes");
    if (hasRelationField) {
      const includeName = getIncludeName(name);
      argsToGenerate.push({
        name: "include",
        isRequired: false,
        isNullable: true,
        inputTypes: [
          {
            type: includeName,
            location: "inputObjectTypes",
            isList: false
          },
          {
            type: "null",
            location: "scalar",
            isList: false
          }
        ],
        comment: `Choose, which related nodes to fetch as well.`
      });
    }
    argsToGenerate.push(...args);
    const generatedName = this.generatedName ?? getModelArgName(name, action);
    if (action === DMMF.ModelAction.findUnique || action === DMMF.ModelAction.findFirst) {
      return this.generateFindMethodArgs(action, name, argsToGenerate, generatedName);
    }
    return `
/**
 * ${this.getGeneratedComment()}
 */
export type ${generatedName}${ifExtensions(
      "<ExtArgs extends runtime.Types.Extensions.Args = runtime.Types.Extensions.DefaultArgs>",
      ""
    )} = {
${(0, import_indent_string14.default)(argsToGenerate.map((arg) => new InputField(arg, false, this.genericsInfo).toTS()).join("\n"), TAB_SIZE)}
}
`;
  }
  generateFindMethodArgs(action, name, argsToGenerate, modelArgName) {
    const baseTypeName = getBaseTypeName(name, action);
    const replacement = action === DMMF.ModelAction.findFirst ? DMMF.ModelAction.findFirstOrThrow : DMMF.ModelAction.findUniqueOrThrow;
    return `
/**
 * ${name} base type for ${action} actions
 */
export type ${baseTypeName}${ifExtensions(
      "<ExtArgs extends runtime.Types.Extensions.Args = runtime.Types.Extensions.DefaultArgs>",
      ""
    )} = {
${(0, import_indent_string14.default)(argsToGenerate.map((arg) => new InputField(arg, false, this.genericsInfo).toTS()).join("\n"), TAB_SIZE)}
}

/**
 * ${this.getGeneratedComment()}
 */
export interface ${modelArgName}${ifExtensions(
      "<ExtArgs extends runtime.Types.Extensions.Args = runtime.Types.Extensions.DefaultArgs>",
      ""
    )} extends ${baseTypeName}${ifExtensions("<ExtArgs>", "")} {
 /**
  * Throw an Error if query returns no results
  * @deprecated since 4.0.0: use \`${replacement}\` method instead
  */
  rejectOnNotFound?: RejectOnNotFound
}
      `;
  }
  getGeneratedComment() {
    return this.comment ?? `${this.type.name} ${this.action ?? "without action"}`;
  }
};
__name(ArgsType, "ArgsType");
var MinimalArgsType = class {
  constructor(args, type, genericsInfo, action, generatedTypeName = getModelArgName(type.name, action)) {
    this.args = args;
    this.type = type;
    this.genericsInfo = genericsInfo;
    this.action = action;
    this.generatedTypeName = generatedTypeName;
  }
  toTS() {
    const { action, args } = this;
    const { name } = this.type;
    for (const arg of args) {
      arg.comment = getArgFieldJSDoc(this.type, action, arg);
    }
    return `
/**
 * ${name} ${action ? action : "without action"}
 */
export type ${this.generatedTypeName}${ifExtensions(
      "<ExtArgs extends runtime.Types.Extensions.Args = runtime.Types.Extensions.DefaultArgs>",
      ""
    )} = {
${(0, import_indent_string14.default)(
      args.map((arg) => {
        const noEnumerable = arg.inputTypes.some((input) => input.type === "Json") && arg.name === "pipeline";
        return new InputField(arg, noEnumerable, this.genericsInfo).toTS();
      }).join("\n"),
      TAB_SIZE
    )}
}
`;
  }
};
__name(MinimalArgsType, "MinimalArgsType");
function getBaseTypeName(modelName, action) {
  switch (action) {
    case DMMF.ModelAction.findFirst:
      return `${modelName}FindFirstArgsBase`;
    case DMMF.ModelAction.findUnique:
      return `${modelName}FindUniqueArgsBase`;
  }
}
__name(getBaseTypeName, "getBaseTypeName");

// src/generation/generateClient.ts
var remove = (0, import_util6.promisify)(import_fs10.default.unlink);
var writeFile2 = (0, import_util6.promisify)(import_fs10.default.writeFile);
var exists3 = (0, import_util6.promisify)(import_fs10.default.exists);
var copyFile = (0, import_util6.promisify)(import_fs10.default.copyFile);
var stat = (0, import_util6.promisify)(import_fs10.default.stat);
var GENERATED_PACKAGE_NAME = ".prisma/client";
var DenylistError = class extends Error {
  constructor(message) {
    super(message);
    this.name = "DenylistError";
    this.stack = void 0;
  }
};
__name(DenylistError, "DenylistError");
async function buildClient({
  schemaPath: schemaPath2,
  runtimeDirs: runtimeDirs2,
  binaryPaths: binaryPaths2,
  outputDir: outputDir2,
  generator: generator2,
  dmmf: dmmf2,
  datasources: datasources2,
  engineVersion: engineVersion2,
  clientVersion: clientVersion3,
  projectRoot: projectRoot2,
  activeProvider: activeProvider2,
  dataProxy: dataProxy2
}) {
  const document2 = getPrismaClientDMMF(dmmf2);
  const clientEngineType2 = getClientEngineType(generator2);
  const tsClientOptions = {
    document: document2,
    datasources: datasources2,
    generator: generator2,
    platforms: clientEngineType2 === "library" /* Library */ ? Object.keys(binaryPaths2.libqueryEngine ?? {}) : Object.keys(binaryPaths2.queryEngine ?? {}),
    schemaPath: schemaPath2,
    outputDir: outputDir2,
    clientVersion: clientVersion3,
    engineVersion: engineVersion2,
    projectRoot: projectRoot2,
    activeProvider: activeProvider2,
    dataProxy: dataProxy2
  };
  const nodeTsClient = new TSClient({
    ...tsClientOptions,
    runtimeName: getNodeRuntimeName(clientEngineType2, dataProxy2),
    runtimeDir: runtimeDirs2.node
  });
  const edgeTsClient = new TSClient({
    ...tsClientOptions,
    dataProxy: true,
    runtimeName: "edge",
    runtimeDir: runtimeDirs2.edge
  });
  const fileMap2 = {};
  fileMap2["index.js"] = await JS(nodeTsClient, false);
  fileMap2["index.d.ts"] = await TS(nodeTsClient);
  fileMap2["index-browser.js"] = await BrowserJS(nodeTsClient);
  fileMap2["package.json"] = JSON.stringify(
    {
      name: GENERATED_PACKAGE_NAME,
      main: "index.js",
      types: "index.d.ts",
      browser: "index-browser.js"
    },
    null,
    2
  );
  if (dataProxy2 === true) {
    fileMap2["edge.js"] = await JS(edgeTsClient, true);
    fileMap2["edge.d.ts"] = await TS(edgeTsClient, true);
  }
  if (generator2?.previewFeatures.includes("deno") && !!globalThis.Deno) {
    if (dataProxy2 === true) {
      const denoEdgeTsClient = new TSClient({
        ...tsClientOptions,
        dataProxy: true,
        runtimeName: "index.d.ts",
        runtimeDir: "../" + runtimeDirs2.edge,
        deno: true
      });
      fileMap2["deno/edge.js"] = await JS(denoEdgeTsClient, true);
      fileMap2["deno/index.d.ts"] = await TS(denoEdgeTsClient);
      fileMap2["deno/edge.ts"] = `
import './polyfill.js'
// @deno-types="./index.d.ts"
export * from './edge.js'`;
      fileMap2["deno/polyfill.js"] = "globalThis.process = { env: Deno.env.toObject() }; globalThis.global = globalThis";
    }
  }
  return {
    fileMap: fileMap2,
    prismaClientDmmf: document2
  };
}
__name(buildClient, "buildClient");
async function getDefaultOutdir(outputDir2) {
  if (outputDir2.endsWith("node_modules/@prisma/client")) {
    return import_path8.default.join(outputDir2, "../../.prisma/client");
  }
  if (process.env.INIT_CWD && process.env.npm_lifecycle_event === "postinstall" && !process.env.PWD?.includes(".pnpm")) {
    if (import_fs10.default.existsSync(import_path8.default.join(process.env.INIT_CWD, "package.json"))) {
      return import_path8.default.join(process.env.INIT_CWD, "node_modules/.prisma/client");
    }
    const packagePath = await (0, import_pkg_up.default)({ cwd: process.env.INIT_CWD });
    if (packagePath) {
      return import_path8.default.join(import_path8.default.dirname(packagePath), "node_modules/.prisma/client");
    }
  }
  return import_path8.default.join(outputDir2, "../../.prisma/client");
}
__name(getDefaultOutdir, "getDefaultOutdir");
async function generateClient(options) {
  const {
    datamodel,
    schemaPath,
    outputDir,
    transpile,
    generator,
    dmmf,
    datasources,
    binaryPaths,
    testMode,
    copyRuntime,
    copyRuntimeSourceMaps = false,
    clientVersion,
    engineVersion,
    activeProvider,
    dataProxy
  } = options;
  const clientEngineType = getClientEngineType(generator);
  const { runtimeDirs, finalOutputDir, projectRoot } = await getGenerationDirs(options);
  const { prismaClientDmmf, fileMap } = await buildClient({
    datamodel,
    schemaPath,
    transpile,
    runtimeDirs,
    outputDir: finalOutputDir,
    generator,
    dmmf,
    datasources,
    binaryPaths,
    clientVersion,
    engineVersion,
    projectRoot,
    activeProvider,
    dataProxy
  });
  const denylistsErrors = validateDmmfAgainstDenylists(prismaClientDmmf);
  if (denylistsErrors) {
    let message = `${import_chalk8.default.redBright.bold(
      "Error: "
    )}The schema at "${schemaPath}" contains reserved keywords.
       Rename the following items:`;
    for (const error of denylistsErrors) {
      message += "\n         - " + error.message;
    }
    message += `
To learn more about how to rename models, check out https://pris.ly/d/naming-models`;
    throw new DenylistError(message);
  }
  await (0, import_fs_extra2.ensureDir)(finalOutputDir);
  await (0, import_fs_extra2.ensureDir)(import_path8.default.join(outputDir, "runtime"));
  if (generator?.previewFeatures.includes("deno") && !!globalThis.Deno) {
    await (0, import_fs_extra2.ensureDir)(import_path8.default.join(outputDir, "deno"));
  }
  await Promise.all(
    Object.entries(fileMap).map(async ([fileName, file2]) => {
      const filePath = import_path8.default.join(finalOutputDir, fileName);
      if (await exists3(filePath)) {
        await remove(filePath);
      }
      await writeFile2(filePath, file2);
    })
  );
  const runtimeSourceDir = testMode ? eval(`require('path').join(__dirname, '../../runtime')`) : eval(`require('path').join(__dirname, '../runtime')`);
  if (copyRuntime || !import_path8.default.resolve(outputDir).endsWith(`@prisma${import_path8.default.sep}client`)) {
    const copyTarget = import_path8.default.join(outputDir, "runtime");
    await (0, import_fs_extra2.ensureDir)(copyTarget);
    if (runtimeSourceDir !== copyTarget) {
      await copyRuntimeFiles({
        from: runtimeSourceDir,
        to: copyTarget,
        sourceMaps: copyRuntimeSourceMaps,
        runtimeName: getNodeRuntimeName(clientEngineType, dataProxy)
      });
    }
  }
  const enginePath = clientEngineType === "library" /* Library */ ? binaryPaths.libqueryEngine : binaryPaths.queryEngine;
  if (!enginePath) {
    throw new Error(
      `Prisma Client needs \`${clientEngineType === "library" /* Library */ ? "libqueryEngine" : "queryEngine"}\` in the \`binaryPaths\` object.`
    );
  }
  if (transpile === true && dataProxy !== true) {
    if (process.env.NETLIFY) {
      await (0, import_fs_extra2.ensureDir)("/tmp/prisma-engines");
    }
    for (const [binaryTarget, filePath] of Object.entries(enginePath)) {
      const fileName = import_path8.default.basename(filePath);
      const target = process.env.NETLIFY && binaryTarget !== "rhel-openssl-1.0.x" ? import_path8.default.join("/tmp/prisma-engines", fileName) : import_path8.default.join(finalOutputDir, fileName);
      const [sourceFileSize, targetFileSize] = await Promise.all([fileSize(filePath), fileSize(target)]);
      if (!targetFileSize) {
        if (import_fs10.default.existsSync(filePath)) {
          await overwriteFile(filePath, target);
          continue;
        } else {
          throw new Error(`File at ${filePath} is required but was not present`);
        }
      }
      if (targetFileSize && sourceFileSize && targetFileSize !== sourceFileSize) {
        await overwriteFile(filePath, target);
        continue;
      }
      const binaryName = clientEngineType === "binary" /* Binary */ ? "query-engine" /* queryEngine */ : "libquery-engine" /* libqueryEngine */;
      const [sourceVersion, targetVersion] = await Promise.all([
        getEngineVersion(filePath, binaryName).catch(() => null),
        getEngineVersion(target, binaryName).catch(() => null)
      ]);
      if (sourceVersion && targetVersion && sourceVersion === targetVersion) {
      } else {
        await overwriteFile(filePath, target);
      }
    }
  }
  const schemaTargetPath = import_path8.default.join(finalOutputDir, "schema.prisma");
  if (schemaPath !== schemaTargetPath) {
    await copyFile(schemaPath, schemaTargetPath);
  }
  const proxyIndexJsPath = import_path8.default.join(outputDir, "index.js");
  const proxyIndexBrowserJsPath = import_path8.default.join(outputDir, "index-browser.js");
  const proxyIndexDTSPath = import_path8.default.join(outputDir, "index.d.ts");
  if (!import_fs10.default.existsSync(proxyIndexJsPath)) {
    await copyFile(import_path8.default.join(__dirname, "../../index.js"), proxyIndexJsPath);
  }
  if (!import_fs10.default.existsSync(proxyIndexDTSPath)) {
    await copyFile(import_path8.default.join(__dirname, "../../index.d.ts"), proxyIndexDTSPath);
  }
  if (!import_fs10.default.existsSync(proxyIndexBrowserJsPath)) {
    await copyFile(import_path8.default.join(__dirname, "../../index-browser.js"), proxyIndexBrowserJsPath);
  }
}
__name(generateClient, "generateClient");
async function fileSize(name) {
  try {
    const statResult = await stat(name);
    return statResult.size;
  } catch (e2) {
    return null;
  }
}
__name(fileSize, "fileSize");
function validateDmmfAgainstDenylists(prismaClientDmmf2) {
  const errorArray = [];
  const denylists = {
    models: [
      "PrismaClient",
      "Prisma",
      "break",
      "case",
      "catch",
      "class",
      "const",
      "continue",
      "debugger",
      "default",
      "delete",
      "do",
      "else",
      "enum",
      "export",
      "extends",
      "false",
      "finally",
      "for",
      "function",
      "if",
      "implements",
      "import",
      "in",
      "instanceof",
      "interface",
      "let",
      "new",
      "null",
      "package",
      "private",
      "protected",
      "public",
      "return",
      "super",
      "switch",
      "this",
      "throw",
      "true",
      "try",
      "typeof",
      "var",
      "void",
      "while",
      "with",
      "yield"
    ],
    fields: ["AND", "OR", "NOT"],
    dynamic: []
  };
  if (prismaClientDmmf2.datamodel.enums) {
    for (const it of prismaClientDmmf2.datamodel.enums) {
      if (denylists.models.includes(it.name) || denylists.fields.includes(it.name)) {
        errorArray.push(Error(`"enum ${it.name}"`));
      }
    }
  }
  if (prismaClientDmmf2.datamodel.models) {
    for (const it of prismaClientDmmf2.datamodel.models) {
      if (denylists.models.includes(it.name) || denylists.fields.includes(it.name)) {
        errorArray.push(Error(`"model ${it.name}"`));
      }
    }
  }
  return errorArray.length > 0 ? errorArray : null;
}
__name(validateDmmfAgainstDenylists, "validateDmmfAgainstDenylists");
async function getGenerationDirs({
  testMode: testMode2,
  runtimeDirs: runtimeDirs2,
  generator: generator2,
  outputDir: outputDir2,
  datamodel: datamodel2,
  schemaPath: schemaPath2
}) {
  const useDefaultOutdir = testMode2 ? !runtimeDirs2 : !generator2?.isCustomOutput;
  const _runtimeDirs = {
    node: runtimeDirs2?.node || (useDefaultOutdir ? "@prisma/client/runtime" : "./runtime"),
    edge: runtimeDirs2?.edge || (useDefaultOutdir ? "@prisma/client/runtime" : "./runtime")
  };
  const finalOutputDir2 = useDefaultOutdir ? await getDefaultOutdir(outputDir2) : outputDir2;
  if (!useDefaultOutdir) {
    await verifyOutputDirectory(finalOutputDir2, datamodel2, schemaPath2);
  }
  const packageRoot = await (0, import_pkg_up.default)({ cwd: import_path8.default.dirname(finalOutputDir2) });
  const projectRoot2 = packageRoot ? import_path8.default.dirname(packageRoot) : process.cwd();
  return {
    runtimeDirs: _runtimeDirs,
    finalOutputDir: finalOutputDir2,
    projectRoot: projectRoot2
  };
}
__name(getGenerationDirs, "getGenerationDirs");
async function verifyOutputDirectory(directory, datamodel2, schemaPath2) {
  let content;
  try {
    content = await import_fs10.default.promises.readFile(import_path8.default.join(directory, "package.json"), "utf8");
  } catch (e2) {
    if (e2.code === "ENOENT") {
      return;
    }
    throw e2;
  }
  const { name } = JSON.parse(content);
  if (name === import_package.name) {
    const message = [`Generating client into ${import_chalk8.default.bold(directory)} is not allowed.`];
    message.push("This package is used by `prisma generate` and overwriting its content is dangerous.");
    message.push("");
    message.push("Suggestion:");
    const outputDeclaration = findOutputPathDeclaration(datamodel2);
    if (outputDeclaration && outputDeclaration.content.includes(import_package.name)) {
      const outputLine = outputDeclaration.content;
      message.push(`In ${import_chalk8.default.bold(schemaPath2)} replace:`);
      message.push("");
      message.push(
        `${import_chalk8.default.dim(outputDeclaration.lineNumber)} ${replacePackageName(outputLine, import_chalk8.default.red(import_package.name))}`
      );
      message.push("with");
      message.push(
        `${import_chalk8.default.dim(outputDeclaration.lineNumber)} ${replacePackageName(outputLine, import_chalk8.default.green(".prisma/client"))}`
      );
    } else {
      message.push(
        `Generate client into ${import_chalk8.default.bold(replacePackageName(directory, import_chalk8.default.green(".prisma/client")))} instead`
      );
    }
    message.push("");
    message.push("You won't need to change your imports.");
    message.push("Imports from `@prisma/client` will be automatically forwarded to `.prisma/client`");
    const error = new Error(message.join("\n"));
    throw error;
  }
}
__name(verifyOutputDirectory, "verifyOutputDirectory");
function replacePackageName(directoryPath, replacement) {
  return directoryPath.replace(import_package.name, replacement);
}
__name(replacePackageName, "replacePackageName");
function findOutputPathDeclaration(datamodel2) {
  const lines = datamodel2.split(/\r?\n/);
  for (const [i, line] of lines.entries()) {
    if (/output\s*=/.test(line)) {
      return { lineNumber: i + 1, content: line.trim() };
    }
  }
  return null;
}
__name(findOutputPathDeclaration, "findOutputPathDeclaration");
function getNodeRuntimeName(engineType, dataProxy2) {
  if (dataProxy2) {
    return "data-proxy";
  }
  if (engineType === "binary" /* Binary */) {
    return "binary";
  }
  if (engineType === "library" /* Library */) {
    return "library";
  }
  assertNever(engineType, "Unknown engine type");
}
__name(getNodeRuntimeName, "getNodeRuntimeName");
async function copyRuntimeFiles({ from, to, runtimeName, sourceMaps }) {
  const files = ["index.d.ts", "index-browser.js", "index-browser.d.ts"];
  files.push(`${runtimeName}.js`, `${runtimeName}.d.ts`);
  if (runtimeName === "data-proxy") {
    files.push("edge.js", "edge-esm.js");
  }
  if (sourceMaps) {
    files.push(...files.filter((file2) => file2.endsWith(".js")).map((file2) => `${file2}.map`));
  }
  await Promise.all(files.map((file2) => copyFile(import_path8.default.join(from, file2), import_path8.default.join(to, file2))));
}
__name(copyRuntimeFiles, "copyRuntimeFiles");

// src/generation/utils/types/dmmfToTypes.ts
function dmmfToTypes(document2) {
  return new TSClient({
    document: document2,
    datasources: [],
    projectRoot: "",
    clientVersion: "",
    engineVersion: "",
    runtimeDir: "",
    runtimeName: "",
    schemaPath: "",
    outputDir: "",
    activeProvider: "",
    dataProxy: false
  }).toTS();
}
__name(dmmfToTypes, "dmmfToTypes");

// src/generation/generator.ts
var debug8 = src_default("prisma:client:generator");
var pkg = require_package3();
var clientVersion2 = pkg.version;
if (process.argv[1] === __filename) {
  generatorHandler({
    onManifest(config2) {
      const requiredEngine = getClientEngineType(config2) === "library" /* Library */ ? "libqueryEngine" : "queryEngine";
      debug8(`requiredEngine: ${requiredEngine}`);
      return {
        defaultOutput: ".prisma/client",
        prettyName: "Prisma Client",
        requiresEngines: [requiredEngine],
        version: clientVersion2,
        requiresEngineVersion: import_engines_version3.enginesVersion
      };
    },
    async onGenerate(options2) {
      const outputDir2 = typeof options2.generator.output === "string" ? options2.generator.output : parseEnvValue(options2.generator.output);
      return generateClient({
        datamodel: options2.datamodel,
        schemaPath: options2.schemaPath,
        binaryPaths: options2.binaryPaths,
        datasources: options2.datasources,
        outputDir: outputDir2,
        copyRuntime: Boolean(options2.generator.config.copyRuntime),
        copyRuntimeSourceMaps: Boolean(process.env.PRISMA_COPY_RUNTIME_SOURCEMAPS),
        dmmf: options2.dmmf,
        generator: options2.generator,
        engineVersion: options2.version,
        clientVersion: clientVersion2,
        transpile: true,
        activeProvider: options2.datasources[0]?.activeProvider,
        dataProxy: options2.dataProxy
      });
    }
  });
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  dmmfToTypes,
  externalToInternalDmmf
});
/*!
 *  decimal.js v10.4.3
 *  An arbitrary-precision Decimal type for JavaScript.
 *  https://github.com/MikeMcl/decimal.js
 *  Copyright (c) 2022 Michael Mclaughlin <M8ch88l@gmail.com>
 *  MIT Licence
 */
