"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("lodash");
const helpers_1 = require("./helpers");
const defaultHeaderMetadata = {
    name: '',
    required: true
};
exports.ApiImplicitHeader = (metadata) => {
    const param = {
        name: lodash_1.isNil(metadata.name) ? defaultHeaderMetadata.name : metadata.name,
        in: 'header',
        description: metadata.description,
        required: metadata.required,
        type: String
    };
    return helpers_1.createParamDecorator(param, defaultHeaderMetadata);
};
exports.ApiImplicitHeaders = (headers) => {
    const multiMetadata = headers.map(metadata => ({
        name: lodash_1.isNil(metadata.name) ? defaultHeaderMetadata.name : metadata.name,
        in: 'header',
        description: metadata.description,
        required: metadata.required,
        type: String
    }));
    return helpers_1.createMultipleParamDecorator(multiMetadata, defaultHeaderMetadata);
};
