import { GraphQLSchemaConfig } from 'graphql';
import { GraphQLAstExplorer } from './graphql-ast.explorer';
import { GraphQLSchemaBuilder } from './graphql-schema.builder';
import { GraphQLSchemaHost } from './graphql-schema.host';
import { GqlModuleOptions } from './interfaces';
import { ResolversExplorerService, ScalarsExplorerService } from './services';
export declare class GraphQLFactory {
    private readonly resolversExplorerService;
    private readonly scalarsExplorerService;
    private readonly graphqlAstExplorer;
    private readonly gqlSchemaBuilder;
    private readonly gqlSchemaHost;
    constructor(resolversExplorerService: ResolversExplorerService, scalarsExplorerService: ScalarsExplorerService, graphqlAstExplorer: GraphQLAstExplorer, gqlSchemaBuilder: GraphQLSchemaBuilder, gqlSchemaHost: GraphQLSchemaHost);
    mergeWithSchema<T extends GqlModuleOptions>(options?: T): Promise<T>;
    overrideOrExtendResolvers(executableSchemaConfig: GraphQLSchemaConfig, autoGeneratedSchemaConfig: GraphQLSchemaConfig): GraphQLSchemaConfig;
    generateDefinitions(typeDefs: string | string[], options: GqlModuleOptions): Promise<void>;
}
//# sourceMappingURL=graphql.factory.d.ts.map