import { GraphQLSchema } from 'graphql';
import { GraphQLSchemaBuilder } from '../graphql-schema.builder';
import { GraphQLSchemaHost } from '../graphql-schema.host';
import { AutoSchemaFileValue, BuildFederatedSchemaOptions, GqlModuleOptions } from '../interfaces';
import { ResolversExplorerService, ScalarsExplorerService } from '../services';
import { TypeDefsDecoratorFactory } from './type-defs-decorator.factory';
export declare class GraphQLFederationFactory {
    private readonly resolversExplorerService;
    private readonly scalarsExplorerService;
    private readonly gqlSchemaBuilder;
    private readonly gqlSchemaHost;
    private readonly typeDefsDecoratorFactory;
    constructor(resolversExplorerService: ResolversExplorerService, scalarsExplorerService: ScalarsExplorerService, gqlSchemaBuilder: GraphQLSchemaBuilder, gqlSchemaHost: GraphQLSchemaHost, typeDefsDecoratorFactory: TypeDefsDecoratorFactory);
    mergeWithSchema<T extends GqlModuleOptions>(options?: T, buildFederatedSchema?: (options: BuildFederatedSchemaOptions) => GraphQLSchema): Promise<T>;
    private buildSchemaFromTypeDefs;
    private generateSchema;
    private getResolvers;
    private extendResolvers;
    private overrideOrExtendResolvers;
    /**
     * Ensures that the resolveType method for unions and interfaces in the federated schema
     * is properly set from the one in the autoGeneratedSchema.
     */
    private overrideFederatedResolveType;
    buildFederatedSchema<T extends GqlModuleOptions>(autoSchemaFile: AutoSchemaFileValue, options: T, resolvers: Function[]): Promise<GraphQLSchema>;
    private getFederationVersionAndConfig;
    private loadFederationDirectives;
}
//# sourceMappingURL=graphql-federation.factory.d.ts.map