import { IntrospectionResult, Type } from '@nestjs/common';
import { GetOrResolveOptions } from '@nestjs/common/interfaces';
import { AbstractInstanceResolver } from './abstract-instance-resolver';
import { NestContainer } from './container';
import { Injector } from './injector';
import { InstanceLinksHost } from './instance-links-host';
import { ContextId } from './instance-wrapper';
import { Module } from './module';
export declare abstract class ModuleRef extends AbstractInstanceResolver {
    protected readonly container: NestContainer;
    protected readonly injector: Injector;
    private _instanceLinksHost;
    protected get instanceLinksHost(): InstanceLinksHost;
    constructor(container: NestContainer);
    /**
     * Retrieves an instance of either injectable or controller, otherwise, throws exception.
     * @returns {TResult}
     */
    abstract get<TInput = any, TResult = TInput>(typeOrToken: Type<TInput> | Function | string | symbol): TResult;
    /**
     * Retrieves an instance of either injectable or controller, otherwise, throws exception.
     * @returns {TResult}
     */
    abstract get<TInput = any, TResult = TInput>(typeOrToken: Type<TInput> | Function | string | symbol, options: {
        strict?: boolean;
        each?: undefined | false;
    }): TResult;
    /**
     * Retrieves a list of instances of either injectables or controllers, otherwise, throws exception.
     * @returns {Array<TResult>}
     */
    abstract get<TInput = any, TResult = TInput>(typeOrToken: Type<TInput> | Function | string | symbol, options: {
        strict?: boolean;
        each: true;
    }): Array<TResult>;
    /**
     * Retrieves an instance (or a list of instances) of either injectable or controller, otherwise, throws exception.
     * @returns {TResult | Array<TResult>}
     */
    abstract get<TInput = any, TResult = TInput>(typeOrToken: Type<TInput> | Function | string | symbol, options?: GetOrResolveOptions): TResult | Array<TResult>;
    /**
     * Resolves transient or request-scoped instance of either injectable or controller, otherwise, throws exception.
     * @returns {Array<TResult>}
     */
    abstract resolve<TInput = any, TResult = TInput>(typeOrToken: Type<TInput> | Function | string | symbol): Promise<TResult>;
    /**
     * Resolves transient or request-scoped instance of either injectable or controller, otherwise, throws exception.
     * @returns {Array<TResult>}
     */
    abstract resolve<TInput = any, TResult = TInput>(typeOrToken: Type<TInput> | Function | string | symbol, contextId?: {
        id: number;
    }): Promise<TResult>;
    /**
     * Resolves transient or request-scoped instance of either injectable or controller, otherwise, throws exception.
     * @returns {Array<TResult>}
     */
    abstract resolve<TInput = any, TResult = TInput>(typeOrToken: Type<TInput> | Function | string | symbol, contextId?: {
        id: number;
    }, options?: {
        strict?: boolean;
        each?: undefined | false;
    }): Promise<TResult>;
    /**
     * Resolves transient or request-scoped instances of either injectables or controllers, otherwise, throws exception.
     * @returns {Array<TResult>}
     */
    abstract resolve<TInput = any, TResult = TInput>(typeOrToken: Type<TInput> | Function | string | symbol, contextId?: {
        id: number;
    }, options?: {
        strict?: boolean;
        each: true;
    }): Promise<Array<TResult>>;
    /**
     * Resolves transient or request-scoped instance (or a list of instances) of either injectable or controller, otherwise, throws exception.
     * @returns {Promise<TResult | Array<TResult>>}
     */
    abstract resolve<TInput = any, TResult = TInput>(typeOrToken: Type<TInput> | Function | string | symbol, contextId?: {
        id: number;
    }, options?: GetOrResolveOptions): Promise<TResult | Array<TResult>>;
    abstract create<T = any>(type: Type<T>): Promise<T>;
    introspect<T = any>(token: Type<T> | string | symbol): IntrospectionResult;
    registerRequestByContextId<T = any>(request: T, contextId: ContextId): void;
    protected instantiateClass<T = any>(type: Type<T>, moduleRef: Module): Promise<T>;
}
