"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NestCollection = void 0;
const abstract_collection_1 = require("./abstract.collection");
class NestCollection extends abstract_collection_1.AbstractCollection {
    constructor(runner) {
        super('@nestjs/schematics', runner);
    }
    execute(name, options) {
        const _super = Object.create(null, {
            execute: { get: () => super.execute }
        });
        return __awaiter(this, void 0, void 0, function* () {
            const schematic = this.validate(name);
            yield _super.execute.call(this, schematic, options);
        });
    }
    static getSchematics() {
        return NestCollection.schematics.filter((item) => item.name !== 'angular-app');
    }
    validate(name) {
        const schematic = NestCollection.schematics.find((s) => s.name === name || s.alias === name);
        if (schematic === undefined || schematic === null) {
            throw new Error(`Invalid schematic "${name}". Please, ensure that "${name}" exists in this collection.`);
        }
        return schematic.name;
    }
}
exports.NestCollection = NestCollection;
NestCollection.schematics = [
    {
        name: 'application',
        alias: 'application',
        description: 'Generate a new application workspace',
    },
    {
        name: 'angular-app',
        alias: 'ng-app',
        description: '',
    },
    {
        name: 'class',
        alias: 'cl',
        description: 'Generate a new class',
    },
    {
        name: 'configuration',
        alias: 'config',
        description: 'Generate a CLI configuration file',
    },
    {
        name: 'controller',
        alias: 'co',
        description: 'Generate a controller declaration',
    },
    {
        name: 'decorator',
        alias: 'd',
        description: 'Generate a custom decorator',
    },
    {
        name: 'filter',
        alias: 'f',
        description: 'Generate a filter declaration',
    },
    {
        name: 'gateway',
        alias: 'ga',
        description: 'Generate a gateway declaration',
    },
    {
        name: 'guard',
        alias: 'gu',
        description: 'Generate a guard declaration',
    },
    {
        name: 'interceptor',
        alias: 'itc',
        description: 'Generate an interceptor declaration',
    },
    {
        name: 'interface',
        alias: 'itf',
        description: 'Generate an interface',
    },
    {
        name: 'middleware',
        alias: 'mi',
        description: 'Generate a middleware declaration',
    },
    {
        name: 'module',
        alias: 'mo',
        description: 'Generate a module declaration',
    },
    {
        name: 'pipe',
        alias: 'pi',
        description: 'Generate a pipe declaration',
    },
    {
        name: 'provider',
        alias: 'pr',
        description: 'Generate a provider declaration',
    },
    {
        name: 'resolver',
        alias: 'r',
        description: 'Generate a GraphQL resolver declaration',
    },
    {
        name: 'service',
        alias: 's',
        description: 'Generate a service declaration',
    },
    {
        name: 'library',
        alias: 'lib',
        description: 'Generate a new library within a monorepo',
    },
    {
        name: 'sub-app',
        alias: 'app',
        description: 'Generate a new application within a monorepo',
    },
    {
        name: 'resource',
        alias: 'res',
        description: 'Generate a new CRUD resource',
    },
];
