"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EjsAdapter = void 0;
const ejs_1 = require("ejs");
const lodash_1 = require("lodash");
const fs = require("fs");
const path = require("path");
const inlineCss = require("inline-css");
class EjsAdapter {
    constructor(config) {
        this.precompiledTemplates = {};
        this.config = {
            inlineCssOptions: { url: ' ' },
            inlineCssEnabled: true,
        };
        Object.assign(this.config, config);
    }
    compile(mail, callback, mailerOptions) {
        const { context, template } = mail.data;
        const templateExt = path.extname(template) || '.ejs';
        const templateName = path.basename(template, path.extname(template));
        const templateDir = path.isAbsolute(template)
            ? path.dirname(template)
            : path.join((0, lodash_1.get)(mailerOptions, 'template.dir', ''), path.dirname(template));
        const templatePath = path.join(templateDir, templateName + templateExt);
        if (!this.precompiledTemplates[templateName]) {
            try {
                const template = fs.readFileSync(templatePath, 'utf-8');
                this.precompiledTemplates[templateName] = (0, ejs_1.compile)(template, Object.assign(Object.assign({}, (0, lodash_1.get)(mailerOptions, 'template.options', {})), { filename: templatePath }));
            }
            catch (err) {
                return callback(err);
            }
        }
        const rendered = this.precompiledTemplates[templateName](context);
        const render = (html) => {
            if (this.config.inlineCssEnabled) {
                inlineCss(html, this.config.inlineCssOptions)
                    .then((html) => {
                    mail.data.html = html;
                    return callback();
                })
                    .catch(callback);
            }
            else {
                mail.data.html = html;
                return callback();
            }
        };
        if (typeof rendered === 'string') {
            render(rendered);
        }
        else {
            rendered.then(render);
        }
    }
}
exports.EjsAdapter = EjsAdapter;
