
/**
 * Client
**/

import * as runtime from '@prisma/client/runtime/library';
type UnwrapPromise<P extends any> = P extends Promise<infer R> ? R : P
type UnwrapTuple<Tuple extends readonly unknown[]> = {
  [K in keyof Tuple]: K extends `${number}` ? Tuple[K] extends Prisma.PrismaPromise<infer X> ? X : UnwrapPromise<Tuple[K]> : UnwrapPromise<Tuple[K]>
};


/**
 * Model User
 * 
 */
export type User = {
  id: string
  email: string
  password: string
  phone: string | null
  status: UserStatus
  role_id: string
  createdAt: Date
  updatedAt: Date
}

/**
 * Model UserDetail
 * 
 */
export type UserDetail = {
  id: string
  user_id: string
  first_name: string | null
  last_name: string | null
  personal_code: number | null
  featured_image: string | null
  delay_time: string | null
  delay_ratio: number | null
  manager_id: string | null
  vacation_remained: number
  createdAt: Date
  updatedAt: Date
}

/**
 * Model ResetPassowrd
 * 
 */
export type ResetPassowrd = {
  email: string
  token: string
  createdAt: Date
}

/**
 * Model Role
 * 
 */
export type Role = {
  id: string
  name: string
  description: string | null
}

/**
 * Model Permission
 * 
 */
export type Permission = {
  id: string
  key: string
  persian_name: string
  english_name: string
  category: string
}

/**
 * Model PermissionsOnRole
 * 
 */
export type PermissionsOnRole = {
  id: string
  role_id: string
  permission_id: string
  assignedAt: Date
  assignedBy: string
}

/**
 * Model File
 * 
 */
export type File = {
  id: string
  path: string
  type: FileType
  author: string
  size: number
  alt: string | null
  mimetype: string
  createdAt: Date
  updatedAt: Date
}

/**
 * Model Inout
 * 
 */
export type Inout = {
  id: string
  user_id: string
  time: Date
  type: InoutType
  delete: boolean
  description: string | null
  createdAt: Date
  updatedAt: Date
  approved: boolean
}

/**
 * Model Inout_logs
 * 
 */
export type Inout_logs = {
  id: string
  inout_id: string
  action: Log_Action
  old_time: Date | null
  new_time: Date | null
  description: string | null
  createdAt: Date
  updatedAt: Date
}

/**
 * Model Holiday
 * 
 */
export type Holiday = {
  date: Date
}

/**
 * Model Notification
 * 
 */
export type Notification = {
  id: string
  title: string
  content: string
  file_id: string | null
  author_id: string
  createdAt: Date
}

/**
 * Model Notification_Receiver
 * 
 */
export type Notification_Receiver = {
  id: string
  notification_id: string
  user_id: string
  isRead: boolean
}

/**
 * Model Vacation
 * 
 */
export type Vacation = {
  id: string
  user_id: string
  from: Date
  to: Date
  type: Vacation_Type
  status: Vacation_Status
  description: string | null
  createdAt: Date
  updatedAt: Date
}


/**
 * Enums
 */

// Based on
// https://github.com/microsoft/TypeScript/issues/3192#issuecomment-261720275

export const FileType: {
  image: 'image',
  video: 'video',
  document: 'document'
};

export type FileType = (typeof FileType)[keyof typeof FileType]


export const InoutType: {
  service: 'service',
  custom: 'custom'
};

export type InoutType = (typeof InoutType)[keyof typeof InoutType]


export const Log_Action: {
  add: 'add',
  edit: 'edit',
  delete: 'delete'
};

export type Log_Action = (typeof Log_Action)[keyof typeof Log_Action]


export const UserStatus: {
  active: 'active',
  pending: 'pending',
  inactive: 'inactive'
};

export type UserStatus = (typeof UserStatus)[keyof typeof UserStatus]


export const Vacation_Status: {
  accepted: 'accepted',
  denied: 'denied',
  pending: 'pending'
};

export type Vacation_Status = (typeof Vacation_Status)[keyof typeof Vacation_Status]


export const Vacation_Type: {
  hourly: 'hourly',
  daily: 'daily'
};

export type Vacation_Type = (typeof Vacation_Type)[keyof typeof Vacation_Type]


/**
 * ##  Prisma Client ʲˢ
 * 
 * Type-safe database client for TypeScript & Node.js
 * @example
 * ```
 * const prisma = new PrismaClient()
 * // Fetch zero or more Users
 * const users = await prisma.user.findMany()
 * ```
 *
 * 
 * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
 */
export class PrismaClient<
  T extends Prisma.PrismaClientOptions = Prisma.PrismaClientOptions,
  U = 'log' extends keyof T ? T['log'] extends Array<Prisma.LogLevel | Prisma.LogDefinition> ? Prisma.GetEvents<T['log']> : never : never,
  GlobalReject extends Prisma.RejectOnNotFound | Prisma.RejectPerOperation | false | undefined = 'rejectOnNotFound' extends keyof T
    ? T['rejectOnNotFound']
    : false
      > {
    /**
   * ##  Prisma Client ʲˢ
   * 
   * Type-safe database client for TypeScript & Node.js
   * @example
   * ```
   * const prisma = new PrismaClient()
   * // Fetch zero or more Users
   * const users = await prisma.user.findMany()
   * ```
   *
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
   */

  constructor(optionsArg ?: Prisma.Subset<T, Prisma.PrismaClientOptions>);
  $on<V extends (U | 'beforeExit')>(eventType: V, callback: (event: V extends 'query' ? Prisma.QueryEvent : V extends 'beforeExit' ? () => Promise<void> : Prisma.LogEvent) => void): void;

  /**
   * Connect with the database
   */
  $connect(): Promise<void>;

  /**
   * Disconnect from the database
   */
  $disconnect(): Promise<void>;

  /**
   * Add a middleware
   */
  $use(cb: Prisma.Middleware): void

/**
   * Executes a prepared raw query and returns the number of affected rows.
   * @example
   * ```
   * const result = await prisma.$executeRaw`UPDATE User SET cool = ${true} WHERE email = ${'user@email.com'};`
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<number>;

  /**
   * Executes a raw query and returns the number of affected rows.
   * Susceptible to SQL injections, see documentation.
   * @example
   * ```
   * const result = await prisma.$executeRawUnsafe('UPDATE User SET cool = $1 WHERE email = $2 ;', true, 'user@email.com')
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<number>;

  /**
   * Performs a prepared raw query and returns the `SELECT` data.
   * @example
   * ```
   * const result = await prisma.$queryRaw`SELECT * FROM User WHERE id = ${1} OR email = ${'user@email.com'};`
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<T>;

  /**
   * Performs a raw query and returns the `SELECT` data.
   * Susceptible to SQL injections, see documentation.
   * @example
   * ```
   * const result = await prisma.$queryRawUnsafe('SELECT * FROM User WHERE id = $1 OR email = $2;', 1, 'user@email.com')
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<T>;

  /**
   * Allows the running of a sequence of read/write operations that are guaranteed to either succeed or fail as a whole.
   * @example
   * ```
   * const [george, bob, alice] = await prisma.$transaction([
   *   prisma.user.create({ data: { name: 'George' } }),
   *   prisma.user.create({ data: { name: 'Bob' } }),
   *   prisma.user.create({ data: { name: 'Alice' } }),
   * ])
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/concepts/components/prisma-client/transactions).
   */
  $transaction<P extends Prisma.PrismaPromise<any>[]>(arg: [...P], options?: { isolationLevel?: Prisma.TransactionIsolationLevel }): Promise<UnwrapTuple<P>>

  $transaction<R>(fn: (prisma: Omit<this, "$connect" | "$disconnect" | "$on" | "$transaction" | "$use">) => Promise<R>, options?: { maxWait?: number, timeout?: number, isolationLevel?: Prisma.TransactionIsolationLevel }): Promise<R>

      /**
   * `prisma.user`: Exposes CRUD operations for the **User** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Users
    * const users = await prisma.user.findMany()
    * ```
    */
  get user(): Prisma.UserDelegate<GlobalReject>;

  /**
   * `prisma.userDetail`: Exposes CRUD operations for the **UserDetail** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more UserDetails
    * const userDetails = await prisma.userDetail.findMany()
    * ```
    */
  get userDetail(): Prisma.UserDetailDelegate<GlobalReject>;

  /**
   * `prisma.resetPassowrd`: Exposes CRUD operations for the **ResetPassowrd** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ResetPassowrds
    * const resetPassowrds = await prisma.resetPassowrd.findMany()
    * ```
    */
  get resetPassowrd(): Prisma.ResetPassowrdDelegate<GlobalReject>;

  /**
   * `prisma.role`: Exposes CRUD operations for the **Role** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Roles
    * const roles = await prisma.role.findMany()
    * ```
    */
  get role(): Prisma.RoleDelegate<GlobalReject>;

  /**
   * `prisma.permission`: Exposes CRUD operations for the **Permission** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Permissions
    * const permissions = await prisma.permission.findMany()
    * ```
    */
  get permission(): Prisma.PermissionDelegate<GlobalReject>;

  /**
   * `prisma.permissionsOnRole`: Exposes CRUD operations for the **PermissionsOnRole** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more PermissionsOnRoles
    * const permissionsOnRoles = await prisma.permissionsOnRole.findMany()
    * ```
    */
  get permissionsOnRole(): Prisma.PermissionsOnRoleDelegate<GlobalReject>;

  /**
   * `prisma.file`: Exposes CRUD operations for the **File** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Files
    * const files = await prisma.file.findMany()
    * ```
    */
  get file(): Prisma.FileDelegate<GlobalReject>;

  /**
   * `prisma.inout`: Exposes CRUD operations for the **Inout** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Inouts
    * const inouts = await prisma.inout.findMany()
    * ```
    */
  get inout(): Prisma.InoutDelegate<GlobalReject>;

  /**
   * `prisma.inout_logs`: Exposes CRUD operations for the **Inout_logs** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Inout_logs
    * const inout_logs = await prisma.inout_logs.findMany()
    * ```
    */
  get inout_logs(): Prisma.Inout_logsDelegate<GlobalReject>;

  /**
   * `prisma.holiday`: Exposes CRUD operations for the **Holiday** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Holidays
    * const holidays = await prisma.holiday.findMany()
    * ```
    */
  get holiday(): Prisma.HolidayDelegate<GlobalReject>;

  /**
   * `prisma.notification`: Exposes CRUD operations for the **Notification** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Notifications
    * const notifications = await prisma.notification.findMany()
    * ```
    */
  get notification(): Prisma.NotificationDelegate<GlobalReject>;

  /**
   * `prisma.notification_Receiver`: Exposes CRUD operations for the **Notification_Receiver** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Notification_Receivers
    * const notification_Receivers = await prisma.notification_Receiver.findMany()
    * ```
    */
  get notification_Receiver(): Prisma.Notification_ReceiverDelegate<GlobalReject>;

  /**
   * `prisma.vacation`: Exposes CRUD operations for the **Vacation** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Vacations
    * const vacations = await prisma.vacation.findMany()
    * ```
    */
  get vacation(): Prisma.VacationDelegate<GlobalReject>;
}

export namespace Prisma {
  export import DMMF = runtime.DMMF

  export type PrismaPromise<T> = runtime.Types.Public.PrismaPromise<T>

  /**
   * Prisma Errors
   */
  export import PrismaClientKnownRequestError = runtime.PrismaClientKnownRequestError
  export import PrismaClientUnknownRequestError = runtime.PrismaClientUnknownRequestError
  export import PrismaClientRustPanicError = runtime.PrismaClientRustPanicError
  export import PrismaClientInitializationError = runtime.PrismaClientInitializationError
  export import PrismaClientValidationError = runtime.PrismaClientValidationError
  export import NotFoundError = runtime.NotFoundError

  /**
   * Re-export of sql-template-tag
   */
  export import sql = runtime.sqltag
  export import empty = runtime.empty
  export import join = runtime.join
  export import raw = runtime.raw
  export import Sql = runtime.Sql

  /**
   * Decimal.js
   */
  export import Decimal = runtime.Decimal

  export type DecimalJsLike = runtime.DecimalJsLike

  /**
   * Metrics 
   */
  export type Metrics = runtime.Metrics
  export type Metric<T> = runtime.Metric<T>
  export type MetricHistogram = runtime.MetricHistogram
  export type MetricHistogramBucket = runtime.MetricHistogramBucket


  /**
   * Prisma Client JS version: 4.11.0
   * Query Engine version: 8fde8fef4033376662cad983758335009d522acb
   */
  export type PrismaVersion = {
    client: string
  }

  export const prismaVersion: PrismaVersion 

  /**
   * Utility Types
   */

  /**
   * From https://github.com/sindresorhus/type-fest/
   * Matches a JSON object.
   * This type can be useful to enforce some input to be JSON-compatible or as a super-type to be extended from. 
   */
  export type JsonObject = {[Key in string]?: JsonValue}

  /**
   * From https://github.com/sindresorhus/type-fest/
   * Matches a JSON array.
   */
  export interface JsonArray extends Array<JsonValue> {}

  /**
   * From https://github.com/sindresorhus/type-fest/
   * Matches any valid JSON value.
   */
  export type JsonValue = string | number | boolean | JsonObject | JsonArray | null

  /**
   * Matches a JSON object.
   * Unlike `JsonObject`, this type allows undefined and read-only properties.
   */
  export type InputJsonObject = {readonly [Key in string]?: InputJsonValue | null}

  /**
   * Matches a JSON array.
   * Unlike `JsonArray`, readonly arrays are assignable to this type.
   */
  export interface InputJsonArray extends ReadonlyArray<InputJsonValue | null> {}

  /**
   * Matches any valid value that can be used as an input for operations like
   * create and update as the value of a JSON field. Unlike `JsonValue`, this
   * type allows read-only arrays and read-only object properties and disallows
   * `null` at the top level.
   *
   * `null` cannot be used as the value of a JSON field because its meaning
   * would be ambiguous. Use `Prisma.JsonNull` to store the JSON null value or
   * `Prisma.DbNull` to clear the JSON value and set the field to the database
   * NULL value instead.
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-by-null-values
   */
  export type InputJsonValue = string | number | boolean | InputJsonObject | InputJsonArray

  /**
   * Types of the values used to represent different kinds of `null` values when working with JSON fields.
   * 
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  namespace NullTypes {
    /**
    * Type of `Prisma.DbNull`.
    * 
    * You cannot use other instances of this class. Please use the `Prisma.DbNull` value.
    * 
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class DbNull {
      private DbNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.JsonNull`.
    * 
    * You cannot use other instances of this class. Please use the `Prisma.JsonNull` value.
    * 
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class JsonNull {
      private JsonNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.AnyNull`.
    * 
    * You cannot use other instances of this class. Please use the `Prisma.AnyNull` value.
    * 
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class AnyNull {
      private AnyNull: never
      private constructor()
    }
  }

  /**
   * Helper for filtering JSON entries that have `null` on the database (empty on the db)
   * 
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const DbNull: NullTypes.DbNull

  /**
   * Helper for filtering JSON entries that have JSON `null` values (not empty on the db)
   * 
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const JsonNull: NullTypes.JsonNull

  /**
   * Helper for filtering JSON entries that are `Prisma.DbNull` or `Prisma.JsonNull`
   * 
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const AnyNull: NullTypes.AnyNull

  type SelectAndInclude = {
    select: any
    include: any
  }
  type HasSelect = {
    select: any
  }
  type HasInclude = {
    include: any
  }
  type CheckSelect<T, S, U> = T extends SelectAndInclude
    ? 'Please either choose `select` or `include`'
    : T extends HasSelect
    ? U
    : T extends HasInclude
    ? U
    : S

  /**
   * Get the type of the value, that the Promise holds.
   */
  export type PromiseType<T extends PromiseLike<any>> = T extends PromiseLike<infer U> ? U : T;

  /**
   * Get the return type of a function which returns a Promise.
   */
  export type PromiseReturnType<T extends (...args: any) => Promise<any>> = PromiseType<ReturnType<T>>

  /**
   * From T, pick a set of properties whose keys are in the union K
   */
  type Prisma__Pick<T, K extends keyof T> = {
      [P in K]: T[P];
  };


  export type Enumerable<T> = T | Array<T>;

  export type RequiredKeys<T> = {
    [K in keyof T]-?: {} extends Prisma__Pick<T, K> ? never : K
  }[keyof T]

  export type TruthyKeys<T> = keyof {
    [K in keyof T as T[K] extends false | undefined | null ? never : K]: K
  }

  export type TrueKeys<T> = TruthyKeys<Prisma__Pick<T, RequiredKeys<T>>>

  /**
   * Subset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection
   */
  export type Subset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never;
  };

  /**
   * SelectSubset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection.
   * Additionally, it validates, if both select and include are present. If the case, it errors.
   */
  export type SelectSubset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    (T extends SelectAndInclude
      ? 'Please either choose `select` or `include`.'
      : {})

  /**
   * Subset + Intersection
   * @desc From `T` pick properties that exist in `U` and intersect `K`
   */
  export type SubsetIntersection<T, U, K> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    K

  type Without<T, U> = { [P in Exclude<keyof T, keyof U>]?: never };

  /**
   * XOR is needed to have a real mutually exclusive union type
   * https://stackoverflow.com/questions/42123407/does-typescript-support-mutually-exclusive-types
   */
  type XOR<T, U> =
    T extends object ?
    U extends object ?
      (Without<T, U> & U) | (Without<U, T> & T)
    : U : T


  /**
   * Is T a Record?
   */
  type IsObject<T extends any> = T extends Array<any>
  ? False
  : T extends Date
  ? False
  : T extends Uint8Array
  ? False
  : T extends BigInt
  ? False
  : T extends object
  ? True
  : False


  /**
   * If it's T[], return T
   */
  export type UnEnumerate<T extends unknown> = T extends Array<infer U> ? U : T

  /**
   * From ts-toolbelt
   */

  type __Either<O extends object, K extends Key> = Omit<O, K> &
    {
      // Merge all but K
      [P in K]: Prisma__Pick<O, P & keyof O> // With K possibilities
    }[K]

  type EitherStrict<O extends object, K extends Key> = Strict<__Either<O, K>>

  type EitherLoose<O extends object, K extends Key> = ComputeRaw<__Either<O, K>>

  type _Either<
    O extends object,
    K extends Key,
    strict extends Boolean
  > = {
    1: EitherStrict<O, K>
    0: EitherLoose<O, K>
  }[strict]

  type Either<
    O extends object,
    K extends Key,
    strict extends Boolean = 1
  > = O extends unknown ? _Either<O, K, strict> : never

  export type Union = any

  type PatchUndefined<O extends object, O1 extends object> = {
    [K in keyof O]: O[K] extends undefined ? At<O1, K> : O[K]
  } & {}

  /** Helper Types for "Merge" **/
  export type IntersectOf<U extends Union> = (
    U extends unknown ? (k: U) => void : never
  ) extends (k: infer I) => void
    ? I
    : never

  export type Overwrite<O extends object, O1 extends object> = {
      [K in keyof O]: K extends keyof O1 ? O1[K] : O[K];
  } & {};

  type _Merge<U extends object> = IntersectOf<Overwrite<U, {
      [K in keyof U]-?: At<U, K>;
  }>>;

  type Key = string | number | symbol;
  type AtBasic<O extends object, K extends Key> = K extends keyof O ? O[K] : never;
  type AtStrict<O extends object, K extends Key> = O[K & keyof O];
  type AtLoose<O extends object, K extends Key> = O extends unknown ? AtStrict<O, K> : never;
  export type At<O extends object, K extends Key, strict extends Boolean = 1> = {
      1: AtStrict<O, K>;
      0: AtLoose<O, K>;
  }[strict];

  export type ComputeRaw<A extends any> = A extends Function ? A : {
    [K in keyof A]: A[K];
  } & {};

  export type OptionalFlat<O> = {
    [K in keyof O]?: O[K];
  } & {};

  type _Record<K extends keyof any, T> = {
    [P in K]: T;
  };

  // cause typescript not to expand types and preserve names
  type NoExpand<T> = T extends unknown ? T : never;

  // this type assumes the passed object is entirely optional
  type AtLeast<O extends object, K extends string> = NoExpand<
    O extends unknown
    ? | (K extends keyof O ? { [P in K]: O[P] } & O : O)
      | {[P in keyof O as P extends K ? K : never]-?: O[P]} & O
    : never>;

  type _Strict<U, _U = U> = U extends unknown ? U & OptionalFlat<_Record<Exclude<Keys<_U>, keyof U>, never>> : never;

  export type Strict<U extends object> = ComputeRaw<_Strict<U>>;
  /** End Helper Types for "Merge" **/

  export type Merge<U extends object> = ComputeRaw<_Merge<Strict<U>>>;

  /**
  A [[Boolean]]
  */
  export type Boolean = True | False

  // /**
  // 1
  // */
  export type True = 1

  /**
  0
  */
  export type False = 0

  export type Not<B extends Boolean> = {
    0: 1
    1: 0
  }[B]

  export type Extends<A1 extends any, A2 extends any> = [A1] extends [never]
    ? 0 // anything `never` is false
    : A1 extends A2
    ? 1
    : 0

  export type Has<U extends Union, U1 extends Union> = Not<
    Extends<Exclude<U1, U>, U1>
  >

  export type Or<B1 extends Boolean, B2 extends Boolean> = {
    0: {
      0: 0
      1: 1
    }
    1: {
      0: 1
      1: 1
    }
  }[B1][B2]

  export type Keys<U extends Union> = U extends unknown ? keyof U : never

  type Cast<A, B> = A extends B ? A : B;

  export const type: unique symbol;

  export function validator<V>(): <S>(select: runtime.Types.Utils.LegacyExact<S, V>) => S;

  /**
   * Used by group by
   */

  export type GetScalarType<T, O> = O extends object ? {
    [P in keyof T]: P extends keyof O
      ? O[P]
      : never
  } : never

  type FieldPaths<
    T,
    U = Omit<T, '_avg' | '_sum' | '_count' | '_min' | '_max'>
  > = IsObject<T> extends True ? U : T

  type GetHavingFields<T> = {
    [K in keyof T]: Or<
      Or<Extends<'OR', K>, Extends<'AND', K>>,
      Extends<'NOT', K>
    > extends True
      ? // infer is only needed to not hit TS limit
        // based on the brilliant idea of Pierre-Antoine Mills
        // https://github.com/microsoft/TypeScript/issues/30188#issuecomment-478938437
        T[K] extends infer TK
        ? GetHavingFields<UnEnumerate<TK> extends object ? Merge<UnEnumerate<TK>> : never>
        : never
      : {} extends FieldPaths<T[K]>
      ? never
      : K
  }[keyof T]

  /**
   * Convert tuple to union
   */
  type _TupleToUnion<T> = T extends (infer E)[] ? E : never
  type TupleToUnion<K extends readonly any[]> = _TupleToUnion<K>
  type MaybeTupleToUnion<T> = T extends any[] ? TupleToUnion<T> : T

  /**
   * Like `Pick`, but with an array
   */
  type PickArray<T, K extends Array<keyof T>> = Prisma__Pick<T, TupleToUnion<K>>

  /**
   * Exclude all keys with underscores
   */
  type ExcludeUnderscoreKeys<T extends string> = T extends `_${string}` ? never : T


  export type FieldRef<Model, FieldType> = runtime.FieldRef<Model, FieldType>

  type FieldRefInputType<Model, FieldType> = Model extends never ? never : FieldRef<Model, FieldType>


  export const ModelName: {
    User: 'User',
    UserDetail: 'UserDetail',
    ResetPassowrd: 'ResetPassowrd',
    Role: 'Role',
    Permission: 'Permission',
    PermissionsOnRole: 'PermissionsOnRole',
    File: 'File',
    Inout: 'Inout',
    Inout_logs: 'Inout_logs',
    Holiday: 'Holiday',
    Notification: 'Notification',
    Notification_Receiver: 'Notification_Receiver',
    Vacation: 'Vacation'
  };

  export type ModelName = (typeof ModelName)[keyof typeof ModelName]


  export type Datasources = {
    db?: Datasource
  }

  export type DefaultPrismaClient = PrismaClient
  export type RejectOnNotFound = boolean | ((error: Error) => Error)
  export type RejectPerModel = { [P in ModelName]?: RejectOnNotFound }
  export type RejectPerOperation =  { [P in "findUnique" | "findFirst"]?: RejectPerModel | RejectOnNotFound } 
  type IsReject<T> = T extends true ? True : T extends (err: Error) => Error ? True : False
  export type HasReject<
    GlobalRejectSettings extends Prisma.PrismaClientOptions['rejectOnNotFound'],
    LocalRejectSettings,
    Action extends PrismaAction,
    Model extends ModelName
  > = LocalRejectSettings extends RejectOnNotFound
    ? IsReject<LocalRejectSettings>
    : GlobalRejectSettings extends RejectPerOperation
    ? Action extends keyof GlobalRejectSettings
      ? GlobalRejectSettings[Action] extends RejectOnNotFound
        ? IsReject<GlobalRejectSettings[Action]>
        : GlobalRejectSettings[Action] extends RejectPerModel
        ? Model extends keyof GlobalRejectSettings[Action]
          ? IsReject<GlobalRejectSettings[Action][Model]>
          : False
        : False
      : False
    : IsReject<GlobalRejectSettings>
  export type ErrorFormat = 'pretty' | 'colorless' | 'minimal'

  export interface PrismaClientOptions {
    /**
     * Configure findUnique/findFirst to throw an error if the query returns null. 
     * @deprecated since 4.0.0. Use `findUniqueOrThrow`/`findFirstOrThrow` methods instead.
     * @example
     * ```
     * // Reject on both findUnique/findFirst
     * rejectOnNotFound: true
     * // Reject only on findFirst with a custom error
     * rejectOnNotFound: { findFirst: (err) => new Error("Custom Error")}
     * // Reject on user.findUnique with a custom error
     * rejectOnNotFound: { findUnique: {User: (err) => new Error("User not found")}}
     * ```
     */
    rejectOnNotFound?: RejectOnNotFound | RejectPerOperation
    /**
     * Overwrites the datasource url from your schema.prisma file
     */
    datasources?: Datasources

    /**
     * @default "colorless"
     */
    errorFormat?: ErrorFormat

    /**
     * @example
     * ```
     * // Defaults to stdout
     * log: ['query', 'info', 'warn', 'error']
     * 
     * // Emit as events
     * log: [
     *  { emit: 'stdout', level: 'query' },
     *  { emit: 'stdout', level: 'info' },
     *  { emit: 'stdout', level: 'warn' }
     *  { emit: 'stdout', level: 'error' }
     * ]
     * ```
     * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/logging#the-log-option).
     */
    log?: Array<LogLevel | LogDefinition>
  }

  /* Types for Logging */
  export type LogLevel = 'info' | 'query' | 'warn' | 'error'
  export type LogDefinition = {
    level: LogLevel
    emit: 'stdout' | 'event'
  }

  export type GetLogType<T extends LogLevel | LogDefinition> = T extends LogDefinition ? T['emit'] extends 'event' ? T['level'] : never : never
  export type GetEvents<T extends any> = T extends Array<LogLevel | LogDefinition> ?
    GetLogType<T[0]> | GetLogType<T[1]> | GetLogType<T[2]> | GetLogType<T[3]>
    : never

  export type QueryEvent = {
    timestamp: Date
    query: string
    params: string
    duration: number
    target: string
  }

  export type LogEvent = {
    timestamp: Date
    message: string
    target: string
  }
  /* End Types for Logging */


  export type PrismaAction =
    | 'findUnique'
    | 'findMany'
    | 'findFirst'
    | 'create'
    | 'createMany'
    | 'update'
    | 'updateMany'
    | 'upsert'
    | 'delete'
    | 'deleteMany'
    | 'executeRaw'
    | 'queryRaw'
    | 'aggregate'
    | 'count'
    | 'runCommandRaw'
    | 'findRaw'

  /**
   * These options are being passed into the middleware as "params"
   */
  export type MiddlewareParams = {
    model?: ModelName
    action: PrismaAction
    args: any
    dataPath: string[]
    runInTransaction: boolean
  }

  /**
   * The `T` type makes sure, that the `return proceed` is not forgotten in the middleware implementation
   */
  export type Middleware<T = any> = (
    params: MiddlewareParams,
    next: (params: MiddlewareParams) => Promise<T>,
  ) => Promise<T>

  // tested in getLogLevel.test.ts
  export function getLogLevel(log: Array<LogLevel | LogDefinition>): LogLevel | undefined;

  /**
   * `PrismaClient` proxy available in interactive transactions.
   */
  export type TransactionClient = Omit<Prisma.DefaultPrismaClient, '$connect' | '$disconnect' | '$on' | '$transaction' | '$use'>

  export type Datasource = {
    url?: string
  }

  /**
   * Count Types
   */


  /**
   * Count Type UserCountOutputType
   */


  export type UserCountOutputType = {
    userManager: number
    Inout: number
    File: number
    Notification: number
    Notification_Receiver: number
    Vacation: number
  }

  export type UserCountOutputTypeSelect = {
    userManager?: boolean
    Inout?: boolean
    File?: boolean
    Notification?: boolean
    Notification_Receiver?: boolean
    Vacation?: boolean
  }

  export type UserCountOutputTypeGetPayload<S extends boolean | null | undefined | UserCountOutputTypeArgs> =
    S extends { select: any, include: any } ? 'Please either choose `select` or `include`' :
    S extends true ? UserCountOutputType :
    S extends undefined ? never :
    S extends { include: any } & (UserCountOutputTypeArgs)
    ? UserCountOutputType 
    : S extends { select: any } & (UserCountOutputTypeArgs)
      ? {
    [P in TruthyKeys<S['select']>]:
    P extends keyof UserCountOutputType ? UserCountOutputType[P] : never
  } 
      : UserCountOutputType




  // Custom InputTypes

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeArgs = {
    /**
     * Select specific fields to fetch from the UserCountOutputType
     */
    select?: UserCountOutputTypeSelect | null
  }



  /**
   * Count Type RoleCountOutputType
   */


  export type RoleCountOutputType = {
    PermissionsOnRole: number
    User: number
  }

  export type RoleCountOutputTypeSelect = {
    PermissionsOnRole?: boolean
    User?: boolean
  }

  export type RoleCountOutputTypeGetPayload<S extends boolean | null | undefined | RoleCountOutputTypeArgs> =
    S extends { select: any, include: any } ? 'Please either choose `select` or `include`' :
    S extends true ? RoleCountOutputType :
    S extends undefined ? never :
    S extends { include: any } & (RoleCountOutputTypeArgs)
    ? RoleCountOutputType 
    : S extends { select: any } & (RoleCountOutputTypeArgs)
      ? {
    [P in TruthyKeys<S['select']>]:
    P extends keyof RoleCountOutputType ? RoleCountOutputType[P] : never
  } 
      : RoleCountOutputType




  // Custom InputTypes

  /**
   * RoleCountOutputType without action
   */
  export type RoleCountOutputTypeArgs = {
    /**
     * Select specific fields to fetch from the RoleCountOutputType
     */
    select?: RoleCountOutputTypeSelect | null
  }



  /**
   * Count Type PermissionCountOutputType
   */


  export type PermissionCountOutputType = {
    PermissionsOnRole: number
  }

  export type PermissionCountOutputTypeSelect = {
    PermissionsOnRole?: boolean
  }

  export type PermissionCountOutputTypeGetPayload<S extends boolean | null | undefined | PermissionCountOutputTypeArgs> =
    S extends { select: any, include: any } ? 'Please either choose `select` or `include`' :
    S extends true ? PermissionCountOutputType :
    S extends undefined ? never :
    S extends { include: any } & (PermissionCountOutputTypeArgs)
    ? PermissionCountOutputType 
    : S extends { select: any } & (PermissionCountOutputTypeArgs)
      ? {
    [P in TruthyKeys<S['select']>]:
    P extends keyof PermissionCountOutputType ? PermissionCountOutputType[P] : never
  } 
      : PermissionCountOutputType




  // Custom InputTypes

  /**
   * PermissionCountOutputType without action
   */
  export type PermissionCountOutputTypeArgs = {
    /**
     * Select specific fields to fetch from the PermissionCountOutputType
     */
    select?: PermissionCountOutputTypeSelect | null
  }



  /**
   * Count Type FileCountOutputType
   */


  export type FileCountOutputType = {
    UserDetail: number
    Notification: number
  }

  export type FileCountOutputTypeSelect = {
    UserDetail?: boolean
    Notification?: boolean
  }

  export type FileCountOutputTypeGetPayload<S extends boolean | null | undefined | FileCountOutputTypeArgs> =
    S extends { select: any, include: any } ? 'Please either choose `select` or `include`' :
    S extends true ? FileCountOutputType :
    S extends undefined ? never :
    S extends { include: any } & (FileCountOutputTypeArgs)
    ? FileCountOutputType 
    : S extends { select: any } & (FileCountOutputTypeArgs)
      ? {
    [P in TruthyKeys<S['select']>]:
    P extends keyof FileCountOutputType ? FileCountOutputType[P] : never
  } 
      : FileCountOutputType




  // Custom InputTypes

  /**
   * FileCountOutputType without action
   */
  export type FileCountOutputTypeArgs = {
    /**
     * Select specific fields to fetch from the FileCountOutputType
     */
    select?: FileCountOutputTypeSelect | null
  }



  /**
   * Count Type InoutCountOutputType
   */


  export type InoutCountOutputType = {
    Inout_logs: number
  }

  export type InoutCountOutputTypeSelect = {
    Inout_logs?: boolean
  }

  export type InoutCountOutputTypeGetPayload<S extends boolean | null | undefined | InoutCountOutputTypeArgs> =
    S extends { select: any, include: any } ? 'Please either choose `select` or `include`' :
    S extends true ? InoutCountOutputType :
    S extends undefined ? never :
    S extends { include: any } & (InoutCountOutputTypeArgs)
    ? InoutCountOutputType 
    : S extends { select: any } & (InoutCountOutputTypeArgs)
      ? {
    [P in TruthyKeys<S['select']>]:
    P extends keyof InoutCountOutputType ? InoutCountOutputType[P] : never
  } 
      : InoutCountOutputType




  // Custom InputTypes

  /**
   * InoutCountOutputType without action
   */
  export type InoutCountOutputTypeArgs = {
    /**
     * Select specific fields to fetch from the InoutCountOutputType
     */
    select?: InoutCountOutputTypeSelect | null
  }



  /**
   * Count Type NotificationCountOutputType
   */


  export type NotificationCountOutputType = {
    Notification_Receiver: number
  }

  export type NotificationCountOutputTypeSelect = {
    Notification_Receiver?: boolean
  }

  export type NotificationCountOutputTypeGetPayload<S extends boolean | null | undefined | NotificationCountOutputTypeArgs> =
    S extends { select: any, include: any } ? 'Please either choose `select` or `include`' :
    S extends true ? NotificationCountOutputType :
    S extends undefined ? never :
    S extends { include: any } & (NotificationCountOutputTypeArgs)
    ? NotificationCountOutputType 
    : S extends { select: any } & (NotificationCountOutputTypeArgs)
      ? {
    [P in TruthyKeys<S['select']>]:
    P extends keyof NotificationCountOutputType ? NotificationCountOutputType[P] : never
  } 
      : NotificationCountOutputType




  // Custom InputTypes

  /**
   * NotificationCountOutputType without action
   */
  export type NotificationCountOutputTypeArgs = {
    /**
     * Select specific fields to fetch from the NotificationCountOutputType
     */
    select?: NotificationCountOutputTypeSelect | null
  }



  /**
   * Models
   */

  /**
   * Model User
   */


  export type AggregateUser = {
    _count: UserCountAggregateOutputType | null
    _min: UserMinAggregateOutputType | null
    _max: UserMaxAggregateOutputType | null
  }

  export type UserMinAggregateOutputType = {
    id: string | null
    email: string | null
    password: string | null
    phone: string | null
    status: UserStatus | null
    role_id: string | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type UserMaxAggregateOutputType = {
    id: string | null
    email: string | null
    password: string | null
    phone: string | null
    status: UserStatus | null
    role_id: string | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type UserCountAggregateOutputType = {
    id: number
    email: number
    password: number
    phone: number
    status: number
    role_id: number
    createdAt: number
    updatedAt: number
    _all: number
  }


  export type UserMinAggregateInputType = {
    id?: true
    email?: true
    password?: true
    phone?: true
    status?: true
    role_id?: true
    createdAt?: true
    updatedAt?: true
  }

  export type UserMaxAggregateInputType = {
    id?: true
    email?: true
    password?: true
    phone?: true
    status?: true
    role_id?: true
    createdAt?: true
    updatedAt?: true
  }

  export type UserCountAggregateInputType = {
    id?: true
    email?: true
    password?: true
    phone?: true
    status?: true
    role_id?: true
    createdAt?: true
    updatedAt?: true
    _all?: true
  }

  export type UserAggregateArgs = {
    /**
     * Filter which User to aggregate.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: Enumerable<UserOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Users
    **/
    _count?: true | UserCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: UserMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: UserMaxAggregateInputType
  }

  export type GetUserAggregateType<T extends UserAggregateArgs> = {
        [P in keyof T & keyof AggregateUser]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateUser[P]>
      : GetScalarType<T[P], AggregateUser[P]>
  }




  export type UserGroupByArgs = {
    where?: UserWhereInput
    orderBy?: Enumerable<UserOrderByWithAggregationInput>
    by: UserScalarFieldEnum[]
    having?: UserScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: UserCountAggregateInputType | true
    _min?: UserMinAggregateInputType
    _max?: UserMaxAggregateInputType
  }


  export type UserGroupByOutputType = {
    id: string
    email: string
    password: string
    phone: string | null
    status: UserStatus
    role_id: string
    createdAt: Date
    updatedAt: Date
    _count: UserCountAggregateOutputType | null
    _min: UserMinAggregateOutputType | null
    _max: UserMaxAggregateOutputType | null
  }

  type GetUserGroupByPayload<T extends UserGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickArray<UserGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof UserGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], UserGroupByOutputType[P]>
            : GetScalarType<T[P], UserGroupByOutputType[P]>
        }
      >
    >


  export type UserSelect = {
    id?: boolean
    email?: boolean
    password?: boolean
    phone?: boolean
    status?: boolean
    role_id?: boolean
    createdAt?: boolean
    updatedAt?: boolean
    userDetail?: boolean | UserDetailArgs
    userManager?: boolean | User$userManagerArgs
    role?: boolean | RoleArgs
    ResetPassowrd?: boolean | ResetPassowrdArgs
    Inout?: boolean | User$InoutArgs
    File?: boolean | User$FileArgs
    Notification?: boolean | User$NotificationArgs
    Notification_Receiver?: boolean | User$Notification_ReceiverArgs
    Vacation?: boolean | User$VacationArgs
    _count?: boolean | UserCountOutputTypeArgs
  }


  export type UserInclude = {
    userDetail?: boolean | UserDetailArgs
    userManager?: boolean | User$userManagerArgs
    role?: boolean | RoleArgs
    ResetPassowrd?: boolean | ResetPassowrdArgs
    Inout?: boolean | User$InoutArgs
    File?: boolean | User$FileArgs
    Notification?: boolean | User$NotificationArgs
    Notification_Receiver?: boolean | User$Notification_ReceiverArgs
    Vacation?: boolean | User$VacationArgs
    _count?: boolean | UserCountOutputTypeArgs
  }

  export type UserGetPayload<S extends boolean | null | undefined | UserArgs> =
    S extends { select: any, include: any } ? 'Please either choose `select` or `include`' :
    S extends true ? User :
    S extends undefined ? never :
    S extends { include: any } & (UserArgs | UserFindManyArgs)
    ? User  & {
    [P in TruthyKeys<S['include']>]:
        P extends 'userDetail' ? UserDetailGetPayload<S['include'][P]> | null :
        P extends 'userManager' ? Array < UserDetailGetPayload<S['include'][P]>>  :
        P extends 'role' ? RoleGetPayload<S['include'][P]> :
        P extends 'ResetPassowrd' ? ResetPassowrdGetPayload<S['include'][P]> | null :
        P extends 'Inout' ? Array < InoutGetPayload<S['include'][P]>>  :
        P extends 'File' ? Array < FileGetPayload<S['include'][P]>>  :
        P extends 'Notification' ? Array < NotificationGetPayload<S['include'][P]>>  :
        P extends 'Notification_Receiver' ? Array < Notification_ReceiverGetPayload<S['include'][P]>>  :
        P extends 'Vacation' ? Array < VacationGetPayload<S['include'][P]>>  :
        P extends '_count' ? UserCountOutputTypeGetPayload<S['include'][P]> :  never
  } 
    : S extends { select: any } & (UserArgs | UserFindManyArgs)
      ? {
    [P in TruthyKeys<S['select']>]:
        P extends 'userDetail' ? UserDetailGetPayload<S['select'][P]> | null :
        P extends 'userManager' ? Array < UserDetailGetPayload<S['select'][P]>>  :
        P extends 'role' ? RoleGetPayload<S['select'][P]> :
        P extends 'ResetPassowrd' ? ResetPassowrdGetPayload<S['select'][P]> | null :
        P extends 'Inout' ? Array < InoutGetPayload<S['select'][P]>>  :
        P extends 'File' ? Array < FileGetPayload<S['select'][P]>>  :
        P extends 'Notification' ? Array < NotificationGetPayload<S['select'][P]>>  :
        P extends 'Notification_Receiver' ? Array < Notification_ReceiverGetPayload<S['select'][P]>>  :
        P extends 'Vacation' ? Array < VacationGetPayload<S['select'][P]>>  :
        P extends '_count' ? UserCountOutputTypeGetPayload<S['select'][P]> :  P extends keyof User ? User[P] : never
  } 
      : User


  type UserCountArgs = 
    Omit<UserFindManyArgs, 'select' | 'include'> & {
      select?: UserCountAggregateInputType | true
    }

  export interface UserDelegate<GlobalRejectSettings extends Prisma.RejectOnNotFound | Prisma.RejectPerOperation | false | undefined> {

    /**
     * Find zero or one User that matches the filter.
     * @param {UserFindUniqueArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends UserFindUniqueArgs,  LocalRejectSettings = T["rejectOnNotFound"] extends RejectOnNotFound ? T['rejectOnNotFound'] : undefined>(
      args: SelectSubset<T, UserFindUniqueArgs>
    ): HasReject<GlobalRejectSettings, LocalRejectSettings, 'findUnique', 'User'> extends True ? Prisma__UserClient<UserGetPayload<T>> : Prisma__UserClient<UserGetPayload<T> | null, null>

    /**
     * Find one User that matches the filter or throw an error  with `error.code='P2025'` 
     *     if no matches were found.
     * @param {UserFindUniqueOrThrowArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends UserFindUniqueOrThrowArgs>(
      args?: SelectSubset<T, UserFindUniqueOrThrowArgs>
    ): Prisma__UserClient<UserGetPayload<T>>

    /**
     * Find the first User that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserFindFirstArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends UserFindFirstArgs,  LocalRejectSettings = T["rejectOnNotFound"] extends RejectOnNotFound ? T['rejectOnNotFound'] : undefined>(
      args?: SelectSubset<T, UserFindFirstArgs>
    ): HasReject<GlobalRejectSettings, LocalRejectSettings, 'findFirst', 'User'> extends True ? Prisma__UserClient<UserGetPayload<T>> : Prisma__UserClient<UserGetPayload<T> | null, null>

    /**
     * Find the first User that matches the filter or
     * throw `NotFoundError` if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserFindFirstOrThrowArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends UserFindFirstOrThrowArgs>(
      args?: SelectSubset<T, UserFindFirstOrThrowArgs>
    ): Prisma__UserClient<UserGetPayload<T>>

    /**
     * Find zero or more Users that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserFindManyArgs=} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Users
     * const users = await prisma.user.findMany()
     * 
     * // Get first 10 Users
     * const users = await prisma.user.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const userWithIdOnly = await prisma.user.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends UserFindManyArgs>(
      args?: SelectSubset<T, UserFindManyArgs>
    ): Prisma.PrismaPromise<Array<UserGetPayload<T>>>

    /**
     * Create a User.
     * @param {UserCreateArgs} args - Arguments to create a User.
     * @example
     * // Create one User
     * const User = await prisma.user.create({
     *   data: {
     *     // ... data to create a User
     *   }
     * })
     * 
    **/
    create<T extends UserCreateArgs>(
      args: SelectSubset<T, UserCreateArgs>
    ): Prisma__UserClient<UserGetPayload<T>>

    /**
     * Create many Users.
     *     @param {UserCreateManyArgs} args - Arguments to create many Users.
     *     @example
     *     // Create many Users
     *     const user = await prisma.user.createMany({
     *       data: {
     *         // ... provide data here
     *       }
     *     })
     *     
    **/
    createMany<T extends UserCreateManyArgs>(
      args?: SelectSubset<T, UserCreateManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a User.
     * @param {UserDeleteArgs} args - Arguments to delete one User.
     * @example
     * // Delete one User
     * const User = await prisma.user.delete({
     *   where: {
     *     // ... filter to delete one User
     *   }
     * })
     * 
    **/
    delete<T extends UserDeleteArgs>(
      args: SelectSubset<T, UserDeleteArgs>
    ): Prisma__UserClient<UserGetPayload<T>>

    /**
     * Update one User.
     * @param {UserUpdateArgs} args - Arguments to update one User.
     * @example
     * // Update one User
     * const user = await prisma.user.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends UserUpdateArgs>(
      args: SelectSubset<T, UserUpdateArgs>
    ): Prisma__UserClient<UserGetPayload<T>>

    /**
     * Delete zero or more Users.
     * @param {UserDeleteManyArgs} args - Arguments to filter Users to delete.
     * @example
     * // Delete a few Users
     * const { count } = await prisma.user.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends UserDeleteManyArgs>(
      args?: SelectSubset<T, UserDeleteManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Users.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Users
     * const user = await prisma.user.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends UserUpdateManyArgs>(
      args: SelectSubset<T, UserUpdateManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one User.
     * @param {UserUpsertArgs} args - Arguments to update or create a User.
     * @example
     * // Update or create a User
     * const user = await prisma.user.upsert({
     *   create: {
     *     // ... data to create a User
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the User we want to update
     *   }
     * })
    **/
    upsert<T extends UserUpsertArgs>(
      args: SelectSubset<T, UserUpsertArgs>
    ): Prisma__UserClient<UserGetPayload<T>>

    /**
     * Count the number of Users.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserCountArgs} args - Arguments to filter Users to count.
     * @example
     * // Count the number of Users
     * const count = await prisma.user.count({
     *   where: {
     *     // ... the filter for the Users we want to count
     *   }
     * })
    **/
    count<T extends UserCountArgs>(
      args?: Subset<T, UserCountArgs>,
    ): Prisma.PrismaPromise<
      T extends _Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], UserCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a User.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends UserAggregateArgs>(args: Subset<T, UserAggregateArgs>): Prisma.PrismaPromise<GetUserAggregateType<T>>

    /**
     * Group by User.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends UserGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: UserGroupByArgs['orderBy'] }
        : { orderBy?: UserGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends TupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, UserGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetUserGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>

  }

  /**
   * The delegate class that acts as a "Promise-like" for User.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export class Prisma__UserClient<T, Null = never> implements Prisma.PrismaPromise<T> {
    private readonly _dmmf;
    private readonly _queryType;
    private readonly _rootField;
    private readonly _clientMethod;
    private readonly _args;
    private readonly _dataPath;
    private readonly _errorFormat;
    private readonly _measurePerformance?;
    private _isList;
    private _callsite;
    private _requestPromise?;
    readonly [Symbol.toStringTag]: 'PrismaPromise';
    constructor(_dmmf: runtime.DMMFClass, _queryType: 'query' | 'mutation', _rootField: string, _clientMethod: string, _args: any, _dataPath: string[], _errorFormat: ErrorFormat, _measurePerformance?: boolean | undefined, _isList?: boolean);

    userDetail<T extends UserDetailArgs= {}>(args?: Subset<T, UserDetailArgs>): Prisma__UserDetailClient<UserDetailGetPayload<T> | Null>;

    userManager<T extends User$userManagerArgs= {}>(args?: Subset<T, User$userManagerArgs>): Prisma.PrismaPromise<Array<UserDetailGetPayload<T>>| Null>;

    role<T extends RoleArgs= {}>(args?: Subset<T, RoleArgs>): Prisma__RoleClient<RoleGetPayload<T> | Null>;

    ResetPassowrd<T extends ResetPassowrdArgs= {}>(args?: Subset<T, ResetPassowrdArgs>): Prisma__ResetPassowrdClient<ResetPassowrdGetPayload<T> | Null>;

    Inout<T extends User$InoutArgs= {}>(args?: Subset<T, User$InoutArgs>): Prisma.PrismaPromise<Array<InoutGetPayload<T>>| Null>;

    File<T extends User$FileArgs= {}>(args?: Subset<T, User$FileArgs>): Prisma.PrismaPromise<Array<FileGetPayload<T>>| Null>;

    Notification<T extends User$NotificationArgs= {}>(args?: Subset<T, User$NotificationArgs>): Prisma.PrismaPromise<Array<NotificationGetPayload<T>>| Null>;

    Notification_Receiver<T extends User$Notification_ReceiverArgs= {}>(args?: Subset<T, User$Notification_ReceiverArgs>): Prisma.PrismaPromise<Array<Notification_ReceiverGetPayload<T>>| Null>;

    Vacation<T extends User$VacationArgs= {}>(args?: Subset<T, User$VacationArgs>): Prisma.PrismaPromise<Array<VacationGetPayload<T>>| Null>;

    private get _document();
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): Promise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): Promise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): Promise<T>;
  }



  // Custom InputTypes

  /**
   * User base type for findUnique actions
   */
  export type UserFindUniqueArgsBase = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserInclude | null
    /**
     * Filter, which User to fetch.
     */
    where: UserWhereUniqueInput
  }

  /**
   * User findUnique
   */
  export interface UserFindUniqueArgs extends UserFindUniqueArgsBase {
   /**
    * Throw an Error if query returns no results
    * @deprecated since 4.0.0: use `findUniqueOrThrow` method instead
    */
    rejectOnNotFound?: RejectOnNotFound
  }
      

  /**
   * User findUniqueOrThrow
   */
  export type UserFindUniqueOrThrowArgs = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserInclude | null
    /**
     * Filter, which User to fetch.
     */
    where: UserWhereUniqueInput
  }


  /**
   * User base type for findFirst actions
   */
  export type UserFindFirstArgsBase = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserInclude | null
    /**
     * Filter, which User to fetch.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: Enumerable<UserOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Users.
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Users.
     */
    distinct?: Enumerable<UserScalarFieldEnum>
  }

  /**
   * User findFirst
   */
  export interface UserFindFirstArgs extends UserFindFirstArgsBase {
   /**
    * Throw an Error if query returns no results
    * @deprecated since 4.0.0: use `findFirstOrThrow` method instead
    */
    rejectOnNotFound?: RejectOnNotFound
  }
      

  /**
   * User findFirstOrThrow
   */
  export type UserFindFirstOrThrowArgs = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserInclude | null
    /**
     * Filter, which User to fetch.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: Enumerable<UserOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Users.
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Users.
     */
    distinct?: Enumerable<UserScalarFieldEnum>
  }


  /**
   * User findMany
   */
  export type UserFindManyArgs = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserInclude | null
    /**
     * Filter, which Users to fetch.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: Enumerable<UserOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Users.
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    distinct?: Enumerable<UserScalarFieldEnum>
  }


  /**
   * User create
   */
  export type UserCreateArgs = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserInclude | null
    /**
     * The data needed to create a User.
     */
    data: XOR<UserCreateInput, UserUncheckedCreateInput>
  }


  /**
   * User createMany
   */
  export type UserCreateManyArgs = {
    /**
     * The data used to create many Users.
     */
    data: Enumerable<UserCreateManyInput>
    skipDuplicates?: boolean
  }


  /**
   * User update
   */
  export type UserUpdateArgs = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserInclude | null
    /**
     * The data needed to update a User.
     */
    data: XOR<UserUpdateInput, UserUncheckedUpdateInput>
    /**
     * Choose, which User to update.
     */
    where: UserWhereUniqueInput
  }


  /**
   * User updateMany
   */
  export type UserUpdateManyArgs = {
    /**
     * The data used to update Users.
     */
    data: XOR<UserUpdateManyMutationInput, UserUncheckedUpdateManyInput>
    /**
     * Filter which Users to update
     */
    where?: UserWhereInput
  }


  /**
   * User upsert
   */
  export type UserUpsertArgs = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserInclude | null
    /**
     * The filter to search for the User to update in case it exists.
     */
    where: UserWhereUniqueInput
    /**
     * In case the User found by the `where` argument doesn't exist, create a new User with this data.
     */
    create: XOR<UserCreateInput, UserUncheckedCreateInput>
    /**
     * In case the User was found with the provided `where` argument, update it with this data.
     */
    update: XOR<UserUpdateInput, UserUncheckedUpdateInput>
  }


  /**
   * User delete
   */
  export type UserDeleteArgs = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserInclude | null
    /**
     * Filter which User to delete.
     */
    where: UserWhereUniqueInput
  }


  /**
   * User deleteMany
   */
  export type UserDeleteManyArgs = {
    /**
     * Filter which Users to delete
     */
    where?: UserWhereInput
  }


  /**
   * User.userManager
   */
  export type User$userManagerArgs = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserDetailInclude | null
    where?: UserDetailWhereInput
    orderBy?: Enumerable<UserDetailOrderByWithRelationInput>
    cursor?: UserDetailWhereUniqueInput
    take?: number
    skip?: number
    distinct?: Enumerable<UserDetailScalarFieldEnum>
  }


  /**
   * User.Inout
   */
  export type User$InoutArgs = {
    /**
     * Select specific fields to fetch from the Inout
     */
    select?: InoutSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: InoutInclude | null
    where?: InoutWhereInput
    orderBy?: Enumerable<InoutOrderByWithRelationInput>
    cursor?: InoutWhereUniqueInput
    take?: number
    skip?: number
    distinct?: Enumerable<InoutScalarFieldEnum>
  }


  /**
   * User.File
   */
  export type User$FileArgs = {
    /**
     * Select specific fields to fetch from the File
     */
    select?: FileSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: FileInclude | null
    where?: FileWhereInput
    orderBy?: Enumerable<FileOrderByWithRelationInput>
    cursor?: FileWhereUniqueInput
    take?: number
    skip?: number
    distinct?: Enumerable<FileScalarFieldEnum>
  }


  /**
   * User.Notification
   */
  export type User$NotificationArgs = {
    /**
     * Select specific fields to fetch from the Notification
     */
    select?: NotificationSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: NotificationInclude | null
    where?: NotificationWhereInput
    orderBy?: Enumerable<NotificationOrderByWithRelationInput>
    cursor?: NotificationWhereUniqueInput
    take?: number
    skip?: number
    distinct?: Enumerable<NotificationScalarFieldEnum>
  }


  /**
   * User.Notification_Receiver
   */
  export type User$Notification_ReceiverArgs = {
    /**
     * Select specific fields to fetch from the Notification_Receiver
     */
    select?: Notification_ReceiverSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: Notification_ReceiverInclude | null
    where?: Notification_ReceiverWhereInput
    orderBy?: Enumerable<Notification_ReceiverOrderByWithRelationInput>
    cursor?: Notification_ReceiverWhereUniqueInput
    take?: number
    skip?: number
    distinct?: Enumerable<Notification_ReceiverScalarFieldEnum>
  }


  /**
   * User.Vacation
   */
  export type User$VacationArgs = {
    /**
     * Select specific fields to fetch from the Vacation
     */
    select?: VacationSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: VacationInclude | null
    where?: VacationWhereInput
    orderBy?: Enumerable<VacationOrderByWithRelationInput>
    cursor?: VacationWhereUniqueInput
    take?: number
    skip?: number
    distinct?: Enumerable<VacationScalarFieldEnum>
  }


  /**
   * User without action
   */
  export type UserArgs = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserInclude | null
  }



  /**
   * Model UserDetail
   */


  export type AggregateUserDetail = {
    _count: UserDetailCountAggregateOutputType | null
    _avg: UserDetailAvgAggregateOutputType | null
    _sum: UserDetailSumAggregateOutputType | null
    _min: UserDetailMinAggregateOutputType | null
    _max: UserDetailMaxAggregateOutputType | null
  }

  export type UserDetailAvgAggregateOutputType = {
    personal_code: number | null
    delay_ratio: number | null
    vacation_remained: number | null
  }

  export type UserDetailSumAggregateOutputType = {
    personal_code: number | null
    delay_ratio: number | null
    vacation_remained: number | null
  }

  export type UserDetailMinAggregateOutputType = {
    id: string | null
    user_id: string | null
    first_name: string | null
    last_name: string | null
    personal_code: number | null
    featured_image: string | null
    delay_time: string | null
    delay_ratio: number | null
    manager_id: string | null
    vacation_remained: number | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type UserDetailMaxAggregateOutputType = {
    id: string | null
    user_id: string | null
    first_name: string | null
    last_name: string | null
    personal_code: number | null
    featured_image: string | null
    delay_time: string | null
    delay_ratio: number | null
    manager_id: string | null
    vacation_remained: number | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type UserDetailCountAggregateOutputType = {
    id: number
    user_id: number
    first_name: number
    last_name: number
    personal_code: number
    featured_image: number
    delay_time: number
    delay_ratio: number
    manager_id: number
    vacation_remained: number
    createdAt: number
    updatedAt: number
    _all: number
  }


  export type UserDetailAvgAggregateInputType = {
    personal_code?: true
    delay_ratio?: true
    vacation_remained?: true
  }

  export type UserDetailSumAggregateInputType = {
    personal_code?: true
    delay_ratio?: true
    vacation_remained?: true
  }

  export type UserDetailMinAggregateInputType = {
    id?: true
    user_id?: true
    first_name?: true
    last_name?: true
    personal_code?: true
    featured_image?: true
    delay_time?: true
    delay_ratio?: true
    manager_id?: true
    vacation_remained?: true
    createdAt?: true
    updatedAt?: true
  }

  export type UserDetailMaxAggregateInputType = {
    id?: true
    user_id?: true
    first_name?: true
    last_name?: true
    personal_code?: true
    featured_image?: true
    delay_time?: true
    delay_ratio?: true
    manager_id?: true
    vacation_remained?: true
    createdAt?: true
    updatedAt?: true
  }

  export type UserDetailCountAggregateInputType = {
    id?: true
    user_id?: true
    first_name?: true
    last_name?: true
    personal_code?: true
    featured_image?: true
    delay_time?: true
    delay_ratio?: true
    manager_id?: true
    vacation_remained?: true
    createdAt?: true
    updatedAt?: true
    _all?: true
  }

  export type UserDetailAggregateArgs = {
    /**
     * Filter which UserDetail to aggregate.
     */
    where?: UserDetailWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserDetails to fetch.
     */
    orderBy?: Enumerable<UserDetailOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: UserDetailWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserDetails from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserDetails.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned UserDetails
    **/
    _count?: true | UserDetailCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: UserDetailAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: UserDetailSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: UserDetailMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: UserDetailMaxAggregateInputType
  }

  export type GetUserDetailAggregateType<T extends UserDetailAggregateArgs> = {
        [P in keyof T & keyof AggregateUserDetail]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateUserDetail[P]>
      : GetScalarType<T[P], AggregateUserDetail[P]>
  }




  export type UserDetailGroupByArgs = {
    where?: UserDetailWhereInput
    orderBy?: Enumerable<UserDetailOrderByWithAggregationInput>
    by: UserDetailScalarFieldEnum[]
    having?: UserDetailScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: UserDetailCountAggregateInputType | true
    _avg?: UserDetailAvgAggregateInputType
    _sum?: UserDetailSumAggregateInputType
    _min?: UserDetailMinAggregateInputType
    _max?: UserDetailMaxAggregateInputType
  }


  export type UserDetailGroupByOutputType = {
    id: string
    user_id: string
    first_name: string | null
    last_name: string | null
    personal_code: number | null
    featured_image: string | null
    delay_time: string | null
    delay_ratio: number | null
    manager_id: string | null
    vacation_remained: number
    createdAt: Date
    updatedAt: Date
    _count: UserDetailCountAggregateOutputType | null
    _avg: UserDetailAvgAggregateOutputType | null
    _sum: UserDetailSumAggregateOutputType | null
    _min: UserDetailMinAggregateOutputType | null
    _max: UserDetailMaxAggregateOutputType | null
  }

  type GetUserDetailGroupByPayload<T extends UserDetailGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickArray<UserDetailGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof UserDetailGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], UserDetailGroupByOutputType[P]>
            : GetScalarType<T[P], UserDetailGroupByOutputType[P]>
        }
      >
    >


  export type UserDetailSelect = {
    id?: boolean
    user_id?: boolean
    first_name?: boolean
    last_name?: boolean
    personal_code?: boolean
    featured_image?: boolean
    delay_time?: boolean
    delay_ratio?: boolean
    manager_id?: boolean
    vacation_remained?: boolean
    createdAt?: boolean
    updatedAt?: boolean
    file?: boolean | FileArgs
    user?: boolean | UserArgs
    manager?: boolean | UserArgs
  }


  export type UserDetailInclude = {
    file?: boolean | FileArgs
    user?: boolean | UserArgs
    manager?: boolean | UserArgs
  }

  export type UserDetailGetPayload<S extends boolean | null | undefined | UserDetailArgs> =
    S extends { select: any, include: any } ? 'Please either choose `select` or `include`' :
    S extends true ? UserDetail :
    S extends undefined ? never :
    S extends { include: any } & (UserDetailArgs | UserDetailFindManyArgs)
    ? UserDetail  & {
    [P in TruthyKeys<S['include']>]:
        P extends 'file' ? FileGetPayload<S['include'][P]> | null :
        P extends 'user' ? UserGetPayload<S['include'][P]> :
        P extends 'manager' ? UserGetPayload<S['include'][P]> | null :  never
  } 
    : S extends { select: any } & (UserDetailArgs | UserDetailFindManyArgs)
      ? {
    [P in TruthyKeys<S['select']>]:
        P extends 'file' ? FileGetPayload<S['select'][P]> | null :
        P extends 'user' ? UserGetPayload<S['select'][P]> :
        P extends 'manager' ? UserGetPayload<S['select'][P]> | null :  P extends keyof UserDetail ? UserDetail[P] : never
  } 
      : UserDetail


  type UserDetailCountArgs = 
    Omit<UserDetailFindManyArgs, 'select' | 'include'> & {
      select?: UserDetailCountAggregateInputType | true
    }

  export interface UserDetailDelegate<GlobalRejectSettings extends Prisma.RejectOnNotFound | Prisma.RejectPerOperation | false | undefined> {

    /**
     * Find zero or one UserDetail that matches the filter.
     * @param {UserDetailFindUniqueArgs} args - Arguments to find a UserDetail
     * @example
     * // Get one UserDetail
     * const userDetail = await prisma.userDetail.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends UserDetailFindUniqueArgs,  LocalRejectSettings = T["rejectOnNotFound"] extends RejectOnNotFound ? T['rejectOnNotFound'] : undefined>(
      args: SelectSubset<T, UserDetailFindUniqueArgs>
    ): HasReject<GlobalRejectSettings, LocalRejectSettings, 'findUnique', 'UserDetail'> extends True ? Prisma__UserDetailClient<UserDetailGetPayload<T>> : Prisma__UserDetailClient<UserDetailGetPayload<T> | null, null>

    /**
     * Find one UserDetail that matches the filter or throw an error  with `error.code='P2025'` 
     *     if no matches were found.
     * @param {UserDetailFindUniqueOrThrowArgs} args - Arguments to find a UserDetail
     * @example
     * // Get one UserDetail
     * const userDetail = await prisma.userDetail.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends UserDetailFindUniqueOrThrowArgs>(
      args?: SelectSubset<T, UserDetailFindUniqueOrThrowArgs>
    ): Prisma__UserDetailClient<UserDetailGetPayload<T>>

    /**
     * Find the first UserDetail that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserDetailFindFirstArgs} args - Arguments to find a UserDetail
     * @example
     * // Get one UserDetail
     * const userDetail = await prisma.userDetail.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends UserDetailFindFirstArgs,  LocalRejectSettings = T["rejectOnNotFound"] extends RejectOnNotFound ? T['rejectOnNotFound'] : undefined>(
      args?: SelectSubset<T, UserDetailFindFirstArgs>
    ): HasReject<GlobalRejectSettings, LocalRejectSettings, 'findFirst', 'UserDetail'> extends True ? Prisma__UserDetailClient<UserDetailGetPayload<T>> : Prisma__UserDetailClient<UserDetailGetPayload<T> | null, null>

    /**
     * Find the first UserDetail that matches the filter or
     * throw `NotFoundError` if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserDetailFindFirstOrThrowArgs} args - Arguments to find a UserDetail
     * @example
     * // Get one UserDetail
     * const userDetail = await prisma.userDetail.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends UserDetailFindFirstOrThrowArgs>(
      args?: SelectSubset<T, UserDetailFindFirstOrThrowArgs>
    ): Prisma__UserDetailClient<UserDetailGetPayload<T>>

    /**
     * Find zero or more UserDetails that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserDetailFindManyArgs=} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all UserDetails
     * const userDetails = await prisma.userDetail.findMany()
     * 
     * // Get first 10 UserDetails
     * const userDetails = await prisma.userDetail.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const userDetailWithIdOnly = await prisma.userDetail.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends UserDetailFindManyArgs>(
      args?: SelectSubset<T, UserDetailFindManyArgs>
    ): Prisma.PrismaPromise<Array<UserDetailGetPayload<T>>>

    /**
     * Create a UserDetail.
     * @param {UserDetailCreateArgs} args - Arguments to create a UserDetail.
     * @example
     * // Create one UserDetail
     * const UserDetail = await prisma.userDetail.create({
     *   data: {
     *     // ... data to create a UserDetail
     *   }
     * })
     * 
    **/
    create<T extends UserDetailCreateArgs>(
      args: SelectSubset<T, UserDetailCreateArgs>
    ): Prisma__UserDetailClient<UserDetailGetPayload<T>>

    /**
     * Create many UserDetails.
     *     @param {UserDetailCreateManyArgs} args - Arguments to create many UserDetails.
     *     @example
     *     // Create many UserDetails
     *     const userDetail = await prisma.userDetail.createMany({
     *       data: {
     *         // ... provide data here
     *       }
     *     })
     *     
    **/
    createMany<T extends UserDetailCreateManyArgs>(
      args?: SelectSubset<T, UserDetailCreateManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a UserDetail.
     * @param {UserDetailDeleteArgs} args - Arguments to delete one UserDetail.
     * @example
     * // Delete one UserDetail
     * const UserDetail = await prisma.userDetail.delete({
     *   where: {
     *     // ... filter to delete one UserDetail
     *   }
     * })
     * 
    **/
    delete<T extends UserDetailDeleteArgs>(
      args: SelectSubset<T, UserDetailDeleteArgs>
    ): Prisma__UserDetailClient<UserDetailGetPayload<T>>

    /**
     * Update one UserDetail.
     * @param {UserDetailUpdateArgs} args - Arguments to update one UserDetail.
     * @example
     * // Update one UserDetail
     * const userDetail = await prisma.userDetail.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends UserDetailUpdateArgs>(
      args: SelectSubset<T, UserDetailUpdateArgs>
    ): Prisma__UserDetailClient<UserDetailGetPayload<T>>

    /**
     * Delete zero or more UserDetails.
     * @param {UserDetailDeleteManyArgs} args - Arguments to filter UserDetails to delete.
     * @example
     * // Delete a few UserDetails
     * const { count } = await prisma.userDetail.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends UserDetailDeleteManyArgs>(
      args?: SelectSubset<T, UserDetailDeleteManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more UserDetails.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserDetailUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many UserDetails
     * const userDetail = await prisma.userDetail.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends UserDetailUpdateManyArgs>(
      args: SelectSubset<T, UserDetailUpdateManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one UserDetail.
     * @param {UserDetailUpsertArgs} args - Arguments to update or create a UserDetail.
     * @example
     * // Update or create a UserDetail
     * const userDetail = await prisma.userDetail.upsert({
     *   create: {
     *     // ... data to create a UserDetail
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the UserDetail we want to update
     *   }
     * })
    **/
    upsert<T extends UserDetailUpsertArgs>(
      args: SelectSubset<T, UserDetailUpsertArgs>
    ): Prisma__UserDetailClient<UserDetailGetPayload<T>>

    /**
     * Count the number of UserDetails.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserDetailCountArgs} args - Arguments to filter UserDetails to count.
     * @example
     * // Count the number of UserDetails
     * const count = await prisma.userDetail.count({
     *   where: {
     *     // ... the filter for the UserDetails we want to count
     *   }
     * })
    **/
    count<T extends UserDetailCountArgs>(
      args?: Subset<T, UserDetailCountArgs>,
    ): Prisma.PrismaPromise<
      T extends _Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], UserDetailCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a UserDetail.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserDetailAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends UserDetailAggregateArgs>(args: Subset<T, UserDetailAggregateArgs>): Prisma.PrismaPromise<GetUserDetailAggregateType<T>>

    /**
     * Group by UserDetail.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserDetailGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends UserDetailGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: UserDetailGroupByArgs['orderBy'] }
        : { orderBy?: UserDetailGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends TupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, UserDetailGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetUserDetailGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>

  }

  /**
   * The delegate class that acts as a "Promise-like" for UserDetail.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export class Prisma__UserDetailClient<T, Null = never> implements Prisma.PrismaPromise<T> {
    private readonly _dmmf;
    private readonly _queryType;
    private readonly _rootField;
    private readonly _clientMethod;
    private readonly _args;
    private readonly _dataPath;
    private readonly _errorFormat;
    private readonly _measurePerformance?;
    private _isList;
    private _callsite;
    private _requestPromise?;
    readonly [Symbol.toStringTag]: 'PrismaPromise';
    constructor(_dmmf: runtime.DMMFClass, _queryType: 'query' | 'mutation', _rootField: string, _clientMethod: string, _args: any, _dataPath: string[], _errorFormat: ErrorFormat, _measurePerformance?: boolean | undefined, _isList?: boolean);

    file<T extends FileArgs= {}>(args?: Subset<T, FileArgs>): Prisma__FileClient<FileGetPayload<T> | Null>;

    user<T extends UserArgs= {}>(args?: Subset<T, UserArgs>): Prisma__UserClient<UserGetPayload<T> | Null>;

    manager<T extends UserArgs= {}>(args?: Subset<T, UserArgs>): Prisma__UserClient<UserGetPayload<T> | Null>;

    private get _document();
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): Promise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): Promise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): Promise<T>;
  }



  // Custom InputTypes

  /**
   * UserDetail base type for findUnique actions
   */
  export type UserDetailFindUniqueArgsBase = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserDetailInclude | null
    /**
     * Filter, which UserDetail to fetch.
     */
    where: UserDetailWhereUniqueInput
  }

  /**
   * UserDetail findUnique
   */
  export interface UserDetailFindUniqueArgs extends UserDetailFindUniqueArgsBase {
   /**
    * Throw an Error if query returns no results
    * @deprecated since 4.0.0: use `findUniqueOrThrow` method instead
    */
    rejectOnNotFound?: RejectOnNotFound
  }
      

  /**
   * UserDetail findUniqueOrThrow
   */
  export type UserDetailFindUniqueOrThrowArgs = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserDetailInclude | null
    /**
     * Filter, which UserDetail to fetch.
     */
    where: UserDetailWhereUniqueInput
  }


  /**
   * UserDetail base type for findFirst actions
   */
  export type UserDetailFindFirstArgsBase = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserDetailInclude | null
    /**
     * Filter, which UserDetail to fetch.
     */
    where?: UserDetailWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserDetails to fetch.
     */
    orderBy?: Enumerable<UserDetailOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for UserDetails.
     */
    cursor?: UserDetailWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserDetails from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserDetails.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of UserDetails.
     */
    distinct?: Enumerable<UserDetailScalarFieldEnum>
  }

  /**
   * UserDetail findFirst
   */
  export interface UserDetailFindFirstArgs extends UserDetailFindFirstArgsBase {
   /**
    * Throw an Error if query returns no results
    * @deprecated since 4.0.0: use `findFirstOrThrow` method instead
    */
    rejectOnNotFound?: RejectOnNotFound
  }
      

  /**
   * UserDetail findFirstOrThrow
   */
  export type UserDetailFindFirstOrThrowArgs = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserDetailInclude | null
    /**
     * Filter, which UserDetail to fetch.
     */
    where?: UserDetailWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserDetails to fetch.
     */
    orderBy?: Enumerable<UserDetailOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for UserDetails.
     */
    cursor?: UserDetailWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserDetails from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserDetails.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of UserDetails.
     */
    distinct?: Enumerable<UserDetailScalarFieldEnum>
  }


  /**
   * UserDetail findMany
   */
  export type UserDetailFindManyArgs = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserDetailInclude | null
    /**
     * Filter, which UserDetails to fetch.
     */
    where?: UserDetailWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserDetails to fetch.
     */
    orderBy?: Enumerable<UserDetailOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing UserDetails.
     */
    cursor?: UserDetailWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserDetails from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserDetails.
     */
    skip?: number
    distinct?: Enumerable<UserDetailScalarFieldEnum>
  }


  /**
   * UserDetail create
   */
  export type UserDetailCreateArgs = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserDetailInclude | null
    /**
     * The data needed to create a UserDetail.
     */
    data: XOR<UserDetailCreateInput, UserDetailUncheckedCreateInput>
  }


  /**
   * UserDetail createMany
   */
  export type UserDetailCreateManyArgs = {
    /**
     * The data used to create many UserDetails.
     */
    data: Enumerable<UserDetailCreateManyInput>
    skipDuplicates?: boolean
  }


  /**
   * UserDetail update
   */
  export type UserDetailUpdateArgs = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserDetailInclude | null
    /**
     * The data needed to update a UserDetail.
     */
    data: XOR<UserDetailUpdateInput, UserDetailUncheckedUpdateInput>
    /**
     * Choose, which UserDetail to update.
     */
    where: UserDetailWhereUniqueInput
  }


  /**
   * UserDetail updateMany
   */
  export type UserDetailUpdateManyArgs = {
    /**
     * The data used to update UserDetails.
     */
    data: XOR<UserDetailUpdateManyMutationInput, UserDetailUncheckedUpdateManyInput>
    /**
     * Filter which UserDetails to update
     */
    where?: UserDetailWhereInput
  }


  /**
   * UserDetail upsert
   */
  export type UserDetailUpsertArgs = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserDetailInclude | null
    /**
     * The filter to search for the UserDetail to update in case it exists.
     */
    where: UserDetailWhereUniqueInput
    /**
     * In case the UserDetail found by the `where` argument doesn't exist, create a new UserDetail with this data.
     */
    create: XOR<UserDetailCreateInput, UserDetailUncheckedCreateInput>
    /**
     * In case the UserDetail was found with the provided `where` argument, update it with this data.
     */
    update: XOR<UserDetailUpdateInput, UserDetailUncheckedUpdateInput>
  }


  /**
   * UserDetail delete
   */
  export type UserDetailDeleteArgs = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserDetailInclude | null
    /**
     * Filter which UserDetail to delete.
     */
    where: UserDetailWhereUniqueInput
  }


  /**
   * UserDetail deleteMany
   */
  export type UserDetailDeleteManyArgs = {
    /**
     * Filter which UserDetails to delete
     */
    where?: UserDetailWhereInput
  }


  /**
   * UserDetail without action
   */
  export type UserDetailArgs = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserDetailInclude | null
  }



  /**
   * Model ResetPassowrd
   */


  export type AggregateResetPassowrd = {
    _count: ResetPassowrdCountAggregateOutputType | null
    _min: ResetPassowrdMinAggregateOutputType | null
    _max: ResetPassowrdMaxAggregateOutputType | null
  }

  export type ResetPassowrdMinAggregateOutputType = {
    email: string | null
    token: string | null
    createdAt: Date | null
  }

  export type ResetPassowrdMaxAggregateOutputType = {
    email: string | null
    token: string | null
    createdAt: Date | null
  }

  export type ResetPassowrdCountAggregateOutputType = {
    email: number
    token: number
    createdAt: number
    _all: number
  }


  export type ResetPassowrdMinAggregateInputType = {
    email?: true
    token?: true
    createdAt?: true
  }

  export type ResetPassowrdMaxAggregateInputType = {
    email?: true
    token?: true
    createdAt?: true
  }

  export type ResetPassowrdCountAggregateInputType = {
    email?: true
    token?: true
    createdAt?: true
    _all?: true
  }

  export type ResetPassowrdAggregateArgs = {
    /**
     * Filter which ResetPassowrd to aggregate.
     */
    where?: ResetPassowrdWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ResetPassowrds to fetch.
     */
    orderBy?: Enumerable<ResetPassowrdOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ResetPassowrdWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ResetPassowrds from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ResetPassowrds.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned ResetPassowrds
    **/
    _count?: true | ResetPassowrdCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ResetPassowrdMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ResetPassowrdMaxAggregateInputType
  }

  export type GetResetPassowrdAggregateType<T extends ResetPassowrdAggregateArgs> = {
        [P in keyof T & keyof AggregateResetPassowrd]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateResetPassowrd[P]>
      : GetScalarType<T[P], AggregateResetPassowrd[P]>
  }




  export type ResetPassowrdGroupByArgs = {
    where?: ResetPassowrdWhereInput
    orderBy?: Enumerable<ResetPassowrdOrderByWithAggregationInput>
    by: ResetPassowrdScalarFieldEnum[]
    having?: ResetPassowrdScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ResetPassowrdCountAggregateInputType | true
    _min?: ResetPassowrdMinAggregateInputType
    _max?: ResetPassowrdMaxAggregateInputType
  }


  export type ResetPassowrdGroupByOutputType = {
    email: string
    token: string
    createdAt: Date
    _count: ResetPassowrdCountAggregateOutputType | null
    _min: ResetPassowrdMinAggregateOutputType | null
    _max: ResetPassowrdMaxAggregateOutputType | null
  }

  type GetResetPassowrdGroupByPayload<T extends ResetPassowrdGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickArray<ResetPassowrdGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ResetPassowrdGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ResetPassowrdGroupByOutputType[P]>
            : GetScalarType<T[P], ResetPassowrdGroupByOutputType[P]>
        }
      >
    >


  export type ResetPassowrdSelect = {
    email?: boolean
    token?: boolean
    createdAt?: boolean
    user?: boolean | UserArgs
  }


  export type ResetPassowrdInclude = {
    user?: boolean | UserArgs
  }

  export type ResetPassowrdGetPayload<S extends boolean | null | undefined | ResetPassowrdArgs> =
    S extends { select: any, include: any } ? 'Please either choose `select` or `include`' :
    S extends true ? ResetPassowrd :
    S extends undefined ? never :
    S extends { include: any } & (ResetPassowrdArgs | ResetPassowrdFindManyArgs)
    ? ResetPassowrd  & {
    [P in TruthyKeys<S['include']>]:
        P extends 'user' ? UserGetPayload<S['include'][P]> :  never
  } 
    : S extends { select: any } & (ResetPassowrdArgs | ResetPassowrdFindManyArgs)
      ? {
    [P in TruthyKeys<S['select']>]:
        P extends 'user' ? UserGetPayload<S['select'][P]> :  P extends keyof ResetPassowrd ? ResetPassowrd[P] : never
  } 
      : ResetPassowrd


  type ResetPassowrdCountArgs = 
    Omit<ResetPassowrdFindManyArgs, 'select' | 'include'> & {
      select?: ResetPassowrdCountAggregateInputType | true
    }

  export interface ResetPassowrdDelegate<GlobalRejectSettings extends Prisma.RejectOnNotFound | Prisma.RejectPerOperation | false | undefined> {

    /**
     * Find zero or one ResetPassowrd that matches the filter.
     * @param {ResetPassowrdFindUniqueArgs} args - Arguments to find a ResetPassowrd
     * @example
     * // Get one ResetPassowrd
     * const resetPassowrd = await prisma.resetPassowrd.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends ResetPassowrdFindUniqueArgs,  LocalRejectSettings = T["rejectOnNotFound"] extends RejectOnNotFound ? T['rejectOnNotFound'] : undefined>(
      args: SelectSubset<T, ResetPassowrdFindUniqueArgs>
    ): HasReject<GlobalRejectSettings, LocalRejectSettings, 'findUnique', 'ResetPassowrd'> extends True ? Prisma__ResetPassowrdClient<ResetPassowrdGetPayload<T>> : Prisma__ResetPassowrdClient<ResetPassowrdGetPayload<T> | null, null>

    /**
     * Find one ResetPassowrd that matches the filter or throw an error  with `error.code='P2025'` 
     *     if no matches were found.
     * @param {ResetPassowrdFindUniqueOrThrowArgs} args - Arguments to find a ResetPassowrd
     * @example
     * // Get one ResetPassowrd
     * const resetPassowrd = await prisma.resetPassowrd.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends ResetPassowrdFindUniqueOrThrowArgs>(
      args?: SelectSubset<T, ResetPassowrdFindUniqueOrThrowArgs>
    ): Prisma__ResetPassowrdClient<ResetPassowrdGetPayload<T>>

    /**
     * Find the first ResetPassowrd that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ResetPassowrdFindFirstArgs} args - Arguments to find a ResetPassowrd
     * @example
     * // Get one ResetPassowrd
     * const resetPassowrd = await prisma.resetPassowrd.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends ResetPassowrdFindFirstArgs,  LocalRejectSettings = T["rejectOnNotFound"] extends RejectOnNotFound ? T['rejectOnNotFound'] : undefined>(
      args?: SelectSubset<T, ResetPassowrdFindFirstArgs>
    ): HasReject<GlobalRejectSettings, LocalRejectSettings, 'findFirst', 'ResetPassowrd'> extends True ? Prisma__ResetPassowrdClient<ResetPassowrdGetPayload<T>> : Prisma__ResetPassowrdClient<ResetPassowrdGetPayload<T> | null, null>

    /**
     * Find the first ResetPassowrd that matches the filter or
     * throw `NotFoundError` if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ResetPassowrdFindFirstOrThrowArgs} args - Arguments to find a ResetPassowrd
     * @example
     * // Get one ResetPassowrd
     * const resetPassowrd = await prisma.resetPassowrd.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends ResetPassowrdFindFirstOrThrowArgs>(
      args?: SelectSubset<T, ResetPassowrdFindFirstOrThrowArgs>
    ): Prisma__ResetPassowrdClient<ResetPassowrdGetPayload<T>>

    /**
     * Find zero or more ResetPassowrds that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ResetPassowrdFindManyArgs=} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all ResetPassowrds
     * const resetPassowrds = await prisma.resetPassowrd.findMany()
     * 
     * // Get first 10 ResetPassowrds
     * const resetPassowrds = await prisma.resetPassowrd.findMany({ take: 10 })
     * 
     * // Only select the `email`
     * const resetPassowrdWithEmailOnly = await prisma.resetPassowrd.findMany({ select: { email: true } })
     * 
    **/
    findMany<T extends ResetPassowrdFindManyArgs>(
      args?: SelectSubset<T, ResetPassowrdFindManyArgs>
    ): Prisma.PrismaPromise<Array<ResetPassowrdGetPayload<T>>>

    /**
     * Create a ResetPassowrd.
     * @param {ResetPassowrdCreateArgs} args - Arguments to create a ResetPassowrd.
     * @example
     * // Create one ResetPassowrd
     * const ResetPassowrd = await prisma.resetPassowrd.create({
     *   data: {
     *     // ... data to create a ResetPassowrd
     *   }
     * })
     * 
    **/
    create<T extends ResetPassowrdCreateArgs>(
      args: SelectSubset<T, ResetPassowrdCreateArgs>
    ): Prisma__ResetPassowrdClient<ResetPassowrdGetPayload<T>>

    /**
     * Create many ResetPassowrds.
     *     @param {ResetPassowrdCreateManyArgs} args - Arguments to create many ResetPassowrds.
     *     @example
     *     // Create many ResetPassowrds
     *     const resetPassowrd = await prisma.resetPassowrd.createMany({
     *       data: {
     *         // ... provide data here
     *       }
     *     })
     *     
    **/
    createMany<T extends ResetPassowrdCreateManyArgs>(
      args?: SelectSubset<T, ResetPassowrdCreateManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a ResetPassowrd.
     * @param {ResetPassowrdDeleteArgs} args - Arguments to delete one ResetPassowrd.
     * @example
     * // Delete one ResetPassowrd
     * const ResetPassowrd = await prisma.resetPassowrd.delete({
     *   where: {
     *     // ... filter to delete one ResetPassowrd
     *   }
     * })
     * 
    **/
    delete<T extends ResetPassowrdDeleteArgs>(
      args: SelectSubset<T, ResetPassowrdDeleteArgs>
    ): Prisma__ResetPassowrdClient<ResetPassowrdGetPayload<T>>

    /**
     * Update one ResetPassowrd.
     * @param {ResetPassowrdUpdateArgs} args - Arguments to update one ResetPassowrd.
     * @example
     * // Update one ResetPassowrd
     * const resetPassowrd = await prisma.resetPassowrd.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends ResetPassowrdUpdateArgs>(
      args: SelectSubset<T, ResetPassowrdUpdateArgs>
    ): Prisma__ResetPassowrdClient<ResetPassowrdGetPayload<T>>

    /**
     * Delete zero or more ResetPassowrds.
     * @param {ResetPassowrdDeleteManyArgs} args - Arguments to filter ResetPassowrds to delete.
     * @example
     * // Delete a few ResetPassowrds
     * const { count } = await prisma.resetPassowrd.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends ResetPassowrdDeleteManyArgs>(
      args?: SelectSubset<T, ResetPassowrdDeleteManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more ResetPassowrds.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ResetPassowrdUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many ResetPassowrds
     * const resetPassowrd = await prisma.resetPassowrd.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends ResetPassowrdUpdateManyArgs>(
      args: SelectSubset<T, ResetPassowrdUpdateManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one ResetPassowrd.
     * @param {ResetPassowrdUpsertArgs} args - Arguments to update or create a ResetPassowrd.
     * @example
     * // Update or create a ResetPassowrd
     * const resetPassowrd = await prisma.resetPassowrd.upsert({
     *   create: {
     *     // ... data to create a ResetPassowrd
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the ResetPassowrd we want to update
     *   }
     * })
    **/
    upsert<T extends ResetPassowrdUpsertArgs>(
      args: SelectSubset<T, ResetPassowrdUpsertArgs>
    ): Prisma__ResetPassowrdClient<ResetPassowrdGetPayload<T>>

    /**
     * Count the number of ResetPassowrds.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ResetPassowrdCountArgs} args - Arguments to filter ResetPassowrds to count.
     * @example
     * // Count the number of ResetPassowrds
     * const count = await prisma.resetPassowrd.count({
     *   where: {
     *     // ... the filter for the ResetPassowrds we want to count
     *   }
     * })
    **/
    count<T extends ResetPassowrdCountArgs>(
      args?: Subset<T, ResetPassowrdCountArgs>,
    ): Prisma.PrismaPromise<
      T extends _Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ResetPassowrdCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a ResetPassowrd.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ResetPassowrdAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ResetPassowrdAggregateArgs>(args: Subset<T, ResetPassowrdAggregateArgs>): Prisma.PrismaPromise<GetResetPassowrdAggregateType<T>>

    /**
     * Group by ResetPassowrd.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ResetPassowrdGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ResetPassowrdGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ResetPassowrdGroupByArgs['orderBy'] }
        : { orderBy?: ResetPassowrdGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends TupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ResetPassowrdGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetResetPassowrdGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>

  }

  /**
   * The delegate class that acts as a "Promise-like" for ResetPassowrd.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export class Prisma__ResetPassowrdClient<T, Null = never> implements Prisma.PrismaPromise<T> {
    private readonly _dmmf;
    private readonly _queryType;
    private readonly _rootField;
    private readonly _clientMethod;
    private readonly _args;
    private readonly _dataPath;
    private readonly _errorFormat;
    private readonly _measurePerformance?;
    private _isList;
    private _callsite;
    private _requestPromise?;
    readonly [Symbol.toStringTag]: 'PrismaPromise';
    constructor(_dmmf: runtime.DMMFClass, _queryType: 'query' | 'mutation', _rootField: string, _clientMethod: string, _args: any, _dataPath: string[], _errorFormat: ErrorFormat, _measurePerformance?: boolean | undefined, _isList?: boolean);

    user<T extends UserArgs= {}>(args?: Subset<T, UserArgs>): Prisma__UserClient<UserGetPayload<T> | Null>;

    private get _document();
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): Promise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): Promise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): Promise<T>;
  }



  // Custom InputTypes

  /**
   * ResetPassowrd base type for findUnique actions
   */
  export type ResetPassowrdFindUniqueArgsBase = {
    /**
     * Select specific fields to fetch from the ResetPassowrd
     */
    select?: ResetPassowrdSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ResetPassowrdInclude | null
    /**
     * Filter, which ResetPassowrd to fetch.
     */
    where: ResetPassowrdWhereUniqueInput
  }

  /**
   * ResetPassowrd findUnique
   */
  export interface ResetPassowrdFindUniqueArgs extends ResetPassowrdFindUniqueArgsBase {
   /**
    * Throw an Error if query returns no results
    * @deprecated since 4.0.0: use `findUniqueOrThrow` method instead
    */
    rejectOnNotFound?: RejectOnNotFound
  }
      

  /**
   * ResetPassowrd findUniqueOrThrow
   */
  export type ResetPassowrdFindUniqueOrThrowArgs = {
    /**
     * Select specific fields to fetch from the ResetPassowrd
     */
    select?: ResetPassowrdSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ResetPassowrdInclude | null
    /**
     * Filter, which ResetPassowrd to fetch.
     */
    where: ResetPassowrdWhereUniqueInput
  }


  /**
   * ResetPassowrd base type for findFirst actions
   */
  export type ResetPassowrdFindFirstArgsBase = {
    /**
     * Select specific fields to fetch from the ResetPassowrd
     */
    select?: ResetPassowrdSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ResetPassowrdInclude | null
    /**
     * Filter, which ResetPassowrd to fetch.
     */
    where?: ResetPassowrdWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ResetPassowrds to fetch.
     */
    orderBy?: Enumerable<ResetPassowrdOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ResetPassowrds.
     */
    cursor?: ResetPassowrdWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ResetPassowrds from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ResetPassowrds.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ResetPassowrds.
     */
    distinct?: Enumerable<ResetPassowrdScalarFieldEnum>
  }

  /**
   * ResetPassowrd findFirst
   */
  export interface ResetPassowrdFindFirstArgs extends ResetPassowrdFindFirstArgsBase {
   /**
    * Throw an Error if query returns no results
    * @deprecated since 4.0.0: use `findFirstOrThrow` method instead
    */
    rejectOnNotFound?: RejectOnNotFound
  }
      

  /**
   * ResetPassowrd findFirstOrThrow
   */
  export type ResetPassowrdFindFirstOrThrowArgs = {
    /**
     * Select specific fields to fetch from the ResetPassowrd
     */
    select?: ResetPassowrdSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ResetPassowrdInclude | null
    /**
     * Filter, which ResetPassowrd to fetch.
     */
    where?: ResetPassowrdWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ResetPassowrds to fetch.
     */
    orderBy?: Enumerable<ResetPassowrdOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ResetPassowrds.
     */
    cursor?: ResetPassowrdWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ResetPassowrds from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ResetPassowrds.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ResetPassowrds.
     */
    distinct?: Enumerable<ResetPassowrdScalarFieldEnum>
  }


  /**
   * ResetPassowrd findMany
   */
  export type ResetPassowrdFindManyArgs = {
    /**
     * Select specific fields to fetch from the ResetPassowrd
     */
    select?: ResetPassowrdSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ResetPassowrdInclude | null
    /**
     * Filter, which ResetPassowrds to fetch.
     */
    where?: ResetPassowrdWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ResetPassowrds to fetch.
     */
    orderBy?: Enumerable<ResetPassowrdOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing ResetPassowrds.
     */
    cursor?: ResetPassowrdWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ResetPassowrds from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ResetPassowrds.
     */
    skip?: number
    distinct?: Enumerable<ResetPassowrdScalarFieldEnum>
  }


  /**
   * ResetPassowrd create
   */
  export type ResetPassowrdCreateArgs = {
    /**
     * Select specific fields to fetch from the ResetPassowrd
     */
    select?: ResetPassowrdSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ResetPassowrdInclude | null
    /**
     * The data needed to create a ResetPassowrd.
     */
    data: XOR<ResetPassowrdCreateInput, ResetPassowrdUncheckedCreateInput>
  }


  /**
   * ResetPassowrd createMany
   */
  export type ResetPassowrdCreateManyArgs = {
    /**
     * The data used to create many ResetPassowrds.
     */
    data: Enumerable<ResetPassowrdCreateManyInput>
    skipDuplicates?: boolean
  }


  /**
   * ResetPassowrd update
   */
  export type ResetPassowrdUpdateArgs = {
    /**
     * Select specific fields to fetch from the ResetPassowrd
     */
    select?: ResetPassowrdSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ResetPassowrdInclude | null
    /**
     * The data needed to update a ResetPassowrd.
     */
    data: XOR<ResetPassowrdUpdateInput, ResetPassowrdUncheckedUpdateInput>
    /**
     * Choose, which ResetPassowrd to update.
     */
    where: ResetPassowrdWhereUniqueInput
  }


  /**
   * ResetPassowrd updateMany
   */
  export type ResetPassowrdUpdateManyArgs = {
    /**
     * The data used to update ResetPassowrds.
     */
    data: XOR<ResetPassowrdUpdateManyMutationInput, ResetPassowrdUncheckedUpdateManyInput>
    /**
     * Filter which ResetPassowrds to update
     */
    where?: ResetPassowrdWhereInput
  }


  /**
   * ResetPassowrd upsert
   */
  export type ResetPassowrdUpsertArgs = {
    /**
     * Select specific fields to fetch from the ResetPassowrd
     */
    select?: ResetPassowrdSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ResetPassowrdInclude | null
    /**
     * The filter to search for the ResetPassowrd to update in case it exists.
     */
    where: ResetPassowrdWhereUniqueInput
    /**
     * In case the ResetPassowrd found by the `where` argument doesn't exist, create a new ResetPassowrd with this data.
     */
    create: XOR<ResetPassowrdCreateInput, ResetPassowrdUncheckedCreateInput>
    /**
     * In case the ResetPassowrd was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ResetPassowrdUpdateInput, ResetPassowrdUncheckedUpdateInput>
  }


  /**
   * ResetPassowrd delete
   */
  export type ResetPassowrdDeleteArgs = {
    /**
     * Select specific fields to fetch from the ResetPassowrd
     */
    select?: ResetPassowrdSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ResetPassowrdInclude | null
    /**
     * Filter which ResetPassowrd to delete.
     */
    where: ResetPassowrdWhereUniqueInput
  }


  /**
   * ResetPassowrd deleteMany
   */
  export type ResetPassowrdDeleteManyArgs = {
    /**
     * Filter which ResetPassowrds to delete
     */
    where?: ResetPassowrdWhereInput
  }


  /**
   * ResetPassowrd without action
   */
  export type ResetPassowrdArgs = {
    /**
     * Select specific fields to fetch from the ResetPassowrd
     */
    select?: ResetPassowrdSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ResetPassowrdInclude | null
  }



  /**
   * Model Role
   */


  export type AggregateRole = {
    _count: RoleCountAggregateOutputType | null
    _min: RoleMinAggregateOutputType | null
    _max: RoleMaxAggregateOutputType | null
  }

  export type RoleMinAggregateOutputType = {
    id: string | null
    name: string | null
    description: string | null
  }

  export type RoleMaxAggregateOutputType = {
    id: string | null
    name: string | null
    description: string | null
  }

  export type RoleCountAggregateOutputType = {
    id: number
    name: number
    description: number
    _all: number
  }


  export type RoleMinAggregateInputType = {
    id?: true
    name?: true
    description?: true
  }

  export type RoleMaxAggregateInputType = {
    id?: true
    name?: true
    description?: true
  }

  export type RoleCountAggregateInputType = {
    id?: true
    name?: true
    description?: true
    _all?: true
  }

  export type RoleAggregateArgs = {
    /**
     * Filter which Role to aggregate.
     */
    where?: RoleWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Roles to fetch.
     */
    orderBy?: Enumerable<RoleOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: RoleWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Roles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Roles.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Roles
    **/
    _count?: true | RoleCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: RoleMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: RoleMaxAggregateInputType
  }

  export type GetRoleAggregateType<T extends RoleAggregateArgs> = {
        [P in keyof T & keyof AggregateRole]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateRole[P]>
      : GetScalarType<T[P], AggregateRole[P]>
  }




  export type RoleGroupByArgs = {
    where?: RoleWhereInput
    orderBy?: Enumerable<RoleOrderByWithAggregationInput>
    by: RoleScalarFieldEnum[]
    having?: RoleScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: RoleCountAggregateInputType | true
    _min?: RoleMinAggregateInputType
    _max?: RoleMaxAggregateInputType
  }


  export type RoleGroupByOutputType = {
    id: string
    name: string
    description: string | null
    _count: RoleCountAggregateOutputType | null
    _min: RoleMinAggregateOutputType | null
    _max: RoleMaxAggregateOutputType | null
  }

  type GetRoleGroupByPayload<T extends RoleGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickArray<RoleGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof RoleGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], RoleGroupByOutputType[P]>
            : GetScalarType<T[P], RoleGroupByOutputType[P]>
        }
      >
    >


  export type RoleSelect = {
    id?: boolean
    name?: boolean
    description?: boolean
    PermissionsOnRole?: boolean | Role$PermissionsOnRoleArgs
    User?: boolean | Role$UserArgs
    _count?: boolean | RoleCountOutputTypeArgs
  }


  export type RoleInclude = {
    PermissionsOnRole?: boolean | Role$PermissionsOnRoleArgs
    User?: boolean | Role$UserArgs
    _count?: boolean | RoleCountOutputTypeArgs
  }

  export type RoleGetPayload<S extends boolean | null | undefined | RoleArgs> =
    S extends { select: any, include: any } ? 'Please either choose `select` or `include`' :
    S extends true ? Role :
    S extends undefined ? never :
    S extends { include: any } & (RoleArgs | RoleFindManyArgs)
    ? Role  & {
    [P in TruthyKeys<S['include']>]:
        P extends 'PermissionsOnRole' ? Array < PermissionsOnRoleGetPayload<S['include'][P]>>  :
        P extends 'User' ? Array < UserGetPayload<S['include'][P]>>  :
        P extends '_count' ? RoleCountOutputTypeGetPayload<S['include'][P]> :  never
  } 
    : S extends { select: any } & (RoleArgs | RoleFindManyArgs)
      ? {
    [P in TruthyKeys<S['select']>]:
        P extends 'PermissionsOnRole' ? Array < PermissionsOnRoleGetPayload<S['select'][P]>>  :
        P extends 'User' ? Array < UserGetPayload<S['select'][P]>>  :
        P extends '_count' ? RoleCountOutputTypeGetPayload<S['select'][P]> :  P extends keyof Role ? Role[P] : never
  } 
      : Role


  type RoleCountArgs = 
    Omit<RoleFindManyArgs, 'select' | 'include'> & {
      select?: RoleCountAggregateInputType | true
    }

  export interface RoleDelegate<GlobalRejectSettings extends Prisma.RejectOnNotFound | Prisma.RejectPerOperation | false | undefined> {

    /**
     * Find zero or one Role that matches the filter.
     * @param {RoleFindUniqueArgs} args - Arguments to find a Role
     * @example
     * // Get one Role
     * const role = await prisma.role.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends RoleFindUniqueArgs,  LocalRejectSettings = T["rejectOnNotFound"] extends RejectOnNotFound ? T['rejectOnNotFound'] : undefined>(
      args: SelectSubset<T, RoleFindUniqueArgs>
    ): HasReject<GlobalRejectSettings, LocalRejectSettings, 'findUnique', 'Role'> extends True ? Prisma__RoleClient<RoleGetPayload<T>> : Prisma__RoleClient<RoleGetPayload<T> | null, null>

    /**
     * Find one Role that matches the filter or throw an error  with `error.code='P2025'` 
     *     if no matches were found.
     * @param {RoleFindUniqueOrThrowArgs} args - Arguments to find a Role
     * @example
     * // Get one Role
     * const role = await prisma.role.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends RoleFindUniqueOrThrowArgs>(
      args?: SelectSubset<T, RoleFindUniqueOrThrowArgs>
    ): Prisma__RoleClient<RoleGetPayload<T>>

    /**
     * Find the first Role that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RoleFindFirstArgs} args - Arguments to find a Role
     * @example
     * // Get one Role
     * const role = await prisma.role.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends RoleFindFirstArgs,  LocalRejectSettings = T["rejectOnNotFound"] extends RejectOnNotFound ? T['rejectOnNotFound'] : undefined>(
      args?: SelectSubset<T, RoleFindFirstArgs>
    ): HasReject<GlobalRejectSettings, LocalRejectSettings, 'findFirst', 'Role'> extends True ? Prisma__RoleClient<RoleGetPayload<T>> : Prisma__RoleClient<RoleGetPayload<T> | null, null>

    /**
     * Find the first Role that matches the filter or
     * throw `NotFoundError` if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RoleFindFirstOrThrowArgs} args - Arguments to find a Role
     * @example
     * // Get one Role
     * const role = await prisma.role.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends RoleFindFirstOrThrowArgs>(
      args?: SelectSubset<T, RoleFindFirstOrThrowArgs>
    ): Prisma__RoleClient<RoleGetPayload<T>>

    /**
     * Find zero or more Roles that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RoleFindManyArgs=} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Roles
     * const roles = await prisma.role.findMany()
     * 
     * // Get first 10 Roles
     * const roles = await prisma.role.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const roleWithIdOnly = await prisma.role.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends RoleFindManyArgs>(
      args?: SelectSubset<T, RoleFindManyArgs>
    ): Prisma.PrismaPromise<Array<RoleGetPayload<T>>>

    /**
     * Create a Role.
     * @param {RoleCreateArgs} args - Arguments to create a Role.
     * @example
     * // Create one Role
     * const Role = await prisma.role.create({
     *   data: {
     *     // ... data to create a Role
     *   }
     * })
     * 
    **/
    create<T extends RoleCreateArgs>(
      args: SelectSubset<T, RoleCreateArgs>
    ): Prisma__RoleClient<RoleGetPayload<T>>

    /**
     * Create many Roles.
     *     @param {RoleCreateManyArgs} args - Arguments to create many Roles.
     *     @example
     *     // Create many Roles
     *     const role = await prisma.role.createMany({
     *       data: {
     *         // ... provide data here
     *       }
     *     })
     *     
    **/
    createMany<T extends RoleCreateManyArgs>(
      args?: SelectSubset<T, RoleCreateManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Role.
     * @param {RoleDeleteArgs} args - Arguments to delete one Role.
     * @example
     * // Delete one Role
     * const Role = await prisma.role.delete({
     *   where: {
     *     // ... filter to delete one Role
     *   }
     * })
     * 
    **/
    delete<T extends RoleDeleteArgs>(
      args: SelectSubset<T, RoleDeleteArgs>
    ): Prisma__RoleClient<RoleGetPayload<T>>

    /**
     * Update one Role.
     * @param {RoleUpdateArgs} args - Arguments to update one Role.
     * @example
     * // Update one Role
     * const role = await prisma.role.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends RoleUpdateArgs>(
      args: SelectSubset<T, RoleUpdateArgs>
    ): Prisma__RoleClient<RoleGetPayload<T>>

    /**
     * Delete zero or more Roles.
     * @param {RoleDeleteManyArgs} args - Arguments to filter Roles to delete.
     * @example
     * // Delete a few Roles
     * const { count } = await prisma.role.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends RoleDeleteManyArgs>(
      args?: SelectSubset<T, RoleDeleteManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Roles.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RoleUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Roles
     * const role = await prisma.role.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends RoleUpdateManyArgs>(
      args: SelectSubset<T, RoleUpdateManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Role.
     * @param {RoleUpsertArgs} args - Arguments to update or create a Role.
     * @example
     * // Update or create a Role
     * const role = await prisma.role.upsert({
     *   create: {
     *     // ... data to create a Role
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Role we want to update
     *   }
     * })
    **/
    upsert<T extends RoleUpsertArgs>(
      args: SelectSubset<T, RoleUpsertArgs>
    ): Prisma__RoleClient<RoleGetPayload<T>>

    /**
     * Count the number of Roles.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RoleCountArgs} args - Arguments to filter Roles to count.
     * @example
     * // Count the number of Roles
     * const count = await prisma.role.count({
     *   where: {
     *     // ... the filter for the Roles we want to count
     *   }
     * })
    **/
    count<T extends RoleCountArgs>(
      args?: Subset<T, RoleCountArgs>,
    ): Prisma.PrismaPromise<
      T extends _Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], RoleCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Role.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RoleAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends RoleAggregateArgs>(args: Subset<T, RoleAggregateArgs>): Prisma.PrismaPromise<GetRoleAggregateType<T>>

    /**
     * Group by Role.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RoleGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends RoleGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: RoleGroupByArgs['orderBy'] }
        : { orderBy?: RoleGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends TupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, RoleGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetRoleGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>

  }

  /**
   * The delegate class that acts as a "Promise-like" for Role.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export class Prisma__RoleClient<T, Null = never> implements Prisma.PrismaPromise<T> {
    private readonly _dmmf;
    private readonly _queryType;
    private readonly _rootField;
    private readonly _clientMethod;
    private readonly _args;
    private readonly _dataPath;
    private readonly _errorFormat;
    private readonly _measurePerformance?;
    private _isList;
    private _callsite;
    private _requestPromise?;
    readonly [Symbol.toStringTag]: 'PrismaPromise';
    constructor(_dmmf: runtime.DMMFClass, _queryType: 'query' | 'mutation', _rootField: string, _clientMethod: string, _args: any, _dataPath: string[], _errorFormat: ErrorFormat, _measurePerformance?: boolean | undefined, _isList?: boolean);

    PermissionsOnRole<T extends Role$PermissionsOnRoleArgs= {}>(args?: Subset<T, Role$PermissionsOnRoleArgs>): Prisma.PrismaPromise<Array<PermissionsOnRoleGetPayload<T>>| Null>;

    User<T extends Role$UserArgs= {}>(args?: Subset<T, Role$UserArgs>): Prisma.PrismaPromise<Array<UserGetPayload<T>>| Null>;

    private get _document();
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): Promise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): Promise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): Promise<T>;
  }



  // Custom InputTypes

  /**
   * Role base type for findUnique actions
   */
  export type RoleFindUniqueArgsBase = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: RoleInclude | null
    /**
     * Filter, which Role to fetch.
     */
    where: RoleWhereUniqueInput
  }

  /**
   * Role findUnique
   */
  export interface RoleFindUniqueArgs extends RoleFindUniqueArgsBase {
   /**
    * Throw an Error if query returns no results
    * @deprecated since 4.0.0: use `findUniqueOrThrow` method instead
    */
    rejectOnNotFound?: RejectOnNotFound
  }
      

  /**
   * Role findUniqueOrThrow
   */
  export type RoleFindUniqueOrThrowArgs = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: RoleInclude | null
    /**
     * Filter, which Role to fetch.
     */
    where: RoleWhereUniqueInput
  }


  /**
   * Role base type for findFirst actions
   */
  export type RoleFindFirstArgsBase = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: RoleInclude | null
    /**
     * Filter, which Role to fetch.
     */
    where?: RoleWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Roles to fetch.
     */
    orderBy?: Enumerable<RoleOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Roles.
     */
    cursor?: RoleWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Roles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Roles.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Roles.
     */
    distinct?: Enumerable<RoleScalarFieldEnum>
  }

  /**
   * Role findFirst
   */
  export interface RoleFindFirstArgs extends RoleFindFirstArgsBase {
   /**
    * Throw an Error if query returns no results
    * @deprecated since 4.0.0: use `findFirstOrThrow` method instead
    */
    rejectOnNotFound?: RejectOnNotFound
  }
      

  /**
   * Role findFirstOrThrow
   */
  export type RoleFindFirstOrThrowArgs = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: RoleInclude | null
    /**
     * Filter, which Role to fetch.
     */
    where?: RoleWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Roles to fetch.
     */
    orderBy?: Enumerable<RoleOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Roles.
     */
    cursor?: RoleWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Roles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Roles.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Roles.
     */
    distinct?: Enumerable<RoleScalarFieldEnum>
  }


  /**
   * Role findMany
   */
  export type RoleFindManyArgs = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: RoleInclude | null
    /**
     * Filter, which Roles to fetch.
     */
    where?: RoleWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Roles to fetch.
     */
    orderBy?: Enumerable<RoleOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Roles.
     */
    cursor?: RoleWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Roles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Roles.
     */
    skip?: number
    distinct?: Enumerable<RoleScalarFieldEnum>
  }


  /**
   * Role create
   */
  export type RoleCreateArgs = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: RoleInclude | null
    /**
     * The data needed to create a Role.
     */
    data: XOR<RoleCreateInput, RoleUncheckedCreateInput>
  }


  /**
   * Role createMany
   */
  export type RoleCreateManyArgs = {
    /**
     * The data used to create many Roles.
     */
    data: Enumerable<RoleCreateManyInput>
    skipDuplicates?: boolean
  }


  /**
   * Role update
   */
  export type RoleUpdateArgs = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: RoleInclude | null
    /**
     * The data needed to update a Role.
     */
    data: XOR<RoleUpdateInput, RoleUncheckedUpdateInput>
    /**
     * Choose, which Role to update.
     */
    where: RoleWhereUniqueInput
  }


  /**
   * Role updateMany
   */
  export type RoleUpdateManyArgs = {
    /**
     * The data used to update Roles.
     */
    data: XOR<RoleUpdateManyMutationInput, RoleUncheckedUpdateManyInput>
    /**
     * Filter which Roles to update
     */
    where?: RoleWhereInput
  }


  /**
   * Role upsert
   */
  export type RoleUpsertArgs = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: RoleInclude | null
    /**
     * The filter to search for the Role to update in case it exists.
     */
    where: RoleWhereUniqueInput
    /**
     * In case the Role found by the `where` argument doesn't exist, create a new Role with this data.
     */
    create: XOR<RoleCreateInput, RoleUncheckedCreateInput>
    /**
     * In case the Role was found with the provided `where` argument, update it with this data.
     */
    update: XOR<RoleUpdateInput, RoleUncheckedUpdateInput>
  }


  /**
   * Role delete
   */
  export type RoleDeleteArgs = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: RoleInclude | null
    /**
     * Filter which Role to delete.
     */
    where: RoleWhereUniqueInput
  }


  /**
   * Role deleteMany
   */
  export type RoleDeleteManyArgs = {
    /**
     * Filter which Roles to delete
     */
    where?: RoleWhereInput
  }


  /**
   * Role.PermissionsOnRole
   */
  export type Role$PermissionsOnRoleArgs = {
    /**
     * Select specific fields to fetch from the PermissionsOnRole
     */
    select?: PermissionsOnRoleSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: PermissionsOnRoleInclude | null
    where?: PermissionsOnRoleWhereInput
    orderBy?: Enumerable<PermissionsOnRoleOrderByWithRelationInput>
    cursor?: PermissionsOnRoleWhereUniqueInput
    take?: number
    skip?: number
    distinct?: Enumerable<PermissionsOnRoleScalarFieldEnum>
  }


  /**
   * Role.User
   */
  export type Role$UserArgs = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserInclude | null
    where?: UserWhereInput
    orderBy?: Enumerable<UserOrderByWithRelationInput>
    cursor?: UserWhereUniqueInput
    take?: number
    skip?: number
    distinct?: Enumerable<UserScalarFieldEnum>
  }


  /**
   * Role without action
   */
  export type RoleArgs = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: RoleInclude | null
  }



  /**
   * Model Permission
   */


  export type AggregatePermission = {
    _count: PermissionCountAggregateOutputType | null
    _min: PermissionMinAggregateOutputType | null
    _max: PermissionMaxAggregateOutputType | null
  }

  export type PermissionMinAggregateOutputType = {
    id: string | null
    key: string | null
    persian_name: string | null
    english_name: string | null
    category: string | null
  }

  export type PermissionMaxAggregateOutputType = {
    id: string | null
    key: string | null
    persian_name: string | null
    english_name: string | null
    category: string | null
  }

  export type PermissionCountAggregateOutputType = {
    id: number
    key: number
    persian_name: number
    english_name: number
    category: number
    _all: number
  }


  export type PermissionMinAggregateInputType = {
    id?: true
    key?: true
    persian_name?: true
    english_name?: true
    category?: true
  }

  export type PermissionMaxAggregateInputType = {
    id?: true
    key?: true
    persian_name?: true
    english_name?: true
    category?: true
  }

  export type PermissionCountAggregateInputType = {
    id?: true
    key?: true
    persian_name?: true
    english_name?: true
    category?: true
    _all?: true
  }

  export type PermissionAggregateArgs = {
    /**
     * Filter which Permission to aggregate.
     */
    where?: PermissionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Permissions to fetch.
     */
    orderBy?: Enumerable<PermissionOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: PermissionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Permissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Permissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Permissions
    **/
    _count?: true | PermissionCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: PermissionMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: PermissionMaxAggregateInputType
  }

  export type GetPermissionAggregateType<T extends PermissionAggregateArgs> = {
        [P in keyof T & keyof AggregatePermission]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregatePermission[P]>
      : GetScalarType<T[P], AggregatePermission[P]>
  }




  export type PermissionGroupByArgs = {
    where?: PermissionWhereInput
    orderBy?: Enumerable<PermissionOrderByWithAggregationInput>
    by: PermissionScalarFieldEnum[]
    having?: PermissionScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: PermissionCountAggregateInputType | true
    _min?: PermissionMinAggregateInputType
    _max?: PermissionMaxAggregateInputType
  }


  export type PermissionGroupByOutputType = {
    id: string
    key: string
    persian_name: string
    english_name: string
    category: string
    _count: PermissionCountAggregateOutputType | null
    _min: PermissionMinAggregateOutputType | null
    _max: PermissionMaxAggregateOutputType | null
  }

  type GetPermissionGroupByPayload<T extends PermissionGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickArray<PermissionGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof PermissionGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], PermissionGroupByOutputType[P]>
            : GetScalarType<T[P], PermissionGroupByOutputType[P]>
        }
      >
    >


  export type PermissionSelect = {
    id?: boolean
    key?: boolean
    persian_name?: boolean
    english_name?: boolean
    category?: boolean
    PermissionsOnRole?: boolean | Permission$PermissionsOnRoleArgs
    _count?: boolean | PermissionCountOutputTypeArgs
  }


  export type PermissionInclude = {
    PermissionsOnRole?: boolean | Permission$PermissionsOnRoleArgs
    _count?: boolean | PermissionCountOutputTypeArgs
  }

  export type PermissionGetPayload<S extends boolean | null | undefined | PermissionArgs> =
    S extends { select: any, include: any } ? 'Please either choose `select` or `include`' :
    S extends true ? Permission :
    S extends undefined ? never :
    S extends { include: any } & (PermissionArgs | PermissionFindManyArgs)
    ? Permission  & {
    [P in TruthyKeys<S['include']>]:
        P extends 'PermissionsOnRole' ? Array < PermissionsOnRoleGetPayload<S['include'][P]>>  :
        P extends '_count' ? PermissionCountOutputTypeGetPayload<S['include'][P]> :  never
  } 
    : S extends { select: any } & (PermissionArgs | PermissionFindManyArgs)
      ? {
    [P in TruthyKeys<S['select']>]:
        P extends 'PermissionsOnRole' ? Array < PermissionsOnRoleGetPayload<S['select'][P]>>  :
        P extends '_count' ? PermissionCountOutputTypeGetPayload<S['select'][P]> :  P extends keyof Permission ? Permission[P] : never
  } 
      : Permission


  type PermissionCountArgs = 
    Omit<PermissionFindManyArgs, 'select' | 'include'> & {
      select?: PermissionCountAggregateInputType | true
    }

  export interface PermissionDelegate<GlobalRejectSettings extends Prisma.RejectOnNotFound | Prisma.RejectPerOperation | false | undefined> {

    /**
     * Find zero or one Permission that matches the filter.
     * @param {PermissionFindUniqueArgs} args - Arguments to find a Permission
     * @example
     * // Get one Permission
     * const permission = await prisma.permission.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends PermissionFindUniqueArgs,  LocalRejectSettings = T["rejectOnNotFound"] extends RejectOnNotFound ? T['rejectOnNotFound'] : undefined>(
      args: SelectSubset<T, PermissionFindUniqueArgs>
    ): HasReject<GlobalRejectSettings, LocalRejectSettings, 'findUnique', 'Permission'> extends True ? Prisma__PermissionClient<PermissionGetPayload<T>> : Prisma__PermissionClient<PermissionGetPayload<T> | null, null>

    /**
     * Find one Permission that matches the filter or throw an error  with `error.code='P2025'` 
     *     if no matches were found.
     * @param {PermissionFindUniqueOrThrowArgs} args - Arguments to find a Permission
     * @example
     * // Get one Permission
     * const permission = await prisma.permission.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends PermissionFindUniqueOrThrowArgs>(
      args?: SelectSubset<T, PermissionFindUniqueOrThrowArgs>
    ): Prisma__PermissionClient<PermissionGetPayload<T>>

    /**
     * Find the first Permission that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PermissionFindFirstArgs} args - Arguments to find a Permission
     * @example
     * // Get one Permission
     * const permission = await prisma.permission.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends PermissionFindFirstArgs,  LocalRejectSettings = T["rejectOnNotFound"] extends RejectOnNotFound ? T['rejectOnNotFound'] : undefined>(
      args?: SelectSubset<T, PermissionFindFirstArgs>
    ): HasReject<GlobalRejectSettings, LocalRejectSettings, 'findFirst', 'Permission'> extends True ? Prisma__PermissionClient<PermissionGetPayload<T>> : Prisma__PermissionClient<PermissionGetPayload<T> | null, null>

    /**
     * Find the first Permission that matches the filter or
     * throw `NotFoundError` if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PermissionFindFirstOrThrowArgs} args - Arguments to find a Permission
     * @example
     * // Get one Permission
     * const permission = await prisma.permission.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends PermissionFindFirstOrThrowArgs>(
      args?: SelectSubset<T, PermissionFindFirstOrThrowArgs>
    ): Prisma__PermissionClient<PermissionGetPayload<T>>

    /**
     * Find zero or more Permissions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PermissionFindManyArgs=} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Permissions
     * const permissions = await prisma.permission.findMany()
     * 
     * // Get first 10 Permissions
     * const permissions = await prisma.permission.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const permissionWithIdOnly = await prisma.permission.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends PermissionFindManyArgs>(
      args?: SelectSubset<T, PermissionFindManyArgs>
    ): Prisma.PrismaPromise<Array<PermissionGetPayload<T>>>

    /**
     * Create a Permission.
     * @param {PermissionCreateArgs} args - Arguments to create a Permission.
     * @example
     * // Create one Permission
     * const Permission = await prisma.permission.create({
     *   data: {
     *     // ... data to create a Permission
     *   }
     * })
     * 
    **/
    create<T extends PermissionCreateArgs>(
      args: SelectSubset<T, PermissionCreateArgs>
    ): Prisma__PermissionClient<PermissionGetPayload<T>>

    /**
     * Create many Permissions.
     *     @param {PermissionCreateManyArgs} args - Arguments to create many Permissions.
     *     @example
     *     // Create many Permissions
     *     const permission = await prisma.permission.createMany({
     *       data: {
     *         // ... provide data here
     *       }
     *     })
     *     
    **/
    createMany<T extends PermissionCreateManyArgs>(
      args?: SelectSubset<T, PermissionCreateManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Permission.
     * @param {PermissionDeleteArgs} args - Arguments to delete one Permission.
     * @example
     * // Delete one Permission
     * const Permission = await prisma.permission.delete({
     *   where: {
     *     // ... filter to delete one Permission
     *   }
     * })
     * 
    **/
    delete<T extends PermissionDeleteArgs>(
      args: SelectSubset<T, PermissionDeleteArgs>
    ): Prisma__PermissionClient<PermissionGetPayload<T>>

    /**
     * Update one Permission.
     * @param {PermissionUpdateArgs} args - Arguments to update one Permission.
     * @example
     * // Update one Permission
     * const permission = await prisma.permission.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends PermissionUpdateArgs>(
      args: SelectSubset<T, PermissionUpdateArgs>
    ): Prisma__PermissionClient<PermissionGetPayload<T>>

    /**
     * Delete zero or more Permissions.
     * @param {PermissionDeleteManyArgs} args - Arguments to filter Permissions to delete.
     * @example
     * // Delete a few Permissions
     * const { count } = await prisma.permission.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends PermissionDeleteManyArgs>(
      args?: SelectSubset<T, PermissionDeleteManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Permissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PermissionUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Permissions
     * const permission = await prisma.permission.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends PermissionUpdateManyArgs>(
      args: SelectSubset<T, PermissionUpdateManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Permission.
     * @param {PermissionUpsertArgs} args - Arguments to update or create a Permission.
     * @example
     * // Update or create a Permission
     * const permission = await prisma.permission.upsert({
     *   create: {
     *     // ... data to create a Permission
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Permission we want to update
     *   }
     * })
    **/
    upsert<T extends PermissionUpsertArgs>(
      args: SelectSubset<T, PermissionUpsertArgs>
    ): Prisma__PermissionClient<PermissionGetPayload<T>>

    /**
     * Count the number of Permissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PermissionCountArgs} args - Arguments to filter Permissions to count.
     * @example
     * // Count the number of Permissions
     * const count = await prisma.permission.count({
     *   where: {
     *     // ... the filter for the Permissions we want to count
     *   }
     * })
    **/
    count<T extends PermissionCountArgs>(
      args?: Subset<T, PermissionCountArgs>,
    ): Prisma.PrismaPromise<
      T extends _Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], PermissionCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Permission.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PermissionAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends PermissionAggregateArgs>(args: Subset<T, PermissionAggregateArgs>): Prisma.PrismaPromise<GetPermissionAggregateType<T>>

    /**
     * Group by Permission.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PermissionGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends PermissionGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: PermissionGroupByArgs['orderBy'] }
        : { orderBy?: PermissionGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends TupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, PermissionGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetPermissionGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>

  }

  /**
   * The delegate class that acts as a "Promise-like" for Permission.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export class Prisma__PermissionClient<T, Null = never> implements Prisma.PrismaPromise<T> {
    private readonly _dmmf;
    private readonly _queryType;
    private readonly _rootField;
    private readonly _clientMethod;
    private readonly _args;
    private readonly _dataPath;
    private readonly _errorFormat;
    private readonly _measurePerformance?;
    private _isList;
    private _callsite;
    private _requestPromise?;
    readonly [Symbol.toStringTag]: 'PrismaPromise';
    constructor(_dmmf: runtime.DMMFClass, _queryType: 'query' | 'mutation', _rootField: string, _clientMethod: string, _args: any, _dataPath: string[], _errorFormat: ErrorFormat, _measurePerformance?: boolean | undefined, _isList?: boolean);

    PermissionsOnRole<T extends Permission$PermissionsOnRoleArgs= {}>(args?: Subset<T, Permission$PermissionsOnRoleArgs>): Prisma.PrismaPromise<Array<PermissionsOnRoleGetPayload<T>>| Null>;

    private get _document();
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): Promise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): Promise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): Promise<T>;
  }



  // Custom InputTypes

  /**
   * Permission base type for findUnique actions
   */
  export type PermissionFindUniqueArgsBase = {
    /**
     * Select specific fields to fetch from the Permission
     */
    select?: PermissionSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: PermissionInclude | null
    /**
     * Filter, which Permission to fetch.
     */
    where: PermissionWhereUniqueInput
  }

  /**
   * Permission findUnique
   */
  export interface PermissionFindUniqueArgs extends PermissionFindUniqueArgsBase {
   /**
    * Throw an Error if query returns no results
    * @deprecated since 4.0.0: use `findUniqueOrThrow` method instead
    */
    rejectOnNotFound?: RejectOnNotFound
  }
      

  /**
   * Permission findUniqueOrThrow
   */
  export type PermissionFindUniqueOrThrowArgs = {
    /**
     * Select specific fields to fetch from the Permission
     */
    select?: PermissionSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: PermissionInclude | null
    /**
     * Filter, which Permission to fetch.
     */
    where: PermissionWhereUniqueInput
  }


  /**
   * Permission base type for findFirst actions
   */
  export type PermissionFindFirstArgsBase = {
    /**
     * Select specific fields to fetch from the Permission
     */
    select?: PermissionSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: PermissionInclude | null
    /**
     * Filter, which Permission to fetch.
     */
    where?: PermissionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Permissions to fetch.
     */
    orderBy?: Enumerable<PermissionOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Permissions.
     */
    cursor?: PermissionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Permissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Permissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Permissions.
     */
    distinct?: Enumerable<PermissionScalarFieldEnum>
  }

  /**
   * Permission findFirst
   */
  export interface PermissionFindFirstArgs extends PermissionFindFirstArgsBase {
   /**
    * Throw an Error if query returns no results
    * @deprecated since 4.0.0: use `findFirstOrThrow` method instead
    */
    rejectOnNotFound?: RejectOnNotFound
  }
      

  /**
   * Permission findFirstOrThrow
   */
  export type PermissionFindFirstOrThrowArgs = {
    /**
     * Select specific fields to fetch from the Permission
     */
    select?: PermissionSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: PermissionInclude | null
    /**
     * Filter, which Permission to fetch.
     */
    where?: PermissionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Permissions to fetch.
     */
    orderBy?: Enumerable<PermissionOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Permissions.
     */
    cursor?: PermissionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Permissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Permissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Permissions.
     */
    distinct?: Enumerable<PermissionScalarFieldEnum>
  }


  /**
   * Permission findMany
   */
  export type PermissionFindManyArgs = {
    /**
     * Select specific fields to fetch from the Permission
     */
    select?: PermissionSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: PermissionInclude | null
    /**
     * Filter, which Permissions to fetch.
     */
    where?: PermissionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Permissions to fetch.
     */
    orderBy?: Enumerable<PermissionOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Permissions.
     */
    cursor?: PermissionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Permissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Permissions.
     */
    skip?: number
    distinct?: Enumerable<PermissionScalarFieldEnum>
  }


  /**
   * Permission create
   */
  export type PermissionCreateArgs = {
    /**
     * Select specific fields to fetch from the Permission
     */
    select?: PermissionSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: PermissionInclude | null
    /**
     * The data needed to create a Permission.
     */
    data: XOR<PermissionCreateInput, PermissionUncheckedCreateInput>
  }


  /**
   * Permission createMany
   */
  export type PermissionCreateManyArgs = {
    /**
     * The data used to create many Permissions.
     */
    data: Enumerable<PermissionCreateManyInput>
    skipDuplicates?: boolean
  }


  /**
   * Permission update
   */
  export type PermissionUpdateArgs = {
    /**
     * Select specific fields to fetch from the Permission
     */
    select?: PermissionSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: PermissionInclude | null
    /**
     * The data needed to update a Permission.
     */
    data: XOR<PermissionUpdateInput, PermissionUncheckedUpdateInput>
    /**
     * Choose, which Permission to update.
     */
    where: PermissionWhereUniqueInput
  }


  /**
   * Permission updateMany
   */
  export type PermissionUpdateManyArgs = {
    /**
     * The data used to update Permissions.
     */
    data: XOR<PermissionUpdateManyMutationInput, PermissionUncheckedUpdateManyInput>
    /**
     * Filter which Permissions to update
     */
    where?: PermissionWhereInput
  }


  /**
   * Permission upsert
   */
  export type PermissionUpsertArgs = {
    /**
     * Select specific fields to fetch from the Permission
     */
    select?: PermissionSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: PermissionInclude | null
    /**
     * The filter to search for the Permission to update in case it exists.
     */
    where: PermissionWhereUniqueInput
    /**
     * In case the Permission found by the `where` argument doesn't exist, create a new Permission with this data.
     */
    create: XOR<PermissionCreateInput, PermissionUncheckedCreateInput>
    /**
     * In case the Permission was found with the provided `where` argument, update it with this data.
     */
    update: XOR<PermissionUpdateInput, PermissionUncheckedUpdateInput>
  }


  /**
   * Permission delete
   */
  export type PermissionDeleteArgs = {
    /**
     * Select specific fields to fetch from the Permission
     */
    select?: PermissionSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: PermissionInclude | null
    /**
     * Filter which Permission to delete.
     */
    where: PermissionWhereUniqueInput
  }


  /**
   * Permission deleteMany
   */
  export type PermissionDeleteManyArgs = {
    /**
     * Filter which Permissions to delete
     */
    where?: PermissionWhereInput
  }


  /**
   * Permission.PermissionsOnRole
   */
  export type Permission$PermissionsOnRoleArgs = {
    /**
     * Select specific fields to fetch from the PermissionsOnRole
     */
    select?: PermissionsOnRoleSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: PermissionsOnRoleInclude | null
    where?: PermissionsOnRoleWhereInput
    orderBy?: Enumerable<PermissionsOnRoleOrderByWithRelationInput>
    cursor?: PermissionsOnRoleWhereUniqueInput
    take?: number
    skip?: number
    distinct?: Enumerable<PermissionsOnRoleScalarFieldEnum>
  }


  /**
   * Permission without action
   */
  export type PermissionArgs = {
    /**
     * Select specific fields to fetch from the Permission
     */
    select?: PermissionSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: PermissionInclude | null
  }



  /**
   * Model PermissionsOnRole
   */


  export type AggregatePermissionsOnRole = {
    _count: PermissionsOnRoleCountAggregateOutputType | null
    _min: PermissionsOnRoleMinAggregateOutputType | null
    _max: PermissionsOnRoleMaxAggregateOutputType | null
  }

  export type PermissionsOnRoleMinAggregateOutputType = {
    id: string | null
    role_id: string | null
    permission_id: string | null
    assignedAt: Date | null
    assignedBy: string | null
  }

  export type PermissionsOnRoleMaxAggregateOutputType = {
    id: string | null
    role_id: string | null
    permission_id: string | null
    assignedAt: Date | null
    assignedBy: string | null
  }

  export type PermissionsOnRoleCountAggregateOutputType = {
    id: number
    role_id: number
    permission_id: number
    assignedAt: number
    assignedBy: number
    _all: number
  }


  export type PermissionsOnRoleMinAggregateInputType = {
    id?: true
    role_id?: true
    permission_id?: true
    assignedAt?: true
    assignedBy?: true
  }

  export type PermissionsOnRoleMaxAggregateInputType = {
    id?: true
    role_id?: true
    permission_id?: true
    assignedAt?: true
    assignedBy?: true
  }

  export type PermissionsOnRoleCountAggregateInputType = {
    id?: true
    role_id?: true
    permission_id?: true
    assignedAt?: true
    assignedBy?: true
    _all?: true
  }

  export type PermissionsOnRoleAggregateArgs = {
    /**
     * Filter which PermissionsOnRole to aggregate.
     */
    where?: PermissionsOnRoleWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of PermissionsOnRoles to fetch.
     */
    orderBy?: Enumerable<PermissionsOnRoleOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: PermissionsOnRoleWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` PermissionsOnRoles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` PermissionsOnRoles.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned PermissionsOnRoles
    **/
    _count?: true | PermissionsOnRoleCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: PermissionsOnRoleMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: PermissionsOnRoleMaxAggregateInputType
  }

  export type GetPermissionsOnRoleAggregateType<T extends PermissionsOnRoleAggregateArgs> = {
        [P in keyof T & keyof AggregatePermissionsOnRole]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregatePermissionsOnRole[P]>
      : GetScalarType<T[P], AggregatePermissionsOnRole[P]>
  }




  export type PermissionsOnRoleGroupByArgs = {
    where?: PermissionsOnRoleWhereInput
    orderBy?: Enumerable<PermissionsOnRoleOrderByWithAggregationInput>
    by: PermissionsOnRoleScalarFieldEnum[]
    having?: PermissionsOnRoleScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: PermissionsOnRoleCountAggregateInputType | true
    _min?: PermissionsOnRoleMinAggregateInputType
    _max?: PermissionsOnRoleMaxAggregateInputType
  }


  export type PermissionsOnRoleGroupByOutputType = {
    id: string
    role_id: string
    permission_id: string
    assignedAt: Date
    assignedBy: string
    _count: PermissionsOnRoleCountAggregateOutputType | null
    _min: PermissionsOnRoleMinAggregateOutputType | null
    _max: PermissionsOnRoleMaxAggregateOutputType | null
  }

  type GetPermissionsOnRoleGroupByPayload<T extends PermissionsOnRoleGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickArray<PermissionsOnRoleGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof PermissionsOnRoleGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], PermissionsOnRoleGroupByOutputType[P]>
            : GetScalarType<T[P], PermissionsOnRoleGroupByOutputType[P]>
        }
      >
    >


  export type PermissionsOnRoleSelect = {
    id?: boolean
    role_id?: boolean
    permission_id?: boolean
    assignedAt?: boolean
    assignedBy?: boolean
    role?: boolean | RoleArgs
    permission?: boolean | PermissionArgs
  }


  export type PermissionsOnRoleInclude = {
    role?: boolean | RoleArgs
    permission?: boolean | PermissionArgs
  }

  export type PermissionsOnRoleGetPayload<S extends boolean | null | undefined | PermissionsOnRoleArgs> =
    S extends { select: any, include: any } ? 'Please either choose `select` or `include`' :
    S extends true ? PermissionsOnRole :
    S extends undefined ? never :
    S extends { include: any } & (PermissionsOnRoleArgs | PermissionsOnRoleFindManyArgs)
    ? PermissionsOnRole  & {
    [P in TruthyKeys<S['include']>]:
        P extends 'role' ? RoleGetPayload<S['include'][P]> :
        P extends 'permission' ? PermissionGetPayload<S['include'][P]> :  never
  } 
    : S extends { select: any } & (PermissionsOnRoleArgs | PermissionsOnRoleFindManyArgs)
      ? {
    [P in TruthyKeys<S['select']>]:
        P extends 'role' ? RoleGetPayload<S['select'][P]> :
        P extends 'permission' ? PermissionGetPayload<S['select'][P]> :  P extends keyof PermissionsOnRole ? PermissionsOnRole[P] : never
  } 
      : PermissionsOnRole


  type PermissionsOnRoleCountArgs = 
    Omit<PermissionsOnRoleFindManyArgs, 'select' | 'include'> & {
      select?: PermissionsOnRoleCountAggregateInputType | true
    }

  export interface PermissionsOnRoleDelegate<GlobalRejectSettings extends Prisma.RejectOnNotFound | Prisma.RejectPerOperation | false | undefined> {

    /**
     * Find zero or one PermissionsOnRole that matches the filter.
     * @param {PermissionsOnRoleFindUniqueArgs} args - Arguments to find a PermissionsOnRole
     * @example
     * // Get one PermissionsOnRole
     * const permissionsOnRole = await prisma.permissionsOnRole.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends PermissionsOnRoleFindUniqueArgs,  LocalRejectSettings = T["rejectOnNotFound"] extends RejectOnNotFound ? T['rejectOnNotFound'] : undefined>(
      args: SelectSubset<T, PermissionsOnRoleFindUniqueArgs>
    ): HasReject<GlobalRejectSettings, LocalRejectSettings, 'findUnique', 'PermissionsOnRole'> extends True ? Prisma__PermissionsOnRoleClient<PermissionsOnRoleGetPayload<T>> : Prisma__PermissionsOnRoleClient<PermissionsOnRoleGetPayload<T> | null, null>

    /**
     * Find one PermissionsOnRole that matches the filter or throw an error  with `error.code='P2025'` 
     *     if no matches were found.
     * @param {PermissionsOnRoleFindUniqueOrThrowArgs} args - Arguments to find a PermissionsOnRole
     * @example
     * // Get one PermissionsOnRole
     * const permissionsOnRole = await prisma.permissionsOnRole.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends PermissionsOnRoleFindUniqueOrThrowArgs>(
      args?: SelectSubset<T, PermissionsOnRoleFindUniqueOrThrowArgs>
    ): Prisma__PermissionsOnRoleClient<PermissionsOnRoleGetPayload<T>>

    /**
     * Find the first PermissionsOnRole that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PermissionsOnRoleFindFirstArgs} args - Arguments to find a PermissionsOnRole
     * @example
     * // Get one PermissionsOnRole
     * const permissionsOnRole = await prisma.permissionsOnRole.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends PermissionsOnRoleFindFirstArgs,  LocalRejectSettings = T["rejectOnNotFound"] extends RejectOnNotFound ? T['rejectOnNotFound'] : undefined>(
      args?: SelectSubset<T, PermissionsOnRoleFindFirstArgs>
    ): HasReject<GlobalRejectSettings, LocalRejectSettings, 'findFirst', 'PermissionsOnRole'> extends True ? Prisma__PermissionsOnRoleClient<PermissionsOnRoleGetPayload<T>> : Prisma__PermissionsOnRoleClient<PermissionsOnRoleGetPayload<T> | null, null>

    /**
     * Find the first PermissionsOnRole that matches the filter or
     * throw `NotFoundError` if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PermissionsOnRoleFindFirstOrThrowArgs} args - Arguments to find a PermissionsOnRole
     * @example
     * // Get one PermissionsOnRole
     * const permissionsOnRole = await prisma.permissionsOnRole.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends PermissionsOnRoleFindFirstOrThrowArgs>(
      args?: SelectSubset<T, PermissionsOnRoleFindFirstOrThrowArgs>
    ): Prisma__PermissionsOnRoleClient<PermissionsOnRoleGetPayload<T>>

    /**
     * Find zero or more PermissionsOnRoles that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PermissionsOnRoleFindManyArgs=} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all PermissionsOnRoles
     * const permissionsOnRoles = await prisma.permissionsOnRole.findMany()
     * 
     * // Get first 10 PermissionsOnRoles
     * const permissionsOnRoles = await prisma.permissionsOnRole.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const permissionsOnRoleWithIdOnly = await prisma.permissionsOnRole.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends PermissionsOnRoleFindManyArgs>(
      args?: SelectSubset<T, PermissionsOnRoleFindManyArgs>
    ): Prisma.PrismaPromise<Array<PermissionsOnRoleGetPayload<T>>>

    /**
     * Create a PermissionsOnRole.
     * @param {PermissionsOnRoleCreateArgs} args - Arguments to create a PermissionsOnRole.
     * @example
     * // Create one PermissionsOnRole
     * const PermissionsOnRole = await prisma.permissionsOnRole.create({
     *   data: {
     *     // ... data to create a PermissionsOnRole
     *   }
     * })
     * 
    **/
    create<T extends PermissionsOnRoleCreateArgs>(
      args: SelectSubset<T, PermissionsOnRoleCreateArgs>
    ): Prisma__PermissionsOnRoleClient<PermissionsOnRoleGetPayload<T>>

    /**
     * Create many PermissionsOnRoles.
     *     @param {PermissionsOnRoleCreateManyArgs} args - Arguments to create many PermissionsOnRoles.
     *     @example
     *     // Create many PermissionsOnRoles
     *     const permissionsOnRole = await prisma.permissionsOnRole.createMany({
     *       data: {
     *         // ... provide data here
     *       }
     *     })
     *     
    **/
    createMany<T extends PermissionsOnRoleCreateManyArgs>(
      args?: SelectSubset<T, PermissionsOnRoleCreateManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a PermissionsOnRole.
     * @param {PermissionsOnRoleDeleteArgs} args - Arguments to delete one PermissionsOnRole.
     * @example
     * // Delete one PermissionsOnRole
     * const PermissionsOnRole = await prisma.permissionsOnRole.delete({
     *   where: {
     *     // ... filter to delete one PermissionsOnRole
     *   }
     * })
     * 
    **/
    delete<T extends PermissionsOnRoleDeleteArgs>(
      args: SelectSubset<T, PermissionsOnRoleDeleteArgs>
    ): Prisma__PermissionsOnRoleClient<PermissionsOnRoleGetPayload<T>>

    /**
     * Update one PermissionsOnRole.
     * @param {PermissionsOnRoleUpdateArgs} args - Arguments to update one PermissionsOnRole.
     * @example
     * // Update one PermissionsOnRole
     * const permissionsOnRole = await prisma.permissionsOnRole.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends PermissionsOnRoleUpdateArgs>(
      args: SelectSubset<T, PermissionsOnRoleUpdateArgs>
    ): Prisma__PermissionsOnRoleClient<PermissionsOnRoleGetPayload<T>>

    /**
     * Delete zero or more PermissionsOnRoles.
     * @param {PermissionsOnRoleDeleteManyArgs} args - Arguments to filter PermissionsOnRoles to delete.
     * @example
     * // Delete a few PermissionsOnRoles
     * const { count } = await prisma.permissionsOnRole.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends PermissionsOnRoleDeleteManyArgs>(
      args?: SelectSubset<T, PermissionsOnRoleDeleteManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more PermissionsOnRoles.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PermissionsOnRoleUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many PermissionsOnRoles
     * const permissionsOnRole = await prisma.permissionsOnRole.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends PermissionsOnRoleUpdateManyArgs>(
      args: SelectSubset<T, PermissionsOnRoleUpdateManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one PermissionsOnRole.
     * @param {PermissionsOnRoleUpsertArgs} args - Arguments to update or create a PermissionsOnRole.
     * @example
     * // Update or create a PermissionsOnRole
     * const permissionsOnRole = await prisma.permissionsOnRole.upsert({
     *   create: {
     *     // ... data to create a PermissionsOnRole
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the PermissionsOnRole we want to update
     *   }
     * })
    **/
    upsert<T extends PermissionsOnRoleUpsertArgs>(
      args: SelectSubset<T, PermissionsOnRoleUpsertArgs>
    ): Prisma__PermissionsOnRoleClient<PermissionsOnRoleGetPayload<T>>

    /**
     * Count the number of PermissionsOnRoles.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PermissionsOnRoleCountArgs} args - Arguments to filter PermissionsOnRoles to count.
     * @example
     * // Count the number of PermissionsOnRoles
     * const count = await prisma.permissionsOnRole.count({
     *   where: {
     *     // ... the filter for the PermissionsOnRoles we want to count
     *   }
     * })
    **/
    count<T extends PermissionsOnRoleCountArgs>(
      args?: Subset<T, PermissionsOnRoleCountArgs>,
    ): Prisma.PrismaPromise<
      T extends _Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], PermissionsOnRoleCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a PermissionsOnRole.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PermissionsOnRoleAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends PermissionsOnRoleAggregateArgs>(args: Subset<T, PermissionsOnRoleAggregateArgs>): Prisma.PrismaPromise<GetPermissionsOnRoleAggregateType<T>>

    /**
     * Group by PermissionsOnRole.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PermissionsOnRoleGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends PermissionsOnRoleGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: PermissionsOnRoleGroupByArgs['orderBy'] }
        : { orderBy?: PermissionsOnRoleGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends TupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, PermissionsOnRoleGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetPermissionsOnRoleGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>

  }

  /**
   * The delegate class that acts as a "Promise-like" for PermissionsOnRole.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export class Prisma__PermissionsOnRoleClient<T, Null = never> implements Prisma.PrismaPromise<T> {
    private readonly _dmmf;
    private readonly _queryType;
    private readonly _rootField;
    private readonly _clientMethod;
    private readonly _args;
    private readonly _dataPath;
    private readonly _errorFormat;
    private readonly _measurePerformance?;
    private _isList;
    private _callsite;
    private _requestPromise?;
    readonly [Symbol.toStringTag]: 'PrismaPromise';
    constructor(_dmmf: runtime.DMMFClass, _queryType: 'query' | 'mutation', _rootField: string, _clientMethod: string, _args: any, _dataPath: string[], _errorFormat: ErrorFormat, _measurePerformance?: boolean | undefined, _isList?: boolean);

    role<T extends RoleArgs= {}>(args?: Subset<T, RoleArgs>): Prisma__RoleClient<RoleGetPayload<T> | Null>;

    permission<T extends PermissionArgs= {}>(args?: Subset<T, PermissionArgs>): Prisma__PermissionClient<PermissionGetPayload<T> | Null>;

    private get _document();
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): Promise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): Promise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): Promise<T>;
  }



  // Custom InputTypes

  /**
   * PermissionsOnRole base type for findUnique actions
   */
  export type PermissionsOnRoleFindUniqueArgsBase = {
    /**
     * Select specific fields to fetch from the PermissionsOnRole
     */
    select?: PermissionsOnRoleSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: PermissionsOnRoleInclude | null
    /**
     * Filter, which PermissionsOnRole to fetch.
     */
    where: PermissionsOnRoleWhereUniqueInput
  }

  /**
   * PermissionsOnRole findUnique
   */
  export interface PermissionsOnRoleFindUniqueArgs extends PermissionsOnRoleFindUniqueArgsBase {
   /**
    * Throw an Error if query returns no results
    * @deprecated since 4.0.0: use `findUniqueOrThrow` method instead
    */
    rejectOnNotFound?: RejectOnNotFound
  }
      

  /**
   * PermissionsOnRole findUniqueOrThrow
   */
  export type PermissionsOnRoleFindUniqueOrThrowArgs = {
    /**
     * Select specific fields to fetch from the PermissionsOnRole
     */
    select?: PermissionsOnRoleSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: PermissionsOnRoleInclude | null
    /**
     * Filter, which PermissionsOnRole to fetch.
     */
    where: PermissionsOnRoleWhereUniqueInput
  }


  /**
   * PermissionsOnRole base type for findFirst actions
   */
  export type PermissionsOnRoleFindFirstArgsBase = {
    /**
     * Select specific fields to fetch from the PermissionsOnRole
     */
    select?: PermissionsOnRoleSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: PermissionsOnRoleInclude | null
    /**
     * Filter, which PermissionsOnRole to fetch.
     */
    where?: PermissionsOnRoleWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of PermissionsOnRoles to fetch.
     */
    orderBy?: Enumerable<PermissionsOnRoleOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for PermissionsOnRoles.
     */
    cursor?: PermissionsOnRoleWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` PermissionsOnRoles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` PermissionsOnRoles.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of PermissionsOnRoles.
     */
    distinct?: Enumerable<PermissionsOnRoleScalarFieldEnum>
  }

  /**
   * PermissionsOnRole findFirst
   */
  export interface PermissionsOnRoleFindFirstArgs extends PermissionsOnRoleFindFirstArgsBase {
   /**
    * Throw an Error if query returns no results
    * @deprecated since 4.0.0: use `findFirstOrThrow` method instead
    */
    rejectOnNotFound?: RejectOnNotFound
  }
      

  /**
   * PermissionsOnRole findFirstOrThrow
   */
  export type PermissionsOnRoleFindFirstOrThrowArgs = {
    /**
     * Select specific fields to fetch from the PermissionsOnRole
     */
    select?: PermissionsOnRoleSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: PermissionsOnRoleInclude | null
    /**
     * Filter, which PermissionsOnRole to fetch.
     */
    where?: PermissionsOnRoleWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of PermissionsOnRoles to fetch.
     */
    orderBy?: Enumerable<PermissionsOnRoleOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for PermissionsOnRoles.
     */
    cursor?: PermissionsOnRoleWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` PermissionsOnRoles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` PermissionsOnRoles.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of PermissionsOnRoles.
     */
    distinct?: Enumerable<PermissionsOnRoleScalarFieldEnum>
  }


  /**
   * PermissionsOnRole findMany
   */
  export type PermissionsOnRoleFindManyArgs = {
    /**
     * Select specific fields to fetch from the PermissionsOnRole
     */
    select?: PermissionsOnRoleSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: PermissionsOnRoleInclude | null
    /**
     * Filter, which PermissionsOnRoles to fetch.
     */
    where?: PermissionsOnRoleWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of PermissionsOnRoles to fetch.
     */
    orderBy?: Enumerable<PermissionsOnRoleOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing PermissionsOnRoles.
     */
    cursor?: PermissionsOnRoleWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` PermissionsOnRoles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` PermissionsOnRoles.
     */
    skip?: number
    distinct?: Enumerable<PermissionsOnRoleScalarFieldEnum>
  }


  /**
   * PermissionsOnRole create
   */
  export type PermissionsOnRoleCreateArgs = {
    /**
     * Select specific fields to fetch from the PermissionsOnRole
     */
    select?: PermissionsOnRoleSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: PermissionsOnRoleInclude | null
    /**
     * The data needed to create a PermissionsOnRole.
     */
    data: XOR<PermissionsOnRoleCreateInput, PermissionsOnRoleUncheckedCreateInput>
  }


  /**
   * PermissionsOnRole createMany
   */
  export type PermissionsOnRoleCreateManyArgs = {
    /**
     * The data used to create many PermissionsOnRoles.
     */
    data: Enumerable<PermissionsOnRoleCreateManyInput>
    skipDuplicates?: boolean
  }


  /**
   * PermissionsOnRole update
   */
  export type PermissionsOnRoleUpdateArgs = {
    /**
     * Select specific fields to fetch from the PermissionsOnRole
     */
    select?: PermissionsOnRoleSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: PermissionsOnRoleInclude | null
    /**
     * The data needed to update a PermissionsOnRole.
     */
    data: XOR<PermissionsOnRoleUpdateInput, PermissionsOnRoleUncheckedUpdateInput>
    /**
     * Choose, which PermissionsOnRole to update.
     */
    where: PermissionsOnRoleWhereUniqueInput
  }


  /**
   * PermissionsOnRole updateMany
   */
  export type PermissionsOnRoleUpdateManyArgs = {
    /**
     * The data used to update PermissionsOnRoles.
     */
    data: XOR<PermissionsOnRoleUpdateManyMutationInput, PermissionsOnRoleUncheckedUpdateManyInput>
    /**
     * Filter which PermissionsOnRoles to update
     */
    where?: PermissionsOnRoleWhereInput
  }


  /**
   * PermissionsOnRole upsert
   */
  export type PermissionsOnRoleUpsertArgs = {
    /**
     * Select specific fields to fetch from the PermissionsOnRole
     */
    select?: PermissionsOnRoleSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: PermissionsOnRoleInclude | null
    /**
     * The filter to search for the PermissionsOnRole to update in case it exists.
     */
    where: PermissionsOnRoleWhereUniqueInput
    /**
     * In case the PermissionsOnRole found by the `where` argument doesn't exist, create a new PermissionsOnRole with this data.
     */
    create: XOR<PermissionsOnRoleCreateInput, PermissionsOnRoleUncheckedCreateInput>
    /**
     * In case the PermissionsOnRole was found with the provided `where` argument, update it with this data.
     */
    update: XOR<PermissionsOnRoleUpdateInput, PermissionsOnRoleUncheckedUpdateInput>
  }


  /**
   * PermissionsOnRole delete
   */
  export type PermissionsOnRoleDeleteArgs = {
    /**
     * Select specific fields to fetch from the PermissionsOnRole
     */
    select?: PermissionsOnRoleSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: PermissionsOnRoleInclude | null
    /**
     * Filter which PermissionsOnRole to delete.
     */
    where: PermissionsOnRoleWhereUniqueInput
  }


  /**
   * PermissionsOnRole deleteMany
   */
  export type PermissionsOnRoleDeleteManyArgs = {
    /**
     * Filter which PermissionsOnRoles to delete
     */
    where?: PermissionsOnRoleWhereInput
  }


  /**
   * PermissionsOnRole without action
   */
  export type PermissionsOnRoleArgs = {
    /**
     * Select specific fields to fetch from the PermissionsOnRole
     */
    select?: PermissionsOnRoleSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: PermissionsOnRoleInclude | null
  }



  /**
   * Model File
   */


  export type AggregateFile = {
    _count: FileCountAggregateOutputType | null
    _avg: FileAvgAggregateOutputType | null
    _sum: FileSumAggregateOutputType | null
    _min: FileMinAggregateOutputType | null
    _max: FileMaxAggregateOutputType | null
  }

  export type FileAvgAggregateOutputType = {
    size: number | null
  }

  export type FileSumAggregateOutputType = {
    size: number | null
  }

  export type FileMinAggregateOutputType = {
    id: string | null
    path: string | null
    type: FileType | null
    author: string | null
    size: number | null
    alt: string | null
    mimetype: string | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type FileMaxAggregateOutputType = {
    id: string | null
    path: string | null
    type: FileType | null
    author: string | null
    size: number | null
    alt: string | null
    mimetype: string | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type FileCountAggregateOutputType = {
    id: number
    path: number
    type: number
    author: number
    size: number
    alt: number
    mimetype: number
    createdAt: number
    updatedAt: number
    _all: number
  }


  export type FileAvgAggregateInputType = {
    size?: true
  }

  export type FileSumAggregateInputType = {
    size?: true
  }

  export type FileMinAggregateInputType = {
    id?: true
    path?: true
    type?: true
    author?: true
    size?: true
    alt?: true
    mimetype?: true
    createdAt?: true
    updatedAt?: true
  }

  export type FileMaxAggregateInputType = {
    id?: true
    path?: true
    type?: true
    author?: true
    size?: true
    alt?: true
    mimetype?: true
    createdAt?: true
    updatedAt?: true
  }

  export type FileCountAggregateInputType = {
    id?: true
    path?: true
    type?: true
    author?: true
    size?: true
    alt?: true
    mimetype?: true
    createdAt?: true
    updatedAt?: true
    _all?: true
  }

  export type FileAggregateArgs = {
    /**
     * Filter which File to aggregate.
     */
    where?: FileWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Files to fetch.
     */
    orderBy?: Enumerable<FileOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: FileWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Files from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Files.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Files
    **/
    _count?: true | FileCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: FileAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: FileSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: FileMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: FileMaxAggregateInputType
  }

  export type GetFileAggregateType<T extends FileAggregateArgs> = {
        [P in keyof T & keyof AggregateFile]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateFile[P]>
      : GetScalarType<T[P], AggregateFile[P]>
  }




  export type FileGroupByArgs = {
    where?: FileWhereInput
    orderBy?: Enumerable<FileOrderByWithAggregationInput>
    by: FileScalarFieldEnum[]
    having?: FileScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: FileCountAggregateInputType | true
    _avg?: FileAvgAggregateInputType
    _sum?: FileSumAggregateInputType
    _min?: FileMinAggregateInputType
    _max?: FileMaxAggregateInputType
  }


  export type FileGroupByOutputType = {
    id: string
    path: string
    type: FileType
    author: string
    size: number
    alt: string | null
    mimetype: string
    createdAt: Date
    updatedAt: Date
    _count: FileCountAggregateOutputType | null
    _avg: FileAvgAggregateOutputType | null
    _sum: FileSumAggregateOutputType | null
    _min: FileMinAggregateOutputType | null
    _max: FileMaxAggregateOutputType | null
  }

  type GetFileGroupByPayload<T extends FileGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickArray<FileGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof FileGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], FileGroupByOutputType[P]>
            : GetScalarType<T[P], FileGroupByOutputType[P]>
        }
      >
    >


  export type FileSelect = {
    id?: boolean
    path?: boolean
    type?: boolean
    author?: boolean
    size?: boolean
    alt?: boolean
    mimetype?: boolean
    createdAt?: boolean
    updatedAt?: boolean
    user?: boolean | UserArgs
    UserDetail?: boolean | File$UserDetailArgs
    Notification?: boolean | File$NotificationArgs
    _count?: boolean | FileCountOutputTypeArgs
  }


  export type FileInclude = {
    user?: boolean | UserArgs
    UserDetail?: boolean | File$UserDetailArgs
    Notification?: boolean | File$NotificationArgs
    _count?: boolean | FileCountOutputTypeArgs
  }

  export type FileGetPayload<S extends boolean | null | undefined | FileArgs> =
    S extends { select: any, include: any } ? 'Please either choose `select` or `include`' :
    S extends true ? File :
    S extends undefined ? never :
    S extends { include: any } & (FileArgs | FileFindManyArgs)
    ? File  & {
    [P in TruthyKeys<S['include']>]:
        P extends 'user' ? UserGetPayload<S['include'][P]> :
        P extends 'UserDetail' ? Array < UserDetailGetPayload<S['include'][P]>>  :
        P extends 'Notification' ? Array < NotificationGetPayload<S['include'][P]>>  :
        P extends '_count' ? FileCountOutputTypeGetPayload<S['include'][P]> :  never
  } 
    : S extends { select: any } & (FileArgs | FileFindManyArgs)
      ? {
    [P in TruthyKeys<S['select']>]:
        P extends 'user' ? UserGetPayload<S['select'][P]> :
        P extends 'UserDetail' ? Array < UserDetailGetPayload<S['select'][P]>>  :
        P extends 'Notification' ? Array < NotificationGetPayload<S['select'][P]>>  :
        P extends '_count' ? FileCountOutputTypeGetPayload<S['select'][P]> :  P extends keyof File ? File[P] : never
  } 
      : File


  type FileCountArgs = 
    Omit<FileFindManyArgs, 'select' | 'include'> & {
      select?: FileCountAggregateInputType | true
    }

  export interface FileDelegate<GlobalRejectSettings extends Prisma.RejectOnNotFound | Prisma.RejectPerOperation | false | undefined> {

    /**
     * Find zero or one File that matches the filter.
     * @param {FileFindUniqueArgs} args - Arguments to find a File
     * @example
     * // Get one File
     * const file = await prisma.file.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends FileFindUniqueArgs,  LocalRejectSettings = T["rejectOnNotFound"] extends RejectOnNotFound ? T['rejectOnNotFound'] : undefined>(
      args: SelectSubset<T, FileFindUniqueArgs>
    ): HasReject<GlobalRejectSettings, LocalRejectSettings, 'findUnique', 'File'> extends True ? Prisma__FileClient<FileGetPayload<T>> : Prisma__FileClient<FileGetPayload<T> | null, null>

    /**
     * Find one File that matches the filter or throw an error  with `error.code='P2025'` 
     *     if no matches were found.
     * @param {FileFindUniqueOrThrowArgs} args - Arguments to find a File
     * @example
     * // Get one File
     * const file = await prisma.file.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends FileFindUniqueOrThrowArgs>(
      args?: SelectSubset<T, FileFindUniqueOrThrowArgs>
    ): Prisma__FileClient<FileGetPayload<T>>

    /**
     * Find the first File that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {FileFindFirstArgs} args - Arguments to find a File
     * @example
     * // Get one File
     * const file = await prisma.file.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends FileFindFirstArgs,  LocalRejectSettings = T["rejectOnNotFound"] extends RejectOnNotFound ? T['rejectOnNotFound'] : undefined>(
      args?: SelectSubset<T, FileFindFirstArgs>
    ): HasReject<GlobalRejectSettings, LocalRejectSettings, 'findFirst', 'File'> extends True ? Prisma__FileClient<FileGetPayload<T>> : Prisma__FileClient<FileGetPayload<T> | null, null>

    /**
     * Find the first File that matches the filter or
     * throw `NotFoundError` if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {FileFindFirstOrThrowArgs} args - Arguments to find a File
     * @example
     * // Get one File
     * const file = await prisma.file.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends FileFindFirstOrThrowArgs>(
      args?: SelectSubset<T, FileFindFirstOrThrowArgs>
    ): Prisma__FileClient<FileGetPayload<T>>

    /**
     * Find zero or more Files that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {FileFindManyArgs=} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Files
     * const files = await prisma.file.findMany()
     * 
     * // Get first 10 Files
     * const files = await prisma.file.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const fileWithIdOnly = await prisma.file.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends FileFindManyArgs>(
      args?: SelectSubset<T, FileFindManyArgs>
    ): Prisma.PrismaPromise<Array<FileGetPayload<T>>>

    /**
     * Create a File.
     * @param {FileCreateArgs} args - Arguments to create a File.
     * @example
     * // Create one File
     * const File = await prisma.file.create({
     *   data: {
     *     // ... data to create a File
     *   }
     * })
     * 
    **/
    create<T extends FileCreateArgs>(
      args: SelectSubset<T, FileCreateArgs>
    ): Prisma__FileClient<FileGetPayload<T>>

    /**
     * Create many Files.
     *     @param {FileCreateManyArgs} args - Arguments to create many Files.
     *     @example
     *     // Create many Files
     *     const file = await prisma.file.createMany({
     *       data: {
     *         // ... provide data here
     *       }
     *     })
     *     
    **/
    createMany<T extends FileCreateManyArgs>(
      args?: SelectSubset<T, FileCreateManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a File.
     * @param {FileDeleteArgs} args - Arguments to delete one File.
     * @example
     * // Delete one File
     * const File = await prisma.file.delete({
     *   where: {
     *     // ... filter to delete one File
     *   }
     * })
     * 
    **/
    delete<T extends FileDeleteArgs>(
      args: SelectSubset<T, FileDeleteArgs>
    ): Prisma__FileClient<FileGetPayload<T>>

    /**
     * Update one File.
     * @param {FileUpdateArgs} args - Arguments to update one File.
     * @example
     * // Update one File
     * const file = await prisma.file.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends FileUpdateArgs>(
      args: SelectSubset<T, FileUpdateArgs>
    ): Prisma__FileClient<FileGetPayload<T>>

    /**
     * Delete zero or more Files.
     * @param {FileDeleteManyArgs} args - Arguments to filter Files to delete.
     * @example
     * // Delete a few Files
     * const { count } = await prisma.file.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends FileDeleteManyArgs>(
      args?: SelectSubset<T, FileDeleteManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Files.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {FileUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Files
     * const file = await prisma.file.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends FileUpdateManyArgs>(
      args: SelectSubset<T, FileUpdateManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one File.
     * @param {FileUpsertArgs} args - Arguments to update or create a File.
     * @example
     * // Update or create a File
     * const file = await prisma.file.upsert({
     *   create: {
     *     // ... data to create a File
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the File we want to update
     *   }
     * })
    **/
    upsert<T extends FileUpsertArgs>(
      args: SelectSubset<T, FileUpsertArgs>
    ): Prisma__FileClient<FileGetPayload<T>>

    /**
     * Count the number of Files.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {FileCountArgs} args - Arguments to filter Files to count.
     * @example
     * // Count the number of Files
     * const count = await prisma.file.count({
     *   where: {
     *     // ... the filter for the Files we want to count
     *   }
     * })
    **/
    count<T extends FileCountArgs>(
      args?: Subset<T, FileCountArgs>,
    ): Prisma.PrismaPromise<
      T extends _Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], FileCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a File.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {FileAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends FileAggregateArgs>(args: Subset<T, FileAggregateArgs>): Prisma.PrismaPromise<GetFileAggregateType<T>>

    /**
     * Group by File.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {FileGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends FileGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: FileGroupByArgs['orderBy'] }
        : { orderBy?: FileGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends TupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, FileGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetFileGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>

  }

  /**
   * The delegate class that acts as a "Promise-like" for File.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export class Prisma__FileClient<T, Null = never> implements Prisma.PrismaPromise<T> {
    private readonly _dmmf;
    private readonly _queryType;
    private readonly _rootField;
    private readonly _clientMethod;
    private readonly _args;
    private readonly _dataPath;
    private readonly _errorFormat;
    private readonly _measurePerformance?;
    private _isList;
    private _callsite;
    private _requestPromise?;
    readonly [Symbol.toStringTag]: 'PrismaPromise';
    constructor(_dmmf: runtime.DMMFClass, _queryType: 'query' | 'mutation', _rootField: string, _clientMethod: string, _args: any, _dataPath: string[], _errorFormat: ErrorFormat, _measurePerformance?: boolean | undefined, _isList?: boolean);

    user<T extends UserArgs= {}>(args?: Subset<T, UserArgs>): Prisma__UserClient<UserGetPayload<T> | Null>;

    UserDetail<T extends File$UserDetailArgs= {}>(args?: Subset<T, File$UserDetailArgs>): Prisma.PrismaPromise<Array<UserDetailGetPayload<T>>| Null>;

    Notification<T extends File$NotificationArgs= {}>(args?: Subset<T, File$NotificationArgs>): Prisma.PrismaPromise<Array<NotificationGetPayload<T>>| Null>;

    private get _document();
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): Promise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): Promise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): Promise<T>;
  }



  // Custom InputTypes

  /**
   * File base type for findUnique actions
   */
  export type FileFindUniqueArgsBase = {
    /**
     * Select specific fields to fetch from the File
     */
    select?: FileSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: FileInclude | null
    /**
     * Filter, which File to fetch.
     */
    where: FileWhereUniqueInput
  }

  /**
   * File findUnique
   */
  export interface FileFindUniqueArgs extends FileFindUniqueArgsBase {
   /**
    * Throw an Error if query returns no results
    * @deprecated since 4.0.0: use `findUniqueOrThrow` method instead
    */
    rejectOnNotFound?: RejectOnNotFound
  }
      

  /**
   * File findUniqueOrThrow
   */
  export type FileFindUniqueOrThrowArgs = {
    /**
     * Select specific fields to fetch from the File
     */
    select?: FileSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: FileInclude | null
    /**
     * Filter, which File to fetch.
     */
    where: FileWhereUniqueInput
  }


  /**
   * File base type for findFirst actions
   */
  export type FileFindFirstArgsBase = {
    /**
     * Select specific fields to fetch from the File
     */
    select?: FileSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: FileInclude | null
    /**
     * Filter, which File to fetch.
     */
    where?: FileWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Files to fetch.
     */
    orderBy?: Enumerable<FileOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Files.
     */
    cursor?: FileWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Files from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Files.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Files.
     */
    distinct?: Enumerable<FileScalarFieldEnum>
  }

  /**
   * File findFirst
   */
  export interface FileFindFirstArgs extends FileFindFirstArgsBase {
   /**
    * Throw an Error if query returns no results
    * @deprecated since 4.0.0: use `findFirstOrThrow` method instead
    */
    rejectOnNotFound?: RejectOnNotFound
  }
      

  /**
   * File findFirstOrThrow
   */
  export type FileFindFirstOrThrowArgs = {
    /**
     * Select specific fields to fetch from the File
     */
    select?: FileSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: FileInclude | null
    /**
     * Filter, which File to fetch.
     */
    where?: FileWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Files to fetch.
     */
    orderBy?: Enumerable<FileOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Files.
     */
    cursor?: FileWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Files from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Files.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Files.
     */
    distinct?: Enumerable<FileScalarFieldEnum>
  }


  /**
   * File findMany
   */
  export type FileFindManyArgs = {
    /**
     * Select specific fields to fetch from the File
     */
    select?: FileSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: FileInclude | null
    /**
     * Filter, which Files to fetch.
     */
    where?: FileWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Files to fetch.
     */
    orderBy?: Enumerable<FileOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Files.
     */
    cursor?: FileWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Files from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Files.
     */
    skip?: number
    distinct?: Enumerable<FileScalarFieldEnum>
  }


  /**
   * File create
   */
  export type FileCreateArgs = {
    /**
     * Select specific fields to fetch from the File
     */
    select?: FileSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: FileInclude | null
    /**
     * The data needed to create a File.
     */
    data: XOR<FileCreateInput, FileUncheckedCreateInput>
  }


  /**
   * File createMany
   */
  export type FileCreateManyArgs = {
    /**
     * The data used to create many Files.
     */
    data: Enumerable<FileCreateManyInput>
    skipDuplicates?: boolean
  }


  /**
   * File update
   */
  export type FileUpdateArgs = {
    /**
     * Select specific fields to fetch from the File
     */
    select?: FileSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: FileInclude | null
    /**
     * The data needed to update a File.
     */
    data: XOR<FileUpdateInput, FileUncheckedUpdateInput>
    /**
     * Choose, which File to update.
     */
    where: FileWhereUniqueInput
  }


  /**
   * File updateMany
   */
  export type FileUpdateManyArgs = {
    /**
     * The data used to update Files.
     */
    data: XOR<FileUpdateManyMutationInput, FileUncheckedUpdateManyInput>
    /**
     * Filter which Files to update
     */
    where?: FileWhereInput
  }


  /**
   * File upsert
   */
  export type FileUpsertArgs = {
    /**
     * Select specific fields to fetch from the File
     */
    select?: FileSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: FileInclude | null
    /**
     * The filter to search for the File to update in case it exists.
     */
    where: FileWhereUniqueInput
    /**
     * In case the File found by the `where` argument doesn't exist, create a new File with this data.
     */
    create: XOR<FileCreateInput, FileUncheckedCreateInput>
    /**
     * In case the File was found with the provided `where` argument, update it with this data.
     */
    update: XOR<FileUpdateInput, FileUncheckedUpdateInput>
  }


  /**
   * File delete
   */
  export type FileDeleteArgs = {
    /**
     * Select specific fields to fetch from the File
     */
    select?: FileSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: FileInclude | null
    /**
     * Filter which File to delete.
     */
    where: FileWhereUniqueInput
  }


  /**
   * File deleteMany
   */
  export type FileDeleteManyArgs = {
    /**
     * Filter which Files to delete
     */
    where?: FileWhereInput
  }


  /**
   * File.UserDetail
   */
  export type File$UserDetailArgs = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserDetailInclude | null
    where?: UserDetailWhereInput
    orderBy?: Enumerable<UserDetailOrderByWithRelationInput>
    cursor?: UserDetailWhereUniqueInput
    take?: number
    skip?: number
    distinct?: Enumerable<UserDetailScalarFieldEnum>
  }


  /**
   * File.Notification
   */
  export type File$NotificationArgs = {
    /**
     * Select specific fields to fetch from the Notification
     */
    select?: NotificationSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: NotificationInclude | null
    where?: NotificationWhereInput
    orderBy?: Enumerable<NotificationOrderByWithRelationInput>
    cursor?: NotificationWhereUniqueInput
    take?: number
    skip?: number
    distinct?: Enumerable<NotificationScalarFieldEnum>
  }


  /**
   * File without action
   */
  export type FileArgs = {
    /**
     * Select specific fields to fetch from the File
     */
    select?: FileSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: FileInclude | null
  }



  /**
   * Model Inout
   */


  export type AggregateInout = {
    _count: InoutCountAggregateOutputType | null
    _min: InoutMinAggregateOutputType | null
    _max: InoutMaxAggregateOutputType | null
  }

  export type InoutMinAggregateOutputType = {
    id: string | null
    user_id: string | null
    time: Date | null
    type: InoutType | null
    delete: boolean | null
    description: string | null
    createdAt: Date | null
    updatedAt: Date | null
    approved: boolean | null
  }

  export type InoutMaxAggregateOutputType = {
    id: string | null
    user_id: string | null
    time: Date | null
    type: InoutType | null
    delete: boolean | null
    description: string | null
    createdAt: Date | null
    updatedAt: Date | null
    approved: boolean | null
  }

  export type InoutCountAggregateOutputType = {
    id: number
    user_id: number
    time: number
    type: number
    delete: number
    description: number
    createdAt: number
    updatedAt: number
    approved: number
    _all: number
  }


  export type InoutMinAggregateInputType = {
    id?: true
    user_id?: true
    time?: true
    type?: true
    delete?: true
    description?: true
    createdAt?: true
    updatedAt?: true
    approved?: true
  }

  export type InoutMaxAggregateInputType = {
    id?: true
    user_id?: true
    time?: true
    type?: true
    delete?: true
    description?: true
    createdAt?: true
    updatedAt?: true
    approved?: true
  }

  export type InoutCountAggregateInputType = {
    id?: true
    user_id?: true
    time?: true
    type?: true
    delete?: true
    description?: true
    createdAt?: true
    updatedAt?: true
    approved?: true
    _all?: true
  }

  export type InoutAggregateArgs = {
    /**
     * Filter which Inout to aggregate.
     */
    where?: InoutWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Inouts to fetch.
     */
    orderBy?: Enumerable<InoutOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: InoutWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Inouts from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Inouts.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Inouts
    **/
    _count?: true | InoutCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: InoutMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: InoutMaxAggregateInputType
  }

  export type GetInoutAggregateType<T extends InoutAggregateArgs> = {
        [P in keyof T & keyof AggregateInout]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateInout[P]>
      : GetScalarType<T[P], AggregateInout[P]>
  }




  export type InoutGroupByArgs = {
    where?: InoutWhereInput
    orderBy?: Enumerable<InoutOrderByWithAggregationInput>
    by: InoutScalarFieldEnum[]
    having?: InoutScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: InoutCountAggregateInputType | true
    _min?: InoutMinAggregateInputType
    _max?: InoutMaxAggregateInputType
  }


  export type InoutGroupByOutputType = {
    id: string
    user_id: string
    time: Date
    type: InoutType
    delete: boolean
    description: string | null
    createdAt: Date
    updatedAt: Date
    approved: boolean
    _count: InoutCountAggregateOutputType | null
    _min: InoutMinAggregateOutputType | null
    _max: InoutMaxAggregateOutputType | null
  }

  type GetInoutGroupByPayload<T extends InoutGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickArray<InoutGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof InoutGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], InoutGroupByOutputType[P]>
            : GetScalarType<T[P], InoutGroupByOutputType[P]>
        }
      >
    >


  export type InoutSelect = {
    id?: boolean
    user_id?: boolean
    time?: boolean
    type?: boolean
    delete?: boolean
    description?: boolean
    createdAt?: boolean
    updatedAt?: boolean
    approved?: boolean
    user?: boolean | UserArgs
    Inout_logs?: boolean | Inout$Inout_logsArgs
    _count?: boolean | InoutCountOutputTypeArgs
  }


  export type InoutInclude = {
    user?: boolean | UserArgs
    Inout_logs?: boolean | Inout$Inout_logsArgs
    _count?: boolean | InoutCountOutputTypeArgs
  }

  export type InoutGetPayload<S extends boolean | null | undefined | InoutArgs> =
    S extends { select: any, include: any } ? 'Please either choose `select` or `include`' :
    S extends true ? Inout :
    S extends undefined ? never :
    S extends { include: any } & (InoutArgs | InoutFindManyArgs)
    ? Inout  & {
    [P in TruthyKeys<S['include']>]:
        P extends 'user' ? UserGetPayload<S['include'][P]> :
        P extends 'Inout_logs' ? Array < Inout_logsGetPayload<S['include'][P]>>  :
        P extends '_count' ? InoutCountOutputTypeGetPayload<S['include'][P]> :  never
  } 
    : S extends { select: any } & (InoutArgs | InoutFindManyArgs)
      ? {
    [P in TruthyKeys<S['select']>]:
        P extends 'user' ? UserGetPayload<S['select'][P]> :
        P extends 'Inout_logs' ? Array < Inout_logsGetPayload<S['select'][P]>>  :
        P extends '_count' ? InoutCountOutputTypeGetPayload<S['select'][P]> :  P extends keyof Inout ? Inout[P] : never
  } 
      : Inout


  type InoutCountArgs = 
    Omit<InoutFindManyArgs, 'select' | 'include'> & {
      select?: InoutCountAggregateInputType | true
    }

  export interface InoutDelegate<GlobalRejectSettings extends Prisma.RejectOnNotFound | Prisma.RejectPerOperation | false | undefined> {

    /**
     * Find zero or one Inout that matches the filter.
     * @param {InoutFindUniqueArgs} args - Arguments to find a Inout
     * @example
     * // Get one Inout
     * const inout = await prisma.inout.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends InoutFindUniqueArgs,  LocalRejectSettings = T["rejectOnNotFound"] extends RejectOnNotFound ? T['rejectOnNotFound'] : undefined>(
      args: SelectSubset<T, InoutFindUniqueArgs>
    ): HasReject<GlobalRejectSettings, LocalRejectSettings, 'findUnique', 'Inout'> extends True ? Prisma__InoutClient<InoutGetPayload<T>> : Prisma__InoutClient<InoutGetPayload<T> | null, null>

    /**
     * Find one Inout that matches the filter or throw an error  with `error.code='P2025'` 
     *     if no matches were found.
     * @param {InoutFindUniqueOrThrowArgs} args - Arguments to find a Inout
     * @example
     * // Get one Inout
     * const inout = await prisma.inout.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends InoutFindUniqueOrThrowArgs>(
      args?: SelectSubset<T, InoutFindUniqueOrThrowArgs>
    ): Prisma__InoutClient<InoutGetPayload<T>>

    /**
     * Find the first Inout that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {InoutFindFirstArgs} args - Arguments to find a Inout
     * @example
     * // Get one Inout
     * const inout = await prisma.inout.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends InoutFindFirstArgs,  LocalRejectSettings = T["rejectOnNotFound"] extends RejectOnNotFound ? T['rejectOnNotFound'] : undefined>(
      args?: SelectSubset<T, InoutFindFirstArgs>
    ): HasReject<GlobalRejectSettings, LocalRejectSettings, 'findFirst', 'Inout'> extends True ? Prisma__InoutClient<InoutGetPayload<T>> : Prisma__InoutClient<InoutGetPayload<T> | null, null>

    /**
     * Find the first Inout that matches the filter or
     * throw `NotFoundError` if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {InoutFindFirstOrThrowArgs} args - Arguments to find a Inout
     * @example
     * // Get one Inout
     * const inout = await prisma.inout.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends InoutFindFirstOrThrowArgs>(
      args?: SelectSubset<T, InoutFindFirstOrThrowArgs>
    ): Prisma__InoutClient<InoutGetPayload<T>>

    /**
     * Find zero or more Inouts that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {InoutFindManyArgs=} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Inouts
     * const inouts = await prisma.inout.findMany()
     * 
     * // Get first 10 Inouts
     * const inouts = await prisma.inout.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const inoutWithIdOnly = await prisma.inout.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends InoutFindManyArgs>(
      args?: SelectSubset<T, InoutFindManyArgs>
    ): Prisma.PrismaPromise<Array<InoutGetPayload<T>>>

    /**
     * Create a Inout.
     * @param {InoutCreateArgs} args - Arguments to create a Inout.
     * @example
     * // Create one Inout
     * const Inout = await prisma.inout.create({
     *   data: {
     *     // ... data to create a Inout
     *   }
     * })
     * 
    **/
    create<T extends InoutCreateArgs>(
      args: SelectSubset<T, InoutCreateArgs>
    ): Prisma__InoutClient<InoutGetPayload<T>>

    /**
     * Create many Inouts.
     *     @param {InoutCreateManyArgs} args - Arguments to create many Inouts.
     *     @example
     *     // Create many Inouts
     *     const inout = await prisma.inout.createMany({
     *       data: {
     *         // ... provide data here
     *       }
     *     })
     *     
    **/
    createMany<T extends InoutCreateManyArgs>(
      args?: SelectSubset<T, InoutCreateManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Inout.
     * @param {InoutDeleteArgs} args - Arguments to delete one Inout.
     * @example
     * // Delete one Inout
     * const Inout = await prisma.inout.delete({
     *   where: {
     *     // ... filter to delete one Inout
     *   }
     * })
     * 
    **/
    delete<T extends InoutDeleteArgs>(
      args: SelectSubset<T, InoutDeleteArgs>
    ): Prisma__InoutClient<InoutGetPayload<T>>

    /**
     * Update one Inout.
     * @param {InoutUpdateArgs} args - Arguments to update one Inout.
     * @example
     * // Update one Inout
     * const inout = await prisma.inout.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends InoutUpdateArgs>(
      args: SelectSubset<T, InoutUpdateArgs>
    ): Prisma__InoutClient<InoutGetPayload<T>>

    /**
     * Delete zero or more Inouts.
     * @param {InoutDeleteManyArgs} args - Arguments to filter Inouts to delete.
     * @example
     * // Delete a few Inouts
     * const { count } = await prisma.inout.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends InoutDeleteManyArgs>(
      args?: SelectSubset<T, InoutDeleteManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Inouts.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {InoutUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Inouts
     * const inout = await prisma.inout.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends InoutUpdateManyArgs>(
      args: SelectSubset<T, InoutUpdateManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Inout.
     * @param {InoutUpsertArgs} args - Arguments to update or create a Inout.
     * @example
     * // Update or create a Inout
     * const inout = await prisma.inout.upsert({
     *   create: {
     *     // ... data to create a Inout
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Inout we want to update
     *   }
     * })
    **/
    upsert<T extends InoutUpsertArgs>(
      args: SelectSubset<T, InoutUpsertArgs>
    ): Prisma__InoutClient<InoutGetPayload<T>>

    /**
     * Count the number of Inouts.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {InoutCountArgs} args - Arguments to filter Inouts to count.
     * @example
     * // Count the number of Inouts
     * const count = await prisma.inout.count({
     *   where: {
     *     // ... the filter for the Inouts we want to count
     *   }
     * })
    **/
    count<T extends InoutCountArgs>(
      args?: Subset<T, InoutCountArgs>,
    ): Prisma.PrismaPromise<
      T extends _Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], InoutCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Inout.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {InoutAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends InoutAggregateArgs>(args: Subset<T, InoutAggregateArgs>): Prisma.PrismaPromise<GetInoutAggregateType<T>>

    /**
     * Group by Inout.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {InoutGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends InoutGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: InoutGroupByArgs['orderBy'] }
        : { orderBy?: InoutGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends TupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, InoutGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetInoutGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>

  }

  /**
   * The delegate class that acts as a "Promise-like" for Inout.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export class Prisma__InoutClient<T, Null = never> implements Prisma.PrismaPromise<T> {
    private readonly _dmmf;
    private readonly _queryType;
    private readonly _rootField;
    private readonly _clientMethod;
    private readonly _args;
    private readonly _dataPath;
    private readonly _errorFormat;
    private readonly _measurePerformance?;
    private _isList;
    private _callsite;
    private _requestPromise?;
    readonly [Symbol.toStringTag]: 'PrismaPromise';
    constructor(_dmmf: runtime.DMMFClass, _queryType: 'query' | 'mutation', _rootField: string, _clientMethod: string, _args: any, _dataPath: string[], _errorFormat: ErrorFormat, _measurePerformance?: boolean | undefined, _isList?: boolean);

    user<T extends UserArgs= {}>(args?: Subset<T, UserArgs>): Prisma__UserClient<UserGetPayload<T> | Null>;

    Inout_logs<T extends Inout$Inout_logsArgs= {}>(args?: Subset<T, Inout$Inout_logsArgs>): Prisma.PrismaPromise<Array<Inout_logsGetPayload<T>>| Null>;

    private get _document();
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): Promise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): Promise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): Promise<T>;
  }



  // Custom InputTypes

  /**
   * Inout base type for findUnique actions
   */
  export type InoutFindUniqueArgsBase = {
    /**
     * Select specific fields to fetch from the Inout
     */
    select?: InoutSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: InoutInclude | null
    /**
     * Filter, which Inout to fetch.
     */
    where: InoutWhereUniqueInput
  }

  /**
   * Inout findUnique
   */
  export interface InoutFindUniqueArgs extends InoutFindUniqueArgsBase {
   /**
    * Throw an Error if query returns no results
    * @deprecated since 4.0.0: use `findUniqueOrThrow` method instead
    */
    rejectOnNotFound?: RejectOnNotFound
  }
      

  /**
   * Inout findUniqueOrThrow
   */
  export type InoutFindUniqueOrThrowArgs = {
    /**
     * Select specific fields to fetch from the Inout
     */
    select?: InoutSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: InoutInclude | null
    /**
     * Filter, which Inout to fetch.
     */
    where: InoutWhereUniqueInput
  }


  /**
   * Inout base type for findFirst actions
   */
  export type InoutFindFirstArgsBase = {
    /**
     * Select specific fields to fetch from the Inout
     */
    select?: InoutSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: InoutInclude | null
    /**
     * Filter, which Inout to fetch.
     */
    where?: InoutWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Inouts to fetch.
     */
    orderBy?: Enumerable<InoutOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Inouts.
     */
    cursor?: InoutWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Inouts from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Inouts.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Inouts.
     */
    distinct?: Enumerable<InoutScalarFieldEnum>
  }

  /**
   * Inout findFirst
   */
  export interface InoutFindFirstArgs extends InoutFindFirstArgsBase {
   /**
    * Throw an Error if query returns no results
    * @deprecated since 4.0.0: use `findFirstOrThrow` method instead
    */
    rejectOnNotFound?: RejectOnNotFound
  }
      

  /**
   * Inout findFirstOrThrow
   */
  export type InoutFindFirstOrThrowArgs = {
    /**
     * Select specific fields to fetch from the Inout
     */
    select?: InoutSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: InoutInclude | null
    /**
     * Filter, which Inout to fetch.
     */
    where?: InoutWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Inouts to fetch.
     */
    orderBy?: Enumerable<InoutOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Inouts.
     */
    cursor?: InoutWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Inouts from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Inouts.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Inouts.
     */
    distinct?: Enumerable<InoutScalarFieldEnum>
  }


  /**
   * Inout findMany
   */
  export type InoutFindManyArgs = {
    /**
     * Select specific fields to fetch from the Inout
     */
    select?: InoutSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: InoutInclude | null
    /**
     * Filter, which Inouts to fetch.
     */
    where?: InoutWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Inouts to fetch.
     */
    orderBy?: Enumerable<InoutOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Inouts.
     */
    cursor?: InoutWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Inouts from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Inouts.
     */
    skip?: number
    distinct?: Enumerable<InoutScalarFieldEnum>
  }


  /**
   * Inout create
   */
  export type InoutCreateArgs = {
    /**
     * Select specific fields to fetch from the Inout
     */
    select?: InoutSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: InoutInclude | null
    /**
     * The data needed to create a Inout.
     */
    data: XOR<InoutCreateInput, InoutUncheckedCreateInput>
  }


  /**
   * Inout createMany
   */
  export type InoutCreateManyArgs = {
    /**
     * The data used to create many Inouts.
     */
    data: Enumerable<InoutCreateManyInput>
    skipDuplicates?: boolean
  }


  /**
   * Inout update
   */
  export type InoutUpdateArgs = {
    /**
     * Select specific fields to fetch from the Inout
     */
    select?: InoutSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: InoutInclude | null
    /**
     * The data needed to update a Inout.
     */
    data: XOR<InoutUpdateInput, InoutUncheckedUpdateInput>
    /**
     * Choose, which Inout to update.
     */
    where: InoutWhereUniqueInput
  }


  /**
   * Inout updateMany
   */
  export type InoutUpdateManyArgs = {
    /**
     * The data used to update Inouts.
     */
    data: XOR<InoutUpdateManyMutationInput, InoutUncheckedUpdateManyInput>
    /**
     * Filter which Inouts to update
     */
    where?: InoutWhereInput
  }


  /**
   * Inout upsert
   */
  export type InoutUpsertArgs = {
    /**
     * Select specific fields to fetch from the Inout
     */
    select?: InoutSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: InoutInclude | null
    /**
     * The filter to search for the Inout to update in case it exists.
     */
    where: InoutWhereUniqueInput
    /**
     * In case the Inout found by the `where` argument doesn't exist, create a new Inout with this data.
     */
    create: XOR<InoutCreateInput, InoutUncheckedCreateInput>
    /**
     * In case the Inout was found with the provided `where` argument, update it with this data.
     */
    update: XOR<InoutUpdateInput, InoutUncheckedUpdateInput>
  }


  /**
   * Inout delete
   */
  export type InoutDeleteArgs = {
    /**
     * Select specific fields to fetch from the Inout
     */
    select?: InoutSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: InoutInclude | null
    /**
     * Filter which Inout to delete.
     */
    where: InoutWhereUniqueInput
  }


  /**
   * Inout deleteMany
   */
  export type InoutDeleteManyArgs = {
    /**
     * Filter which Inouts to delete
     */
    where?: InoutWhereInput
  }


  /**
   * Inout.Inout_logs
   */
  export type Inout$Inout_logsArgs = {
    /**
     * Select specific fields to fetch from the Inout_logs
     */
    select?: Inout_logsSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: Inout_logsInclude | null
    where?: Inout_logsWhereInput
    orderBy?: Enumerable<Inout_logsOrderByWithRelationInput>
    cursor?: Inout_logsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: Enumerable<Inout_logsScalarFieldEnum>
  }


  /**
   * Inout without action
   */
  export type InoutArgs = {
    /**
     * Select specific fields to fetch from the Inout
     */
    select?: InoutSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: InoutInclude | null
  }



  /**
   * Model Inout_logs
   */


  export type AggregateInout_logs = {
    _count: Inout_logsCountAggregateOutputType | null
    _min: Inout_logsMinAggregateOutputType | null
    _max: Inout_logsMaxAggregateOutputType | null
  }

  export type Inout_logsMinAggregateOutputType = {
    id: string | null
    inout_id: string | null
    action: Log_Action | null
    old_time: Date | null
    new_time: Date | null
    description: string | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type Inout_logsMaxAggregateOutputType = {
    id: string | null
    inout_id: string | null
    action: Log_Action | null
    old_time: Date | null
    new_time: Date | null
    description: string | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type Inout_logsCountAggregateOutputType = {
    id: number
    inout_id: number
    action: number
    old_time: number
    new_time: number
    description: number
    createdAt: number
    updatedAt: number
    _all: number
  }


  export type Inout_logsMinAggregateInputType = {
    id?: true
    inout_id?: true
    action?: true
    old_time?: true
    new_time?: true
    description?: true
    createdAt?: true
    updatedAt?: true
  }

  export type Inout_logsMaxAggregateInputType = {
    id?: true
    inout_id?: true
    action?: true
    old_time?: true
    new_time?: true
    description?: true
    createdAt?: true
    updatedAt?: true
  }

  export type Inout_logsCountAggregateInputType = {
    id?: true
    inout_id?: true
    action?: true
    old_time?: true
    new_time?: true
    description?: true
    createdAt?: true
    updatedAt?: true
    _all?: true
  }

  export type Inout_logsAggregateArgs = {
    /**
     * Filter which Inout_logs to aggregate.
     */
    where?: Inout_logsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Inout_logs to fetch.
     */
    orderBy?: Enumerable<Inout_logsOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: Inout_logsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Inout_logs from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Inout_logs.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Inout_logs
    **/
    _count?: true | Inout_logsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Inout_logsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Inout_logsMaxAggregateInputType
  }

  export type GetInout_logsAggregateType<T extends Inout_logsAggregateArgs> = {
        [P in keyof T & keyof AggregateInout_logs]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateInout_logs[P]>
      : GetScalarType<T[P], AggregateInout_logs[P]>
  }




  export type Inout_logsGroupByArgs = {
    where?: Inout_logsWhereInput
    orderBy?: Enumerable<Inout_logsOrderByWithAggregationInput>
    by: Inout_logsScalarFieldEnum[]
    having?: Inout_logsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Inout_logsCountAggregateInputType | true
    _min?: Inout_logsMinAggregateInputType
    _max?: Inout_logsMaxAggregateInputType
  }


  export type Inout_logsGroupByOutputType = {
    id: string
    inout_id: string
    action: Log_Action
    old_time: Date | null
    new_time: Date | null
    description: string | null
    createdAt: Date
    updatedAt: Date
    _count: Inout_logsCountAggregateOutputType | null
    _min: Inout_logsMinAggregateOutputType | null
    _max: Inout_logsMaxAggregateOutputType | null
  }

  type GetInout_logsGroupByPayload<T extends Inout_logsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickArray<Inout_logsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Inout_logsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Inout_logsGroupByOutputType[P]>
            : GetScalarType<T[P], Inout_logsGroupByOutputType[P]>
        }
      >
    >


  export type Inout_logsSelect = {
    id?: boolean
    inout_id?: boolean
    action?: boolean
    old_time?: boolean
    new_time?: boolean
    description?: boolean
    createdAt?: boolean
    updatedAt?: boolean
    inout?: boolean | InoutArgs
  }


  export type Inout_logsInclude = {
    inout?: boolean | InoutArgs
  }

  export type Inout_logsGetPayload<S extends boolean | null | undefined | Inout_logsArgs> =
    S extends { select: any, include: any } ? 'Please either choose `select` or `include`' :
    S extends true ? Inout_logs :
    S extends undefined ? never :
    S extends { include: any } & (Inout_logsArgs | Inout_logsFindManyArgs)
    ? Inout_logs  & {
    [P in TruthyKeys<S['include']>]:
        P extends 'inout' ? InoutGetPayload<S['include'][P]> :  never
  } 
    : S extends { select: any } & (Inout_logsArgs | Inout_logsFindManyArgs)
      ? {
    [P in TruthyKeys<S['select']>]:
        P extends 'inout' ? InoutGetPayload<S['select'][P]> :  P extends keyof Inout_logs ? Inout_logs[P] : never
  } 
      : Inout_logs


  type Inout_logsCountArgs = 
    Omit<Inout_logsFindManyArgs, 'select' | 'include'> & {
      select?: Inout_logsCountAggregateInputType | true
    }

  export interface Inout_logsDelegate<GlobalRejectSettings extends Prisma.RejectOnNotFound | Prisma.RejectPerOperation | false | undefined> {

    /**
     * Find zero or one Inout_logs that matches the filter.
     * @param {Inout_logsFindUniqueArgs} args - Arguments to find a Inout_logs
     * @example
     * // Get one Inout_logs
     * const inout_logs = await prisma.inout_logs.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends Inout_logsFindUniqueArgs,  LocalRejectSettings = T["rejectOnNotFound"] extends RejectOnNotFound ? T['rejectOnNotFound'] : undefined>(
      args: SelectSubset<T, Inout_logsFindUniqueArgs>
    ): HasReject<GlobalRejectSettings, LocalRejectSettings, 'findUnique', 'Inout_logs'> extends True ? Prisma__Inout_logsClient<Inout_logsGetPayload<T>> : Prisma__Inout_logsClient<Inout_logsGetPayload<T> | null, null>

    /**
     * Find one Inout_logs that matches the filter or throw an error  with `error.code='P2025'` 
     *     if no matches were found.
     * @param {Inout_logsFindUniqueOrThrowArgs} args - Arguments to find a Inout_logs
     * @example
     * // Get one Inout_logs
     * const inout_logs = await prisma.inout_logs.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends Inout_logsFindUniqueOrThrowArgs>(
      args?: SelectSubset<T, Inout_logsFindUniqueOrThrowArgs>
    ): Prisma__Inout_logsClient<Inout_logsGetPayload<T>>

    /**
     * Find the first Inout_logs that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Inout_logsFindFirstArgs} args - Arguments to find a Inout_logs
     * @example
     * // Get one Inout_logs
     * const inout_logs = await prisma.inout_logs.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends Inout_logsFindFirstArgs,  LocalRejectSettings = T["rejectOnNotFound"] extends RejectOnNotFound ? T['rejectOnNotFound'] : undefined>(
      args?: SelectSubset<T, Inout_logsFindFirstArgs>
    ): HasReject<GlobalRejectSettings, LocalRejectSettings, 'findFirst', 'Inout_logs'> extends True ? Prisma__Inout_logsClient<Inout_logsGetPayload<T>> : Prisma__Inout_logsClient<Inout_logsGetPayload<T> | null, null>

    /**
     * Find the first Inout_logs that matches the filter or
     * throw `NotFoundError` if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Inout_logsFindFirstOrThrowArgs} args - Arguments to find a Inout_logs
     * @example
     * // Get one Inout_logs
     * const inout_logs = await prisma.inout_logs.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends Inout_logsFindFirstOrThrowArgs>(
      args?: SelectSubset<T, Inout_logsFindFirstOrThrowArgs>
    ): Prisma__Inout_logsClient<Inout_logsGetPayload<T>>

    /**
     * Find zero or more Inout_logs that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Inout_logsFindManyArgs=} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Inout_logs
     * const inout_logs = await prisma.inout_logs.findMany()
     * 
     * // Get first 10 Inout_logs
     * const inout_logs = await prisma.inout_logs.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const inout_logsWithIdOnly = await prisma.inout_logs.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends Inout_logsFindManyArgs>(
      args?: SelectSubset<T, Inout_logsFindManyArgs>
    ): Prisma.PrismaPromise<Array<Inout_logsGetPayload<T>>>

    /**
     * Create a Inout_logs.
     * @param {Inout_logsCreateArgs} args - Arguments to create a Inout_logs.
     * @example
     * // Create one Inout_logs
     * const Inout_logs = await prisma.inout_logs.create({
     *   data: {
     *     // ... data to create a Inout_logs
     *   }
     * })
     * 
    **/
    create<T extends Inout_logsCreateArgs>(
      args: SelectSubset<T, Inout_logsCreateArgs>
    ): Prisma__Inout_logsClient<Inout_logsGetPayload<T>>

    /**
     * Create many Inout_logs.
     *     @param {Inout_logsCreateManyArgs} args - Arguments to create many Inout_logs.
     *     @example
     *     // Create many Inout_logs
     *     const inout_logs = await prisma.inout_logs.createMany({
     *       data: {
     *         // ... provide data here
     *       }
     *     })
     *     
    **/
    createMany<T extends Inout_logsCreateManyArgs>(
      args?: SelectSubset<T, Inout_logsCreateManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Inout_logs.
     * @param {Inout_logsDeleteArgs} args - Arguments to delete one Inout_logs.
     * @example
     * // Delete one Inout_logs
     * const Inout_logs = await prisma.inout_logs.delete({
     *   where: {
     *     // ... filter to delete one Inout_logs
     *   }
     * })
     * 
    **/
    delete<T extends Inout_logsDeleteArgs>(
      args: SelectSubset<T, Inout_logsDeleteArgs>
    ): Prisma__Inout_logsClient<Inout_logsGetPayload<T>>

    /**
     * Update one Inout_logs.
     * @param {Inout_logsUpdateArgs} args - Arguments to update one Inout_logs.
     * @example
     * // Update one Inout_logs
     * const inout_logs = await prisma.inout_logs.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends Inout_logsUpdateArgs>(
      args: SelectSubset<T, Inout_logsUpdateArgs>
    ): Prisma__Inout_logsClient<Inout_logsGetPayload<T>>

    /**
     * Delete zero or more Inout_logs.
     * @param {Inout_logsDeleteManyArgs} args - Arguments to filter Inout_logs to delete.
     * @example
     * // Delete a few Inout_logs
     * const { count } = await prisma.inout_logs.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends Inout_logsDeleteManyArgs>(
      args?: SelectSubset<T, Inout_logsDeleteManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Inout_logs.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Inout_logsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Inout_logs
     * const inout_logs = await prisma.inout_logs.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends Inout_logsUpdateManyArgs>(
      args: SelectSubset<T, Inout_logsUpdateManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Inout_logs.
     * @param {Inout_logsUpsertArgs} args - Arguments to update or create a Inout_logs.
     * @example
     * // Update or create a Inout_logs
     * const inout_logs = await prisma.inout_logs.upsert({
     *   create: {
     *     // ... data to create a Inout_logs
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Inout_logs we want to update
     *   }
     * })
    **/
    upsert<T extends Inout_logsUpsertArgs>(
      args: SelectSubset<T, Inout_logsUpsertArgs>
    ): Prisma__Inout_logsClient<Inout_logsGetPayload<T>>

    /**
     * Count the number of Inout_logs.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Inout_logsCountArgs} args - Arguments to filter Inout_logs to count.
     * @example
     * // Count the number of Inout_logs
     * const count = await prisma.inout_logs.count({
     *   where: {
     *     // ... the filter for the Inout_logs we want to count
     *   }
     * })
    **/
    count<T extends Inout_logsCountArgs>(
      args?: Subset<T, Inout_logsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends _Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Inout_logsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Inout_logs.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Inout_logsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Inout_logsAggregateArgs>(args: Subset<T, Inout_logsAggregateArgs>): Prisma.PrismaPromise<GetInout_logsAggregateType<T>>

    /**
     * Group by Inout_logs.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Inout_logsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends Inout_logsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: Inout_logsGroupByArgs['orderBy'] }
        : { orderBy?: Inout_logsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends TupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, Inout_logsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetInout_logsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>

  }

  /**
   * The delegate class that acts as a "Promise-like" for Inout_logs.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export class Prisma__Inout_logsClient<T, Null = never> implements Prisma.PrismaPromise<T> {
    private readonly _dmmf;
    private readonly _queryType;
    private readonly _rootField;
    private readonly _clientMethod;
    private readonly _args;
    private readonly _dataPath;
    private readonly _errorFormat;
    private readonly _measurePerformance?;
    private _isList;
    private _callsite;
    private _requestPromise?;
    readonly [Symbol.toStringTag]: 'PrismaPromise';
    constructor(_dmmf: runtime.DMMFClass, _queryType: 'query' | 'mutation', _rootField: string, _clientMethod: string, _args: any, _dataPath: string[], _errorFormat: ErrorFormat, _measurePerformance?: boolean | undefined, _isList?: boolean);

    inout<T extends InoutArgs= {}>(args?: Subset<T, InoutArgs>): Prisma__InoutClient<InoutGetPayload<T> | Null>;

    private get _document();
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): Promise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): Promise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): Promise<T>;
  }



  // Custom InputTypes

  /**
   * Inout_logs base type for findUnique actions
   */
  export type Inout_logsFindUniqueArgsBase = {
    /**
     * Select specific fields to fetch from the Inout_logs
     */
    select?: Inout_logsSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: Inout_logsInclude | null
    /**
     * Filter, which Inout_logs to fetch.
     */
    where: Inout_logsWhereUniqueInput
  }

  /**
   * Inout_logs findUnique
   */
  export interface Inout_logsFindUniqueArgs extends Inout_logsFindUniqueArgsBase {
   /**
    * Throw an Error if query returns no results
    * @deprecated since 4.0.0: use `findUniqueOrThrow` method instead
    */
    rejectOnNotFound?: RejectOnNotFound
  }
      

  /**
   * Inout_logs findUniqueOrThrow
   */
  export type Inout_logsFindUniqueOrThrowArgs = {
    /**
     * Select specific fields to fetch from the Inout_logs
     */
    select?: Inout_logsSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: Inout_logsInclude | null
    /**
     * Filter, which Inout_logs to fetch.
     */
    where: Inout_logsWhereUniqueInput
  }


  /**
   * Inout_logs base type for findFirst actions
   */
  export type Inout_logsFindFirstArgsBase = {
    /**
     * Select specific fields to fetch from the Inout_logs
     */
    select?: Inout_logsSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: Inout_logsInclude | null
    /**
     * Filter, which Inout_logs to fetch.
     */
    where?: Inout_logsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Inout_logs to fetch.
     */
    orderBy?: Enumerable<Inout_logsOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Inout_logs.
     */
    cursor?: Inout_logsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Inout_logs from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Inout_logs.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Inout_logs.
     */
    distinct?: Enumerable<Inout_logsScalarFieldEnum>
  }

  /**
   * Inout_logs findFirst
   */
  export interface Inout_logsFindFirstArgs extends Inout_logsFindFirstArgsBase {
   /**
    * Throw an Error if query returns no results
    * @deprecated since 4.0.0: use `findFirstOrThrow` method instead
    */
    rejectOnNotFound?: RejectOnNotFound
  }
      

  /**
   * Inout_logs findFirstOrThrow
   */
  export type Inout_logsFindFirstOrThrowArgs = {
    /**
     * Select specific fields to fetch from the Inout_logs
     */
    select?: Inout_logsSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: Inout_logsInclude | null
    /**
     * Filter, which Inout_logs to fetch.
     */
    where?: Inout_logsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Inout_logs to fetch.
     */
    orderBy?: Enumerable<Inout_logsOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Inout_logs.
     */
    cursor?: Inout_logsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Inout_logs from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Inout_logs.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Inout_logs.
     */
    distinct?: Enumerable<Inout_logsScalarFieldEnum>
  }


  /**
   * Inout_logs findMany
   */
  export type Inout_logsFindManyArgs = {
    /**
     * Select specific fields to fetch from the Inout_logs
     */
    select?: Inout_logsSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: Inout_logsInclude | null
    /**
     * Filter, which Inout_logs to fetch.
     */
    where?: Inout_logsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Inout_logs to fetch.
     */
    orderBy?: Enumerable<Inout_logsOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Inout_logs.
     */
    cursor?: Inout_logsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Inout_logs from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Inout_logs.
     */
    skip?: number
    distinct?: Enumerable<Inout_logsScalarFieldEnum>
  }


  /**
   * Inout_logs create
   */
  export type Inout_logsCreateArgs = {
    /**
     * Select specific fields to fetch from the Inout_logs
     */
    select?: Inout_logsSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: Inout_logsInclude | null
    /**
     * The data needed to create a Inout_logs.
     */
    data: XOR<Inout_logsCreateInput, Inout_logsUncheckedCreateInput>
  }


  /**
   * Inout_logs createMany
   */
  export type Inout_logsCreateManyArgs = {
    /**
     * The data used to create many Inout_logs.
     */
    data: Enumerable<Inout_logsCreateManyInput>
    skipDuplicates?: boolean
  }


  /**
   * Inout_logs update
   */
  export type Inout_logsUpdateArgs = {
    /**
     * Select specific fields to fetch from the Inout_logs
     */
    select?: Inout_logsSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: Inout_logsInclude | null
    /**
     * The data needed to update a Inout_logs.
     */
    data: XOR<Inout_logsUpdateInput, Inout_logsUncheckedUpdateInput>
    /**
     * Choose, which Inout_logs to update.
     */
    where: Inout_logsWhereUniqueInput
  }


  /**
   * Inout_logs updateMany
   */
  export type Inout_logsUpdateManyArgs = {
    /**
     * The data used to update Inout_logs.
     */
    data: XOR<Inout_logsUpdateManyMutationInput, Inout_logsUncheckedUpdateManyInput>
    /**
     * Filter which Inout_logs to update
     */
    where?: Inout_logsWhereInput
  }


  /**
   * Inout_logs upsert
   */
  export type Inout_logsUpsertArgs = {
    /**
     * Select specific fields to fetch from the Inout_logs
     */
    select?: Inout_logsSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: Inout_logsInclude | null
    /**
     * The filter to search for the Inout_logs to update in case it exists.
     */
    where: Inout_logsWhereUniqueInput
    /**
     * In case the Inout_logs found by the `where` argument doesn't exist, create a new Inout_logs with this data.
     */
    create: XOR<Inout_logsCreateInput, Inout_logsUncheckedCreateInput>
    /**
     * In case the Inout_logs was found with the provided `where` argument, update it with this data.
     */
    update: XOR<Inout_logsUpdateInput, Inout_logsUncheckedUpdateInput>
  }


  /**
   * Inout_logs delete
   */
  export type Inout_logsDeleteArgs = {
    /**
     * Select specific fields to fetch from the Inout_logs
     */
    select?: Inout_logsSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: Inout_logsInclude | null
    /**
     * Filter which Inout_logs to delete.
     */
    where: Inout_logsWhereUniqueInput
  }


  /**
   * Inout_logs deleteMany
   */
  export type Inout_logsDeleteManyArgs = {
    /**
     * Filter which Inout_logs to delete
     */
    where?: Inout_logsWhereInput
  }


  /**
   * Inout_logs without action
   */
  export type Inout_logsArgs = {
    /**
     * Select specific fields to fetch from the Inout_logs
     */
    select?: Inout_logsSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: Inout_logsInclude | null
  }



  /**
   * Model Holiday
   */


  export type AggregateHoliday = {
    _count: HolidayCountAggregateOutputType | null
    _min: HolidayMinAggregateOutputType | null
    _max: HolidayMaxAggregateOutputType | null
  }

  export type HolidayMinAggregateOutputType = {
    date: Date | null
  }

  export type HolidayMaxAggregateOutputType = {
    date: Date | null
  }

  export type HolidayCountAggregateOutputType = {
    date: number
    _all: number
  }


  export type HolidayMinAggregateInputType = {
    date?: true
  }

  export type HolidayMaxAggregateInputType = {
    date?: true
  }

  export type HolidayCountAggregateInputType = {
    date?: true
    _all?: true
  }

  export type HolidayAggregateArgs = {
    /**
     * Filter which Holiday to aggregate.
     */
    where?: HolidayWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Holidays to fetch.
     */
    orderBy?: Enumerable<HolidayOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: HolidayWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Holidays from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Holidays.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Holidays
    **/
    _count?: true | HolidayCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: HolidayMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: HolidayMaxAggregateInputType
  }

  export type GetHolidayAggregateType<T extends HolidayAggregateArgs> = {
        [P in keyof T & keyof AggregateHoliday]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateHoliday[P]>
      : GetScalarType<T[P], AggregateHoliday[P]>
  }




  export type HolidayGroupByArgs = {
    where?: HolidayWhereInput
    orderBy?: Enumerable<HolidayOrderByWithAggregationInput>
    by: HolidayScalarFieldEnum[]
    having?: HolidayScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: HolidayCountAggregateInputType | true
    _min?: HolidayMinAggregateInputType
    _max?: HolidayMaxAggregateInputType
  }


  export type HolidayGroupByOutputType = {
    date: Date
    _count: HolidayCountAggregateOutputType | null
    _min: HolidayMinAggregateOutputType | null
    _max: HolidayMaxAggregateOutputType | null
  }

  type GetHolidayGroupByPayload<T extends HolidayGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickArray<HolidayGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof HolidayGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], HolidayGroupByOutputType[P]>
            : GetScalarType<T[P], HolidayGroupByOutputType[P]>
        }
      >
    >


  export type HolidaySelect = {
    date?: boolean
  }


  export type HolidayGetPayload<S extends boolean | null | undefined | HolidayArgs> =
    S extends { select: any, include: any } ? 'Please either choose `select` or `include`' :
    S extends true ? Holiday :
    S extends undefined ? never :
    S extends { include: any } & (HolidayArgs | HolidayFindManyArgs)
    ? Holiday 
    : S extends { select: any } & (HolidayArgs | HolidayFindManyArgs)
      ? {
    [P in TruthyKeys<S['select']>]:
    P extends keyof Holiday ? Holiday[P] : never
  } 
      : Holiday


  type HolidayCountArgs = 
    Omit<HolidayFindManyArgs, 'select' | 'include'> & {
      select?: HolidayCountAggregateInputType | true
    }

  export interface HolidayDelegate<GlobalRejectSettings extends Prisma.RejectOnNotFound | Prisma.RejectPerOperation | false | undefined> {

    /**
     * Find zero or one Holiday that matches the filter.
     * @param {HolidayFindUniqueArgs} args - Arguments to find a Holiday
     * @example
     * // Get one Holiday
     * const holiday = await prisma.holiday.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends HolidayFindUniqueArgs,  LocalRejectSettings = T["rejectOnNotFound"] extends RejectOnNotFound ? T['rejectOnNotFound'] : undefined>(
      args: SelectSubset<T, HolidayFindUniqueArgs>
    ): HasReject<GlobalRejectSettings, LocalRejectSettings, 'findUnique', 'Holiday'> extends True ? Prisma__HolidayClient<HolidayGetPayload<T>> : Prisma__HolidayClient<HolidayGetPayload<T> | null, null>

    /**
     * Find one Holiday that matches the filter or throw an error  with `error.code='P2025'` 
     *     if no matches were found.
     * @param {HolidayFindUniqueOrThrowArgs} args - Arguments to find a Holiday
     * @example
     * // Get one Holiday
     * const holiday = await prisma.holiday.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends HolidayFindUniqueOrThrowArgs>(
      args?: SelectSubset<T, HolidayFindUniqueOrThrowArgs>
    ): Prisma__HolidayClient<HolidayGetPayload<T>>

    /**
     * Find the first Holiday that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HolidayFindFirstArgs} args - Arguments to find a Holiday
     * @example
     * // Get one Holiday
     * const holiday = await prisma.holiday.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends HolidayFindFirstArgs,  LocalRejectSettings = T["rejectOnNotFound"] extends RejectOnNotFound ? T['rejectOnNotFound'] : undefined>(
      args?: SelectSubset<T, HolidayFindFirstArgs>
    ): HasReject<GlobalRejectSettings, LocalRejectSettings, 'findFirst', 'Holiday'> extends True ? Prisma__HolidayClient<HolidayGetPayload<T>> : Prisma__HolidayClient<HolidayGetPayload<T> | null, null>

    /**
     * Find the first Holiday that matches the filter or
     * throw `NotFoundError` if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HolidayFindFirstOrThrowArgs} args - Arguments to find a Holiday
     * @example
     * // Get one Holiday
     * const holiday = await prisma.holiday.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends HolidayFindFirstOrThrowArgs>(
      args?: SelectSubset<T, HolidayFindFirstOrThrowArgs>
    ): Prisma__HolidayClient<HolidayGetPayload<T>>

    /**
     * Find zero or more Holidays that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HolidayFindManyArgs=} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Holidays
     * const holidays = await prisma.holiday.findMany()
     * 
     * // Get first 10 Holidays
     * const holidays = await prisma.holiday.findMany({ take: 10 })
     * 
     * // Only select the `date`
     * const holidayWithDateOnly = await prisma.holiday.findMany({ select: { date: true } })
     * 
    **/
    findMany<T extends HolidayFindManyArgs>(
      args?: SelectSubset<T, HolidayFindManyArgs>
    ): Prisma.PrismaPromise<Array<HolidayGetPayload<T>>>

    /**
     * Create a Holiday.
     * @param {HolidayCreateArgs} args - Arguments to create a Holiday.
     * @example
     * // Create one Holiday
     * const Holiday = await prisma.holiday.create({
     *   data: {
     *     // ... data to create a Holiday
     *   }
     * })
     * 
    **/
    create<T extends HolidayCreateArgs>(
      args: SelectSubset<T, HolidayCreateArgs>
    ): Prisma__HolidayClient<HolidayGetPayload<T>>

    /**
     * Create many Holidays.
     *     @param {HolidayCreateManyArgs} args - Arguments to create many Holidays.
     *     @example
     *     // Create many Holidays
     *     const holiday = await prisma.holiday.createMany({
     *       data: {
     *         // ... provide data here
     *       }
     *     })
     *     
    **/
    createMany<T extends HolidayCreateManyArgs>(
      args?: SelectSubset<T, HolidayCreateManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Holiday.
     * @param {HolidayDeleteArgs} args - Arguments to delete one Holiday.
     * @example
     * // Delete one Holiday
     * const Holiday = await prisma.holiday.delete({
     *   where: {
     *     // ... filter to delete one Holiday
     *   }
     * })
     * 
    **/
    delete<T extends HolidayDeleteArgs>(
      args: SelectSubset<T, HolidayDeleteArgs>
    ): Prisma__HolidayClient<HolidayGetPayload<T>>

    /**
     * Update one Holiday.
     * @param {HolidayUpdateArgs} args - Arguments to update one Holiday.
     * @example
     * // Update one Holiday
     * const holiday = await prisma.holiday.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends HolidayUpdateArgs>(
      args: SelectSubset<T, HolidayUpdateArgs>
    ): Prisma__HolidayClient<HolidayGetPayload<T>>

    /**
     * Delete zero or more Holidays.
     * @param {HolidayDeleteManyArgs} args - Arguments to filter Holidays to delete.
     * @example
     * // Delete a few Holidays
     * const { count } = await prisma.holiday.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends HolidayDeleteManyArgs>(
      args?: SelectSubset<T, HolidayDeleteManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Holidays.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HolidayUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Holidays
     * const holiday = await prisma.holiday.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends HolidayUpdateManyArgs>(
      args: SelectSubset<T, HolidayUpdateManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Holiday.
     * @param {HolidayUpsertArgs} args - Arguments to update or create a Holiday.
     * @example
     * // Update or create a Holiday
     * const holiday = await prisma.holiday.upsert({
     *   create: {
     *     // ... data to create a Holiday
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Holiday we want to update
     *   }
     * })
    **/
    upsert<T extends HolidayUpsertArgs>(
      args: SelectSubset<T, HolidayUpsertArgs>
    ): Prisma__HolidayClient<HolidayGetPayload<T>>

    /**
     * Count the number of Holidays.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HolidayCountArgs} args - Arguments to filter Holidays to count.
     * @example
     * // Count the number of Holidays
     * const count = await prisma.holiday.count({
     *   where: {
     *     // ... the filter for the Holidays we want to count
     *   }
     * })
    **/
    count<T extends HolidayCountArgs>(
      args?: Subset<T, HolidayCountArgs>,
    ): Prisma.PrismaPromise<
      T extends _Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], HolidayCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Holiday.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HolidayAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends HolidayAggregateArgs>(args: Subset<T, HolidayAggregateArgs>): Prisma.PrismaPromise<GetHolidayAggregateType<T>>

    /**
     * Group by Holiday.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HolidayGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends HolidayGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: HolidayGroupByArgs['orderBy'] }
        : { orderBy?: HolidayGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends TupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, HolidayGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetHolidayGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>

  }

  /**
   * The delegate class that acts as a "Promise-like" for Holiday.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export class Prisma__HolidayClient<T, Null = never> implements Prisma.PrismaPromise<T> {
    private readonly _dmmf;
    private readonly _queryType;
    private readonly _rootField;
    private readonly _clientMethod;
    private readonly _args;
    private readonly _dataPath;
    private readonly _errorFormat;
    private readonly _measurePerformance?;
    private _isList;
    private _callsite;
    private _requestPromise?;
    readonly [Symbol.toStringTag]: 'PrismaPromise';
    constructor(_dmmf: runtime.DMMFClass, _queryType: 'query' | 'mutation', _rootField: string, _clientMethod: string, _args: any, _dataPath: string[], _errorFormat: ErrorFormat, _measurePerformance?: boolean | undefined, _isList?: boolean);


    private get _document();
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): Promise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): Promise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): Promise<T>;
  }



  // Custom InputTypes

  /**
   * Holiday base type for findUnique actions
   */
  export type HolidayFindUniqueArgsBase = {
    /**
     * Select specific fields to fetch from the Holiday
     */
    select?: HolidaySelect | null
    /**
     * Filter, which Holiday to fetch.
     */
    where: HolidayWhereUniqueInput
  }

  /**
   * Holiday findUnique
   */
  export interface HolidayFindUniqueArgs extends HolidayFindUniqueArgsBase {
   /**
    * Throw an Error if query returns no results
    * @deprecated since 4.0.0: use `findUniqueOrThrow` method instead
    */
    rejectOnNotFound?: RejectOnNotFound
  }
      

  /**
   * Holiday findUniqueOrThrow
   */
  export type HolidayFindUniqueOrThrowArgs = {
    /**
     * Select specific fields to fetch from the Holiday
     */
    select?: HolidaySelect | null
    /**
     * Filter, which Holiday to fetch.
     */
    where: HolidayWhereUniqueInput
  }


  /**
   * Holiday base type for findFirst actions
   */
  export type HolidayFindFirstArgsBase = {
    /**
     * Select specific fields to fetch from the Holiday
     */
    select?: HolidaySelect | null
    /**
     * Filter, which Holiday to fetch.
     */
    where?: HolidayWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Holidays to fetch.
     */
    orderBy?: Enumerable<HolidayOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Holidays.
     */
    cursor?: HolidayWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Holidays from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Holidays.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Holidays.
     */
    distinct?: Enumerable<HolidayScalarFieldEnum>
  }

  /**
   * Holiday findFirst
   */
  export interface HolidayFindFirstArgs extends HolidayFindFirstArgsBase {
   /**
    * Throw an Error if query returns no results
    * @deprecated since 4.0.0: use `findFirstOrThrow` method instead
    */
    rejectOnNotFound?: RejectOnNotFound
  }
      

  /**
   * Holiday findFirstOrThrow
   */
  export type HolidayFindFirstOrThrowArgs = {
    /**
     * Select specific fields to fetch from the Holiday
     */
    select?: HolidaySelect | null
    /**
     * Filter, which Holiday to fetch.
     */
    where?: HolidayWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Holidays to fetch.
     */
    orderBy?: Enumerable<HolidayOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Holidays.
     */
    cursor?: HolidayWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Holidays from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Holidays.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Holidays.
     */
    distinct?: Enumerable<HolidayScalarFieldEnum>
  }


  /**
   * Holiday findMany
   */
  export type HolidayFindManyArgs = {
    /**
     * Select specific fields to fetch from the Holiday
     */
    select?: HolidaySelect | null
    /**
     * Filter, which Holidays to fetch.
     */
    where?: HolidayWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Holidays to fetch.
     */
    orderBy?: Enumerable<HolidayOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Holidays.
     */
    cursor?: HolidayWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Holidays from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Holidays.
     */
    skip?: number
    distinct?: Enumerable<HolidayScalarFieldEnum>
  }


  /**
   * Holiday create
   */
  export type HolidayCreateArgs = {
    /**
     * Select specific fields to fetch from the Holiday
     */
    select?: HolidaySelect | null
    /**
     * The data needed to create a Holiday.
     */
    data: XOR<HolidayCreateInput, HolidayUncheckedCreateInput>
  }


  /**
   * Holiday createMany
   */
  export type HolidayCreateManyArgs = {
    /**
     * The data used to create many Holidays.
     */
    data: Enumerable<HolidayCreateManyInput>
    skipDuplicates?: boolean
  }


  /**
   * Holiday update
   */
  export type HolidayUpdateArgs = {
    /**
     * Select specific fields to fetch from the Holiday
     */
    select?: HolidaySelect | null
    /**
     * The data needed to update a Holiday.
     */
    data: XOR<HolidayUpdateInput, HolidayUncheckedUpdateInput>
    /**
     * Choose, which Holiday to update.
     */
    where: HolidayWhereUniqueInput
  }


  /**
   * Holiday updateMany
   */
  export type HolidayUpdateManyArgs = {
    /**
     * The data used to update Holidays.
     */
    data: XOR<HolidayUpdateManyMutationInput, HolidayUncheckedUpdateManyInput>
    /**
     * Filter which Holidays to update
     */
    where?: HolidayWhereInput
  }


  /**
   * Holiday upsert
   */
  export type HolidayUpsertArgs = {
    /**
     * Select specific fields to fetch from the Holiday
     */
    select?: HolidaySelect | null
    /**
     * The filter to search for the Holiday to update in case it exists.
     */
    where: HolidayWhereUniqueInput
    /**
     * In case the Holiday found by the `where` argument doesn't exist, create a new Holiday with this data.
     */
    create: XOR<HolidayCreateInput, HolidayUncheckedCreateInput>
    /**
     * In case the Holiday was found with the provided `where` argument, update it with this data.
     */
    update: XOR<HolidayUpdateInput, HolidayUncheckedUpdateInput>
  }


  /**
   * Holiday delete
   */
  export type HolidayDeleteArgs = {
    /**
     * Select specific fields to fetch from the Holiday
     */
    select?: HolidaySelect | null
    /**
     * Filter which Holiday to delete.
     */
    where: HolidayWhereUniqueInput
  }


  /**
   * Holiday deleteMany
   */
  export type HolidayDeleteManyArgs = {
    /**
     * Filter which Holidays to delete
     */
    where?: HolidayWhereInput
  }


  /**
   * Holiday without action
   */
  export type HolidayArgs = {
    /**
     * Select specific fields to fetch from the Holiday
     */
    select?: HolidaySelect | null
  }



  /**
   * Model Notification
   */


  export type AggregateNotification = {
    _count: NotificationCountAggregateOutputType | null
    _min: NotificationMinAggregateOutputType | null
    _max: NotificationMaxAggregateOutputType | null
  }

  export type NotificationMinAggregateOutputType = {
    id: string | null
    title: string | null
    content: string | null
    file_id: string | null
    author_id: string | null
    createdAt: Date | null
  }

  export type NotificationMaxAggregateOutputType = {
    id: string | null
    title: string | null
    content: string | null
    file_id: string | null
    author_id: string | null
    createdAt: Date | null
  }

  export type NotificationCountAggregateOutputType = {
    id: number
    title: number
    content: number
    file_id: number
    author_id: number
    createdAt: number
    _all: number
  }


  export type NotificationMinAggregateInputType = {
    id?: true
    title?: true
    content?: true
    file_id?: true
    author_id?: true
    createdAt?: true
  }

  export type NotificationMaxAggregateInputType = {
    id?: true
    title?: true
    content?: true
    file_id?: true
    author_id?: true
    createdAt?: true
  }

  export type NotificationCountAggregateInputType = {
    id?: true
    title?: true
    content?: true
    file_id?: true
    author_id?: true
    createdAt?: true
    _all?: true
  }

  export type NotificationAggregateArgs = {
    /**
     * Filter which Notification to aggregate.
     */
    where?: NotificationWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Notifications to fetch.
     */
    orderBy?: Enumerable<NotificationOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: NotificationWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Notifications from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Notifications.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Notifications
    **/
    _count?: true | NotificationCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: NotificationMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: NotificationMaxAggregateInputType
  }

  export type GetNotificationAggregateType<T extends NotificationAggregateArgs> = {
        [P in keyof T & keyof AggregateNotification]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateNotification[P]>
      : GetScalarType<T[P], AggregateNotification[P]>
  }




  export type NotificationGroupByArgs = {
    where?: NotificationWhereInput
    orderBy?: Enumerable<NotificationOrderByWithAggregationInput>
    by: NotificationScalarFieldEnum[]
    having?: NotificationScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: NotificationCountAggregateInputType | true
    _min?: NotificationMinAggregateInputType
    _max?: NotificationMaxAggregateInputType
  }


  export type NotificationGroupByOutputType = {
    id: string
    title: string
    content: string
    file_id: string | null
    author_id: string
    createdAt: Date
    _count: NotificationCountAggregateOutputType | null
    _min: NotificationMinAggregateOutputType | null
    _max: NotificationMaxAggregateOutputType | null
  }

  type GetNotificationGroupByPayload<T extends NotificationGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickArray<NotificationGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof NotificationGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], NotificationGroupByOutputType[P]>
            : GetScalarType<T[P], NotificationGroupByOutputType[P]>
        }
      >
    >


  export type NotificationSelect = {
    id?: boolean
    title?: boolean
    content?: boolean
    file_id?: boolean
    author_id?: boolean
    createdAt?: boolean
    file?: boolean | FileArgs
    author?: boolean | UserArgs
    Notification_Receiver?: boolean | Notification$Notification_ReceiverArgs
    _count?: boolean | NotificationCountOutputTypeArgs
  }


  export type NotificationInclude = {
    file?: boolean | FileArgs
    author?: boolean | UserArgs
    Notification_Receiver?: boolean | Notification$Notification_ReceiverArgs
    _count?: boolean | NotificationCountOutputTypeArgs
  }

  export type NotificationGetPayload<S extends boolean | null | undefined | NotificationArgs> =
    S extends { select: any, include: any } ? 'Please either choose `select` or `include`' :
    S extends true ? Notification :
    S extends undefined ? never :
    S extends { include: any } & (NotificationArgs | NotificationFindManyArgs)
    ? Notification  & {
    [P in TruthyKeys<S['include']>]:
        P extends 'file' ? FileGetPayload<S['include'][P]> | null :
        P extends 'author' ? UserGetPayload<S['include'][P]> :
        P extends 'Notification_Receiver' ? Array < Notification_ReceiverGetPayload<S['include'][P]>>  :
        P extends '_count' ? NotificationCountOutputTypeGetPayload<S['include'][P]> :  never
  } 
    : S extends { select: any } & (NotificationArgs | NotificationFindManyArgs)
      ? {
    [P in TruthyKeys<S['select']>]:
        P extends 'file' ? FileGetPayload<S['select'][P]> | null :
        P extends 'author' ? UserGetPayload<S['select'][P]> :
        P extends 'Notification_Receiver' ? Array < Notification_ReceiverGetPayload<S['select'][P]>>  :
        P extends '_count' ? NotificationCountOutputTypeGetPayload<S['select'][P]> :  P extends keyof Notification ? Notification[P] : never
  } 
      : Notification


  type NotificationCountArgs = 
    Omit<NotificationFindManyArgs, 'select' | 'include'> & {
      select?: NotificationCountAggregateInputType | true
    }

  export interface NotificationDelegate<GlobalRejectSettings extends Prisma.RejectOnNotFound | Prisma.RejectPerOperation | false | undefined> {

    /**
     * Find zero or one Notification that matches the filter.
     * @param {NotificationFindUniqueArgs} args - Arguments to find a Notification
     * @example
     * // Get one Notification
     * const notification = await prisma.notification.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends NotificationFindUniqueArgs,  LocalRejectSettings = T["rejectOnNotFound"] extends RejectOnNotFound ? T['rejectOnNotFound'] : undefined>(
      args: SelectSubset<T, NotificationFindUniqueArgs>
    ): HasReject<GlobalRejectSettings, LocalRejectSettings, 'findUnique', 'Notification'> extends True ? Prisma__NotificationClient<NotificationGetPayload<T>> : Prisma__NotificationClient<NotificationGetPayload<T> | null, null>

    /**
     * Find one Notification that matches the filter or throw an error  with `error.code='P2025'` 
     *     if no matches were found.
     * @param {NotificationFindUniqueOrThrowArgs} args - Arguments to find a Notification
     * @example
     * // Get one Notification
     * const notification = await prisma.notification.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends NotificationFindUniqueOrThrowArgs>(
      args?: SelectSubset<T, NotificationFindUniqueOrThrowArgs>
    ): Prisma__NotificationClient<NotificationGetPayload<T>>

    /**
     * Find the first Notification that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {NotificationFindFirstArgs} args - Arguments to find a Notification
     * @example
     * // Get one Notification
     * const notification = await prisma.notification.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends NotificationFindFirstArgs,  LocalRejectSettings = T["rejectOnNotFound"] extends RejectOnNotFound ? T['rejectOnNotFound'] : undefined>(
      args?: SelectSubset<T, NotificationFindFirstArgs>
    ): HasReject<GlobalRejectSettings, LocalRejectSettings, 'findFirst', 'Notification'> extends True ? Prisma__NotificationClient<NotificationGetPayload<T>> : Prisma__NotificationClient<NotificationGetPayload<T> | null, null>

    /**
     * Find the first Notification that matches the filter or
     * throw `NotFoundError` if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {NotificationFindFirstOrThrowArgs} args - Arguments to find a Notification
     * @example
     * // Get one Notification
     * const notification = await prisma.notification.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends NotificationFindFirstOrThrowArgs>(
      args?: SelectSubset<T, NotificationFindFirstOrThrowArgs>
    ): Prisma__NotificationClient<NotificationGetPayload<T>>

    /**
     * Find zero or more Notifications that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {NotificationFindManyArgs=} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Notifications
     * const notifications = await prisma.notification.findMany()
     * 
     * // Get first 10 Notifications
     * const notifications = await prisma.notification.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const notificationWithIdOnly = await prisma.notification.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends NotificationFindManyArgs>(
      args?: SelectSubset<T, NotificationFindManyArgs>
    ): Prisma.PrismaPromise<Array<NotificationGetPayload<T>>>

    /**
     * Create a Notification.
     * @param {NotificationCreateArgs} args - Arguments to create a Notification.
     * @example
     * // Create one Notification
     * const Notification = await prisma.notification.create({
     *   data: {
     *     // ... data to create a Notification
     *   }
     * })
     * 
    **/
    create<T extends NotificationCreateArgs>(
      args: SelectSubset<T, NotificationCreateArgs>
    ): Prisma__NotificationClient<NotificationGetPayload<T>>

    /**
     * Create many Notifications.
     *     @param {NotificationCreateManyArgs} args - Arguments to create many Notifications.
     *     @example
     *     // Create many Notifications
     *     const notification = await prisma.notification.createMany({
     *       data: {
     *         // ... provide data here
     *       }
     *     })
     *     
    **/
    createMany<T extends NotificationCreateManyArgs>(
      args?: SelectSubset<T, NotificationCreateManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Notification.
     * @param {NotificationDeleteArgs} args - Arguments to delete one Notification.
     * @example
     * // Delete one Notification
     * const Notification = await prisma.notification.delete({
     *   where: {
     *     // ... filter to delete one Notification
     *   }
     * })
     * 
    **/
    delete<T extends NotificationDeleteArgs>(
      args: SelectSubset<T, NotificationDeleteArgs>
    ): Prisma__NotificationClient<NotificationGetPayload<T>>

    /**
     * Update one Notification.
     * @param {NotificationUpdateArgs} args - Arguments to update one Notification.
     * @example
     * // Update one Notification
     * const notification = await prisma.notification.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends NotificationUpdateArgs>(
      args: SelectSubset<T, NotificationUpdateArgs>
    ): Prisma__NotificationClient<NotificationGetPayload<T>>

    /**
     * Delete zero or more Notifications.
     * @param {NotificationDeleteManyArgs} args - Arguments to filter Notifications to delete.
     * @example
     * // Delete a few Notifications
     * const { count } = await prisma.notification.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends NotificationDeleteManyArgs>(
      args?: SelectSubset<T, NotificationDeleteManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Notifications.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {NotificationUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Notifications
     * const notification = await prisma.notification.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends NotificationUpdateManyArgs>(
      args: SelectSubset<T, NotificationUpdateManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Notification.
     * @param {NotificationUpsertArgs} args - Arguments to update or create a Notification.
     * @example
     * // Update or create a Notification
     * const notification = await prisma.notification.upsert({
     *   create: {
     *     // ... data to create a Notification
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Notification we want to update
     *   }
     * })
    **/
    upsert<T extends NotificationUpsertArgs>(
      args: SelectSubset<T, NotificationUpsertArgs>
    ): Prisma__NotificationClient<NotificationGetPayload<T>>

    /**
     * Count the number of Notifications.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {NotificationCountArgs} args - Arguments to filter Notifications to count.
     * @example
     * // Count the number of Notifications
     * const count = await prisma.notification.count({
     *   where: {
     *     // ... the filter for the Notifications we want to count
     *   }
     * })
    **/
    count<T extends NotificationCountArgs>(
      args?: Subset<T, NotificationCountArgs>,
    ): Prisma.PrismaPromise<
      T extends _Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], NotificationCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Notification.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {NotificationAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends NotificationAggregateArgs>(args: Subset<T, NotificationAggregateArgs>): Prisma.PrismaPromise<GetNotificationAggregateType<T>>

    /**
     * Group by Notification.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {NotificationGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends NotificationGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: NotificationGroupByArgs['orderBy'] }
        : { orderBy?: NotificationGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends TupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, NotificationGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetNotificationGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>

  }

  /**
   * The delegate class that acts as a "Promise-like" for Notification.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export class Prisma__NotificationClient<T, Null = never> implements Prisma.PrismaPromise<T> {
    private readonly _dmmf;
    private readonly _queryType;
    private readonly _rootField;
    private readonly _clientMethod;
    private readonly _args;
    private readonly _dataPath;
    private readonly _errorFormat;
    private readonly _measurePerformance?;
    private _isList;
    private _callsite;
    private _requestPromise?;
    readonly [Symbol.toStringTag]: 'PrismaPromise';
    constructor(_dmmf: runtime.DMMFClass, _queryType: 'query' | 'mutation', _rootField: string, _clientMethod: string, _args: any, _dataPath: string[], _errorFormat: ErrorFormat, _measurePerformance?: boolean | undefined, _isList?: boolean);

    file<T extends FileArgs= {}>(args?: Subset<T, FileArgs>): Prisma__FileClient<FileGetPayload<T> | Null>;

    author<T extends UserArgs= {}>(args?: Subset<T, UserArgs>): Prisma__UserClient<UserGetPayload<T> | Null>;

    Notification_Receiver<T extends Notification$Notification_ReceiverArgs= {}>(args?: Subset<T, Notification$Notification_ReceiverArgs>): Prisma.PrismaPromise<Array<Notification_ReceiverGetPayload<T>>| Null>;

    private get _document();
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): Promise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): Promise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): Promise<T>;
  }



  // Custom InputTypes

  /**
   * Notification base type for findUnique actions
   */
  export type NotificationFindUniqueArgsBase = {
    /**
     * Select specific fields to fetch from the Notification
     */
    select?: NotificationSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: NotificationInclude | null
    /**
     * Filter, which Notification to fetch.
     */
    where: NotificationWhereUniqueInput
  }

  /**
   * Notification findUnique
   */
  export interface NotificationFindUniqueArgs extends NotificationFindUniqueArgsBase {
   /**
    * Throw an Error if query returns no results
    * @deprecated since 4.0.0: use `findUniqueOrThrow` method instead
    */
    rejectOnNotFound?: RejectOnNotFound
  }
      

  /**
   * Notification findUniqueOrThrow
   */
  export type NotificationFindUniqueOrThrowArgs = {
    /**
     * Select specific fields to fetch from the Notification
     */
    select?: NotificationSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: NotificationInclude | null
    /**
     * Filter, which Notification to fetch.
     */
    where: NotificationWhereUniqueInput
  }


  /**
   * Notification base type for findFirst actions
   */
  export type NotificationFindFirstArgsBase = {
    /**
     * Select specific fields to fetch from the Notification
     */
    select?: NotificationSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: NotificationInclude | null
    /**
     * Filter, which Notification to fetch.
     */
    where?: NotificationWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Notifications to fetch.
     */
    orderBy?: Enumerable<NotificationOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Notifications.
     */
    cursor?: NotificationWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Notifications from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Notifications.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Notifications.
     */
    distinct?: Enumerable<NotificationScalarFieldEnum>
  }

  /**
   * Notification findFirst
   */
  export interface NotificationFindFirstArgs extends NotificationFindFirstArgsBase {
   /**
    * Throw an Error if query returns no results
    * @deprecated since 4.0.0: use `findFirstOrThrow` method instead
    */
    rejectOnNotFound?: RejectOnNotFound
  }
      

  /**
   * Notification findFirstOrThrow
   */
  export type NotificationFindFirstOrThrowArgs = {
    /**
     * Select specific fields to fetch from the Notification
     */
    select?: NotificationSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: NotificationInclude | null
    /**
     * Filter, which Notification to fetch.
     */
    where?: NotificationWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Notifications to fetch.
     */
    orderBy?: Enumerable<NotificationOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Notifications.
     */
    cursor?: NotificationWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Notifications from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Notifications.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Notifications.
     */
    distinct?: Enumerable<NotificationScalarFieldEnum>
  }


  /**
   * Notification findMany
   */
  export type NotificationFindManyArgs = {
    /**
     * Select specific fields to fetch from the Notification
     */
    select?: NotificationSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: NotificationInclude | null
    /**
     * Filter, which Notifications to fetch.
     */
    where?: NotificationWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Notifications to fetch.
     */
    orderBy?: Enumerable<NotificationOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Notifications.
     */
    cursor?: NotificationWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Notifications from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Notifications.
     */
    skip?: number
    distinct?: Enumerable<NotificationScalarFieldEnum>
  }


  /**
   * Notification create
   */
  export type NotificationCreateArgs = {
    /**
     * Select specific fields to fetch from the Notification
     */
    select?: NotificationSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: NotificationInclude | null
    /**
     * The data needed to create a Notification.
     */
    data: XOR<NotificationCreateInput, NotificationUncheckedCreateInput>
  }


  /**
   * Notification createMany
   */
  export type NotificationCreateManyArgs = {
    /**
     * The data used to create many Notifications.
     */
    data: Enumerable<NotificationCreateManyInput>
    skipDuplicates?: boolean
  }


  /**
   * Notification update
   */
  export type NotificationUpdateArgs = {
    /**
     * Select specific fields to fetch from the Notification
     */
    select?: NotificationSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: NotificationInclude | null
    /**
     * The data needed to update a Notification.
     */
    data: XOR<NotificationUpdateInput, NotificationUncheckedUpdateInput>
    /**
     * Choose, which Notification to update.
     */
    where: NotificationWhereUniqueInput
  }


  /**
   * Notification updateMany
   */
  export type NotificationUpdateManyArgs = {
    /**
     * The data used to update Notifications.
     */
    data: XOR<NotificationUpdateManyMutationInput, NotificationUncheckedUpdateManyInput>
    /**
     * Filter which Notifications to update
     */
    where?: NotificationWhereInput
  }


  /**
   * Notification upsert
   */
  export type NotificationUpsertArgs = {
    /**
     * Select specific fields to fetch from the Notification
     */
    select?: NotificationSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: NotificationInclude | null
    /**
     * The filter to search for the Notification to update in case it exists.
     */
    where: NotificationWhereUniqueInput
    /**
     * In case the Notification found by the `where` argument doesn't exist, create a new Notification with this data.
     */
    create: XOR<NotificationCreateInput, NotificationUncheckedCreateInput>
    /**
     * In case the Notification was found with the provided `where` argument, update it with this data.
     */
    update: XOR<NotificationUpdateInput, NotificationUncheckedUpdateInput>
  }


  /**
   * Notification delete
   */
  export type NotificationDeleteArgs = {
    /**
     * Select specific fields to fetch from the Notification
     */
    select?: NotificationSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: NotificationInclude | null
    /**
     * Filter which Notification to delete.
     */
    where: NotificationWhereUniqueInput
  }


  /**
   * Notification deleteMany
   */
  export type NotificationDeleteManyArgs = {
    /**
     * Filter which Notifications to delete
     */
    where?: NotificationWhereInput
  }


  /**
   * Notification.Notification_Receiver
   */
  export type Notification$Notification_ReceiverArgs = {
    /**
     * Select specific fields to fetch from the Notification_Receiver
     */
    select?: Notification_ReceiverSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: Notification_ReceiverInclude | null
    where?: Notification_ReceiverWhereInput
    orderBy?: Enumerable<Notification_ReceiverOrderByWithRelationInput>
    cursor?: Notification_ReceiverWhereUniqueInput
    take?: number
    skip?: number
    distinct?: Enumerable<Notification_ReceiverScalarFieldEnum>
  }


  /**
   * Notification without action
   */
  export type NotificationArgs = {
    /**
     * Select specific fields to fetch from the Notification
     */
    select?: NotificationSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: NotificationInclude | null
  }



  /**
   * Model Notification_Receiver
   */


  export type AggregateNotification_Receiver = {
    _count: Notification_ReceiverCountAggregateOutputType | null
    _min: Notification_ReceiverMinAggregateOutputType | null
    _max: Notification_ReceiverMaxAggregateOutputType | null
  }

  export type Notification_ReceiverMinAggregateOutputType = {
    id: string | null
    notification_id: string | null
    user_id: string | null
    isRead: boolean | null
  }

  export type Notification_ReceiverMaxAggregateOutputType = {
    id: string | null
    notification_id: string | null
    user_id: string | null
    isRead: boolean | null
  }

  export type Notification_ReceiverCountAggregateOutputType = {
    id: number
    notification_id: number
    user_id: number
    isRead: number
    _all: number
  }


  export type Notification_ReceiverMinAggregateInputType = {
    id?: true
    notification_id?: true
    user_id?: true
    isRead?: true
  }

  export type Notification_ReceiverMaxAggregateInputType = {
    id?: true
    notification_id?: true
    user_id?: true
    isRead?: true
  }

  export type Notification_ReceiverCountAggregateInputType = {
    id?: true
    notification_id?: true
    user_id?: true
    isRead?: true
    _all?: true
  }

  export type Notification_ReceiverAggregateArgs = {
    /**
     * Filter which Notification_Receiver to aggregate.
     */
    where?: Notification_ReceiverWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Notification_Receivers to fetch.
     */
    orderBy?: Enumerable<Notification_ReceiverOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: Notification_ReceiverWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Notification_Receivers from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Notification_Receivers.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Notification_Receivers
    **/
    _count?: true | Notification_ReceiverCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Notification_ReceiverMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Notification_ReceiverMaxAggregateInputType
  }

  export type GetNotification_ReceiverAggregateType<T extends Notification_ReceiverAggregateArgs> = {
        [P in keyof T & keyof AggregateNotification_Receiver]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateNotification_Receiver[P]>
      : GetScalarType<T[P], AggregateNotification_Receiver[P]>
  }




  export type Notification_ReceiverGroupByArgs = {
    where?: Notification_ReceiverWhereInput
    orderBy?: Enumerable<Notification_ReceiverOrderByWithAggregationInput>
    by: Notification_ReceiverScalarFieldEnum[]
    having?: Notification_ReceiverScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Notification_ReceiverCountAggregateInputType | true
    _min?: Notification_ReceiverMinAggregateInputType
    _max?: Notification_ReceiverMaxAggregateInputType
  }


  export type Notification_ReceiverGroupByOutputType = {
    id: string
    notification_id: string
    user_id: string
    isRead: boolean
    _count: Notification_ReceiverCountAggregateOutputType | null
    _min: Notification_ReceiverMinAggregateOutputType | null
    _max: Notification_ReceiverMaxAggregateOutputType | null
  }

  type GetNotification_ReceiverGroupByPayload<T extends Notification_ReceiverGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickArray<Notification_ReceiverGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Notification_ReceiverGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Notification_ReceiverGroupByOutputType[P]>
            : GetScalarType<T[P], Notification_ReceiverGroupByOutputType[P]>
        }
      >
    >


  export type Notification_ReceiverSelect = {
    id?: boolean
    notification_id?: boolean
    user_id?: boolean
    isRead?: boolean
    notification?: boolean | NotificationArgs
    user?: boolean | UserArgs
  }


  export type Notification_ReceiverInclude = {
    notification?: boolean | NotificationArgs
    user?: boolean | UserArgs
  }

  export type Notification_ReceiverGetPayload<S extends boolean | null | undefined | Notification_ReceiverArgs> =
    S extends { select: any, include: any } ? 'Please either choose `select` or `include`' :
    S extends true ? Notification_Receiver :
    S extends undefined ? never :
    S extends { include: any } & (Notification_ReceiverArgs | Notification_ReceiverFindManyArgs)
    ? Notification_Receiver  & {
    [P in TruthyKeys<S['include']>]:
        P extends 'notification' ? NotificationGetPayload<S['include'][P]> :
        P extends 'user' ? UserGetPayload<S['include'][P]> :  never
  } 
    : S extends { select: any } & (Notification_ReceiverArgs | Notification_ReceiverFindManyArgs)
      ? {
    [P in TruthyKeys<S['select']>]:
        P extends 'notification' ? NotificationGetPayload<S['select'][P]> :
        P extends 'user' ? UserGetPayload<S['select'][P]> :  P extends keyof Notification_Receiver ? Notification_Receiver[P] : never
  } 
      : Notification_Receiver


  type Notification_ReceiverCountArgs = 
    Omit<Notification_ReceiverFindManyArgs, 'select' | 'include'> & {
      select?: Notification_ReceiverCountAggregateInputType | true
    }

  export interface Notification_ReceiverDelegate<GlobalRejectSettings extends Prisma.RejectOnNotFound | Prisma.RejectPerOperation | false | undefined> {

    /**
     * Find zero or one Notification_Receiver that matches the filter.
     * @param {Notification_ReceiverFindUniqueArgs} args - Arguments to find a Notification_Receiver
     * @example
     * // Get one Notification_Receiver
     * const notification_Receiver = await prisma.notification_Receiver.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends Notification_ReceiverFindUniqueArgs,  LocalRejectSettings = T["rejectOnNotFound"] extends RejectOnNotFound ? T['rejectOnNotFound'] : undefined>(
      args: SelectSubset<T, Notification_ReceiverFindUniqueArgs>
    ): HasReject<GlobalRejectSettings, LocalRejectSettings, 'findUnique', 'Notification_Receiver'> extends True ? Prisma__Notification_ReceiverClient<Notification_ReceiverGetPayload<T>> : Prisma__Notification_ReceiverClient<Notification_ReceiverGetPayload<T> | null, null>

    /**
     * Find one Notification_Receiver that matches the filter or throw an error  with `error.code='P2025'` 
     *     if no matches were found.
     * @param {Notification_ReceiverFindUniqueOrThrowArgs} args - Arguments to find a Notification_Receiver
     * @example
     * // Get one Notification_Receiver
     * const notification_Receiver = await prisma.notification_Receiver.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends Notification_ReceiverFindUniqueOrThrowArgs>(
      args?: SelectSubset<T, Notification_ReceiverFindUniqueOrThrowArgs>
    ): Prisma__Notification_ReceiverClient<Notification_ReceiverGetPayload<T>>

    /**
     * Find the first Notification_Receiver that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Notification_ReceiverFindFirstArgs} args - Arguments to find a Notification_Receiver
     * @example
     * // Get one Notification_Receiver
     * const notification_Receiver = await prisma.notification_Receiver.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends Notification_ReceiverFindFirstArgs,  LocalRejectSettings = T["rejectOnNotFound"] extends RejectOnNotFound ? T['rejectOnNotFound'] : undefined>(
      args?: SelectSubset<T, Notification_ReceiverFindFirstArgs>
    ): HasReject<GlobalRejectSettings, LocalRejectSettings, 'findFirst', 'Notification_Receiver'> extends True ? Prisma__Notification_ReceiverClient<Notification_ReceiverGetPayload<T>> : Prisma__Notification_ReceiverClient<Notification_ReceiverGetPayload<T> | null, null>

    /**
     * Find the first Notification_Receiver that matches the filter or
     * throw `NotFoundError` if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Notification_ReceiverFindFirstOrThrowArgs} args - Arguments to find a Notification_Receiver
     * @example
     * // Get one Notification_Receiver
     * const notification_Receiver = await prisma.notification_Receiver.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends Notification_ReceiverFindFirstOrThrowArgs>(
      args?: SelectSubset<T, Notification_ReceiverFindFirstOrThrowArgs>
    ): Prisma__Notification_ReceiverClient<Notification_ReceiverGetPayload<T>>

    /**
     * Find zero or more Notification_Receivers that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Notification_ReceiverFindManyArgs=} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Notification_Receivers
     * const notification_Receivers = await prisma.notification_Receiver.findMany()
     * 
     * // Get first 10 Notification_Receivers
     * const notification_Receivers = await prisma.notification_Receiver.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const notification_ReceiverWithIdOnly = await prisma.notification_Receiver.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends Notification_ReceiverFindManyArgs>(
      args?: SelectSubset<T, Notification_ReceiverFindManyArgs>
    ): Prisma.PrismaPromise<Array<Notification_ReceiverGetPayload<T>>>

    /**
     * Create a Notification_Receiver.
     * @param {Notification_ReceiverCreateArgs} args - Arguments to create a Notification_Receiver.
     * @example
     * // Create one Notification_Receiver
     * const Notification_Receiver = await prisma.notification_Receiver.create({
     *   data: {
     *     // ... data to create a Notification_Receiver
     *   }
     * })
     * 
    **/
    create<T extends Notification_ReceiverCreateArgs>(
      args: SelectSubset<T, Notification_ReceiverCreateArgs>
    ): Prisma__Notification_ReceiverClient<Notification_ReceiverGetPayload<T>>

    /**
     * Create many Notification_Receivers.
     *     @param {Notification_ReceiverCreateManyArgs} args - Arguments to create many Notification_Receivers.
     *     @example
     *     // Create many Notification_Receivers
     *     const notification_Receiver = await prisma.notification_Receiver.createMany({
     *       data: {
     *         // ... provide data here
     *       }
     *     })
     *     
    **/
    createMany<T extends Notification_ReceiverCreateManyArgs>(
      args?: SelectSubset<T, Notification_ReceiverCreateManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Notification_Receiver.
     * @param {Notification_ReceiverDeleteArgs} args - Arguments to delete one Notification_Receiver.
     * @example
     * // Delete one Notification_Receiver
     * const Notification_Receiver = await prisma.notification_Receiver.delete({
     *   where: {
     *     // ... filter to delete one Notification_Receiver
     *   }
     * })
     * 
    **/
    delete<T extends Notification_ReceiverDeleteArgs>(
      args: SelectSubset<T, Notification_ReceiverDeleteArgs>
    ): Prisma__Notification_ReceiverClient<Notification_ReceiverGetPayload<T>>

    /**
     * Update one Notification_Receiver.
     * @param {Notification_ReceiverUpdateArgs} args - Arguments to update one Notification_Receiver.
     * @example
     * // Update one Notification_Receiver
     * const notification_Receiver = await prisma.notification_Receiver.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends Notification_ReceiverUpdateArgs>(
      args: SelectSubset<T, Notification_ReceiverUpdateArgs>
    ): Prisma__Notification_ReceiverClient<Notification_ReceiverGetPayload<T>>

    /**
     * Delete zero or more Notification_Receivers.
     * @param {Notification_ReceiverDeleteManyArgs} args - Arguments to filter Notification_Receivers to delete.
     * @example
     * // Delete a few Notification_Receivers
     * const { count } = await prisma.notification_Receiver.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends Notification_ReceiverDeleteManyArgs>(
      args?: SelectSubset<T, Notification_ReceiverDeleteManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Notification_Receivers.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Notification_ReceiverUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Notification_Receivers
     * const notification_Receiver = await prisma.notification_Receiver.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends Notification_ReceiverUpdateManyArgs>(
      args: SelectSubset<T, Notification_ReceiverUpdateManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Notification_Receiver.
     * @param {Notification_ReceiverUpsertArgs} args - Arguments to update or create a Notification_Receiver.
     * @example
     * // Update or create a Notification_Receiver
     * const notification_Receiver = await prisma.notification_Receiver.upsert({
     *   create: {
     *     // ... data to create a Notification_Receiver
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Notification_Receiver we want to update
     *   }
     * })
    **/
    upsert<T extends Notification_ReceiverUpsertArgs>(
      args: SelectSubset<T, Notification_ReceiverUpsertArgs>
    ): Prisma__Notification_ReceiverClient<Notification_ReceiverGetPayload<T>>

    /**
     * Count the number of Notification_Receivers.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Notification_ReceiverCountArgs} args - Arguments to filter Notification_Receivers to count.
     * @example
     * // Count the number of Notification_Receivers
     * const count = await prisma.notification_Receiver.count({
     *   where: {
     *     // ... the filter for the Notification_Receivers we want to count
     *   }
     * })
    **/
    count<T extends Notification_ReceiverCountArgs>(
      args?: Subset<T, Notification_ReceiverCountArgs>,
    ): Prisma.PrismaPromise<
      T extends _Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Notification_ReceiverCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Notification_Receiver.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Notification_ReceiverAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Notification_ReceiverAggregateArgs>(args: Subset<T, Notification_ReceiverAggregateArgs>): Prisma.PrismaPromise<GetNotification_ReceiverAggregateType<T>>

    /**
     * Group by Notification_Receiver.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Notification_ReceiverGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends Notification_ReceiverGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: Notification_ReceiverGroupByArgs['orderBy'] }
        : { orderBy?: Notification_ReceiverGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends TupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, Notification_ReceiverGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetNotification_ReceiverGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>

  }

  /**
   * The delegate class that acts as a "Promise-like" for Notification_Receiver.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export class Prisma__Notification_ReceiverClient<T, Null = never> implements Prisma.PrismaPromise<T> {
    private readonly _dmmf;
    private readonly _queryType;
    private readonly _rootField;
    private readonly _clientMethod;
    private readonly _args;
    private readonly _dataPath;
    private readonly _errorFormat;
    private readonly _measurePerformance?;
    private _isList;
    private _callsite;
    private _requestPromise?;
    readonly [Symbol.toStringTag]: 'PrismaPromise';
    constructor(_dmmf: runtime.DMMFClass, _queryType: 'query' | 'mutation', _rootField: string, _clientMethod: string, _args: any, _dataPath: string[], _errorFormat: ErrorFormat, _measurePerformance?: boolean | undefined, _isList?: boolean);

    notification<T extends NotificationArgs= {}>(args?: Subset<T, NotificationArgs>): Prisma__NotificationClient<NotificationGetPayload<T> | Null>;

    user<T extends UserArgs= {}>(args?: Subset<T, UserArgs>): Prisma__UserClient<UserGetPayload<T> | Null>;

    private get _document();
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): Promise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): Promise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): Promise<T>;
  }



  // Custom InputTypes

  /**
   * Notification_Receiver base type for findUnique actions
   */
  export type Notification_ReceiverFindUniqueArgsBase = {
    /**
     * Select specific fields to fetch from the Notification_Receiver
     */
    select?: Notification_ReceiverSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: Notification_ReceiverInclude | null
    /**
     * Filter, which Notification_Receiver to fetch.
     */
    where: Notification_ReceiverWhereUniqueInput
  }

  /**
   * Notification_Receiver findUnique
   */
  export interface Notification_ReceiverFindUniqueArgs extends Notification_ReceiverFindUniqueArgsBase {
   /**
    * Throw an Error if query returns no results
    * @deprecated since 4.0.0: use `findUniqueOrThrow` method instead
    */
    rejectOnNotFound?: RejectOnNotFound
  }
      

  /**
   * Notification_Receiver findUniqueOrThrow
   */
  export type Notification_ReceiverFindUniqueOrThrowArgs = {
    /**
     * Select specific fields to fetch from the Notification_Receiver
     */
    select?: Notification_ReceiverSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: Notification_ReceiverInclude | null
    /**
     * Filter, which Notification_Receiver to fetch.
     */
    where: Notification_ReceiverWhereUniqueInput
  }


  /**
   * Notification_Receiver base type for findFirst actions
   */
  export type Notification_ReceiverFindFirstArgsBase = {
    /**
     * Select specific fields to fetch from the Notification_Receiver
     */
    select?: Notification_ReceiverSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: Notification_ReceiverInclude | null
    /**
     * Filter, which Notification_Receiver to fetch.
     */
    where?: Notification_ReceiverWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Notification_Receivers to fetch.
     */
    orderBy?: Enumerable<Notification_ReceiverOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Notification_Receivers.
     */
    cursor?: Notification_ReceiverWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Notification_Receivers from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Notification_Receivers.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Notification_Receivers.
     */
    distinct?: Enumerable<Notification_ReceiverScalarFieldEnum>
  }

  /**
   * Notification_Receiver findFirst
   */
  export interface Notification_ReceiverFindFirstArgs extends Notification_ReceiverFindFirstArgsBase {
   /**
    * Throw an Error if query returns no results
    * @deprecated since 4.0.0: use `findFirstOrThrow` method instead
    */
    rejectOnNotFound?: RejectOnNotFound
  }
      

  /**
   * Notification_Receiver findFirstOrThrow
   */
  export type Notification_ReceiverFindFirstOrThrowArgs = {
    /**
     * Select specific fields to fetch from the Notification_Receiver
     */
    select?: Notification_ReceiverSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: Notification_ReceiverInclude | null
    /**
     * Filter, which Notification_Receiver to fetch.
     */
    where?: Notification_ReceiverWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Notification_Receivers to fetch.
     */
    orderBy?: Enumerable<Notification_ReceiverOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Notification_Receivers.
     */
    cursor?: Notification_ReceiverWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Notification_Receivers from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Notification_Receivers.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Notification_Receivers.
     */
    distinct?: Enumerable<Notification_ReceiverScalarFieldEnum>
  }


  /**
   * Notification_Receiver findMany
   */
  export type Notification_ReceiverFindManyArgs = {
    /**
     * Select specific fields to fetch from the Notification_Receiver
     */
    select?: Notification_ReceiverSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: Notification_ReceiverInclude | null
    /**
     * Filter, which Notification_Receivers to fetch.
     */
    where?: Notification_ReceiverWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Notification_Receivers to fetch.
     */
    orderBy?: Enumerable<Notification_ReceiverOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Notification_Receivers.
     */
    cursor?: Notification_ReceiverWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Notification_Receivers from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Notification_Receivers.
     */
    skip?: number
    distinct?: Enumerable<Notification_ReceiverScalarFieldEnum>
  }


  /**
   * Notification_Receiver create
   */
  export type Notification_ReceiverCreateArgs = {
    /**
     * Select specific fields to fetch from the Notification_Receiver
     */
    select?: Notification_ReceiverSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: Notification_ReceiverInclude | null
    /**
     * The data needed to create a Notification_Receiver.
     */
    data: XOR<Notification_ReceiverCreateInput, Notification_ReceiverUncheckedCreateInput>
  }


  /**
   * Notification_Receiver createMany
   */
  export type Notification_ReceiverCreateManyArgs = {
    /**
     * The data used to create many Notification_Receivers.
     */
    data: Enumerable<Notification_ReceiverCreateManyInput>
    skipDuplicates?: boolean
  }


  /**
   * Notification_Receiver update
   */
  export type Notification_ReceiverUpdateArgs = {
    /**
     * Select specific fields to fetch from the Notification_Receiver
     */
    select?: Notification_ReceiverSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: Notification_ReceiverInclude | null
    /**
     * The data needed to update a Notification_Receiver.
     */
    data: XOR<Notification_ReceiverUpdateInput, Notification_ReceiverUncheckedUpdateInput>
    /**
     * Choose, which Notification_Receiver to update.
     */
    where: Notification_ReceiverWhereUniqueInput
  }


  /**
   * Notification_Receiver updateMany
   */
  export type Notification_ReceiverUpdateManyArgs = {
    /**
     * The data used to update Notification_Receivers.
     */
    data: XOR<Notification_ReceiverUpdateManyMutationInput, Notification_ReceiverUncheckedUpdateManyInput>
    /**
     * Filter which Notification_Receivers to update
     */
    where?: Notification_ReceiverWhereInput
  }


  /**
   * Notification_Receiver upsert
   */
  export type Notification_ReceiverUpsertArgs = {
    /**
     * Select specific fields to fetch from the Notification_Receiver
     */
    select?: Notification_ReceiverSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: Notification_ReceiverInclude | null
    /**
     * The filter to search for the Notification_Receiver to update in case it exists.
     */
    where: Notification_ReceiverWhereUniqueInput
    /**
     * In case the Notification_Receiver found by the `where` argument doesn't exist, create a new Notification_Receiver with this data.
     */
    create: XOR<Notification_ReceiverCreateInput, Notification_ReceiverUncheckedCreateInput>
    /**
     * In case the Notification_Receiver was found with the provided `where` argument, update it with this data.
     */
    update: XOR<Notification_ReceiverUpdateInput, Notification_ReceiverUncheckedUpdateInput>
  }


  /**
   * Notification_Receiver delete
   */
  export type Notification_ReceiverDeleteArgs = {
    /**
     * Select specific fields to fetch from the Notification_Receiver
     */
    select?: Notification_ReceiverSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: Notification_ReceiverInclude | null
    /**
     * Filter which Notification_Receiver to delete.
     */
    where: Notification_ReceiverWhereUniqueInput
  }


  /**
   * Notification_Receiver deleteMany
   */
  export type Notification_ReceiverDeleteManyArgs = {
    /**
     * Filter which Notification_Receivers to delete
     */
    where?: Notification_ReceiverWhereInput
  }


  /**
   * Notification_Receiver without action
   */
  export type Notification_ReceiverArgs = {
    /**
     * Select specific fields to fetch from the Notification_Receiver
     */
    select?: Notification_ReceiverSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: Notification_ReceiverInclude | null
  }



  /**
   * Model Vacation
   */


  export type AggregateVacation = {
    _count: VacationCountAggregateOutputType | null
    _min: VacationMinAggregateOutputType | null
    _max: VacationMaxAggregateOutputType | null
  }

  export type VacationMinAggregateOutputType = {
    id: string | null
    user_id: string | null
    from: Date | null
    to: Date | null
    type: Vacation_Type | null
    status: Vacation_Status | null
    description: string | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type VacationMaxAggregateOutputType = {
    id: string | null
    user_id: string | null
    from: Date | null
    to: Date | null
    type: Vacation_Type | null
    status: Vacation_Status | null
    description: string | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type VacationCountAggregateOutputType = {
    id: number
    user_id: number
    from: number
    to: number
    type: number
    status: number
    description: number
    createdAt: number
    updatedAt: number
    _all: number
  }


  export type VacationMinAggregateInputType = {
    id?: true
    user_id?: true
    from?: true
    to?: true
    type?: true
    status?: true
    description?: true
    createdAt?: true
    updatedAt?: true
  }

  export type VacationMaxAggregateInputType = {
    id?: true
    user_id?: true
    from?: true
    to?: true
    type?: true
    status?: true
    description?: true
    createdAt?: true
    updatedAt?: true
  }

  export type VacationCountAggregateInputType = {
    id?: true
    user_id?: true
    from?: true
    to?: true
    type?: true
    status?: true
    description?: true
    createdAt?: true
    updatedAt?: true
    _all?: true
  }

  export type VacationAggregateArgs = {
    /**
     * Filter which Vacation to aggregate.
     */
    where?: VacationWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Vacations to fetch.
     */
    orderBy?: Enumerable<VacationOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: VacationWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Vacations from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Vacations.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Vacations
    **/
    _count?: true | VacationCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: VacationMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: VacationMaxAggregateInputType
  }

  export type GetVacationAggregateType<T extends VacationAggregateArgs> = {
        [P in keyof T & keyof AggregateVacation]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateVacation[P]>
      : GetScalarType<T[P], AggregateVacation[P]>
  }




  export type VacationGroupByArgs = {
    where?: VacationWhereInput
    orderBy?: Enumerable<VacationOrderByWithAggregationInput>
    by: VacationScalarFieldEnum[]
    having?: VacationScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: VacationCountAggregateInputType | true
    _min?: VacationMinAggregateInputType
    _max?: VacationMaxAggregateInputType
  }


  export type VacationGroupByOutputType = {
    id: string
    user_id: string
    from: Date
    to: Date
    type: Vacation_Type
    status: Vacation_Status
    description: string | null
    createdAt: Date
    updatedAt: Date
    _count: VacationCountAggregateOutputType | null
    _min: VacationMinAggregateOutputType | null
    _max: VacationMaxAggregateOutputType | null
  }

  type GetVacationGroupByPayload<T extends VacationGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickArray<VacationGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof VacationGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], VacationGroupByOutputType[P]>
            : GetScalarType<T[P], VacationGroupByOutputType[P]>
        }
      >
    >


  export type VacationSelect = {
    id?: boolean
    user_id?: boolean
    from?: boolean
    to?: boolean
    type?: boolean
    status?: boolean
    description?: boolean
    createdAt?: boolean
    updatedAt?: boolean
    user?: boolean | UserArgs
  }


  export type VacationInclude = {
    user?: boolean | UserArgs
  }

  export type VacationGetPayload<S extends boolean | null | undefined | VacationArgs> =
    S extends { select: any, include: any } ? 'Please either choose `select` or `include`' :
    S extends true ? Vacation :
    S extends undefined ? never :
    S extends { include: any } & (VacationArgs | VacationFindManyArgs)
    ? Vacation  & {
    [P in TruthyKeys<S['include']>]:
        P extends 'user' ? UserGetPayload<S['include'][P]> :  never
  } 
    : S extends { select: any } & (VacationArgs | VacationFindManyArgs)
      ? {
    [P in TruthyKeys<S['select']>]:
        P extends 'user' ? UserGetPayload<S['select'][P]> :  P extends keyof Vacation ? Vacation[P] : never
  } 
      : Vacation


  type VacationCountArgs = 
    Omit<VacationFindManyArgs, 'select' | 'include'> & {
      select?: VacationCountAggregateInputType | true
    }

  export interface VacationDelegate<GlobalRejectSettings extends Prisma.RejectOnNotFound | Prisma.RejectPerOperation | false | undefined> {

    /**
     * Find zero or one Vacation that matches the filter.
     * @param {VacationFindUniqueArgs} args - Arguments to find a Vacation
     * @example
     * // Get one Vacation
     * const vacation = await prisma.vacation.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends VacationFindUniqueArgs,  LocalRejectSettings = T["rejectOnNotFound"] extends RejectOnNotFound ? T['rejectOnNotFound'] : undefined>(
      args: SelectSubset<T, VacationFindUniqueArgs>
    ): HasReject<GlobalRejectSettings, LocalRejectSettings, 'findUnique', 'Vacation'> extends True ? Prisma__VacationClient<VacationGetPayload<T>> : Prisma__VacationClient<VacationGetPayload<T> | null, null>

    /**
     * Find one Vacation that matches the filter or throw an error  with `error.code='P2025'` 
     *     if no matches were found.
     * @param {VacationFindUniqueOrThrowArgs} args - Arguments to find a Vacation
     * @example
     * // Get one Vacation
     * const vacation = await prisma.vacation.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends VacationFindUniqueOrThrowArgs>(
      args?: SelectSubset<T, VacationFindUniqueOrThrowArgs>
    ): Prisma__VacationClient<VacationGetPayload<T>>

    /**
     * Find the first Vacation that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {VacationFindFirstArgs} args - Arguments to find a Vacation
     * @example
     * // Get one Vacation
     * const vacation = await prisma.vacation.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends VacationFindFirstArgs,  LocalRejectSettings = T["rejectOnNotFound"] extends RejectOnNotFound ? T['rejectOnNotFound'] : undefined>(
      args?: SelectSubset<T, VacationFindFirstArgs>
    ): HasReject<GlobalRejectSettings, LocalRejectSettings, 'findFirst', 'Vacation'> extends True ? Prisma__VacationClient<VacationGetPayload<T>> : Prisma__VacationClient<VacationGetPayload<T> | null, null>

    /**
     * Find the first Vacation that matches the filter or
     * throw `NotFoundError` if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {VacationFindFirstOrThrowArgs} args - Arguments to find a Vacation
     * @example
     * // Get one Vacation
     * const vacation = await prisma.vacation.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends VacationFindFirstOrThrowArgs>(
      args?: SelectSubset<T, VacationFindFirstOrThrowArgs>
    ): Prisma__VacationClient<VacationGetPayload<T>>

    /**
     * Find zero or more Vacations that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {VacationFindManyArgs=} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Vacations
     * const vacations = await prisma.vacation.findMany()
     * 
     * // Get first 10 Vacations
     * const vacations = await prisma.vacation.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const vacationWithIdOnly = await prisma.vacation.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends VacationFindManyArgs>(
      args?: SelectSubset<T, VacationFindManyArgs>
    ): Prisma.PrismaPromise<Array<VacationGetPayload<T>>>

    /**
     * Create a Vacation.
     * @param {VacationCreateArgs} args - Arguments to create a Vacation.
     * @example
     * // Create one Vacation
     * const Vacation = await prisma.vacation.create({
     *   data: {
     *     // ... data to create a Vacation
     *   }
     * })
     * 
    **/
    create<T extends VacationCreateArgs>(
      args: SelectSubset<T, VacationCreateArgs>
    ): Prisma__VacationClient<VacationGetPayload<T>>

    /**
     * Create many Vacations.
     *     @param {VacationCreateManyArgs} args - Arguments to create many Vacations.
     *     @example
     *     // Create many Vacations
     *     const vacation = await prisma.vacation.createMany({
     *       data: {
     *         // ... provide data here
     *       }
     *     })
     *     
    **/
    createMany<T extends VacationCreateManyArgs>(
      args?: SelectSubset<T, VacationCreateManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Vacation.
     * @param {VacationDeleteArgs} args - Arguments to delete one Vacation.
     * @example
     * // Delete one Vacation
     * const Vacation = await prisma.vacation.delete({
     *   where: {
     *     // ... filter to delete one Vacation
     *   }
     * })
     * 
    **/
    delete<T extends VacationDeleteArgs>(
      args: SelectSubset<T, VacationDeleteArgs>
    ): Prisma__VacationClient<VacationGetPayload<T>>

    /**
     * Update one Vacation.
     * @param {VacationUpdateArgs} args - Arguments to update one Vacation.
     * @example
     * // Update one Vacation
     * const vacation = await prisma.vacation.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends VacationUpdateArgs>(
      args: SelectSubset<T, VacationUpdateArgs>
    ): Prisma__VacationClient<VacationGetPayload<T>>

    /**
     * Delete zero or more Vacations.
     * @param {VacationDeleteManyArgs} args - Arguments to filter Vacations to delete.
     * @example
     * // Delete a few Vacations
     * const { count } = await prisma.vacation.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends VacationDeleteManyArgs>(
      args?: SelectSubset<T, VacationDeleteManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Vacations.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {VacationUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Vacations
     * const vacation = await prisma.vacation.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends VacationUpdateManyArgs>(
      args: SelectSubset<T, VacationUpdateManyArgs>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Vacation.
     * @param {VacationUpsertArgs} args - Arguments to update or create a Vacation.
     * @example
     * // Update or create a Vacation
     * const vacation = await prisma.vacation.upsert({
     *   create: {
     *     // ... data to create a Vacation
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Vacation we want to update
     *   }
     * })
    **/
    upsert<T extends VacationUpsertArgs>(
      args: SelectSubset<T, VacationUpsertArgs>
    ): Prisma__VacationClient<VacationGetPayload<T>>

    /**
     * Count the number of Vacations.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {VacationCountArgs} args - Arguments to filter Vacations to count.
     * @example
     * // Count the number of Vacations
     * const count = await prisma.vacation.count({
     *   where: {
     *     // ... the filter for the Vacations we want to count
     *   }
     * })
    **/
    count<T extends VacationCountArgs>(
      args?: Subset<T, VacationCountArgs>,
    ): Prisma.PrismaPromise<
      T extends _Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], VacationCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Vacation.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {VacationAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends VacationAggregateArgs>(args: Subset<T, VacationAggregateArgs>): Prisma.PrismaPromise<GetVacationAggregateType<T>>

    /**
     * Group by Vacation.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {VacationGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends VacationGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: VacationGroupByArgs['orderBy'] }
        : { orderBy?: VacationGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends TupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, VacationGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetVacationGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>

  }

  /**
   * The delegate class that acts as a "Promise-like" for Vacation.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export class Prisma__VacationClient<T, Null = never> implements Prisma.PrismaPromise<T> {
    private readonly _dmmf;
    private readonly _queryType;
    private readonly _rootField;
    private readonly _clientMethod;
    private readonly _args;
    private readonly _dataPath;
    private readonly _errorFormat;
    private readonly _measurePerformance?;
    private _isList;
    private _callsite;
    private _requestPromise?;
    readonly [Symbol.toStringTag]: 'PrismaPromise';
    constructor(_dmmf: runtime.DMMFClass, _queryType: 'query' | 'mutation', _rootField: string, _clientMethod: string, _args: any, _dataPath: string[], _errorFormat: ErrorFormat, _measurePerformance?: boolean | undefined, _isList?: boolean);

    user<T extends UserArgs= {}>(args?: Subset<T, UserArgs>): Prisma__UserClient<UserGetPayload<T> | Null>;

    private get _document();
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): Promise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): Promise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): Promise<T>;
  }



  // Custom InputTypes

  /**
   * Vacation base type for findUnique actions
   */
  export type VacationFindUniqueArgsBase = {
    /**
     * Select specific fields to fetch from the Vacation
     */
    select?: VacationSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: VacationInclude | null
    /**
     * Filter, which Vacation to fetch.
     */
    where: VacationWhereUniqueInput
  }

  /**
   * Vacation findUnique
   */
  export interface VacationFindUniqueArgs extends VacationFindUniqueArgsBase {
   /**
    * Throw an Error if query returns no results
    * @deprecated since 4.0.0: use `findUniqueOrThrow` method instead
    */
    rejectOnNotFound?: RejectOnNotFound
  }
      

  /**
   * Vacation findUniqueOrThrow
   */
  export type VacationFindUniqueOrThrowArgs = {
    /**
     * Select specific fields to fetch from the Vacation
     */
    select?: VacationSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: VacationInclude | null
    /**
     * Filter, which Vacation to fetch.
     */
    where: VacationWhereUniqueInput
  }


  /**
   * Vacation base type for findFirst actions
   */
  export type VacationFindFirstArgsBase = {
    /**
     * Select specific fields to fetch from the Vacation
     */
    select?: VacationSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: VacationInclude | null
    /**
     * Filter, which Vacation to fetch.
     */
    where?: VacationWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Vacations to fetch.
     */
    orderBy?: Enumerable<VacationOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Vacations.
     */
    cursor?: VacationWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Vacations from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Vacations.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Vacations.
     */
    distinct?: Enumerable<VacationScalarFieldEnum>
  }

  /**
   * Vacation findFirst
   */
  export interface VacationFindFirstArgs extends VacationFindFirstArgsBase {
   /**
    * Throw an Error if query returns no results
    * @deprecated since 4.0.0: use `findFirstOrThrow` method instead
    */
    rejectOnNotFound?: RejectOnNotFound
  }
      

  /**
   * Vacation findFirstOrThrow
   */
  export type VacationFindFirstOrThrowArgs = {
    /**
     * Select specific fields to fetch from the Vacation
     */
    select?: VacationSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: VacationInclude | null
    /**
     * Filter, which Vacation to fetch.
     */
    where?: VacationWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Vacations to fetch.
     */
    orderBy?: Enumerable<VacationOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Vacations.
     */
    cursor?: VacationWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Vacations from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Vacations.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Vacations.
     */
    distinct?: Enumerable<VacationScalarFieldEnum>
  }


  /**
   * Vacation findMany
   */
  export type VacationFindManyArgs = {
    /**
     * Select specific fields to fetch from the Vacation
     */
    select?: VacationSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: VacationInclude | null
    /**
     * Filter, which Vacations to fetch.
     */
    where?: VacationWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Vacations to fetch.
     */
    orderBy?: Enumerable<VacationOrderByWithRelationInput>
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Vacations.
     */
    cursor?: VacationWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Vacations from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Vacations.
     */
    skip?: number
    distinct?: Enumerable<VacationScalarFieldEnum>
  }


  /**
   * Vacation create
   */
  export type VacationCreateArgs = {
    /**
     * Select specific fields to fetch from the Vacation
     */
    select?: VacationSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: VacationInclude | null
    /**
     * The data needed to create a Vacation.
     */
    data: XOR<VacationCreateInput, VacationUncheckedCreateInput>
  }


  /**
   * Vacation createMany
   */
  export type VacationCreateManyArgs = {
    /**
     * The data used to create many Vacations.
     */
    data: Enumerable<VacationCreateManyInput>
    skipDuplicates?: boolean
  }


  /**
   * Vacation update
   */
  export type VacationUpdateArgs = {
    /**
     * Select specific fields to fetch from the Vacation
     */
    select?: VacationSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: VacationInclude | null
    /**
     * The data needed to update a Vacation.
     */
    data: XOR<VacationUpdateInput, VacationUncheckedUpdateInput>
    /**
     * Choose, which Vacation to update.
     */
    where: VacationWhereUniqueInput
  }


  /**
   * Vacation updateMany
   */
  export type VacationUpdateManyArgs = {
    /**
     * The data used to update Vacations.
     */
    data: XOR<VacationUpdateManyMutationInput, VacationUncheckedUpdateManyInput>
    /**
     * Filter which Vacations to update
     */
    where?: VacationWhereInput
  }


  /**
   * Vacation upsert
   */
  export type VacationUpsertArgs = {
    /**
     * Select specific fields to fetch from the Vacation
     */
    select?: VacationSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: VacationInclude | null
    /**
     * The filter to search for the Vacation to update in case it exists.
     */
    where: VacationWhereUniqueInput
    /**
     * In case the Vacation found by the `where` argument doesn't exist, create a new Vacation with this data.
     */
    create: XOR<VacationCreateInput, VacationUncheckedCreateInput>
    /**
     * In case the Vacation was found with the provided `where` argument, update it with this data.
     */
    update: XOR<VacationUpdateInput, VacationUncheckedUpdateInput>
  }


  /**
   * Vacation delete
   */
  export type VacationDeleteArgs = {
    /**
     * Select specific fields to fetch from the Vacation
     */
    select?: VacationSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: VacationInclude | null
    /**
     * Filter which Vacation to delete.
     */
    where: VacationWhereUniqueInput
  }


  /**
   * Vacation deleteMany
   */
  export type VacationDeleteManyArgs = {
    /**
     * Filter which Vacations to delete
     */
    where?: VacationWhereInput
  }


  /**
   * Vacation without action
   */
  export type VacationArgs = {
    /**
     * Select specific fields to fetch from the Vacation
     */
    select?: VacationSelect | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: VacationInclude | null
  }



  /**
   * Enums
   */

  // Based on
  // https://github.com/microsoft/TypeScript/issues/3192#issuecomment-261720275

  export const FileScalarFieldEnum: {
    id: 'id',
    path: 'path',
    type: 'type',
    author: 'author',
    size: 'size',
    alt: 'alt',
    mimetype: 'mimetype',
    createdAt: 'createdAt',
    updatedAt: 'updatedAt'
  };

  export type FileScalarFieldEnum = (typeof FileScalarFieldEnum)[keyof typeof FileScalarFieldEnum]


  export const HolidayScalarFieldEnum: {
    date: 'date'
  };

  export type HolidayScalarFieldEnum = (typeof HolidayScalarFieldEnum)[keyof typeof HolidayScalarFieldEnum]


  export const InoutScalarFieldEnum: {
    id: 'id',
    user_id: 'user_id',
    time: 'time',
    type: 'type',
    delete: 'delete',
    description: 'description',
    createdAt: 'createdAt',
    updatedAt: 'updatedAt',
    approved: 'approved'
  };

  export type InoutScalarFieldEnum = (typeof InoutScalarFieldEnum)[keyof typeof InoutScalarFieldEnum]


  export const Inout_logsScalarFieldEnum: {
    id: 'id',
    inout_id: 'inout_id',
    action: 'action',
    old_time: 'old_time',
    new_time: 'new_time',
    description: 'description',
    createdAt: 'createdAt',
    updatedAt: 'updatedAt'
  };

  export type Inout_logsScalarFieldEnum = (typeof Inout_logsScalarFieldEnum)[keyof typeof Inout_logsScalarFieldEnum]


  export const NotificationScalarFieldEnum: {
    id: 'id',
    title: 'title',
    content: 'content',
    file_id: 'file_id',
    author_id: 'author_id',
    createdAt: 'createdAt'
  };

  export type NotificationScalarFieldEnum = (typeof NotificationScalarFieldEnum)[keyof typeof NotificationScalarFieldEnum]


  export const Notification_ReceiverScalarFieldEnum: {
    id: 'id',
    notification_id: 'notification_id',
    user_id: 'user_id',
    isRead: 'isRead'
  };

  export type Notification_ReceiverScalarFieldEnum = (typeof Notification_ReceiverScalarFieldEnum)[keyof typeof Notification_ReceiverScalarFieldEnum]


  export const PermissionScalarFieldEnum: {
    id: 'id',
    key: 'key',
    persian_name: 'persian_name',
    english_name: 'english_name',
    category: 'category'
  };

  export type PermissionScalarFieldEnum = (typeof PermissionScalarFieldEnum)[keyof typeof PermissionScalarFieldEnum]


  export const PermissionsOnRoleScalarFieldEnum: {
    id: 'id',
    role_id: 'role_id',
    permission_id: 'permission_id',
    assignedAt: 'assignedAt',
    assignedBy: 'assignedBy'
  };

  export type PermissionsOnRoleScalarFieldEnum = (typeof PermissionsOnRoleScalarFieldEnum)[keyof typeof PermissionsOnRoleScalarFieldEnum]


  export const ResetPassowrdScalarFieldEnum: {
    email: 'email',
    token: 'token',
    createdAt: 'createdAt'
  };

  export type ResetPassowrdScalarFieldEnum = (typeof ResetPassowrdScalarFieldEnum)[keyof typeof ResetPassowrdScalarFieldEnum]


  export const RoleScalarFieldEnum: {
    id: 'id',
    name: 'name',
    description: 'description'
  };

  export type RoleScalarFieldEnum = (typeof RoleScalarFieldEnum)[keyof typeof RoleScalarFieldEnum]


  export const SortOrder: {
    asc: 'asc',
    desc: 'desc'
  };

  export type SortOrder = (typeof SortOrder)[keyof typeof SortOrder]


  export const TransactionIsolationLevel: {
    ReadUncommitted: 'ReadUncommitted',
    ReadCommitted: 'ReadCommitted',
    RepeatableRead: 'RepeatableRead',
    Serializable: 'Serializable'
  };

  export type TransactionIsolationLevel = (typeof TransactionIsolationLevel)[keyof typeof TransactionIsolationLevel]


  export const UserDetailScalarFieldEnum: {
    id: 'id',
    user_id: 'user_id',
    first_name: 'first_name',
    last_name: 'last_name',
    personal_code: 'personal_code',
    featured_image: 'featured_image',
    delay_time: 'delay_time',
    delay_ratio: 'delay_ratio',
    manager_id: 'manager_id',
    vacation_remained: 'vacation_remained',
    createdAt: 'createdAt',
    updatedAt: 'updatedAt'
  };

  export type UserDetailScalarFieldEnum = (typeof UserDetailScalarFieldEnum)[keyof typeof UserDetailScalarFieldEnum]


  export const UserScalarFieldEnum: {
    id: 'id',
    email: 'email',
    password: 'password',
    phone: 'phone',
    status: 'status',
    role_id: 'role_id',
    createdAt: 'createdAt',
    updatedAt: 'updatedAt'
  };

  export type UserScalarFieldEnum = (typeof UserScalarFieldEnum)[keyof typeof UserScalarFieldEnum]


  export const VacationScalarFieldEnum: {
    id: 'id',
    user_id: 'user_id',
    from: 'from',
    to: 'to',
    type: 'type',
    status: 'status',
    description: 'description',
    createdAt: 'createdAt',
    updatedAt: 'updatedAt'
  };

  export type VacationScalarFieldEnum = (typeof VacationScalarFieldEnum)[keyof typeof VacationScalarFieldEnum]


  /**
   * Deep Input Types
   */


  export type UserWhereInput = {
    AND?: Enumerable<UserWhereInput>
    OR?: Enumerable<UserWhereInput>
    NOT?: Enumerable<UserWhereInput>
    id?: StringFilter | string
    email?: StringFilter | string
    password?: StringFilter | string
    phone?: StringNullableFilter | string | null
    status?: EnumUserStatusFilter | UserStatus
    role_id?: StringFilter | string
    createdAt?: DateTimeFilter | Date | string
    updatedAt?: DateTimeFilter | Date | string
    userDetail?: XOR<UserDetailRelationFilter, UserDetailWhereInput> | null
    userManager?: UserDetailListRelationFilter
    role?: XOR<RoleRelationFilter, RoleWhereInput>
    ResetPassowrd?: XOR<ResetPassowrdRelationFilter, ResetPassowrdWhereInput> | null
    Inout?: InoutListRelationFilter
    File?: FileListRelationFilter
    Notification?: NotificationListRelationFilter
    Notification_Receiver?: Notification_ReceiverListRelationFilter
    Vacation?: VacationListRelationFilter
  }

  export type UserOrderByWithRelationInput = {
    id?: SortOrder
    email?: SortOrder
    password?: SortOrder
    phone?: SortOrder
    status?: SortOrder
    role_id?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
    userDetail?: UserDetailOrderByWithRelationInput
    userManager?: UserDetailOrderByRelationAggregateInput
    role?: RoleOrderByWithRelationInput
    ResetPassowrd?: ResetPassowrdOrderByWithRelationInput
    Inout?: InoutOrderByRelationAggregateInput
    File?: FileOrderByRelationAggregateInput
    Notification?: NotificationOrderByRelationAggregateInput
    Notification_Receiver?: Notification_ReceiverOrderByRelationAggregateInput
    Vacation?: VacationOrderByRelationAggregateInput
  }

  export type UserWhereUniqueInput = {
    id?: string
    email?: string
    phone?: string
  }

  export type UserOrderByWithAggregationInput = {
    id?: SortOrder
    email?: SortOrder
    password?: SortOrder
    phone?: SortOrder
    status?: SortOrder
    role_id?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
    _count?: UserCountOrderByAggregateInput
    _max?: UserMaxOrderByAggregateInput
    _min?: UserMinOrderByAggregateInput
  }

  export type UserScalarWhereWithAggregatesInput = {
    AND?: Enumerable<UserScalarWhereWithAggregatesInput>
    OR?: Enumerable<UserScalarWhereWithAggregatesInput>
    NOT?: Enumerable<UserScalarWhereWithAggregatesInput>
    id?: StringWithAggregatesFilter | string
    email?: StringWithAggregatesFilter | string
    password?: StringWithAggregatesFilter | string
    phone?: StringNullableWithAggregatesFilter | string | null
    status?: EnumUserStatusWithAggregatesFilter | UserStatus
    role_id?: StringWithAggregatesFilter | string
    createdAt?: DateTimeWithAggregatesFilter | Date | string
    updatedAt?: DateTimeWithAggregatesFilter | Date | string
  }

  export type UserDetailWhereInput = {
    AND?: Enumerable<UserDetailWhereInput>
    OR?: Enumerable<UserDetailWhereInput>
    NOT?: Enumerable<UserDetailWhereInput>
    id?: StringFilter | string
    user_id?: StringFilter | string
    first_name?: StringNullableFilter | string | null
    last_name?: StringNullableFilter | string | null
    personal_code?: IntNullableFilter | number | null
    featured_image?: StringNullableFilter | string | null
    delay_time?: StringNullableFilter | string | null
    delay_ratio?: IntNullableFilter | number | null
    manager_id?: StringNullableFilter | string | null
    vacation_remained?: IntFilter | number
    createdAt?: DateTimeFilter | Date | string
    updatedAt?: DateTimeFilter | Date | string
    file?: XOR<FileRelationFilter, FileWhereInput> | null
    user?: XOR<UserRelationFilter, UserWhereInput>
    manager?: XOR<UserRelationFilter, UserWhereInput> | null
  }

  export type UserDetailOrderByWithRelationInput = {
    id?: SortOrder
    user_id?: SortOrder
    first_name?: SortOrder
    last_name?: SortOrder
    personal_code?: SortOrder
    featured_image?: SortOrder
    delay_time?: SortOrder
    delay_ratio?: SortOrder
    manager_id?: SortOrder
    vacation_remained?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
    file?: FileOrderByWithRelationInput
    user?: UserOrderByWithRelationInput
    manager?: UserOrderByWithRelationInput
  }

  export type UserDetailWhereUniqueInput = {
    id?: string
    user_id?: string
  }

  export type UserDetailOrderByWithAggregationInput = {
    id?: SortOrder
    user_id?: SortOrder
    first_name?: SortOrder
    last_name?: SortOrder
    personal_code?: SortOrder
    featured_image?: SortOrder
    delay_time?: SortOrder
    delay_ratio?: SortOrder
    manager_id?: SortOrder
    vacation_remained?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
    _count?: UserDetailCountOrderByAggregateInput
    _avg?: UserDetailAvgOrderByAggregateInput
    _max?: UserDetailMaxOrderByAggregateInput
    _min?: UserDetailMinOrderByAggregateInput
    _sum?: UserDetailSumOrderByAggregateInput
  }

  export type UserDetailScalarWhereWithAggregatesInput = {
    AND?: Enumerable<UserDetailScalarWhereWithAggregatesInput>
    OR?: Enumerable<UserDetailScalarWhereWithAggregatesInput>
    NOT?: Enumerable<UserDetailScalarWhereWithAggregatesInput>
    id?: StringWithAggregatesFilter | string
    user_id?: StringWithAggregatesFilter | string
    first_name?: StringNullableWithAggregatesFilter | string | null
    last_name?: StringNullableWithAggregatesFilter | string | null
    personal_code?: IntNullableWithAggregatesFilter | number | null
    featured_image?: StringNullableWithAggregatesFilter | string | null
    delay_time?: StringNullableWithAggregatesFilter | string | null
    delay_ratio?: IntNullableWithAggregatesFilter | number | null
    manager_id?: StringNullableWithAggregatesFilter | string | null
    vacation_remained?: IntWithAggregatesFilter | number
    createdAt?: DateTimeWithAggregatesFilter | Date | string
    updatedAt?: DateTimeWithAggregatesFilter | Date | string
  }

  export type ResetPassowrdWhereInput = {
    AND?: Enumerable<ResetPassowrdWhereInput>
    OR?: Enumerable<ResetPassowrdWhereInput>
    NOT?: Enumerable<ResetPassowrdWhereInput>
    email?: StringFilter | string
    token?: StringFilter | string
    createdAt?: DateTimeFilter | Date | string
    user?: XOR<UserRelationFilter, UserWhereInput>
  }

  export type ResetPassowrdOrderByWithRelationInput = {
    email?: SortOrder
    token?: SortOrder
    createdAt?: SortOrder
    user?: UserOrderByWithRelationInput
  }

  export type ResetPassowrdWhereUniqueInput = {
    email?: string
    token?: string
  }

  export type ResetPassowrdOrderByWithAggregationInput = {
    email?: SortOrder
    token?: SortOrder
    createdAt?: SortOrder
    _count?: ResetPassowrdCountOrderByAggregateInput
    _max?: ResetPassowrdMaxOrderByAggregateInput
    _min?: ResetPassowrdMinOrderByAggregateInput
  }

  export type ResetPassowrdScalarWhereWithAggregatesInput = {
    AND?: Enumerable<ResetPassowrdScalarWhereWithAggregatesInput>
    OR?: Enumerable<ResetPassowrdScalarWhereWithAggregatesInput>
    NOT?: Enumerable<ResetPassowrdScalarWhereWithAggregatesInput>
    email?: StringWithAggregatesFilter | string
    token?: StringWithAggregatesFilter | string
    createdAt?: DateTimeWithAggregatesFilter | Date | string
  }

  export type RoleWhereInput = {
    AND?: Enumerable<RoleWhereInput>
    OR?: Enumerable<RoleWhereInput>
    NOT?: Enumerable<RoleWhereInput>
    id?: StringFilter | string
    name?: StringFilter | string
    description?: StringNullableFilter | string | null
    PermissionsOnRole?: PermissionsOnRoleListRelationFilter
    User?: UserListRelationFilter
  }

  export type RoleOrderByWithRelationInput = {
    id?: SortOrder
    name?: SortOrder
    description?: SortOrder
    PermissionsOnRole?: PermissionsOnRoleOrderByRelationAggregateInput
    User?: UserOrderByRelationAggregateInput
  }

  export type RoleWhereUniqueInput = {
    id?: string
  }

  export type RoleOrderByWithAggregationInput = {
    id?: SortOrder
    name?: SortOrder
    description?: SortOrder
    _count?: RoleCountOrderByAggregateInput
    _max?: RoleMaxOrderByAggregateInput
    _min?: RoleMinOrderByAggregateInput
  }

  export type RoleScalarWhereWithAggregatesInput = {
    AND?: Enumerable<RoleScalarWhereWithAggregatesInput>
    OR?: Enumerable<RoleScalarWhereWithAggregatesInput>
    NOT?: Enumerable<RoleScalarWhereWithAggregatesInput>
    id?: StringWithAggregatesFilter | string
    name?: StringWithAggregatesFilter | string
    description?: StringNullableWithAggregatesFilter | string | null
  }

  export type PermissionWhereInput = {
    AND?: Enumerable<PermissionWhereInput>
    OR?: Enumerable<PermissionWhereInput>
    NOT?: Enumerable<PermissionWhereInput>
    id?: StringFilter | string
    key?: StringFilter | string
    persian_name?: StringFilter | string
    english_name?: StringFilter | string
    category?: StringFilter | string
    PermissionsOnRole?: PermissionsOnRoleListRelationFilter
  }

  export type PermissionOrderByWithRelationInput = {
    id?: SortOrder
    key?: SortOrder
    persian_name?: SortOrder
    english_name?: SortOrder
    category?: SortOrder
    PermissionsOnRole?: PermissionsOnRoleOrderByRelationAggregateInput
  }

  export type PermissionWhereUniqueInput = {
    id?: string
  }

  export type PermissionOrderByWithAggregationInput = {
    id?: SortOrder
    key?: SortOrder
    persian_name?: SortOrder
    english_name?: SortOrder
    category?: SortOrder
    _count?: PermissionCountOrderByAggregateInput
    _max?: PermissionMaxOrderByAggregateInput
    _min?: PermissionMinOrderByAggregateInput
  }

  export type PermissionScalarWhereWithAggregatesInput = {
    AND?: Enumerable<PermissionScalarWhereWithAggregatesInput>
    OR?: Enumerable<PermissionScalarWhereWithAggregatesInput>
    NOT?: Enumerable<PermissionScalarWhereWithAggregatesInput>
    id?: StringWithAggregatesFilter | string
    key?: StringWithAggregatesFilter | string
    persian_name?: StringWithAggregatesFilter | string
    english_name?: StringWithAggregatesFilter | string
    category?: StringWithAggregatesFilter | string
  }

  export type PermissionsOnRoleWhereInput = {
    AND?: Enumerable<PermissionsOnRoleWhereInput>
    OR?: Enumerable<PermissionsOnRoleWhereInput>
    NOT?: Enumerable<PermissionsOnRoleWhereInput>
    id?: StringFilter | string
    role_id?: StringFilter | string
    permission_id?: StringFilter | string
    assignedAt?: DateTimeFilter | Date | string
    assignedBy?: StringFilter | string
    role?: XOR<RoleRelationFilter, RoleWhereInput>
    permission?: XOR<PermissionRelationFilter, PermissionWhereInput>
  }

  export type PermissionsOnRoleOrderByWithRelationInput = {
    id?: SortOrder
    role_id?: SortOrder
    permission_id?: SortOrder
    assignedAt?: SortOrder
    assignedBy?: SortOrder
    role?: RoleOrderByWithRelationInput
    permission?: PermissionOrderByWithRelationInput
  }

  export type PermissionsOnRoleWhereUniqueInput = {
    id?: string
  }

  export type PermissionsOnRoleOrderByWithAggregationInput = {
    id?: SortOrder
    role_id?: SortOrder
    permission_id?: SortOrder
    assignedAt?: SortOrder
    assignedBy?: SortOrder
    _count?: PermissionsOnRoleCountOrderByAggregateInput
    _max?: PermissionsOnRoleMaxOrderByAggregateInput
    _min?: PermissionsOnRoleMinOrderByAggregateInput
  }

  export type PermissionsOnRoleScalarWhereWithAggregatesInput = {
    AND?: Enumerable<PermissionsOnRoleScalarWhereWithAggregatesInput>
    OR?: Enumerable<PermissionsOnRoleScalarWhereWithAggregatesInput>
    NOT?: Enumerable<PermissionsOnRoleScalarWhereWithAggregatesInput>
    id?: StringWithAggregatesFilter | string
    role_id?: StringWithAggregatesFilter | string
    permission_id?: StringWithAggregatesFilter | string
    assignedAt?: DateTimeWithAggregatesFilter | Date | string
    assignedBy?: StringWithAggregatesFilter | string
  }

  export type FileWhereInput = {
    AND?: Enumerable<FileWhereInput>
    OR?: Enumerable<FileWhereInput>
    NOT?: Enumerable<FileWhereInput>
    id?: StringFilter | string
    path?: StringFilter | string
    type?: EnumFileTypeFilter | FileType
    author?: StringFilter | string
    size?: IntFilter | number
    alt?: StringNullableFilter | string | null
    mimetype?: StringFilter | string
    createdAt?: DateTimeFilter | Date | string
    updatedAt?: DateTimeFilter | Date | string
    user?: XOR<UserRelationFilter, UserWhereInput>
    UserDetail?: UserDetailListRelationFilter
    Notification?: NotificationListRelationFilter
  }

  export type FileOrderByWithRelationInput = {
    id?: SortOrder
    path?: SortOrder
    type?: SortOrder
    author?: SortOrder
    size?: SortOrder
    alt?: SortOrder
    mimetype?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
    user?: UserOrderByWithRelationInput
    UserDetail?: UserDetailOrderByRelationAggregateInput
    Notification?: NotificationOrderByRelationAggregateInput
  }

  export type FileWhereUniqueInput = {
    id?: string
    path?: string
  }

  export type FileOrderByWithAggregationInput = {
    id?: SortOrder
    path?: SortOrder
    type?: SortOrder
    author?: SortOrder
    size?: SortOrder
    alt?: SortOrder
    mimetype?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
    _count?: FileCountOrderByAggregateInput
    _avg?: FileAvgOrderByAggregateInput
    _max?: FileMaxOrderByAggregateInput
    _min?: FileMinOrderByAggregateInput
    _sum?: FileSumOrderByAggregateInput
  }

  export type FileScalarWhereWithAggregatesInput = {
    AND?: Enumerable<FileScalarWhereWithAggregatesInput>
    OR?: Enumerable<FileScalarWhereWithAggregatesInput>
    NOT?: Enumerable<FileScalarWhereWithAggregatesInput>
    id?: StringWithAggregatesFilter | string
    path?: StringWithAggregatesFilter | string
    type?: EnumFileTypeWithAggregatesFilter | FileType
    author?: StringWithAggregatesFilter | string
    size?: IntWithAggregatesFilter | number
    alt?: StringNullableWithAggregatesFilter | string | null
    mimetype?: StringWithAggregatesFilter | string
    createdAt?: DateTimeWithAggregatesFilter | Date | string
    updatedAt?: DateTimeWithAggregatesFilter | Date | string
  }

  export type InoutWhereInput = {
    AND?: Enumerable<InoutWhereInput>
    OR?: Enumerable<InoutWhereInput>
    NOT?: Enumerable<InoutWhereInput>
    id?: StringFilter | string
    user_id?: StringFilter | string
    time?: DateTimeFilter | Date | string
    type?: EnumInoutTypeFilter | InoutType
    delete?: BoolFilter | boolean
    description?: StringNullableFilter | string | null
    createdAt?: DateTimeFilter | Date | string
    updatedAt?: DateTimeFilter | Date | string
    approved?: BoolFilter | boolean
    user?: XOR<UserRelationFilter, UserWhereInput>
    Inout_logs?: Inout_logsListRelationFilter
  }

  export type InoutOrderByWithRelationInput = {
    id?: SortOrder
    user_id?: SortOrder
    time?: SortOrder
    type?: SortOrder
    delete?: SortOrder
    description?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
    approved?: SortOrder
    user?: UserOrderByWithRelationInput
    Inout_logs?: Inout_logsOrderByRelationAggregateInput
  }

  export type InoutWhereUniqueInput = {
    id?: string
    time_user_id?: InoutTimeUser_idCompoundUniqueInput
  }

  export type InoutOrderByWithAggregationInput = {
    id?: SortOrder
    user_id?: SortOrder
    time?: SortOrder
    type?: SortOrder
    delete?: SortOrder
    description?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
    approved?: SortOrder
    _count?: InoutCountOrderByAggregateInput
    _max?: InoutMaxOrderByAggregateInput
    _min?: InoutMinOrderByAggregateInput
  }

  export type InoutScalarWhereWithAggregatesInput = {
    AND?: Enumerable<InoutScalarWhereWithAggregatesInput>
    OR?: Enumerable<InoutScalarWhereWithAggregatesInput>
    NOT?: Enumerable<InoutScalarWhereWithAggregatesInput>
    id?: StringWithAggregatesFilter | string
    user_id?: StringWithAggregatesFilter | string
    time?: DateTimeWithAggregatesFilter | Date | string
    type?: EnumInoutTypeWithAggregatesFilter | InoutType
    delete?: BoolWithAggregatesFilter | boolean
    description?: StringNullableWithAggregatesFilter | string | null
    createdAt?: DateTimeWithAggregatesFilter | Date | string
    updatedAt?: DateTimeWithAggregatesFilter | Date | string
    approved?: BoolWithAggregatesFilter | boolean
  }

  export type Inout_logsWhereInput = {
    AND?: Enumerable<Inout_logsWhereInput>
    OR?: Enumerable<Inout_logsWhereInput>
    NOT?: Enumerable<Inout_logsWhereInput>
    id?: StringFilter | string
    inout_id?: StringFilter | string
    action?: EnumLog_ActionFilter | Log_Action
    old_time?: DateTimeNullableFilter | Date | string | null
    new_time?: DateTimeNullableFilter | Date | string | null
    description?: StringNullableFilter | string | null
    createdAt?: DateTimeFilter | Date | string
    updatedAt?: DateTimeFilter | Date | string
    inout?: XOR<InoutRelationFilter, InoutWhereInput>
  }

  export type Inout_logsOrderByWithRelationInput = {
    id?: SortOrder
    inout_id?: SortOrder
    action?: SortOrder
    old_time?: SortOrder
    new_time?: SortOrder
    description?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
    inout?: InoutOrderByWithRelationInput
  }

  export type Inout_logsWhereUniqueInput = {
    id?: string
  }

  export type Inout_logsOrderByWithAggregationInput = {
    id?: SortOrder
    inout_id?: SortOrder
    action?: SortOrder
    old_time?: SortOrder
    new_time?: SortOrder
    description?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
    _count?: Inout_logsCountOrderByAggregateInput
    _max?: Inout_logsMaxOrderByAggregateInput
    _min?: Inout_logsMinOrderByAggregateInput
  }

  export type Inout_logsScalarWhereWithAggregatesInput = {
    AND?: Enumerable<Inout_logsScalarWhereWithAggregatesInput>
    OR?: Enumerable<Inout_logsScalarWhereWithAggregatesInput>
    NOT?: Enumerable<Inout_logsScalarWhereWithAggregatesInput>
    id?: StringWithAggregatesFilter | string
    inout_id?: StringWithAggregatesFilter | string
    action?: EnumLog_ActionWithAggregatesFilter | Log_Action
    old_time?: DateTimeNullableWithAggregatesFilter | Date | string | null
    new_time?: DateTimeNullableWithAggregatesFilter | Date | string | null
    description?: StringNullableWithAggregatesFilter | string | null
    createdAt?: DateTimeWithAggregatesFilter | Date | string
    updatedAt?: DateTimeWithAggregatesFilter | Date | string
  }

  export type HolidayWhereInput = {
    AND?: Enumerable<HolidayWhereInput>
    OR?: Enumerable<HolidayWhereInput>
    NOT?: Enumerable<HolidayWhereInput>
    date?: DateTimeFilter | Date | string
  }

  export type HolidayOrderByWithRelationInput = {
    date?: SortOrder
  }

  export type HolidayWhereUniqueInput = {
    date?: Date | string
  }

  export type HolidayOrderByWithAggregationInput = {
    date?: SortOrder
    _count?: HolidayCountOrderByAggregateInput
    _max?: HolidayMaxOrderByAggregateInput
    _min?: HolidayMinOrderByAggregateInput
  }

  export type HolidayScalarWhereWithAggregatesInput = {
    AND?: Enumerable<HolidayScalarWhereWithAggregatesInput>
    OR?: Enumerable<HolidayScalarWhereWithAggregatesInput>
    NOT?: Enumerable<HolidayScalarWhereWithAggregatesInput>
    date?: DateTimeWithAggregatesFilter | Date | string
  }

  export type NotificationWhereInput = {
    AND?: Enumerable<NotificationWhereInput>
    OR?: Enumerable<NotificationWhereInput>
    NOT?: Enumerable<NotificationWhereInput>
    id?: StringFilter | string
    title?: StringFilter | string
    content?: StringFilter | string
    file_id?: StringNullableFilter | string | null
    author_id?: StringFilter | string
    createdAt?: DateTimeFilter | Date | string
    file?: XOR<FileRelationFilter, FileWhereInput> | null
    author?: XOR<UserRelationFilter, UserWhereInput>
    Notification_Receiver?: Notification_ReceiverListRelationFilter
  }

  export type NotificationOrderByWithRelationInput = {
    id?: SortOrder
    title?: SortOrder
    content?: SortOrder
    file_id?: SortOrder
    author_id?: SortOrder
    createdAt?: SortOrder
    file?: FileOrderByWithRelationInput
    author?: UserOrderByWithRelationInput
    Notification_Receiver?: Notification_ReceiverOrderByRelationAggregateInput
  }

  export type NotificationWhereUniqueInput = {
    id?: string
  }

  export type NotificationOrderByWithAggregationInput = {
    id?: SortOrder
    title?: SortOrder
    content?: SortOrder
    file_id?: SortOrder
    author_id?: SortOrder
    createdAt?: SortOrder
    _count?: NotificationCountOrderByAggregateInput
    _max?: NotificationMaxOrderByAggregateInput
    _min?: NotificationMinOrderByAggregateInput
  }

  export type NotificationScalarWhereWithAggregatesInput = {
    AND?: Enumerable<NotificationScalarWhereWithAggregatesInput>
    OR?: Enumerable<NotificationScalarWhereWithAggregatesInput>
    NOT?: Enumerable<NotificationScalarWhereWithAggregatesInput>
    id?: StringWithAggregatesFilter | string
    title?: StringWithAggregatesFilter | string
    content?: StringWithAggregatesFilter | string
    file_id?: StringNullableWithAggregatesFilter | string | null
    author_id?: StringWithAggregatesFilter | string
    createdAt?: DateTimeWithAggregatesFilter | Date | string
  }

  export type Notification_ReceiverWhereInput = {
    AND?: Enumerable<Notification_ReceiverWhereInput>
    OR?: Enumerable<Notification_ReceiverWhereInput>
    NOT?: Enumerable<Notification_ReceiverWhereInput>
    id?: StringFilter | string
    notification_id?: StringFilter | string
    user_id?: StringFilter | string
    isRead?: BoolFilter | boolean
    notification?: XOR<NotificationRelationFilter, NotificationWhereInput>
    user?: XOR<UserRelationFilter, UserWhereInput>
  }

  export type Notification_ReceiverOrderByWithRelationInput = {
    id?: SortOrder
    notification_id?: SortOrder
    user_id?: SortOrder
    isRead?: SortOrder
    notification?: NotificationOrderByWithRelationInput
    user?: UserOrderByWithRelationInput
  }

  export type Notification_ReceiverWhereUniqueInput = {
    id?: string
  }

  export type Notification_ReceiverOrderByWithAggregationInput = {
    id?: SortOrder
    notification_id?: SortOrder
    user_id?: SortOrder
    isRead?: SortOrder
    _count?: Notification_ReceiverCountOrderByAggregateInput
    _max?: Notification_ReceiverMaxOrderByAggregateInput
    _min?: Notification_ReceiverMinOrderByAggregateInput
  }

  export type Notification_ReceiverScalarWhereWithAggregatesInput = {
    AND?: Enumerable<Notification_ReceiverScalarWhereWithAggregatesInput>
    OR?: Enumerable<Notification_ReceiverScalarWhereWithAggregatesInput>
    NOT?: Enumerable<Notification_ReceiverScalarWhereWithAggregatesInput>
    id?: StringWithAggregatesFilter | string
    notification_id?: StringWithAggregatesFilter | string
    user_id?: StringWithAggregatesFilter | string
    isRead?: BoolWithAggregatesFilter | boolean
  }

  export type VacationWhereInput = {
    AND?: Enumerable<VacationWhereInput>
    OR?: Enumerable<VacationWhereInput>
    NOT?: Enumerable<VacationWhereInput>
    id?: StringFilter | string
    user_id?: StringFilter | string
    from?: DateTimeFilter | Date | string
    to?: DateTimeFilter | Date | string
    type?: EnumVacation_TypeFilter | Vacation_Type
    status?: EnumVacation_StatusFilter | Vacation_Status
    description?: StringNullableFilter | string | null
    createdAt?: DateTimeFilter | Date | string
    updatedAt?: DateTimeFilter | Date | string
    user?: XOR<UserRelationFilter, UserWhereInput>
  }

  export type VacationOrderByWithRelationInput = {
    id?: SortOrder
    user_id?: SortOrder
    from?: SortOrder
    to?: SortOrder
    type?: SortOrder
    status?: SortOrder
    description?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
    user?: UserOrderByWithRelationInput
  }

  export type VacationWhereUniqueInput = {
    id?: string
  }

  export type VacationOrderByWithAggregationInput = {
    id?: SortOrder
    user_id?: SortOrder
    from?: SortOrder
    to?: SortOrder
    type?: SortOrder
    status?: SortOrder
    description?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
    _count?: VacationCountOrderByAggregateInput
    _max?: VacationMaxOrderByAggregateInput
    _min?: VacationMinOrderByAggregateInput
  }

  export type VacationScalarWhereWithAggregatesInput = {
    AND?: Enumerable<VacationScalarWhereWithAggregatesInput>
    OR?: Enumerable<VacationScalarWhereWithAggregatesInput>
    NOT?: Enumerable<VacationScalarWhereWithAggregatesInput>
    id?: StringWithAggregatesFilter | string
    user_id?: StringWithAggregatesFilter | string
    from?: DateTimeWithAggregatesFilter | Date | string
    to?: DateTimeWithAggregatesFilter | Date | string
    type?: EnumVacation_TypeWithAggregatesFilter | Vacation_Type
    status?: EnumVacation_StatusWithAggregatesFilter | Vacation_Status
    description?: StringNullableWithAggregatesFilter | string | null
    createdAt?: DateTimeWithAggregatesFilter | Date | string
    updatedAt?: DateTimeWithAggregatesFilter | Date | string
  }

  export type UserCreateInput = {
    id?: string
    email: string
    password: string
    phone?: string | null
    status?: UserStatus
    createdAt?: Date | string
    updatedAt?: Date | string
    userDetail?: UserDetailCreateNestedOneWithoutUserInput
    userManager?: UserDetailCreateNestedManyWithoutManagerInput
    role: RoleCreateNestedOneWithoutUserInput
    ResetPassowrd?: ResetPassowrdCreateNestedOneWithoutUserInput
    Inout?: InoutCreateNestedManyWithoutUserInput
    File?: FileCreateNestedManyWithoutUserInput
    Notification?: NotificationCreateNestedManyWithoutAuthorInput
    Notification_Receiver?: Notification_ReceiverCreateNestedManyWithoutUserInput
    Vacation?: VacationCreateNestedManyWithoutUserInput
  }

  export type UserUncheckedCreateInput = {
    id?: string
    email: string
    password: string
    phone?: string | null
    status?: UserStatus
    role_id: string
    createdAt?: Date | string
    updatedAt?: Date | string
    userDetail?: UserDetailUncheckedCreateNestedOneWithoutUserInput
    userManager?: UserDetailUncheckedCreateNestedManyWithoutManagerInput
    ResetPassowrd?: ResetPassowrdUncheckedCreateNestedOneWithoutUserInput
    Inout?: InoutUncheckedCreateNestedManyWithoutUserInput
    File?: FileUncheckedCreateNestedManyWithoutUserInput
    Notification?: NotificationUncheckedCreateNestedManyWithoutAuthorInput
    Notification_Receiver?: Notification_ReceiverUncheckedCreateNestedManyWithoutUserInput
    Vacation?: VacationUncheckedCreateNestedManyWithoutUserInput
  }

  export type UserUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    status?: EnumUserStatusFieldUpdateOperationsInput | UserStatus
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    userDetail?: UserDetailUpdateOneWithoutUserNestedInput
    userManager?: UserDetailUpdateManyWithoutManagerNestedInput
    role?: RoleUpdateOneRequiredWithoutUserNestedInput
    ResetPassowrd?: ResetPassowrdUpdateOneWithoutUserNestedInput
    Inout?: InoutUpdateManyWithoutUserNestedInput
    File?: FileUpdateManyWithoutUserNestedInput
    Notification?: NotificationUpdateManyWithoutAuthorNestedInput
    Notification_Receiver?: Notification_ReceiverUpdateManyWithoutUserNestedInput
    Vacation?: VacationUpdateManyWithoutUserNestedInput
  }

  export type UserUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    status?: EnumUserStatusFieldUpdateOperationsInput | UserStatus
    role_id?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    userDetail?: UserDetailUncheckedUpdateOneWithoutUserNestedInput
    userManager?: UserDetailUncheckedUpdateManyWithoutManagerNestedInput
    ResetPassowrd?: ResetPassowrdUncheckedUpdateOneWithoutUserNestedInput
    Inout?: InoutUncheckedUpdateManyWithoutUserNestedInput
    File?: FileUncheckedUpdateManyWithoutUserNestedInput
    Notification?: NotificationUncheckedUpdateManyWithoutAuthorNestedInput
    Notification_Receiver?: Notification_ReceiverUncheckedUpdateManyWithoutUserNestedInput
    Vacation?: VacationUncheckedUpdateManyWithoutUserNestedInput
  }

  export type UserCreateManyInput = {
    id?: string
    email: string
    password: string
    phone?: string | null
    status?: UserStatus
    role_id: string
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type UserUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    status?: EnumUserStatusFieldUpdateOperationsInput | UserStatus
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type UserUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    status?: EnumUserStatusFieldUpdateOperationsInput | UserStatus
    role_id?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type UserDetailCreateInput = {
    id?: string
    first_name?: string | null
    last_name?: string | null
    personal_code?: number | null
    delay_time?: string | null
    delay_ratio?: number | null
    vacation_remained?: number
    createdAt?: Date | string
    updatedAt?: Date | string
    file?: FileCreateNestedOneWithoutUserDetailInput
    user: UserCreateNestedOneWithoutUserDetailInput
    manager?: UserCreateNestedOneWithoutUserManagerInput
  }

  export type UserDetailUncheckedCreateInput = {
    id?: string
    user_id: string
    first_name?: string | null
    last_name?: string | null
    personal_code?: number | null
    featured_image?: string | null
    delay_time?: string | null
    delay_ratio?: number | null
    manager_id?: string | null
    vacation_remained?: number
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type UserDetailUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    first_name?: NullableStringFieldUpdateOperationsInput | string | null
    last_name?: NullableStringFieldUpdateOperationsInput | string | null
    personal_code?: NullableIntFieldUpdateOperationsInput | number | null
    delay_time?: NullableStringFieldUpdateOperationsInput | string | null
    delay_ratio?: NullableIntFieldUpdateOperationsInput | number | null
    vacation_remained?: IntFieldUpdateOperationsInput | number
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    file?: FileUpdateOneWithoutUserDetailNestedInput
    user?: UserUpdateOneRequiredWithoutUserDetailNestedInput
    manager?: UserUpdateOneWithoutUserManagerNestedInput
  }

  export type UserDetailUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    user_id?: StringFieldUpdateOperationsInput | string
    first_name?: NullableStringFieldUpdateOperationsInput | string | null
    last_name?: NullableStringFieldUpdateOperationsInput | string | null
    personal_code?: NullableIntFieldUpdateOperationsInput | number | null
    featured_image?: NullableStringFieldUpdateOperationsInput | string | null
    delay_time?: NullableStringFieldUpdateOperationsInput | string | null
    delay_ratio?: NullableIntFieldUpdateOperationsInput | number | null
    manager_id?: NullableStringFieldUpdateOperationsInput | string | null
    vacation_remained?: IntFieldUpdateOperationsInput | number
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type UserDetailCreateManyInput = {
    id?: string
    user_id: string
    first_name?: string | null
    last_name?: string | null
    personal_code?: number | null
    featured_image?: string | null
    delay_time?: string | null
    delay_ratio?: number | null
    manager_id?: string | null
    vacation_remained?: number
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type UserDetailUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    first_name?: NullableStringFieldUpdateOperationsInput | string | null
    last_name?: NullableStringFieldUpdateOperationsInput | string | null
    personal_code?: NullableIntFieldUpdateOperationsInput | number | null
    delay_time?: NullableStringFieldUpdateOperationsInput | string | null
    delay_ratio?: NullableIntFieldUpdateOperationsInput | number | null
    vacation_remained?: IntFieldUpdateOperationsInput | number
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type UserDetailUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    user_id?: StringFieldUpdateOperationsInput | string
    first_name?: NullableStringFieldUpdateOperationsInput | string | null
    last_name?: NullableStringFieldUpdateOperationsInput | string | null
    personal_code?: NullableIntFieldUpdateOperationsInput | number | null
    featured_image?: NullableStringFieldUpdateOperationsInput | string | null
    delay_time?: NullableStringFieldUpdateOperationsInput | string | null
    delay_ratio?: NullableIntFieldUpdateOperationsInput | number | null
    manager_id?: NullableStringFieldUpdateOperationsInput | string | null
    vacation_remained?: IntFieldUpdateOperationsInput | number
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type ResetPassowrdCreateInput = {
    token: string
    createdAt?: Date | string
    user: UserCreateNestedOneWithoutResetPassowrdInput
  }

  export type ResetPassowrdUncheckedCreateInput = {
    email: string
    token: string
    createdAt?: Date | string
  }

  export type ResetPassowrdUpdateInput = {
    token?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    user?: UserUpdateOneRequiredWithoutResetPassowrdNestedInput
  }

  export type ResetPassowrdUncheckedUpdateInput = {
    email?: StringFieldUpdateOperationsInput | string
    token?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type ResetPassowrdCreateManyInput = {
    email: string
    token: string
    createdAt?: Date | string
  }

  export type ResetPassowrdUpdateManyMutationInput = {
    token?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type ResetPassowrdUncheckedUpdateManyInput = {
    email?: StringFieldUpdateOperationsInput | string
    token?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type RoleCreateInput = {
    id?: string
    name: string
    description?: string | null
    PermissionsOnRole?: PermissionsOnRoleCreateNestedManyWithoutRoleInput
    User?: UserCreateNestedManyWithoutRoleInput
  }

  export type RoleUncheckedCreateInput = {
    id?: string
    name: string
    description?: string | null
    PermissionsOnRole?: PermissionsOnRoleUncheckedCreateNestedManyWithoutRoleInput
    User?: UserUncheckedCreateNestedManyWithoutRoleInput
  }

  export type RoleUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    PermissionsOnRole?: PermissionsOnRoleUpdateManyWithoutRoleNestedInput
    User?: UserUpdateManyWithoutRoleNestedInput
  }

  export type RoleUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    PermissionsOnRole?: PermissionsOnRoleUncheckedUpdateManyWithoutRoleNestedInput
    User?: UserUncheckedUpdateManyWithoutRoleNestedInput
  }

  export type RoleCreateManyInput = {
    id?: string
    name: string
    description?: string | null
  }

  export type RoleUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
  }

  export type RoleUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
  }

  export type PermissionCreateInput = {
    id?: string
    key: string
    persian_name: string
    english_name: string
    category: string
    PermissionsOnRole?: PermissionsOnRoleCreateNestedManyWithoutPermissionInput
  }

  export type PermissionUncheckedCreateInput = {
    id?: string
    key: string
    persian_name: string
    english_name: string
    category: string
    PermissionsOnRole?: PermissionsOnRoleUncheckedCreateNestedManyWithoutPermissionInput
  }

  export type PermissionUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    key?: StringFieldUpdateOperationsInput | string
    persian_name?: StringFieldUpdateOperationsInput | string
    english_name?: StringFieldUpdateOperationsInput | string
    category?: StringFieldUpdateOperationsInput | string
    PermissionsOnRole?: PermissionsOnRoleUpdateManyWithoutPermissionNestedInput
  }

  export type PermissionUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    key?: StringFieldUpdateOperationsInput | string
    persian_name?: StringFieldUpdateOperationsInput | string
    english_name?: StringFieldUpdateOperationsInput | string
    category?: StringFieldUpdateOperationsInput | string
    PermissionsOnRole?: PermissionsOnRoleUncheckedUpdateManyWithoutPermissionNestedInput
  }

  export type PermissionCreateManyInput = {
    id?: string
    key: string
    persian_name: string
    english_name: string
    category: string
  }

  export type PermissionUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    key?: StringFieldUpdateOperationsInput | string
    persian_name?: StringFieldUpdateOperationsInput | string
    english_name?: StringFieldUpdateOperationsInput | string
    category?: StringFieldUpdateOperationsInput | string
  }

  export type PermissionUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    key?: StringFieldUpdateOperationsInput | string
    persian_name?: StringFieldUpdateOperationsInput | string
    english_name?: StringFieldUpdateOperationsInput | string
    category?: StringFieldUpdateOperationsInput | string
  }

  export type PermissionsOnRoleCreateInput = {
    id?: string
    assignedAt?: Date | string
    assignedBy: string
    role: RoleCreateNestedOneWithoutPermissionsOnRoleInput
    permission: PermissionCreateNestedOneWithoutPermissionsOnRoleInput
  }

  export type PermissionsOnRoleUncheckedCreateInput = {
    id?: string
    role_id: string
    permission_id: string
    assignedAt?: Date | string
    assignedBy: string
  }

  export type PermissionsOnRoleUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    assignedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    assignedBy?: StringFieldUpdateOperationsInput | string
    role?: RoleUpdateOneRequiredWithoutPermissionsOnRoleNestedInput
    permission?: PermissionUpdateOneRequiredWithoutPermissionsOnRoleNestedInput
  }

  export type PermissionsOnRoleUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    role_id?: StringFieldUpdateOperationsInput | string
    permission_id?: StringFieldUpdateOperationsInput | string
    assignedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    assignedBy?: StringFieldUpdateOperationsInput | string
  }

  export type PermissionsOnRoleCreateManyInput = {
    id?: string
    role_id: string
    permission_id: string
    assignedAt?: Date | string
    assignedBy: string
  }

  export type PermissionsOnRoleUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    assignedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    assignedBy?: StringFieldUpdateOperationsInput | string
  }

  export type PermissionsOnRoleUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    role_id?: StringFieldUpdateOperationsInput | string
    permission_id?: StringFieldUpdateOperationsInput | string
    assignedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    assignedBy?: StringFieldUpdateOperationsInput | string
  }

  export type FileCreateInput = {
    id?: string
    path: string
    type: FileType
    size: number
    alt?: string | null
    mimetype: string
    createdAt?: Date | string
    updatedAt?: Date | string
    user: UserCreateNestedOneWithoutFileInput
    UserDetail?: UserDetailCreateNestedManyWithoutFileInput
    Notification?: NotificationCreateNestedManyWithoutFileInput
  }

  export type FileUncheckedCreateInput = {
    id?: string
    path: string
    type: FileType
    author: string
    size: number
    alt?: string | null
    mimetype: string
    createdAt?: Date | string
    updatedAt?: Date | string
    UserDetail?: UserDetailUncheckedCreateNestedManyWithoutFileInput
    Notification?: NotificationUncheckedCreateNestedManyWithoutFileInput
  }

  export type FileUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    path?: StringFieldUpdateOperationsInput | string
    type?: EnumFileTypeFieldUpdateOperationsInput | FileType
    size?: IntFieldUpdateOperationsInput | number
    alt?: NullableStringFieldUpdateOperationsInput | string | null
    mimetype?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    user?: UserUpdateOneRequiredWithoutFileNestedInput
    UserDetail?: UserDetailUpdateManyWithoutFileNestedInput
    Notification?: NotificationUpdateManyWithoutFileNestedInput
  }

  export type FileUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    path?: StringFieldUpdateOperationsInput | string
    type?: EnumFileTypeFieldUpdateOperationsInput | FileType
    author?: StringFieldUpdateOperationsInput | string
    size?: IntFieldUpdateOperationsInput | number
    alt?: NullableStringFieldUpdateOperationsInput | string | null
    mimetype?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    UserDetail?: UserDetailUncheckedUpdateManyWithoutFileNestedInput
    Notification?: NotificationUncheckedUpdateManyWithoutFileNestedInput
  }

  export type FileCreateManyInput = {
    id?: string
    path: string
    type: FileType
    author: string
    size: number
    alt?: string | null
    mimetype: string
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type FileUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    path?: StringFieldUpdateOperationsInput | string
    type?: EnumFileTypeFieldUpdateOperationsInput | FileType
    size?: IntFieldUpdateOperationsInput | number
    alt?: NullableStringFieldUpdateOperationsInput | string | null
    mimetype?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type FileUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    path?: StringFieldUpdateOperationsInput | string
    type?: EnumFileTypeFieldUpdateOperationsInput | FileType
    author?: StringFieldUpdateOperationsInput | string
    size?: IntFieldUpdateOperationsInput | number
    alt?: NullableStringFieldUpdateOperationsInput | string | null
    mimetype?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type InoutCreateInput = {
    id?: string
    time: Date | string
    type?: InoutType
    delete?: boolean
    description?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
    approved?: boolean
    user: UserCreateNestedOneWithoutInoutInput
    Inout_logs?: Inout_logsCreateNestedManyWithoutInoutInput
  }

  export type InoutUncheckedCreateInput = {
    id?: string
    user_id: string
    time: Date | string
    type?: InoutType
    delete?: boolean
    description?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
    approved?: boolean
    Inout_logs?: Inout_logsUncheckedCreateNestedManyWithoutInoutInput
  }

  export type InoutUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    time?: DateTimeFieldUpdateOperationsInput | Date | string
    type?: EnumInoutTypeFieldUpdateOperationsInput | InoutType
    delete?: BoolFieldUpdateOperationsInput | boolean
    description?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    approved?: BoolFieldUpdateOperationsInput | boolean
    user?: UserUpdateOneRequiredWithoutInoutNestedInput
    Inout_logs?: Inout_logsUpdateManyWithoutInoutNestedInput
  }

  export type InoutUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    user_id?: StringFieldUpdateOperationsInput | string
    time?: DateTimeFieldUpdateOperationsInput | Date | string
    type?: EnumInoutTypeFieldUpdateOperationsInput | InoutType
    delete?: BoolFieldUpdateOperationsInput | boolean
    description?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    approved?: BoolFieldUpdateOperationsInput | boolean
    Inout_logs?: Inout_logsUncheckedUpdateManyWithoutInoutNestedInput
  }

  export type InoutCreateManyInput = {
    id?: string
    user_id: string
    time: Date | string
    type?: InoutType
    delete?: boolean
    description?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
    approved?: boolean
  }

  export type InoutUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    time?: DateTimeFieldUpdateOperationsInput | Date | string
    type?: EnumInoutTypeFieldUpdateOperationsInput | InoutType
    delete?: BoolFieldUpdateOperationsInput | boolean
    description?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    approved?: BoolFieldUpdateOperationsInput | boolean
  }

  export type InoutUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    user_id?: StringFieldUpdateOperationsInput | string
    time?: DateTimeFieldUpdateOperationsInput | Date | string
    type?: EnumInoutTypeFieldUpdateOperationsInput | InoutType
    delete?: BoolFieldUpdateOperationsInput | boolean
    description?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    approved?: BoolFieldUpdateOperationsInput | boolean
  }

  export type Inout_logsCreateInput = {
    id?: string
    action: Log_Action
    old_time?: Date | string | null
    new_time?: Date | string | null
    description?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
    inout: InoutCreateNestedOneWithoutInout_logsInput
  }

  export type Inout_logsUncheckedCreateInput = {
    id?: string
    inout_id: string
    action: Log_Action
    old_time?: Date | string | null
    new_time?: Date | string | null
    description?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type Inout_logsUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    action?: EnumLog_ActionFieldUpdateOperationsInput | Log_Action
    old_time?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    new_time?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    description?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    inout?: InoutUpdateOneRequiredWithoutInout_logsNestedInput
  }

  export type Inout_logsUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    inout_id?: StringFieldUpdateOperationsInput | string
    action?: EnumLog_ActionFieldUpdateOperationsInput | Log_Action
    old_time?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    new_time?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    description?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type Inout_logsCreateManyInput = {
    id?: string
    inout_id: string
    action: Log_Action
    old_time?: Date | string | null
    new_time?: Date | string | null
    description?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type Inout_logsUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    action?: EnumLog_ActionFieldUpdateOperationsInput | Log_Action
    old_time?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    new_time?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    description?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type Inout_logsUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    inout_id?: StringFieldUpdateOperationsInput | string
    action?: EnumLog_ActionFieldUpdateOperationsInput | Log_Action
    old_time?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    new_time?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    description?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type HolidayCreateInput = {
    date: Date | string
  }

  export type HolidayUncheckedCreateInput = {
    date: Date | string
  }

  export type HolidayUpdateInput = {
    date?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type HolidayUncheckedUpdateInput = {
    date?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type HolidayCreateManyInput = {
    date: Date | string
  }

  export type HolidayUpdateManyMutationInput = {
    date?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type HolidayUncheckedUpdateManyInput = {
    date?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type NotificationCreateInput = {
    id?: string
    title: string
    content: string
    createdAt?: Date | string
    file?: FileCreateNestedOneWithoutNotificationInput
    author: UserCreateNestedOneWithoutNotificationInput
    Notification_Receiver?: Notification_ReceiverCreateNestedManyWithoutNotificationInput
  }

  export type NotificationUncheckedCreateInput = {
    id?: string
    title: string
    content: string
    file_id?: string | null
    author_id: string
    createdAt?: Date | string
    Notification_Receiver?: Notification_ReceiverUncheckedCreateNestedManyWithoutNotificationInput
  }

  export type NotificationUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    title?: StringFieldUpdateOperationsInput | string
    content?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    file?: FileUpdateOneWithoutNotificationNestedInput
    author?: UserUpdateOneRequiredWithoutNotificationNestedInput
    Notification_Receiver?: Notification_ReceiverUpdateManyWithoutNotificationNestedInput
  }

  export type NotificationUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    title?: StringFieldUpdateOperationsInput | string
    content?: StringFieldUpdateOperationsInput | string
    file_id?: NullableStringFieldUpdateOperationsInput | string | null
    author_id?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    Notification_Receiver?: Notification_ReceiverUncheckedUpdateManyWithoutNotificationNestedInput
  }

  export type NotificationCreateManyInput = {
    id?: string
    title: string
    content: string
    file_id?: string | null
    author_id: string
    createdAt?: Date | string
  }

  export type NotificationUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    title?: StringFieldUpdateOperationsInput | string
    content?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type NotificationUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    title?: StringFieldUpdateOperationsInput | string
    content?: StringFieldUpdateOperationsInput | string
    file_id?: NullableStringFieldUpdateOperationsInput | string | null
    author_id?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type Notification_ReceiverCreateInput = {
    id?: string
    isRead?: boolean
    notification: NotificationCreateNestedOneWithoutNotification_ReceiverInput
    user: UserCreateNestedOneWithoutNotification_ReceiverInput
  }

  export type Notification_ReceiverUncheckedCreateInput = {
    id?: string
    notification_id: string
    user_id: string
    isRead?: boolean
  }

  export type Notification_ReceiverUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    isRead?: BoolFieldUpdateOperationsInput | boolean
    notification?: NotificationUpdateOneRequiredWithoutNotification_ReceiverNestedInput
    user?: UserUpdateOneRequiredWithoutNotification_ReceiverNestedInput
  }

  export type Notification_ReceiverUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    notification_id?: StringFieldUpdateOperationsInput | string
    user_id?: StringFieldUpdateOperationsInput | string
    isRead?: BoolFieldUpdateOperationsInput | boolean
  }

  export type Notification_ReceiverCreateManyInput = {
    id?: string
    notification_id: string
    user_id: string
    isRead?: boolean
  }

  export type Notification_ReceiverUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    isRead?: BoolFieldUpdateOperationsInput | boolean
  }

  export type Notification_ReceiverUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    notification_id?: StringFieldUpdateOperationsInput | string
    user_id?: StringFieldUpdateOperationsInput | string
    isRead?: BoolFieldUpdateOperationsInput | boolean
  }

  export type VacationCreateInput = {
    id?: string
    from: Date | string
    to: Date | string
    type: Vacation_Type
    status?: Vacation_Status
    description?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
    user: UserCreateNestedOneWithoutVacationInput
  }

  export type VacationUncheckedCreateInput = {
    id?: string
    user_id: string
    from: Date | string
    to: Date | string
    type: Vacation_Type
    status?: Vacation_Status
    description?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type VacationUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    from?: DateTimeFieldUpdateOperationsInput | Date | string
    to?: DateTimeFieldUpdateOperationsInput | Date | string
    type?: EnumVacation_TypeFieldUpdateOperationsInput | Vacation_Type
    status?: EnumVacation_StatusFieldUpdateOperationsInput | Vacation_Status
    description?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    user?: UserUpdateOneRequiredWithoutVacationNestedInput
  }

  export type VacationUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    user_id?: StringFieldUpdateOperationsInput | string
    from?: DateTimeFieldUpdateOperationsInput | Date | string
    to?: DateTimeFieldUpdateOperationsInput | Date | string
    type?: EnumVacation_TypeFieldUpdateOperationsInput | Vacation_Type
    status?: EnumVacation_StatusFieldUpdateOperationsInput | Vacation_Status
    description?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type VacationCreateManyInput = {
    id?: string
    user_id: string
    from: Date | string
    to: Date | string
    type: Vacation_Type
    status?: Vacation_Status
    description?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type VacationUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    from?: DateTimeFieldUpdateOperationsInput | Date | string
    to?: DateTimeFieldUpdateOperationsInput | Date | string
    type?: EnumVacation_TypeFieldUpdateOperationsInput | Vacation_Type
    status?: EnumVacation_StatusFieldUpdateOperationsInput | Vacation_Status
    description?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type VacationUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    user_id?: StringFieldUpdateOperationsInput | string
    from?: DateTimeFieldUpdateOperationsInput | Date | string
    to?: DateTimeFieldUpdateOperationsInput | Date | string
    type?: EnumVacation_TypeFieldUpdateOperationsInput | Vacation_Type
    status?: EnumVacation_StatusFieldUpdateOperationsInput | Vacation_Status
    description?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type StringFilter = {
    equals?: string
    in?: Enumerable<string>
    notIn?: Enumerable<string>
    lt?: string
    lte?: string
    gt?: string
    gte?: string
    contains?: string
    startsWith?: string
    endsWith?: string
    not?: NestedStringFilter | string
  }

  export type StringNullableFilter = {
    equals?: string | null
    in?: Enumerable<string> | null
    notIn?: Enumerable<string> | null
    lt?: string
    lte?: string
    gt?: string
    gte?: string
    contains?: string
    startsWith?: string
    endsWith?: string
    not?: NestedStringNullableFilter | string | null
  }

  export type EnumUserStatusFilter = {
    equals?: UserStatus
    in?: Enumerable<UserStatus>
    notIn?: Enumerable<UserStatus>
    not?: NestedEnumUserStatusFilter | UserStatus
  }

  export type DateTimeFilter = {
    equals?: Date | string
    in?: Enumerable<Date> | Enumerable<string>
    notIn?: Enumerable<Date> | Enumerable<string>
    lt?: Date | string
    lte?: Date | string
    gt?: Date | string
    gte?: Date | string
    not?: NestedDateTimeFilter | Date | string
  }

  export type UserDetailRelationFilter = {
    is?: UserDetailWhereInput | null
    isNot?: UserDetailWhereInput | null
  }

  export type UserDetailListRelationFilter = {
    every?: UserDetailWhereInput
    some?: UserDetailWhereInput
    none?: UserDetailWhereInput
  }

  export type RoleRelationFilter = {
    is?: RoleWhereInput
    isNot?: RoleWhereInput
  }

  export type ResetPassowrdRelationFilter = {
    is?: ResetPassowrdWhereInput | null
    isNot?: ResetPassowrdWhereInput | null
  }

  export type InoutListRelationFilter = {
    every?: InoutWhereInput
    some?: InoutWhereInput
    none?: InoutWhereInput
  }

  export type FileListRelationFilter = {
    every?: FileWhereInput
    some?: FileWhereInput
    none?: FileWhereInput
  }

  export type NotificationListRelationFilter = {
    every?: NotificationWhereInput
    some?: NotificationWhereInput
    none?: NotificationWhereInput
  }

  export type Notification_ReceiverListRelationFilter = {
    every?: Notification_ReceiverWhereInput
    some?: Notification_ReceiverWhereInput
    none?: Notification_ReceiverWhereInput
  }

  export type VacationListRelationFilter = {
    every?: VacationWhereInput
    some?: VacationWhereInput
    none?: VacationWhereInput
  }

  export type UserDetailOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type InoutOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type FileOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type NotificationOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type Notification_ReceiverOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type VacationOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type UserCountOrderByAggregateInput = {
    id?: SortOrder
    email?: SortOrder
    password?: SortOrder
    phone?: SortOrder
    status?: SortOrder
    role_id?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
  }

  export type UserMaxOrderByAggregateInput = {
    id?: SortOrder
    email?: SortOrder
    password?: SortOrder
    phone?: SortOrder
    status?: SortOrder
    role_id?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
  }

  export type UserMinOrderByAggregateInput = {
    id?: SortOrder
    email?: SortOrder
    password?: SortOrder
    phone?: SortOrder
    status?: SortOrder
    role_id?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
  }

  export type StringWithAggregatesFilter = {
    equals?: string
    in?: Enumerable<string>
    notIn?: Enumerable<string>
    lt?: string
    lte?: string
    gt?: string
    gte?: string
    contains?: string
    startsWith?: string
    endsWith?: string
    not?: NestedStringWithAggregatesFilter | string
    _count?: NestedIntFilter
    _min?: NestedStringFilter
    _max?: NestedStringFilter
  }

  export type StringNullableWithAggregatesFilter = {
    equals?: string | null
    in?: Enumerable<string> | null
    notIn?: Enumerable<string> | null
    lt?: string
    lte?: string
    gt?: string
    gte?: string
    contains?: string
    startsWith?: string
    endsWith?: string
    not?: NestedStringNullableWithAggregatesFilter | string | null
    _count?: NestedIntNullableFilter
    _min?: NestedStringNullableFilter
    _max?: NestedStringNullableFilter
  }

  export type EnumUserStatusWithAggregatesFilter = {
    equals?: UserStatus
    in?: Enumerable<UserStatus>
    notIn?: Enumerable<UserStatus>
    not?: NestedEnumUserStatusWithAggregatesFilter | UserStatus
    _count?: NestedIntFilter
    _min?: NestedEnumUserStatusFilter
    _max?: NestedEnumUserStatusFilter
  }

  export type DateTimeWithAggregatesFilter = {
    equals?: Date | string
    in?: Enumerable<Date> | Enumerable<string>
    notIn?: Enumerable<Date> | Enumerable<string>
    lt?: Date | string
    lte?: Date | string
    gt?: Date | string
    gte?: Date | string
    not?: NestedDateTimeWithAggregatesFilter | Date | string
    _count?: NestedIntFilter
    _min?: NestedDateTimeFilter
    _max?: NestedDateTimeFilter
  }

  export type IntNullableFilter = {
    equals?: number | null
    in?: Enumerable<number> | null
    notIn?: Enumerable<number> | null
    lt?: number
    lte?: number
    gt?: number
    gte?: number
    not?: NestedIntNullableFilter | number | null
  }

  export type IntFilter = {
    equals?: number
    in?: Enumerable<number>
    notIn?: Enumerable<number>
    lt?: number
    lte?: number
    gt?: number
    gte?: number
    not?: NestedIntFilter | number
  }

  export type FileRelationFilter = {
    is?: FileWhereInput | null
    isNot?: FileWhereInput | null
  }

  export type UserRelationFilter = {
    is?: UserWhereInput
    isNot?: UserWhereInput
  }

  export type UserDetailCountOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    first_name?: SortOrder
    last_name?: SortOrder
    personal_code?: SortOrder
    featured_image?: SortOrder
    delay_time?: SortOrder
    delay_ratio?: SortOrder
    manager_id?: SortOrder
    vacation_remained?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
  }

  export type UserDetailAvgOrderByAggregateInput = {
    personal_code?: SortOrder
    delay_ratio?: SortOrder
    vacation_remained?: SortOrder
  }

  export type UserDetailMaxOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    first_name?: SortOrder
    last_name?: SortOrder
    personal_code?: SortOrder
    featured_image?: SortOrder
    delay_time?: SortOrder
    delay_ratio?: SortOrder
    manager_id?: SortOrder
    vacation_remained?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
  }

  export type UserDetailMinOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    first_name?: SortOrder
    last_name?: SortOrder
    personal_code?: SortOrder
    featured_image?: SortOrder
    delay_time?: SortOrder
    delay_ratio?: SortOrder
    manager_id?: SortOrder
    vacation_remained?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
  }

  export type UserDetailSumOrderByAggregateInput = {
    personal_code?: SortOrder
    delay_ratio?: SortOrder
    vacation_remained?: SortOrder
  }

  export type IntNullableWithAggregatesFilter = {
    equals?: number | null
    in?: Enumerable<number> | null
    notIn?: Enumerable<number> | null
    lt?: number
    lte?: number
    gt?: number
    gte?: number
    not?: NestedIntNullableWithAggregatesFilter | number | null
    _count?: NestedIntNullableFilter
    _avg?: NestedFloatNullableFilter
    _sum?: NestedIntNullableFilter
    _min?: NestedIntNullableFilter
    _max?: NestedIntNullableFilter
  }

  export type IntWithAggregatesFilter = {
    equals?: number
    in?: Enumerable<number>
    notIn?: Enumerable<number>
    lt?: number
    lte?: number
    gt?: number
    gte?: number
    not?: NestedIntWithAggregatesFilter | number
    _count?: NestedIntFilter
    _avg?: NestedFloatFilter
    _sum?: NestedIntFilter
    _min?: NestedIntFilter
    _max?: NestedIntFilter
  }

  export type ResetPassowrdCountOrderByAggregateInput = {
    email?: SortOrder
    token?: SortOrder
    createdAt?: SortOrder
  }

  export type ResetPassowrdMaxOrderByAggregateInput = {
    email?: SortOrder
    token?: SortOrder
    createdAt?: SortOrder
  }

  export type ResetPassowrdMinOrderByAggregateInput = {
    email?: SortOrder
    token?: SortOrder
    createdAt?: SortOrder
  }

  export type PermissionsOnRoleListRelationFilter = {
    every?: PermissionsOnRoleWhereInput
    some?: PermissionsOnRoleWhereInput
    none?: PermissionsOnRoleWhereInput
  }

  export type UserListRelationFilter = {
    every?: UserWhereInput
    some?: UserWhereInput
    none?: UserWhereInput
  }

  export type PermissionsOnRoleOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type UserOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type RoleCountOrderByAggregateInput = {
    id?: SortOrder
    name?: SortOrder
    description?: SortOrder
  }

  export type RoleMaxOrderByAggregateInput = {
    id?: SortOrder
    name?: SortOrder
    description?: SortOrder
  }

  export type RoleMinOrderByAggregateInput = {
    id?: SortOrder
    name?: SortOrder
    description?: SortOrder
  }

  export type PermissionCountOrderByAggregateInput = {
    id?: SortOrder
    key?: SortOrder
    persian_name?: SortOrder
    english_name?: SortOrder
    category?: SortOrder
  }

  export type PermissionMaxOrderByAggregateInput = {
    id?: SortOrder
    key?: SortOrder
    persian_name?: SortOrder
    english_name?: SortOrder
    category?: SortOrder
  }

  export type PermissionMinOrderByAggregateInput = {
    id?: SortOrder
    key?: SortOrder
    persian_name?: SortOrder
    english_name?: SortOrder
    category?: SortOrder
  }

  export type PermissionRelationFilter = {
    is?: PermissionWhereInput
    isNot?: PermissionWhereInput
  }

  export type PermissionsOnRoleCountOrderByAggregateInput = {
    id?: SortOrder
    role_id?: SortOrder
    permission_id?: SortOrder
    assignedAt?: SortOrder
    assignedBy?: SortOrder
  }

  export type PermissionsOnRoleMaxOrderByAggregateInput = {
    id?: SortOrder
    role_id?: SortOrder
    permission_id?: SortOrder
    assignedAt?: SortOrder
    assignedBy?: SortOrder
  }

  export type PermissionsOnRoleMinOrderByAggregateInput = {
    id?: SortOrder
    role_id?: SortOrder
    permission_id?: SortOrder
    assignedAt?: SortOrder
    assignedBy?: SortOrder
  }

  export type EnumFileTypeFilter = {
    equals?: FileType
    in?: Enumerable<FileType>
    notIn?: Enumerable<FileType>
    not?: NestedEnumFileTypeFilter | FileType
  }

  export type FileCountOrderByAggregateInput = {
    id?: SortOrder
    path?: SortOrder
    type?: SortOrder
    author?: SortOrder
    size?: SortOrder
    alt?: SortOrder
    mimetype?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
  }

  export type FileAvgOrderByAggregateInput = {
    size?: SortOrder
  }

  export type FileMaxOrderByAggregateInput = {
    id?: SortOrder
    path?: SortOrder
    type?: SortOrder
    author?: SortOrder
    size?: SortOrder
    alt?: SortOrder
    mimetype?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
  }

  export type FileMinOrderByAggregateInput = {
    id?: SortOrder
    path?: SortOrder
    type?: SortOrder
    author?: SortOrder
    size?: SortOrder
    alt?: SortOrder
    mimetype?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
  }

  export type FileSumOrderByAggregateInput = {
    size?: SortOrder
  }

  export type EnumFileTypeWithAggregatesFilter = {
    equals?: FileType
    in?: Enumerable<FileType>
    notIn?: Enumerable<FileType>
    not?: NestedEnumFileTypeWithAggregatesFilter | FileType
    _count?: NestedIntFilter
    _min?: NestedEnumFileTypeFilter
    _max?: NestedEnumFileTypeFilter
  }

  export type EnumInoutTypeFilter = {
    equals?: InoutType
    in?: Enumerable<InoutType>
    notIn?: Enumerable<InoutType>
    not?: NestedEnumInoutTypeFilter | InoutType
  }

  export type BoolFilter = {
    equals?: boolean
    not?: NestedBoolFilter | boolean
  }

  export type Inout_logsListRelationFilter = {
    every?: Inout_logsWhereInput
    some?: Inout_logsWhereInput
    none?: Inout_logsWhereInput
  }

  export type Inout_logsOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type InoutTimeUser_idCompoundUniqueInput = {
    time: Date | string
    user_id: string
  }

  export type InoutCountOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    time?: SortOrder
    type?: SortOrder
    delete?: SortOrder
    description?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
    approved?: SortOrder
  }

  export type InoutMaxOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    time?: SortOrder
    type?: SortOrder
    delete?: SortOrder
    description?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
    approved?: SortOrder
  }

  export type InoutMinOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    time?: SortOrder
    type?: SortOrder
    delete?: SortOrder
    description?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
    approved?: SortOrder
  }

  export type EnumInoutTypeWithAggregatesFilter = {
    equals?: InoutType
    in?: Enumerable<InoutType>
    notIn?: Enumerable<InoutType>
    not?: NestedEnumInoutTypeWithAggregatesFilter | InoutType
    _count?: NestedIntFilter
    _min?: NestedEnumInoutTypeFilter
    _max?: NestedEnumInoutTypeFilter
  }

  export type BoolWithAggregatesFilter = {
    equals?: boolean
    not?: NestedBoolWithAggregatesFilter | boolean
    _count?: NestedIntFilter
    _min?: NestedBoolFilter
    _max?: NestedBoolFilter
  }

  export type EnumLog_ActionFilter = {
    equals?: Log_Action
    in?: Enumerable<Log_Action>
    notIn?: Enumerable<Log_Action>
    not?: NestedEnumLog_ActionFilter | Log_Action
  }

  export type DateTimeNullableFilter = {
    equals?: Date | string | null
    in?: Enumerable<Date> | Enumerable<string> | null
    notIn?: Enumerable<Date> | Enumerable<string> | null
    lt?: Date | string
    lte?: Date | string
    gt?: Date | string
    gte?: Date | string
    not?: NestedDateTimeNullableFilter | Date | string | null
  }

  export type InoutRelationFilter = {
    is?: InoutWhereInput
    isNot?: InoutWhereInput
  }

  export type Inout_logsCountOrderByAggregateInput = {
    id?: SortOrder
    inout_id?: SortOrder
    action?: SortOrder
    old_time?: SortOrder
    new_time?: SortOrder
    description?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
  }

  export type Inout_logsMaxOrderByAggregateInput = {
    id?: SortOrder
    inout_id?: SortOrder
    action?: SortOrder
    old_time?: SortOrder
    new_time?: SortOrder
    description?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
  }

  export type Inout_logsMinOrderByAggregateInput = {
    id?: SortOrder
    inout_id?: SortOrder
    action?: SortOrder
    old_time?: SortOrder
    new_time?: SortOrder
    description?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
  }

  export type EnumLog_ActionWithAggregatesFilter = {
    equals?: Log_Action
    in?: Enumerable<Log_Action>
    notIn?: Enumerable<Log_Action>
    not?: NestedEnumLog_ActionWithAggregatesFilter | Log_Action
    _count?: NestedIntFilter
    _min?: NestedEnumLog_ActionFilter
    _max?: NestedEnumLog_ActionFilter
  }

  export type DateTimeNullableWithAggregatesFilter = {
    equals?: Date | string | null
    in?: Enumerable<Date> | Enumerable<string> | null
    notIn?: Enumerable<Date> | Enumerable<string> | null
    lt?: Date | string
    lte?: Date | string
    gt?: Date | string
    gte?: Date | string
    not?: NestedDateTimeNullableWithAggregatesFilter | Date | string | null
    _count?: NestedIntNullableFilter
    _min?: NestedDateTimeNullableFilter
    _max?: NestedDateTimeNullableFilter
  }

  export type HolidayCountOrderByAggregateInput = {
    date?: SortOrder
  }

  export type HolidayMaxOrderByAggregateInput = {
    date?: SortOrder
  }

  export type HolidayMinOrderByAggregateInput = {
    date?: SortOrder
  }

  export type NotificationCountOrderByAggregateInput = {
    id?: SortOrder
    title?: SortOrder
    content?: SortOrder
    file_id?: SortOrder
    author_id?: SortOrder
    createdAt?: SortOrder
  }

  export type NotificationMaxOrderByAggregateInput = {
    id?: SortOrder
    title?: SortOrder
    content?: SortOrder
    file_id?: SortOrder
    author_id?: SortOrder
    createdAt?: SortOrder
  }

  export type NotificationMinOrderByAggregateInput = {
    id?: SortOrder
    title?: SortOrder
    content?: SortOrder
    file_id?: SortOrder
    author_id?: SortOrder
    createdAt?: SortOrder
  }

  export type NotificationRelationFilter = {
    is?: NotificationWhereInput
    isNot?: NotificationWhereInput
  }

  export type Notification_ReceiverCountOrderByAggregateInput = {
    id?: SortOrder
    notification_id?: SortOrder
    user_id?: SortOrder
    isRead?: SortOrder
  }

  export type Notification_ReceiverMaxOrderByAggregateInput = {
    id?: SortOrder
    notification_id?: SortOrder
    user_id?: SortOrder
    isRead?: SortOrder
  }

  export type Notification_ReceiverMinOrderByAggregateInput = {
    id?: SortOrder
    notification_id?: SortOrder
    user_id?: SortOrder
    isRead?: SortOrder
  }

  export type EnumVacation_TypeFilter = {
    equals?: Vacation_Type
    in?: Enumerable<Vacation_Type>
    notIn?: Enumerable<Vacation_Type>
    not?: NestedEnumVacation_TypeFilter | Vacation_Type
  }

  export type EnumVacation_StatusFilter = {
    equals?: Vacation_Status
    in?: Enumerable<Vacation_Status>
    notIn?: Enumerable<Vacation_Status>
    not?: NestedEnumVacation_StatusFilter | Vacation_Status
  }

  export type VacationCountOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    from?: SortOrder
    to?: SortOrder
    type?: SortOrder
    status?: SortOrder
    description?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
  }

  export type VacationMaxOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    from?: SortOrder
    to?: SortOrder
    type?: SortOrder
    status?: SortOrder
    description?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
  }

  export type VacationMinOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    from?: SortOrder
    to?: SortOrder
    type?: SortOrder
    status?: SortOrder
    description?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
  }

  export type EnumVacation_TypeWithAggregatesFilter = {
    equals?: Vacation_Type
    in?: Enumerable<Vacation_Type>
    notIn?: Enumerable<Vacation_Type>
    not?: NestedEnumVacation_TypeWithAggregatesFilter | Vacation_Type
    _count?: NestedIntFilter
    _min?: NestedEnumVacation_TypeFilter
    _max?: NestedEnumVacation_TypeFilter
  }

  export type EnumVacation_StatusWithAggregatesFilter = {
    equals?: Vacation_Status
    in?: Enumerable<Vacation_Status>
    notIn?: Enumerable<Vacation_Status>
    not?: NestedEnumVacation_StatusWithAggregatesFilter | Vacation_Status
    _count?: NestedIntFilter
    _min?: NestedEnumVacation_StatusFilter
    _max?: NestedEnumVacation_StatusFilter
  }

  export type UserDetailCreateNestedOneWithoutUserInput = {
    create?: XOR<UserDetailCreateWithoutUserInput, UserDetailUncheckedCreateWithoutUserInput>
    connectOrCreate?: UserDetailCreateOrConnectWithoutUserInput
    connect?: UserDetailWhereUniqueInput
  }

  export type UserDetailCreateNestedManyWithoutManagerInput = {
    create?: XOR<Enumerable<UserDetailCreateWithoutManagerInput>, Enumerable<UserDetailUncheckedCreateWithoutManagerInput>>
    connectOrCreate?: Enumerable<UserDetailCreateOrConnectWithoutManagerInput>
    createMany?: UserDetailCreateManyManagerInputEnvelope
    connect?: Enumerable<UserDetailWhereUniqueInput>
  }

  export type RoleCreateNestedOneWithoutUserInput = {
    create?: XOR<RoleCreateWithoutUserInput, RoleUncheckedCreateWithoutUserInput>
    connectOrCreate?: RoleCreateOrConnectWithoutUserInput
    connect?: RoleWhereUniqueInput
  }

  export type ResetPassowrdCreateNestedOneWithoutUserInput = {
    create?: XOR<ResetPassowrdCreateWithoutUserInput, ResetPassowrdUncheckedCreateWithoutUserInput>
    connectOrCreate?: ResetPassowrdCreateOrConnectWithoutUserInput
    connect?: ResetPassowrdWhereUniqueInput
  }

  export type InoutCreateNestedManyWithoutUserInput = {
    create?: XOR<Enumerable<InoutCreateWithoutUserInput>, Enumerable<InoutUncheckedCreateWithoutUserInput>>
    connectOrCreate?: Enumerable<InoutCreateOrConnectWithoutUserInput>
    createMany?: InoutCreateManyUserInputEnvelope
    connect?: Enumerable<InoutWhereUniqueInput>
  }

  export type FileCreateNestedManyWithoutUserInput = {
    create?: XOR<Enumerable<FileCreateWithoutUserInput>, Enumerable<FileUncheckedCreateWithoutUserInput>>
    connectOrCreate?: Enumerable<FileCreateOrConnectWithoutUserInput>
    createMany?: FileCreateManyUserInputEnvelope
    connect?: Enumerable<FileWhereUniqueInput>
  }

  export type NotificationCreateNestedManyWithoutAuthorInput = {
    create?: XOR<Enumerable<NotificationCreateWithoutAuthorInput>, Enumerable<NotificationUncheckedCreateWithoutAuthorInput>>
    connectOrCreate?: Enumerable<NotificationCreateOrConnectWithoutAuthorInput>
    createMany?: NotificationCreateManyAuthorInputEnvelope
    connect?: Enumerable<NotificationWhereUniqueInput>
  }

  export type Notification_ReceiverCreateNestedManyWithoutUserInput = {
    create?: XOR<Enumerable<Notification_ReceiverCreateWithoutUserInput>, Enumerable<Notification_ReceiverUncheckedCreateWithoutUserInput>>
    connectOrCreate?: Enumerable<Notification_ReceiverCreateOrConnectWithoutUserInput>
    createMany?: Notification_ReceiverCreateManyUserInputEnvelope
    connect?: Enumerable<Notification_ReceiverWhereUniqueInput>
  }

  export type VacationCreateNestedManyWithoutUserInput = {
    create?: XOR<Enumerable<VacationCreateWithoutUserInput>, Enumerable<VacationUncheckedCreateWithoutUserInput>>
    connectOrCreate?: Enumerable<VacationCreateOrConnectWithoutUserInput>
    createMany?: VacationCreateManyUserInputEnvelope
    connect?: Enumerable<VacationWhereUniqueInput>
  }

  export type UserDetailUncheckedCreateNestedOneWithoutUserInput = {
    create?: XOR<UserDetailCreateWithoutUserInput, UserDetailUncheckedCreateWithoutUserInput>
    connectOrCreate?: UserDetailCreateOrConnectWithoutUserInput
    connect?: UserDetailWhereUniqueInput
  }

  export type UserDetailUncheckedCreateNestedManyWithoutManagerInput = {
    create?: XOR<Enumerable<UserDetailCreateWithoutManagerInput>, Enumerable<UserDetailUncheckedCreateWithoutManagerInput>>
    connectOrCreate?: Enumerable<UserDetailCreateOrConnectWithoutManagerInput>
    createMany?: UserDetailCreateManyManagerInputEnvelope
    connect?: Enumerable<UserDetailWhereUniqueInput>
  }

  export type ResetPassowrdUncheckedCreateNestedOneWithoutUserInput = {
    create?: XOR<ResetPassowrdCreateWithoutUserInput, ResetPassowrdUncheckedCreateWithoutUserInput>
    connectOrCreate?: ResetPassowrdCreateOrConnectWithoutUserInput
    connect?: ResetPassowrdWhereUniqueInput
  }

  export type InoutUncheckedCreateNestedManyWithoutUserInput = {
    create?: XOR<Enumerable<InoutCreateWithoutUserInput>, Enumerable<InoutUncheckedCreateWithoutUserInput>>
    connectOrCreate?: Enumerable<InoutCreateOrConnectWithoutUserInput>
    createMany?: InoutCreateManyUserInputEnvelope
    connect?: Enumerable<InoutWhereUniqueInput>
  }

  export type FileUncheckedCreateNestedManyWithoutUserInput = {
    create?: XOR<Enumerable<FileCreateWithoutUserInput>, Enumerable<FileUncheckedCreateWithoutUserInput>>
    connectOrCreate?: Enumerable<FileCreateOrConnectWithoutUserInput>
    createMany?: FileCreateManyUserInputEnvelope
    connect?: Enumerable<FileWhereUniqueInput>
  }

  export type NotificationUncheckedCreateNestedManyWithoutAuthorInput = {
    create?: XOR<Enumerable<NotificationCreateWithoutAuthorInput>, Enumerable<NotificationUncheckedCreateWithoutAuthorInput>>
    connectOrCreate?: Enumerable<NotificationCreateOrConnectWithoutAuthorInput>
    createMany?: NotificationCreateManyAuthorInputEnvelope
    connect?: Enumerable<NotificationWhereUniqueInput>
  }

  export type Notification_ReceiverUncheckedCreateNestedManyWithoutUserInput = {
    create?: XOR<Enumerable<Notification_ReceiverCreateWithoutUserInput>, Enumerable<Notification_ReceiverUncheckedCreateWithoutUserInput>>
    connectOrCreate?: Enumerable<Notification_ReceiverCreateOrConnectWithoutUserInput>
    createMany?: Notification_ReceiverCreateManyUserInputEnvelope
    connect?: Enumerable<Notification_ReceiverWhereUniqueInput>
  }

  export type VacationUncheckedCreateNestedManyWithoutUserInput = {
    create?: XOR<Enumerable<VacationCreateWithoutUserInput>, Enumerable<VacationUncheckedCreateWithoutUserInput>>
    connectOrCreate?: Enumerable<VacationCreateOrConnectWithoutUserInput>
    createMany?: VacationCreateManyUserInputEnvelope
    connect?: Enumerable<VacationWhereUniqueInput>
  }

  export type StringFieldUpdateOperationsInput = {
    set?: string
  }

  export type NullableStringFieldUpdateOperationsInput = {
    set?: string | null
  }

  export type EnumUserStatusFieldUpdateOperationsInput = {
    set?: UserStatus
  }

  export type DateTimeFieldUpdateOperationsInput = {
    set?: Date | string
  }

  export type UserDetailUpdateOneWithoutUserNestedInput = {
    create?: XOR<UserDetailCreateWithoutUserInput, UserDetailUncheckedCreateWithoutUserInput>
    connectOrCreate?: UserDetailCreateOrConnectWithoutUserInput
    upsert?: UserDetailUpsertWithoutUserInput
    disconnect?: boolean
    delete?: boolean
    connect?: UserDetailWhereUniqueInput
    update?: XOR<UserDetailUpdateWithoutUserInput, UserDetailUncheckedUpdateWithoutUserInput>
  }

  export type UserDetailUpdateManyWithoutManagerNestedInput = {
    create?: XOR<Enumerable<UserDetailCreateWithoutManagerInput>, Enumerable<UserDetailUncheckedCreateWithoutManagerInput>>
    connectOrCreate?: Enumerable<UserDetailCreateOrConnectWithoutManagerInput>
    upsert?: Enumerable<UserDetailUpsertWithWhereUniqueWithoutManagerInput>
    createMany?: UserDetailCreateManyManagerInputEnvelope
    set?: Enumerable<UserDetailWhereUniqueInput>
    disconnect?: Enumerable<UserDetailWhereUniqueInput>
    delete?: Enumerable<UserDetailWhereUniqueInput>
    connect?: Enumerable<UserDetailWhereUniqueInput>
    update?: Enumerable<UserDetailUpdateWithWhereUniqueWithoutManagerInput>
    updateMany?: Enumerable<UserDetailUpdateManyWithWhereWithoutManagerInput>
    deleteMany?: Enumerable<UserDetailScalarWhereInput>
  }

  export type RoleUpdateOneRequiredWithoutUserNestedInput = {
    create?: XOR<RoleCreateWithoutUserInput, RoleUncheckedCreateWithoutUserInput>
    connectOrCreate?: RoleCreateOrConnectWithoutUserInput
    upsert?: RoleUpsertWithoutUserInput
    connect?: RoleWhereUniqueInput
    update?: XOR<RoleUpdateWithoutUserInput, RoleUncheckedUpdateWithoutUserInput>
  }

  export type ResetPassowrdUpdateOneWithoutUserNestedInput = {
    create?: XOR<ResetPassowrdCreateWithoutUserInput, ResetPassowrdUncheckedCreateWithoutUserInput>
    connectOrCreate?: ResetPassowrdCreateOrConnectWithoutUserInput
    upsert?: ResetPassowrdUpsertWithoutUserInput
    disconnect?: boolean
    delete?: boolean
    connect?: ResetPassowrdWhereUniqueInput
    update?: XOR<ResetPassowrdUpdateWithoutUserInput, ResetPassowrdUncheckedUpdateWithoutUserInput>
  }

  export type InoutUpdateManyWithoutUserNestedInput = {
    create?: XOR<Enumerable<InoutCreateWithoutUserInput>, Enumerable<InoutUncheckedCreateWithoutUserInput>>
    connectOrCreate?: Enumerable<InoutCreateOrConnectWithoutUserInput>
    upsert?: Enumerable<InoutUpsertWithWhereUniqueWithoutUserInput>
    createMany?: InoutCreateManyUserInputEnvelope
    set?: Enumerable<InoutWhereUniqueInput>
    disconnect?: Enumerable<InoutWhereUniqueInput>
    delete?: Enumerable<InoutWhereUniqueInput>
    connect?: Enumerable<InoutWhereUniqueInput>
    update?: Enumerable<InoutUpdateWithWhereUniqueWithoutUserInput>
    updateMany?: Enumerable<InoutUpdateManyWithWhereWithoutUserInput>
    deleteMany?: Enumerable<InoutScalarWhereInput>
  }

  export type FileUpdateManyWithoutUserNestedInput = {
    create?: XOR<Enumerable<FileCreateWithoutUserInput>, Enumerable<FileUncheckedCreateWithoutUserInput>>
    connectOrCreate?: Enumerable<FileCreateOrConnectWithoutUserInput>
    upsert?: Enumerable<FileUpsertWithWhereUniqueWithoutUserInput>
    createMany?: FileCreateManyUserInputEnvelope
    set?: Enumerable<FileWhereUniqueInput>
    disconnect?: Enumerable<FileWhereUniqueInput>
    delete?: Enumerable<FileWhereUniqueInput>
    connect?: Enumerable<FileWhereUniqueInput>
    update?: Enumerable<FileUpdateWithWhereUniqueWithoutUserInput>
    updateMany?: Enumerable<FileUpdateManyWithWhereWithoutUserInput>
    deleteMany?: Enumerable<FileScalarWhereInput>
  }

  export type NotificationUpdateManyWithoutAuthorNestedInput = {
    create?: XOR<Enumerable<NotificationCreateWithoutAuthorInput>, Enumerable<NotificationUncheckedCreateWithoutAuthorInput>>
    connectOrCreate?: Enumerable<NotificationCreateOrConnectWithoutAuthorInput>
    upsert?: Enumerable<NotificationUpsertWithWhereUniqueWithoutAuthorInput>
    createMany?: NotificationCreateManyAuthorInputEnvelope
    set?: Enumerable<NotificationWhereUniqueInput>
    disconnect?: Enumerable<NotificationWhereUniqueInput>
    delete?: Enumerable<NotificationWhereUniqueInput>
    connect?: Enumerable<NotificationWhereUniqueInput>
    update?: Enumerable<NotificationUpdateWithWhereUniqueWithoutAuthorInput>
    updateMany?: Enumerable<NotificationUpdateManyWithWhereWithoutAuthorInput>
    deleteMany?: Enumerable<NotificationScalarWhereInput>
  }

  export type Notification_ReceiverUpdateManyWithoutUserNestedInput = {
    create?: XOR<Enumerable<Notification_ReceiverCreateWithoutUserInput>, Enumerable<Notification_ReceiverUncheckedCreateWithoutUserInput>>
    connectOrCreate?: Enumerable<Notification_ReceiverCreateOrConnectWithoutUserInput>
    upsert?: Enumerable<Notification_ReceiverUpsertWithWhereUniqueWithoutUserInput>
    createMany?: Notification_ReceiverCreateManyUserInputEnvelope
    set?: Enumerable<Notification_ReceiverWhereUniqueInput>
    disconnect?: Enumerable<Notification_ReceiverWhereUniqueInput>
    delete?: Enumerable<Notification_ReceiverWhereUniqueInput>
    connect?: Enumerable<Notification_ReceiverWhereUniqueInput>
    update?: Enumerable<Notification_ReceiverUpdateWithWhereUniqueWithoutUserInput>
    updateMany?: Enumerable<Notification_ReceiverUpdateManyWithWhereWithoutUserInput>
    deleteMany?: Enumerable<Notification_ReceiverScalarWhereInput>
  }

  export type VacationUpdateManyWithoutUserNestedInput = {
    create?: XOR<Enumerable<VacationCreateWithoutUserInput>, Enumerable<VacationUncheckedCreateWithoutUserInput>>
    connectOrCreate?: Enumerable<VacationCreateOrConnectWithoutUserInput>
    upsert?: Enumerable<VacationUpsertWithWhereUniqueWithoutUserInput>
    createMany?: VacationCreateManyUserInputEnvelope
    set?: Enumerable<VacationWhereUniqueInput>
    disconnect?: Enumerable<VacationWhereUniqueInput>
    delete?: Enumerable<VacationWhereUniqueInput>
    connect?: Enumerable<VacationWhereUniqueInput>
    update?: Enumerable<VacationUpdateWithWhereUniqueWithoutUserInput>
    updateMany?: Enumerable<VacationUpdateManyWithWhereWithoutUserInput>
    deleteMany?: Enumerable<VacationScalarWhereInput>
  }

  export type UserDetailUncheckedUpdateOneWithoutUserNestedInput = {
    create?: XOR<UserDetailCreateWithoutUserInput, UserDetailUncheckedCreateWithoutUserInput>
    connectOrCreate?: UserDetailCreateOrConnectWithoutUserInput
    upsert?: UserDetailUpsertWithoutUserInput
    disconnect?: boolean
    delete?: boolean
    connect?: UserDetailWhereUniqueInput
    update?: XOR<UserDetailUpdateWithoutUserInput, UserDetailUncheckedUpdateWithoutUserInput>
  }

  export type UserDetailUncheckedUpdateManyWithoutManagerNestedInput = {
    create?: XOR<Enumerable<UserDetailCreateWithoutManagerInput>, Enumerable<UserDetailUncheckedCreateWithoutManagerInput>>
    connectOrCreate?: Enumerable<UserDetailCreateOrConnectWithoutManagerInput>
    upsert?: Enumerable<UserDetailUpsertWithWhereUniqueWithoutManagerInput>
    createMany?: UserDetailCreateManyManagerInputEnvelope
    set?: Enumerable<UserDetailWhereUniqueInput>
    disconnect?: Enumerable<UserDetailWhereUniqueInput>
    delete?: Enumerable<UserDetailWhereUniqueInput>
    connect?: Enumerable<UserDetailWhereUniqueInput>
    update?: Enumerable<UserDetailUpdateWithWhereUniqueWithoutManagerInput>
    updateMany?: Enumerable<UserDetailUpdateManyWithWhereWithoutManagerInput>
    deleteMany?: Enumerable<UserDetailScalarWhereInput>
  }

  export type ResetPassowrdUncheckedUpdateOneWithoutUserNestedInput = {
    create?: XOR<ResetPassowrdCreateWithoutUserInput, ResetPassowrdUncheckedCreateWithoutUserInput>
    connectOrCreate?: ResetPassowrdCreateOrConnectWithoutUserInput
    upsert?: ResetPassowrdUpsertWithoutUserInput
    disconnect?: boolean
    delete?: boolean
    connect?: ResetPassowrdWhereUniqueInput
    update?: XOR<ResetPassowrdUpdateWithoutUserInput, ResetPassowrdUncheckedUpdateWithoutUserInput>
  }

  export type InoutUncheckedUpdateManyWithoutUserNestedInput = {
    create?: XOR<Enumerable<InoutCreateWithoutUserInput>, Enumerable<InoutUncheckedCreateWithoutUserInput>>
    connectOrCreate?: Enumerable<InoutCreateOrConnectWithoutUserInput>
    upsert?: Enumerable<InoutUpsertWithWhereUniqueWithoutUserInput>
    createMany?: InoutCreateManyUserInputEnvelope
    set?: Enumerable<InoutWhereUniqueInput>
    disconnect?: Enumerable<InoutWhereUniqueInput>
    delete?: Enumerable<InoutWhereUniqueInput>
    connect?: Enumerable<InoutWhereUniqueInput>
    update?: Enumerable<InoutUpdateWithWhereUniqueWithoutUserInput>
    updateMany?: Enumerable<InoutUpdateManyWithWhereWithoutUserInput>
    deleteMany?: Enumerable<InoutScalarWhereInput>
  }

  export type FileUncheckedUpdateManyWithoutUserNestedInput = {
    create?: XOR<Enumerable<FileCreateWithoutUserInput>, Enumerable<FileUncheckedCreateWithoutUserInput>>
    connectOrCreate?: Enumerable<FileCreateOrConnectWithoutUserInput>
    upsert?: Enumerable<FileUpsertWithWhereUniqueWithoutUserInput>
    createMany?: FileCreateManyUserInputEnvelope
    set?: Enumerable<FileWhereUniqueInput>
    disconnect?: Enumerable<FileWhereUniqueInput>
    delete?: Enumerable<FileWhereUniqueInput>
    connect?: Enumerable<FileWhereUniqueInput>
    update?: Enumerable<FileUpdateWithWhereUniqueWithoutUserInput>
    updateMany?: Enumerable<FileUpdateManyWithWhereWithoutUserInput>
    deleteMany?: Enumerable<FileScalarWhereInput>
  }

  export type NotificationUncheckedUpdateManyWithoutAuthorNestedInput = {
    create?: XOR<Enumerable<NotificationCreateWithoutAuthorInput>, Enumerable<NotificationUncheckedCreateWithoutAuthorInput>>
    connectOrCreate?: Enumerable<NotificationCreateOrConnectWithoutAuthorInput>
    upsert?: Enumerable<NotificationUpsertWithWhereUniqueWithoutAuthorInput>
    createMany?: NotificationCreateManyAuthorInputEnvelope
    set?: Enumerable<NotificationWhereUniqueInput>
    disconnect?: Enumerable<NotificationWhereUniqueInput>
    delete?: Enumerable<NotificationWhereUniqueInput>
    connect?: Enumerable<NotificationWhereUniqueInput>
    update?: Enumerable<NotificationUpdateWithWhereUniqueWithoutAuthorInput>
    updateMany?: Enumerable<NotificationUpdateManyWithWhereWithoutAuthorInput>
    deleteMany?: Enumerable<NotificationScalarWhereInput>
  }

  export type Notification_ReceiverUncheckedUpdateManyWithoutUserNestedInput = {
    create?: XOR<Enumerable<Notification_ReceiverCreateWithoutUserInput>, Enumerable<Notification_ReceiverUncheckedCreateWithoutUserInput>>
    connectOrCreate?: Enumerable<Notification_ReceiverCreateOrConnectWithoutUserInput>
    upsert?: Enumerable<Notification_ReceiverUpsertWithWhereUniqueWithoutUserInput>
    createMany?: Notification_ReceiverCreateManyUserInputEnvelope
    set?: Enumerable<Notification_ReceiverWhereUniqueInput>
    disconnect?: Enumerable<Notification_ReceiverWhereUniqueInput>
    delete?: Enumerable<Notification_ReceiverWhereUniqueInput>
    connect?: Enumerable<Notification_ReceiverWhereUniqueInput>
    update?: Enumerable<Notification_ReceiverUpdateWithWhereUniqueWithoutUserInput>
    updateMany?: Enumerable<Notification_ReceiverUpdateManyWithWhereWithoutUserInput>
    deleteMany?: Enumerable<Notification_ReceiverScalarWhereInput>
  }

  export type VacationUncheckedUpdateManyWithoutUserNestedInput = {
    create?: XOR<Enumerable<VacationCreateWithoutUserInput>, Enumerable<VacationUncheckedCreateWithoutUserInput>>
    connectOrCreate?: Enumerable<VacationCreateOrConnectWithoutUserInput>
    upsert?: Enumerable<VacationUpsertWithWhereUniqueWithoutUserInput>
    createMany?: VacationCreateManyUserInputEnvelope
    set?: Enumerable<VacationWhereUniqueInput>
    disconnect?: Enumerable<VacationWhereUniqueInput>
    delete?: Enumerable<VacationWhereUniqueInput>
    connect?: Enumerable<VacationWhereUniqueInput>
    update?: Enumerable<VacationUpdateWithWhereUniqueWithoutUserInput>
    updateMany?: Enumerable<VacationUpdateManyWithWhereWithoutUserInput>
    deleteMany?: Enumerable<VacationScalarWhereInput>
  }

  export type FileCreateNestedOneWithoutUserDetailInput = {
    create?: XOR<FileCreateWithoutUserDetailInput, FileUncheckedCreateWithoutUserDetailInput>
    connectOrCreate?: FileCreateOrConnectWithoutUserDetailInput
    connect?: FileWhereUniqueInput
  }

  export type UserCreateNestedOneWithoutUserDetailInput = {
    create?: XOR<UserCreateWithoutUserDetailInput, UserUncheckedCreateWithoutUserDetailInput>
    connectOrCreate?: UserCreateOrConnectWithoutUserDetailInput
    connect?: UserWhereUniqueInput
  }

  export type UserCreateNestedOneWithoutUserManagerInput = {
    create?: XOR<UserCreateWithoutUserManagerInput, UserUncheckedCreateWithoutUserManagerInput>
    connectOrCreate?: UserCreateOrConnectWithoutUserManagerInput
    connect?: UserWhereUniqueInput
  }

  export type NullableIntFieldUpdateOperationsInput = {
    set?: number | null
    increment?: number
    decrement?: number
    multiply?: number
    divide?: number
  }

  export type IntFieldUpdateOperationsInput = {
    set?: number
    increment?: number
    decrement?: number
    multiply?: number
    divide?: number
  }

  export type FileUpdateOneWithoutUserDetailNestedInput = {
    create?: XOR<FileCreateWithoutUserDetailInput, FileUncheckedCreateWithoutUserDetailInput>
    connectOrCreate?: FileCreateOrConnectWithoutUserDetailInput
    upsert?: FileUpsertWithoutUserDetailInput
    disconnect?: boolean
    delete?: boolean
    connect?: FileWhereUniqueInput
    update?: XOR<FileUpdateWithoutUserDetailInput, FileUncheckedUpdateWithoutUserDetailInput>
  }

  export type UserUpdateOneRequiredWithoutUserDetailNestedInput = {
    create?: XOR<UserCreateWithoutUserDetailInput, UserUncheckedCreateWithoutUserDetailInput>
    connectOrCreate?: UserCreateOrConnectWithoutUserDetailInput
    upsert?: UserUpsertWithoutUserDetailInput
    connect?: UserWhereUniqueInput
    update?: XOR<UserUpdateWithoutUserDetailInput, UserUncheckedUpdateWithoutUserDetailInput>
  }

  export type UserUpdateOneWithoutUserManagerNestedInput = {
    create?: XOR<UserCreateWithoutUserManagerInput, UserUncheckedCreateWithoutUserManagerInput>
    connectOrCreate?: UserCreateOrConnectWithoutUserManagerInput
    upsert?: UserUpsertWithoutUserManagerInput
    disconnect?: boolean
    delete?: boolean
    connect?: UserWhereUniqueInput
    update?: XOR<UserUpdateWithoutUserManagerInput, UserUncheckedUpdateWithoutUserManagerInput>
  }

  export type UserCreateNestedOneWithoutResetPassowrdInput = {
    create?: XOR<UserCreateWithoutResetPassowrdInput, UserUncheckedCreateWithoutResetPassowrdInput>
    connectOrCreate?: UserCreateOrConnectWithoutResetPassowrdInput
    connect?: UserWhereUniqueInput
  }

  export type UserUpdateOneRequiredWithoutResetPassowrdNestedInput = {
    create?: XOR<UserCreateWithoutResetPassowrdInput, UserUncheckedCreateWithoutResetPassowrdInput>
    connectOrCreate?: UserCreateOrConnectWithoutResetPassowrdInput
    upsert?: UserUpsertWithoutResetPassowrdInput
    connect?: UserWhereUniqueInput
    update?: XOR<UserUpdateWithoutResetPassowrdInput, UserUncheckedUpdateWithoutResetPassowrdInput>
  }

  export type PermissionsOnRoleCreateNestedManyWithoutRoleInput = {
    create?: XOR<Enumerable<PermissionsOnRoleCreateWithoutRoleInput>, Enumerable<PermissionsOnRoleUncheckedCreateWithoutRoleInput>>
    connectOrCreate?: Enumerable<PermissionsOnRoleCreateOrConnectWithoutRoleInput>
    createMany?: PermissionsOnRoleCreateManyRoleInputEnvelope
    connect?: Enumerable<PermissionsOnRoleWhereUniqueInput>
  }

  export type UserCreateNestedManyWithoutRoleInput = {
    create?: XOR<Enumerable<UserCreateWithoutRoleInput>, Enumerable<UserUncheckedCreateWithoutRoleInput>>
    connectOrCreate?: Enumerable<UserCreateOrConnectWithoutRoleInput>
    createMany?: UserCreateManyRoleInputEnvelope
    connect?: Enumerable<UserWhereUniqueInput>
  }

  export type PermissionsOnRoleUncheckedCreateNestedManyWithoutRoleInput = {
    create?: XOR<Enumerable<PermissionsOnRoleCreateWithoutRoleInput>, Enumerable<PermissionsOnRoleUncheckedCreateWithoutRoleInput>>
    connectOrCreate?: Enumerable<PermissionsOnRoleCreateOrConnectWithoutRoleInput>
    createMany?: PermissionsOnRoleCreateManyRoleInputEnvelope
    connect?: Enumerable<PermissionsOnRoleWhereUniqueInput>
  }

  export type UserUncheckedCreateNestedManyWithoutRoleInput = {
    create?: XOR<Enumerable<UserCreateWithoutRoleInput>, Enumerable<UserUncheckedCreateWithoutRoleInput>>
    connectOrCreate?: Enumerable<UserCreateOrConnectWithoutRoleInput>
    createMany?: UserCreateManyRoleInputEnvelope
    connect?: Enumerable<UserWhereUniqueInput>
  }

  export type PermissionsOnRoleUpdateManyWithoutRoleNestedInput = {
    create?: XOR<Enumerable<PermissionsOnRoleCreateWithoutRoleInput>, Enumerable<PermissionsOnRoleUncheckedCreateWithoutRoleInput>>
    connectOrCreate?: Enumerable<PermissionsOnRoleCreateOrConnectWithoutRoleInput>
    upsert?: Enumerable<PermissionsOnRoleUpsertWithWhereUniqueWithoutRoleInput>
    createMany?: PermissionsOnRoleCreateManyRoleInputEnvelope
    set?: Enumerable<PermissionsOnRoleWhereUniqueInput>
    disconnect?: Enumerable<PermissionsOnRoleWhereUniqueInput>
    delete?: Enumerable<PermissionsOnRoleWhereUniqueInput>
    connect?: Enumerable<PermissionsOnRoleWhereUniqueInput>
    update?: Enumerable<PermissionsOnRoleUpdateWithWhereUniqueWithoutRoleInput>
    updateMany?: Enumerable<PermissionsOnRoleUpdateManyWithWhereWithoutRoleInput>
    deleteMany?: Enumerable<PermissionsOnRoleScalarWhereInput>
  }

  export type UserUpdateManyWithoutRoleNestedInput = {
    create?: XOR<Enumerable<UserCreateWithoutRoleInput>, Enumerable<UserUncheckedCreateWithoutRoleInput>>
    connectOrCreate?: Enumerable<UserCreateOrConnectWithoutRoleInput>
    upsert?: Enumerable<UserUpsertWithWhereUniqueWithoutRoleInput>
    createMany?: UserCreateManyRoleInputEnvelope
    set?: Enumerable<UserWhereUniqueInput>
    disconnect?: Enumerable<UserWhereUniqueInput>
    delete?: Enumerable<UserWhereUniqueInput>
    connect?: Enumerable<UserWhereUniqueInput>
    update?: Enumerable<UserUpdateWithWhereUniqueWithoutRoleInput>
    updateMany?: Enumerable<UserUpdateManyWithWhereWithoutRoleInput>
    deleteMany?: Enumerable<UserScalarWhereInput>
  }

  export type PermissionsOnRoleUncheckedUpdateManyWithoutRoleNestedInput = {
    create?: XOR<Enumerable<PermissionsOnRoleCreateWithoutRoleInput>, Enumerable<PermissionsOnRoleUncheckedCreateWithoutRoleInput>>
    connectOrCreate?: Enumerable<PermissionsOnRoleCreateOrConnectWithoutRoleInput>
    upsert?: Enumerable<PermissionsOnRoleUpsertWithWhereUniqueWithoutRoleInput>
    createMany?: PermissionsOnRoleCreateManyRoleInputEnvelope
    set?: Enumerable<PermissionsOnRoleWhereUniqueInput>
    disconnect?: Enumerable<PermissionsOnRoleWhereUniqueInput>
    delete?: Enumerable<PermissionsOnRoleWhereUniqueInput>
    connect?: Enumerable<PermissionsOnRoleWhereUniqueInput>
    update?: Enumerable<PermissionsOnRoleUpdateWithWhereUniqueWithoutRoleInput>
    updateMany?: Enumerable<PermissionsOnRoleUpdateManyWithWhereWithoutRoleInput>
    deleteMany?: Enumerable<PermissionsOnRoleScalarWhereInput>
  }

  export type UserUncheckedUpdateManyWithoutRoleNestedInput = {
    create?: XOR<Enumerable<UserCreateWithoutRoleInput>, Enumerable<UserUncheckedCreateWithoutRoleInput>>
    connectOrCreate?: Enumerable<UserCreateOrConnectWithoutRoleInput>
    upsert?: Enumerable<UserUpsertWithWhereUniqueWithoutRoleInput>
    createMany?: UserCreateManyRoleInputEnvelope
    set?: Enumerable<UserWhereUniqueInput>
    disconnect?: Enumerable<UserWhereUniqueInput>
    delete?: Enumerable<UserWhereUniqueInput>
    connect?: Enumerable<UserWhereUniqueInput>
    update?: Enumerable<UserUpdateWithWhereUniqueWithoutRoleInput>
    updateMany?: Enumerable<UserUpdateManyWithWhereWithoutRoleInput>
    deleteMany?: Enumerable<UserScalarWhereInput>
  }

  export type PermissionsOnRoleCreateNestedManyWithoutPermissionInput = {
    create?: XOR<Enumerable<PermissionsOnRoleCreateWithoutPermissionInput>, Enumerable<PermissionsOnRoleUncheckedCreateWithoutPermissionInput>>
    connectOrCreate?: Enumerable<PermissionsOnRoleCreateOrConnectWithoutPermissionInput>
    createMany?: PermissionsOnRoleCreateManyPermissionInputEnvelope
    connect?: Enumerable<PermissionsOnRoleWhereUniqueInput>
  }

  export type PermissionsOnRoleUncheckedCreateNestedManyWithoutPermissionInput = {
    create?: XOR<Enumerable<PermissionsOnRoleCreateWithoutPermissionInput>, Enumerable<PermissionsOnRoleUncheckedCreateWithoutPermissionInput>>
    connectOrCreate?: Enumerable<PermissionsOnRoleCreateOrConnectWithoutPermissionInput>
    createMany?: PermissionsOnRoleCreateManyPermissionInputEnvelope
    connect?: Enumerable<PermissionsOnRoleWhereUniqueInput>
  }

  export type PermissionsOnRoleUpdateManyWithoutPermissionNestedInput = {
    create?: XOR<Enumerable<PermissionsOnRoleCreateWithoutPermissionInput>, Enumerable<PermissionsOnRoleUncheckedCreateWithoutPermissionInput>>
    connectOrCreate?: Enumerable<PermissionsOnRoleCreateOrConnectWithoutPermissionInput>
    upsert?: Enumerable<PermissionsOnRoleUpsertWithWhereUniqueWithoutPermissionInput>
    createMany?: PermissionsOnRoleCreateManyPermissionInputEnvelope
    set?: Enumerable<PermissionsOnRoleWhereUniqueInput>
    disconnect?: Enumerable<PermissionsOnRoleWhereUniqueInput>
    delete?: Enumerable<PermissionsOnRoleWhereUniqueInput>
    connect?: Enumerable<PermissionsOnRoleWhereUniqueInput>
    update?: Enumerable<PermissionsOnRoleUpdateWithWhereUniqueWithoutPermissionInput>
    updateMany?: Enumerable<PermissionsOnRoleUpdateManyWithWhereWithoutPermissionInput>
    deleteMany?: Enumerable<PermissionsOnRoleScalarWhereInput>
  }

  export type PermissionsOnRoleUncheckedUpdateManyWithoutPermissionNestedInput = {
    create?: XOR<Enumerable<PermissionsOnRoleCreateWithoutPermissionInput>, Enumerable<PermissionsOnRoleUncheckedCreateWithoutPermissionInput>>
    connectOrCreate?: Enumerable<PermissionsOnRoleCreateOrConnectWithoutPermissionInput>
    upsert?: Enumerable<PermissionsOnRoleUpsertWithWhereUniqueWithoutPermissionInput>
    createMany?: PermissionsOnRoleCreateManyPermissionInputEnvelope
    set?: Enumerable<PermissionsOnRoleWhereUniqueInput>
    disconnect?: Enumerable<PermissionsOnRoleWhereUniqueInput>
    delete?: Enumerable<PermissionsOnRoleWhereUniqueInput>
    connect?: Enumerable<PermissionsOnRoleWhereUniqueInput>
    update?: Enumerable<PermissionsOnRoleUpdateWithWhereUniqueWithoutPermissionInput>
    updateMany?: Enumerable<PermissionsOnRoleUpdateManyWithWhereWithoutPermissionInput>
    deleteMany?: Enumerable<PermissionsOnRoleScalarWhereInput>
  }

  export type RoleCreateNestedOneWithoutPermissionsOnRoleInput = {
    create?: XOR<RoleCreateWithoutPermissionsOnRoleInput, RoleUncheckedCreateWithoutPermissionsOnRoleInput>
    connectOrCreate?: RoleCreateOrConnectWithoutPermissionsOnRoleInput
    connect?: RoleWhereUniqueInput
  }

  export type PermissionCreateNestedOneWithoutPermissionsOnRoleInput = {
    create?: XOR<PermissionCreateWithoutPermissionsOnRoleInput, PermissionUncheckedCreateWithoutPermissionsOnRoleInput>
    connectOrCreate?: PermissionCreateOrConnectWithoutPermissionsOnRoleInput
    connect?: PermissionWhereUniqueInput
  }

  export type RoleUpdateOneRequiredWithoutPermissionsOnRoleNestedInput = {
    create?: XOR<RoleCreateWithoutPermissionsOnRoleInput, RoleUncheckedCreateWithoutPermissionsOnRoleInput>
    connectOrCreate?: RoleCreateOrConnectWithoutPermissionsOnRoleInput
    upsert?: RoleUpsertWithoutPermissionsOnRoleInput
    connect?: RoleWhereUniqueInput
    update?: XOR<RoleUpdateWithoutPermissionsOnRoleInput, RoleUncheckedUpdateWithoutPermissionsOnRoleInput>
  }

  export type PermissionUpdateOneRequiredWithoutPermissionsOnRoleNestedInput = {
    create?: XOR<PermissionCreateWithoutPermissionsOnRoleInput, PermissionUncheckedCreateWithoutPermissionsOnRoleInput>
    connectOrCreate?: PermissionCreateOrConnectWithoutPermissionsOnRoleInput
    upsert?: PermissionUpsertWithoutPermissionsOnRoleInput
    connect?: PermissionWhereUniqueInput
    update?: XOR<PermissionUpdateWithoutPermissionsOnRoleInput, PermissionUncheckedUpdateWithoutPermissionsOnRoleInput>
  }

  export type UserCreateNestedOneWithoutFileInput = {
    create?: XOR<UserCreateWithoutFileInput, UserUncheckedCreateWithoutFileInput>
    connectOrCreate?: UserCreateOrConnectWithoutFileInput
    connect?: UserWhereUniqueInput
  }

  export type UserDetailCreateNestedManyWithoutFileInput = {
    create?: XOR<Enumerable<UserDetailCreateWithoutFileInput>, Enumerable<UserDetailUncheckedCreateWithoutFileInput>>
    connectOrCreate?: Enumerable<UserDetailCreateOrConnectWithoutFileInput>
    createMany?: UserDetailCreateManyFileInputEnvelope
    connect?: Enumerable<UserDetailWhereUniqueInput>
  }

  export type NotificationCreateNestedManyWithoutFileInput = {
    create?: XOR<Enumerable<NotificationCreateWithoutFileInput>, Enumerable<NotificationUncheckedCreateWithoutFileInput>>
    connectOrCreate?: Enumerable<NotificationCreateOrConnectWithoutFileInput>
    createMany?: NotificationCreateManyFileInputEnvelope
    connect?: Enumerable<NotificationWhereUniqueInput>
  }

  export type UserDetailUncheckedCreateNestedManyWithoutFileInput = {
    create?: XOR<Enumerable<UserDetailCreateWithoutFileInput>, Enumerable<UserDetailUncheckedCreateWithoutFileInput>>
    connectOrCreate?: Enumerable<UserDetailCreateOrConnectWithoutFileInput>
    createMany?: UserDetailCreateManyFileInputEnvelope
    connect?: Enumerable<UserDetailWhereUniqueInput>
  }

  export type NotificationUncheckedCreateNestedManyWithoutFileInput = {
    create?: XOR<Enumerable<NotificationCreateWithoutFileInput>, Enumerable<NotificationUncheckedCreateWithoutFileInput>>
    connectOrCreate?: Enumerable<NotificationCreateOrConnectWithoutFileInput>
    createMany?: NotificationCreateManyFileInputEnvelope
    connect?: Enumerable<NotificationWhereUniqueInput>
  }

  export type EnumFileTypeFieldUpdateOperationsInput = {
    set?: FileType
  }

  export type UserUpdateOneRequiredWithoutFileNestedInput = {
    create?: XOR<UserCreateWithoutFileInput, UserUncheckedCreateWithoutFileInput>
    connectOrCreate?: UserCreateOrConnectWithoutFileInput
    upsert?: UserUpsertWithoutFileInput
    connect?: UserWhereUniqueInput
    update?: XOR<UserUpdateWithoutFileInput, UserUncheckedUpdateWithoutFileInput>
  }

  export type UserDetailUpdateManyWithoutFileNestedInput = {
    create?: XOR<Enumerable<UserDetailCreateWithoutFileInput>, Enumerable<UserDetailUncheckedCreateWithoutFileInput>>
    connectOrCreate?: Enumerable<UserDetailCreateOrConnectWithoutFileInput>
    upsert?: Enumerable<UserDetailUpsertWithWhereUniqueWithoutFileInput>
    createMany?: UserDetailCreateManyFileInputEnvelope
    set?: Enumerable<UserDetailWhereUniqueInput>
    disconnect?: Enumerable<UserDetailWhereUniqueInput>
    delete?: Enumerable<UserDetailWhereUniqueInput>
    connect?: Enumerable<UserDetailWhereUniqueInput>
    update?: Enumerable<UserDetailUpdateWithWhereUniqueWithoutFileInput>
    updateMany?: Enumerable<UserDetailUpdateManyWithWhereWithoutFileInput>
    deleteMany?: Enumerable<UserDetailScalarWhereInput>
  }

  export type NotificationUpdateManyWithoutFileNestedInput = {
    create?: XOR<Enumerable<NotificationCreateWithoutFileInput>, Enumerable<NotificationUncheckedCreateWithoutFileInput>>
    connectOrCreate?: Enumerable<NotificationCreateOrConnectWithoutFileInput>
    upsert?: Enumerable<NotificationUpsertWithWhereUniqueWithoutFileInput>
    createMany?: NotificationCreateManyFileInputEnvelope
    set?: Enumerable<NotificationWhereUniqueInput>
    disconnect?: Enumerable<NotificationWhereUniqueInput>
    delete?: Enumerable<NotificationWhereUniqueInput>
    connect?: Enumerable<NotificationWhereUniqueInput>
    update?: Enumerable<NotificationUpdateWithWhereUniqueWithoutFileInput>
    updateMany?: Enumerable<NotificationUpdateManyWithWhereWithoutFileInput>
    deleteMany?: Enumerable<NotificationScalarWhereInput>
  }

  export type UserDetailUncheckedUpdateManyWithoutFileNestedInput = {
    create?: XOR<Enumerable<UserDetailCreateWithoutFileInput>, Enumerable<UserDetailUncheckedCreateWithoutFileInput>>
    connectOrCreate?: Enumerable<UserDetailCreateOrConnectWithoutFileInput>
    upsert?: Enumerable<UserDetailUpsertWithWhereUniqueWithoutFileInput>
    createMany?: UserDetailCreateManyFileInputEnvelope
    set?: Enumerable<UserDetailWhereUniqueInput>
    disconnect?: Enumerable<UserDetailWhereUniqueInput>
    delete?: Enumerable<UserDetailWhereUniqueInput>
    connect?: Enumerable<UserDetailWhereUniqueInput>
    update?: Enumerable<UserDetailUpdateWithWhereUniqueWithoutFileInput>
    updateMany?: Enumerable<UserDetailUpdateManyWithWhereWithoutFileInput>
    deleteMany?: Enumerable<UserDetailScalarWhereInput>
  }

  export type NotificationUncheckedUpdateManyWithoutFileNestedInput = {
    create?: XOR<Enumerable<NotificationCreateWithoutFileInput>, Enumerable<NotificationUncheckedCreateWithoutFileInput>>
    connectOrCreate?: Enumerable<NotificationCreateOrConnectWithoutFileInput>
    upsert?: Enumerable<NotificationUpsertWithWhereUniqueWithoutFileInput>
    createMany?: NotificationCreateManyFileInputEnvelope
    set?: Enumerable<NotificationWhereUniqueInput>
    disconnect?: Enumerable<NotificationWhereUniqueInput>
    delete?: Enumerable<NotificationWhereUniqueInput>
    connect?: Enumerable<NotificationWhereUniqueInput>
    update?: Enumerable<NotificationUpdateWithWhereUniqueWithoutFileInput>
    updateMany?: Enumerable<NotificationUpdateManyWithWhereWithoutFileInput>
    deleteMany?: Enumerable<NotificationScalarWhereInput>
  }

  export type UserCreateNestedOneWithoutInoutInput = {
    create?: XOR<UserCreateWithoutInoutInput, UserUncheckedCreateWithoutInoutInput>
    connectOrCreate?: UserCreateOrConnectWithoutInoutInput
    connect?: UserWhereUniqueInput
  }

  export type Inout_logsCreateNestedManyWithoutInoutInput = {
    create?: XOR<Enumerable<Inout_logsCreateWithoutInoutInput>, Enumerable<Inout_logsUncheckedCreateWithoutInoutInput>>
    connectOrCreate?: Enumerable<Inout_logsCreateOrConnectWithoutInoutInput>
    createMany?: Inout_logsCreateManyInoutInputEnvelope
    connect?: Enumerable<Inout_logsWhereUniqueInput>
  }

  export type Inout_logsUncheckedCreateNestedManyWithoutInoutInput = {
    create?: XOR<Enumerable<Inout_logsCreateWithoutInoutInput>, Enumerable<Inout_logsUncheckedCreateWithoutInoutInput>>
    connectOrCreate?: Enumerable<Inout_logsCreateOrConnectWithoutInoutInput>
    createMany?: Inout_logsCreateManyInoutInputEnvelope
    connect?: Enumerable<Inout_logsWhereUniqueInput>
  }

  export type EnumInoutTypeFieldUpdateOperationsInput = {
    set?: InoutType
  }

  export type BoolFieldUpdateOperationsInput = {
    set?: boolean
  }

  export type UserUpdateOneRequiredWithoutInoutNestedInput = {
    create?: XOR<UserCreateWithoutInoutInput, UserUncheckedCreateWithoutInoutInput>
    connectOrCreate?: UserCreateOrConnectWithoutInoutInput
    upsert?: UserUpsertWithoutInoutInput
    connect?: UserWhereUniqueInput
    update?: XOR<UserUpdateWithoutInoutInput, UserUncheckedUpdateWithoutInoutInput>
  }

  export type Inout_logsUpdateManyWithoutInoutNestedInput = {
    create?: XOR<Enumerable<Inout_logsCreateWithoutInoutInput>, Enumerable<Inout_logsUncheckedCreateWithoutInoutInput>>
    connectOrCreate?: Enumerable<Inout_logsCreateOrConnectWithoutInoutInput>
    upsert?: Enumerable<Inout_logsUpsertWithWhereUniqueWithoutInoutInput>
    createMany?: Inout_logsCreateManyInoutInputEnvelope
    set?: Enumerable<Inout_logsWhereUniqueInput>
    disconnect?: Enumerable<Inout_logsWhereUniqueInput>
    delete?: Enumerable<Inout_logsWhereUniqueInput>
    connect?: Enumerable<Inout_logsWhereUniqueInput>
    update?: Enumerable<Inout_logsUpdateWithWhereUniqueWithoutInoutInput>
    updateMany?: Enumerable<Inout_logsUpdateManyWithWhereWithoutInoutInput>
    deleteMany?: Enumerable<Inout_logsScalarWhereInput>
  }

  export type Inout_logsUncheckedUpdateManyWithoutInoutNestedInput = {
    create?: XOR<Enumerable<Inout_logsCreateWithoutInoutInput>, Enumerable<Inout_logsUncheckedCreateWithoutInoutInput>>
    connectOrCreate?: Enumerable<Inout_logsCreateOrConnectWithoutInoutInput>
    upsert?: Enumerable<Inout_logsUpsertWithWhereUniqueWithoutInoutInput>
    createMany?: Inout_logsCreateManyInoutInputEnvelope
    set?: Enumerable<Inout_logsWhereUniqueInput>
    disconnect?: Enumerable<Inout_logsWhereUniqueInput>
    delete?: Enumerable<Inout_logsWhereUniqueInput>
    connect?: Enumerable<Inout_logsWhereUniqueInput>
    update?: Enumerable<Inout_logsUpdateWithWhereUniqueWithoutInoutInput>
    updateMany?: Enumerable<Inout_logsUpdateManyWithWhereWithoutInoutInput>
    deleteMany?: Enumerable<Inout_logsScalarWhereInput>
  }

  export type InoutCreateNestedOneWithoutInout_logsInput = {
    create?: XOR<InoutCreateWithoutInout_logsInput, InoutUncheckedCreateWithoutInout_logsInput>
    connectOrCreate?: InoutCreateOrConnectWithoutInout_logsInput
    connect?: InoutWhereUniqueInput
  }

  export type EnumLog_ActionFieldUpdateOperationsInput = {
    set?: Log_Action
  }

  export type NullableDateTimeFieldUpdateOperationsInput = {
    set?: Date | string | null
  }

  export type InoutUpdateOneRequiredWithoutInout_logsNestedInput = {
    create?: XOR<InoutCreateWithoutInout_logsInput, InoutUncheckedCreateWithoutInout_logsInput>
    connectOrCreate?: InoutCreateOrConnectWithoutInout_logsInput
    upsert?: InoutUpsertWithoutInout_logsInput
    connect?: InoutWhereUniqueInput
    update?: XOR<InoutUpdateWithoutInout_logsInput, InoutUncheckedUpdateWithoutInout_logsInput>
  }

  export type FileCreateNestedOneWithoutNotificationInput = {
    create?: XOR<FileCreateWithoutNotificationInput, FileUncheckedCreateWithoutNotificationInput>
    connectOrCreate?: FileCreateOrConnectWithoutNotificationInput
    connect?: FileWhereUniqueInput
  }

  export type UserCreateNestedOneWithoutNotificationInput = {
    create?: XOR<UserCreateWithoutNotificationInput, UserUncheckedCreateWithoutNotificationInput>
    connectOrCreate?: UserCreateOrConnectWithoutNotificationInput
    connect?: UserWhereUniqueInput
  }

  export type Notification_ReceiverCreateNestedManyWithoutNotificationInput = {
    create?: XOR<Enumerable<Notification_ReceiverCreateWithoutNotificationInput>, Enumerable<Notification_ReceiverUncheckedCreateWithoutNotificationInput>>
    connectOrCreate?: Enumerable<Notification_ReceiverCreateOrConnectWithoutNotificationInput>
    createMany?: Notification_ReceiverCreateManyNotificationInputEnvelope
    connect?: Enumerable<Notification_ReceiverWhereUniqueInput>
  }

  export type Notification_ReceiverUncheckedCreateNestedManyWithoutNotificationInput = {
    create?: XOR<Enumerable<Notification_ReceiverCreateWithoutNotificationInput>, Enumerable<Notification_ReceiverUncheckedCreateWithoutNotificationInput>>
    connectOrCreate?: Enumerable<Notification_ReceiverCreateOrConnectWithoutNotificationInput>
    createMany?: Notification_ReceiverCreateManyNotificationInputEnvelope
    connect?: Enumerable<Notification_ReceiverWhereUniqueInput>
  }

  export type FileUpdateOneWithoutNotificationNestedInput = {
    create?: XOR<FileCreateWithoutNotificationInput, FileUncheckedCreateWithoutNotificationInput>
    connectOrCreate?: FileCreateOrConnectWithoutNotificationInput
    upsert?: FileUpsertWithoutNotificationInput
    disconnect?: boolean
    delete?: boolean
    connect?: FileWhereUniqueInput
    update?: XOR<FileUpdateWithoutNotificationInput, FileUncheckedUpdateWithoutNotificationInput>
  }

  export type UserUpdateOneRequiredWithoutNotificationNestedInput = {
    create?: XOR<UserCreateWithoutNotificationInput, UserUncheckedCreateWithoutNotificationInput>
    connectOrCreate?: UserCreateOrConnectWithoutNotificationInput
    upsert?: UserUpsertWithoutNotificationInput
    connect?: UserWhereUniqueInput
    update?: XOR<UserUpdateWithoutNotificationInput, UserUncheckedUpdateWithoutNotificationInput>
  }

  export type Notification_ReceiverUpdateManyWithoutNotificationNestedInput = {
    create?: XOR<Enumerable<Notification_ReceiverCreateWithoutNotificationInput>, Enumerable<Notification_ReceiverUncheckedCreateWithoutNotificationInput>>
    connectOrCreate?: Enumerable<Notification_ReceiverCreateOrConnectWithoutNotificationInput>
    upsert?: Enumerable<Notification_ReceiverUpsertWithWhereUniqueWithoutNotificationInput>
    createMany?: Notification_ReceiverCreateManyNotificationInputEnvelope
    set?: Enumerable<Notification_ReceiverWhereUniqueInput>
    disconnect?: Enumerable<Notification_ReceiverWhereUniqueInput>
    delete?: Enumerable<Notification_ReceiverWhereUniqueInput>
    connect?: Enumerable<Notification_ReceiverWhereUniqueInput>
    update?: Enumerable<Notification_ReceiverUpdateWithWhereUniqueWithoutNotificationInput>
    updateMany?: Enumerable<Notification_ReceiverUpdateManyWithWhereWithoutNotificationInput>
    deleteMany?: Enumerable<Notification_ReceiverScalarWhereInput>
  }

  export type Notification_ReceiverUncheckedUpdateManyWithoutNotificationNestedInput = {
    create?: XOR<Enumerable<Notification_ReceiverCreateWithoutNotificationInput>, Enumerable<Notification_ReceiverUncheckedCreateWithoutNotificationInput>>
    connectOrCreate?: Enumerable<Notification_ReceiverCreateOrConnectWithoutNotificationInput>
    upsert?: Enumerable<Notification_ReceiverUpsertWithWhereUniqueWithoutNotificationInput>
    createMany?: Notification_ReceiverCreateManyNotificationInputEnvelope
    set?: Enumerable<Notification_ReceiverWhereUniqueInput>
    disconnect?: Enumerable<Notification_ReceiverWhereUniqueInput>
    delete?: Enumerable<Notification_ReceiverWhereUniqueInput>
    connect?: Enumerable<Notification_ReceiverWhereUniqueInput>
    update?: Enumerable<Notification_ReceiverUpdateWithWhereUniqueWithoutNotificationInput>
    updateMany?: Enumerable<Notification_ReceiverUpdateManyWithWhereWithoutNotificationInput>
    deleteMany?: Enumerable<Notification_ReceiverScalarWhereInput>
  }

  export type NotificationCreateNestedOneWithoutNotification_ReceiverInput = {
    create?: XOR<NotificationCreateWithoutNotification_ReceiverInput, NotificationUncheckedCreateWithoutNotification_ReceiverInput>
    connectOrCreate?: NotificationCreateOrConnectWithoutNotification_ReceiverInput
    connect?: NotificationWhereUniqueInput
  }

  export type UserCreateNestedOneWithoutNotification_ReceiverInput = {
    create?: XOR<UserCreateWithoutNotification_ReceiverInput, UserUncheckedCreateWithoutNotification_ReceiverInput>
    connectOrCreate?: UserCreateOrConnectWithoutNotification_ReceiverInput
    connect?: UserWhereUniqueInput
  }

  export type NotificationUpdateOneRequiredWithoutNotification_ReceiverNestedInput = {
    create?: XOR<NotificationCreateWithoutNotification_ReceiverInput, NotificationUncheckedCreateWithoutNotification_ReceiverInput>
    connectOrCreate?: NotificationCreateOrConnectWithoutNotification_ReceiverInput
    upsert?: NotificationUpsertWithoutNotification_ReceiverInput
    connect?: NotificationWhereUniqueInput
    update?: XOR<NotificationUpdateWithoutNotification_ReceiverInput, NotificationUncheckedUpdateWithoutNotification_ReceiverInput>
  }

  export type UserUpdateOneRequiredWithoutNotification_ReceiverNestedInput = {
    create?: XOR<UserCreateWithoutNotification_ReceiverInput, UserUncheckedCreateWithoutNotification_ReceiverInput>
    connectOrCreate?: UserCreateOrConnectWithoutNotification_ReceiverInput
    upsert?: UserUpsertWithoutNotification_ReceiverInput
    connect?: UserWhereUniqueInput
    update?: XOR<UserUpdateWithoutNotification_ReceiverInput, UserUncheckedUpdateWithoutNotification_ReceiverInput>
  }

  export type UserCreateNestedOneWithoutVacationInput = {
    create?: XOR<UserCreateWithoutVacationInput, UserUncheckedCreateWithoutVacationInput>
    connectOrCreate?: UserCreateOrConnectWithoutVacationInput
    connect?: UserWhereUniqueInput
  }

  export type EnumVacation_TypeFieldUpdateOperationsInput = {
    set?: Vacation_Type
  }

  export type EnumVacation_StatusFieldUpdateOperationsInput = {
    set?: Vacation_Status
  }

  export type UserUpdateOneRequiredWithoutVacationNestedInput = {
    create?: XOR<UserCreateWithoutVacationInput, UserUncheckedCreateWithoutVacationInput>
    connectOrCreate?: UserCreateOrConnectWithoutVacationInput
    upsert?: UserUpsertWithoutVacationInput
    connect?: UserWhereUniqueInput
    update?: XOR<UserUpdateWithoutVacationInput, UserUncheckedUpdateWithoutVacationInput>
  }

  export type NestedStringFilter = {
    equals?: string
    in?: Enumerable<string>
    notIn?: Enumerable<string>
    lt?: string
    lte?: string
    gt?: string
    gte?: string
    contains?: string
    startsWith?: string
    endsWith?: string
    not?: NestedStringFilter | string
  }

  export type NestedStringNullableFilter = {
    equals?: string | null
    in?: Enumerable<string> | null
    notIn?: Enumerable<string> | null
    lt?: string
    lte?: string
    gt?: string
    gte?: string
    contains?: string
    startsWith?: string
    endsWith?: string
    not?: NestedStringNullableFilter | string | null
  }

  export type NestedEnumUserStatusFilter = {
    equals?: UserStatus
    in?: Enumerable<UserStatus>
    notIn?: Enumerable<UserStatus>
    not?: NestedEnumUserStatusFilter | UserStatus
  }

  export type NestedDateTimeFilter = {
    equals?: Date | string
    in?: Enumerable<Date> | Enumerable<string>
    notIn?: Enumerable<Date> | Enumerable<string>
    lt?: Date | string
    lte?: Date | string
    gt?: Date | string
    gte?: Date | string
    not?: NestedDateTimeFilter | Date | string
  }

  export type NestedStringWithAggregatesFilter = {
    equals?: string
    in?: Enumerable<string>
    notIn?: Enumerable<string>
    lt?: string
    lte?: string
    gt?: string
    gte?: string
    contains?: string
    startsWith?: string
    endsWith?: string
    not?: NestedStringWithAggregatesFilter | string
    _count?: NestedIntFilter
    _min?: NestedStringFilter
    _max?: NestedStringFilter
  }

  export type NestedIntFilter = {
    equals?: number
    in?: Enumerable<number>
    notIn?: Enumerable<number>
    lt?: number
    lte?: number
    gt?: number
    gte?: number
    not?: NestedIntFilter | number
  }

  export type NestedStringNullableWithAggregatesFilter = {
    equals?: string | null
    in?: Enumerable<string> | null
    notIn?: Enumerable<string> | null
    lt?: string
    lte?: string
    gt?: string
    gte?: string
    contains?: string
    startsWith?: string
    endsWith?: string
    not?: NestedStringNullableWithAggregatesFilter | string | null
    _count?: NestedIntNullableFilter
    _min?: NestedStringNullableFilter
    _max?: NestedStringNullableFilter
  }

  export type NestedIntNullableFilter = {
    equals?: number | null
    in?: Enumerable<number> | null
    notIn?: Enumerable<number> | null
    lt?: number
    lte?: number
    gt?: number
    gte?: number
    not?: NestedIntNullableFilter | number | null
  }

  export type NestedEnumUserStatusWithAggregatesFilter = {
    equals?: UserStatus
    in?: Enumerable<UserStatus>
    notIn?: Enumerable<UserStatus>
    not?: NestedEnumUserStatusWithAggregatesFilter | UserStatus
    _count?: NestedIntFilter
    _min?: NestedEnumUserStatusFilter
    _max?: NestedEnumUserStatusFilter
  }

  export type NestedDateTimeWithAggregatesFilter = {
    equals?: Date | string
    in?: Enumerable<Date> | Enumerable<string>
    notIn?: Enumerable<Date> | Enumerable<string>
    lt?: Date | string
    lte?: Date | string
    gt?: Date | string
    gte?: Date | string
    not?: NestedDateTimeWithAggregatesFilter | Date | string
    _count?: NestedIntFilter
    _min?: NestedDateTimeFilter
    _max?: NestedDateTimeFilter
  }

  export type NestedIntNullableWithAggregatesFilter = {
    equals?: number | null
    in?: Enumerable<number> | null
    notIn?: Enumerable<number> | null
    lt?: number
    lte?: number
    gt?: number
    gte?: number
    not?: NestedIntNullableWithAggregatesFilter | number | null
    _count?: NestedIntNullableFilter
    _avg?: NestedFloatNullableFilter
    _sum?: NestedIntNullableFilter
    _min?: NestedIntNullableFilter
    _max?: NestedIntNullableFilter
  }

  export type NestedFloatNullableFilter = {
    equals?: number | null
    in?: Enumerable<number> | null
    notIn?: Enumerable<number> | null
    lt?: number
    lte?: number
    gt?: number
    gte?: number
    not?: NestedFloatNullableFilter | number | null
  }

  export type NestedIntWithAggregatesFilter = {
    equals?: number
    in?: Enumerable<number>
    notIn?: Enumerable<number>
    lt?: number
    lte?: number
    gt?: number
    gte?: number
    not?: NestedIntWithAggregatesFilter | number
    _count?: NestedIntFilter
    _avg?: NestedFloatFilter
    _sum?: NestedIntFilter
    _min?: NestedIntFilter
    _max?: NestedIntFilter
  }

  export type NestedFloatFilter = {
    equals?: number
    in?: Enumerable<number>
    notIn?: Enumerable<number>
    lt?: number
    lte?: number
    gt?: number
    gte?: number
    not?: NestedFloatFilter | number
  }

  export type NestedEnumFileTypeFilter = {
    equals?: FileType
    in?: Enumerable<FileType>
    notIn?: Enumerable<FileType>
    not?: NestedEnumFileTypeFilter | FileType
  }

  export type NestedEnumFileTypeWithAggregatesFilter = {
    equals?: FileType
    in?: Enumerable<FileType>
    notIn?: Enumerable<FileType>
    not?: NestedEnumFileTypeWithAggregatesFilter | FileType
    _count?: NestedIntFilter
    _min?: NestedEnumFileTypeFilter
    _max?: NestedEnumFileTypeFilter
  }

  export type NestedEnumInoutTypeFilter = {
    equals?: InoutType
    in?: Enumerable<InoutType>
    notIn?: Enumerable<InoutType>
    not?: NestedEnumInoutTypeFilter | InoutType
  }

  export type NestedBoolFilter = {
    equals?: boolean
    not?: NestedBoolFilter | boolean
  }

  export type NestedEnumInoutTypeWithAggregatesFilter = {
    equals?: InoutType
    in?: Enumerable<InoutType>
    notIn?: Enumerable<InoutType>
    not?: NestedEnumInoutTypeWithAggregatesFilter | InoutType
    _count?: NestedIntFilter
    _min?: NestedEnumInoutTypeFilter
    _max?: NestedEnumInoutTypeFilter
  }

  export type NestedBoolWithAggregatesFilter = {
    equals?: boolean
    not?: NestedBoolWithAggregatesFilter | boolean
    _count?: NestedIntFilter
    _min?: NestedBoolFilter
    _max?: NestedBoolFilter
  }

  export type NestedEnumLog_ActionFilter = {
    equals?: Log_Action
    in?: Enumerable<Log_Action>
    notIn?: Enumerable<Log_Action>
    not?: NestedEnumLog_ActionFilter | Log_Action
  }

  export type NestedDateTimeNullableFilter = {
    equals?: Date | string | null
    in?: Enumerable<Date> | Enumerable<string> | null
    notIn?: Enumerable<Date> | Enumerable<string> | null
    lt?: Date | string
    lte?: Date | string
    gt?: Date | string
    gte?: Date | string
    not?: NestedDateTimeNullableFilter | Date | string | null
  }

  export type NestedEnumLog_ActionWithAggregatesFilter = {
    equals?: Log_Action
    in?: Enumerable<Log_Action>
    notIn?: Enumerable<Log_Action>
    not?: NestedEnumLog_ActionWithAggregatesFilter | Log_Action
    _count?: NestedIntFilter
    _min?: NestedEnumLog_ActionFilter
    _max?: NestedEnumLog_ActionFilter
  }

  export type NestedDateTimeNullableWithAggregatesFilter = {
    equals?: Date | string | null
    in?: Enumerable<Date> | Enumerable<string> | null
    notIn?: Enumerable<Date> | Enumerable<string> | null
    lt?: Date | string
    lte?: Date | string
    gt?: Date | string
    gte?: Date | string
    not?: NestedDateTimeNullableWithAggregatesFilter | Date | string | null
    _count?: NestedIntNullableFilter
    _min?: NestedDateTimeNullableFilter
    _max?: NestedDateTimeNullableFilter
  }

  export type NestedEnumVacation_TypeFilter = {
    equals?: Vacation_Type
    in?: Enumerable<Vacation_Type>
    notIn?: Enumerable<Vacation_Type>
    not?: NestedEnumVacation_TypeFilter | Vacation_Type
  }

  export type NestedEnumVacation_StatusFilter = {
    equals?: Vacation_Status
    in?: Enumerable<Vacation_Status>
    notIn?: Enumerable<Vacation_Status>
    not?: NestedEnumVacation_StatusFilter | Vacation_Status
  }

  export type NestedEnumVacation_TypeWithAggregatesFilter = {
    equals?: Vacation_Type
    in?: Enumerable<Vacation_Type>
    notIn?: Enumerable<Vacation_Type>
    not?: NestedEnumVacation_TypeWithAggregatesFilter | Vacation_Type
    _count?: NestedIntFilter
    _min?: NestedEnumVacation_TypeFilter
    _max?: NestedEnumVacation_TypeFilter
  }

  export type NestedEnumVacation_StatusWithAggregatesFilter = {
    equals?: Vacation_Status
    in?: Enumerable<Vacation_Status>
    notIn?: Enumerable<Vacation_Status>
    not?: NestedEnumVacation_StatusWithAggregatesFilter | Vacation_Status
    _count?: NestedIntFilter
    _min?: NestedEnumVacation_StatusFilter
    _max?: NestedEnumVacation_StatusFilter
  }

  export type UserDetailCreateWithoutUserInput = {
    id?: string
    first_name?: string | null
    last_name?: string | null
    personal_code?: number | null
    delay_time?: string | null
    delay_ratio?: number | null
    vacation_remained?: number
    createdAt?: Date | string
    updatedAt?: Date | string
    file?: FileCreateNestedOneWithoutUserDetailInput
    manager?: UserCreateNestedOneWithoutUserManagerInput
  }

  export type UserDetailUncheckedCreateWithoutUserInput = {
    id?: string
    first_name?: string | null
    last_name?: string | null
    personal_code?: number | null
    featured_image?: string | null
    delay_time?: string | null
    delay_ratio?: number | null
    manager_id?: string | null
    vacation_remained?: number
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type UserDetailCreateOrConnectWithoutUserInput = {
    where: UserDetailWhereUniqueInput
    create: XOR<UserDetailCreateWithoutUserInput, UserDetailUncheckedCreateWithoutUserInput>
  }

  export type UserDetailCreateWithoutManagerInput = {
    id?: string
    first_name?: string | null
    last_name?: string | null
    personal_code?: number | null
    delay_time?: string | null
    delay_ratio?: number | null
    vacation_remained?: number
    createdAt?: Date | string
    updatedAt?: Date | string
    file?: FileCreateNestedOneWithoutUserDetailInput
    user: UserCreateNestedOneWithoutUserDetailInput
  }

  export type UserDetailUncheckedCreateWithoutManagerInput = {
    id?: string
    user_id: string
    first_name?: string | null
    last_name?: string | null
    personal_code?: number | null
    featured_image?: string | null
    delay_time?: string | null
    delay_ratio?: number | null
    vacation_remained?: number
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type UserDetailCreateOrConnectWithoutManagerInput = {
    where: UserDetailWhereUniqueInput
    create: XOR<UserDetailCreateWithoutManagerInput, UserDetailUncheckedCreateWithoutManagerInput>
  }

  export type UserDetailCreateManyManagerInputEnvelope = {
    data: Enumerable<UserDetailCreateManyManagerInput>
    skipDuplicates?: boolean
  }

  export type RoleCreateWithoutUserInput = {
    id?: string
    name: string
    description?: string | null
    PermissionsOnRole?: PermissionsOnRoleCreateNestedManyWithoutRoleInput
  }

  export type RoleUncheckedCreateWithoutUserInput = {
    id?: string
    name: string
    description?: string | null
    PermissionsOnRole?: PermissionsOnRoleUncheckedCreateNestedManyWithoutRoleInput
  }

  export type RoleCreateOrConnectWithoutUserInput = {
    where: RoleWhereUniqueInput
    create: XOR<RoleCreateWithoutUserInput, RoleUncheckedCreateWithoutUserInput>
  }

  export type ResetPassowrdCreateWithoutUserInput = {
    token: string
    createdAt?: Date | string
  }

  export type ResetPassowrdUncheckedCreateWithoutUserInput = {
    token: string
    createdAt?: Date | string
  }

  export type ResetPassowrdCreateOrConnectWithoutUserInput = {
    where: ResetPassowrdWhereUniqueInput
    create: XOR<ResetPassowrdCreateWithoutUserInput, ResetPassowrdUncheckedCreateWithoutUserInput>
  }

  export type InoutCreateWithoutUserInput = {
    id?: string
    time: Date | string
    type?: InoutType
    delete?: boolean
    description?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
    approved?: boolean
    Inout_logs?: Inout_logsCreateNestedManyWithoutInoutInput
  }

  export type InoutUncheckedCreateWithoutUserInput = {
    id?: string
    time: Date | string
    type?: InoutType
    delete?: boolean
    description?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
    approved?: boolean
    Inout_logs?: Inout_logsUncheckedCreateNestedManyWithoutInoutInput
  }

  export type InoutCreateOrConnectWithoutUserInput = {
    where: InoutWhereUniqueInput
    create: XOR<InoutCreateWithoutUserInput, InoutUncheckedCreateWithoutUserInput>
  }

  export type InoutCreateManyUserInputEnvelope = {
    data: Enumerable<InoutCreateManyUserInput>
    skipDuplicates?: boolean
  }

  export type FileCreateWithoutUserInput = {
    id?: string
    path: string
    type: FileType
    size: number
    alt?: string | null
    mimetype: string
    createdAt?: Date | string
    updatedAt?: Date | string
    UserDetail?: UserDetailCreateNestedManyWithoutFileInput
    Notification?: NotificationCreateNestedManyWithoutFileInput
  }

  export type FileUncheckedCreateWithoutUserInput = {
    id?: string
    path: string
    type: FileType
    size: number
    alt?: string | null
    mimetype: string
    createdAt?: Date | string
    updatedAt?: Date | string
    UserDetail?: UserDetailUncheckedCreateNestedManyWithoutFileInput
    Notification?: NotificationUncheckedCreateNestedManyWithoutFileInput
  }

  export type FileCreateOrConnectWithoutUserInput = {
    where: FileWhereUniqueInput
    create: XOR<FileCreateWithoutUserInput, FileUncheckedCreateWithoutUserInput>
  }

  export type FileCreateManyUserInputEnvelope = {
    data: Enumerable<FileCreateManyUserInput>
    skipDuplicates?: boolean
  }

  export type NotificationCreateWithoutAuthorInput = {
    id?: string
    title: string
    content: string
    createdAt?: Date | string
    file?: FileCreateNestedOneWithoutNotificationInput
    Notification_Receiver?: Notification_ReceiverCreateNestedManyWithoutNotificationInput
  }

  export type NotificationUncheckedCreateWithoutAuthorInput = {
    id?: string
    title: string
    content: string
    file_id?: string | null
    createdAt?: Date | string
    Notification_Receiver?: Notification_ReceiverUncheckedCreateNestedManyWithoutNotificationInput
  }

  export type NotificationCreateOrConnectWithoutAuthorInput = {
    where: NotificationWhereUniqueInput
    create: XOR<NotificationCreateWithoutAuthorInput, NotificationUncheckedCreateWithoutAuthorInput>
  }

  export type NotificationCreateManyAuthorInputEnvelope = {
    data: Enumerable<NotificationCreateManyAuthorInput>
    skipDuplicates?: boolean
  }

  export type Notification_ReceiverCreateWithoutUserInput = {
    id?: string
    isRead?: boolean
    notification: NotificationCreateNestedOneWithoutNotification_ReceiverInput
  }

  export type Notification_ReceiverUncheckedCreateWithoutUserInput = {
    id?: string
    notification_id: string
    isRead?: boolean
  }

  export type Notification_ReceiverCreateOrConnectWithoutUserInput = {
    where: Notification_ReceiverWhereUniqueInput
    create: XOR<Notification_ReceiverCreateWithoutUserInput, Notification_ReceiverUncheckedCreateWithoutUserInput>
  }

  export type Notification_ReceiverCreateManyUserInputEnvelope = {
    data: Enumerable<Notification_ReceiverCreateManyUserInput>
    skipDuplicates?: boolean
  }

  export type VacationCreateWithoutUserInput = {
    id?: string
    from: Date | string
    to: Date | string
    type: Vacation_Type
    status?: Vacation_Status
    description?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type VacationUncheckedCreateWithoutUserInput = {
    id?: string
    from: Date | string
    to: Date | string
    type: Vacation_Type
    status?: Vacation_Status
    description?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type VacationCreateOrConnectWithoutUserInput = {
    where: VacationWhereUniqueInput
    create: XOR<VacationCreateWithoutUserInput, VacationUncheckedCreateWithoutUserInput>
  }

  export type VacationCreateManyUserInputEnvelope = {
    data: Enumerable<VacationCreateManyUserInput>
    skipDuplicates?: boolean
  }

  export type UserDetailUpsertWithoutUserInput = {
    update: XOR<UserDetailUpdateWithoutUserInput, UserDetailUncheckedUpdateWithoutUserInput>
    create: XOR<UserDetailCreateWithoutUserInput, UserDetailUncheckedCreateWithoutUserInput>
  }

  export type UserDetailUpdateWithoutUserInput = {
    id?: StringFieldUpdateOperationsInput | string
    first_name?: NullableStringFieldUpdateOperationsInput | string | null
    last_name?: NullableStringFieldUpdateOperationsInput | string | null
    personal_code?: NullableIntFieldUpdateOperationsInput | number | null
    delay_time?: NullableStringFieldUpdateOperationsInput | string | null
    delay_ratio?: NullableIntFieldUpdateOperationsInput | number | null
    vacation_remained?: IntFieldUpdateOperationsInput | number
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    file?: FileUpdateOneWithoutUserDetailNestedInput
    manager?: UserUpdateOneWithoutUserManagerNestedInput
  }

  export type UserDetailUncheckedUpdateWithoutUserInput = {
    id?: StringFieldUpdateOperationsInput | string
    first_name?: NullableStringFieldUpdateOperationsInput | string | null
    last_name?: NullableStringFieldUpdateOperationsInput | string | null
    personal_code?: NullableIntFieldUpdateOperationsInput | number | null
    featured_image?: NullableStringFieldUpdateOperationsInput | string | null
    delay_time?: NullableStringFieldUpdateOperationsInput | string | null
    delay_ratio?: NullableIntFieldUpdateOperationsInput | number | null
    manager_id?: NullableStringFieldUpdateOperationsInput | string | null
    vacation_remained?: IntFieldUpdateOperationsInput | number
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type UserDetailUpsertWithWhereUniqueWithoutManagerInput = {
    where: UserDetailWhereUniqueInput
    update: XOR<UserDetailUpdateWithoutManagerInput, UserDetailUncheckedUpdateWithoutManagerInput>
    create: XOR<UserDetailCreateWithoutManagerInput, UserDetailUncheckedCreateWithoutManagerInput>
  }

  export type UserDetailUpdateWithWhereUniqueWithoutManagerInput = {
    where: UserDetailWhereUniqueInput
    data: XOR<UserDetailUpdateWithoutManagerInput, UserDetailUncheckedUpdateWithoutManagerInput>
  }

  export type UserDetailUpdateManyWithWhereWithoutManagerInput = {
    where: UserDetailScalarWhereInput
    data: XOR<UserDetailUpdateManyMutationInput, UserDetailUncheckedUpdateManyWithoutUserManagerInput>
  }

  export type UserDetailScalarWhereInput = {
    AND?: Enumerable<UserDetailScalarWhereInput>
    OR?: Enumerable<UserDetailScalarWhereInput>
    NOT?: Enumerable<UserDetailScalarWhereInput>
    id?: StringFilter | string
    user_id?: StringFilter | string
    first_name?: StringNullableFilter | string | null
    last_name?: StringNullableFilter | string | null
    personal_code?: IntNullableFilter | number | null
    featured_image?: StringNullableFilter | string | null
    delay_time?: StringNullableFilter | string | null
    delay_ratio?: IntNullableFilter | number | null
    manager_id?: StringNullableFilter | string | null
    vacation_remained?: IntFilter | number
    createdAt?: DateTimeFilter | Date | string
    updatedAt?: DateTimeFilter | Date | string
  }

  export type RoleUpsertWithoutUserInput = {
    update: XOR<RoleUpdateWithoutUserInput, RoleUncheckedUpdateWithoutUserInput>
    create: XOR<RoleCreateWithoutUserInput, RoleUncheckedCreateWithoutUserInput>
  }

  export type RoleUpdateWithoutUserInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    PermissionsOnRole?: PermissionsOnRoleUpdateManyWithoutRoleNestedInput
  }

  export type RoleUncheckedUpdateWithoutUserInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    PermissionsOnRole?: PermissionsOnRoleUncheckedUpdateManyWithoutRoleNestedInput
  }

  export type ResetPassowrdUpsertWithoutUserInput = {
    update: XOR<ResetPassowrdUpdateWithoutUserInput, ResetPassowrdUncheckedUpdateWithoutUserInput>
    create: XOR<ResetPassowrdCreateWithoutUserInput, ResetPassowrdUncheckedCreateWithoutUserInput>
  }

  export type ResetPassowrdUpdateWithoutUserInput = {
    token?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type ResetPassowrdUncheckedUpdateWithoutUserInput = {
    token?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type InoutUpsertWithWhereUniqueWithoutUserInput = {
    where: InoutWhereUniqueInput
    update: XOR<InoutUpdateWithoutUserInput, InoutUncheckedUpdateWithoutUserInput>
    create: XOR<InoutCreateWithoutUserInput, InoutUncheckedCreateWithoutUserInput>
  }

  export type InoutUpdateWithWhereUniqueWithoutUserInput = {
    where: InoutWhereUniqueInput
    data: XOR<InoutUpdateWithoutUserInput, InoutUncheckedUpdateWithoutUserInput>
  }

  export type InoutUpdateManyWithWhereWithoutUserInput = {
    where: InoutScalarWhereInput
    data: XOR<InoutUpdateManyMutationInput, InoutUncheckedUpdateManyWithoutInoutInput>
  }

  export type InoutScalarWhereInput = {
    AND?: Enumerable<InoutScalarWhereInput>
    OR?: Enumerable<InoutScalarWhereInput>
    NOT?: Enumerable<InoutScalarWhereInput>
    id?: StringFilter | string
    user_id?: StringFilter | string
    time?: DateTimeFilter | Date | string
    type?: EnumInoutTypeFilter | InoutType
    delete?: BoolFilter | boolean
    description?: StringNullableFilter | string | null
    createdAt?: DateTimeFilter | Date | string
    updatedAt?: DateTimeFilter | Date | string
    approved?: BoolFilter | boolean
  }

  export type FileUpsertWithWhereUniqueWithoutUserInput = {
    where: FileWhereUniqueInput
    update: XOR<FileUpdateWithoutUserInput, FileUncheckedUpdateWithoutUserInput>
    create: XOR<FileCreateWithoutUserInput, FileUncheckedCreateWithoutUserInput>
  }

  export type FileUpdateWithWhereUniqueWithoutUserInput = {
    where: FileWhereUniqueInput
    data: XOR<FileUpdateWithoutUserInput, FileUncheckedUpdateWithoutUserInput>
  }

  export type FileUpdateManyWithWhereWithoutUserInput = {
    where: FileScalarWhereInput
    data: XOR<FileUpdateManyMutationInput, FileUncheckedUpdateManyWithoutFileInput>
  }

  export type FileScalarWhereInput = {
    AND?: Enumerable<FileScalarWhereInput>
    OR?: Enumerable<FileScalarWhereInput>
    NOT?: Enumerable<FileScalarWhereInput>
    id?: StringFilter | string
    path?: StringFilter | string
    type?: EnumFileTypeFilter | FileType
    author?: StringFilter | string
    size?: IntFilter | number
    alt?: StringNullableFilter | string | null
    mimetype?: StringFilter | string
    createdAt?: DateTimeFilter | Date | string
    updatedAt?: DateTimeFilter | Date | string
  }

  export type NotificationUpsertWithWhereUniqueWithoutAuthorInput = {
    where: NotificationWhereUniqueInput
    update: XOR<NotificationUpdateWithoutAuthorInput, NotificationUncheckedUpdateWithoutAuthorInput>
    create: XOR<NotificationCreateWithoutAuthorInput, NotificationUncheckedCreateWithoutAuthorInput>
  }

  export type NotificationUpdateWithWhereUniqueWithoutAuthorInput = {
    where: NotificationWhereUniqueInput
    data: XOR<NotificationUpdateWithoutAuthorInput, NotificationUncheckedUpdateWithoutAuthorInput>
  }

  export type NotificationUpdateManyWithWhereWithoutAuthorInput = {
    where: NotificationScalarWhereInput
    data: XOR<NotificationUpdateManyMutationInput, NotificationUncheckedUpdateManyWithoutNotificationInput>
  }

  export type NotificationScalarWhereInput = {
    AND?: Enumerable<NotificationScalarWhereInput>
    OR?: Enumerable<NotificationScalarWhereInput>
    NOT?: Enumerable<NotificationScalarWhereInput>
    id?: StringFilter | string
    title?: StringFilter | string
    content?: StringFilter | string
    file_id?: StringNullableFilter | string | null
    author_id?: StringFilter | string
    createdAt?: DateTimeFilter | Date | string
  }

  export type Notification_ReceiverUpsertWithWhereUniqueWithoutUserInput = {
    where: Notification_ReceiverWhereUniqueInput
    update: XOR<Notification_ReceiverUpdateWithoutUserInput, Notification_ReceiverUncheckedUpdateWithoutUserInput>
    create: XOR<Notification_ReceiverCreateWithoutUserInput, Notification_ReceiverUncheckedCreateWithoutUserInput>
  }

  export type Notification_ReceiverUpdateWithWhereUniqueWithoutUserInput = {
    where: Notification_ReceiverWhereUniqueInput
    data: XOR<Notification_ReceiverUpdateWithoutUserInput, Notification_ReceiverUncheckedUpdateWithoutUserInput>
  }

  export type Notification_ReceiverUpdateManyWithWhereWithoutUserInput = {
    where: Notification_ReceiverScalarWhereInput
    data: XOR<Notification_ReceiverUpdateManyMutationInput, Notification_ReceiverUncheckedUpdateManyWithoutNotification_ReceiverInput>
  }

  export type Notification_ReceiverScalarWhereInput = {
    AND?: Enumerable<Notification_ReceiverScalarWhereInput>
    OR?: Enumerable<Notification_ReceiverScalarWhereInput>
    NOT?: Enumerable<Notification_ReceiverScalarWhereInput>
    id?: StringFilter | string
    notification_id?: StringFilter | string
    user_id?: StringFilter | string
    isRead?: BoolFilter | boolean
  }

  export type VacationUpsertWithWhereUniqueWithoutUserInput = {
    where: VacationWhereUniqueInput
    update: XOR<VacationUpdateWithoutUserInput, VacationUncheckedUpdateWithoutUserInput>
    create: XOR<VacationCreateWithoutUserInput, VacationUncheckedCreateWithoutUserInput>
  }

  export type VacationUpdateWithWhereUniqueWithoutUserInput = {
    where: VacationWhereUniqueInput
    data: XOR<VacationUpdateWithoutUserInput, VacationUncheckedUpdateWithoutUserInput>
  }

  export type VacationUpdateManyWithWhereWithoutUserInput = {
    where: VacationScalarWhereInput
    data: XOR<VacationUpdateManyMutationInput, VacationUncheckedUpdateManyWithoutVacationInput>
  }

  export type VacationScalarWhereInput = {
    AND?: Enumerable<VacationScalarWhereInput>
    OR?: Enumerable<VacationScalarWhereInput>
    NOT?: Enumerable<VacationScalarWhereInput>
    id?: StringFilter | string
    user_id?: StringFilter | string
    from?: DateTimeFilter | Date | string
    to?: DateTimeFilter | Date | string
    type?: EnumVacation_TypeFilter | Vacation_Type
    status?: EnumVacation_StatusFilter | Vacation_Status
    description?: StringNullableFilter | string | null
    createdAt?: DateTimeFilter | Date | string
    updatedAt?: DateTimeFilter | Date | string
  }

  export type FileCreateWithoutUserDetailInput = {
    id?: string
    path: string
    type: FileType
    size: number
    alt?: string | null
    mimetype: string
    createdAt?: Date | string
    updatedAt?: Date | string
    user: UserCreateNestedOneWithoutFileInput
    Notification?: NotificationCreateNestedManyWithoutFileInput
  }

  export type FileUncheckedCreateWithoutUserDetailInput = {
    id?: string
    path: string
    type: FileType
    author: string
    size: number
    alt?: string | null
    mimetype: string
    createdAt?: Date | string
    updatedAt?: Date | string
    Notification?: NotificationUncheckedCreateNestedManyWithoutFileInput
  }

  export type FileCreateOrConnectWithoutUserDetailInput = {
    where: FileWhereUniqueInput
    create: XOR<FileCreateWithoutUserDetailInput, FileUncheckedCreateWithoutUserDetailInput>
  }

  export type UserCreateWithoutUserDetailInput = {
    id?: string
    email: string
    password: string
    phone?: string | null
    status?: UserStatus
    createdAt?: Date | string
    updatedAt?: Date | string
    userManager?: UserDetailCreateNestedManyWithoutManagerInput
    role: RoleCreateNestedOneWithoutUserInput
    ResetPassowrd?: ResetPassowrdCreateNestedOneWithoutUserInput
    Inout?: InoutCreateNestedManyWithoutUserInput
    File?: FileCreateNestedManyWithoutUserInput
    Notification?: NotificationCreateNestedManyWithoutAuthorInput
    Notification_Receiver?: Notification_ReceiverCreateNestedManyWithoutUserInput
    Vacation?: VacationCreateNestedManyWithoutUserInput
  }

  export type UserUncheckedCreateWithoutUserDetailInput = {
    id?: string
    email: string
    password: string
    phone?: string | null
    status?: UserStatus
    role_id: string
    createdAt?: Date | string
    updatedAt?: Date | string
    userManager?: UserDetailUncheckedCreateNestedManyWithoutManagerInput
    ResetPassowrd?: ResetPassowrdUncheckedCreateNestedOneWithoutUserInput
    Inout?: InoutUncheckedCreateNestedManyWithoutUserInput
    File?: FileUncheckedCreateNestedManyWithoutUserInput
    Notification?: NotificationUncheckedCreateNestedManyWithoutAuthorInput
    Notification_Receiver?: Notification_ReceiverUncheckedCreateNestedManyWithoutUserInput
    Vacation?: VacationUncheckedCreateNestedManyWithoutUserInput
  }

  export type UserCreateOrConnectWithoutUserDetailInput = {
    where: UserWhereUniqueInput
    create: XOR<UserCreateWithoutUserDetailInput, UserUncheckedCreateWithoutUserDetailInput>
  }

  export type UserCreateWithoutUserManagerInput = {
    id?: string
    email: string
    password: string
    phone?: string | null
    status?: UserStatus
    createdAt?: Date | string
    updatedAt?: Date | string
    userDetail?: UserDetailCreateNestedOneWithoutUserInput
    role: RoleCreateNestedOneWithoutUserInput
    ResetPassowrd?: ResetPassowrdCreateNestedOneWithoutUserInput
    Inout?: InoutCreateNestedManyWithoutUserInput
    File?: FileCreateNestedManyWithoutUserInput
    Notification?: NotificationCreateNestedManyWithoutAuthorInput
    Notification_Receiver?: Notification_ReceiverCreateNestedManyWithoutUserInput
    Vacation?: VacationCreateNestedManyWithoutUserInput
  }

  export type UserUncheckedCreateWithoutUserManagerInput = {
    id?: string
    email: string
    password: string
    phone?: string | null
    status?: UserStatus
    role_id: string
    createdAt?: Date | string
    updatedAt?: Date | string
    userDetail?: UserDetailUncheckedCreateNestedOneWithoutUserInput
    ResetPassowrd?: ResetPassowrdUncheckedCreateNestedOneWithoutUserInput
    Inout?: InoutUncheckedCreateNestedManyWithoutUserInput
    File?: FileUncheckedCreateNestedManyWithoutUserInput
    Notification?: NotificationUncheckedCreateNestedManyWithoutAuthorInput
    Notification_Receiver?: Notification_ReceiverUncheckedCreateNestedManyWithoutUserInput
    Vacation?: VacationUncheckedCreateNestedManyWithoutUserInput
  }

  export type UserCreateOrConnectWithoutUserManagerInput = {
    where: UserWhereUniqueInput
    create: XOR<UserCreateWithoutUserManagerInput, UserUncheckedCreateWithoutUserManagerInput>
  }

  export type FileUpsertWithoutUserDetailInput = {
    update: XOR<FileUpdateWithoutUserDetailInput, FileUncheckedUpdateWithoutUserDetailInput>
    create: XOR<FileCreateWithoutUserDetailInput, FileUncheckedCreateWithoutUserDetailInput>
  }

  export type FileUpdateWithoutUserDetailInput = {
    id?: StringFieldUpdateOperationsInput | string
    path?: StringFieldUpdateOperationsInput | string
    type?: EnumFileTypeFieldUpdateOperationsInput | FileType
    size?: IntFieldUpdateOperationsInput | number
    alt?: NullableStringFieldUpdateOperationsInput | string | null
    mimetype?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    user?: UserUpdateOneRequiredWithoutFileNestedInput
    Notification?: NotificationUpdateManyWithoutFileNestedInput
  }

  export type FileUncheckedUpdateWithoutUserDetailInput = {
    id?: StringFieldUpdateOperationsInput | string
    path?: StringFieldUpdateOperationsInput | string
    type?: EnumFileTypeFieldUpdateOperationsInput | FileType
    author?: StringFieldUpdateOperationsInput | string
    size?: IntFieldUpdateOperationsInput | number
    alt?: NullableStringFieldUpdateOperationsInput | string | null
    mimetype?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    Notification?: NotificationUncheckedUpdateManyWithoutFileNestedInput
  }

  export type UserUpsertWithoutUserDetailInput = {
    update: XOR<UserUpdateWithoutUserDetailInput, UserUncheckedUpdateWithoutUserDetailInput>
    create: XOR<UserCreateWithoutUserDetailInput, UserUncheckedCreateWithoutUserDetailInput>
  }

  export type UserUpdateWithoutUserDetailInput = {
    id?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    status?: EnumUserStatusFieldUpdateOperationsInput | UserStatus
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    userManager?: UserDetailUpdateManyWithoutManagerNestedInput
    role?: RoleUpdateOneRequiredWithoutUserNestedInput
    ResetPassowrd?: ResetPassowrdUpdateOneWithoutUserNestedInput
    Inout?: InoutUpdateManyWithoutUserNestedInput
    File?: FileUpdateManyWithoutUserNestedInput
    Notification?: NotificationUpdateManyWithoutAuthorNestedInput
    Notification_Receiver?: Notification_ReceiverUpdateManyWithoutUserNestedInput
    Vacation?: VacationUpdateManyWithoutUserNestedInput
  }

  export type UserUncheckedUpdateWithoutUserDetailInput = {
    id?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    status?: EnumUserStatusFieldUpdateOperationsInput | UserStatus
    role_id?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    userManager?: UserDetailUncheckedUpdateManyWithoutManagerNestedInput
    ResetPassowrd?: ResetPassowrdUncheckedUpdateOneWithoutUserNestedInput
    Inout?: InoutUncheckedUpdateManyWithoutUserNestedInput
    File?: FileUncheckedUpdateManyWithoutUserNestedInput
    Notification?: NotificationUncheckedUpdateManyWithoutAuthorNestedInput
    Notification_Receiver?: Notification_ReceiverUncheckedUpdateManyWithoutUserNestedInput
    Vacation?: VacationUncheckedUpdateManyWithoutUserNestedInput
  }

  export type UserUpsertWithoutUserManagerInput = {
    update: XOR<UserUpdateWithoutUserManagerInput, UserUncheckedUpdateWithoutUserManagerInput>
    create: XOR<UserCreateWithoutUserManagerInput, UserUncheckedCreateWithoutUserManagerInput>
  }

  export type UserUpdateWithoutUserManagerInput = {
    id?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    status?: EnumUserStatusFieldUpdateOperationsInput | UserStatus
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    userDetail?: UserDetailUpdateOneWithoutUserNestedInput
    role?: RoleUpdateOneRequiredWithoutUserNestedInput
    ResetPassowrd?: ResetPassowrdUpdateOneWithoutUserNestedInput
    Inout?: InoutUpdateManyWithoutUserNestedInput
    File?: FileUpdateManyWithoutUserNestedInput
    Notification?: NotificationUpdateManyWithoutAuthorNestedInput
    Notification_Receiver?: Notification_ReceiverUpdateManyWithoutUserNestedInput
    Vacation?: VacationUpdateManyWithoutUserNestedInput
  }

  export type UserUncheckedUpdateWithoutUserManagerInput = {
    id?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    status?: EnumUserStatusFieldUpdateOperationsInput | UserStatus
    role_id?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    userDetail?: UserDetailUncheckedUpdateOneWithoutUserNestedInput
    ResetPassowrd?: ResetPassowrdUncheckedUpdateOneWithoutUserNestedInput
    Inout?: InoutUncheckedUpdateManyWithoutUserNestedInput
    File?: FileUncheckedUpdateManyWithoutUserNestedInput
    Notification?: NotificationUncheckedUpdateManyWithoutAuthorNestedInput
    Notification_Receiver?: Notification_ReceiverUncheckedUpdateManyWithoutUserNestedInput
    Vacation?: VacationUncheckedUpdateManyWithoutUserNestedInput
  }

  export type UserCreateWithoutResetPassowrdInput = {
    id?: string
    email: string
    password: string
    phone?: string | null
    status?: UserStatus
    createdAt?: Date | string
    updatedAt?: Date | string
    userDetail?: UserDetailCreateNestedOneWithoutUserInput
    userManager?: UserDetailCreateNestedManyWithoutManagerInput
    role: RoleCreateNestedOneWithoutUserInput
    Inout?: InoutCreateNestedManyWithoutUserInput
    File?: FileCreateNestedManyWithoutUserInput
    Notification?: NotificationCreateNestedManyWithoutAuthorInput
    Notification_Receiver?: Notification_ReceiverCreateNestedManyWithoutUserInput
    Vacation?: VacationCreateNestedManyWithoutUserInput
  }

  export type UserUncheckedCreateWithoutResetPassowrdInput = {
    id?: string
    email: string
    password: string
    phone?: string | null
    status?: UserStatus
    role_id: string
    createdAt?: Date | string
    updatedAt?: Date | string
    userDetail?: UserDetailUncheckedCreateNestedOneWithoutUserInput
    userManager?: UserDetailUncheckedCreateNestedManyWithoutManagerInput
    Inout?: InoutUncheckedCreateNestedManyWithoutUserInput
    File?: FileUncheckedCreateNestedManyWithoutUserInput
    Notification?: NotificationUncheckedCreateNestedManyWithoutAuthorInput
    Notification_Receiver?: Notification_ReceiverUncheckedCreateNestedManyWithoutUserInput
    Vacation?: VacationUncheckedCreateNestedManyWithoutUserInput
  }

  export type UserCreateOrConnectWithoutResetPassowrdInput = {
    where: UserWhereUniqueInput
    create: XOR<UserCreateWithoutResetPassowrdInput, UserUncheckedCreateWithoutResetPassowrdInput>
  }

  export type UserUpsertWithoutResetPassowrdInput = {
    update: XOR<UserUpdateWithoutResetPassowrdInput, UserUncheckedUpdateWithoutResetPassowrdInput>
    create: XOR<UserCreateWithoutResetPassowrdInput, UserUncheckedCreateWithoutResetPassowrdInput>
  }

  export type UserUpdateWithoutResetPassowrdInput = {
    id?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    status?: EnumUserStatusFieldUpdateOperationsInput | UserStatus
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    userDetail?: UserDetailUpdateOneWithoutUserNestedInput
    userManager?: UserDetailUpdateManyWithoutManagerNestedInput
    role?: RoleUpdateOneRequiredWithoutUserNestedInput
    Inout?: InoutUpdateManyWithoutUserNestedInput
    File?: FileUpdateManyWithoutUserNestedInput
    Notification?: NotificationUpdateManyWithoutAuthorNestedInput
    Notification_Receiver?: Notification_ReceiverUpdateManyWithoutUserNestedInput
    Vacation?: VacationUpdateManyWithoutUserNestedInput
  }

  export type UserUncheckedUpdateWithoutResetPassowrdInput = {
    id?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    status?: EnumUserStatusFieldUpdateOperationsInput | UserStatus
    role_id?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    userDetail?: UserDetailUncheckedUpdateOneWithoutUserNestedInput
    userManager?: UserDetailUncheckedUpdateManyWithoutManagerNestedInput
    Inout?: InoutUncheckedUpdateManyWithoutUserNestedInput
    File?: FileUncheckedUpdateManyWithoutUserNestedInput
    Notification?: NotificationUncheckedUpdateManyWithoutAuthorNestedInput
    Notification_Receiver?: Notification_ReceiverUncheckedUpdateManyWithoutUserNestedInput
    Vacation?: VacationUncheckedUpdateManyWithoutUserNestedInput
  }

  export type PermissionsOnRoleCreateWithoutRoleInput = {
    id?: string
    assignedAt?: Date | string
    assignedBy: string
    permission: PermissionCreateNestedOneWithoutPermissionsOnRoleInput
  }

  export type PermissionsOnRoleUncheckedCreateWithoutRoleInput = {
    id?: string
    permission_id: string
    assignedAt?: Date | string
    assignedBy: string
  }

  export type PermissionsOnRoleCreateOrConnectWithoutRoleInput = {
    where: PermissionsOnRoleWhereUniqueInput
    create: XOR<PermissionsOnRoleCreateWithoutRoleInput, PermissionsOnRoleUncheckedCreateWithoutRoleInput>
  }

  export type PermissionsOnRoleCreateManyRoleInputEnvelope = {
    data: Enumerable<PermissionsOnRoleCreateManyRoleInput>
    skipDuplicates?: boolean
  }

  export type UserCreateWithoutRoleInput = {
    id?: string
    email: string
    password: string
    phone?: string | null
    status?: UserStatus
    createdAt?: Date | string
    updatedAt?: Date | string
    userDetail?: UserDetailCreateNestedOneWithoutUserInput
    userManager?: UserDetailCreateNestedManyWithoutManagerInput
    ResetPassowrd?: ResetPassowrdCreateNestedOneWithoutUserInput
    Inout?: InoutCreateNestedManyWithoutUserInput
    File?: FileCreateNestedManyWithoutUserInput
    Notification?: NotificationCreateNestedManyWithoutAuthorInput
    Notification_Receiver?: Notification_ReceiverCreateNestedManyWithoutUserInput
    Vacation?: VacationCreateNestedManyWithoutUserInput
  }

  export type UserUncheckedCreateWithoutRoleInput = {
    id?: string
    email: string
    password: string
    phone?: string | null
    status?: UserStatus
    createdAt?: Date | string
    updatedAt?: Date | string
    userDetail?: UserDetailUncheckedCreateNestedOneWithoutUserInput
    userManager?: UserDetailUncheckedCreateNestedManyWithoutManagerInput
    ResetPassowrd?: ResetPassowrdUncheckedCreateNestedOneWithoutUserInput
    Inout?: InoutUncheckedCreateNestedManyWithoutUserInput
    File?: FileUncheckedCreateNestedManyWithoutUserInput
    Notification?: NotificationUncheckedCreateNestedManyWithoutAuthorInput
    Notification_Receiver?: Notification_ReceiverUncheckedCreateNestedManyWithoutUserInput
    Vacation?: VacationUncheckedCreateNestedManyWithoutUserInput
  }

  export type UserCreateOrConnectWithoutRoleInput = {
    where: UserWhereUniqueInput
    create: XOR<UserCreateWithoutRoleInput, UserUncheckedCreateWithoutRoleInput>
  }

  export type UserCreateManyRoleInputEnvelope = {
    data: Enumerable<UserCreateManyRoleInput>
    skipDuplicates?: boolean
  }

  export type PermissionsOnRoleUpsertWithWhereUniqueWithoutRoleInput = {
    where: PermissionsOnRoleWhereUniqueInput
    update: XOR<PermissionsOnRoleUpdateWithoutRoleInput, PermissionsOnRoleUncheckedUpdateWithoutRoleInput>
    create: XOR<PermissionsOnRoleCreateWithoutRoleInput, PermissionsOnRoleUncheckedCreateWithoutRoleInput>
  }

  export type PermissionsOnRoleUpdateWithWhereUniqueWithoutRoleInput = {
    where: PermissionsOnRoleWhereUniqueInput
    data: XOR<PermissionsOnRoleUpdateWithoutRoleInput, PermissionsOnRoleUncheckedUpdateWithoutRoleInput>
  }

  export type PermissionsOnRoleUpdateManyWithWhereWithoutRoleInput = {
    where: PermissionsOnRoleScalarWhereInput
    data: XOR<PermissionsOnRoleUpdateManyMutationInput, PermissionsOnRoleUncheckedUpdateManyWithoutPermissionsOnRoleInput>
  }

  export type PermissionsOnRoleScalarWhereInput = {
    AND?: Enumerable<PermissionsOnRoleScalarWhereInput>
    OR?: Enumerable<PermissionsOnRoleScalarWhereInput>
    NOT?: Enumerable<PermissionsOnRoleScalarWhereInput>
    id?: StringFilter | string
    role_id?: StringFilter | string
    permission_id?: StringFilter | string
    assignedAt?: DateTimeFilter | Date | string
    assignedBy?: StringFilter | string
  }

  export type UserUpsertWithWhereUniqueWithoutRoleInput = {
    where: UserWhereUniqueInput
    update: XOR<UserUpdateWithoutRoleInput, UserUncheckedUpdateWithoutRoleInput>
    create: XOR<UserCreateWithoutRoleInput, UserUncheckedCreateWithoutRoleInput>
  }

  export type UserUpdateWithWhereUniqueWithoutRoleInput = {
    where: UserWhereUniqueInput
    data: XOR<UserUpdateWithoutRoleInput, UserUncheckedUpdateWithoutRoleInput>
  }

  export type UserUpdateManyWithWhereWithoutRoleInput = {
    where: UserScalarWhereInput
    data: XOR<UserUpdateManyMutationInput, UserUncheckedUpdateManyWithoutUserInput>
  }

  export type UserScalarWhereInput = {
    AND?: Enumerable<UserScalarWhereInput>
    OR?: Enumerable<UserScalarWhereInput>
    NOT?: Enumerable<UserScalarWhereInput>
    id?: StringFilter | string
    email?: StringFilter | string
    password?: StringFilter | string
    phone?: StringNullableFilter | string | null
    status?: EnumUserStatusFilter | UserStatus
    role_id?: StringFilter | string
    createdAt?: DateTimeFilter | Date | string
    updatedAt?: DateTimeFilter | Date | string
  }

  export type PermissionsOnRoleCreateWithoutPermissionInput = {
    id?: string
    assignedAt?: Date | string
    assignedBy: string
    role: RoleCreateNestedOneWithoutPermissionsOnRoleInput
  }

  export type PermissionsOnRoleUncheckedCreateWithoutPermissionInput = {
    id?: string
    role_id: string
    assignedAt?: Date | string
    assignedBy: string
  }

  export type PermissionsOnRoleCreateOrConnectWithoutPermissionInput = {
    where: PermissionsOnRoleWhereUniqueInput
    create: XOR<PermissionsOnRoleCreateWithoutPermissionInput, PermissionsOnRoleUncheckedCreateWithoutPermissionInput>
  }

  export type PermissionsOnRoleCreateManyPermissionInputEnvelope = {
    data: Enumerable<PermissionsOnRoleCreateManyPermissionInput>
    skipDuplicates?: boolean
  }

  export type PermissionsOnRoleUpsertWithWhereUniqueWithoutPermissionInput = {
    where: PermissionsOnRoleWhereUniqueInput
    update: XOR<PermissionsOnRoleUpdateWithoutPermissionInput, PermissionsOnRoleUncheckedUpdateWithoutPermissionInput>
    create: XOR<PermissionsOnRoleCreateWithoutPermissionInput, PermissionsOnRoleUncheckedCreateWithoutPermissionInput>
  }

  export type PermissionsOnRoleUpdateWithWhereUniqueWithoutPermissionInput = {
    where: PermissionsOnRoleWhereUniqueInput
    data: XOR<PermissionsOnRoleUpdateWithoutPermissionInput, PermissionsOnRoleUncheckedUpdateWithoutPermissionInput>
  }

  export type PermissionsOnRoleUpdateManyWithWhereWithoutPermissionInput = {
    where: PermissionsOnRoleScalarWhereInput
    data: XOR<PermissionsOnRoleUpdateManyMutationInput, PermissionsOnRoleUncheckedUpdateManyWithoutPermissionsOnRoleInput>
  }

  export type RoleCreateWithoutPermissionsOnRoleInput = {
    id?: string
    name: string
    description?: string | null
    User?: UserCreateNestedManyWithoutRoleInput
  }

  export type RoleUncheckedCreateWithoutPermissionsOnRoleInput = {
    id?: string
    name: string
    description?: string | null
    User?: UserUncheckedCreateNestedManyWithoutRoleInput
  }

  export type RoleCreateOrConnectWithoutPermissionsOnRoleInput = {
    where: RoleWhereUniqueInput
    create: XOR<RoleCreateWithoutPermissionsOnRoleInput, RoleUncheckedCreateWithoutPermissionsOnRoleInput>
  }

  export type PermissionCreateWithoutPermissionsOnRoleInput = {
    id?: string
    key: string
    persian_name: string
    english_name: string
    category: string
  }

  export type PermissionUncheckedCreateWithoutPermissionsOnRoleInput = {
    id?: string
    key: string
    persian_name: string
    english_name: string
    category: string
  }

  export type PermissionCreateOrConnectWithoutPermissionsOnRoleInput = {
    where: PermissionWhereUniqueInput
    create: XOR<PermissionCreateWithoutPermissionsOnRoleInput, PermissionUncheckedCreateWithoutPermissionsOnRoleInput>
  }

  export type RoleUpsertWithoutPermissionsOnRoleInput = {
    update: XOR<RoleUpdateWithoutPermissionsOnRoleInput, RoleUncheckedUpdateWithoutPermissionsOnRoleInput>
    create: XOR<RoleCreateWithoutPermissionsOnRoleInput, RoleUncheckedCreateWithoutPermissionsOnRoleInput>
  }

  export type RoleUpdateWithoutPermissionsOnRoleInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    User?: UserUpdateManyWithoutRoleNestedInput
  }

  export type RoleUncheckedUpdateWithoutPermissionsOnRoleInput = {
    id?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    User?: UserUncheckedUpdateManyWithoutRoleNestedInput
  }

  export type PermissionUpsertWithoutPermissionsOnRoleInput = {
    update: XOR<PermissionUpdateWithoutPermissionsOnRoleInput, PermissionUncheckedUpdateWithoutPermissionsOnRoleInput>
    create: XOR<PermissionCreateWithoutPermissionsOnRoleInput, PermissionUncheckedCreateWithoutPermissionsOnRoleInput>
  }

  export type PermissionUpdateWithoutPermissionsOnRoleInput = {
    id?: StringFieldUpdateOperationsInput | string
    key?: StringFieldUpdateOperationsInput | string
    persian_name?: StringFieldUpdateOperationsInput | string
    english_name?: StringFieldUpdateOperationsInput | string
    category?: StringFieldUpdateOperationsInput | string
  }

  export type PermissionUncheckedUpdateWithoutPermissionsOnRoleInput = {
    id?: StringFieldUpdateOperationsInput | string
    key?: StringFieldUpdateOperationsInput | string
    persian_name?: StringFieldUpdateOperationsInput | string
    english_name?: StringFieldUpdateOperationsInput | string
    category?: StringFieldUpdateOperationsInput | string
  }

  export type UserCreateWithoutFileInput = {
    id?: string
    email: string
    password: string
    phone?: string | null
    status?: UserStatus
    createdAt?: Date | string
    updatedAt?: Date | string
    userDetail?: UserDetailCreateNestedOneWithoutUserInput
    userManager?: UserDetailCreateNestedManyWithoutManagerInput
    role: RoleCreateNestedOneWithoutUserInput
    ResetPassowrd?: ResetPassowrdCreateNestedOneWithoutUserInput
    Inout?: InoutCreateNestedManyWithoutUserInput
    Notification?: NotificationCreateNestedManyWithoutAuthorInput
    Notification_Receiver?: Notification_ReceiverCreateNestedManyWithoutUserInput
    Vacation?: VacationCreateNestedManyWithoutUserInput
  }

  export type UserUncheckedCreateWithoutFileInput = {
    id?: string
    email: string
    password: string
    phone?: string | null
    status?: UserStatus
    role_id: string
    createdAt?: Date | string
    updatedAt?: Date | string
    userDetail?: UserDetailUncheckedCreateNestedOneWithoutUserInput
    userManager?: UserDetailUncheckedCreateNestedManyWithoutManagerInput
    ResetPassowrd?: ResetPassowrdUncheckedCreateNestedOneWithoutUserInput
    Inout?: InoutUncheckedCreateNestedManyWithoutUserInput
    Notification?: NotificationUncheckedCreateNestedManyWithoutAuthorInput
    Notification_Receiver?: Notification_ReceiverUncheckedCreateNestedManyWithoutUserInput
    Vacation?: VacationUncheckedCreateNestedManyWithoutUserInput
  }

  export type UserCreateOrConnectWithoutFileInput = {
    where: UserWhereUniqueInput
    create: XOR<UserCreateWithoutFileInput, UserUncheckedCreateWithoutFileInput>
  }

  export type UserDetailCreateWithoutFileInput = {
    id?: string
    first_name?: string | null
    last_name?: string | null
    personal_code?: number | null
    delay_time?: string | null
    delay_ratio?: number | null
    vacation_remained?: number
    createdAt?: Date | string
    updatedAt?: Date | string
    user: UserCreateNestedOneWithoutUserDetailInput
    manager?: UserCreateNestedOneWithoutUserManagerInput
  }

  export type UserDetailUncheckedCreateWithoutFileInput = {
    id?: string
    user_id: string
    first_name?: string | null
    last_name?: string | null
    personal_code?: number | null
    delay_time?: string | null
    delay_ratio?: number | null
    manager_id?: string | null
    vacation_remained?: number
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type UserDetailCreateOrConnectWithoutFileInput = {
    where: UserDetailWhereUniqueInput
    create: XOR<UserDetailCreateWithoutFileInput, UserDetailUncheckedCreateWithoutFileInput>
  }

  export type UserDetailCreateManyFileInputEnvelope = {
    data: Enumerable<UserDetailCreateManyFileInput>
    skipDuplicates?: boolean
  }

  export type NotificationCreateWithoutFileInput = {
    id?: string
    title: string
    content: string
    createdAt?: Date | string
    author: UserCreateNestedOneWithoutNotificationInput
    Notification_Receiver?: Notification_ReceiverCreateNestedManyWithoutNotificationInput
  }

  export type NotificationUncheckedCreateWithoutFileInput = {
    id?: string
    title: string
    content: string
    author_id: string
    createdAt?: Date | string
    Notification_Receiver?: Notification_ReceiverUncheckedCreateNestedManyWithoutNotificationInput
  }

  export type NotificationCreateOrConnectWithoutFileInput = {
    where: NotificationWhereUniqueInput
    create: XOR<NotificationCreateWithoutFileInput, NotificationUncheckedCreateWithoutFileInput>
  }

  export type NotificationCreateManyFileInputEnvelope = {
    data: Enumerable<NotificationCreateManyFileInput>
    skipDuplicates?: boolean
  }

  export type UserUpsertWithoutFileInput = {
    update: XOR<UserUpdateWithoutFileInput, UserUncheckedUpdateWithoutFileInput>
    create: XOR<UserCreateWithoutFileInput, UserUncheckedCreateWithoutFileInput>
  }

  export type UserUpdateWithoutFileInput = {
    id?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    status?: EnumUserStatusFieldUpdateOperationsInput | UserStatus
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    userDetail?: UserDetailUpdateOneWithoutUserNestedInput
    userManager?: UserDetailUpdateManyWithoutManagerNestedInput
    role?: RoleUpdateOneRequiredWithoutUserNestedInput
    ResetPassowrd?: ResetPassowrdUpdateOneWithoutUserNestedInput
    Inout?: InoutUpdateManyWithoutUserNestedInput
    Notification?: NotificationUpdateManyWithoutAuthorNestedInput
    Notification_Receiver?: Notification_ReceiverUpdateManyWithoutUserNestedInput
    Vacation?: VacationUpdateManyWithoutUserNestedInput
  }

  export type UserUncheckedUpdateWithoutFileInput = {
    id?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    status?: EnumUserStatusFieldUpdateOperationsInput | UserStatus
    role_id?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    userDetail?: UserDetailUncheckedUpdateOneWithoutUserNestedInput
    userManager?: UserDetailUncheckedUpdateManyWithoutManagerNestedInput
    ResetPassowrd?: ResetPassowrdUncheckedUpdateOneWithoutUserNestedInput
    Inout?: InoutUncheckedUpdateManyWithoutUserNestedInput
    Notification?: NotificationUncheckedUpdateManyWithoutAuthorNestedInput
    Notification_Receiver?: Notification_ReceiverUncheckedUpdateManyWithoutUserNestedInput
    Vacation?: VacationUncheckedUpdateManyWithoutUserNestedInput
  }

  export type UserDetailUpsertWithWhereUniqueWithoutFileInput = {
    where: UserDetailWhereUniqueInput
    update: XOR<UserDetailUpdateWithoutFileInput, UserDetailUncheckedUpdateWithoutFileInput>
    create: XOR<UserDetailCreateWithoutFileInput, UserDetailUncheckedCreateWithoutFileInput>
  }

  export type UserDetailUpdateWithWhereUniqueWithoutFileInput = {
    where: UserDetailWhereUniqueInput
    data: XOR<UserDetailUpdateWithoutFileInput, UserDetailUncheckedUpdateWithoutFileInput>
  }

  export type UserDetailUpdateManyWithWhereWithoutFileInput = {
    where: UserDetailScalarWhereInput
    data: XOR<UserDetailUpdateManyMutationInput, UserDetailUncheckedUpdateManyWithoutUserDetailInput>
  }

  export type NotificationUpsertWithWhereUniqueWithoutFileInput = {
    where: NotificationWhereUniqueInput
    update: XOR<NotificationUpdateWithoutFileInput, NotificationUncheckedUpdateWithoutFileInput>
    create: XOR<NotificationCreateWithoutFileInput, NotificationUncheckedCreateWithoutFileInput>
  }

  export type NotificationUpdateWithWhereUniqueWithoutFileInput = {
    where: NotificationWhereUniqueInput
    data: XOR<NotificationUpdateWithoutFileInput, NotificationUncheckedUpdateWithoutFileInput>
  }

  export type NotificationUpdateManyWithWhereWithoutFileInput = {
    where: NotificationScalarWhereInput
    data: XOR<NotificationUpdateManyMutationInput, NotificationUncheckedUpdateManyWithoutNotificationInput>
  }

  export type UserCreateWithoutInoutInput = {
    id?: string
    email: string
    password: string
    phone?: string | null
    status?: UserStatus
    createdAt?: Date | string
    updatedAt?: Date | string
    userDetail?: UserDetailCreateNestedOneWithoutUserInput
    userManager?: UserDetailCreateNestedManyWithoutManagerInput
    role: RoleCreateNestedOneWithoutUserInput
    ResetPassowrd?: ResetPassowrdCreateNestedOneWithoutUserInput
    File?: FileCreateNestedManyWithoutUserInput
    Notification?: NotificationCreateNestedManyWithoutAuthorInput
    Notification_Receiver?: Notification_ReceiverCreateNestedManyWithoutUserInput
    Vacation?: VacationCreateNestedManyWithoutUserInput
  }

  export type UserUncheckedCreateWithoutInoutInput = {
    id?: string
    email: string
    password: string
    phone?: string | null
    status?: UserStatus
    role_id: string
    createdAt?: Date | string
    updatedAt?: Date | string
    userDetail?: UserDetailUncheckedCreateNestedOneWithoutUserInput
    userManager?: UserDetailUncheckedCreateNestedManyWithoutManagerInput
    ResetPassowrd?: ResetPassowrdUncheckedCreateNestedOneWithoutUserInput
    File?: FileUncheckedCreateNestedManyWithoutUserInput
    Notification?: NotificationUncheckedCreateNestedManyWithoutAuthorInput
    Notification_Receiver?: Notification_ReceiverUncheckedCreateNestedManyWithoutUserInput
    Vacation?: VacationUncheckedCreateNestedManyWithoutUserInput
  }

  export type UserCreateOrConnectWithoutInoutInput = {
    where: UserWhereUniqueInput
    create: XOR<UserCreateWithoutInoutInput, UserUncheckedCreateWithoutInoutInput>
  }

  export type Inout_logsCreateWithoutInoutInput = {
    id?: string
    action: Log_Action
    old_time?: Date | string | null
    new_time?: Date | string | null
    description?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type Inout_logsUncheckedCreateWithoutInoutInput = {
    id?: string
    action: Log_Action
    old_time?: Date | string | null
    new_time?: Date | string | null
    description?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type Inout_logsCreateOrConnectWithoutInoutInput = {
    where: Inout_logsWhereUniqueInput
    create: XOR<Inout_logsCreateWithoutInoutInput, Inout_logsUncheckedCreateWithoutInoutInput>
  }

  export type Inout_logsCreateManyInoutInputEnvelope = {
    data: Enumerable<Inout_logsCreateManyInoutInput>
    skipDuplicates?: boolean
  }

  export type UserUpsertWithoutInoutInput = {
    update: XOR<UserUpdateWithoutInoutInput, UserUncheckedUpdateWithoutInoutInput>
    create: XOR<UserCreateWithoutInoutInput, UserUncheckedCreateWithoutInoutInput>
  }

  export type UserUpdateWithoutInoutInput = {
    id?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    status?: EnumUserStatusFieldUpdateOperationsInput | UserStatus
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    userDetail?: UserDetailUpdateOneWithoutUserNestedInput
    userManager?: UserDetailUpdateManyWithoutManagerNestedInput
    role?: RoleUpdateOneRequiredWithoutUserNestedInput
    ResetPassowrd?: ResetPassowrdUpdateOneWithoutUserNestedInput
    File?: FileUpdateManyWithoutUserNestedInput
    Notification?: NotificationUpdateManyWithoutAuthorNestedInput
    Notification_Receiver?: Notification_ReceiverUpdateManyWithoutUserNestedInput
    Vacation?: VacationUpdateManyWithoutUserNestedInput
  }

  export type UserUncheckedUpdateWithoutInoutInput = {
    id?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    status?: EnumUserStatusFieldUpdateOperationsInput | UserStatus
    role_id?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    userDetail?: UserDetailUncheckedUpdateOneWithoutUserNestedInput
    userManager?: UserDetailUncheckedUpdateManyWithoutManagerNestedInput
    ResetPassowrd?: ResetPassowrdUncheckedUpdateOneWithoutUserNestedInput
    File?: FileUncheckedUpdateManyWithoutUserNestedInput
    Notification?: NotificationUncheckedUpdateManyWithoutAuthorNestedInput
    Notification_Receiver?: Notification_ReceiverUncheckedUpdateManyWithoutUserNestedInput
    Vacation?: VacationUncheckedUpdateManyWithoutUserNestedInput
  }

  export type Inout_logsUpsertWithWhereUniqueWithoutInoutInput = {
    where: Inout_logsWhereUniqueInput
    update: XOR<Inout_logsUpdateWithoutInoutInput, Inout_logsUncheckedUpdateWithoutInoutInput>
    create: XOR<Inout_logsCreateWithoutInoutInput, Inout_logsUncheckedCreateWithoutInoutInput>
  }

  export type Inout_logsUpdateWithWhereUniqueWithoutInoutInput = {
    where: Inout_logsWhereUniqueInput
    data: XOR<Inout_logsUpdateWithoutInoutInput, Inout_logsUncheckedUpdateWithoutInoutInput>
  }

  export type Inout_logsUpdateManyWithWhereWithoutInoutInput = {
    where: Inout_logsScalarWhereInput
    data: XOR<Inout_logsUpdateManyMutationInput, Inout_logsUncheckedUpdateManyWithoutInout_logsInput>
  }

  export type Inout_logsScalarWhereInput = {
    AND?: Enumerable<Inout_logsScalarWhereInput>
    OR?: Enumerable<Inout_logsScalarWhereInput>
    NOT?: Enumerable<Inout_logsScalarWhereInput>
    id?: StringFilter | string
    inout_id?: StringFilter | string
    action?: EnumLog_ActionFilter | Log_Action
    old_time?: DateTimeNullableFilter | Date | string | null
    new_time?: DateTimeNullableFilter | Date | string | null
    description?: StringNullableFilter | string | null
    createdAt?: DateTimeFilter | Date | string
    updatedAt?: DateTimeFilter | Date | string
  }

  export type InoutCreateWithoutInout_logsInput = {
    id?: string
    time: Date | string
    type?: InoutType
    delete?: boolean
    description?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
    approved?: boolean
    user: UserCreateNestedOneWithoutInoutInput
  }

  export type InoutUncheckedCreateWithoutInout_logsInput = {
    id?: string
    user_id: string
    time: Date | string
    type?: InoutType
    delete?: boolean
    description?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
    approved?: boolean
  }

  export type InoutCreateOrConnectWithoutInout_logsInput = {
    where: InoutWhereUniqueInput
    create: XOR<InoutCreateWithoutInout_logsInput, InoutUncheckedCreateWithoutInout_logsInput>
  }

  export type InoutUpsertWithoutInout_logsInput = {
    update: XOR<InoutUpdateWithoutInout_logsInput, InoutUncheckedUpdateWithoutInout_logsInput>
    create: XOR<InoutCreateWithoutInout_logsInput, InoutUncheckedCreateWithoutInout_logsInput>
  }

  export type InoutUpdateWithoutInout_logsInput = {
    id?: StringFieldUpdateOperationsInput | string
    time?: DateTimeFieldUpdateOperationsInput | Date | string
    type?: EnumInoutTypeFieldUpdateOperationsInput | InoutType
    delete?: BoolFieldUpdateOperationsInput | boolean
    description?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    approved?: BoolFieldUpdateOperationsInput | boolean
    user?: UserUpdateOneRequiredWithoutInoutNestedInput
  }

  export type InoutUncheckedUpdateWithoutInout_logsInput = {
    id?: StringFieldUpdateOperationsInput | string
    user_id?: StringFieldUpdateOperationsInput | string
    time?: DateTimeFieldUpdateOperationsInput | Date | string
    type?: EnumInoutTypeFieldUpdateOperationsInput | InoutType
    delete?: BoolFieldUpdateOperationsInput | boolean
    description?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    approved?: BoolFieldUpdateOperationsInput | boolean
  }

  export type FileCreateWithoutNotificationInput = {
    id?: string
    path: string
    type: FileType
    size: number
    alt?: string | null
    mimetype: string
    createdAt?: Date | string
    updatedAt?: Date | string
    user: UserCreateNestedOneWithoutFileInput
    UserDetail?: UserDetailCreateNestedManyWithoutFileInput
  }

  export type FileUncheckedCreateWithoutNotificationInput = {
    id?: string
    path: string
    type: FileType
    author: string
    size: number
    alt?: string | null
    mimetype: string
    createdAt?: Date | string
    updatedAt?: Date | string
    UserDetail?: UserDetailUncheckedCreateNestedManyWithoutFileInput
  }

  export type FileCreateOrConnectWithoutNotificationInput = {
    where: FileWhereUniqueInput
    create: XOR<FileCreateWithoutNotificationInput, FileUncheckedCreateWithoutNotificationInput>
  }

  export type UserCreateWithoutNotificationInput = {
    id?: string
    email: string
    password: string
    phone?: string | null
    status?: UserStatus
    createdAt?: Date | string
    updatedAt?: Date | string
    userDetail?: UserDetailCreateNestedOneWithoutUserInput
    userManager?: UserDetailCreateNestedManyWithoutManagerInput
    role: RoleCreateNestedOneWithoutUserInput
    ResetPassowrd?: ResetPassowrdCreateNestedOneWithoutUserInput
    Inout?: InoutCreateNestedManyWithoutUserInput
    File?: FileCreateNestedManyWithoutUserInput
    Notification_Receiver?: Notification_ReceiverCreateNestedManyWithoutUserInput
    Vacation?: VacationCreateNestedManyWithoutUserInput
  }

  export type UserUncheckedCreateWithoutNotificationInput = {
    id?: string
    email: string
    password: string
    phone?: string | null
    status?: UserStatus
    role_id: string
    createdAt?: Date | string
    updatedAt?: Date | string
    userDetail?: UserDetailUncheckedCreateNestedOneWithoutUserInput
    userManager?: UserDetailUncheckedCreateNestedManyWithoutManagerInput
    ResetPassowrd?: ResetPassowrdUncheckedCreateNestedOneWithoutUserInput
    Inout?: InoutUncheckedCreateNestedManyWithoutUserInput
    File?: FileUncheckedCreateNestedManyWithoutUserInput
    Notification_Receiver?: Notification_ReceiverUncheckedCreateNestedManyWithoutUserInput
    Vacation?: VacationUncheckedCreateNestedManyWithoutUserInput
  }

  export type UserCreateOrConnectWithoutNotificationInput = {
    where: UserWhereUniqueInput
    create: XOR<UserCreateWithoutNotificationInput, UserUncheckedCreateWithoutNotificationInput>
  }

  export type Notification_ReceiverCreateWithoutNotificationInput = {
    id?: string
    isRead?: boolean
    user: UserCreateNestedOneWithoutNotification_ReceiverInput
  }

  export type Notification_ReceiverUncheckedCreateWithoutNotificationInput = {
    id?: string
    user_id: string
    isRead?: boolean
  }

  export type Notification_ReceiverCreateOrConnectWithoutNotificationInput = {
    where: Notification_ReceiverWhereUniqueInput
    create: XOR<Notification_ReceiverCreateWithoutNotificationInput, Notification_ReceiverUncheckedCreateWithoutNotificationInput>
  }

  export type Notification_ReceiverCreateManyNotificationInputEnvelope = {
    data: Enumerable<Notification_ReceiverCreateManyNotificationInput>
    skipDuplicates?: boolean
  }

  export type FileUpsertWithoutNotificationInput = {
    update: XOR<FileUpdateWithoutNotificationInput, FileUncheckedUpdateWithoutNotificationInput>
    create: XOR<FileCreateWithoutNotificationInput, FileUncheckedCreateWithoutNotificationInput>
  }

  export type FileUpdateWithoutNotificationInput = {
    id?: StringFieldUpdateOperationsInput | string
    path?: StringFieldUpdateOperationsInput | string
    type?: EnumFileTypeFieldUpdateOperationsInput | FileType
    size?: IntFieldUpdateOperationsInput | number
    alt?: NullableStringFieldUpdateOperationsInput | string | null
    mimetype?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    user?: UserUpdateOneRequiredWithoutFileNestedInput
    UserDetail?: UserDetailUpdateManyWithoutFileNestedInput
  }

  export type FileUncheckedUpdateWithoutNotificationInput = {
    id?: StringFieldUpdateOperationsInput | string
    path?: StringFieldUpdateOperationsInput | string
    type?: EnumFileTypeFieldUpdateOperationsInput | FileType
    author?: StringFieldUpdateOperationsInput | string
    size?: IntFieldUpdateOperationsInput | number
    alt?: NullableStringFieldUpdateOperationsInput | string | null
    mimetype?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    UserDetail?: UserDetailUncheckedUpdateManyWithoutFileNestedInput
  }

  export type UserUpsertWithoutNotificationInput = {
    update: XOR<UserUpdateWithoutNotificationInput, UserUncheckedUpdateWithoutNotificationInput>
    create: XOR<UserCreateWithoutNotificationInput, UserUncheckedCreateWithoutNotificationInput>
  }

  export type UserUpdateWithoutNotificationInput = {
    id?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    status?: EnumUserStatusFieldUpdateOperationsInput | UserStatus
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    userDetail?: UserDetailUpdateOneWithoutUserNestedInput
    userManager?: UserDetailUpdateManyWithoutManagerNestedInput
    role?: RoleUpdateOneRequiredWithoutUserNestedInput
    ResetPassowrd?: ResetPassowrdUpdateOneWithoutUserNestedInput
    Inout?: InoutUpdateManyWithoutUserNestedInput
    File?: FileUpdateManyWithoutUserNestedInput
    Notification_Receiver?: Notification_ReceiverUpdateManyWithoutUserNestedInput
    Vacation?: VacationUpdateManyWithoutUserNestedInput
  }

  export type UserUncheckedUpdateWithoutNotificationInput = {
    id?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    status?: EnumUserStatusFieldUpdateOperationsInput | UserStatus
    role_id?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    userDetail?: UserDetailUncheckedUpdateOneWithoutUserNestedInput
    userManager?: UserDetailUncheckedUpdateManyWithoutManagerNestedInput
    ResetPassowrd?: ResetPassowrdUncheckedUpdateOneWithoutUserNestedInput
    Inout?: InoutUncheckedUpdateManyWithoutUserNestedInput
    File?: FileUncheckedUpdateManyWithoutUserNestedInput
    Notification_Receiver?: Notification_ReceiverUncheckedUpdateManyWithoutUserNestedInput
    Vacation?: VacationUncheckedUpdateManyWithoutUserNestedInput
  }

  export type Notification_ReceiverUpsertWithWhereUniqueWithoutNotificationInput = {
    where: Notification_ReceiverWhereUniqueInput
    update: XOR<Notification_ReceiverUpdateWithoutNotificationInput, Notification_ReceiverUncheckedUpdateWithoutNotificationInput>
    create: XOR<Notification_ReceiverCreateWithoutNotificationInput, Notification_ReceiverUncheckedCreateWithoutNotificationInput>
  }

  export type Notification_ReceiverUpdateWithWhereUniqueWithoutNotificationInput = {
    where: Notification_ReceiverWhereUniqueInput
    data: XOR<Notification_ReceiverUpdateWithoutNotificationInput, Notification_ReceiverUncheckedUpdateWithoutNotificationInput>
  }

  export type Notification_ReceiverUpdateManyWithWhereWithoutNotificationInput = {
    where: Notification_ReceiverScalarWhereInput
    data: XOR<Notification_ReceiverUpdateManyMutationInput, Notification_ReceiverUncheckedUpdateManyWithoutNotification_ReceiverInput>
  }

  export type NotificationCreateWithoutNotification_ReceiverInput = {
    id?: string
    title: string
    content: string
    createdAt?: Date | string
    file?: FileCreateNestedOneWithoutNotificationInput
    author: UserCreateNestedOneWithoutNotificationInput
  }

  export type NotificationUncheckedCreateWithoutNotification_ReceiverInput = {
    id?: string
    title: string
    content: string
    file_id?: string | null
    author_id: string
    createdAt?: Date | string
  }

  export type NotificationCreateOrConnectWithoutNotification_ReceiverInput = {
    where: NotificationWhereUniqueInput
    create: XOR<NotificationCreateWithoutNotification_ReceiverInput, NotificationUncheckedCreateWithoutNotification_ReceiverInput>
  }

  export type UserCreateWithoutNotification_ReceiverInput = {
    id?: string
    email: string
    password: string
    phone?: string | null
    status?: UserStatus
    createdAt?: Date | string
    updatedAt?: Date | string
    userDetail?: UserDetailCreateNestedOneWithoutUserInput
    userManager?: UserDetailCreateNestedManyWithoutManagerInput
    role: RoleCreateNestedOneWithoutUserInput
    ResetPassowrd?: ResetPassowrdCreateNestedOneWithoutUserInput
    Inout?: InoutCreateNestedManyWithoutUserInput
    File?: FileCreateNestedManyWithoutUserInput
    Notification?: NotificationCreateNestedManyWithoutAuthorInput
    Vacation?: VacationCreateNestedManyWithoutUserInput
  }

  export type UserUncheckedCreateWithoutNotification_ReceiverInput = {
    id?: string
    email: string
    password: string
    phone?: string | null
    status?: UserStatus
    role_id: string
    createdAt?: Date | string
    updatedAt?: Date | string
    userDetail?: UserDetailUncheckedCreateNestedOneWithoutUserInput
    userManager?: UserDetailUncheckedCreateNestedManyWithoutManagerInput
    ResetPassowrd?: ResetPassowrdUncheckedCreateNestedOneWithoutUserInput
    Inout?: InoutUncheckedCreateNestedManyWithoutUserInput
    File?: FileUncheckedCreateNestedManyWithoutUserInput
    Notification?: NotificationUncheckedCreateNestedManyWithoutAuthorInput
    Vacation?: VacationUncheckedCreateNestedManyWithoutUserInput
  }

  export type UserCreateOrConnectWithoutNotification_ReceiverInput = {
    where: UserWhereUniqueInput
    create: XOR<UserCreateWithoutNotification_ReceiverInput, UserUncheckedCreateWithoutNotification_ReceiverInput>
  }

  export type NotificationUpsertWithoutNotification_ReceiverInput = {
    update: XOR<NotificationUpdateWithoutNotification_ReceiverInput, NotificationUncheckedUpdateWithoutNotification_ReceiverInput>
    create: XOR<NotificationCreateWithoutNotification_ReceiverInput, NotificationUncheckedCreateWithoutNotification_ReceiverInput>
  }

  export type NotificationUpdateWithoutNotification_ReceiverInput = {
    id?: StringFieldUpdateOperationsInput | string
    title?: StringFieldUpdateOperationsInput | string
    content?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    file?: FileUpdateOneWithoutNotificationNestedInput
    author?: UserUpdateOneRequiredWithoutNotificationNestedInput
  }

  export type NotificationUncheckedUpdateWithoutNotification_ReceiverInput = {
    id?: StringFieldUpdateOperationsInput | string
    title?: StringFieldUpdateOperationsInput | string
    content?: StringFieldUpdateOperationsInput | string
    file_id?: NullableStringFieldUpdateOperationsInput | string | null
    author_id?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type UserUpsertWithoutNotification_ReceiverInput = {
    update: XOR<UserUpdateWithoutNotification_ReceiverInput, UserUncheckedUpdateWithoutNotification_ReceiverInput>
    create: XOR<UserCreateWithoutNotification_ReceiverInput, UserUncheckedCreateWithoutNotification_ReceiverInput>
  }

  export type UserUpdateWithoutNotification_ReceiverInput = {
    id?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    status?: EnumUserStatusFieldUpdateOperationsInput | UserStatus
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    userDetail?: UserDetailUpdateOneWithoutUserNestedInput
    userManager?: UserDetailUpdateManyWithoutManagerNestedInput
    role?: RoleUpdateOneRequiredWithoutUserNestedInput
    ResetPassowrd?: ResetPassowrdUpdateOneWithoutUserNestedInput
    Inout?: InoutUpdateManyWithoutUserNestedInput
    File?: FileUpdateManyWithoutUserNestedInput
    Notification?: NotificationUpdateManyWithoutAuthorNestedInput
    Vacation?: VacationUpdateManyWithoutUserNestedInput
  }

  export type UserUncheckedUpdateWithoutNotification_ReceiverInput = {
    id?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    status?: EnumUserStatusFieldUpdateOperationsInput | UserStatus
    role_id?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    userDetail?: UserDetailUncheckedUpdateOneWithoutUserNestedInput
    userManager?: UserDetailUncheckedUpdateManyWithoutManagerNestedInput
    ResetPassowrd?: ResetPassowrdUncheckedUpdateOneWithoutUserNestedInput
    Inout?: InoutUncheckedUpdateManyWithoutUserNestedInput
    File?: FileUncheckedUpdateManyWithoutUserNestedInput
    Notification?: NotificationUncheckedUpdateManyWithoutAuthorNestedInput
    Vacation?: VacationUncheckedUpdateManyWithoutUserNestedInput
  }

  export type UserCreateWithoutVacationInput = {
    id?: string
    email: string
    password: string
    phone?: string | null
    status?: UserStatus
    createdAt?: Date | string
    updatedAt?: Date | string
    userDetail?: UserDetailCreateNestedOneWithoutUserInput
    userManager?: UserDetailCreateNestedManyWithoutManagerInput
    role: RoleCreateNestedOneWithoutUserInput
    ResetPassowrd?: ResetPassowrdCreateNestedOneWithoutUserInput
    Inout?: InoutCreateNestedManyWithoutUserInput
    File?: FileCreateNestedManyWithoutUserInput
    Notification?: NotificationCreateNestedManyWithoutAuthorInput
    Notification_Receiver?: Notification_ReceiverCreateNestedManyWithoutUserInput
  }

  export type UserUncheckedCreateWithoutVacationInput = {
    id?: string
    email: string
    password: string
    phone?: string | null
    status?: UserStatus
    role_id: string
    createdAt?: Date | string
    updatedAt?: Date | string
    userDetail?: UserDetailUncheckedCreateNestedOneWithoutUserInput
    userManager?: UserDetailUncheckedCreateNestedManyWithoutManagerInput
    ResetPassowrd?: ResetPassowrdUncheckedCreateNestedOneWithoutUserInput
    Inout?: InoutUncheckedCreateNestedManyWithoutUserInput
    File?: FileUncheckedCreateNestedManyWithoutUserInput
    Notification?: NotificationUncheckedCreateNestedManyWithoutAuthorInput
    Notification_Receiver?: Notification_ReceiverUncheckedCreateNestedManyWithoutUserInput
  }

  export type UserCreateOrConnectWithoutVacationInput = {
    where: UserWhereUniqueInput
    create: XOR<UserCreateWithoutVacationInput, UserUncheckedCreateWithoutVacationInput>
  }

  export type UserUpsertWithoutVacationInput = {
    update: XOR<UserUpdateWithoutVacationInput, UserUncheckedUpdateWithoutVacationInput>
    create: XOR<UserCreateWithoutVacationInput, UserUncheckedCreateWithoutVacationInput>
  }

  export type UserUpdateWithoutVacationInput = {
    id?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    status?: EnumUserStatusFieldUpdateOperationsInput | UserStatus
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    userDetail?: UserDetailUpdateOneWithoutUserNestedInput
    userManager?: UserDetailUpdateManyWithoutManagerNestedInput
    role?: RoleUpdateOneRequiredWithoutUserNestedInput
    ResetPassowrd?: ResetPassowrdUpdateOneWithoutUserNestedInput
    Inout?: InoutUpdateManyWithoutUserNestedInput
    File?: FileUpdateManyWithoutUserNestedInput
    Notification?: NotificationUpdateManyWithoutAuthorNestedInput
    Notification_Receiver?: Notification_ReceiverUpdateManyWithoutUserNestedInput
  }

  export type UserUncheckedUpdateWithoutVacationInput = {
    id?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    status?: EnumUserStatusFieldUpdateOperationsInput | UserStatus
    role_id?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    userDetail?: UserDetailUncheckedUpdateOneWithoutUserNestedInput
    userManager?: UserDetailUncheckedUpdateManyWithoutManagerNestedInput
    ResetPassowrd?: ResetPassowrdUncheckedUpdateOneWithoutUserNestedInput
    Inout?: InoutUncheckedUpdateManyWithoutUserNestedInput
    File?: FileUncheckedUpdateManyWithoutUserNestedInput
    Notification?: NotificationUncheckedUpdateManyWithoutAuthorNestedInput
    Notification_Receiver?: Notification_ReceiverUncheckedUpdateManyWithoutUserNestedInput
  }

  export type UserDetailCreateManyManagerInput = {
    id?: string
    user_id: string
    first_name?: string | null
    last_name?: string | null
    personal_code?: number | null
    featured_image?: string | null
    delay_time?: string | null
    delay_ratio?: number | null
    vacation_remained?: number
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type InoutCreateManyUserInput = {
    id?: string
    time: Date | string
    type?: InoutType
    delete?: boolean
    description?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
    approved?: boolean
  }

  export type FileCreateManyUserInput = {
    id?: string
    path: string
    type: FileType
    size: number
    alt?: string | null
    mimetype: string
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type NotificationCreateManyAuthorInput = {
    id?: string
    title: string
    content: string
    file_id?: string | null
    createdAt?: Date | string
  }

  export type Notification_ReceiverCreateManyUserInput = {
    id?: string
    notification_id: string
    isRead?: boolean
  }

  export type VacationCreateManyUserInput = {
    id?: string
    from: Date | string
    to: Date | string
    type: Vacation_Type
    status?: Vacation_Status
    description?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type UserDetailUpdateWithoutManagerInput = {
    id?: StringFieldUpdateOperationsInput | string
    first_name?: NullableStringFieldUpdateOperationsInput | string | null
    last_name?: NullableStringFieldUpdateOperationsInput | string | null
    personal_code?: NullableIntFieldUpdateOperationsInput | number | null
    delay_time?: NullableStringFieldUpdateOperationsInput | string | null
    delay_ratio?: NullableIntFieldUpdateOperationsInput | number | null
    vacation_remained?: IntFieldUpdateOperationsInput | number
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    file?: FileUpdateOneWithoutUserDetailNestedInput
    user?: UserUpdateOneRequiredWithoutUserDetailNestedInput
  }

  export type UserDetailUncheckedUpdateWithoutManagerInput = {
    id?: StringFieldUpdateOperationsInput | string
    user_id?: StringFieldUpdateOperationsInput | string
    first_name?: NullableStringFieldUpdateOperationsInput | string | null
    last_name?: NullableStringFieldUpdateOperationsInput | string | null
    personal_code?: NullableIntFieldUpdateOperationsInput | number | null
    featured_image?: NullableStringFieldUpdateOperationsInput | string | null
    delay_time?: NullableStringFieldUpdateOperationsInput | string | null
    delay_ratio?: NullableIntFieldUpdateOperationsInput | number | null
    vacation_remained?: IntFieldUpdateOperationsInput | number
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type UserDetailUncheckedUpdateManyWithoutUserManagerInput = {
    id?: StringFieldUpdateOperationsInput | string
    user_id?: StringFieldUpdateOperationsInput | string
    first_name?: NullableStringFieldUpdateOperationsInput | string | null
    last_name?: NullableStringFieldUpdateOperationsInput | string | null
    personal_code?: NullableIntFieldUpdateOperationsInput | number | null
    featured_image?: NullableStringFieldUpdateOperationsInput | string | null
    delay_time?: NullableStringFieldUpdateOperationsInput | string | null
    delay_ratio?: NullableIntFieldUpdateOperationsInput | number | null
    vacation_remained?: IntFieldUpdateOperationsInput | number
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type InoutUpdateWithoutUserInput = {
    id?: StringFieldUpdateOperationsInput | string
    time?: DateTimeFieldUpdateOperationsInput | Date | string
    type?: EnumInoutTypeFieldUpdateOperationsInput | InoutType
    delete?: BoolFieldUpdateOperationsInput | boolean
    description?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    approved?: BoolFieldUpdateOperationsInput | boolean
    Inout_logs?: Inout_logsUpdateManyWithoutInoutNestedInput
  }

  export type InoutUncheckedUpdateWithoutUserInput = {
    id?: StringFieldUpdateOperationsInput | string
    time?: DateTimeFieldUpdateOperationsInput | Date | string
    type?: EnumInoutTypeFieldUpdateOperationsInput | InoutType
    delete?: BoolFieldUpdateOperationsInput | boolean
    description?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    approved?: BoolFieldUpdateOperationsInput | boolean
    Inout_logs?: Inout_logsUncheckedUpdateManyWithoutInoutNestedInput
  }

  export type InoutUncheckedUpdateManyWithoutInoutInput = {
    id?: StringFieldUpdateOperationsInput | string
    time?: DateTimeFieldUpdateOperationsInput | Date | string
    type?: EnumInoutTypeFieldUpdateOperationsInput | InoutType
    delete?: BoolFieldUpdateOperationsInput | boolean
    description?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    approved?: BoolFieldUpdateOperationsInput | boolean
  }

  export type FileUpdateWithoutUserInput = {
    id?: StringFieldUpdateOperationsInput | string
    path?: StringFieldUpdateOperationsInput | string
    type?: EnumFileTypeFieldUpdateOperationsInput | FileType
    size?: IntFieldUpdateOperationsInput | number
    alt?: NullableStringFieldUpdateOperationsInput | string | null
    mimetype?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    UserDetail?: UserDetailUpdateManyWithoutFileNestedInput
    Notification?: NotificationUpdateManyWithoutFileNestedInput
  }

  export type FileUncheckedUpdateWithoutUserInput = {
    id?: StringFieldUpdateOperationsInput | string
    path?: StringFieldUpdateOperationsInput | string
    type?: EnumFileTypeFieldUpdateOperationsInput | FileType
    size?: IntFieldUpdateOperationsInput | number
    alt?: NullableStringFieldUpdateOperationsInput | string | null
    mimetype?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    UserDetail?: UserDetailUncheckedUpdateManyWithoutFileNestedInput
    Notification?: NotificationUncheckedUpdateManyWithoutFileNestedInput
  }

  export type FileUncheckedUpdateManyWithoutFileInput = {
    id?: StringFieldUpdateOperationsInput | string
    path?: StringFieldUpdateOperationsInput | string
    type?: EnumFileTypeFieldUpdateOperationsInput | FileType
    size?: IntFieldUpdateOperationsInput | number
    alt?: NullableStringFieldUpdateOperationsInput | string | null
    mimetype?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type NotificationUpdateWithoutAuthorInput = {
    id?: StringFieldUpdateOperationsInput | string
    title?: StringFieldUpdateOperationsInput | string
    content?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    file?: FileUpdateOneWithoutNotificationNestedInput
    Notification_Receiver?: Notification_ReceiverUpdateManyWithoutNotificationNestedInput
  }

  export type NotificationUncheckedUpdateWithoutAuthorInput = {
    id?: StringFieldUpdateOperationsInput | string
    title?: StringFieldUpdateOperationsInput | string
    content?: StringFieldUpdateOperationsInput | string
    file_id?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    Notification_Receiver?: Notification_ReceiverUncheckedUpdateManyWithoutNotificationNestedInput
  }

  export type NotificationUncheckedUpdateManyWithoutNotificationInput = {
    id?: StringFieldUpdateOperationsInput | string
    title?: StringFieldUpdateOperationsInput | string
    content?: StringFieldUpdateOperationsInput | string
    file_id?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type Notification_ReceiverUpdateWithoutUserInput = {
    id?: StringFieldUpdateOperationsInput | string
    isRead?: BoolFieldUpdateOperationsInput | boolean
    notification?: NotificationUpdateOneRequiredWithoutNotification_ReceiverNestedInput
  }

  export type Notification_ReceiverUncheckedUpdateWithoutUserInput = {
    id?: StringFieldUpdateOperationsInput | string
    notification_id?: StringFieldUpdateOperationsInput | string
    isRead?: BoolFieldUpdateOperationsInput | boolean
  }

  export type Notification_ReceiverUncheckedUpdateManyWithoutNotification_ReceiverInput = {
    id?: StringFieldUpdateOperationsInput | string
    notification_id?: StringFieldUpdateOperationsInput | string
    isRead?: BoolFieldUpdateOperationsInput | boolean
  }

  export type VacationUpdateWithoutUserInput = {
    id?: StringFieldUpdateOperationsInput | string
    from?: DateTimeFieldUpdateOperationsInput | Date | string
    to?: DateTimeFieldUpdateOperationsInput | Date | string
    type?: EnumVacation_TypeFieldUpdateOperationsInput | Vacation_Type
    status?: EnumVacation_StatusFieldUpdateOperationsInput | Vacation_Status
    description?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type VacationUncheckedUpdateWithoutUserInput = {
    id?: StringFieldUpdateOperationsInput | string
    from?: DateTimeFieldUpdateOperationsInput | Date | string
    to?: DateTimeFieldUpdateOperationsInput | Date | string
    type?: EnumVacation_TypeFieldUpdateOperationsInput | Vacation_Type
    status?: EnumVacation_StatusFieldUpdateOperationsInput | Vacation_Status
    description?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type VacationUncheckedUpdateManyWithoutVacationInput = {
    id?: StringFieldUpdateOperationsInput | string
    from?: DateTimeFieldUpdateOperationsInput | Date | string
    to?: DateTimeFieldUpdateOperationsInput | Date | string
    type?: EnumVacation_TypeFieldUpdateOperationsInput | Vacation_Type
    status?: EnumVacation_StatusFieldUpdateOperationsInput | Vacation_Status
    description?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type PermissionsOnRoleCreateManyRoleInput = {
    id?: string
    permission_id: string
    assignedAt?: Date | string
    assignedBy: string
  }

  export type UserCreateManyRoleInput = {
    id?: string
    email: string
    password: string
    phone?: string | null
    status?: UserStatus
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type PermissionsOnRoleUpdateWithoutRoleInput = {
    id?: StringFieldUpdateOperationsInput | string
    assignedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    assignedBy?: StringFieldUpdateOperationsInput | string
    permission?: PermissionUpdateOneRequiredWithoutPermissionsOnRoleNestedInput
  }

  export type PermissionsOnRoleUncheckedUpdateWithoutRoleInput = {
    id?: StringFieldUpdateOperationsInput | string
    permission_id?: StringFieldUpdateOperationsInput | string
    assignedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    assignedBy?: StringFieldUpdateOperationsInput | string
  }

  export type PermissionsOnRoleUncheckedUpdateManyWithoutPermissionsOnRoleInput = {
    id?: StringFieldUpdateOperationsInput | string
    permission_id?: StringFieldUpdateOperationsInput | string
    assignedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    assignedBy?: StringFieldUpdateOperationsInput | string
  }

  export type UserUpdateWithoutRoleInput = {
    id?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    status?: EnumUserStatusFieldUpdateOperationsInput | UserStatus
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    userDetail?: UserDetailUpdateOneWithoutUserNestedInput
    userManager?: UserDetailUpdateManyWithoutManagerNestedInput
    ResetPassowrd?: ResetPassowrdUpdateOneWithoutUserNestedInput
    Inout?: InoutUpdateManyWithoutUserNestedInput
    File?: FileUpdateManyWithoutUserNestedInput
    Notification?: NotificationUpdateManyWithoutAuthorNestedInput
    Notification_Receiver?: Notification_ReceiverUpdateManyWithoutUserNestedInput
    Vacation?: VacationUpdateManyWithoutUserNestedInput
  }

  export type UserUncheckedUpdateWithoutRoleInput = {
    id?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    status?: EnumUserStatusFieldUpdateOperationsInput | UserStatus
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    userDetail?: UserDetailUncheckedUpdateOneWithoutUserNestedInput
    userManager?: UserDetailUncheckedUpdateManyWithoutManagerNestedInput
    ResetPassowrd?: ResetPassowrdUncheckedUpdateOneWithoutUserNestedInput
    Inout?: InoutUncheckedUpdateManyWithoutUserNestedInput
    File?: FileUncheckedUpdateManyWithoutUserNestedInput
    Notification?: NotificationUncheckedUpdateManyWithoutAuthorNestedInput
    Notification_Receiver?: Notification_ReceiverUncheckedUpdateManyWithoutUserNestedInput
    Vacation?: VacationUncheckedUpdateManyWithoutUserNestedInput
  }

  export type UserUncheckedUpdateManyWithoutUserInput = {
    id?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    password?: StringFieldUpdateOperationsInput | string
    phone?: NullableStringFieldUpdateOperationsInput | string | null
    status?: EnumUserStatusFieldUpdateOperationsInput | UserStatus
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type PermissionsOnRoleCreateManyPermissionInput = {
    id?: string
    role_id: string
    assignedAt?: Date | string
    assignedBy: string
  }

  export type PermissionsOnRoleUpdateWithoutPermissionInput = {
    id?: StringFieldUpdateOperationsInput | string
    assignedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    assignedBy?: StringFieldUpdateOperationsInput | string
    role?: RoleUpdateOneRequiredWithoutPermissionsOnRoleNestedInput
  }

  export type PermissionsOnRoleUncheckedUpdateWithoutPermissionInput = {
    id?: StringFieldUpdateOperationsInput | string
    role_id?: StringFieldUpdateOperationsInput | string
    assignedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    assignedBy?: StringFieldUpdateOperationsInput | string
  }

  export type UserDetailCreateManyFileInput = {
    id?: string
    user_id: string
    first_name?: string | null
    last_name?: string | null
    personal_code?: number | null
    delay_time?: string | null
    delay_ratio?: number | null
    manager_id?: string | null
    vacation_remained?: number
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type NotificationCreateManyFileInput = {
    id?: string
    title: string
    content: string
    author_id: string
    createdAt?: Date | string
  }

  export type UserDetailUpdateWithoutFileInput = {
    id?: StringFieldUpdateOperationsInput | string
    first_name?: NullableStringFieldUpdateOperationsInput | string | null
    last_name?: NullableStringFieldUpdateOperationsInput | string | null
    personal_code?: NullableIntFieldUpdateOperationsInput | number | null
    delay_time?: NullableStringFieldUpdateOperationsInput | string | null
    delay_ratio?: NullableIntFieldUpdateOperationsInput | number | null
    vacation_remained?: IntFieldUpdateOperationsInput | number
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    user?: UserUpdateOneRequiredWithoutUserDetailNestedInput
    manager?: UserUpdateOneWithoutUserManagerNestedInput
  }

  export type UserDetailUncheckedUpdateWithoutFileInput = {
    id?: StringFieldUpdateOperationsInput | string
    user_id?: StringFieldUpdateOperationsInput | string
    first_name?: NullableStringFieldUpdateOperationsInput | string | null
    last_name?: NullableStringFieldUpdateOperationsInput | string | null
    personal_code?: NullableIntFieldUpdateOperationsInput | number | null
    delay_time?: NullableStringFieldUpdateOperationsInput | string | null
    delay_ratio?: NullableIntFieldUpdateOperationsInput | number | null
    manager_id?: NullableStringFieldUpdateOperationsInput | string | null
    vacation_remained?: IntFieldUpdateOperationsInput | number
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type UserDetailUncheckedUpdateManyWithoutUserDetailInput = {
    id?: StringFieldUpdateOperationsInput | string
    user_id?: StringFieldUpdateOperationsInput | string
    first_name?: NullableStringFieldUpdateOperationsInput | string | null
    last_name?: NullableStringFieldUpdateOperationsInput | string | null
    personal_code?: NullableIntFieldUpdateOperationsInput | number | null
    delay_time?: NullableStringFieldUpdateOperationsInput | string | null
    delay_ratio?: NullableIntFieldUpdateOperationsInput | number | null
    manager_id?: NullableStringFieldUpdateOperationsInput | string | null
    vacation_remained?: IntFieldUpdateOperationsInput | number
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type NotificationUpdateWithoutFileInput = {
    id?: StringFieldUpdateOperationsInput | string
    title?: StringFieldUpdateOperationsInput | string
    content?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    author?: UserUpdateOneRequiredWithoutNotificationNestedInput
    Notification_Receiver?: Notification_ReceiverUpdateManyWithoutNotificationNestedInput
  }

  export type NotificationUncheckedUpdateWithoutFileInput = {
    id?: StringFieldUpdateOperationsInput | string
    title?: StringFieldUpdateOperationsInput | string
    content?: StringFieldUpdateOperationsInput | string
    author_id?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    Notification_Receiver?: Notification_ReceiverUncheckedUpdateManyWithoutNotificationNestedInput
  }

  export type Inout_logsCreateManyInoutInput = {
    id?: string
    action: Log_Action
    old_time?: Date | string | null
    new_time?: Date | string | null
    description?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type Inout_logsUpdateWithoutInoutInput = {
    id?: StringFieldUpdateOperationsInput | string
    action?: EnumLog_ActionFieldUpdateOperationsInput | Log_Action
    old_time?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    new_time?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    description?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type Inout_logsUncheckedUpdateWithoutInoutInput = {
    id?: StringFieldUpdateOperationsInput | string
    action?: EnumLog_ActionFieldUpdateOperationsInput | Log_Action
    old_time?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    new_time?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    description?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type Inout_logsUncheckedUpdateManyWithoutInout_logsInput = {
    id?: StringFieldUpdateOperationsInput | string
    action?: EnumLog_ActionFieldUpdateOperationsInput | Log_Action
    old_time?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    new_time?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    description?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type Notification_ReceiverCreateManyNotificationInput = {
    id?: string
    user_id: string
    isRead?: boolean
  }

  export type Notification_ReceiverUpdateWithoutNotificationInput = {
    id?: StringFieldUpdateOperationsInput | string
    isRead?: BoolFieldUpdateOperationsInput | boolean
    user?: UserUpdateOneRequiredWithoutNotification_ReceiverNestedInput
  }

  export type Notification_ReceiverUncheckedUpdateWithoutNotificationInput = {
    id?: StringFieldUpdateOperationsInput | string
    user_id?: StringFieldUpdateOperationsInput | string
    isRead?: BoolFieldUpdateOperationsInput | boolean
  }



  /**
   * Batch Payload for updateMany & deleteMany & createMany
   */

  export type BatchPayload = {
    count: number
  }

  /**
   * DMMF
   */
  export const dmmf: runtime.BaseDMMF
}