import { Type } from 'class-transformer';
import { IsDate } from 'class-validator';
import { ApiProperty } from '@nestjs/swagger';

export enum TypeEnum {
  hourly = 'hourly',
  daily = 'daily',
}

export enum StatusEnum {
  accepted = 'accepted',
  denied = 'denied',
  pending = 'pending',
}

export class CreateVacationDto {
  user_id: string;
  @Type(() => Date)
  @IsDate()
  @ApiProperty()
  from: Date;
  @Type(() => Date)
  @IsDate()
  @ApiProperty()
  to: Date;

  type: TypeEnum;

  status: StatusEnum;
  @ApiProperty()
  description: string;
}
