import { PartialType } from '@nestjs/mapped-types';
import { CreateUserDto } from './create-user.dto';
import { ApiBearerAuth, ApiProperty } from '@nestjs/swagger';
import { IsEmail, IsOptional, Length } from 'class-validator';
import { IsNotNull } from '@nestjsi/class-validator';

@ApiBearerAuth()
export class UpdateUserDto extends PartialType(CreateUserDto) {
  @ApiProperty()
  @Length(11, 11)
  phone: string;

  @ApiProperty()
  @IsEmail()
  @IsNotNull()
  email: string;

  @ApiProperty()
  @IsNotNull()
  @IsOptional()
  @Length(8, 100)
  password: string;
}
