import { ApiBearerAuth, ApiProperty } from '@nestjs/swagger';
import { IsEmail, IsEnum, IsOptional, Length } from 'class-validator';
import { IsNotNull } from '@nestjsi/class-validator';
import { isEmailUnique, isPhoneUnique } from 'src/common/validators';

export enum Status {
  active = 'active',
  pending = 'pending',
  inactive = 'inactive',
}

@ApiBearerAuth()
export class CreateUserDto {
  @ApiProperty()
  first_name: string;

  @ApiProperty()
  last_name: string;

  @ApiProperty()
  @isPhoneUnique()
  @Length(11, 11)
  phone: string;

  @ApiProperty()
  @isEmailUnique()
  @IsEmail()
  @IsNotNull()
  email: string;

  @ApiProperty()
  @IsNotNull()
  @Length(8, 100)
  password: string;

  @IsEnum(Status)
  @ApiProperty({
    description: 'description of the severity property',
    enum: Status,
  })
  status: Status;

  @ApiProperty()
  @IsNotNull()
  role_id: string;

  @ApiProperty()
  @IsNotNull()
  delay_time: string;

  @ApiProperty()
  @IsNotNull()
  delay_ratio: string;

  @ApiProperty()
  @IsOptional()
  manager_id: string;

  @ApiProperty()
  personal_code: string;

  @ApiProperty()
  vacation_remained: string;
}
