import { HttpException, HttpStatus, Injectable } from '@nestjs/common';
import { CreateRoleDto } from './dto/create-role.dto';
import { UpdateRoleDto } from './dto/update-role.dto';
import { PrismaService } from '../prisma/prisma.service';

@Injectable()
export class RolesService {
  constructor(private prisma: PrismaService) {}

  create(createRoleDto: CreateRoleDto) {
    const req_permissions = JSON.parse(createRoleDto.permissions);
    return this.prisma.role.create({
      data: {
        name: createRoleDto.name,
        description: createRoleDto.description,
        PermissionsOnRole: {
          createMany: {
            data: req_permissions.map((el) => {
              return {
                permission_id: el,
                assignedBy: 'postman',
              };
            }),
          },
        },
      },
    });
  }

  findAll() {
    return this.prisma.role.findMany();
  }

  findOne(id: string) {
    return this.prisma.role.findUnique({
      where: { id },
      include: {
        PermissionsOnRole: {
          select: {
            permission_id: true,
          },
        },
      },
    });
  }

  update(id: string, updateRoleDto: UpdateRoleDto) {
    const req_permissions = JSON.parse(updateRoleDto.permissions);
    return this.prisma.role.update({
      where: { id },
      data: {
        name: updateRoleDto.name,
        description: updateRoleDto.description,
        PermissionsOnRole: {
          deleteMany: {
            role_id: id,
          },
          createMany: {
            data: req_permissions.map((el) => {
              return {
                permission_id: el,
                assignedBy: 'postman',
              };
            }),
          },
        },
      },
    });
  }

  async remove(id: string) {
    const supername = await this.prisma.role.findFirst({
      where: { name: 'superman' },
    });
    if (supername.id == id) {
      throw new HttpException(
        "You Can't Remove Super Admin!!!",
        HttpStatus.NOT_ACCEPTABLE,
      );
    } else {
      await this.prisma.permissionsOnRole.deleteMany({
        where: {
          role_id: id,
        },
      });
      return await this.prisma.role.delete({ where: { id } });
    }
  }

  permissions() {
    return this.prisma.permission.findMany();
  }
}
