import {
  Controller,
  Get,
  Post,
  Body,
  Patch,
  Param,
  Delete,
  SetMetadata,
  UseGuards,
} from '@nestjs/common';
import { RolesService } from './roles.service';
import { CreateRoleDto } from './dto/create-role.dto';
import { UpdateRoleDto } from './dto/update-role.dto';
import { ApiBearerAuth } from '@nestjs/swagger';
import { JwtAuthGuard } from '../auth/guards/jwt-auth.guard';
import { AuthGuard } from '../auth/guards/auth.guard';

@Controller('roles')
export class RolesController {
  constructor(private readonly rolesService: RolesService) {}

  @ApiBearerAuth()
  @SetMetadata('permissions', ['create_role'])
  @UseGuards(JwtAuthGuard, AuthGuard)
  @Post()
  create(@Body() createRoleDto: CreateRoleDto) {
    return this.rolesService.create(createRoleDto);
  }

  @ApiBearerAuth()
  @SetMetadata('permissions', ['view_role'])
  @UseGuards(JwtAuthGuard, AuthGuard)
  @Get()
  findAll() {
    return this.rolesService.findAll();
  }

  @ApiBearerAuth()
  @SetMetadata('permissions', ['view_role'])
  @UseGuards(JwtAuthGuard, AuthGuard)
  @Get('permissions')
  permissions() {
    return this.rolesService.permissions();
  }

  @ApiBearerAuth()
  @SetMetadata('permissions', ['view_role'])
  @UseGuards(JwtAuthGuard, AuthGuard)
  @Get(':id')
  findOne(@Param('id') id: string) {
    return this.rolesService.findOne(id);
  }

  @ApiBearerAuth()
  @SetMetadata('permissions', ['edit_role'])
  @UseGuards(JwtAuthGuard, AuthGuard)
  @Patch(':id')
  update(@Param('id') id: string, @Body() updateRoleDto: UpdateRoleDto) {
    return this.rolesService.update(id, updateRoleDto);
  }

  @ApiBearerAuth()
  @SetMetadata('permissions', ['destroy_role'])
  @UseGuards(JwtAuthGuard, AuthGuard)
  @Delete(':id')
  remove(@Param('id') id: string) {
    return this.rolesService.remove(id);
  }
}
