import { Controller, Get, Req, SetMetadata, UseGuards } from '@nestjs/common';
import { PanelsService } from './panels.service';
import { ApiBearerAuth } from '@nestjs/swagger';
import { JwtAuthGuard } from '../auth/guards/jwt-auth.guard';
import { AuthGuard } from '../auth/guards/auth.guard';

@Controller('panels')
export class PanelsController {
  constructor(private readonly panelsService: PanelsService) {}

  @Get('dashboard')
  @ApiBearerAuth()
  @SetMetadata('permissions', ['create_user'])
  @UseGuards(JwtAuthGuard, AuthGuard)
  dashboard(@Req() req: any) {
    return this.panelsService.dashboard(req.user.id);
  }
}
