import { NestFactory } from '@nestjs/core';
import { SwaggerModule, DocumentBuilder } from '@nestjs/swagger';
import { AppModule } from './app.module';
import { ValidationPipe } from '@nestjs/common';

async function bootstrap() {
  const app = await NestFactory.create(AppModule);

  const validatorOp = {
    errorHttpStatusCode: 401,
    stopAtFirstError: true,
  };
  app.useGlobalPipes(new ValidationPipe(validatorOp));

  const config = new DocumentBuilder()
    .setTitle('Iotaci Panel')
    .setDescription('The Panel API description')
    .setVersion('0.0.1')
    .addTag('iotaci')
    .addBearerAuth()
    .build();
  const document = SwaggerModule.createDocument(app, config);
  SwaggerModule.setup('api', app, document);
  app.enableCors();
  await app.listen(8000);
}

bootstrap();
