import { MailerService } from '@nestjs-modules/mailer';
import { Injectable } from '@nestjs/common';

@Injectable()
export class MailService {
  constructor(private mailerService: MailerService) {}

  async sendResetPassword(
    user: { email: string; first_name: string; last_name: string },
    token: string,
  ) {
    await this.mailerService.sendMail({
      to: user.email,
      subject: 'Reset Password Request.',
      template: 'reset-password', // `.hbs` extension is appended automatically
      context: {
        first_name: user.first_name,
        last_name: user.last_name,
        token: token,
      },
    });
  }
}
