import {
  Controller,
  Get,
  Post,
  Body,
  Patch,
  Param,
  Delete,
  UseGuards,
  Req,
  SetMetadata,
} from '@nestjs/common';
import { InoutsService } from './inouts.service';
import { CreateInoutDto } from './dto/create-inout.dto';
import { UpdateInoutDto } from './dto/update-inout.dto';
import { ApiBearerAuth } from '@nestjs/swagger';
import { JwtAuthGuard } from '../auth/guards/jwt-auth.guard';
import { AuthGuard } from '../auth/guards/auth.guard';

@Controller('inouts')
export class InoutsController {
  constructor(private readonly inoutsService: InoutsService) {}

  @ApiBearerAuth()
  @UseGuards(JwtAuthGuard)
  @Post()
  create(@Body() createInoutDto: CreateInoutDto, @Req() req: any) {
    return this.inoutsService.create(createInoutDto, req.user.id);
  }

  @ApiBearerAuth()
  @UseGuards(JwtAuthGuard)
  @Get()
  findAll(@Req() req: any) {
    return this.inoutsService.findAll(
      req.query.user != 'undefined' ? req.query.user : req.user.id,
      req.query.year,
      req.query.month,
      req.query.manager,
    );
  }

  @Get('users')
  @ApiBearerAuth()
  @UseGuards(JwtAuthGuard, AuthGuard)
  users(@Req() req: any) {
    return this.inoutsService.users(req.user.id);
  }

  @ApiBearerAuth()
  @UseGuards(JwtAuthGuard)
  @Get(':id')
  findOne(@Param('id') id: string) {
    return this.inoutsService.findOne(id);
  }

  @ApiBearerAuth()
  @UseGuards(JwtAuthGuard)
  @Patch(':id')
  update(@Param('id') id: string, @Body() updateInoutDto: UpdateInoutDto) {
    return this.inoutsService.update(id, updateInoutDto);
  }

  @ApiBearerAuth()
  @UseGuards(JwtAuthGuard)
  @Delete(':id')
  remove(@Param('id') id: string) {
    return this.inoutsService.remove(id);
  }
}
