import { PrismaClient } from '@prisma/client';

export class Inout_logs {
  prisma = new PrismaClient();
  public id;
  private readonly action;
  private readonly description;
  private new_time;

  constructor(id, action, description, new_time) {
    // id = this.id;
    this.id = id;
    this.action = action;
    this.description = description;
    this.new_time = new_time;
  }

  private async getPreviousTime() {
    const inout = await this.prisma.inout.findUnique({
      where: { id: this.id },
    });
    return inout.time;
  }

  async addLog() {
    return this.prisma.inout_logs.create({
      data: {
        action: this.action,
        inout_id: this.id,
        description: this.description,
        old_time: await this.getPreviousTime(),
      },
    });
  }
}
