import { ApiProperty } from '@nestjs/swagger';
import { Type } from 'class-transformer';
import { IsDate, IsOptional } from 'class-validator';

export enum TypeEnum {
  service = 'service',
  custom = 'custom',
}

export class CreateInoutDto {
  @Type(() => Date)
  @IsDate()
  @ApiProperty()
  time: Date;

  @ApiProperty()
  type: TypeEnum;

  @ApiProperty()
  @IsOptional()
  description: string;
}
