import { Injectable } from '@nestjs/common';
import { PrismaService } from '../prisma/prisma.service';

@Injectable()
export class FilesService {
  constructor(private prisma: PrismaService) {}

  create(files, user_id) {
    const typeGenerator = (type) => {
      let splitor = type.split('/');
      switch (splitor[0]) {
        case 'image': {
          return 'image';
        }
        case 'video': {
          return 'video';
        }
        default: {
          return 'document';
        }
      }
    };

    return this.prisma.file.createMany({
      data: files.map((file) => {
        return {
          path: file.filename,
          type: typeGenerator(file.mimetype),
          author: user_id,
          mimetype: file.mimetype,
          size: file.size,
          alt: file.originalname.split('.')[0],
        };
      }),
    });
  }

  findAll(param: { type: 'image' | 'video' | 'document' } | null) {
    if (param.type) {
      return this.prisma.file.findMany({ where: { type: param.type } });
    } else {
      return this.prisma.file.findMany();
    }
  }

  findOne(id: string) {
    return this.prisma.file.findUnique({
      where: { id },
    });
  }

  update(id: string, data) {
    return this.prisma.file.update({
      where: { id },
      data: {
        alt: data.alt,
      },
    });
  }

  remove(id: string) {
    return this.prisma.file.delete({ where: { id } });
  }

  streamFile(path: string) {
    return this.prisma.file.findFirst({ where: { path: path } });
  }
}
