import { CanActivate, ExecutionContext, Injectable } from '@nestjs/common';
import { Reflector } from '@nestjs/core';
import { PrismaService } from '../../prisma/prisma.service';

@Injectable()
export class AuthGuard implements CanActivate {
  constructor(private reflector: Reflector, private prisma: PrismaService) {}

  async canActivate(context: ExecutionContext) {
    const permissions = this.reflector.get<string[]>(
      'permissions',
      context.getHandler(),
    );
    const request = context.switchToHttp().getRequest();
    const user = request.user;
    if (!permissions) {
      return true;
    }
    const user_id = user.id;
    const user_role = await this.prisma.user.findUnique({
      where: { id: user_id },
      select: { role_id: true },
    });
    const role = await this.prisma.role.findFirst({
      where: {
        id: user_role.role_id,
      },
      select: {
        PermissionsOnRole: {
          select: {
            permission: {
              select: {
                key: true,
              },
            },
          },
        },
      },
    });
    const user_permissions = [];
    role.PermissionsOnRole.map((el) => {
      user_permissions.push(el.permission.key);
    });

    const found = user_permissions.some((x) => x.includes(permissions));
    return found;
  }
}
