import {ApiProperty} from '@nestjs/swagger';
import { IsEmail, Length } from "class-validator";

export class ResetPasswordDto {
    @ApiProperty()
    @IsEmail()
    email: string;

    @ApiProperty()
    password: string;

    @ApiProperty()
    @Length(6,6)
    token: string | number
}
