import {ApiProperty} from '@nestjs/swagger';
import { IsEmail, IsEnum, Length } from "class-validator";
import { isEmailUnique, isPhoneUnique } from "../../common/validators";
import { IsNotNull } from "@nestjsi/class-validator";
import { Status } from "../../users/dto/create-user.dto";

export class RegisterAuthDto {
    @ApiProperty()
    first_name: string;

    @ApiProperty()
    last_name: string;

    @ApiProperty()
    @isPhoneUnique()
    @Length(11, 11)
    phone: string;

    @ApiProperty()
    @isEmailUnique()
    @IsEmail()
    @IsNotNull()
    email: string;

    @ApiProperty()
    @IsNotNull()
    @Length(8, 100)
    password: string;
}
