import {
  Controller,
  Post,
  Body,
  HttpCode,
  Get,
  Req,
  UseGuards, HttpException, HttpStatus
} from "@nestjs/common";
import { AuthService } from './auth.service';
import { LoginAuthDto } from './dto/login-auth.dto';
import { JwtAuthGuard } from './guards/jwt-auth.guard';
import { ForgetPasswordDtoDto } from './dto/forget-password.dto';
import { ResetPasswordDto } from './dto/reset-password.dto';
import { RegisterAuthDto } from "./dto/register-auth.dto";

@Controller('auth')
export class AuthController {
  constructor(private readonly authService: AuthService) {}

  @Post('login')
  @HttpCode(200)
  login(@Body() data: LoginAuthDto) {
    return this.authService
      .validateUser(data.email, data.password)
      .then((r) => {
        if (r) {
          return this.authService.login(r).then((x) => {
            return x;
          });
        } else {
          throw new HttpException('Not Correct!', HttpStatus.NOT_ACCEPTABLE);
        }
      });
  }

  @Post('register')
  @HttpCode(200)
  register(@Body() data: RegisterAuthDto) {
    return this.authService.register(data)
  }


  @Post('forgetpassword')
  @HttpCode(200)
  forgetpassword(@Body() data: ForgetPasswordDtoDto) {
    return this.authService.forgetpassword(data.email);
  }

  @Post('resetpassword')
  @HttpCode(200)
  resetpassword(@Body() data: ResetPasswordDto) {
    return this.authService.resetpassword(data);
  }

  @Get('check')
  @HttpCode(200)
  @UseGuards(JwtAuthGuard)
  check(@Req() req: any) {
    return this.authService.check(req.user.id);
  }
}
