import { Module } from '@nestjs/common';
import { AppController } from './app.controller';
import { AppService } from './app.service';
import { PrismaModule } from './prisma/prisma.module';
import { UsersModule } from './users/users.module';
import { AuthModule } from './auth/auth.module';
import { InoutsModule } from './inouts/inouts.module';
import { HolidaysModule } from './holidays/holidays.module';
import { RolesModule } from './roles/roles.module';
import { FilesModule } from './files/files.module';
import { NotificationsModule } from './notifications/notifications.module';
import { PanelsModule } from './panels/panels.module';
import { VacationsModule } from './vacations/vacations.module';

@Module({
  controllers: [AppController],
  providers: [AppService],
  imports: [
    PrismaModule,
    UsersModule,
    AuthModule,
    InoutsModule,
    HolidaysModule,
    RolesModule,
    FilesModule,
    NotificationsModule,
    PanelsModule,
    VacationsModule,
  ],
})
export class AppModule {}
