import { PrismaClient } from '@prisma/client';
import * as bcrypt from 'bcrypt';
import * as fs from 'fs';
import * as path from 'path';
import * as MomentJ from 'moment-jalaali';

const prisma = new PrismaClient();

async function main() {
  const saltOrRounds = 10;

  //#region role
  const Role = await prisma.role.create({
    data: {
      name: 'superman',
      description: 'access like superman',
    },
  });
  const UserRole = await prisma.role.create({
    data: {
      name: 'employee',
    },
  });
  //#endregion

  //#region permission
  const permissions = [
    //#region dashboard
    {
      key: 'dashboard',
      category: 'dashboard',
      english_name: 'dashboard',
      persian_name: 'داشبورد',
    },
    //#endregion
    //#region user
    {
      key: 'view_user',
      category: 'user',
      english_name: 'view user',
      persian_name: 'لیست کاربران',
    },
    {
      key: 'create_user',
      category: 'user',
      english_name: 'create user',
      persian_name: 'افزودن کاربران',
    },
    {
      key: 'edit_user',
      category: 'user',
      english_name: 'edit user',
      persian_name: 'ویرایش کاربران',
    },
    {
      key: 'destroy_user',
      category: 'user',
      english_name: 'destroy user',
      persian_name: 'حذف کاربران',
    },
    //#endregion
    //#region role
    {
      key: 'view_role',
      category: 'role',
      english_name: 'view role',
      persian_name: 'لیست نقش',
    },
    {
      key: 'create_role',
      category: 'role',
      english_name: 'create role',
      persian_name: 'افزودن نقش',
    },
    {
      key: 'edit_role',
      category: 'role',
      english_name: 'edit role',
      persian_name: 'ویرایش نقش',
    },
    {
      key: 'destroy_role',
      category: 'role',
      english_name: 'destroy user',
      persian_name: 'حذف نقش',
    },
    //#endregion
    //#region post
    {
      key: 'view_post',
      category: 'post',
      english_name: 'view post',
      persian_name: 'لیست پست',
    },
    {
      key: 'create_post',
      category: 'post',
      english_name: 'create post',
      persian_name: 'افزودن پست',
    },
    {
      key: 'edit_post',
      category: 'post',
      english_name: 'edit post',
      persian_name: 'ویرایش پست',
    },
    {
      key: 'destroy_post',
      category: 'post',
      english_name: 'destroy post',
      persian_name: 'حذف پست',
    },
    //#endregion
    //#region file
    {
      key: 'view_file',
      category: 'file',
      english_name: 'view file',
      persian_name: 'لیست فایل',
    },
    {
      key: 'create_file',
      category: 'file',
      english_name: 'create file',
      persian_name: 'افزودن فایل',
    },
    {
      key: 'edit_file',
      category: 'file',
      english_name: 'edit file',
      persian_name: 'ویرایش فایل',
    },
    {
      key: 'destroy_file',
      category: 'file',
      english_name: 'destroy file',
      persian_name: 'حذف فایل',
    },
    //#endregion
    //#region notification
    {
      key: 'view_notification',
      category: 'notification',
      english_name: 'view notification',
      persian_name: 'لیست اعلانات',
    },
    {
      key: 'create_notification',
      category: 'notification',
      english_name: 'create notification',
      persian_name: 'افزودن اعلانات',
    },
    {
      key: 'edit_notification',
      category: 'notification',
      english_name: 'edit notification',
      persian_name: 'ویرایش اعلانات',
    },
    {
      key: 'destroy_notification',
      category: 'notification',
      english_name: 'destroy notification',
      persian_name: 'حذف اعلانات',
    },
    //#endregion
    //#region inout
    {
      key: 'view_inout',
      category: 'inout',
      english_name: 'view inout',
      persian_name: 'لیست ورود و خروج',
    },
    {
      key: 'create_inout',
      category: 'inout',
      english_name: 'create inout',
      persian_name: 'افزودن ورود و خروج',
    },
    {
      key: 'edit_inout',
      category: 'inout',
      english_name: 'edit inout',
      persian_name: 'ویرایش ورود و خروج',
    },
    {
      key: 'destroy_inout',
      category: 'inout',
      english_name: 'destroy inout',
      persian_name: 'حذف ورود و خروج',
    },
    //#endregion
    //#region vacation
    {
      key: 'view_vacation',
      category: 'vacation',
      english_name: 'view vacation',
      persian_name: 'لیست مرخصی',
    },
    {
      key: 'create_vacation',
      category: 'vacation',
      english_name: 'create vacation',
      persian_name: 'افزودن مرخصی',
    },
    {
      key: 'edit_vacation',
      category: 'vacation',
      english_name: 'edit vacation',
      persian_name: 'ویرایش مرخصی',
    },
    {
      key: 'destroy_vacation',
      category: 'vacation',
      english_name: 'destroy vacation',
      persian_name: 'حذف مرخصی',
    },
    //#endregion
  ];

  for (const permission of permissions) {
    await prisma.permission.create({
      data: {
        key: permission.key,
        category: permission.category,
        english_name: permission.english_name,
        persian_name: permission.persian_name,
        PermissionsOnRole: {
          create: {
            role_id: Role.id,
            assignedBy: 'seeder',
          },
        },
      },
    });
  }
  //#endregion

  const Admin = await prisma.user.upsert({
    where: { email: 'sepehr.jozef@gmail.com' },
    create: {
      email: 'sepehr.jozef@gmail.com',
      password: await bcrypt.hash('Sepehr98', saltOrRounds),
      phone: '09308484482',
      role_id: Role.id,
      userDetail: {
        create: {
          first_name: 'Sepehr',
          last_name: 'Pourjozi',
          personal_code: 3043,
        },
      },
    },
    update: {},
  });

  //region نقی زاده
  await prisma.user.upsert({
    where: { email: 'h.naghizadeh@iotaci.com' },
    create: {
      email: 'h.naghizadeh@iotaci.com',
      password: await bcrypt.hash('0084163951', saltOrRounds),
      phone: '09123643959',
      role_id: UserRole.id,
      userDetail: {
        create: {
          first_name: 'حمید',
          last_name: 'نقی زاده',
          personal_code: 3008,
        },
      },
    },
    update: {},
  });
  //endregion

  //region حدادی
  await prisma.user.upsert({
    where: { email: 'a.hadadi@iotaci.com' },
    create: {
      email: 'a.hadadi@iotaci.com',
      password: await bcrypt.hash('001890901', saltOrRounds),
      phone: '09365472511',
      role_id: UserRole.id,
      userDetail: {
        create: {
          first_name: 'امیر حسین',
          last_name: 'حدادی',
          personal_code: 3007,
        },
      },
    },
    update: {},
  });
  //endregion

  //#region Holidays
  const folderPath = 'src/holidays/files';
  fs.readdirSync(folderPath);
  fs.readdirSync(folderPath).map((fileName) => {
    let holies = [];
    fs.readFile(path.join(folderPath, fileName), 'utf8', async (err, data) => {
      if (err) {
        console.error(err);
        return;
      }
      await JSON.parse(data).map((pt) => {
        const Date = MomentJ(pt, 'jYYYY/jMM/jDD').format('YYYY-MM-DD 00:00:00');
        holies.push(Date);
      });
      await prisma.holiday.createMany({
        data: holies.map((h) => {
          return {
            date: new Date(h),
          };
        }),
      });
    });
  });
  //#endregion
  console.log('DONE!');
}

main()
  .then(async () => {
    await prisma.$disconnect();
  })
  .catch(async (e) => {
    console.error(e);
    await prisma.$disconnect();
    process.exit(1);
  });
